/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// KMIPServer struct for KMIPServer
type KMIPServer struct {
	Active *bool `json:"active,omitempty"`
	Ca *[]int32 `json:"ca,omitempty"`
	Certificate *[]int32 `json:"certificate,omitempty"`
	CertificateIssueDate *time.Time `json:"certificate_issue_date,omitempty"`
	CertificateTtlInSeconds *int64 `json:"certificate_ttl_in_seconds,omitempty"`
	Hostname *string `json:"hostname,omitempty"`
	Root *string `json:"root,omitempty"`
}

// NewKMIPServer instantiates a new KMIPServer object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKMIPServer() *KMIPServer {
	this := KMIPServer{}
	return &this
}

// NewKMIPServerWithDefaults instantiates a new KMIPServer object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKMIPServerWithDefaults() *KMIPServer {
	this := KMIPServer{}
	return &this
}

// GetActive returns the Active field value if set, zero value otherwise.
func (o *KMIPServer) GetActive() bool {
	if o == nil || o.Active == nil {
		var ret bool
		return ret
	}
	return *o.Active
}

// GetActiveOk returns a tuple with the Active field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KMIPServer) GetActiveOk() (*bool, bool) {
	if o == nil || o.Active == nil {
		return nil, false
	}
	return o.Active, true
}

// HasActive returns a boolean if a field has been set.
func (o *KMIPServer) HasActive() bool {
	if o != nil && o.Active != nil {
		return true
	}

	return false
}

// SetActive gets a reference to the given bool and assigns it to the Active field.
func (o *KMIPServer) SetActive(v bool) {
	o.Active = &v
}

// GetCa returns the Ca field value if set, zero value otherwise.
func (o *KMIPServer) GetCa() []int32 {
	if o == nil || o.Ca == nil {
		var ret []int32
		return ret
	}
	return *o.Ca
}

// GetCaOk returns a tuple with the Ca field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KMIPServer) GetCaOk() (*[]int32, bool) {
	if o == nil || o.Ca == nil {
		return nil, false
	}
	return o.Ca, true
}

// HasCa returns a boolean if a field has been set.
func (o *KMIPServer) HasCa() bool {
	if o != nil && o.Ca != nil {
		return true
	}

	return false
}

// SetCa gets a reference to the given []int32 and assigns it to the Ca field.
func (o *KMIPServer) SetCa(v []int32) {
	o.Ca = &v
}

// GetCertificate returns the Certificate field value if set, zero value otherwise.
func (o *KMIPServer) GetCertificate() []int32 {
	if o == nil || o.Certificate == nil {
		var ret []int32
		return ret
	}
	return *o.Certificate
}

// GetCertificateOk returns a tuple with the Certificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KMIPServer) GetCertificateOk() (*[]int32, bool) {
	if o == nil || o.Certificate == nil {
		return nil, false
	}
	return o.Certificate, true
}

// HasCertificate returns a boolean if a field has been set.
func (o *KMIPServer) HasCertificate() bool {
	if o != nil && o.Certificate != nil {
		return true
	}

	return false
}

// SetCertificate gets a reference to the given []int32 and assigns it to the Certificate field.
func (o *KMIPServer) SetCertificate(v []int32) {
	o.Certificate = &v
}

// GetCertificateIssueDate returns the CertificateIssueDate field value if set, zero value otherwise.
func (o *KMIPServer) GetCertificateIssueDate() time.Time {
	if o == nil || o.CertificateIssueDate == nil {
		var ret time.Time
		return ret
	}
	return *o.CertificateIssueDate
}

// GetCertificateIssueDateOk returns a tuple with the CertificateIssueDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KMIPServer) GetCertificateIssueDateOk() (*time.Time, bool) {
	if o == nil || o.CertificateIssueDate == nil {
		return nil, false
	}
	return o.CertificateIssueDate, true
}

// HasCertificateIssueDate returns a boolean if a field has been set.
func (o *KMIPServer) HasCertificateIssueDate() bool {
	if o != nil && o.CertificateIssueDate != nil {
		return true
	}

	return false
}

// SetCertificateIssueDate gets a reference to the given time.Time and assigns it to the CertificateIssueDate field.
func (o *KMIPServer) SetCertificateIssueDate(v time.Time) {
	o.CertificateIssueDate = &v
}

// GetCertificateTtlInSeconds returns the CertificateTtlInSeconds field value if set, zero value otherwise.
func (o *KMIPServer) GetCertificateTtlInSeconds() int64 {
	if o == nil || o.CertificateTtlInSeconds == nil {
		var ret int64
		return ret
	}
	return *o.CertificateTtlInSeconds
}

// GetCertificateTtlInSecondsOk returns a tuple with the CertificateTtlInSeconds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KMIPServer) GetCertificateTtlInSecondsOk() (*int64, bool) {
	if o == nil || o.CertificateTtlInSeconds == nil {
		return nil, false
	}
	return o.CertificateTtlInSeconds, true
}

// HasCertificateTtlInSeconds returns a boolean if a field has been set.
func (o *KMIPServer) HasCertificateTtlInSeconds() bool {
	if o != nil && o.CertificateTtlInSeconds != nil {
		return true
	}

	return false
}

// SetCertificateTtlInSeconds gets a reference to the given int64 and assigns it to the CertificateTtlInSeconds field.
func (o *KMIPServer) SetCertificateTtlInSeconds(v int64) {
	o.CertificateTtlInSeconds = &v
}

// GetHostname returns the Hostname field value if set, zero value otherwise.
func (o *KMIPServer) GetHostname() string {
	if o == nil || o.Hostname == nil {
		var ret string
		return ret
	}
	return *o.Hostname
}

// GetHostnameOk returns a tuple with the Hostname field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KMIPServer) GetHostnameOk() (*string, bool) {
	if o == nil || o.Hostname == nil {
		return nil, false
	}
	return o.Hostname, true
}

// HasHostname returns a boolean if a field has been set.
func (o *KMIPServer) HasHostname() bool {
	if o != nil && o.Hostname != nil {
		return true
	}

	return false
}

// SetHostname gets a reference to the given string and assigns it to the Hostname field.
func (o *KMIPServer) SetHostname(v string) {
	o.Hostname = &v
}

// GetRoot returns the Root field value if set, zero value otherwise.
func (o *KMIPServer) GetRoot() string {
	if o == nil || o.Root == nil {
		var ret string
		return ret
	}
	return *o.Root
}

// GetRootOk returns a tuple with the Root field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KMIPServer) GetRootOk() (*string, bool) {
	if o == nil || o.Root == nil {
		return nil, false
	}
	return o.Root, true
}

// HasRoot returns a boolean if a field has been set.
func (o *KMIPServer) HasRoot() bool {
	if o != nil && o.Root != nil {
		return true
	}

	return false
}

// SetRoot gets a reference to the given string and assigns it to the Root field.
func (o *KMIPServer) SetRoot(v string) {
	o.Root = &v
}

func (o KMIPServer) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Active != nil {
		toSerialize["active"] = o.Active
	}
	if o.Ca != nil {
		toSerialize["ca"] = o.Ca
	}
	if o.Certificate != nil {
		toSerialize["certificate"] = o.Certificate
	}
	if o.CertificateIssueDate != nil {
		toSerialize["certificate_issue_date"] = o.CertificateIssueDate
	}
	if o.CertificateTtlInSeconds != nil {
		toSerialize["certificate_ttl_in_seconds"] = o.CertificateTtlInSeconds
	}
	if o.Hostname != nil {
		toSerialize["hostname"] = o.Hostname
	}
	if o.Root != nil {
		toSerialize["root"] = o.Root
	}
	return json.Marshal(toSerialize)
}

type NullableKMIPServer struct {
	value *KMIPServer
	isSet bool
}

func (v NullableKMIPServer) Get() *KMIPServer {
	return v.value
}

func (v *NullableKMIPServer) Set(val *KMIPServer) {
	v.value = val
	v.isSet = true
}

func (v NullableKMIPServer) IsSet() bool {
	return v.isSet
}

func (v *NullableKMIPServer) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKMIPServer(val *KMIPServer) *NullableKMIPServer {
	return &NullableKMIPServer{value: val, isSet: true}
}

func (v NullableKMIPServer) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKMIPServer) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


