/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GwUpdateRemoteAccessSessionLogsSumologic gwUpdateRemoteAccessSessionLogsSumologic is a command that updates session log forwarding config (sumologic target)
type GwUpdateRemoteAccessSessionLogsSumologic struct {
	// Enable Log Forwarding [true/false]
	Enable *string `json:"enable,omitempty"`
	// Sumologic endpoint URL
	Endpoint *string `json:"endpoint,omitempty"`
	// Sumologic host
	Host *string `json:"host,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Logs format [text/json]
	OutputFormat *string `json:"output-format,omitempty"`
	// Pull interval in seconds
	PullInterval *string `json:"pull-interval,omitempty"`
	// A comma-separated list of Sumologic tags
	SumologicTags *string `json:"sumologic-tags,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGwUpdateRemoteAccessSessionLogsSumologic instantiates a new GwUpdateRemoteAccessSessionLogsSumologic object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGwUpdateRemoteAccessSessionLogsSumologic() *GwUpdateRemoteAccessSessionLogsSumologic {
	this := GwUpdateRemoteAccessSessionLogsSumologic{}
	var enable string = "true"
	this.Enable = &enable
	var host string = "use-existing"
	this.Host = &host
	var json bool = false
	this.Json = &json
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	var sumologicTags string = "use-existing"
	this.SumologicTags = &sumologicTags
	return &this
}

// NewGwUpdateRemoteAccessSessionLogsSumologicWithDefaults instantiates a new GwUpdateRemoteAccessSessionLogsSumologic object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGwUpdateRemoteAccessSessionLogsSumologicWithDefaults() *GwUpdateRemoteAccessSessionLogsSumologic {
	this := GwUpdateRemoteAccessSessionLogsSumologic{}
	var enable string = "true"
	this.Enable = &enable
	var host string = "use-existing"
	this.Host = &host
	var json bool = false
	this.Json = &json
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	var sumologicTags string = "use-existing"
	this.SumologicTags = &sumologicTags
	return &this
}

// GetEnable returns the Enable field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetEnable() string {
	if o == nil || o.Enable == nil {
		var ret string
		return ret
	}
	return *o.Enable
}

// GetEnableOk returns a tuple with the Enable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetEnableOk() (*string, bool) {
	if o == nil || o.Enable == nil {
		return nil, false
	}
	return o.Enable, true
}

// HasEnable returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) HasEnable() bool {
	if o != nil && o.Enable != nil {
		return true
	}

	return false
}

// SetEnable gets a reference to the given string and assigns it to the Enable field.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) SetEnable(v string) {
	o.Enable = &v
}

// GetEndpoint returns the Endpoint field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetEndpoint() string {
	if o == nil || o.Endpoint == nil {
		var ret string
		return ret
	}
	return *o.Endpoint
}

// GetEndpointOk returns a tuple with the Endpoint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetEndpointOk() (*string, bool) {
	if o == nil || o.Endpoint == nil {
		return nil, false
	}
	return o.Endpoint, true
}

// HasEndpoint returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) HasEndpoint() bool {
	if o != nil && o.Endpoint != nil {
		return true
	}

	return false
}

// SetEndpoint gets a reference to the given string and assigns it to the Endpoint field.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) SetEndpoint(v string) {
	o.Endpoint = &v
}

// GetHost returns the Host field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetHost() string {
	if o == nil || o.Host == nil {
		var ret string
		return ret
	}
	return *o.Host
}

// GetHostOk returns a tuple with the Host field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetHostOk() (*string, bool) {
	if o == nil || o.Host == nil {
		return nil, false
	}
	return o.Host, true
}

// HasHost returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) HasHost() bool {
	if o != nil && o.Host != nil {
		return true
	}

	return false
}

// SetHost gets a reference to the given string and assigns it to the Host field.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) SetHost(v string) {
	o.Host = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) SetJson(v bool) {
	o.Json = &v
}

// GetOutputFormat returns the OutputFormat field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetOutputFormat() string {
	if o == nil || o.OutputFormat == nil {
		var ret string
		return ret
	}
	return *o.OutputFormat
}

// GetOutputFormatOk returns a tuple with the OutputFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetOutputFormatOk() (*string, bool) {
	if o == nil || o.OutputFormat == nil {
		return nil, false
	}
	return o.OutputFormat, true
}

// HasOutputFormat returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) HasOutputFormat() bool {
	if o != nil && o.OutputFormat != nil {
		return true
	}

	return false
}

// SetOutputFormat gets a reference to the given string and assigns it to the OutputFormat field.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) SetOutputFormat(v string) {
	o.OutputFormat = &v
}

// GetPullInterval returns the PullInterval field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetPullInterval() string {
	if o == nil || o.PullInterval == nil {
		var ret string
		return ret
	}
	return *o.PullInterval
}

// GetPullIntervalOk returns a tuple with the PullInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetPullIntervalOk() (*string, bool) {
	if o == nil || o.PullInterval == nil {
		return nil, false
	}
	return o.PullInterval, true
}

// HasPullInterval returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) HasPullInterval() bool {
	if o != nil && o.PullInterval != nil {
		return true
	}

	return false
}

// SetPullInterval gets a reference to the given string and assigns it to the PullInterval field.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) SetPullInterval(v string) {
	o.PullInterval = &v
}

// GetSumologicTags returns the SumologicTags field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetSumologicTags() string {
	if o == nil || o.SumologicTags == nil {
		var ret string
		return ret
	}
	return *o.SumologicTags
}

// GetSumologicTagsOk returns a tuple with the SumologicTags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetSumologicTagsOk() (*string, bool) {
	if o == nil || o.SumologicTags == nil {
		return nil, false
	}
	return o.SumologicTags, true
}

// HasSumologicTags returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) HasSumologicTags() bool {
	if o != nil && o.SumologicTags != nil {
		return true
	}

	return false
}

// SetSumologicTags gets a reference to the given string and assigns it to the SumologicTags field.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) SetSumologicTags(v string) {
	o.SumologicTags = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GwUpdateRemoteAccessSessionLogsSumologic) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GwUpdateRemoteAccessSessionLogsSumologic) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Enable != nil {
		toSerialize["enable"] = o.Enable
	}
	if o.Endpoint != nil {
		toSerialize["endpoint"] = o.Endpoint
	}
	if o.Host != nil {
		toSerialize["host"] = o.Host
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.OutputFormat != nil {
		toSerialize["output-format"] = o.OutputFormat
	}
	if o.PullInterval != nil {
		toSerialize["pull-interval"] = o.PullInterval
	}
	if o.SumologicTags != nil {
		toSerialize["sumologic-tags"] = o.SumologicTags
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGwUpdateRemoteAccessSessionLogsSumologic struct {
	value *GwUpdateRemoteAccessSessionLogsSumologic
	isSet bool
}

func (v NullableGwUpdateRemoteAccessSessionLogsSumologic) Get() *GwUpdateRemoteAccessSessionLogsSumologic {
	return v.value
}

func (v *NullableGwUpdateRemoteAccessSessionLogsSumologic) Set(val *GwUpdateRemoteAccessSessionLogsSumologic) {
	v.value = val
	v.isSet = true
}

func (v NullableGwUpdateRemoteAccessSessionLogsSumologic) IsSet() bool {
	return v.isSet
}

func (v *NullableGwUpdateRemoteAccessSessionLogsSumologic) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGwUpdateRemoteAccessSessionLogsSumologic(val *GwUpdateRemoteAccessSessionLogsSumologic) *NullableGwUpdateRemoteAccessSessionLogsSumologic {
	return &NullableGwUpdateRemoteAccessSessionLogsSumologic{value: val, isSet: true}
}

func (v NullableGwUpdateRemoteAccessSessionLogsSumologic) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGwUpdateRemoteAccessSessionLogsSumologic) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


