/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GlobalSignGCCTargetDetails GlobalSignGCCTargetDetails
type GlobalSignGCCTargetDetails struct {
	Email *string `json:"email,omitempty"`
	// Contact Info - GlobalSign requires this to be sent with every certificate creation request
	FirstName *string `json:"first_name,omitempty"`
	LastName *string `json:"last_name,omitempty"`
	Password *string `json:"password,omitempty"`
	Phone *string `json:"phone,omitempty"`
	ProfileId *string `json:"profile_id,omitempty"`
	// A Duration represents the elapsed time between two instants as an int64 nanosecond count. The representation limits the largest representable duration to approximately 290 years.
	Timeout *int64 `json:"timeout,omitempty"`
	Username *string `json:"username,omitempty"`
}

// NewGlobalSignGCCTargetDetails instantiates a new GlobalSignGCCTargetDetails object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGlobalSignGCCTargetDetails() *GlobalSignGCCTargetDetails {
	this := GlobalSignGCCTargetDetails{}
	return &this
}

// NewGlobalSignGCCTargetDetailsWithDefaults instantiates a new GlobalSignGCCTargetDetails object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGlobalSignGCCTargetDetailsWithDefaults() *GlobalSignGCCTargetDetails {
	this := GlobalSignGCCTargetDetails{}
	return &this
}

// GetEmail returns the Email field value if set, zero value otherwise.
func (o *GlobalSignGCCTargetDetails) GetEmail() string {
	if o == nil || o.Email == nil {
		var ret string
		return ret
	}
	return *o.Email
}

// GetEmailOk returns a tuple with the Email field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GlobalSignGCCTargetDetails) GetEmailOk() (*string, bool) {
	if o == nil || o.Email == nil {
		return nil, false
	}
	return o.Email, true
}

// HasEmail returns a boolean if a field has been set.
func (o *GlobalSignGCCTargetDetails) HasEmail() bool {
	if o != nil && o.Email != nil {
		return true
	}

	return false
}

// SetEmail gets a reference to the given string and assigns it to the Email field.
func (o *GlobalSignGCCTargetDetails) SetEmail(v string) {
	o.Email = &v
}

// GetFirstName returns the FirstName field value if set, zero value otherwise.
func (o *GlobalSignGCCTargetDetails) GetFirstName() string {
	if o == nil || o.FirstName == nil {
		var ret string
		return ret
	}
	return *o.FirstName
}

// GetFirstNameOk returns a tuple with the FirstName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GlobalSignGCCTargetDetails) GetFirstNameOk() (*string, bool) {
	if o == nil || o.FirstName == nil {
		return nil, false
	}
	return o.FirstName, true
}

// HasFirstName returns a boolean if a field has been set.
func (o *GlobalSignGCCTargetDetails) HasFirstName() bool {
	if o != nil && o.FirstName != nil {
		return true
	}

	return false
}

// SetFirstName gets a reference to the given string and assigns it to the FirstName field.
func (o *GlobalSignGCCTargetDetails) SetFirstName(v string) {
	o.FirstName = &v
}

// GetLastName returns the LastName field value if set, zero value otherwise.
func (o *GlobalSignGCCTargetDetails) GetLastName() string {
	if o == nil || o.LastName == nil {
		var ret string
		return ret
	}
	return *o.LastName
}

// GetLastNameOk returns a tuple with the LastName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GlobalSignGCCTargetDetails) GetLastNameOk() (*string, bool) {
	if o == nil || o.LastName == nil {
		return nil, false
	}
	return o.LastName, true
}

// HasLastName returns a boolean if a field has been set.
func (o *GlobalSignGCCTargetDetails) HasLastName() bool {
	if o != nil && o.LastName != nil {
		return true
	}

	return false
}

// SetLastName gets a reference to the given string and assigns it to the LastName field.
func (o *GlobalSignGCCTargetDetails) SetLastName(v string) {
	o.LastName = &v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *GlobalSignGCCTargetDetails) GetPassword() string {
	if o == nil || o.Password == nil {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GlobalSignGCCTargetDetails) GetPasswordOk() (*string, bool) {
	if o == nil || o.Password == nil {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *GlobalSignGCCTargetDetails) HasPassword() bool {
	if o != nil && o.Password != nil {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *GlobalSignGCCTargetDetails) SetPassword(v string) {
	o.Password = &v
}

// GetPhone returns the Phone field value if set, zero value otherwise.
func (o *GlobalSignGCCTargetDetails) GetPhone() string {
	if o == nil || o.Phone == nil {
		var ret string
		return ret
	}
	return *o.Phone
}

// GetPhoneOk returns a tuple with the Phone field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GlobalSignGCCTargetDetails) GetPhoneOk() (*string, bool) {
	if o == nil || o.Phone == nil {
		return nil, false
	}
	return o.Phone, true
}

// HasPhone returns a boolean if a field has been set.
func (o *GlobalSignGCCTargetDetails) HasPhone() bool {
	if o != nil && o.Phone != nil {
		return true
	}

	return false
}

// SetPhone gets a reference to the given string and assigns it to the Phone field.
func (o *GlobalSignGCCTargetDetails) SetPhone(v string) {
	o.Phone = &v
}

// GetProfileId returns the ProfileId field value if set, zero value otherwise.
func (o *GlobalSignGCCTargetDetails) GetProfileId() string {
	if o == nil || o.ProfileId == nil {
		var ret string
		return ret
	}
	return *o.ProfileId
}

// GetProfileIdOk returns a tuple with the ProfileId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GlobalSignGCCTargetDetails) GetProfileIdOk() (*string, bool) {
	if o == nil || o.ProfileId == nil {
		return nil, false
	}
	return o.ProfileId, true
}

// HasProfileId returns a boolean if a field has been set.
func (o *GlobalSignGCCTargetDetails) HasProfileId() bool {
	if o != nil && o.ProfileId != nil {
		return true
	}

	return false
}

// SetProfileId gets a reference to the given string and assigns it to the ProfileId field.
func (o *GlobalSignGCCTargetDetails) SetProfileId(v string) {
	o.ProfileId = &v
}

// GetTimeout returns the Timeout field value if set, zero value otherwise.
func (o *GlobalSignGCCTargetDetails) GetTimeout() int64 {
	if o == nil || o.Timeout == nil {
		var ret int64
		return ret
	}
	return *o.Timeout
}

// GetTimeoutOk returns a tuple with the Timeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GlobalSignGCCTargetDetails) GetTimeoutOk() (*int64, bool) {
	if o == nil || o.Timeout == nil {
		return nil, false
	}
	return o.Timeout, true
}

// HasTimeout returns a boolean if a field has been set.
func (o *GlobalSignGCCTargetDetails) HasTimeout() bool {
	if o != nil && o.Timeout != nil {
		return true
	}

	return false
}

// SetTimeout gets a reference to the given int64 and assigns it to the Timeout field.
func (o *GlobalSignGCCTargetDetails) SetTimeout(v int64) {
	o.Timeout = &v
}

// GetUsername returns the Username field value if set, zero value otherwise.
func (o *GlobalSignGCCTargetDetails) GetUsername() string {
	if o == nil || o.Username == nil {
		var ret string
		return ret
	}
	return *o.Username
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GlobalSignGCCTargetDetails) GetUsernameOk() (*string, bool) {
	if o == nil || o.Username == nil {
		return nil, false
	}
	return o.Username, true
}

// HasUsername returns a boolean if a field has been set.
func (o *GlobalSignGCCTargetDetails) HasUsername() bool {
	if o != nil && o.Username != nil {
		return true
	}

	return false
}

// SetUsername gets a reference to the given string and assigns it to the Username field.
func (o *GlobalSignGCCTargetDetails) SetUsername(v string) {
	o.Username = &v
}

func (o GlobalSignGCCTargetDetails) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Email != nil {
		toSerialize["email"] = o.Email
	}
	if o.FirstName != nil {
		toSerialize["first_name"] = o.FirstName
	}
	if o.LastName != nil {
		toSerialize["last_name"] = o.LastName
	}
	if o.Password != nil {
		toSerialize["password"] = o.Password
	}
	if o.Phone != nil {
		toSerialize["phone"] = o.Phone
	}
	if o.ProfileId != nil {
		toSerialize["profile_id"] = o.ProfileId
	}
	if o.Timeout != nil {
		toSerialize["timeout"] = o.Timeout
	}
	if o.Username != nil {
		toSerialize["username"] = o.Username
	}
	return json.Marshal(toSerialize)
}

type NullableGlobalSignGCCTargetDetails struct {
	value *GlobalSignGCCTargetDetails
	isSet bool
}

func (v NullableGlobalSignGCCTargetDetails) Get() *GlobalSignGCCTargetDetails {
	return v.value
}

func (v *NullableGlobalSignGCCTargetDetails) Set(val *GlobalSignGCCTargetDetails) {
	v.value = val
	v.isSet = true
}

func (v NullableGlobalSignGCCTargetDetails) IsSet() bool {
	return v.isSet
}

func (v *NullableGlobalSignGCCTargetDetails) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGlobalSignGCCTargetDetails(val *GlobalSignGCCTargetDetails) *NullableGlobalSignGCCTargetDetails {
	return &NullableGlobalSignGCCTargetDetails{value: val, isSet: true}
}

func (v NullableGlobalSignGCCTargetDetails) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGlobalSignGCCTargetDetails) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


