/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GenCustomerFragment struct for GenCustomerFragment
type GenCustomerFragment struct {
	// Description of the object
	Description *string `json:"description,omitempty"`
	// The label of the hsm key to use for customer fragment operations (relevant for hsm_wrapped/hsm_protected customer fragments)
	HsmKeyLabel *string `json:"hsm-key-label,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Deprecated - use description
	Metadata *string `json:"metadata,omitempty"`
	// Customer fragment name
	Name *string `json:"name,omitempty"`
	// Customer fragment type [standard/hsm_wrapped/hsm_secured]
	Type *string `json:"type,omitempty"`
}

// NewGenCustomerFragment instantiates a new GenCustomerFragment object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGenCustomerFragment() *GenCustomerFragment {
	this := GenCustomerFragment{}
	var json bool = false
	this.Json = &json
	var type_ string = "standard"
	this.Type = &type_
	return &this
}

// NewGenCustomerFragmentWithDefaults instantiates a new GenCustomerFragment object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGenCustomerFragmentWithDefaults() *GenCustomerFragment {
	this := GenCustomerFragment{}
	var json bool = false
	this.Json = &json
	var type_ string = "standard"
	this.Type = &type_
	return &this
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *GenCustomerFragment) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenCustomerFragment) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *GenCustomerFragment) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *GenCustomerFragment) SetDescription(v string) {
	o.Description = &v
}

// GetHsmKeyLabel returns the HsmKeyLabel field value if set, zero value otherwise.
func (o *GenCustomerFragment) GetHsmKeyLabel() string {
	if o == nil || o.HsmKeyLabel == nil {
		var ret string
		return ret
	}
	return *o.HsmKeyLabel
}

// GetHsmKeyLabelOk returns a tuple with the HsmKeyLabel field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenCustomerFragment) GetHsmKeyLabelOk() (*string, bool) {
	if o == nil || o.HsmKeyLabel == nil {
		return nil, false
	}
	return o.HsmKeyLabel, true
}

// HasHsmKeyLabel returns a boolean if a field has been set.
func (o *GenCustomerFragment) HasHsmKeyLabel() bool {
	if o != nil && o.HsmKeyLabel != nil {
		return true
	}

	return false
}

// SetHsmKeyLabel gets a reference to the given string and assigns it to the HsmKeyLabel field.
func (o *GenCustomerFragment) SetHsmKeyLabel(v string) {
	o.HsmKeyLabel = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GenCustomerFragment) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenCustomerFragment) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GenCustomerFragment) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GenCustomerFragment) SetJson(v bool) {
	o.Json = &v
}

// GetMetadata returns the Metadata field value if set, zero value otherwise.
func (o *GenCustomerFragment) GetMetadata() string {
	if o == nil || o.Metadata == nil {
		var ret string
		return ret
	}
	return *o.Metadata
}

// GetMetadataOk returns a tuple with the Metadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenCustomerFragment) GetMetadataOk() (*string, bool) {
	if o == nil || o.Metadata == nil {
		return nil, false
	}
	return o.Metadata, true
}

// HasMetadata returns a boolean if a field has been set.
func (o *GenCustomerFragment) HasMetadata() bool {
	if o != nil && o.Metadata != nil {
		return true
	}

	return false
}

// SetMetadata gets a reference to the given string and assigns it to the Metadata field.
func (o *GenCustomerFragment) SetMetadata(v string) {
	o.Metadata = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *GenCustomerFragment) GetName() string {
	if o == nil || o.Name == nil {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenCustomerFragment) GetNameOk() (*string, bool) {
	if o == nil || o.Name == nil {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *GenCustomerFragment) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *GenCustomerFragment) SetName(v string) {
	o.Name = &v
}

// GetType returns the Type field value if set, zero value otherwise.
func (o *GenCustomerFragment) GetType() string {
	if o == nil || o.Type == nil {
		var ret string
		return ret
	}
	return *o.Type
}

// GetTypeOk returns a tuple with the Type field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenCustomerFragment) GetTypeOk() (*string, bool) {
	if o == nil || o.Type == nil {
		return nil, false
	}
	return o.Type, true
}

// HasType returns a boolean if a field has been set.
func (o *GenCustomerFragment) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

// SetType gets a reference to the given string and assigns it to the Type field.
func (o *GenCustomerFragment) SetType(v string) {
	o.Type = &v
}

func (o GenCustomerFragment) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.HsmKeyLabel != nil {
		toSerialize["hsm-key-label"] = o.HsmKeyLabel
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Metadata != nil {
		toSerialize["metadata"] = o.Metadata
	}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	if o.Type != nil {
		toSerialize["type"] = o.Type
	}
	return json.Marshal(toSerialize)
}

type NullableGenCustomerFragment struct {
	value *GenCustomerFragment
	isSet bool
}

func (v NullableGenCustomerFragment) Get() *GenCustomerFragment {
	return v.value
}

func (v *NullableGenCustomerFragment) Set(val *GenCustomerFragment) {
	v.value = val
	v.isSet = true
}

func (v NullableGenCustomerFragment) IsSet() bool {
	return v.isSet
}

func (v *NullableGenCustomerFragment) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGenCustomerFragment(val *GenCustomerFragment) *NullableGenCustomerFragment {
	return &NullableGenCustomerFragment{value: val, isSet: true}
}

func (v NullableGenCustomerFragment) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGenCustomerFragment) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


