/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// EsmCreate esmCreate is a command that creates a new secret in an External Secrets Manager
type EsmCreate struct {
	// Use this option if the external secret value is a base64 encoded binary
	BinaryValue *bool `json:"binary-value,omitempty"`
	// Description of the external secret
	Description *string `json:"description,omitempty"`
	// Name of the External Secrets Manager item
	EsmName string `json:"esm-name"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Name for the new external secret
	SecretName string `json:"secret-name"`
	// Tags for the external secret
	Tags *map[string]string `json:"tags,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Value of the external secret item, either text or base64 encoded binary
	Value string `json:"value"`
}

// NewEsmCreate instantiates a new EsmCreate object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEsmCreate(esmName string, secretName string, value string, ) *EsmCreate {
	this := EsmCreate{}
	this.EsmName = esmName
	var json bool = false
	this.Json = &json
	this.SecretName = secretName
	this.Value = value
	return &this
}

// NewEsmCreateWithDefaults instantiates a new EsmCreate object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEsmCreateWithDefaults() *EsmCreate {
	this := EsmCreate{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetBinaryValue returns the BinaryValue field value if set, zero value otherwise.
func (o *EsmCreate) GetBinaryValue() bool {
	if o == nil || o.BinaryValue == nil {
		var ret bool
		return ret
	}
	return *o.BinaryValue
}

// GetBinaryValueOk returns a tuple with the BinaryValue field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmCreate) GetBinaryValueOk() (*bool, bool) {
	if o == nil || o.BinaryValue == nil {
		return nil, false
	}
	return o.BinaryValue, true
}

// HasBinaryValue returns a boolean if a field has been set.
func (o *EsmCreate) HasBinaryValue() bool {
	if o != nil && o.BinaryValue != nil {
		return true
	}

	return false
}

// SetBinaryValue gets a reference to the given bool and assigns it to the BinaryValue field.
func (o *EsmCreate) SetBinaryValue(v bool) {
	o.BinaryValue = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *EsmCreate) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmCreate) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *EsmCreate) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *EsmCreate) SetDescription(v string) {
	o.Description = &v
}

// GetEsmName returns the EsmName field value
func (o *EsmCreate) GetEsmName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EsmName
}

// GetEsmNameOk returns a tuple with the EsmName field value
// and a boolean to check if the value has been set.
func (o *EsmCreate) GetEsmNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EsmName, true
}

// SetEsmName sets field value
func (o *EsmCreate) SetEsmName(v string) {
	o.EsmName = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *EsmCreate) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmCreate) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *EsmCreate) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *EsmCreate) SetJson(v bool) {
	o.Json = &v
}

// GetSecretName returns the SecretName field value
func (o *EsmCreate) GetSecretName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.SecretName
}

// GetSecretNameOk returns a tuple with the SecretName field value
// and a boolean to check if the value has been set.
func (o *EsmCreate) GetSecretNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.SecretName, true
}

// SetSecretName sets field value
func (o *EsmCreate) SetSecretName(v string) {
	o.SecretName = v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *EsmCreate) GetTags() map[string]string {
	if o == nil || o.Tags == nil {
		var ret map[string]string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmCreate) GetTagsOk() (*map[string]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *EsmCreate) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given map[string]string and assigns it to the Tags field.
func (o *EsmCreate) SetTags(v map[string]string) {
	o.Tags = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *EsmCreate) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmCreate) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *EsmCreate) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *EsmCreate) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *EsmCreate) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmCreate) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *EsmCreate) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *EsmCreate) SetUidToken(v string) {
	o.UidToken = &v
}

// GetValue returns the Value field value
func (o *EsmCreate) GetValue() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Value
}

// GetValueOk returns a tuple with the Value field value
// and a boolean to check if the value has been set.
func (o *EsmCreate) GetValueOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Value, true
}

// SetValue sets field value
func (o *EsmCreate) SetValue(v string) {
	o.Value = v
}

func (o EsmCreate) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.BinaryValue != nil {
		toSerialize["binary-value"] = o.BinaryValue
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if true {
		toSerialize["esm-name"] = o.EsmName
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["secret-name"] = o.SecretName
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if true {
		toSerialize["value"] = o.Value
	}
	return json.Marshal(toSerialize)
}

type NullableEsmCreate struct {
	value *EsmCreate
	isSet bool
}

func (v NullableEsmCreate) Get() *EsmCreate {
	return v.value
}

func (v *NullableEsmCreate) Set(val *EsmCreate) {
	v.value = val
	v.isSet = true
}

func (v NullableEsmCreate) IsSet() bool {
	return v.isSet
}

func (v *NullableEsmCreate) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEsmCreate(val *EsmCreate) *NullableEsmCreate {
	return &NullableEsmCreate{value: val, isSet: true}
}

func (v NullableEsmCreate) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEsmCreate) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


