/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DynamicSecretUpdateHanaDb dynamicSecretUpdateHanaDb is a command that updates hanadb dynamic secret
type DynamicSecretUpdateHanaDb struct {
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// HanaDb Name
	HanaDbname *string `json:"hana-dbname,omitempty"`
	// HanaDb Creation statements
	HanadbCreateStatements *string `json:"hanadb-create-statements,omitempty"`
	// HanaDb Host
	HanadbHost *string `json:"hanadb-host,omitempty"`
	// HanaDb Password
	HanadbPassword *string `json:"hanadb-password,omitempty"`
	// HanaDb Port
	HanadbPort *string `json:"hanadb-port,omitempty"`
	// HanaDb Revocation statements
	HanadbRevocationStatements *string `json:"hanadb-revocation-statements,omitempty"`
	// HanaDb Username
	HanadbUsername *string `json:"hanadb-username,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// Dynamic secret name
	NewName *string `json:"new-name,omitempty"`
	// The length of the password to be generated
	PasswordLength *string `json:"password-length,omitempty"`
	// Dynamic producer encryption key
	ProducerEncryptionKeyName *string `json:"producer-encryption-key-name,omitempty"`
	// Path to the SSH Certificate Issuer for your Akeyless Bastion
	SecureAccessBastionIssuer *string `json:"secure-access-bastion-issuer,omitempty"`
	// The DB schema
	SecureAccessDbSchema *string `json:"secure-access-db-schema,omitempty"`
	// Enable/Disable secure remote access [true/false]
	SecureAccessEnable *string `json:"secure-access-enable,omitempty"`
	// Target DB servers for connections (In case of Linked Target association, host(s) will inherit Linked Target hosts)
	SecureAccessHost *[]string `json:"secure-access-host,omitempty"`
	// Enable Web Secure Remote Access
	SecureAccessWeb *bool `json:"secure-access-web,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Target name
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// User TTL
	UserTtl *string `json:"user-ttl,omitempty"`
}

// NewDynamicSecretUpdateHanaDb instantiates a new DynamicSecretUpdateHanaDb object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDynamicSecretUpdateHanaDb(name string, ) *DynamicSecretUpdateHanaDb {
	this := DynamicSecretUpdateHanaDb{}
	var hanadbHost string = "127.0.0.1"
	this.HanadbHost = &hanadbHost
	var hanadbPort string = "443"
	this.HanadbPort = &hanadbPort
	var json bool = false
	this.Json = &json
	this.Name = name
	var secureAccessWeb bool = false
	this.SecureAccessWeb = &secureAccessWeb
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// NewDynamicSecretUpdateHanaDbWithDefaults instantiates a new DynamicSecretUpdateHanaDb object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDynamicSecretUpdateHanaDbWithDefaults() *DynamicSecretUpdateHanaDb {
	this := DynamicSecretUpdateHanaDb{}
	var hanadbHost string = "127.0.0.1"
	this.HanadbHost = &hanadbHost
	var hanadbPort string = "443"
	this.HanadbPort = &hanadbPort
	var json bool = false
	this.Json = &json
	var secureAccessWeb bool = false
	this.SecureAccessWeb = &secureAccessWeb
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *DynamicSecretUpdateHanaDb) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *DynamicSecretUpdateHanaDb) SetDescription(v string) {
	o.Description = &v
}

// GetHanaDbname returns the HanaDbname field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetHanaDbname() string {
	if o == nil || o.HanaDbname == nil {
		var ret string
		return ret
	}
	return *o.HanaDbname
}

// GetHanaDbnameOk returns a tuple with the HanaDbname field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetHanaDbnameOk() (*string, bool) {
	if o == nil || o.HanaDbname == nil {
		return nil, false
	}
	return o.HanaDbname, true
}

// HasHanaDbname returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasHanaDbname() bool {
	if o != nil && o.HanaDbname != nil {
		return true
	}

	return false
}

// SetHanaDbname gets a reference to the given string and assigns it to the HanaDbname field.
func (o *DynamicSecretUpdateHanaDb) SetHanaDbname(v string) {
	o.HanaDbname = &v
}

// GetHanadbCreateStatements returns the HanadbCreateStatements field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetHanadbCreateStatements() string {
	if o == nil || o.HanadbCreateStatements == nil {
		var ret string
		return ret
	}
	return *o.HanadbCreateStatements
}

// GetHanadbCreateStatementsOk returns a tuple with the HanadbCreateStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetHanadbCreateStatementsOk() (*string, bool) {
	if o == nil || o.HanadbCreateStatements == nil {
		return nil, false
	}
	return o.HanadbCreateStatements, true
}

// HasHanadbCreateStatements returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasHanadbCreateStatements() bool {
	if o != nil && o.HanadbCreateStatements != nil {
		return true
	}

	return false
}

// SetHanadbCreateStatements gets a reference to the given string and assigns it to the HanadbCreateStatements field.
func (o *DynamicSecretUpdateHanaDb) SetHanadbCreateStatements(v string) {
	o.HanadbCreateStatements = &v
}

// GetHanadbHost returns the HanadbHost field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetHanadbHost() string {
	if o == nil || o.HanadbHost == nil {
		var ret string
		return ret
	}
	return *o.HanadbHost
}

// GetHanadbHostOk returns a tuple with the HanadbHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetHanadbHostOk() (*string, bool) {
	if o == nil || o.HanadbHost == nil {
		return nil, false
	}
	return o.HanadbHost, true
}

// HasHanadbHost returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasHanadbHost() bool {
	if o != nil && o.HanadbHost != nil {
		return true
	}

	return false
}

// SetHanadbHost gets a reference to the given string and assigns it to the HanadbHost field.
func (o *DynamicSecretUpdateHanaDb) SetHanadbHost(v string) {
	o.HanadbHost = &v
}

// GetHanadbPassword returns the HanadbPassword field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetHanadbPassword() string {
	if o == nil || o.HanadbPassword == nil {
		var ret string
		return ret
	}
	return *o.HanadbPassword
}

// GetHanadbPasswordOk returns a tuple with the HanadbPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetHanadbPasswordOk() (*string, bool) {
	if o == nil || o.HanadbPassword == nil {
		return nil, false
	}
	return o.HanadbPassword, true
}

// HasHanadbPassword returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasHanadbPassword() bool {
	if o != nil && o.HanadbPassword != nil {
		return true
	}

	return false
}

// SetHanadbPassword gets a reference to the given string and assigns it to the HanadbPassword field.
func (o *DynamicSecretUpdateHanaDb) SetHanadbPassword(v string) {
	o.HanadbPassword = &v
}

// GetHanadbPort returns the HanadbPort field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetHanadbPort() string {
	if o == nil || o.HanadbPort == nil {
		var ret string
		return ret
	}
	return *o.HanadbPort
}

// GetHanadbPortOk returns a tuple with the HanadbPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetHanadbPortOk() (*string, bool) {
	if o == nil || o.HanadbPort == nil {
		return nil, false
	}
	return o.HanadbPort, true
}

// HasHanadbPort returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasHanadbPort() bool {
	if o != nil && o.HanadbPort != nil {
		return true
	}

	return false
}

// SetHanadbPort gets a reference to the given string and assigns it to the HanadbPort field.
func (o *DynamicSecretUpdateHanaDb) SetHanadbPort(v string) {
	o.HanadbPort = &v
}

// GetHanadbRevocationStatements returns the HanadbRevocationStatements field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetHanadbRevocationStatements() string {
	if o == nil || o.HanadbRevocationStatements == nil {
		var ret string
		return ret
	}
	return *o.HanadbRevocationStatements
}

// GetHanadbRevocationStatementsOk returns a tuple with the HanadbRevocationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetHanadbRevocationStatementsOk() (*string, bool) {
	if o == nil || o.HanadbRevocationStatements == nil {
		return nil, false
	}
	return o.HanadbRevocationStatements, true
}

// HasHanadbRevocationStatements returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasHanadbRevocationStatements() bool {
	if o != nil && o.HanadbRevocationStatements != nil {
		return true
	}

	return false
}

// SetHanadbRevocationStatements gets a reference to the given string and assigns it to the HanadbRevocationStatements field.
func (o *DynamicSecretUpdateHanaDb) SetHanadbRevocationStatements(v string) {
	o.HanadbRevocationStatements = &v
}

// GetHanadbUsername returns the HanadbUsername field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetHanadbUsername() string {
	if o == nil || o.HanadbUsername == nil {
		var ret string
		return ret
	}
	return *o.HanadbUsername
}

// GetHanadbUsernameOk returns a tuple with the HanadbUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetHanadbUsernameOk() (*string, bool) {
	if o == nil || o.HanadbUsername == nil {
		return nil, false
	}
	return o.HanadbUsername, true
}

// HasHanadbUsername returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasHanadbUsername() bool {
	if o != nil && o.HanadbUsername != nil {
		return true
	}

	return false
}

// SetHanadbUsername gets a reference to the given string and assigns it to the HanadbUsername field.
func (o *DynamicSecretUpdateHanaDb) SetHanadbUsername(v string) {
	o.HanadbUsername = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DynamicSecretUpdateHanaDb) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *DynamicSecretUpdateHanaDb) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DynamicSecretUpdateHanaDb) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *DynamicSecretUpdateHanaDb) SetNewName(v string) {
	o.NewName = &v
}

// GetPasswordLength returns the PasswordLength field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetPasswordLength() string {
	if o == nil || o.PasswordLength == nil {
		var ret string
		return ret
	}
	return *o.PasswordLength
}

// GetPasswordLengthOk returns a tuple with the PasswordLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetPasswordLengthOk() (*string, bool) {
	if o == nil || o.PasswordLength == nil {
		return nil, false
	}
	return o.PasswordLength, true
}

// HasPasswordLength returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasPasswordLength() bool {
	if o != nil && o.PasswordLength != nil {
		return true
	}

	return false
}

// SetPasswordLength gets a reference to the given string and assigns it to the PasswordLength field.
func (o *DynamicSecretUpdateHanaDb) SetPasswordLength(v string) {
	o.PasswordLength = &v
}

// GetProducerEncryptionKeyName returns the ProducerEncryptionKeyName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetProducerEncryptionKeyName() string {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		var ret string
		return ret
	}
	return *o.ProducerEncryptionKeyName
}

// GetProducerEncryptionKeyNameOk returns a tuple with the ProducerEncryptionKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetProducerEncryptionKeyNameOk() (*string, bool) {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		return nil, false
	}
	return o.ProducerEncryptionKeyName, true
}

// HasProducerEncryptionKeyName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasProducerEncryptionKeyName() bool {
	if o != nil && o.ProducerEncryptionKeyName != nil {
		return true
	}

	return false
}

// SetProducerEncryptionKeyName gets a reference to the given string and assigns it to the ProducerEncryptionKeyName field.
func (o *DynamicSecretUpdateHanaDb) SetProducerEncryptionKeyName(v string) {
	o.ProducerEncryptionKeyName = &v
}

// GetSecureAccessBastionIssuer returns the SecureAccessBastionIssuer field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetSecureAccessBastionIssuer() string {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionIssuer
}

// GetSecureAccessBastionIssuerOk returns a tuple with the SecureAccessBastionIssuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetSecureAccessBastionIssuerOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		return nil, false
	}
	return o.SecureAccessBastionIssuer, true
}

// HasSecureAccessBastionIssuer returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasSecureAccessBastionIssuer() bool {
	if o != nil && o.SecureAccessBastionIssuer != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionIssuer gets a reference to the given string and assigns it to the SecureAccessBastionIssuer field.
func (o *DynamicSecretUpdateHanaDb) SetSecureAccessBastionIssuer(v string) {
	o.SecureAccessBastionIssuer = &v
}

// GetSecureAccessDbSchema returns the SecureAccessDbSchema field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetSecureAccessDbSchema() string {
	if o == nil || o.SecureAccessDbSchema == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessDbSchema
}

// GetSecureAccessDbSchemaOk returns a tuple with the SecureAccessDbSchema field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetSecureAccessDbSchemaOk() (*string, bool) {
	if o == nil || o.SecureAccessDbSchema == nil {
		return nil, false
	}
	return o.SecureAccessDbSchema, true
}

// HasSecureAccessDbSchema returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasSecureAccessDbSchema() bool {
	if o != nil && o.SecureAccessDbSchema != nil {
		return true
	}

	return false
}

// SetSecureAccessDbSchema gets a reference to the given string and assigns it to the SecureAccessDbSchema field.
func (o *DynamicSecretUpdateHanaDb) SetSecureAccessDbSchema(v string) {
	o.SecureAccessDbSchema = &v
}

// GetSecureAccessEnable returns the SecureAccessEnable field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetSecureAccessEnable() string {
	if o == nil || o.SecureAccessEnable == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessEnable
}

// GetSecureAccessEnableOk returns a tuple with the SecureAccessEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetSecureAccessEnableOk() (*string, bool) {
	if o == nil || o.SecureAccessEnable == nil {
		return nil, false
	}
	return o.SecureAccessEnable, true
}

// HasSecureAccessEnable returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasSecureAccessEnable() bool {
	if o != nil && o.SecureAccessEnable != nil {
		return true
	}

	return false
}

// SetSecureAccessEnable gets a reference to the given string and assigns it to the SecureAccessEnable field.
func (o *DynamicSecretUpdateHanaDb) SetSecureAccessEnable(v string) {
	o.SecureAccessEnable = &v
}

// GetSecureAccessHost returns the SecureAccessHost field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetSecureAccessHost() []string {
	if o == nil || o.SecureAccessHost == nil {
		var ret []string
		return ret
	}
	return *o.SecureAccessHost
}

// GetSecureAccessHostOk returns a tuple with the SecureAccessHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetSecureAccessHostOk() (*[]string, bool) {
	if o == nil || o.SecureAccessHost == nil {
		return nil, false
	}
	return o.SecureAccessHost, true
}

// HasSecureAccessHost returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasSecureAccessHost() bool {
	if o != nil && o.SecureAccessHost != nil {
		return true
	}

	return false
}

// SetSecureAccessHost gets a reference to the given []string and assigns it to the SecureAccessHost field.
func (o *DynamicSecretUpdateHanaDb) SetSecureAccessHost(v []string) {
	o.SecureAccessHost = &v
}

// GetSecureAccessWeb returns the SecureAccessWeb field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetSecureAccessWeb() bool {
	if o == nil || o.SecureAccessWeb == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWeb
}

// GetSecureAccessWebOk returns a tuple with the SecureAccessWeb field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetSecureAccessWebOk() (*bool, bool) {
	if o == nil || o.SecureAccessWeb == nil {
		return nil, false
	}
	return o.SecureAccessWeb, true
}

// HasSecureAccessWeb returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasSecureAccessWeb() bool {
	if o != nil && o.SecureAccessWeb != nil {
		return true
	}

	return false
}

// SetSecureAccessWeb gets a reference to the given bool and assigns it to the SecureAccessWeb field.
func (o *DynamicSecretUpdateHanaDb) SetSecureAccessWeb(v bool) {
	o.SecureAccessWeb = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *DynamicSecretUpdateHanaDb) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *DynamicSecretUpdateHanaDb) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DynamicSecretUpdateHanaDb) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DynamicSecretUpdateHanaDb) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserTtl returns the UserTtl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateHanaDb) GetUserTtl() string {
	if o == nil || o.UserTtl == nil {
		var ret string
		return ret
	}
	return *o.UserTtl
}

// GetUserTtlOk returns a tuple with the UserTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateHanaDb) GetUserTtlOk() (*string, bool) {
	if o == nil || o.UserTtl == nil {
		return nil, false
	}
	return o.UserTtl, true
}

// HasUserTtl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateHanaDb) HasUserTtl() bool {
	if o != nil && o.UserTtl != nil {
		return true
	}

	return false
}

// SetUserTtl gets a reference to the given string and assigns it to the UserTtl field.
func (o *DynamicSecretUpdateHanaDb) SetUserTtl(v string) {
	o.UserTtl = &v
}

func (o DynamicSecretUpdateHanaDb) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.HanaDbname != nil {
		toSerialize["hana-dbname"] = o.HanaDbname
	}
	if o.HanadbCreateStatements != nil {
		toSerialize["hanadb-create-statements"] = o.HanadbCreateStatements
	}
	if o.HanadbHost != nil {
		toSerialize["hanadb-host"] = o.HanadbHost
	}
	if o.HanadbPassword != nil {
		toSerialize["hanadb-password"] = o.HanadbPassword
	}
	if o.HanadbPort != nil {
		toSerialize["hanadb-port"] = o.HanadbPort
	}
	if o.HanadbRevocationStatements != nil {
		toSerialize["hanadb-revocation-statements"] = o.HanadbRevocationStatements
	}
	if o.HanadbUsername != nil {
		toSerialize["hanadb-username"] = o.HanadbUsername
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.PasswordLength != nil {
		toSerialize["password-length"] = o.PasswordLength
	}
	if o.ProducerEncryptionKeyName != nil {
		toSerialize["producer-encryption-key-name"] = o.ProducerEncryptionKeyName
	}
	if o.SecureAccessBastionIssuer != nil {
		toSerialize["secure-access-bastion-issuer"] = o.SecureAccessBastionIssuer
	}
	if o.SecureAccessDbSchema != nil {
		toSerialize["secure-access-db-schema"] = o.SecureAccessDbSchema
	}
	if o.SecureAccessEnable != nil {
		toSerialize["secure-access-enable"] = o.SecureAccessEnable
	}
	if o.SecureAccessHost != nil {
		toSerialize["secure-access-host"] = o.SecureAccessHost
	}
	if o.SecureAccessWeb != nil {
		toSerialize["secure-access-web"] = o.SecureAccessWeb
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserTtl != nil {
		toSerialize["user-ttl"] = o.UserTtl
	}
	return json.Marshal(toSerialize)
}

type NullableDynamicSecretUpdateHanaDb struct {
	value *DynamicSecretUpdateHanaDb
	isSet bool
}

func (v NullableDynamicSecretUpdateHanaDb) Get() *DynamicSecretUpdateHanaDb {
	return v.value
}

func (v *NullableDynamicSecretUpdateHanaDb) Set(val *DynamicSecretUpdateHanaDb) {
	v.value = val
	v.isSet = true
}

func (v NullableDynamicSecretUpdateHanaDb) IsSet() bool {
	return v.isSet
}

func (v *NullableDynamicSecretUpdateHanaDb) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDynamicSecretUpdateHanaDb(val *DynamicSecretUpdateHanaDb) *NullableDynamicSecretUpdateHanaDb {
	return &NullableDynamicSecretUpdateHanaDb{value: val, isSet: true}
}

func (v NullableDynamicSecretUpdateHanaDb) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDynamicSecretUpdateHanaDb) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


