/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DeleteItemsOutput struct for DeleteItemsOutput
type DeleteItemsOutput struct {
	DeletedItems *[]string `json:"deleted_items,omitempty"`
	FailedDeletedItems *map[string]string `json:"failed_deleted_items,omitempty"`
	Path *string `json:"path,omitempty"`
}

// NewDeleteItemsOutput instantiates a new DeleteItemsOutput object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDeleteItemsOutput() *DeleteItemsOutput {
	this := DeleteItemsOutput{}
	return &this
}

// NewDeleteItemsOutputWithDefaults instantiates a new DeleteItemsOutput object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDeleteItemsOutputWithDefaults() *DeleteItemsOutput {
	this := DeleteItemsOutput{}
	return &this
}

// GetDeletedItems returns the DeletedItems field value if set, zero value otherwise.
func (o *DeleteItemsOutput) GetDeletedItems() []string {
	if o == nil || o.DeletedItems == nil {
		var ret []string
		return ret
	}
	return *o.DeletedItems
}

// GetDeletedItemsOk returns a tuple with the DeletedItems field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItemsOutput) GetDeletedItemsOk() (*[]string, bool) {
	if o == nil || o.DeletedItems == nil {
		return nil, false
	}
	return o.DeletedItems, true
}

// HasDeletedItems returns a boolean if a field has been set.
func (o *DeleteItemsOutput) HasDeletedItems() bool {
	if o != nil && o.DeletedItems != nil {
		return true
	}

	return false
}

// SetDeletedItems gets a reference to the given []string and assigns it to the DeletedItems field.
func (o *DeleteItemsOutput) SetDeletedItems(v []string) {
	o.DeletedItems = &v
}

// GetFailedDeletedItems returns the FailedDeletedItems field value if set, zero value otherwise.
func (o *DeleteItemsOutput) GetFailedDeletedItems() map[string]string {
	if o == nil || o.FailedDeletedItems == nil {
		var ret map[string]string
		return ret
	}
	return *o.FailedDeletedItems
}

// GetFailedDeletedItemsOk returns a tuple with the FailedDeletedItems field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItemsOutput) GetFailedDeletedItemsOk() (*map[string]string, bool) {
	if o == nil || o.FailedDeletedItems == nil {
		return nil, false
	}
	return o.FailedDeletedItems, true
}

// HasFailedDeletedItems returns a boolean if a field has been set.
func (o *DeleteItemsOutput) HasFailedDeletedItems() bool {
	if o != nil && o.FailedDeletedItems != nil {
		return true
	}

	return false
}

// SetFailedDeletedItems gets a reference to the given map[string]string and assigns it to the FailedDeletedItems field.
func (o *DeleteItemsOutput) SetFailedDeletedItems(v map[string]string) {
	o.FailedDeletedItems = &v
}

// GetPath returns the Path field value if set, zero value otherwise.
func (o *DeleteItemsOutput) GetPath() string {
	if o == nil || o.Path == nil {
		var ret string
		return ret
	}
	return *o.Path
}

// GetPathOk returns a tuple with the Path field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItemsOutput) GetPathOk() (*string, bool) {
	if o == nil || o.Path == nil {
		return nil, false
	}
	return o.Path, true
}

// HasPath returns a boolean if a field has been set.
func (o *DeleteItemsOutput) HasPath() bool {
	if o != nil && o.Path != nil {
		return true
	}

	return false
}

// SetPath gets a reference to the given string and assigns it to the Path field.
func (o *DeleteItemsOutput) SetPath(v string) {
	o.Path = &v
}

func (o DeleteItemsOutput) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DeletedItems != nil {
		toSerialize["deleted_items"] = o.DeletedItems
	}
	if o.FailedDeletedItems != nil {
		toSerialize["failed_deleted_items"] = o.FailedDeletedItems
	}
	if o.Path != nil {
		toSerialize["path"] = o.Path
	}
	return json.Marshal(toSerialize)
}

type NullableDeleteItemsOutput struct {
	value *DeleteItemsOutput
	isSet bool
}

func (v NullableDeleteItemsOutput) Get() *DeleteItemsOutput {
	return v.value
}

func (v *NullableDeleteItemsOutput) Set(val *DeleteItemsOutput) {
	v.value = val
	v.isSet = true
}

func (v NullableDeleteItemsOutput) IsSet() bool {
	return v.isSet
}

func (v *NullableDeleteItemsOutput) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDeleteItemsOutput(val *DeleteItemsOutput) *NullableDeleteItemsOutput {
	return &NullableDeleteItemsOutput{value: val, isSet: true}
}

func (v NullableDeleteItemsOutput) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDeleteItemsOutput) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


