/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DeleteItems struct for DeleteItems
type DeleteItems struct {
	// A list of items to delete, To specify multiple items use argument multiple times
	Item *[]string `json:"item,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Path to delete the items from
	Path string `json:"path"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewDeleteItems instantiates a new DeleteItems object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDeleteItems(path string, ) *DeleteItems {
	this := DeleteItems{}
	var json bool = false
	this.Json = &json
	this.Path = path
	return &this
}

// NewDeleteItemsWithDefaults instantiates a new DeleteItems object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDeleteItemsWithDefaults() *DeleteItems {
	this := DeleteItems{}
	var json bool = false
	this.Json = &json
	var path string = "dummy_path"
	this.Path = path
	return &this
}

// GetItem returns the Item field value if set, zero value otherwise.
func (o *DeleteItems) GetItem() []string {
	if o == nil || o.Item == nil {
		var ret []string
		return ret
	}
	return *o.Item
}

// GetItemOk returns a tuple with the Item field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItems) GetItemOk() (*[]string, bool) {
	if o == nil || o.Item == nil {
		return nil, false
	}
	return o.Item, true
}

// HasItem returns a boolean if a field has been set.
func (o *DeleteItems) HasItem() bool {
	if o != nil && o.Item != nil {
		return true
	}

	return false
}

// SetItem gets a reference to the given []string and assigns it to the Item field.
func (o *DeleteItems) SetItem(v []string) {
	o.Item = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DeleteItems) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItems) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DeleteItems) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DeleteItems) SetJson(v bool) {
	o.Json = &v
}

// GetPath returns the Path field value
func (o *DeleteItems) GetPath() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Path
}

// GetPathOk returns a tuple with the Path field value
// and a boolean to check if the value has been set.
func (o *DeleteItems) GetPathOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Path, true
}

// SetPath sets field value
func (o *DeleteItems) SetPath(v string) {
	o.Path = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DeleteItems) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItems) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DeleteItems) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DeleteItems) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DeleteItems) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItems) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DeleteItems) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DeleteItems) SetUidToken(v string) {
	o.UidToken = &v
}

func (o DeleteItems) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Item != nil {
		toSerialize["item"] = o.Item
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["path"] = o.Path
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableDeleteItems struct {
	value *DeleteItems
	isSet bool
}

func (v NullableDeleteItems) Get() *DeleteItems {
	return v.value
}

func (v *NullableDeleteItems) Set(val *DeleteItems) {
	v.value = val
	v.isSet = true
}

func (v NullableDeleteItems) IsSet() bool {
	return v.isSet
}

func (v *NullableDeleteItems) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDeleteItems(val *DeleteItems) *NullableDeleteItems {
	return &NullableDeleteItems{value: val, isSet: true}
}

func (v NullableDeleteItems) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDeleteItems) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


