/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateUserEvent struct for CreateUserEvent
type CreateUserEvent struct {
	// List of the required capabilities options: [read, update, delete,sra_transparently_connect]. Relevant only for request-access event types
	Capabilities *[]string `json:"capabilities,omitempty"`
	// Deprecated - use description
	Comment *string `json:"comment,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	EventSource *string `json:"event-source,omitempty"`
	EventType string `json:"event-type"`
	// EventItemName Event item name
	ItemName string `json:"item-name"`
	// EventItemType Event item type
	ItemType string `json:"item-type"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// For how long to grant the requested access, in minutes
	RequestAccessTtl *int64 `json:"request-access-ttl,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewCreateUserEvent instantiates a new CreateUserEvent object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateUserEvent(eventType string, itemName string, itemType string, ) *CreateUserEvent {
	this := CreateUserEvent{}
	this.EventType = eventType
	this.ItemName = itemName
	this.ItemType = itemType
	var json bool = false
	this.Json = &json
	return &this
}

// NewCreateUserEventWithDefaults instantiates a new CreateUserEvent object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateUserEventWithDefaults() *CreateUserEvent {
	this := CreateUserEvent{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetCapabilities returns the Capabilities field value if set, zero value otherwise.
func (o *CreateUserEvent) GetCapabilities() []string {
	if o == nil || o.Capabilities == nil {
		var ret []string
		return ret
	}
	return *o.Capabilities
}

// GetCapabilitiesOk returns a tuple with the Capabilities field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetCapabilitiesOk() (*[]string, bool) {
	if o == nil || o.Capabilities == nil {
		return nil, false
	}
	return o.Capabilities, true
}

// HasCapabilities returns a boolean if a field has been set.
func (o *CreateUserEvent) HasCapabilities() bool {
	if o != nil && o.Capabilities != nil {
		return true
	}

	return false
}

// SetCapabilities gets a reference to the given []string and assigns it to the Capabilities field.
func (o *CreateUserEvent) SetCapabilities(v []string) {
	o.Capabilities = &v
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *CreateUserEvent) GetComment() string {
	if o == nil || o.Comment == nil {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetCommentOk() (*string, bool) {
	if o == nil || o.Comment == nil {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *CreateUserEvent) HasComment() bool {
	if o != nil && o.Comment != nil {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *CreateUserEvent) SetComment(v string) {
	o.Comment = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreateUserEvent) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreateUserEvent) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreateUserEvent) SetDescription(v string) {
	o.Description = &v
}

// GetEventSource returns the EventSource field value if set, zero value otherwise.
func (o *CreateUserEvent) GetEventSource() string {
	if o == nil || o.EventSource == nil {
		var ret string
		return ret
	}
	return *o.EventSource
}

// GetEventSourceOk returns a tuple with the EventSource field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetEventSourceOk() (*string, bool) {
	if o == nil || o.EventSource == nil {
		return nil, false
	}
	return o.EventSource, true
}

// HasEventSource returns a boolean if a field has been set.
func (o *CreateUserEvent) HasEventSource() bool {
	if o != nil && o.EventSource != nil {
		return true
	}

	return false
}

// SetEventSource gets a reference to the given string and assigns it to the EventSource field.
func (o *CreateUserEvent) SetEventSource(v string) {
	o.EventSource = &v
}

// GetEventType returns the EventType field value
func (o *CreateUserEvent) GetEventType() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EventType
}

// GetEventTypeOk returns a tuple with the EventType field value
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetEventTypeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EventType, true
}

// SetEventType sets field value
func (o *CreateUserEvent) SetEventType(v string) {
	o.EventType = v
}

// GetItemName returns the ItemName field value
func (o *CreateUserEvent) GetItemName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ItemName
}

// GetItemNameOk returns a tuple with the ItemName field value
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetItemNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ItemName, true
}

// SetItemName sets field value
func (o *CreateUserEvent) SetItemName(v string) {
	o.ItemName = v
}

// GetItemType returns the ItemType field value
func (o *CreateUserEvent) GetItemType() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ItemType
}

// GetItemTypeOk returns a tuple with the ItemType field value
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetItemTypeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ItemType, true
}

// SetItemType sets field value
func (o *CreateUserEvent) SetItemType(v string) {
	o.ItemType = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreateUserEvent) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreateUserEvent) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreateUserEvent) SetJson(v bool) {
	o.Json = &v
}

// GetRequestAccessTtl returns the RequestAccessTtl field value if set, zero value otherwise.
func (o *CreateUserEvent) GetRequestAccessTtl() int64 {
	if o == nil || o.RequestAccessTtl == nil {
		var ret int64
		return ret
	}
	return *o.RequestAccessTtl
}

// GetRequestAccessTtlOk returns a tuple with the RequestAccessTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetRequestAccessTtlOk() (*int64, bool) {
	if o == nil || o.RequestAccessTtl == nil {
		return nil, false
	}
	return o.RequestAccessTtl, true
}

// HasRequestAccessTtl returns a boolean if a field has been set.
func (o *CreateUserEvent) HasRequestAccessTtl() bool {
	if o != nil && o.RequestAccessTtl != nil {
		return true
	}

	return false
}

// SetRequestAccessTtl gets a reference to the given int64 and assigns it to the RequestAccessTtl field.
func (o *CreateUserEvent) SetRequestAccessTtl(v int64) {
	o.RequestAccessTtl = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateUserEvent) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateUserEvent) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateUserEvent) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateUserEvent) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateUserEvent) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateUserEvent) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateUserEvent) SetUidToken(v string) {
	o.UidToken = &v
}

func (o CreateUserEvent) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Capabilities != nil {
		toSerialize["capabilities"] = o.Capabilities
	}
	if o.Comment != nil {
		toSerialize["comment"] = o.Comment
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.EventSource != nil {
		toSerialize["event-source"] = o.EventSource
	}
	if true {
		toSerialize["event-type"] = o.EventType
	}
	if true {
		toSerialize["item-name"] = o.ItemName
	}
	if true {
		toSerialize["item-type"] = o.ItemType
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.RequestAccessTtl != nil {
		toSerialize["request-access-ttl"] = o.RequestAccessTtl
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableCreateUserEvent struct {
	value *CreateUserEvent
	isSet bool
}

func (v NullableCreateUserEvent) Get() *CreateUserEvent {
	return v.value
}

func (v *NullableCreateUserEvent) Set(val *CreateUserEvent) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateUserEvent) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateUserEvent) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateUserEvent(val *CreateUserEvent) *NullableCreateUserEvent {
	return &NullableCreateUserEvent{value: val, isSet: true}
}

func (v NullableCreateUserEvent) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateUserEvent) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


