/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CertificateIssueInfo struct for CertificateIssueInfo
type CertificateIssueInfo struct {
	CertIssuerType *string `json:"cert_issuer_type,omitempty"`
	MaxTtl *int64 `json:"max_ttl,omitempty"`
	PkiCertIssuerDetails *PKICertificateIssueDetails `json:"pki_cert_issuer_details,omitempty"`
	SshCertIssuerDetails *SSHCertificateIssueDetails `json:"ssh_cert_issuer_details,omitempty"`
}

// NewCertificateIssueInfo instantiates a new CertificateIssueInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCertificateIssueInfo() *CertificateIssueInfo {
	this := CertificateIssueInfo{}
	return &this
}

// NewCertificateIssueInfoWithDefaults instantiates a new CertificateIssueInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCertificateIssueInfoWithDefaults() *CertificateIssueInfo {
	this := CertificateIssueInfo{}
	return &this
}

// GetCertIssuerType returns the CertIssuerType field value if set, zero value otherwise.
func (o *CertificateIssueInfo) GetCertIssuerType() string {
	if o == nil || o.CertIssuerType == nil {
		var ret string
		return ret
	}
	return *o.CertIssuerType
}

// GetCertIssuerTypeOk returns a tuple with the CertIssuerType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateIssueInfo) GetCertIssuerTypeOk() (*string, bool) {
	if o == nil || o.CertIssuerType == nil {
		return nil, false
	}
	return o.CertIssuerType, true
}

// HasCertIssuerType returns a boolean if a field has been set.
func (o *CertificateIssueInfo) HasCertIssuerType() bool {
	if o != nil && o.CertIssuerType != nil {
		return true
	}

	return false
}

// SetCertIssuerType gets a reference to the given string and assigns it to the CertIssuerType field.
func (o *CertificateIssueInfo) SetCertIssuerType(v string) {
	o.CertIssuerType = &v
}

// GetMaxTtl returns the MaxTtl field value if set, zero value otherwise.
func (o *CertificateIssueInfo) GetMaxTtl() int64 {
	if o == nil || o.MaxTtl == nil {
		var ret int64
		return ret
	}
	return *o.MaxTtl
}

// GetMaxTtlOk returns a tuple with the MaxTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateIssueInfo) GetMaxTtlOk() (*int64, bool) {
	if o == nil || o.MaxTtl == nil {
		return nil, false
	}
	return o.MaxTtl, true
}

// HasMaxTtl returns a boolean if a field has been set.
func (o *CertificateIssueInfo) HasMaxTtl() bool {
	if o != nil && o.MaxTtl != nil {
		return true
	}

	return false
}

// SetMaxTtl gets a reference to the given int64 and assigns it to the MaxTtl field.
func (o *CertificateIssueInfo) SetMaxTtl(v int64) {
	o.MaxTtl = &v
}

// GetPkiCertIssuerDetails returns the PkiCertIssuerDetails field value if set, zero value otherwise.
func (o *CertificateIssueInfo) GetPkiCertIssuerDetails() PKICertificateIssueDetails {
	if o == nil || o.PkiCertIssuerDetails == nil {
		var ret PKICertificateIssueDetails
		return ret
	}
	return *o.PkiCertIssuerDetails
}

// GetPkiCertIssuerDetailsOk returns a tuple with the PkiCertIssuerDetails field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateIssueInfo) GetPkiCertIssuerDetailsOk() (*PKICertificateIssueDetails, bool) {
	if o == nil || o.PkiCertIssuerDetails == nil {
		return nil, false
	}
	return o.PkiCertIssuerDetails, true
}

// HasPkiCertIssuerDetails returns a boolean if a field has been set.
func (o *CertificateIssueInfo) HasPkiCertIssuerDetails() bool {
	if o != nil && o.PkiCertIssuerDetails != nil {
		return true
	}

	return false
}

// SetPkiCertIssuerDetails gets a reference to the given PKICertificateIssueDetails and assigns it to the PkiCertIssuerDetails field.
func (o *CertificateIssueInfo) SetPkiCertIssuerDetails(v PKICertificateIssueDetails) {
	o.PkiCertIssuerDetails = &v
}

// GetSshCertIssuerDetails returns the SshCertIssuerDetails field value if set, zero value otherwise.
func (o *CertificateIssueInfo) GetSshCertIssuerDetails() SSHCertificateIssueDetails {
	if o == nil || o.SshCertIssuerDetails == nil {
		var ret SSHCertificateIssueDetails
		return ret
	}
	return *o.SshCertIssuerDetails
}

// GetSshCertIssuerDetailsOk returns a tuple with the SshCertIssuerDetails field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateIssueInfo) GetSshCertIssuerDetailsOk() (*SSHCertificateIssueDetails, bool) {
	if o == nil || o.SshCertIssuerDetails == nil {
		return nil, false
	}
	return o.SshCertIssuerDetails, true
}

// HasSshCertIssuerDetails returns a boolean if a field has been set.
func (o *CertificateIssueInfo) HasSshCertIssuerDetails() bool {
	if o != nil && o.SshCertIssuerDetails != nil {
		return true
	}

	return false
}

// SetSshCertIssuerDetails gets a reference to the given SSHCertificateIssueDetails and assigns it to the SshCertIssuerDetails field.
func (o *CertificateIssueInfo) SetSshCertIssuerDetails(v SSHCertificateIssueDetails) {
	o.SshCertIssuerDetails = &v
}

func (o CertificateIssueInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CertIssuerType != nil {
		toSerialize["cert_issuer_type"] = o.CertIssuerType
	}
	if o.MaxTtl != nil {
		toSerialize["max_ttl"] = o.MaxTtl
	}
	if o.PkiCertIssuerDetails != nil {
		toSerialize["pki_cert_issuer_details"] = o.PkiCertIssuerDetails
	}
	if o.SshCertIssuerDetails != nil {
		toSerialize["ssh_cert_issuer_details"] = o.SshCertIssuerDetails
	}
	return json.Marshal(toSerialize)
}

type NullableCertificateIssueInfo struct {
	value *CertificateIssueInfo
	isSet bool
}

func (v NullableCertificateIssueInfo) Get() *CertificateIssueInfo {
	return v.value
}

func (v *NullableCertificateIssueInfo) Set(val *CertificateIssueInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableCertificateIssueInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableCertificateIssueInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCertificateIssueInfo(val *CertificateIssueInfo) *NullableCertificateIssueInfo {
	return &NullableCertificateIssueInfo{value: val, isSet: true}
}

func (v NullableCertificateIssueInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCertificateIssueInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


