Name:           clementine
Version:        1.4.1
Release:        2.28.g41e2a07b3%{?dist}
Summary:        A music player and library organiser

License:        GPLv3
URL:            http://www.clementine-player.org/
Source0:        %{name}-1.4.1-28-g41e2a07b3.tar.xz

BuildRequires:  cmake
BuildRequires:  make
BuildRequires:  git
BuildRequires:  gettext
BuildRequires:  gcc-c++
BuildRequires:  boost-devel
BuildRequires:  sparsehash-devel
BuildRequires:  liblastfm-qt5-devel
BuildRequires:  desktop-file-utils
BuildRequires:  hicolor-icon-theme
BuildRequires:  libappstream-glib
BuildRequires:  qtsingleapplication-qt5-devel
BuildRequires:  pkgconfig
BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(gio-2.0)
BuildRequires:  pkgconfig(gio-unix-2.0)
BuildRequires:  pkgconfig(gthread-2.0)
BuildRequires:  pkgconfig(dbus-1)
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(protobuf)
BuildRequires:  pkgconfig(sqlite3) >= 3.7
BuildRequires:  pkgconfig(taglib) >= 1.11
BuildRequires:  pkgconfig(glew)
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Widgets)
BuildRequires:  pkgconfig(Qt5Concurrent)
BuildRequires:  pkgconfig(Qt5Sql)
BuildRequires:  pkgconfig(Qt5Network)
BuildRequires:  pkgconfig(Qt5Xml)
BuildRequires:  pkgconfig(Qt5X11Extras)
BuildRequires:  pkgconfig(Qt5OpenGL)
BuildRequires:  pkgconfig(Qt5DBus)
BuildRequires:  pkgconfig(Qt5Test)
BuildRequires:  pkgconfig(gstreamer-1.0)
BuildRequires:  pkgconfig(gstreamer-app-1.0)
BuildRequires:  pkgconfig(gstreamer-audio-1.0)
BuildRequires:  pkgconfig(gstreamer-base-1.0)
BuildRequires:  pkgconfig(gstreamer-tag-1.0)
BuildRequires:  pkgconfig(libcdio)
BuildRequires:  pkgconfig(libchromaprint)
BuildRequires:  pkgconfig(libcryptopp)
BuildRequires:  pkgconfig(libgpod-1.0)
BuildRequires:  pkgconfig(libmtp)
BuildRequires:  pkgconfig(libnotify)
BuildRequires:  pkgconfig(libpulse)
BuildRequires:  pkgconfig(libudf)

# GStreamer codec dependencies
Requires:       gstreamer1-plugins-ugly-free

%ifarch x86_64
Requires:       gstreamer1(decoder-audio/x-vorbis)()(64bit)
Requires:       gstreamer1(decoder-audio/x-flac)()(64bit)
Requires:       gstreamer1(decoder-audio/x-speex)()(64bit)
Requires:       gstreamer1(decoder-audio/x-wav)()(64bit)
%else
Requires:       gstreamer1(decoder-audio/x-vorbis)
Requires:       gstreamer1(decoder-audio/x-flac)
Requires:       gstreamer1(decoder-audio/x-speex)
Requires:       gstreamer1(decoder-audio/x-wav)
%endif

%description
Clementine is a modern music player and library organiser.
It is inspired by Amarok 1.4, focusing on a fast and easy-to-use interface for
searching and playing your music.

Features include:
  * Search and play your local music library
  * Listen to internet radio from Last.fm, SomaFM, IntergalacticFM, Magnatune,
    Jamendo and Icecast
  * Create smart playlists and dynamic playlists
  * Tabbed playlists, import and export M3U, XSPF, PLS and ASX
  * Visualisations from projectM
  * Lyrics and artist biographies and photos
  * Transcode music into MP3, Ogg Vorbis, Ogg Speex, FLAC or AAC
  * Edit tags on MP3 and OGG files, organise your music
  * Download missing album cover art from Last.fm
  * Cross-platform - works on Windows, Mac OS X and Linux
  * Native desktop notifications on Linux (libnotify) and Mac OS X (Growl)
  * Remote control using a Wii Remote, MPRIS or the command-line
  * Copy music to your iPod, iPhone, MTP or mass-storage USB player
  * Queue manager

%prep
%setup -q -n %{name}-1.4.1-28-g41e2a07b3


%build
cd bin
%{cmake} .. -DUSE_INSTALL_PREFIX=OFF -DBUNDLE_PROJECTM_PRESETS=ON -DCMAKE_POSITION_INDEPENDENT_CODE=ON -DFORCE_GIT_REVISION=1.4.1-28-g41e2a07b3
%{cmake_build}

%install
cd bin
%{cmake_install}
rm -f $RPM_BUILD_ROOT/usr/share/icons/ubuntu-mono-{dark,light}/apps/24/clementine-panel*.png


%files
%defattr(-,root,root,-)
%doc
%{_bindir}/clementine
%{_bindir}/clementine-tagreader
%dir %{_datadir}/metainfo/
%{_datadir}/metainfo/org.clementine_player.Clementine.appdata.xml
%{_datadir}/applications/org.clementine_player.Clementine.desktop
%{_datadir}/clementine/projectm-presets
%{_datadir}/kservices5/clementine-itms.protocol
%{_datadir}/kservices5/clementine-itpc.protocol
%{_datadir}/kservices5/clementine-feed.protocol
%{_datadir}/kservices5/clementine-zune.protocol
%{_datadir}/icons/hicolor/64x64/apps/org.clementine_player.Clementine.png
%{_datadir}/icons/hicolor/128x128/apps/org.clementine_player.Clementine.png
%{_datadir}/icons/hicolor/scalable/apps/org.clementine_player.Clementine.svg

%changelog
* Mon Jan 13 2025 David Sansome <me@davidsansome.com> - 1.4.1
- Version 1.4.1-28-g41e2a07b3
