//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// NSURLCredentialStorage implements a singleton object (shared instance) which manages the shared credentials cache. Note: Whereas in Mac OS X any application can access any credential with a persistence of NSURLCredentialPersistencePermanent provided the user gives permission, in iPhone OS an application can access only its own credentials.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcredentialstorage?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLCredentialStorage;
);

unsafe impl Send for NSURLCredentialStorage {}

unsafe impl Sync for NSURLCredentialStorage {}

unsafe impl NSObjectProtocol for NSURLCredentialStorage {}

impl NSURLCredentialStorage {
    extern_methods!(
        /// Get the shared singleton authentication storage
        ///
        /// Returns: the shared authentication storage
        #[unsafe(method(sharedCredentialStorage))]
        #[unsafe(method_family = none)]
        pub unsafe fn sharedCredentialStorage() -> Retained<NSURLCredentialStorage>;

        #[cfg(all(
            feature = "NSDictionary",
            feature = "NSString",
            feature = "NSURLCredential",
            feature = "NSURLProtectionSpace"
        ))]
        /// Get a dictionary mapping usernames to credentials for the specified protection space.
        ///
        /// Parameter `space`: An NSURLProtectionSpace indicating the protection space for which to get credentials
        ///
        /// Returns: A dictionary where the keys are usernames and the values are the corresponding NSURLCredentials.
        #[unsafe(method(credentialsForProtectionSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn credentialsForProtectionSpace(
            &self,
            space: &NSURLProtectionSpace,
        ) -> Option<Retained<NSDictionary<NSString, NSURLCredential>>>;

        #[cfg(all(
            feature = "NSDictionary",
            feature = "NSString",
            feature = "NSURLCredential",
            feature = "NSURLProtectionSpace"
        ))]
        /// Get a dictionary mapping NSURLProtectionSpaces to dictionaries which map usernames to NSURLCredentials
        ///
        /// Returns: an NSDictionary where the keys are NSURLProtectionSpaces
        /// and the values are dictionaries, in which the keys are usernames
        /// and the values are NSURLCredentials
        #[unsafe(method(allCredentials))]
        #[unsafe(method_family = none)]
        pub unsafe fn allCredentials(
            &self,
        ) -> Retained<NSDictionary<NSURLProtectionSpace, NSDictionary<NSString, NSURLCredential>>>;

        #[cfg(all(feature = "NSURLCredential", feature = "NSURLProtectionSpace"))]
        /// Add a new credential to the set for the specified protection space or replace an existing one.
        ///
        /// Parameter `credential`: The credential to set.
        ///
        /// Parameter `space`: The protection space for which to add it.
        ///
        /// Multiple credentials may be set for a given protection space, but each must have
        /// a distinct user. If a credential with the same user is already set for the protection space,
        /// the new one will replace it.
        #[unsafe(method(setCredential:forProtectionSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCredential_forProtectionSpace(
            &self,
            credential: &NSURLCredential,
            space: &NSURLProtectionSpace,
        );

        #[cfg(all(feature = "NSURLCredential", feature = "NSURLProtectionSpace"))]
        /// Remove the credential from the set for the specified protection space.
        ///
        /// Parameter `credential`: The credential to remove.
        ///
        /// Parameter `space`: The protection space for which a credential should be removed
        ///
        /// The credential is removed from both persistent and temporary storage. A credential that
        /// has a persistence policy of NSURLCredentialPersistenceSynchronizable will fail.
        /// See removeCredential:forProtectionSpace:options.
        #[unsafe(method(removeCredential:forProtectionSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeCredential_forProtectionSpace(
            &self,
            credential: &NSURLCredential,
            space: &NSURLProtectionSpace,
        );

        #[cfg(all(
            feature = "NSDictionary",
            feature = "NSString",
            feature = "NSURLCredential",
            feature = "NSURLProtectionSpace"
        ))]
        /// Remove the credential from the set for the specified protection space based on options.
        ///
        /// Parameter `credential`: The credential to remove.
        ///
        /// Parameter `space`: The protection space for which a credential should be removed
        ///
        /// Parameter `options`: A dictionary containing options to consider when removing the credential.  This should
        /// be used when trying to delete a credential that has the NSURLCredentialPersistenceSynchronizable policy.
        /// Please note that when NSURLCredential objects that have a NSURLCredentialPersistenceSynchronizable policy
        /// are removed, the credential will be removed on all devices that contain this credential.
        ///
        /// The credential is removed from both persistent and temporary storage.
        #[unsafe(method(removeCredential:forProtectionSpace:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeCredential_forProtectionSpace_options(
            &self,
            credential: &NSURLCredential,
            space: &NSURLProtectionSpace,
            options: Option<&NSDictionary<NSString, AnyObject>>,
        );

        #[cfg(all(feature = "NSURLCredential", feature = "NSURLProtectionSpace"))]
        /// Get the default credential for the specified protection space.
        ///
        /// Parameter `space`: The protection space for which to get the default credential.
        #[unsafe(method(defaultCredentialForProtectionSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultCredentialForProtectionSpace(
            &self,
            space: &NSURLProtectionSpace,
        ) -> Option<Retained<NSURLCredential>>;

        #[cfg(all(feature = "NSURLCredential", feature = "NSURLProtectionSpace"))]
        /// Set the default credential for the specified protection space.
        ///
        /// Parameter `credential`: The credential to set as default.
        ///
        /// Parameter `space`: The protection space for which the credential should be set as default.
        ///
        /// If the credential is not yet in the set for the protection space, it will be added to it.
        #[unsafe(method(setDefaultCredential:forProtectionSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultCredential_forProtectionSpace(
            &self,
            credential: &NSURLCredential,
            space: &NSURLProtectionSpace,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl NSURLCredentialStorage {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// NSURLSessionTaskAdditions.
impl NSURLCredentialStorage {
    extern_methods!(
        #[cfg(all(
            feature = "NSDictionary",
            feature = "NSString",
            feature = "NSURLCredential",
            feature = "NSURLProtectionSpace",
            feature = "NSURLSession",
            feature = "block2"
        ))]
        #[unsafe(method(getCredentialsForProtectionSpace:task:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCredentialsForProtectionSpace_task_completionHandler(
            &self,
            protection_space: &NSURLProtectionSpace,
            task: &NSURLSessionTask,
            completion_handler: &block2::Block<
                dyn Fn(*mut NSDictionary<NSString, NSURLCredential>),
            >,
        );

        #[cfg(all(
            feature = "NSURLCredential",
            feature = "NSURLProtectionSpace",
            feature = "NSURLSession"
        ))]
        #[unsafe(method(setCredential:forProtectionSpace:task:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCredential_forProtectionSpace_task(
            &self,
            credential: &NSURLCredential,
            protection_space: &NSURLProtectionSpace,
            task: &NSURLSessionTask,
        );

        #[cfg(all(
            feature = "NSDictionary",
            feature = "NSString",
            feature = "NSURLCredential",
            feature = "NSURLProtectionSpace",
            feature = "NSURLSession"
        ))]
        #[unsafe(method(removeCredential:forProtectionSpace:options:task:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeCredential_forProtectionSpace_options_task(
            &self,
            credential: &NSURLCredential,
            protection_space: &NSURLProtectionSpace,
            options: Option<&NSDictionary<NSString, AnyObject>>,
            task: &NSURLSessionTask,
        );

        #[cfg(all(
            feature = "NSURLCredential",
            feature = "NSURLProtectionSpace",
            feature = "NSURLSession",
            feature = "block2"
        ))]
        #[unsafe(method(getDefaultCredentialForProtectionSpace:task:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getDefaultCredentialForProtectionSpace_task_completionHandler(
            &self,
            space: &NSURLProtectionSpace,
            task: &NSURLSessionTask,
            completion_handler: &block2::Block<dyn Fn(*mut NSURLCredential)>,
        );

        #[cfg(all(
            feature = "NSURLCredential",
            feature = "NSURLProtectionSpace",
            feature = "NSURLSession"
        ))]
        #[unsafe(method(setDefaultCredential:forProtectionSpace:task:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultCredential_forProtectionSpace_task(
            &self,
            credential: &NSURLCredential,
            protection_space: &NSURLProtectionSpace,
            task: &NSURLSessionTask,
        );
    );
}

extern "C" {
    /// This notification is sent on the main thread whenever
    /// the set of stored credentials changes.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcredentialstoragechangednotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    pub static NSURLCredentialStorageChangedNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcredentialstorageremovesynchronizablecredentials?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLCredentialStorageRemoveSynchronizableCredentials: &'static NSString;
}
