//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstermofaddress?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSTermOfAddress;
);

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSTermOfAddress {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSTermOfAddress {}

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSTermOfAddress {
    type Result = Self;
}

unsafe impl NSObjectProtocol for NSTermOfAddress {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSTermOfAddress {}

impl NSTermOfAddress {
    extern_methods!(
        /// Term of address that uses gender-neutral pronouns (e.g. they/them/theirs in
        /// English), and an epicene grammatical gender when inflecting verbs and
        /// adjectives referring to the person
        #[unsafe(method(neutral))]
        #[unsafe(method_family = none)]
        pub unsafe fn neutral() -> Retained<Self>;

        /// Term of address that uses feminine pronouns (e.g. she/her/hers in English),
        /// and a feminine grammatical gender when inflecting verbs and adjectives
        /// referring to the person
        #[unsafe(method(feminine))]
        #[unsafe(method_family = none)]
        pub unsafe fn feminine() -> Retained<Self>;

        /// Term of address that uses masculine pronouns (e.g. he/him/his in English),
        /// and a masculine grammatical gender when inflecting verbs and adjectives
        /// referring to the person
        #[unsafe(method(masculine))]
        #[unsafe(method_family = none)]
        pub unsafe fn masculine() -> Retained<Self>;

        /// The term of address that should be used for addressing the user
        ///
        /// This term of address will only compare equal to another `+[NSTermOfAddress currentUser]`
        #[unsafe(method(currentUser))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentUser() -> Retained<Self>;

        #[cfg(all(feature = "NSArray", feature = "NSMorphology", feature = "NSString"))]
        /// A term of address restricted to a given language
        ///
        /// Parameter `language`: ISO language code identifier for the language
        ///
        /// Parameter `pronouns`: A list of pronouns in the target language that can be used to
        /// refer to the person.
        #[unsafe(method(localizedForLanguageIdentifier:withPronouns:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedForLanguageIdentifier_withPronouns(
            language: &NSString,
            pronouns: &NSArray<NSMorphologyPronoun>,
        ) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        /// The ISO language code if this is a localized term of address
        #[unsafe(method(languageIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn languageIdentifier(&self) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSArray", feature = "NSMorphology"))]
        /// A list of pronouns for a localized term of address
        #[unsafe(method(pronouns))]
        #[unsafe(method_family = none)]
        pub unsafe fn pronouns(&self) -> Option<Retained<NSArray<NSMorphologyPronoun>>>;
    );
}
