/*
 * Copyright (C) 2016 BlueKitchen GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 * 4. Any redistribution, use, or modification is done solely for
 *    personal benefit and not for any commercial purpose or for
 *    monetary gain.
 *
 * THIS SOFTWARE IS PROVIDED BY BLUEKITCHEN GMBH AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BLUEKITCHEN
 * GMBH OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Please inquire about commercial licensing options at 
 * contact@bluekitchen-gmbh.com
 *
 */

 
/**
 * HCI Event Getter
 *
 * Note: Don't edit this file. It is generated by tool/btstack_event_generator.py
 *
 */

#ifndef BTSTACK_EVENT_H
#define BTSTACK_EVENT_H

#if defined __cplusplus
extern "C" {
#endif

#include "btstack_util.h"
#include <stdint.h>

#ifdef ENABLE_BLE
#include "ble/gatt_client.h"
#endif

/* API_START */

/**
 * @brief Get event type
 * @param event
 * @return type of event
 */
static inline uint8_t hci_event_packet_get_type(const uint8_t * event){
    return event[0];
}

/***
 * @brief Get subevent code for a2dp event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_a2dp_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for ancs event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_ancs_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for avdtp event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_avdtp_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for avrcp event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_avrcp_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for gap event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_gap_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for gattservice event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_gattservice_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for goep event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_goep_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for hfp event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_hfp_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for hid event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_hid_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for hids event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_hids_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for hsp event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_hsp_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for le event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_le_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for map event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_map_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for mesh event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_mesh_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for pbap event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_pbap_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/***
 * @brief Get subevent code for opp event
 * @param event packet
 * @return subevent_code
 */
static inline uint8_t hci_event_opp_meta_get_subevent_code(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field status from event HCI_EVENT_INQUIRY_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_inquiry_complete_get_status(const uint8_t * event){
    return event[2];
}

/**
 * @brief Get field num_responses from event HCI_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return num_responses
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_inquiry_result_get_num_responses(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field bd_addr from event HCI_EVENT_INQUIRY_RESULT
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_inquiry_result_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[3], bd_addr, 6);
}
/**
 * @brief Get field page_scan_repetition_mode from event HCI_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return page_scan_repetition_mode
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_inquiry_result_get_page_scan_repetition_mode(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field reserved1 from event HCI_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return reserved1
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_inquiry_result_get_reserved1(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field reserved2 from event HCI_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return reserved2
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_inquiry_result_get_reserved2(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field class_of_device from event HCI_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return class_of_device
 * @note: btstack_type 3
 */
static inline uint32_t hci_event_inquiry_result_get_class_of_device(const uint8_t * event){
    return little_endian_read_24(event, 12);
}
/**
 * @brief Get field clock_offset from event HCI_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return clock_offset
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_inquiry_result_get_clock_offset(const uint8_t * event){
    return little_endian_read_16(event, 15);
}

/**
 * @brief Get field status from event HCI_EVENT_CONNECTION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_connection_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field connection_handle from event HCI_EVENT_CONNECTION_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_connection_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field bd_addr from event HCI_EVENT_CONNECTION_COMPLETE
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_connection_complete_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[5], bd_addr, 6);
}
/**
 * @brief Get field link_type from event HCI_EVENT_CONNECTION_COMPLETE
 * @param event packet
 * @return link_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_connection_complete_get_link_type(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field encryption_enabled from event HCI_EVENT_CONNECTION_COMPLETE
 * @param event packet
 * @return encryption_enabled
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_connection_complete_get_encryption_enabled(const uint8_t * event){
    return event[12];
}

/**
 * @brief Get field bd_addr from event HCI_EVENT_CONNECTION_REQUEST
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_connection_request_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}
/**
 * @brief Get field class_of_device from event HCI_EVENT_CONNECTION_REQUEST
 * @param event packet
 * @return class_of_device
 * @note: btstack_type 3
 */
static inline uint32_t hci_event_connection_request_get_class_of_device(const uint8_t * event){
    return little_endian_read_24(event, 8);
}
/**
 * @brief Get field link_type from event HCI_EVENT_CONNECTION_REQUEST
 * @param event packet
 * @return link_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_connection_request_get_link_type(const uint8_t * event){
    return event[11];
}

/**
 * @brief Get field status from event HCI_EVENT_DISCONNECTION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_disconnection_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field connection_handle from event HCI_EVENT_DISCONNECTION_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_disconnection_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field reason from event HCI_EVENT_DISCONNECTION_COMPLETE
 * @param event packet
 * @return reason
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_disconnection_complete_get_reason(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field status from event HCI_EVENT_AUTHENTICATION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_authentication_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field connection_handle from event HCI_EVENT_AUTHENTICATION_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_authentication_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field status from event HCI_EVENT_REMOTE_NAME_REQUEST_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_remote_name_request_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field bd_addr from event HCI_EVENT_REMOTE_NAME_REQUEST_COMPLETE
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_remote_name_request_complete_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[3], bd_addr, 6);
}
/**
 * @brief Get field remote_name from event HCI_EVENT_REMOTE_NAME_REQUEST_COMPLETE
 * @param event packet
 * @return remote_name
 * @note: btstack_type N
 */
static inline const char * hci_event_remote_name_request_complete_get_remote_name(const uint8_t * event){
    return (const char *) &event[9];
}

/**
 * @brief Get field status from event HCI_EVENT_ENCRYPTION_CHANGE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_encryption_change_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field connection_handle from event HCI_EVENT_ENCRYPTION_CHANGE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_encryption_change_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field encryption_enabled from event HCI_EVENT_ENCRYPTION_CHANGE
 * @param event packet
 * @return encryption_enabled
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_encryption_change_get_encryption_enabled(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field status from event HCI_EVENT_CHANGE_CONNECTION_LINK_KEY_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_change_connection_link_key_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field connection_handle from event HCI_EVENT_CHANGE_CONNECTION_LINK_KEY_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_change_connection_link_key_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field status from event HCI_EVENT_MASTER_LINK_KEY_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_master_link_key_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field connection_handle from event HCI_EVENT_MASTER_LINK_KEY_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_master_link_key_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field key_flag from event HCI_EVENT_MASTER_LINK_KEY_COMPLETE
 * @param event packet
 * @return key_flag
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_master_link_key_complete_get_key_flag(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field status from event HCI_EVENT_READ_REMOTE_VERSION_INFORMATION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_read_remote_version_information_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field connection_handle from event HCI_EVENT_READ_REMOTE_VERSION_INFORMATION_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_read_remote_version_information_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field version from event HCI_EVENT_READ_REMOTE_VERSION_INFORMATION_COMPLETE
 * @param event packet
 * @return version
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_read_remote_version_information_complete_get_version(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field manufacturer_name from event HCI_EVENT_READ_REMOTE_VERSION_INFORMATION_COMPLETE
 * @param event packet
 * @return manufacturer_name
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_read_remote_version_information_complete_get_manufacturer_name(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field subversion from event HCI_EVENT_READ_REMOTE_VERSION_INFORMATION_COMPLETE
 * @param event packet
 * @return subversion
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_read_remote_version_information_complete_get_subversion(const uint8_t * event){
    return little_endian_read_16(event, 8);
}

/**
 * @brief Get field num_hci_command_packets from event HCI_EVENT_COMMAND_COMPLETE
 * @param event packet
 * @return num_hci_command_packets
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_command_complete_get_num_hci_command_packets(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field command_opcode from event HCI_EVENT_COMMAND_COMPLETE
 * @param event packet
 * @return command_opcode
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_command_complete_get_command_opcode(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field return_parameters from event HCI_EVENT_COMMAND_COMPLETE
 * @param event packet
 * @return return_parameters
 * @note: btstack_type R
 */
static inline const uint8_t * hci_event_command_complete_get_return_parameters(const uint8_t * event){
    return &event[5];
}

/**
 * @brief Get field status from event HCI_EVENT_COMMAND_STATUS
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_command_status_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field num_hci_command_packets from event HCI_EVENT_COMMAND_STATUS
 * @param event packet
 * @return num_hci_command_packets
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_command_status_get_num_hci_command_packets(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field command_opcode from event HCI_EVENT_COMMAND_STATUS
 * @param event packet
 * @return command_opcode
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_command_status_get_command_opcode(const uint8_t * event){
    return little_endian_read_16(event, 4);
}

/**
 * @brief Get field hardware_code from event HCI_EVENT_HARDWARE_ERROR
 * @param event packet
 * @return hardware_code
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_hardware_error_get_hardware_code(const uint8_t * event){
    return event[2];
}

/**
 * @brief Get field handle from event HCI_EVENT_FLUSH_OCCURRED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_flush_occurred_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}

/**
 * @brief Get field status from event HCI_EVENT_ROLE_CHANGE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_role_change_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field bd_addr from event HCI_EVENT_ROLE_CHANGE
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_role_change_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[3], bd_addr, 6);
}
/**
 * @brief Get field role from event HCI_EVENT_ROLE_CHANGE
 * @param event packet
 * @return role
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_role_change_get_role(const uint8_t * event){
    return event[9];
}

/**
 * @brief Get field status from event HCI_EVENT_MODE_CHANGE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_mode_change_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field handle from event HCI_EVENT_MODE_CHANGE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_mode_change_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field mode from event HCI_EVENT_MODE_CHANGE
 * @param event packet
 * @return mode
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_mode_change_get_mode(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field interval from event HCI_EVENT_MODE_CHANGE
 * @param event packet
 * @return interval
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_mode_change_get_interval(const uint8_t * event){
    return little_endian_read_16(event, 6);
}

/**
 * @brief Get field bd_addr from event HCI_EVENT_PIN_CODE_REQUEST
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_pin_code_request_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}

/**
 * @brief Get field bd_addr from event HCI_EVENT_LINK_KEY_REQUEST
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_link_key_request_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}

/**
 * @brief Get field link_type from event HCI_EVENT_DATA_BUFFER_OVERFLOW
 * @param event packet
 * @return link_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_data_buffer_overflow_get_link_type(const uint8_t * event){
    return event[2];
}

/**
 * @brief Get field handle from event HCI_EVENT_MAX_SLOTS_CHANGED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_max_slots_changed_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field lmp_max_slots from event HCI_EVENT_MAX_SLOTS_CHANGED
 * @param event packet
 * @return lmp_max_slots
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_max_slots_changed_get_lmp_max_slots(const uint8_t * event){
    return event[4];
}

/**
 * @brief Get field status from event HCI_EVENT_READ_CLOCK_OFFSET_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_read_clock_offset_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field handle from event HCI_EVENT_READ_CLOCK_OFFSET_COMPLETE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_read_clock_offset_complete_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field clock_offset from event HCI_EVENT_READ_CLOCK_OFFSET_COMPLETE
 * @param event packet
 * @return clock_offset
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_read_clock_offset_complete_get_clock_offset(const uint8_t * event){
    return little_endian_read_16(event, 5);
}

/**
 * @brief Get field status from event HCI_EVENT_CONNECTION_PACKET_TYPE_CHANGED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_connection_packet_type_changed_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field handle from event HCI_EVENT_CONNECTION_PACKET_TYPE_CHANGED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_connection_packet_type_changed_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field packet_types from event HCI_EVENT_CONNECTION_PACKET_TYPE_CHANGED
 * @param event packet
 * @return packet_types
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_connection_packet_type_changed_get_packet_types(const uint8_t * event){
    return little_endian_read_16(event, 5);
}

/**
 * @brief Get field handle from event HCI_EVENT_QOS_VIOLATION
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_qos_violation_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}

/**
 * @brief Get field handle from event HCI_EVENT_PAGE_SCAN_REPETITION_MODE_CHANGE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_page_scan_repetition_mode_change_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field page_scan_repetition_mode from event HCI_EVENT_PAGE_SCAN_REPETITION_MODE_CHANGE
 * @param event packet
 * @return page_scan_repetition_mode
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_page_scan_repetition_mode_change_get_page_scan_repetition_mode(const uint8_t * event){
    return event[4];
}

/**
 * @brief Get field status from event HCI_EVENT_FLOW_SPECIFICATION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_flow_specification_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field handle from event HCI_EVENT_FLOW_SPECIFICATION_COMPLETE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_flow_specification_complete_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field unused from event HCI_EVENT_FLOW_SPECIFICATION_COMPLETE
 * @param event packet
 * @return unused
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_flow_specification_complete_get_unused(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field flow_direction from event HCI_EVENT_FLOW_SPECIFICATION_COMPLETE
 * @param event packet
 * @return flow_direction
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_flow_specification_complete_get_flow_direction(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field service_type from event HCI_EVENT_FLOW_SPECIFICATION_COMPLETE
 * @param event packet
 * @return service_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_flow_specification_complete_get_service_type(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field token_rate from event HCI_EVENT_FLOW_SPECIFICATION_COMPLETE
 * @param event packet
 * @return token_rate
 * @note: btstack_type 4
 */
static inline uint32_t hci_event_flow_specification_complete_get_token_rate(const uint8_t * event){
    return little_endian_read_32(event, 8);
}
/**
 * @brief Get field token_bucket_size from event HCI_EVENT_FLOW_SPECIFICATION_COMPLETE
 * @param event packet
 * @return token_bucket_size
 * @note: btstack_type 4
 */
static inline uint32_t hci_event_flow_specification_complete_get_token_bucket_size(const uint8_t * event){
    return little_endian_read_32(event, 12);
}
/**
 * @brief Get field peak_bandwidth from event HCI_EVENT_FLOW_SPECIFICATION_COMPLETE
 * @param event packet
 * @return peak_bandwidth
 * @note: btstack_type 4
 */
static inline uint32_t hci_event_flow_specification_complete_get_peak_bandwidth(const uint8_t * event){
    return little_endian_read_32(event, 16);
}
/**
 * @brief Get field access_latency from event HCI_EVENT_FLOW_SPECIFICATION_COMPLETE
 * @param event packet
 * @return access_latency
 * @note: btstack_type 4
 */
static inline uint32_t hci_event_flow_specification_complete_get_access_latency(const uint8_t * event){
    return little_endian_read_32(event, 20);
}

/**
 * @brief Get field num_responses from event HCI_EVENT_INQUIRY_RESULT_WITH_RSSI
 * @param event packet
 * @return num_responses
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_inquiry_result_with_rssi_get_num_responses(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field bd_addr from event HCI_EVENT_INQUIRY_RESULT_WITH_RSSI
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_inquiry_result_with_rssi_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[3], bd_addr, 6);
}
/**
 * @brief Get field page_scan_repetition_mode from event HCI_EVENT_INQUIRY_RESULT_WITH_RSSI
 * @param event packet
 * @return page_scan_repetition_mode
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_inquiry_result_with_rssi_get_page_scan_repetition_mode(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field reserved from event HCI_EVENT_INQUIRY_RESULT_WITH_RSSI
 * @param event packet
 * @return reserved
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_inquiry_result_with_rssi_get_reserved(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field class_of_device from event HCI_EVENT_INQUIRY_RESULT_WITH_RSSI
 * @param event packet
 * @return class_of_device
 * @note: btstack_type 3
 */
static inline uint32_t hci_event_inquiry_result_with_rssi_get_class_of_device(const uint8_t * event){
    return little_endian_read_24(event, 11);
}
/**
 * @brief Get field clock_offset from event HCI_EVENT_INQUIRY_RESULT_WITH_RSSI
 * @param event packet
 * @return clock_offset
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_inquiry_result_with_rssi_get_clock_offset(const uint8_t * event){
    return little_endian_read_16(event, 14);
}
/**
 * @brief Get field rssi from event HCI_EVENT_INQUIRY_RESULT_WITH_RSSI
 * @param event packet
 * @return rssi
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_inquiry_result_with_rssi_get_rssi(const uint8_t * event){
    return event[16];
}

/**
 * @brief Get field status from event HCI_EVENT_SYNCHRONOUS_CONNECTION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_synchronous_connection_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field handle from event HCI_EVENT_SYNCHRONOUS_CONNECTION_COMPLETE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_synchronous_connection_complete_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field bd_addr from event HCI_EVENT_SYNCHRONOUS_CONNECTION_COMPLETE
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_synchronous_connection_complete_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[5], bd_addr, 6);
}
/**
 * @brief Get field link_type from event HCI_EVENT_SYNCHRONOUS_CONNECTION_COMPLETE
 * @param event packet
 * @return link_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_synchronous_connection_complete_get_link_type(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field transmission_interval from event HCI_EVENT_SYNCHRONOUS_CONNECTION_COMPLETE
 * @param event packet
 * @return transmission_interval
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_synchronous_connection_complete_get_transmission_interval(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field retransmission_interval from event HCI_EVENT_SYNCHRONOUS_CONNECTION_COMPLETE
 * @param event packet
 * @return retransmission_interval
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_synchronous_connection_complete_get_retransmission_interval(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field rx_packet_length from event HCI_EVENT_SYNCHRONOUS_CONNECTION_COMPLETE
 * @param event packet
 * @return rx_packet_length
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_synchronous_connection_complete_get_rx_packet_length(const uint8_t * event){
    return little_endian_read_16(event, 14);
}
/**
 * @brief Get field tx_packet_length from event HCI_EVENT_SYNCHRONOUS_CONNECTION_COMPLETE
 * @param event packet
 * @return tx_packet_length
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_synchronous_connection_complete_get_tx_packet_length(const uint8_t * event){
    return little_endian_read_16(event, 16);
}
/**
 * @brief Get field air_mode from event HCI_EVENT_SYNCHRONOUS_CONNECTION_COMPLETE
 * @param event packet
 * @return air_mode
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_synchronous_connection_complete_get_air_mode(const uint8_t * event){
    return event[18];
}

/**
 * @brief Get field status from event HCI_EVENT_SYNCHRONOUS_CONNECTION_CHANGED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_synchronous_connection_changed_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field handle from event HCI_EVENT_SYNCHRONOUS_CONNECTION_CHANGED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_synchronous_connection_changed_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field transmission_interval from event HCI_EVENT_SYNCHRONOUS_CONNECTION_CHANGED
 * @param event packet
 * @return transmission_interval
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_synchronous_connection_changed_get_transmission_interval(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field retransmission_interval from event HCI_EVENT_SYNCHRONOUS_CONNECTION_CHANGED
 * @param event packet
 * @return retransmission_interval
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_synchronous_connection_changed_get_retransmission_interval(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field rx_packet_length from event HCI_EVENT_SYNCHRONOUS_CONNECTION_CHANGED
 * @param event packet
 * @return rx_packet_length
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_synchronous_connection_changed_get_rx_packet_length(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field tx_packet_length from event HCI_EVENT_SYNCHRONOUS_CONNECTION_CHANGED
 * @param event packet
 * @return tx_packet_length
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_synchronous_connection_changed_get_tx_packet_length(const uint8_t * event){
    return little_endian_read_16(event, 9);
}

/**
 * @brief Get field status from event HCI_EVENT_SNIFF_SUBRATING
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_sniff_subrating_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field handle from event HCI_EVENT_SNIFF_SUBRATING
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_sniff_subrating_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field max_tx_latency from event HCI_EVENT_SNIFF_SUBRATING
 * @param event packet
 * @return max_tx_latency
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_sniff_subrating_get_max_tx_latency(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field max_rx_latency from event HCI_EVENT_SNIFF_SUBRATING
 * @param event packet
 * @return max_rx_latency
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_sniff_subrating_get_max_rx_latency(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field min_remote_timeout from event HCI_EVENT_SNIFF_SUBRATING
 * @param event packet
 * @return min_remote_timeout
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_sniff_subrating_get_min_remote_timeout(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field min_local_timeout from event HCI_EVENT_SNIFF_SUBRATING
 * @param event packet
 * @return min_local_timeout
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_sniff_subrating_get_min_local_timeout(const uint8_t * event){
    return little_endian_read_16(event, 11);
}

/**
 * @brief Get field num_responses from event HCI_EVENT_EXTENDED_INQUIRY_RESPONSE
 * @param event packet
 * @return num_responses
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_extended_inquiry_response_get_num_responses(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field bd_addr from event HCI_EVENT_EXTENDED_INQUIRY_RESPONSE
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_extended_inquiry_response_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[3], bd_addr, 6);
}
/**
 * @brief Get field page_scan_repetition_mode from event HCI_EVENT_EXTENDED_INQUIRY_RESPONSE
 * @param event packet
 * @return page_scan_repetition_mode
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_extended_inquiry_response_get_page_scan_repetition_mode(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field reserved from event HCI_EVENT_EXTENDED_INQUIRY_RESPONSE
 * @param event packet
 * @return reserved
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_extended_inquiry_response_get_reserved(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field class_of_device from event HCI_EVENT_EXTENDED_INQUIRY_RESPONSE
 * @param event packet
 * @return class_of_device
 * @note: btstack_type 3
 */
static inline uint32_t hci_event_extended_inquiry_response_get_class_of_device(const uint8_t * event){
    return little_endian_read_24(event, 11);
}
/**
 * @brief Get field clock_offset from event HCI_EVENT_EXTENDED_INQUIRY_RESPONSE
 * @param event packet
 * @return clock_offset
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_extended_inquiry_response_get_clock_offset(const uint8_t * event){
    return little_endian_read_16(event, 14);
}
/**
 * @brief Get field rssi from event HCI_EVENT_EXTENDED_INQUIRY_RESPONSE
 * @param event packet
 * @return rssi
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_extended_inquiry_response_get_rssi(const uint8_t * event){
    return event[16];
}

/**
 * @brief Get field status from event HCI_EVENT_ENCRYPTION_KEY_REFRESH_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_encryption_key_refresh_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field handle from event HCI_EVENT_ENCRYPTION_KEY_REFRESH_COMPLETE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_encryption_key_refresh_complete_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field bd_addr from event HCI_EVENT_IO_CAPABILITY_REQUEST
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_io_capability_request_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}

/**
 * @brief Get field bd_addr from event HCI_EVENT_IO_CAPABILITY_RESPONSE
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_io_capability_response_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}
/**
 * @brief Get field io_capability from event HCI_EVENT_IO_CAPABILITY_RESPONSE
 * @param event packet
 * @return io_capability
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_io_capability_response_get_io_capability(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field oob_data_present from event HCI_EVENT_IO_CAPABILITY_RESPONSE
 * @param event packet
 * @return oob_data_present
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_io_capability_response_get_oob_data_present(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field authentication_requirements from event HCI_EVENT_IO_CAPABILITY_RESPONSE
 * @param event packet
 * @return authentication_requirements
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_io_capability_response_get_authentication_requirements(const uint8_t * event){
    return event[10];
}

/**
 * @brief Get field bd_addr from event HCI_EVENT_USER_CONFIRMATION_REQUEST
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_user_confirmation_request_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}
/**
 * @brief Get field numeric_value from event HCI_EVENT_USER_CONFIRMATION_REQUEST
 * @param event packet
 * @return numeric_value
 * @note: btstack_type 4
 */
static inline uint32_t hci_event_user_confirmation_request_get_numeric_value(const uint8_t * event){
    return little_endian_read_32(event, 8);
}

/**
 * @brief Get field bd_addr from event HCI_EVENT_USER_PASSKEY_REQUEST
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_user_passkey_request_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}

/**
 * @brief Get field bd_addr from event HCI_EVENT_REMOTE_OOB_DATA_REQUEST
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_remote_oob_data_request_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}

/**
 * @brief Get field status from event HCI_EVENT_SIMPLE_PAIRING_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_simple_pairing_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field bd_addr from event HCI_EVENT_SIMPLE_PAIRING_COMPLETE
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_simple_pairing_complete_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[3], bd_addr, 6);
}

/**
 * @brief Get field handle from event HCI_EVENT_LINK_SUPERVISION_TIMEOUT_CHANGED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_link_supervision_timeout_changed_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field link_supervision_timeout from event HCI_EVENT_LINK_SUPERVISION_TIMEOUT_CHANGED
 * @param event packet
 * @return link_supervision_timeout
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_link_supervision_timeout_changed_get_link_supervision_timeout(const uint8_t * event){
    return little_endian_read_16(event, 4);
}

/**
 * @brief Get field handle from event HCI_EVENT_ENHANCED_FLUSH_COMPLETE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_enhanced_flush_complete_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}

/**
 * @brief Get field bd_addr from event HCI_EVENT_USER_PASSKEY_NOTIFICATION
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_user_passkey_notification_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}
/**
 * @brief Get field numeric_value from event HCI_EVENT_USER_PASSKEY_NOTIFICATION
 * @param event packet
 * @return numeric_value
 * @note: btstack_type 4
 */
static inline uint32_t hci_event_user_passkey_notification_get_numeric_value(const uint8_t * event){
    return little_endian_read_32(event, 8);
}

/**
 * @brief Get field bd_addr from event HCI_EVENT_KEYPRESS_NOTIFICATION
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hci_event_keypress_notification_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}
/**
 * @brief Get field notification_type from event HCI_EVENT_KEYPRESS_NOTIFICATION
 * @param event packet
 * @return notification_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_keypress_notification_get_notification_type(const uint8_t * event){
    return event[8];
}

/**
 * @brief Get field status from event HCI_EVENT_ENCRYPTION_CHANGE_V2
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_encryption_change_v2_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field connection_handle from event HCI_EVENT_ENCRYPTION_CHANGE_V2
 * @param event packet
 * @return connection_handle
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_encryption_change_v2_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field encryption_enabled from event HCI_EVENT_ENCRYPTION_CHANGE_V2
 * @param event packet
 * @return encryption_enabled
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_encryption_change_v2_get_encryption_enabled(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field encryption_key_size from event HCI_EVENT_ENCRYPTION_CHANGE_V2
 * @param event packet
 * @return encryption_key_size
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_encryption_change_v2_get_encryption_key_size(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field state from event BTSTACK_EVENT_STATE
 * @param event packet
 * @return state
 * @note: btstack_type 1
 */
static inline uint8_t btstack_event_state_get_state(const uint8_t * event){
    return event[2];
}

/**
 * @brief Get field number_connections from event BTSTACK_EVENT_NR_CONNECTIONS_CHANGED
 * @param event packet
 * @return number_connections
 * @note: btstack_type 1
 */
static inline uint8_t btstack_event_nr_connections_changed_get_number_connections(const uint8_t * event){
    return event[2];
}


/**
 * @brief Get field discoverable from event BTSTACK_EVENT_SCAN_MODE_CHANGED
 * @param event packet
 * @return discoverable
 * @note: btstack_type 1
 */
static inline uint8_t btstack_event_scan_mode_changed_get_discoverable(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field connectable from event BTSTACK_EVENT_SCAN_MODE_CHANGED
 * @param event packet
 * @return connectable
 * @note: btstack_type 1
 */
static inline uint8_t btstack_event_scan_mode_changed_get_connectable(const uint8_t * event){
    return event[3];
}

/**
 * @brief Get field active from event HCI_EVENT_TRANSPORT_SLEEP_MODE
 * @param event packet
 * @return active
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_transport_sleep_mode_get_active(const uint8_t * event){
    return event[2];
}

/**
 * @brief Get field vendor_id from event HCI_EVENT_TRANSPORT_USB_INFO
 * @param event packet
 * @return vendor_id
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_transport_usb_info_get_vendor_id(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field product_id from event HCI_EVENT_TRANSPORT_USB_INFO
 * @param event packet
 * @return product_id
 * @note: btstack_type 2
 */
static inline uint16_t hci_event_transport_usb_info_get_product_id(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field path_len from event HCI_EVENT_TRANSPORT_USB_INFO
 * @param event packet
 * @return path_len
 * @note: btstack_type J
 */
static inline uint8_t hci_event_transport_usb_info_get_path_len(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field path from event HCI_EVENT_TRANSPORT_USB_INFO
 * @param event packet
 * @return path
 * @note: btstack_type V
 */
static inline const uint8_t * hci_event_transport_usb_info_get_path(const uint8_t * event){
    return &event[7];
}

/**
 * @brief Get field big_handle from event HCI_EVENT_BIS_CAN_SEND_NOW
 * @param event packet
 * @return big_handle
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_bis_can_send_now_get_big_handle(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field bis_index from event HCI_EVENT_BIS_CAN_SEND_NOW
 * @param event packet
 * @return bis_index
 * @note: btstack_type 1
 */
static inline uint8_t hci_event_bis_can_send_now_get_bis_index(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field con_handle from event HCI_EVENT_BIS_CAN_SEND_NOW
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_bis_can_send_now_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}

/**
 * @brief Get field cis_con_handle from event HCI_EVENT_CIS_CAN_SEND_NOW
 * @param event packet
 * @return cis_con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_event_cis_can_send_now_get_cis_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}


/**
 * @brief Get field status from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_channel_opened_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field address from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void l2cap_event_channel_opened_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[3], address, 6);
}
/**
 * @brief Get field handle from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t l2cap_event_channel_opened_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field psm from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return psm
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_channel_opened_get_psm(const uint8_t * event){
    return little_endian_read_16(event, 11);
}
/**
 * @brief Get field local_cid from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_channel_opened_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 13);
}
/**
 * @brief Get field remote_cid from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return remote_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_channel_opened_get_remote_cid(const uint8_t * event){
    return little_endian_read_16(event, 15);
}
/**
 * @brief Get field local_mtu from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return local_mtu
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_channel_opened_get_local_mtu(const uint8_t * event){
    return little_endian_read_16(event, 17);
}
/**
 * @brief Get field remote_mtu from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return remote_mtu
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_channel_opened_get_remote_mtu(const uint8_t * event){
    return little_endian_read_16(event, 19);
}
/**
 * @brief Get field flush_timeout from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return flush_timeout
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_channel_opened_get_flush_timeout(const uint8_t * event){
    return little_endian_read_16(event, 21);
}
/**
 * @brief Get field incoming from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return incoming
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_channel_opened_get_incoming(const uint8_t * event){
    return event[23];
}
/**
 * @brief Get field mode from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return mode
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_channel_opened_get_mode(const uint8_t * event){
    return event[24];
}
/**
 * @brief Get field fcs from event L2CAP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return fcs
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_channel_opened_get_fcs(const uint8_t * event){
    return event[25];
}

/**
 * @brief Get field local_cid from event L2CAP_EVENT_CHANNEL_CLOSED
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_channel_closed_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}

/**
 * @brief Get field address from event L2CAP_EVENT_INCOMING_CONNECTION
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void l2cap_event_incoming_connection_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[2], address, 6);
}
/**
 * @brief Get field handle from event L2CAP_EVENT_INCOMING_CONNECTION
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t l2cap_event_incoming_connection_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field psm from event L2CAP_EVENT_INCOMING_CONNECTION
 * @param event packet
 * @return psm
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_incoming_connection_get_psm(const uint8_t * event){
    return little_endian_read_16(event, 10);
}
/**
 * @brief Get field local_cid from event L2CAP_EVENT_INCOMING_CONNECTION
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_incoming_connection_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field remote_cid from event L2CAP_EVENT_INCOMING_CONNECTION
 * @param event packet
 * @return remote_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_incoming_connection_get_remote_cid(const uint8_t * event){
    return little_endian_read_16(event, 14);
}

/**
 * @brief Get field handle from event L2CAP_EVENT_CONNECTION_PARAMETER_UPDATE_REQUEST
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t l2cap_event_connection_parameter_update_request_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field interval_min from event L2CAP_EVENT_CONNECTION_PARAMETER_UPDATE_REQUEST
 * @param event packet
 * @return interval_min
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_connection_parameter_update_request_get_interval_min(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field interval_max from event L2CAP_EVENT_CONNECTION_PARAMETER_UPDATE_REQUEST
 * @param event packet
 * @return interval_max
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_connection_parameter_update_request_get_interval_max(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field latency from event L2CAP_EVENT_CONNECTION_PARAMETER_UPDATE_REQUEST
 * @param event packet
 * @return latency
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_connection_parameter_update_request_get_latency(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field timeout_multiplier from event L2CAP_EVENT_CONNECTION_PARAMETER_UPDATE_REQUEST
 * @param event packet
 * @return timeout_multiplier
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_connection_parameter_update_request_get_timeout_multiplier(const uint8_t * event){
    return little_endian_read_16(event, 10);
}

/**
 * @brief Get field handle from event L2CAP_EVENT_CONNECTION_PARAMETER_UPDATE_RESPONSE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t l2cap_event_connection_parameter_update_response_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field result from event L2CAP_EVENT_CONNECTION_PARAMETER_UPDATE_RESPONSE
 * @param event packet
 * @return result
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_connection_parameter_update_response_get_result(const uint8_t * event){
    return little_endian_read_16(event, 4);
}

/**
 * @brief Get field con_handle from event L2CAP_EVENT_INFORMATION_RESPONSE
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t l2cap_event_information_response_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field extended_feature_mask from event L2CAP_EVENT_INFORMATION_RESPONSE
 * @param event packet
 * @return extended_feature_mask
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_information_response_get_extended_feature_mask(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field fixed_channels_supported from event L2CAP_EVENT_INFORMATION_RESPONSE
 * @param event packet
 * @return fixed_channels_supported
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_information_response_get_fixed_channels_supported(const uint8_t * event){
    return little_endian_read_16(event, 6);
}

/**
 * @brief Get field local_cid from event L2CAP_EVENT_CAN_SEND_NOW
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_can_send_now_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}

/**
 * @brief Get field local_cid from event L2CAP_EVENT_PACKET_SENT
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_packet_sent_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}

/**
 * @brief Get field local_cid from event L2CAP_EVENT_ERTM_BUFFER_RELEASED
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ertm_buffer_released_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}

/**
 * @brief Get field address_type from event L2CAP_EVENT_CBM_INCOMING_CONNECTION
 * @param event packet
 * @return address_type
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_cbm_incoming_connection_get_address_type(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field address from event L2CAP_EVENT_CBM_INCOMING_CONNECTION
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void l2cap_event_cbm_incoming_connection_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[3], address, 6);
}
/**
 * @brief Get field handle from event L2CAP_EVENT_CBM_INCOMING_CONNECTION
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t l2cap_event_cbm_incoming_connection_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field psm from event L2CAP_EVENT_CBM_INCOMING_CONNECTION
 * @param event packet
 * @return psm
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_cbm_incoming_connection_get_psm(const uint8_t * event){
    return little_endian_read_16(event, 11);
}
/**
 * @brief Get field local_cid from event L2CAP_EVENT_CBM_INCOMING_CONNECTION
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_cbm_incoming_connection_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 13);
}
/**
 * @brief Get field remote_cid from event L2CAP_EVENT_CBM_INCOMING_CONNECTION
 * @param event packet
 * @return remote_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_cbm_incoming_connection_get_remote_cid(const uint8_t * event){
    return little_endian_read_16(event, 15);
}
/**
 * @brief Get field remote_mtu from event L2CAP_EVENT_CBM_INCOMING_CONNECTION
 * @param event packet
 * @return remote_mtu
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_cbm_incoming_connection_get_remote_mtu(const uint8_t * event){
    return little_endian_read_16(event, 17);
}

/**
 * @brief Get field status from event L2CAP_EVENT_CBM_CHANNEL_OPENED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_cbm_channel_opened_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field address_type from event L2CAP_EVENT_CBM_CHANNEL_OPENED
 * @param event packet
 * @return address_type
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_cbm_channel_opened_get_address_type(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field address from event L2CAP_EVENT_CBM_CHANNEL_OPENED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void l2cap_event_cbm_channel_opened_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[4], address, 6);
}
/**
 * @brief Get field handle from event L2CAP_EVENT_CBM_CHANNEL_OPENED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t l2cap_event_cbm_channel_opened_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 10);
}
/**
 * @brief Get field incoming from event L2CAP_EVENT_CBM_CHANNEL_OPENED
 * @param event packet
 * @return incoming
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_cbm_channel_opened_get_incoming(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field psm from event L2CAP_EVENT_CBM_CHANNEL_OPENED
 * @param event packet
 * @return psm
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_cbm_channel_opened_get_psm(const uint8_t * event){
    return little_endian_read_16(event, 13);
}
/**
 * @brief Get field local_cid from event L2CAP_EVENT_CBM_CHANNEL_OPENED
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_cbm_channel_opened_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 15);
}
/**
 * @brief Get field remote_cid from event L2CAP_EVENT_CBM_CHANNEL_OPENED
 * @param event packet
 * @return remote_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_cbm_channel_opened_get_remote_cid(const uint8_t * event){
    return little_endian_read_16(event, 17);
}
/**
 * @brief Get field local_mtu from event L2CAP_EVENT_CBM_CHANNEL_OPENED
 * @param event packet
 * @return local_mtu
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_cbm_channel_opened_get_local_mtu(const uint8_t * event){
    return little_endian_read_16(event, 19);
}
/**
 * @brief Get field remote_mtu from event L2CAP_EVENT_CBM_CHANNEL_OPENED
 * @param event packet
 * @return remote_mtu
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_cbm_channel_opened_get_remote_mtu(const uint8_t * event){
    return little_endian_read_16(event, 21);
}


/**
 * @brief Get field address_type from event L2CAP_EVENT_ECBM_INCOMING_CONNECTION
 * @param event packet
 * @return address_type
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_ecbm_incoming_connection_get_address_type(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field address from event L2CAP_EVENT_ECBM_INCOMING_CONNECTION
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void l2cap_event_ecbm_incoming_connection_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[3], address, 6);
}
/**
 * @brief Get field handle from event L2CAP_EVENT_ECBM_INCOMING_CONNECTION
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t l2cap_event_ecbm_incoming_connection_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field psm from event L2CAP_EVENT_ECBM_INCOMING_CONNECTION
 * @param event packet
 * @return psm
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_incoming_connection_get_psm(const uint8_t * event){
    return little_endian_read_16(event, 11);
}
/**
 * @brief Get field num_channels from event L2CAP_EVENT_ECBM_INCOMING_CONNECTION
 * @param event packet
 * @return num_channels
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_ecbm_incoming_connection_get_num_channels(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field local_cid from event L2CAP_EVENT_ECBM_INCOMING_CONNECTION
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_incoming_connection_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 14);
}

/**
 * @brief Get field status from event L2CAP_EVENT_ECBM_CHANNEL_OPENED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_ecbm_channel_opened_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field address_type from event L2CAP_EVENT_ECBM_CHANNEL_OPENED
 * @param event packet
 * @return address_type
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_ecbm_channel_opened_get_address_type(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field address from event L2CAP_EVENT_ECBM_CHANNEL_OPENED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void l2cap_event_ecbm_channel_opened_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[4], address, 6);
}
/**
 * @brief Get field handle from event L2CAP_EVENT_ECBM_CHANNEL_OPENED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t l2cap_event_ecbm_channel_opened_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 10);
}
/**
 * @brief Get field incoming from event L2CAP_EVENT_ECBM_CHANNEL_OPENED
 * @param event packet
 * @return incoming
 * @note: btstack_type 1
 */
static inline uint8_t l2cap_event_ecbm_channel_opened_get_incoming(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field psm from event L2CAP_EVENT_ECBM_CHANNEL_OPENED
 * @param event packet
 * @return psm
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_channel_opened_get_psm(const uint8_t * event){
    return little_endian_read_16(event, 13);
}
/**
 * @brief Get field local_cid from event L2CAP_EVENT_ECBM_CHANNEL_OPENED
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_channel_opened_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 15);
}
/**
 * @brief Get field remote_cid from event L2CAP_EVENT_ECBM_CHANNEL_OPENED
 * @param event packet
 * @return remote_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_channel_opened_get_remote_cid(const uint8_t * event){
    return little_endian_read_16(event, 17);
}
/**
 * @brief Get field local_mtu from event L2CAP_EVENT_ECBM_CHANNEL_OPENED
 * @param event packet
 * @return local_mtu
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_channel_opened_get_local_mtu(const uint8_t * event){
    return little_endian_read_16(event, 19);
}
/**
 * @brief Get field remote_mtu from event L2CAP_EVENT_ECBM_CHANNEL_OPENED
 * @param event packet
 * @return remote_mtu
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_channel_opened_get_remote_mtu(const uint8_t * event){
    return little_endian_read_16(event, 21);
}

/**
 * @brief Get field remote_cid from event L2CAP_EVENT_ECBM_RECONFIGURED
 * @param event packet
 * @return remote_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_reconfigured_get_remote_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field mtu from event L2CAP_EVENT_ECBM_RECONFIGURED
 * @param event packet
 * @return mtu
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_reconfigured_get_mtu(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field mps from event L2CAP_EVENT_ECBM_RECONFIGURED
 * @param event packet
 * @return mps
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_reconfigured_get_mps(const uint8_t * event){
    return little_endian_read_16(event, 6);
}

/**
 * @brief Get field local_cid from event L2CAP_EVENT_ECBM_RECONFIGURATION_COMPLETE
 * @param event packet
 * @return local_cid
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_reconfiguration_complete_get_local_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field reconfigure_result from event L2CAP_EVENT_ECBM_RECONFIGURATION_COMPLETE
 * @param event packet
 * @return reconfigure_result
 * @note: btstack_type 2
 */
static inline uint16_t l2cap_event_ecbm_reconfiguration_complete_get_reconfigure_result(const uint8_t * event){
    return little_endian_read_16(event, 4);
}

/**
 * @brief Get field status from event RFCOMM_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t rfcomm_event_channel_opened_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field bd_addr from event RFCOMM_EVENT_CHANNEL_OPENED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void rfcomm_event_channel_opened_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[3], bd_addr, 6);
}
/**
 * @brief Get field con_handle from event RFCOMM_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t rfcomm_event_channel_opened_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field server_channel from event RFCOMM_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return server_channel
 * @note: btstack_type 1
 */
static inline uint8_t rfcomm_event_channel_opened_get_server_channel(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field rfcomm_cid from event RFCOMM_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return rfcomm_cid
 * @note: btstack_type 2
 */
static inline uint16_t rfcomm_event_channel_opened_get_rfcomm_cid(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field max_frame_size from event RFCOMM_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return max_frame_size
 * @note: btstack_type 2
 */
static inline uint16_t rfcomm_event_channel_opened_get_max_frame_size(const uint8_t * event){
    return little_endian_read_16(event, 14);
}
/**
 * @brief Get field incoming from event RFCOMM_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return incoming
 * @note: btstack_type 1
 */
static inline uint8_t rfcomm_event_channel_opened_get_incoming(const uint8_t * event){
    return event[16];
}

/**
 * @brief Get field rfcomm_cid from event RFCOMM_EVENT_CHANNEL_CLOSED
 * @param event packet
 * @return rfcomm_cid
 * @note: btstack_type 2
 */
static inline uint16_t rfcomm_event_channel_closed_get_rfcomm_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}

/**
 * @brief Get field bd_addr from event RFCOMM_EVENT_INCOMING_CONNECTION
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void rfcomm_event_incoming_connection_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}
/**
 * @brief Get field server_channel from event RFCOMM_EVENT_INCOMING_CONNECTION
 * @param event packet
 * @return server_channel
 * @note: btstack_type 1
 */
static inline uint8_t rfcomm_event_incoming_connection_get_server_channel(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field rfcomm_cid from event RFCOMM_EVENT_INCOMING_CONNECTION
 * @param event packet
 * @return rfcomm_cid
 * @note: btstack_type 2
 */
static inline uint16_t rfcomm_event_incoming_connection_get_rfcomm_cid(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field con_handle from event RFCOMM_EVENT_INCOMING_CONNECTION
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t rfcomm_event_incoming_connection_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 11);
}

/**
 * @brief Get field rfcomm_cid from event RFCOMM_EVENT_REMOTE_LINE_STATUS
 * @param event packet
 * @return rfcomm_cid
 * @note: btstack_type 2
 */
static inline uint16_t rfcomm_event_remote_line_status_get_rfcomm_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field line_status from event RFCOMM_EVENT_REMOTE_LINE_STATUS
 * @param event packet
 * @return line_status
 * @note: btstack_type 1
 */
static inline uint8_t rfcomm_event_remote_line_status_get_line_status(const uint8_t * event){
    return event[4];
}

/**
 * @brief Get field rfcomm_cid from event RFCOMM_EVENT_REMOTE_MODEM_STATUS
 * @param event packet
 * @return rfcomm_cid
 * @note: btstack_type 2
 */
static inline uint16_t rfcomm_event_remote_modem_status_get_rfcomm_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field modem_status from event RFCOMM_EVENT_REMOTE_MODEM_STATUS
 * @param event packet
 * @return modem_status
 * @note: btstack_type 1
 */
static inline uint8_t rfcomm_event_remote_modem_status_get_modem_status(const uint8_t * event){
    return event[4];
}

/**
 * @brief Get field rfcomm_cid from event RFCOMM_EVENT_CAN_SEND_NOW
 * @param event packet
 * @return rfcomm_cid
 * @note: btstack_type 2
 */
static inline uint16_t rfcomm_event_can_send_now_get_rfcomm_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}

/**
 * @brief Get field status from event SDP_EVENT_QUERY_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t sdp_event_query_complete_get_status(const uint8_t * event){
    return event[2];
}

/**
 * @brief Get field rfcomm_channel from event SDP_EVENT_QUERY_RFCOMM_SERVICE
 * @param event packet
 * @return rfcomm_channel
 * @note: btstack_type 1
 */
static inline uint8_t sdp_event_query_rfcomm_service_get_rfcomm_channel(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field name from event SDP_EVENT_QUERY_RFCOMM_SERVICE
 * @param event packet
 * @return name
 * @note: btstack_type T
 */
static inline const char * sdp_event_query_rfcomm_service_get_name(const uint8_t * event){
    return (const char *) &event[3];
}

/**
 * @brief Get field record_id from event SDP_EVENT_QUERY_ATTRIBUTE_BYTE
 * @param event packet
 * @return record_id
 * @note: btstack_type 2
 */
static inline uint16_t sdp_event_query_attribute_byte_get_record_id(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field attribute_id from event SDP_EVENT_QUERY_ATTRIBUTE_BYTE
 * @param event packet
 * @return attribute_id
 * @note: btstack_type 2
 */
static inline uint16_t sdp_event_query_attribute_byte_get_attribute_id(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field attribute_length from event SDP_EVENT_QUERY_ATTRIBUTE_BYTE
 * @param event packet
 * @return attribute_length
 * @note: btstack_type 2
 */
static inline uint16_t sdp_event_query_attribute_byte_get_attribute_length(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field data_offset from event SDP_EVENT_QUERY_ATTRIBUTE_BYTE
 * @param event packet
 * @return data_offset
 * @note: btstack_type 2
 */
static inline uint16_t sdp_event_query_attribute_byte_get_data_offset(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field data from event SDP_EVENT_QUERY_ATTRIBUTE_BYTE
 * @param event packet
 * @return data
 * @note: btstack_type 1
 */
static inline uint8_t sdp_event_query_attribute_byte_get_data(const uint8_t * event){
    return event[10];
}

/**
 * @brief Get field record_id from event SDP_EVENT_QUERY_ATTRIBUTE_VALUE
 * @param event packet
 * @return record_id
 * @note: btstack_type 2
 */
static inline uint16_t sdp_event_query_attribute_value_get_record_id(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field attribute_id from event SDP_EVENT_QUERY_ATTRIBUTE_VALUE
 * @param event packet
 * @return attribute_id
 * @note: btstack_type 2
 */
static inline uint16_t sdp_event_query_attribute_value_get_attribute_id(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field attribute_length from event SDP_EVENT_QUERY_ATTRIBUTE_VALUE
 * @param event packet
 * @return attribute_length
 * @note: btstack_type L
 */
static inline uint16_t sdp_event_query_attribute_value_get_attribute_length(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field attribute_value from event SDP_EVENT_QUERY_ATTRIBUTE_VALUE
 * @param event packet
 * @return attribute_value
 * @note: btstack_type V
 */
static inline const uint8_t * sdp_event_query_attribute_value_get_attribute_value(const uint8_t * event){
    return &event[8];
}

/**
 * @brief Get field total_count from event SDP_EVENT_QUERY_SERVICE_RECORD_HANDLE
 * @param event packet
 * @return total_count
 * @note: btstack_type 2
 */
static inline uint16_t sdp_event_query_service_record_handle_get_total_count(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field record_index from event SDP_EVENT_QUERY_SERVICE_RECORD_HANDLE
 * @param event packet
 * @return record_index
 * @note: btstack_type 2
 */
static inline uint16_t sdp_event_query_service_record_handle_get_record_index(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field record_handle from event SDP_EVENT_QUERY_SERVICE_RECORD_HANDLE
 * @param event packet
 * @return record_handle
 * @note: btstack_type 4
 */
static inline uint32_t sdp_event_query_service_record_handle_get_record_handle(const uint8_t * event){
    return little_endian_read_32(event, 6);
}

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_QUERY_COMPLETE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_query_complete_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field att_status from event GATT_EVENT_QUERY_COMPLETE
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gatt_event_query_complete_get_att_status(const uint8_t * event){
    return event[4];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_SERVICE_QUERY_RESULT
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_service_query_result_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field service from event GATT_EVENT_SERVICE_QUERY_RESULT
 * @param event packet
 * @param Pointer to storage for service
 * @note: btstack_type X
 */
static inline void gatt_event_service_query_result_get_service(const uint8_t * event, gatt_client_service_t * service){
    gatt_client_deserialize_service(event, 4, service);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_CHARACTERISTIC_QUERY_RESULT
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_characteristic_query_result_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field characteristic from event GATT_EVENT_CHARACTERISTIC_QUERY_RESULT
 * @param event packet
 * @param Pointer to storage for characteristic
 * @note: btstack_type Y
 */
static inline void gatt_event_characteristic_query_result_get_characteristic(const uint8_t * event, gatt_client_characteristic_t * characteristic){
    gatt_client_deserialize_characteristic(event, 4, characteristic);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_INCLUDED_SERVICE_QUERY_RESULT
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_included_service_query_result_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field include_handle from event GATT_EVENT_INCLUDED_SERVICE_QUERY_RESULT
 * @param event packet
 * @return include_handle
 * @note: btstack_type 2
 */
static inline uint16_t gatt_event_included_service_query_result_get_include_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field service from event GATT_EVENT_INCLUDED_SERVICE_QUERY_RESULT
 * @param event packet
 * @param Pointer to storage for service
 * @note: btstack_type X
 */
static inline void gatt_event_included_service_query_result_get_service(const uint8_t * event, gatt_client_service_t * service){
    gatt_client_deserialize_service(event, 6, service);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_ALL_CHARACTERISTIC_DESCRIPTORS_QUERY_RESULT
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_all_characteristic_descriptors_query_result_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field characteristic_descriptor from event GATT_EVENT_ALL_CHARACTERISTIC_DESCRIPTORS_QUERY_RESULT
 * @param event packet
 * @param Pointer to storage for characteristic_descriptor
 * @note: btstack_type Z
 */
static inline void gatt_event_all_characteristic_descriptors_query_result_get_characteristic_descriptor(const uint8_t * event, gatt_client_characteristic_descriptor_t * characteristic_descriptor){
    gatt_client_deserialize_characteristic_descriptor(event, 4, characteristic_descriptor);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_CHARACTERISTIC_VALUE_QUERY_RESULT
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_characteristic_value_query_result_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field value_handle from event GATT_EVENT_CHARACTERISTIC_VALUE_QUERY_RESULT
 * @param event packet
 * @return value_handle
 * @note: btstack_type 2
 */
static inline uint16_t gatt_event_characteristic_value_query_result_get_value_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field value_length from event GATT_EVENT_CHARACTERISTIC_VALUE_QUERY_RESULT
 * @param event packet
 * @return value_length
 * @note: btstack_type L
 */
static inline uint16_t gatt_event_characteristic_value_query_result_get_value_length(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field value from event GATT_EVENT_CHARACTERISTIC_VALUE_QUERY_RESULT
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * gatt_event_characteristic_value_query_result_get_value(const uint8_t * event){
    return &event[8];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_LONG_CHARACTERISTIC_VALUE_QUERY_RESULT
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_long_characteristic_value_query_result_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field value_handle from event GATT_EVENT_LONG_CHARACTERISTIC_VALUE_QUERY_RESULT
 * @param event packet
 * @return value_handle
 * @note: btstack_type 2
 */
static inline uint16_t gatt_event_long_characteristic_value_query_result_get_value_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field value_offset from event GATT_EVENT_LONG_CHARACTERISTIC_VALUE_QUERY_RESULT
 * @param event packet
 * @return value_offset
 * @note: btstack_type 2
 */
static inline uint16_t gatt_event_long_characteristic_value_query_result_get_value_offset(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field value_length from event GATT_EVENT_LONG_CHARACTERISTIC_VALUE_QUERY_RESULT
 * @param event packet
 * @return value_length
 * @note: btstack_type L
 */
static inline uint16_t gatt_event_long_characteristic_value_query_result_get_value_length(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field value from event GATT_EVENT_LONG_CHARACTERISTIC_VALUE_QUERY_RESULT
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * gatt_event_long_characteristic_value_query_result_get_value(const uint8_t * event){
    return &event[10];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_NOTIFICATION
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_notification_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field value_handle from event GATT_EVENT_NOTIFICATION
 * @param event packet
 * @return value_handle
 * @note: btstack_type 2
 */
static inline uint16_t gatt_event_notification_get_value_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field value_length from event GATT_EVENT_NOTIFICATION
 * @param event packet
 * @return value_length
 * @note: btstack_type L
 */
static inline uint16_t gatt_event_notification_get_value_length(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field value from event GATT_EVENT_NOTIFICATION
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * gatt_event_notification_get_value(const uint8_t * event){
    return &event[8];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_INDICATION
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_indication_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field value_handle from event GATT_EVENT_INDICATION
 * @param event packet
 * @return value_handle
 * @note: btstack_type 2
 */
static inline uint16_t gatt_event_indication_get_value_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field value_length from event GATT_EVENT_INDICATION
 * @param event packet
 * @return value_length
 * @note: btstack_type L
 */
static inline uint16_t gatt_event_indication_get_value_length(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field value from event GATT_EVENT_INDICATION
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * gatt_event_indication_get_value(const uint8_t * event){
    return &event[8];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_CHARACTERISTIC_DESCRIPTOR_QUERY_RESULT
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_characteristic_descriptor_query_result_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field descriptor_handle from event GATT_EVENT_CHARACTERISTIC_DESCRIPTOR_QUERY_RESULT
 * @param event packet
 * @return descriptor_handle
 * @note: btstack_type 2
 */
static inline uint16_t gatt_event_characteristic_descriptor_query_result_get_descriptor_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field descriptor_length from event GATT_EVENT_CHARACTERISTIC_DESCRIPTOR_QUERY_RESULT
 * @param event packet
 * @return descriptor_length
 * @note: btstack_type L
 */
static inline uint16_t gatt_event_characteristic_descriptor_query_result_get_descriptor_length(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field descriptor from event GATT_EVENT_CHARACTERISTIC_DESCRIPTOR_QUERY_RESULT
 * @param event packet
 * @return descriptor
 * @note: btstack_type V
 */
static inline const uint8_t * gatt_event_characteristic_descriptor_query_result_get_descriptor(const uint8_t * event){
    return &event[8];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_LONG_CHARACTERISTIC_DESCRIPTOR_QUERY_RESULT
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_long_characteristic_descriptor_query_result_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field descriptor_offset from event GATT_EVENT_LONG_CHARACTERISTIC_DESCRIPTOR_QUERY_RESULT
 * @param event packet
 * @return descriptor_offset
 * @note: btstack_type 2
 */
static inline uint16_t gatt_event_long_characteristic_descriptor_query_result_get_descriptor_offset(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field descriptor_length from event GATT_EVENT_LONG_CHARACTERISTIC_DESCRIPTOR_QUERY_RESULT
 * @param event packet
 * @return descriptor_length
 * @note: btstack_type L
 */
static inline uint16_t gatt_event_long_characteristic_descriptor_query_result_get_descriptor_length(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field descriptor from event GATT_EVENT_LONG_CHARACTERISTIC_DESCRIPTOR_QUERY_RESULT
 * @param event packet
 * @return descriptor
 * @note: btstack_type V
 */
static inline const uint8_t * gatt_event_long_characteristic_descriptor_query_result_get_descriptor(const uint8_t * event){
    return &event[8];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_MTU
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_mtu_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field MTU from event GATT_EVENT_MTU
 * @param event packet
 * @return MTU
 * @note: btstack_type 2
 */
static inline uint16_t gatt_event_mtu_get_MTU(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_CAN_WRITE_WITHOUT_RESPONSE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_can_write_without_response_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field status from event GATT_EVENT_CONNECTED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gatt_event_connected_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field address from event GATT_EVENT_CONNECTED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void gatt_event_connected_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[3], address, 6);
}
/**
 * @brief Get field handle from event GATT_EVENT_CONNECTED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_connected_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event GATT_EVENT_DISCONNECTED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gatt_event_disconnected_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
#endif

/**
 * @brief Get field address_type from event ATT_EVENT_CONNECTED
 * @param event packet
 * @return address_type
 * @note: btstack_type 1
 */
static inline uint8_t att_event_connected_get_address_type(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field address from event ATT_EVENT_CONNECTED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void att_event_connected_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[3], address, 6);
}
/**
 * @brief Get field handle from event ATT_EVENT_CONNECTED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t att_event_connected_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 9);
}

/**
 * @brief Get field handle from event ATT_EVENT_DISCONNECTED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t att_event_disconnected_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}

/**
 * @brief Get field handle from event ATT_EVENT_MTU_EXCHANGE_COMPLETE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t att_event_mtu_exchange_complete_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field MTU from event ATT_EVENT_MTU_EXCHANGE_COMPLETE
 * @param event packet
 * @return MTU
 * @note: btstack_type 2
 */
static inline uint16_t att_event_mtu_exchange_complete_get_MTU(const uint8_t * event){
    return little_endian_read_16(event, 4);
}

/**
 * @brief Get field status from event ATT_EVENT_HANDLE_VALUE_INDICATION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t att_event_handle_value_indication_complete_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field conn_handle from event ATT_EVENT_HANDLE_VALUE_INDICATION_COMPLETE
 * @param event packet
 * @return conn_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t att_event_handle_value_indication_complete_get_conn_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field attribute_handle from event ATT_EVENT_HANDLE_VALUE_INDICATION_COMPLETE
 * @param event packet
 * @return attribute_handle
 * @note: btstack_type 2
 */
static inline uint16_t att_event_handle_value_indication_complete_get_attribute_handle(const uint8_t * event){
    return little_endian_read_16(event, 5);
}


/**
 * @brief Get field status from event BNEP_EVENT_SERVICE_REGISTERED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t bnep_event_service_registered_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field service_uuid from event BNEP_EVENT_SERVICE_REGISTERED
 * @param event packet
 * @return service_uuid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_service_registered_get_service_uuid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field status from event BNEP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t bnep_event_channel_opened_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field bnep_cid from event BNEP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return bnep_cid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_channel_opened_get_bnep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field source_uuid from event BNEP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return source_uuid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_channel_opened_get_source_uuid(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field destination_uuid from event BNEP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return destination_uuid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_channel_opened_get_destination_uuid(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field mtu from event BNEP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return mtu
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_channel_opened_get_mtu(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field remote_address from event BNEP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @param Pointer to storage for remote_address
 * @note: btstack_type B
 */
static inline void bnep_event_channel_opened_get_remote_address(const uint8_t * event, bd_addr_t remote_address){
    reverse_bytes(&event[11], remote_address, 6);
}
/**
 * @brief Get field con_handle from event BNEP_EVENT_CHANNEL_OPENED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t bnep_event_channel_opened_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 17);
}

/**
 * @brief Get field bnep_cid from event BNEP_EVENT_CHANNEL_CLOSED
 * @param event packet
 * @return bnep_cid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_channel_closed_get_bnep_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field source_uuid from event BNEP_EVENT_CHANNEL_CLOSED
 * @param event packet
 * @return source_uuid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_channel_closed_get_source_uuid(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field destination_uuid from event BNEP_EVENT_CHANNEL_CLOSED
 * @param event packet
 * @return destination_uuid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_channel_closed_get_destination_uuid(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field remote_address from event BNEP_EVENT_CHANNEL_CLOSED
 * @param event packet
 * @param Pointer to storage for remote_address
 * @note: btstack_type B
 */
static inline void bnep_event_channel_closed_get_remote_address(const uint8_t * event, bd_addr_t remote_address){
    reverse_bytes(&event[8], remote_address, 6);
}

/**
 * @brief Get field bnep_cid from event BNEP_EVENT_CHANNEL_TIMEOUT
 * @param event packet
 * @return bnep_cid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_channel_timeout_get_bnep_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field source_uuid from event BNEP_EVENT_CHANNEL_TIMEOUT
 * @param event packet
 * @return source_uuid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_channel_timeout_get_source_uuid(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field destination_uuid from event BNEP_EVENT_CHANNEL_TIMEOUT
 * @param event packet
 * @return destination_uuid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_channel_timeout_get_destination_uuid(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field remote_address from event BNEP_EVENT_CHANNEL_TIMEOUT
 * @param event packet
 * @param Pointer to storage for remote_address
 * @note: btstack_type B
 */
static inline void bnep_event_channel_timeout_get_remote_address(const uint8_t * event, bd_addr_t remote_address){
    reverse_bytes(&event[8], remote_address, 6);
}
/**
 * @brief Get field channel_state from event BNEP_EVENT_CHANNEL_TIMEOUT
 * @param event packet
 * @return channel_state
 * @note: btstack_type 1
 */
static inline uint8_t bnep_event_channel_timeout_get_channel_state(const uint8_t * event){
    return event[14];
}

/**
 * @brief Get field bnep_cid from event BNEP_EVENT_CAN_SEND_NOW
 * @param event packet
 * @return bnep_cid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_can_send_now_get_bnep_cid(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field source_uuid from event BNEP_EVENT_CAN_SEND_NOW
 * @param event packet
 * @return source_uuid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_can_send_now_get_source_uuid(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field destination_uuid from event BNEP_EVENT_CAN_SEND_NOW
 * @param event packet
 * @return destination_uuid
 * @note: btstack_type 2
 */
static inline uint16_t bnep_event_can_send_now_get_destination_uuid(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field remote_address from event BNEP_EVENT_CAN_SEND_NOW
 * @param event packet
 * @param Pointer to storage for remote_address
 * @note: btstack_type B
 */
static inline void bnep_event_can_send_now_get_remote_address(const uint8_t * event, bd_addr_t remote_address){
    reverse_bytes(&event[8], remote_address, 6);
}

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_JUST_WORKS_REQUEST
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_just_works_request_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_JUST_WORKS_REQUEST
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_just_works_request_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_JUST_WORKS_REQUEST
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_just_works_request_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field secure_connection from event SM_EVENT_JUST_WORKS_REQUEST
 * @param event packet
 * @return secure_connection
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_just_works_request_get_secure_connection(const uint8_t * event){
    return event[11];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_PASSKEY_DISPLAY_NUMBER
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_passkey_display_number_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_PASSKEY_DISPLAY_NUMBER
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_passkey_display_number_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_PASSKEY_DISPLAY_NUMBER
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_passkey_display_number_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field secure_connection from event SM_EVENT_PASSKEY_DISPLAY_NUMBER
 * @param event packet
 * @return secure_connection
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_passkey_display_number_get_secure_connection(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field passkey from event SM_EVENT_PASSKEY_DISPLAY_NUMBER
 * @param event packet
 * @return passkey
 * @note: btstack_type 4
 */
static inline uint32_t sm_event_passkey_display_number_get_passkey(const uint8_t * event){
    return little_endian_read_32(event, 12);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_PASSKEY_DISPLAY_CANCEL
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_passkey_display_cancel_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_PASSKEY_DISPLAY_CANCEL
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_passkey_display_cancel_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_PASSKEY_DISPLAY_CANCEL
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_passkey_display_cancel_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_PASSKEY_INPUT_NUMBER
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_passkey_input_number_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_PASSKEY_INPUT_NUMBER
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_passkey_input_number_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_PASSKEY_INPUT_NUMBER
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_passkey_input_number_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field secure_connection from event SM_EVENT_PASSKEY_INPUT_NUMBER
 * @param event packet
 * @return secure_connection
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_passkey_input_number_get_secure_connection(const uint8_t * event){
    return event[11];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_NUMERIC_COMPARISON_REQUEST
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_numeric_comparison_request_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_NUMERIC_COMPARISON_REQUEST
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_numeric_comparison_request_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_NUMERIC_COMPARISON_REQUEST
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_numeric_comparison_request_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field secure_connection from event SM_EVENT_NUMERIC_COMPARISON_REQUEST
 * @param event packet
 * @return secure_connection
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_numeric_comparison_request_get_secure_connection(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field passkey from event SM_EVENT_NUMERIC_COMPARISON_REQUEST
 * @param event packet
 * @return passkey
 * @note: btstack_type 4
 */
static inline uint32_t sm_event_numeric_comparison_request_get_passkey(const uint8_t * event){
    return little_endian_read_32(event, 12);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_IDENTITY_RESOLVING_STARTED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_identity_resolving_started_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_IDENTITY_RESOLVING_STARTED
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_identity_resolving_started_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_IDENTITY_RESOLVING_STARTED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_identity_resolving_started_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_IDENTITY_RESOLVING_FAILED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_identity_resolving_failed_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_IDENTITY_RESOLVING_FAILED
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_identity_resolving_failed_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_IDENTITY_RESOLVING_FAILED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_identity_resolving_failed_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_IDENTITY_RESOLVING_SUCCEEDED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_identity_resolving_succeeded_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_IDENTITY_RESOLVING_SUCCEEDED
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_identity_resolving_succeeded_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_IDENTITY_RESOLVING_SUCCEEDED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_identity_resolving_succeeded_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field identity_addr_type from event SM_EVENT_IDENTITY_RESOLVING_SUCCEEDED
 * @param event packet
 * @return identity_addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_identity_resolving_succeeded_get_identity_addr_type(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field identity_address from event SM_EVENT_IDENTITY_RESOLVING_SUCCEEDED
 * @param event packet
 * @param Pointer to storage for identity_address
 * @note: btstack_type B
 */
static inline void sm_event_identity_resolving_succeeded_get_identity_address(const uint8_t * event, bd_addr_t identity_address){
    reverse_bytes(&event[12], identity_address, 6);
}
/**
 * @brief Get field index from event SM_EVENT_IDENTITY_RESOLVING_SUCCEEDED
 * @param event packet
 * @return index
 * @note: btstack_type 2
 */
static inline uint16_t sm_event_identity_resolving_succeeded_get_index(const uint8_t * event){
    return little_endian_read_16(event, 18);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_AUTHORIZATION_REQUEST
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_authorization_request_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_AUTHORIZATION_REQUEST
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_authorization_request_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_AUTHORIZATION_REQUEST
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_authorization_request_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_AUTHORIZATION_RESULT
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_authorization_result_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_AUTHORIZATION_RESULT
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_authorization_result_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_AUTHORIZATION_RESULT
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_authorization_result_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field authorization_result from event SM_EVENT_AUTHORIZATION_RESULT
 * @param event packet
 * @return authorization_result
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_authorization_result_get_authorization_result(const uint8_t * event){
    return event[11];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_KEYPRESS_NOTIFICATION
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_keypress_notification_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field action from event SM_EVENT_KEYPRESS_NOTIFICATION
 * @param event packet
 * @return action
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_keypress_notification_get_action(const uint8_t * event){
    return event[4];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_IDENTITY_CREATED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_identity_created_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_IDENTITY_CREATED
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_identity_created_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_IDENTITY_CREATED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_identity_created_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field identity_addr_type from event SM_EVENT_IDENTITY_CREATED
 * @param event packet
 * @return identity_addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_identity_created_get_identity_addr_type(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field identity_address from event SM_EVENT_IDENTITY_CREATED
 * @param event packet
 * @param Pointer to storage for identity_address
 * @note: btstack_type B
 */
static inline void sm_event_identity_created_get_identity_address(const uint8_t * event, bd_addr_t identity_address){
    reverse_bytes(&event[12], identity_address, 6);
}
/**
 * @brief Get field index from event SM_EVENT_IDENTITY_CREATED
 * @param event packet
 * @return index
 * @note: btstack_type 2
 */
static inline uint16_t sm_event_identity_created_get_index(const uint8_t * event){
    return little_endian_read_16(event, 18);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_PAIRING_STARTED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_pairing_started_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_PAIRING_STARTED
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_pairing_started_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_PAIRING_STARTED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_pairing_started_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_PAIRING_COMPLETE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_pairing_complete_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_PAIRING_COMPLETE
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_pairing_complete_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_PAIRING_COMPLETE
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_pairing_complete_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field status from event SM_EVENT_PAIRING_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_pairing_complete_get_status(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field reason from event SM_EVENT_PAIRING_COMPLETE
 * @param event packet
 * @return reason
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_pairing_complete_get_reason(const uint8_t * event){
    return event[12];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_REENCRYPTION_STARTED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_reencryption_started_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_REENCRYPTION_STARTED
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_reencryption_started_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_REENCRYPTION_STARTED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_reencryption_started_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event SM_EVENT_REENCRYPTION_COMPLETE
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t sm_event_reencryption_complete_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field addr_type from event SM_EVENT_REENCRYPTION_COMPLETE
 * @param event packet
 * @return addr_type
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_reencryption_complete_get_addr_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event SM_EVENT_REENCRYPTION_COMPLETE
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void sm_event_reencryption_complete_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field status from event SM_EVENT_REENCRYPTION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t sm_event_reencryption_complete_get_status(const uint8_t * event){
    return event[11];
}
#endif

/**
 * @brief Get field handle from event GAP_EVENT_SECURITY_LEVEL
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gap_event_security_level_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field security_level from event GAP_EVENT_SECURITY_LEVEL
 * @param event packet
 * @return security_level
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_security_level_get_security_level(const uint8_t * event){
    return event[4];
}

/**
 * @brief Get field status from event GAP_EVENT_DEDICATED_BONDING_COMPLETED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_dedicated_bonding_completed_get_status(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field address from event GAP_EVENT_DEDICATED_BONDING_COMPLETED
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void gap_event_dedicated_bonding_completed_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[3], address, 6);
}

/**
 * @brief Get field advertising_event_type from event GAP_EVENT_ADVERTISING_REPORT
 * @param event packet
 * @return advertising_event_type
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_advertising_report_get_advertising_event_type(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field address_type from event GAP_EVENT_ADVERTISING_REPORT
 * @param event packet
 * @return address_type
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_advertising_report_get_address_type(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field address from event GAP_EVENT_ADVERTISING_REPORT
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void gap_event_advertising_report_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[4], address, 6);
}
/**
 * @brief Get field rssi from event GAP_EVENT_ADVERTISING_REPORT
 * @param event packet
 * @return rssi
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_advertising_report_get_rssi(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field data_length from event GAP_EVENT_ADVERTISING_REPORT
 * @param event packet
 * @return data_length
 * @note: btstack_type J
 */
static inline uint8_t gap_event_advertising_report_get_data_length(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field data from event GAP_EVENT_ADVERTISING_REPORT
 * @param event packet
 * @return data
 * @note: btstack_type V
 */
static inline const uint8_t * gap_event_advertising_report_get_data(const uint8_t * event){
    return &event[12];
}

/**
 * @brief Get field advertising_event_type from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return advertising_event_type
 * @note: btstack_type 2
 */
static inline uint16_t gap_event_extended_advertising_report_get_advertising_event_type(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field address_type from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return address_type
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_extended_advertising_report_get_address_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field address from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void gap_event_extended_advertising_report_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field primary_phy from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return primary_phy
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_extended_advertising_report_get_primary_phy(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field secondary_phy from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return secondary_phy
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_extended_advertising_report_get_secondary_phy(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field advertising_sid from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return advertising_sid
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_extended_advertising_report_get_advertising_sid(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field tx_power from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return tx_power
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_extended_advertising_report_get_tx_power(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field rssi from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return rssi
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_extended_advertising_report_get_rssi(const uint8_t * event){
    return event[15];
}
/**
 * @brief Get field periodic_advertising_interval from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return periodic_advertising_interval
 * @note: btstack_type 2
 */
static inline uint16_t gap_event_extended_advertising_report_get_periodic_advertising_interval(const uint8_t * event){
    return little_endian_read_16(event, 16);
}
/**
 * @brief Get field direct_address_type from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return direct_address_type
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_extended_advertising_report_get_direct_address_type(const uint8_t * event){
    return event[18];
}
/**
 * @brief Get field direct_address from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @param Pointer to storage for direct_address
 * @note: btstack_type B
 */
static inline void gap_event_extended_advertising_report_get_direct_address(const uint8_t * event, bd_addr_t direct_address){
    reverse_bytes(&event[19], direct_address, 6);
}
/**
 * @brief Get field data_length from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return data_length
 * @note: btstack_type J
 */
static inline uint8_t gap_event_extended_advertising_report_get_data_length(const uint8_t * event){
    return event[25];
}
/**
 * @brief Get field data from event GAP_EVENT_EXTENDED_ADVERTISING_REPORT
 * @param event packet
 * @return data
 * @note: btstack_type V
 */
static inline const uint8_t * gap_event_extended_advertising_report_get_data(const uint8_t * event){
    return &event[26];
}

/**
 * @brief Get field bd_addr from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void gap_event_inquiry_result_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[2], bd_addr, 6);
}
/**
 * @brief Get field page_scan_repetition_mode from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return page_scan_repetition_mode
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_inquiry_result_get_page_scan_repetition_mode(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field class_of_device from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return class_of_device
 * @note: btstack_type 3
 */
static inline uint32_t gap_event_inquiry_result_get_class_of_device(const uint8_t * event){
    return little_endian_read_24(event, 9);
}
/**
 * @brief Get field clock_offset from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return clock_offset
 * @note: btstack_type 2
 */
static inline uint16_t gap_event_inquiry_result_get_clock_offset(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field rssi_available from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return rssi_available
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_inquiry_result_get_rssi_available(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field rssi from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return rssi
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_inquiry_result_get_rssi(const uint8_t * event){
    return event[15];
}
/**
 * @brief Get field device_id_available from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return device_id_available
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_inquiry_result_get_device_id_available(const uint8_t * event){
    return event[16];
}
/**
 * @brief Get field device_id_vendor_id_source from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return device_id_vendor_id_source
 * @note: btstack_type 2
 */
static inline uint16_t gap_event_inquiry_result_get_device_id_vendor_id_source(const uint8_t * event){
    return little_endian_read_16(event, 17);
}
/**
 * @brief Get field device_id_vendor_id from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return device_id_vendor_id
 * @note: btstack_type 2
 */
static inline uint16_t gap_event_inquiry_result_get_device_id_vendor_id(const uint8_t * event){
    return little_endian_read_16(event, 19);
}
/**
 * @brief Get field device_id_product_id from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return device_id_product_id
 * @note: btstack_type 2
 */
static inline uint16_t gap_event_inquiry_result_get_device_id_product_id(const uint8_t * event){
    return little_endian_read_16(event, 21);
}
/**
 * @brief Get field device_id_version from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return device_id_version
 * @note: btstack_type 2
 */
static inline uint16_t gap_event_inquiry_result_get_device_id_version(const uint8_t * event){
    return little_endian_read_16(event, 23);
}
/**
 * @brief Get field name_available from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return name_available
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_inquiry_result_get_name_available(const uint8_t * event){
    return event[25];
}
/**
 * @brief Get field name_len from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return name_len
 * @note: btstack_type J
 */
static inline uint8_t gap_event_inquiry_result_get_name_len(const uint8_t * event){
    return event[26];
}
/**
 * @brief Get field name from event GAP_EVENT_INQUIRY_RESULT
 * @param event packet
 * @return name
 * @note: btstack_type V
 */
static inline const uint8_t * gap_event_inquiry_result_get_name(const uint8_t * event){
    return &event[27];
}

/**
 * @brief Get field status from event GAP_EVENT_INQUIRY_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_inquiry_complete_get_status(const uint8_t * event){
    return event[2];
}

/**
 * @brief Get field con_handle from event GAP_EVENT_RSSI_MEASUREMENT
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gap_event_rssi_measurement_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field rssi from event GAP_EVENT_RSSI_MEASUREMENT
 * @param event packet
 * @return rssi
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_rssi_measurement_get_rssi(const uint8_t * event){
    return event[4];
}

/**
 * @brief Get field oob_data_present from event GAP_EVENT_LOCAL_OOB_DATA
 * @param event packet
 * @return oob_data_present
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_local_oob_data_get_oob_data_present(const uint8_t * event){
    return event[2];
}
/**
 * @brief Get field c_192 from event GAP_EVENT_LOCAL_OOB_DATA
 * @param event packet
 * @param Pointer to storage for c_192
 * @note: btstack_type K
 */
static inline void gap_event_local_oob_data_get_c_192(const uint8_t * event, uint8_t * c_192){
    reverse_bytes(&event[3], c_192, 16);
}
/**
 * @brief Get field r_192 from event GAP_EVENT_LOCAL_OOB_DATA
 * @param event packet
 * @param Pointer to storage for r_192
 * @note: btstack_type K
 */
static inline void gap_event_local_oob_data_get_r_192(const uint8_t * event, uint8_t * r_192){
    reverse_bytes(&event[19], r_192, 16);
}
/**
 * @brief Get field c_256 from event GAP_EVENT_LOCAL_OOB_DATA
 * @param event packet
 * @param Pointer to storage for c_256
 * @note: btstack_type K
 */
static inline void gap_event_local_oob_data_get_c_256(const uint8_t * event, uint8_t * c_256){
    reverse_bytes(&event[35], c_256, 16);
}
/**
 * @brief Get field r_256 from event GAP_EVENT_LOCAL_OOB_DATA
 * @param event packet
 * @param Pointer to storage for r_256
 * @note: btstack_type K
 */
static inline void gap_event_local_oob_data_get_r_256(const uint8_t * event, uint8_t * r_256){
    reverse_bytes(&event[51], r_256, 16);
}

/**
 * @brief Get field con_handle from event GAP_EVENT_PAIRING_STARTED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gap_event_pairing_started_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field bd_addr from event GAP_EVENT_PAIRING_STARTED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void gap_event_pairing_started_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[4], bd_addr, 6);
}
/**
 * @brief Get field ssp from event GAP_EVENT_PAIRING_STARTED
 * @param event packet
 * @return ssp
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_pairing_started_get_ssp(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field initiator from event GAP_EVENT_PAIRING_STARTED
 * @param event packet
 * @return initiator
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_pairing_started_get_initiator(const uint8_t * event){
    return event[11];
}

/**
 * @brief Get field con_handle from event GAP_EVENT_PAIRING_COMPLETE
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gap_event_pairing_complete_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 2);
}
/**
 * @brief Get field bd_addr from event GAP_EVENT_PAIRING_COMPLETE
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void gap_event_pairing_complete_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[4], bd_addr, 6);
}
/**
 * @brief Get field status from event GAP_EVENT_PAIRING_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gap_event_pairing_complete_get_status(const uint8_t * event){
    return event[10];
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_CONNECTION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_connection_complete_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_CONNECTION_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_connection_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field role from event HCI_SUBEVENT_LE_CONNECTION_COMPLETE
 * @param event packet
 * @return role
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_connection_complete_get_role(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field peer_address_type from event HCI_SUBEVENT_LE_CONNECTION_COMPLETE
 * @param event packet
 * @return peer_address_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_connection_complete_get_peer_address_type(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field peer_address from event HCI_SUBEVENT_LE_CONNECTION_COMPLETE
 * @param event packet
 * @param Pointer to storage for peer_address
 * @note: btstack_type B
 */
static inline void hci_subevent_le_connection_complete_get_peer_address(const uint8_t * event, bd_addr_t peer_address){
    reverse_bytes(&event[8], peer_address, 6);
}
/**
 * @brief Get field conn_interval from event HCI_SUBEVENT_LE_CONNECTION_COMPLETE
 * @param event packet
 * @return conn_interval
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_connection_complete_get_conn_interval(const uint8_t * event){
    return little_endian_read_16(event, 14);
}
/**
 * @brief Get field conn_latency from event HCI_SUBEVENT_LE_CONNECTION_COMPLETE
 * @param event packet
 * @return conn_latency
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_connection_complete_get_conn_latency(const uint8_t * event){
    return little_endian_read_16(event, 16);
}
/**
 * @brief Get field supervision_timeout from event HCI_SUBEVENT_LE_CONNECTION_COMPLETE
 * @param event packet
 * @return supervision_timeout
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_connection_complete_get_supervision_timeout(const uint8_t * event){
    return little_endian_read_16(event, 18);
}
/**
 * @brief Get field master_clock_accuracy from event HCI_SUBEVENT_LE_CONNECTION_COMPLETE
 * @param event packet
 * @return master_clock_accuracy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_connection_complete_get_master_clock_accuracy(const uint8_t * event){
    return event[20];
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_CONNECTION_UPDATE_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_connection_update_complete_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_CONNECTION_UPDATE_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_connection_update_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field conn_interval from event HCI_SUBEVENT_LE_CONNECTION_UPDATE_COMPLETE
 * @param event packet
 * @return conn_interval
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_connection_update_complete_get_conn_interval(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field conn_latency from event HCI_SUBEVENT_LE_CONNECTION_UPDATE_COMPLETE
 * @param event packet
 * @return conn_latency
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_connection_update_complete_get_conn_latency(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field supervision_timeout from event HCI_SUBEVENT_LE_CONNECTION_UPDATE_COMPLETE
 * @param event packet
 * @return supervision_timeout
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_connection_update_complete_get_supervision_timeout(const uint8_t * event){
    return little_endian_read_16(event, 10);
}

/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_READ_REMOTE_FEATURES_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_read_remote_features_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field le_features from event HCI_SUBEVENT_LE_READ_REMOTE_FEATURES_COMPLETE
 * @param event packet
 * @return le_features
 * @note: btstack_type D
 */
static inline const uint8_t * hci_subevent_le_read_remote_features_complete_get_le_features(const uint8_t * event){
    return (const uint8_t *) &event[5];
}

/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_LONG_TERM_KEY_REQUEST
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_long_term_key_request_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field random_number from event HCI_SUBEVENT_LE_LONG_TERM_KEY_REQUEST
 * @param event packet
 * @return random_number
 * @note: btstack_type D
 */
static inline const uint8_t * hci_subevent_le_long_term_key_request_get_random_number(const uint8_t * event){
    return (const uint8_t *) &event[5];
}
/**
 * @brief Get field encryption_diversifier from event HCI_SUBEVENT_LE_LONG_TERM_KEY_REQUEST
 * @param event packet
 * @return encryption_diversifier
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_long_term_key_request_get_encryption_diversifier(const uint8_t * event){
    return little_endian_read_16(event, 13);
}

/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_REMOTE_CONNECTION_PARAMETER_REQUEST
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_remote_connection_parameter_request_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field interval_min from event HCI_SUBEVENT_LE_REMOTE_CONNECTION_PARAMETER_REQUEST
 * @param event packet
 * @return interval_min
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_remote_connection_parameter_request_get_interval_min(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field interval_max from event HCI_SUBEVENT_LE_REMOTE_CONNECTION_PARAMETER_REQUEST
 * @param event packet
 * @return interval_max
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_remote_connection_parameter_request_get_interval_max(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field latency from event HCI_SUBEVENT_LE_REMOTE_CONNECTION_PARAMETER_REQUEST
 * @param event packet
 * @return latency
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_remote_connection_parameter_request_get_latency(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field timeout from event HCI_SUBEVENT_LE_REMOTE_CONNECTION_PARAMETER_REQUEST
 * @param event packet
 * @return timeout
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_remote_connection_parameter_request_get_timeout(const uint8_t * event){
    return little_endian_read_16(event, 11);
}

/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_DATA_LENGTH_CHANGE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_data_length_change_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field max_tx_octets from event HCI_SUBEVENT_LE_DATA_LENGTH_CHANGE
 * @param event packet
 * @return max_tx_octets
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_data_length_change_get_max_tx_octets(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field max_tx_time from event HCI_SUBEVENT_LE_DATA_LENGTH_CHANGE
 * @param event packet
 * @return max_tx_time
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_data_length_change_get_max_tx_time(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field max_rx_octets from event HCI_SUBEVENT_LE_DATA_LENGTH_CHANGE
 * @param event packet
 * @return max_rx_octets
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_data_length_change_get_max_rx_octets(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field max_rx_time from event HCI_SUBEVENT_LE_DATA_LENGTH_CHANGE
 * @param event packet
 * @return max_rx_time
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_data_length_change_get_max_rx_time(const uint8_t * event){
    return little_endian_read_16(event, 11);
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_READ_LOCAL_P256_PUBLIC_KEY_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_read_local_p256_public_key_complete_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field dhkey_x from event HCI_SUBEVENT_LE_READ_LOCAL_P256_PUBLIC_KEY_COMPLETE
 * @param event packet
 * @param Pointer to storage for dhkey_x
 * @note: btstack_type Q
 */
static inline void hci_subevent_le_read_local_p256_public_key_complete_get_dhkey_x(const uint8_t * event, uint8_t * dhkey_x){
    reverse_bytes(&event[4], dhkey_x, 32);
}
/**
 * @brief Get field dhkey_y from event HCI_SUBEVENT_LE_READ_LOCAL_P256_PUBLIC_KEY_COMPLETE
 * @param event packet
 * @param Pointer to storage for dhkey_y
 * @note: btstack_type Q
 */
static inline void hci_subevent_le_read_local_p256_public_key_complete_get_dhkey_y(const uint8_t * event, uint8_t * dhkey_y){
    reverse_bytes(&event[36], dhkey_y, 32);
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_GENERATE_DHKEY_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_generate_dhkey_complete_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field dhkey from event HCI_SUBEVENT_LE_GENERATE_DHKEY_COMPLETE
 * @param event packet
 * @param Pointer to storage for dhkey
 * @note: btstack_type Q
 */
static inline void hci_subevent_le_generate_dhkey_complete_get_dhkey(const uint8_t * event, uint8_t * dhkey){
    reverse_bytes(&event[4], dhkey, 32);
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_enhanced_connection_complete_v1_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_enhanced_connection_complete_v1_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field role from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @return role
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_enhanced_connection_complete_v1_get_role(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field peer_address_type from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @return peer_address_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_enhanced_connection_complete_v1_get_peer_address_type(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field peer_addresss from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @param Pointer to storage for peer_addresss
 * @note: btstack_type B
 */
static inline void hci_subevent_le_enhanced_connection_complete_v1_get_peer_addresss(const uint8_t * event, bd_addr_t peer_addresss){
    reverse_bytes(&event[8], peer_addresss, 6);
}
/**
 * @brief Get field local_resolvable_private_address from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @param Pointer to storage for local_resolvable_private_address
 * @note: btstack_type B
 */
static inline void hci_subevent_le_enhanced_connection_complete_v1_get_local_resolvable_private_address(const uint8_t * event, bd_addr_t local_resolvable_private_address){
    reverse_bytes(&event[14], local_resolvable_private_address, 6);
}
/**
 * @brief Get field peer_resolvable_private_address from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @param Pointer to storage for peer_resolvable_private_address
 * @note: btstack_type B
 */
static inline void hci_subevent_le_enhanced_connection_complete_v1_get_peer_resolvable_private_address(const uint8_t * event, bd_addr_t peer_resolvable_private_address){
    reverse_bytes(&event[20], peer_resolvable_private_address, 6);
}
/**
 * @brief Get field conn_interval from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @return conn_interval
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_enhanced_connection_complete_v1_get_conn_interval(const uint8_t * event){
    return little_endian_read_16(event, 26);
}
/**
 * @brief Get field conn_latency from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @return conn_latency
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_enhanced_connection_complete_v1_get_conn_latency(const uint8_t * event){
    return little_endian_read_16(event, 28);
}
/**
 * @brief Get field supervision_timeout from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @return supervision_timeout
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_enhanced_connection_complete_v1_get_supervision_timeout(const uint8_t * event){
    return little_endian_read_16(event, 30);
}
/**
 * @brief Get field master_clock_accuracy from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1
 * @param event packet
 * @return master_clock_accuracy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_enhanced_connection_complete_v1_get_master_clock_accuracy(const uint8_t * event){
    return event[32];
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_PHY_UPDATE_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_phy_update_complete_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_PHY_UPDATE_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_phy_update_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field tx_phy from event HCI_SUBEVENT_LE_PHY_UPDATE_COMPLETE
 * @param event packet
 * @return tx_phy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_phy_update_complete_get_tx_phy(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_ESTABLISHMENT
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_sync_establishment_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field sync_handle from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_ESTABLISHMENT
 * @param event packet
 * @return sync_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_periodic_advertising_sync_establishment_get_sync_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field advertising_sid from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_ESTABLISHMENT
 * @param event packet
 * @return advertising_sid
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_sync_establishment_get_advertising_sid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field advertiser_address_type from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_ESTABLISHMENT
 * @param event packet
 * @return advertiser_address_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_sync_establishment_get_advertiser_address_type(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field advertiser_address from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_ESTABLISHMENT
 * @param event packet
 * @param Pointer to storage for advertiser_address
 * @note: btstack_type B
 */
static inline void hci_subevent_le_periodic_advertising_sync_establishment_get_advertiser_address(const uint8_t * event, bd_addr_t advertiser_address){
    reverse_bytes(&event[8], advertiser_address, 6);
}
/**
 * @brief Get field advertiser_phy from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_ESTABLISHMENT
 * @param event packet
 * @return advertiser_phy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_sync_establishment_get_advertiser_phy(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field periodic_advertising_interval from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_ESTABLISHMENT
 * @param event packet
 * @return periodic_advertising_interval
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_periodic_advertising_sync_establishment_get_periodic_advertising_interval(const uint8_t * event){
    return little_endian_read_16(event, 15);
}
/**
 * @brief Get field advertiser_clock_accuracy from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_ESTABLISHMENT
 * @param event packet
 * @return advertiser_clock_accuracy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_sync_establishment_get_advertiser_clock_accuracy(const uint8_t * event){
    return event[17];
}

/**
 * @brief Get field sync_handle from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_REPORT
 * @param event packet
 * @return sync_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_periodic_advertising_report_get_sync_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field tx_power from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_REPORT
 * @param event packet
 * @return tx_power
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_report_get_tx_power(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field rssi from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_REPORT
 * @param event packet
 * @return rssi
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_report_get_rssi(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field cte_type from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_REPORT
 * @param event packet
 * @return cte_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_report_get_cte_type(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field data_status from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_REPORT
 * @param event packet
 * @return data_status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_report_get_data_status(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field data_length from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_REPORT
 * @param event packet
 * @return data_length
 * @note: btstack_type J
 */
static inline uint8_t hci_subevent_le_periodic_advertising_report_get_data_length(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field data from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_REPORT
 * @param event packet
 * @return data
 * @note: btstack_type V
 */
static inline const uint8_t * hci_subevent_le_periodic_advertising_report_get_data(const uint8_t * event){
    return &event[10];
}

/**
 * @brief Get field sync_handle from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_LOST
 * @param event packet
 * @return sync_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_periodic_advertising_sync_lost_get_sync_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}


/**
 * @brief Get field status from event HCI_SUBEVENT_LE_ADVERTISING_SET_TERMINATED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_advertising_set_terminated_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field advertising_handle from event HCI_SUBEVENT_LE_ADVERTISING_SET_TERMINATED
 * @param event packet
 * @return advertising_handle
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_advertising_set_terminated_get_advertising_handle(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_ADVERTISING_SET_TERMINATED
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_advertising_set_terminated_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field num_completed_exteneded_advertising_events from event HCI_SUBEVENT_LE_ADVERTISING_SET_TERMINATED
 * @param event packet
 * @return num_completed_exteneded_advertising_events
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_advertising_set_terminated_get_num_completed_exteneded_advertising_events(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field advertising_handle from event HCI_SUBEVENT_LE_SCAN_REQUEST_RECEIVED
 * @param event packet
 * @return advertising_handle
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_scan_request_received_get_advertising_handle(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field scanner_address_type from event HCI_SUBEVENT_LE_SCAN_REQUEST_RECEIVED
 * @param event packet
 * @return scanner_address_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_scan_request_received_get_scanner_address_type(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field scanner_address from event HCI_SUBEVENT_LE_SCAN_REQUEST_RECEIVED
 * @param event packet
 * @param Pointer to storage for scanner_address
 * @note: btstack_type B
 */
static inline void hci_subevent_le_scan_request_received_get_scanner_address(const uint8_t * event, bd_addr_t scanner_address){
    reverse_bytes(&event[5], scanner_address, 6);
}

/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_CHANNEL_SELECTION_ALGORITHM
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_channel_selection_algorithm_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field channel_selection_algorithm from event HCI_SUBEVENT_LE_CHANNEL_SELECTION_ALGORITHM
 * @param event packet
 * @return channel_selection_algorithm
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_channel_selection_algorithm_get_channel_selection_algorithm(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_LE_CTE_REQUEST_FAILED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_le_cte_request_failed_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_LE_CTE_REQUEST_FAILED
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_le_cte_request_failed_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_sync_transfer_received_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_periodic_advertising_sync_transfer_received_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field service_data from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED
 * @param event packet
 * @return service_data
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_periodic_advertising_sync_transfer_received_get_service_data(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field sync_handle from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED
 * @param event packet
 * @return sync_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_periodic_advertising_sync_transfer_received_get_sync_handle(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field advertising_sid from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED
 * @param event packet
 * @return advertising_sid
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_sync_transfer_received_get_advertising_sid(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field advertiser_address_type from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED
 * @param event packet
 * @return advertiser_address_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_sync_transfer_received_get_advertiser_address_type(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field advertiser_address from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED
 * @param event packet
 * @param Pointer to storage for advertiser_address
 * @note: btstack_type B
 */
static inline void hci_subevent_le_periodic_advertising_sync_transfer_received_get_advertiser_address(const uint8_t * event, bd_addr_t advertiser_address){
    reverse_bytes(&event[12], advertiser_address, 6);
}
/**
 * @brief Get field advertiser_phy from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED
 * @param event packet
 * @return advertiser_phy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_sync_transfer_received_get_advertiser_phy(const uint8_t * event){
    return event[18];
}
/**
 * @brief Get field periodic_advertising_interval from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED
 * @param event packet
 * @return periodic_advertising_interval
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_periodic_advertising_sync_transfer_received_get_periodic_advertising_interval(const uint8_t * event){
    return little_endian_read_16(event, 19);
}
/**
 * @brief Get field advertiser_clock_accuracy from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED
 * @param event packet
 * @return advertiser_clock_accuracy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_sync_transfer_received_get_advertiser_clock_accuracy(const uint8_t * event){
    return event[21];
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_cis_established_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_cis_established_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field cig_sync_delay from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return cig_sync_delay
 * @note: btstack_type 3
 */
static inline uint32_t hci_subevent_le_cis_established_get_cig_sync_delay(const uint8_t * event){
    return little_endian_read_24(event, 6);
}
/**
 * @brief Get field cis_sync_delay from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return cis_sync_delay
 * @note: btstack_type 3
 */
static inline uint32_t hci_subevent_le_cis_established_get_cis_sync_delay(const uint8_t * event){
    return little_endian_read_24(event, 9);
}
/**
 * @brief Get field transport_latency_c_to_p from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return transport_latency_c_to_p
 * @note: btstack_type 3
 */
static inline uint32_t hci_subevent_le_cis_established_get_transport_latency_c_to_p(const uint8_t * event){
    return little_endian_read_24(event, 12);
}
/**
 * @brief Get field transport_latency_p_to_c from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return transport_latency_p_to_c
 * @note: btstack_type 3
 */
static inline uint32_t hci_subevent_le_cis_established_get_transport_latency_p_to_c(const uint8_t * event){
    return little_endian_read_24(event, 15);
}
/**
 * @brief Get field phy_c_to_p from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return phy_c_to_p
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_cis_established_get_phy_c_to_p(const uint8_t * event){
    return event[18];
}
/**
 * @brief Get field phy_p_to_c from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return phy_p_to_c
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_cis_established_get_phy_p_to_c(const uint8_t * event){
    return event[19];
}
/**
 * @brief Get field nse from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return nse
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_cis_established_get_nse(const uint8_t * event){
    return event[20];
}
/**
 * @brief Get field bn_c_to_p from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return bn_c_to_p
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_cis_established_get_bn_c_to_p(const uint8_t * event){
    return event[21];
}
/**
 * @brief Get field bn_p_to_c from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return bn_p_to_c
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_cis_established_get_bn_p_to_c(const uint8_t * event){
    return event[22];
}
/**
 * @brief Get field ft_c_to_p from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return ft_c_to_p
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_cis_established_get_ft_c_to_p(const uint8_t * event){
    return event[23];
}
/**
 * @brief Get field ft_p_to_c from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return ft_p_to_c
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_cis_established_get_ft_p_to_c(const uint8_t * event){
    return event[24];
}
/**
 * @brief Get field max_pdu_c_to_p from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return max_pdu_c_to_p
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_cis_established_get_max_pdu_c_to_p(const uint8_t * event){
    return little_endian_read_16(event, 25);
}
/**
 * @brief Get field max_pdu_p_to_c from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return max_pdu_p_to_c
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_cis_established_get_max_pdu_p_to_c(const uint8_t * event){
    return little_endian_read_16(event, 27);
}
/**
 * @brief Get field iso_interval from event HCI_SUBEVENT_LE_CIS_ESTABLISHED
 * @param event packet
 * @return iso_interval
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_cis_established_get_iso_interval(const uint8_t * event){
    return little_endian_read_16(event, 29);
}

/**
 * @brief Get field acl_connection_handle from event HCI_SUBEVENT_LE_CIS_REQUEST
 * @param event packet
 * @return acl_connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_cis_request_get_acl_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field cis_connection_handle from event HCI_SUBEVENT_LE_CIS_REQUEST
 * @param event packet
 * @return cis_connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_cis_request_get_cis_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field cig_id from event HCI_SUBEVENT_LE_CIS_REQUEST
 * @param event packet
 * @return cig_id
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_cis_request_get_cig_id(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field cis_id from event HCI_SUBEVENT_LE_CIS_REQUEST
 * @param event packet
 * @return cis_id
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_cis_request_get_cis_id(const uint8_t * event){
    return event[8];
}

/**
 * @brief Get field big_handle from event HCI_SUBEVENT_LE_TERMINATE_BIG_COMPLETE
 * @param event packet
 * @return big_handle
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_terminate_big_complete_get_big_handle(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field reason from event HCI_SUBEVENT_LE_TERMINATE_BIG_COMPLETE
 * @param event packet
 * @return reason
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_terminate_big_complete_get_reason(const uint8_t * event){
    return event[4];
}

/**
 * @brief Get field big_handle from event HCI_SUBEVENT_LE_BIG_SYNC_LOST
 * @param event packet
 * @return big_handle
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_big_sync_lost_get_big_handle(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field reason from event HCI_SUBEVENT_LE_BIG_SYNC_LOST
 * @param event packet
 * @return reason
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_big_sync_lost_get_reason(const uint8_t * event){
    return event[4];
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_REQUEST_PEER_SCA_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_request_peer_sca_complete_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_REQUEST_PEER_SCA_COMPLETE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_request_peer_sca_complete_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field peer_clock_accuracy from event HCI_SUBEVENT_LE_REQUEST_PEER_SCA_COMPLETE
 * @param event packet
 * @return peer_clock_accuracy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_request_peer_sca_complete_get_peer_clock_accuracy(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_TRANSMIT_POWER_REPORTING
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_transmit_power_reporting_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_TRANSMIT_POWER_REPORTING
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_transmit_power_reporting_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field reason from event HCI_SUBEVENT_LE_TRANSMIT_POWER_REPORTING
 * @param event packet
 * @return reason
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_transmit_power_reporting_get_reason(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field phy from event HCI_SUBEVENT_LE_TRANSMIT_POWER_REPORTING
 * @param event packet
 * @return phy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_transmit_power_reporting_get_phy(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field tx_power_level from event HCI_SUBEVENT_LE_TRANSMIT_POWER_REPORTING
 * @param event packet
 * @return tx_power_level
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_transmit_power_reporting_get_tx_power_level(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field tx_power_level_flag from event HCI_SUBEVENT_LE_TRANSMIT_POWER_REPORTING
 * @param event packet
 * @return tx_power_level_flag
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_transmit_power_reporting_get_tx_power_level_flag(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field delta from event HCI_SUBEVENT_LE_TRANSMIT_POWER_REPORTING
 * @param event packet
 * @return delta
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_transmit_power_reporting_get_delta(const uint8_t * event){
    return event[10];
}

/**
 * @brief Get field sync_handle from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return sync_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_biginfo_advertising_report_get_sync_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field num_bis from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return num_bis
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_biginfo_advertising_report_get_num_bis(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field nse from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return nse
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_biginfo_advertising_report_get_nse(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field iso_interval from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return iso_interval
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_biginfo_advertising_report_get_iso_interval(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field bn from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return bn
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_biginfo_advertising_report_get_bn(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field pto from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return pto
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_biginfo_advertising_report_get_pto(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field irc from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return irc
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_biginfo_advertising_report_get_irc(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field max_pdu from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return max_pdu
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_biginfo_advertising_report_get_max_pdu(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field sdu_interval from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return sdu_interval
 * @note: btstack_type 3
 */
static inline uint32_t hci_subevent_le_biginfo_advertising_report_get_sdu_interval(const uint8_t * event){
    return little_endian_read_24(event, 14);
}
/**
 * @brief Get field max_sdu from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return max_sdu
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_biginfo_advertising_report_get_max_sdu(const uint8_t * event){
    return little_endian_read_16(event, 17);
}
/**
 * @brief Get field phy from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return phy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_biginfo_advertising_report_get_phy(const uint8_t * event){
    return event[19];
}
/**
 * @brief Get field framing from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return framing
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_biginfo_advertising_report_get_framing(const uint8_t * event){
    return event[20];
}
/**
 * @brief Get field encryption from event HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT
 * @param event packet
 * @return encryption
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_biginfo_advertising_report_get_encryption(const uint8_t * event){
    return event[21];
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_SUBRATE_CHANGE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_subrate_change_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_SUBRATE_CHANGE
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_subrate_change_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field subrate_factor from event HCI_SUBEVENT_LE_SUBRATE_CHANGE
 * @param event packet
 * @return subrate_factor
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_subrate_change_get_subrate_factor(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field peripheral_latency from event HCI_SUBEVENT_LE_SUBRATE_CHANGE
 * @param event packet
 * @return peripheral_latency
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_subrate_change_get_peripheral_latency(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field continuation_number from event HCI_SUBEVENT_LE_SUBRATE_CHANGE
 * @param event packet
 * @return continuation_number
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_subrate_change_get_continuation_number(const uint8_t * event){
    return little_endian_read_16(event, 10);
}
/**
 * @brief Get field supervision_timeout from event HCI_SUBEVENT_LE_SUBRATE_CHANGE
 * @param event packet
 * @return supervision_timeout
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_subrate_change_get_supervision_timeout(const uint8_t * event){
    return little_endian_read_16(event, 12);
}

/**
 * @brief Get field advertising_handle from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_DATA_REQUEST
 * @param event packet
 * @return advertising_handle
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_data_request_get_advertising_handle(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field subevent_start from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_DATA_REQUEST
 * @param event packet
 * @return subevent_start
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_data_request_get_subevent_start(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field subevent_data_count from event HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_DATA_REQUEST
 * @param event packet
 * @return subevent_data_count
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_periodic_advertising_data_request_get_subevent_data_count(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field status from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_enhanced_connection_complete_v2_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field connection_handle from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @return connection_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_enhanced_connection_complete_v2_get_connection_handle(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field role from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @return role
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_enhanced_connection_complete_v2_get_role(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field peer_address_type from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @return peer_address_type
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_enhanced_connection_complete_v2_get_peer_address_type(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field peer_addresss from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @param Pointer to storage for peer_addresss
 * @note: btstack_type B
 */
static inline void hci_subevent_le_enhanced_connection_complete_v2_get_peer_addresss(const uint8_t * event, bd_addr_t peer_addresss){
    reverse_bytes(&event[8], peer_addresss, 6);
}
/**
 * @brief Get field local_resolvable_private_address from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @param Pointer to storage for local_resolvable_private_address
 * @note: btstack_type B
 */
static inline void hci_subevent_le_enhanced_connection_complete_v2_get_local_resolvable_private_address(const uint8_t * event, bd_addr_t local_resolvable_private_address){
    reverse_bytes(&event[14], local_resolvable_private_address, 6);
}
/**
 * @brief Get field peer_resolvable_private_address from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @param Pointer to storage for peer_resolvable_private_address
 * @note: btstack_type B
 */
static inline void hci_subevent_le_enhanced_connection_complete_v2_get_peer_resolvable_private_address(const uint8_t * event, bd_addr_t peer_resolvable_private_address){
    reverse_bytes(&event[20], peer_resolvable_private_address, 6);
}
/**
 * @brief Get field conn_interval from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @return conn_interval
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_enhanced_connection_complete_v2_get_conn_interval(const uint8_t * event){
    return little_endian_read_16(event, 26);
}
/**
 * @brief Get field conn_latency from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @return conn_latency
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_enhanced_connection_complete_v2_get_conn_latency(const uint8_t * event){
    return little_endian_read_16(event, 28);
}
/**
 * @brief Get field supervision_timeout from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @return supervision_timeout
 * @note: btstack_type 2
 */
static inline uint16_t hci_subevent_le_enhanced_connection_complete_v2_get_supervision_timeout(const uint8_t * event){
    return little_endian_read_16(event, 30);
}
/**
 * @brief Get field master_clock_accuracy from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @return master_clock_accuracy
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_enhanced_connection_complete_v2_get_master_clock_accuracy(const uint8_t * event){
    return event[32];
}
/**
 * @brief Get field advertising_handle from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @return advertising_handle
 * @note: btstack_type 1
 */
static inline uint8_t hci_subevent_le_enhanced_connection_complete_v2_get_advertising_handle(const uint8_t * event){
    return event[33];
}
/**
 * @brief Get field sync_handle from event HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2
 * @param event packet
 * @return sync_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hci_subevent_le_enhanced_connection_complete_v2_get_sync_handle(const uint8_t * event){
    return little_endian_read_16(event, 34);
}

/**
 * @brief Get field advertisement_handle from event GAP_SUBEVENT_ADVERTISING_SET_INSTALLED
 * @param event packet
 * @return advertisement_handle
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_advertising_set_installed_get_advertisement_handle(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field status from event GAP_SUBEVENT_ADVERTISING_SET_INSTALLED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_advertising_set_installed_get_status(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field selected_tx_power from event GAP_SUBEVENT_ADVERTISING_SET_INSTALLED
 * @param event packet
 * @return selected_tx_power
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_advertising_set_installed_get_selected_tx_power(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field advertisement_handle from event GAP_SUBEVENT_ADVERTISING_SET_REMOVED
 * @param event packet
 * @return advertisement_handle
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_advertising_set_removed_get_advertisement_handle(const uint8_t * event){
    return event[3];
}

/**
 * @brief Get field status from event GAP_SUBEVENT_BIG_CREATED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_big_created_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field big_handle from event GAP_SUBEVENT_BIG_CREATED
 * @param event packet
 * @return big_handle
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_big_created_get_big_handle(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field num_bis from event GAP_SUBEVENT_BIG_CREATED
 * @param event packet
 * @return num_bis
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_big_created_get_num_bis(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get element of array field bis_con_handles from event GAP_SUBEVENT_BIG_CREATED
 * @param event packet
 * @param index
 * @return bis_con_handles
 * @note: btstack_type C
 */
static inline uint16_t gap_subevent_big_created_get_bis_con_handles(const uint8_t * event, uint8_t index){
    return little_endian_read_16(event, 6 + (2 * index));
}

/**
 * @brief Get field big_handle from event GAP_SUBEVENT_BIG_TERMINATED
 * @param event packet
 * @return big_handle
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_big_terminated_get_big_handle(const uint8_t * event){
    return event[3];
}

/**
 * @brief Get field status from event GAP_SUBEVENT_BIG_SYNC_CREATED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_big_sync_created_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field big_handle from event GAP_SUBEVENT_BIG_SYNC_CREATED
 * @param event packet
 * @return big_handle
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_big_sync_created_get_big_handle(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field num_bis from event GAP_SUBEVENT_BIG_SYNC_CREATED
 * @param event packet
 * @return num_bis
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_big_sync_created_get_num_bis(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get element of array field bis_con_handles from event GAP_SUBEVENT_BIG_SYNC_CREATED
 * @param event packet
 * @param index
 * @return bis_con_handles
 * @note: btstack_type C
 */
static inline uint16_t gap_subevent_big_sync_created_get_bis_con_handles(const uint8_t * event, uint8_t index){
    return little_endian_read_16(event, 6 + (2 * index));
}

/**
 * @brief Get field big_handle from event GAP_SUBEVENT_BIG_SYNC_STOPPED
 * @param event packet
 * @return big_handle
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_big_sync_stopped_get_big_handle(const uint8_t * event){
    return event[3];
}

/**
 * @brief Get field status from event GAP_SUBEVENT_CIG_CREATED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_cig_created_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field cig_id from event GAP_SUBEVENT_CIG_CREATED
 * @param event packet
 * @return cig_id
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_cig_created_get_cig_id(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field num_cis from event GAP_SUBEVENT_CIG_CREATED
 * @param event packet
 * @return num_cis
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_cig_created_get_num_cis(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get element of array field cis_con_handles from event GAP_SUBEVENT_CIG_CREATED
 * @param event packet
 * @param index
 * @return cis_con_handles
 * @note: btstack_type C
 */
static inline uint16_t gap_subevent_cig_created_get_cis_con_handles(const uint8_t * event, uint8_t index){
    return little_endian_read_16(event, 6 + (2 * index));
}

/**
 * @brief Get field status from event GAP_SUBEVENT_CIS_CREATED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_cis_created_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field cig_id from event GAP_SUBEVENT_CIS_CREATED
 * @param event packet
 * @return cig_id
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_cis_created_get_cig_id(const uint8_t * event){
    return event[4];
}
/**
 * @brief Get field cis_id from event GAP_SUBEVENT_CIS_CREATED
 * @param event packet
 * @return cis_id
 * @note: btstack_type 1
 */
static inline uint8_t gap_subevent_cis_created_get_cis_id(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field cis_con_handle from event GAP_SUBEVENT_CIS_CREATED
 * @param event packet
 * @return cis_con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gap_subevent_cis_created_get_cis_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field acl_con_handle from event GAP_SUBEVENT_CIS_CREATED
 * @param event packet
 * @return acl_con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gap_subevent_cis_created_get_acl_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 8);
}

/**
 * @brief Get field acl_handle from event HSP_SUBEVENT_RFCOMM_CONNECTION_COMPLETE
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_rfcomm_connection_complete_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HSP_SUBEVENT_RFCOMM_CONNECTION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hsp_subevent_rfcomm_connection_complete_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field bd_addr from event HSP_SUBEVENT_RFCOMM_CONNECTION_COMPLETE
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hsp_subevent_rfcomm_connection_complete_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[6], bd_addr, 6);
}

/**
 * @brief Get field acl_handle from event HSP_SUBEVENT_RFCOMM_DISCONNECTION_COMPLETE
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_rfcomm_disconnection_complete_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HSP_SUBEVENT_AUDIO_CONNECTION_COMPLETE
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_audio_connection_complete_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HSP_SUBEVENT_AUDIO_CONNECTION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hsp_subevent_audio_connection_complete_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field sco_handle from event HSP_SUBEVENT_AUDIO_CONNECTION_COMPLETE
 * @param event packet
 * @return sco_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_audio_connection_complete_get_sco_handle(const uint8_t * event){
    return little_endian_read_16(event, 6);
}

/**
 * @brief Get field acl_handle from event HSP_SUBEVENT_AUDIO_DISCONNECTION_COMPLETE
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_audio_disconnection_complete_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field sco_handle from event HSP_SUBEVENT_AUDIO_DISCONNECTION_COMPLETE
 * @param event packet
 * @return sco_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_audio_disconnection_complete_get_sco_handle(const uint8_t * event){
    return little_endian_read_16(event, 5);
}

/**
 * @brief Get field acl_handle from event HSP_SUBEVENT_RING
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_ring_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HSP_SUBEVENT_MICROPHONE_GAIN_CHANGED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_microphone_gain_changed_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field gain from event HSP_SUBEVENT_MICROPHONE_GAIN_CHANGED
 * @param event packet
 * @return gain
 * @note: btstack_type 1
 */
static inline uint8_t hsp_subevent_microphone_gain_changed_get_gain(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HSP_SUBEVENT_SPEAKER_GAIN_CHANGED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_speaker_gain_changed_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field gain from event HSP_SUBEVENT_SPEAKER_GAIN_CHANGED
 * @param event packet
 * @return gain
 * @note: btstack_type 1
 */
static inline uint8_t hsp_subevent_speaker_gain_changed_get_gain(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HSP_SUBEVENT_HS_COMMAND
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_hs_command_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field value_length from event HSP_SUBEVENT_HS_COMMAND
 * @param event packet
 * @return value_length
 * @note: btstack_type J
 */
static inline uint8_t hsp_subevent_hs_command_get_value_length(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value from event HSP_SUBEVENT_HS_COMMAND
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * hsp_subevent_hs_command_get_value(const uint8_t * event){
    return &event[6];
}

/**
 * @brief Get field acl_handle from event HSP_SUBEVENT_AG_INDICATION
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_ag_indication_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field value_length from event HSP_SUBEVENT_AG_INDICATION
 * @param event packet
 * @return value_length
 * @note: btstack_type J
 */
static inline uint8_t hsp_subevent_ag_indication_get_value_length(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value from event HSP_SUBEVENT_AG_INDICATION
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * hsp_subevent_ag_indication_get_value(const uint8_t * event){
    return &event[6];
}

/**
 * @brief Get field acl_handle from event HSP_SUBEVENT_BUTTON_PRESSED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hsp_subevent_button_pressed_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_SERVICE_LEVEL_CONNECTION_ESTABLISHED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_service_level_connection_established_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_SERVICE_LEVEL_CONNECTION_ESTABLISHED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_service_level_connection_established_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field bd_addr from event HFP_SUBEVENT_SERVICE_LEVEL_CONNECTION_ESTABLISHED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hfp_subevent_service_level_connection_established_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[6], bd_addr, 6);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_SERVICE_LEVEL_CONNECTION_RELEASED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_service_level_connection_released_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_AUDIO_CONNECTION_ESTABLISHED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_audio_connection_established_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_AUDIO_CONNECTION_ESTABLISHED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_audio_connection_established_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field sco_handle from event HFP_SUBEVENT_AUDIO_CONNECTION_ESTABLISHED
 * @param event packet
 * @return sco_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_audio_connection_established_get_sco_handle(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field bd_addr from event HFP_SUBEVENT_AUDIO_CONNECTION_ESTABLISHED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hfp_subevent_audio_connection_established_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[8], bd_addr, 6);
}
/**
 * @brief Get field negotiated_codec from event HFP_SUBEVENT_AUDIO_CONNECTION_ESTABLISHED
 * @param event packet
 * @return negotiated_codec
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_audio_connection_established_get_negotiated_codec(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field sco_packet_types from event HFP_SUBEVENT_AUDIO_CONNECTION_ESTABLISHED
 * @param event packet
 * @return sco_packet_types
 * @note: btstack_type 2
 */
static inline uint16_t hfp_subevent_audio_connection_established_get_sco_packet_types(const uint8_t * event){
    return little_endian_read_16(event, 15);
}
/**
 * @brief Get field rx_packet_length from event HFP_SUBEVENT_AUDIO_CONNECTION_ESTABLISHED
 * @param event packet
 * @return rx_packet_length
 * @note: btstack_type 2
 */
static inline uint16_t hfp_subevent_audio_connection_established_get_rx_packet_length(const uint8_t * event){
    return little_endian_read_16(event, 17);
}
/**
 * @brief Get field tx_packet_length from event HFP_SUBEVENT_AUDIO_CONNECTION_ESTABLISHED
 * @param event packet
 * @return tx_packet_length
 * @note: btstack_type 2
 */
static inline uint16_t hfp_subevent_audio_connection_established_get_tx_packet_length(const uint8_t * event){
    return little_endian_read_16(event, 19);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_AUDIO_CONNECTION_RELEASED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_audio_connection_released_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field sco_handle from event HFP_SUBEVENT_AUDIO_CONNECTION_RELEASED
 * @param event packet
 * @return sco_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_audio_connection_released_get_sco_handle(const uint8_t * event){
    return little_endian_read_16(event, 5);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_COMPLETE
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_complete_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_complete_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_AG_INDICATOR_MAPPING
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_ag_indicator_mapping_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field indicator_index from event HFP_SUBEVENT_AG_INDICATOR_MAPPING
 * @param event packet
 * @return indicator_index
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_ag_indicator_mapping_get_indicator_index(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field indicator_min_range from event HFP_SUBEVENT_AG_INDICATOR_MAPPING
 * @param event packet
 * @return indicator_min_range
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_ag_indicator_mapping_get_indicator_min_range(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field indicator_max_range from event HFP_SUBEVENT_AG_INDICATOR_MAPPING
 * @param event packet
 * @return indicator_max_range
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_ag_indicator_mapping_get_indicator_max_range(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field indicator_name from event HFP_SUBEVENT_AG_INDICATOR_MAPPING
 * @param event packet
 * @return indicator_name
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_ag_indicator_mapping_get_indicator_name(const uint8_t * event){
    return (const char *) &event[8];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_AG_INDICATOR_STATUS_CHANGED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_ag_indicator_status_changed_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field indicator_index from event HFP_SUBEVENT_AG_INDICATOR_STATUS_CHANGED
 * @param event packet
 * @return indicator_index
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_ag_indicator_status_changed_get_indicator_index(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field indicator_status from event HFP_SUBEVENT_AG_INDICATOR_STATUS_CHANGED
 * @param event packet
 * @return indicator_status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_ag_indicator_status_changed_get_indicator_status(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field indicator_min_range from event HFP_SUBEVENT_AG_INDICATOR_STATUS_CHANGED
 * @param event packet
 * @return indicator_min_range
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_ag_indicator_status_changed_get_indicator_min_range(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field indicator_max_range from event HFP_SUBEVENT_AG_INDICATOR_STATUS_CHANGED
 * @param event packet
 * @return indicator_max_range
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_ag_indicator_status_changed_get_indicator_max_range(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field indicator_mandatory from event HFP_SUBEVENT_AG_INDICATOR_STATUS_CHANGED
 * @param event packet
 * @return indicator_mandatory
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_ag_indicator_status_changed_get_indicator_mandatory(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field indicator_enabled from event HFP_SUBEVENT_AG_INDICATOR_STATUS_CHANGED
 * @param event packet
 * @return indicator_enabled
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_ag_indicator_status_changed_get_indicator_enabled(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field indicator_status_changed from event HFP_SUBEVENT_AG_INDICATOR_STATUS_CHANGED
 * @param event packet
 * @return indicator_status_changed
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_ag_indicator_status_changed_get_indicator_status_changed(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field indicator_name from event HFP_SUBEVENT_AG_INDICATOR_STATUS_CHANGED
 * @param event packet
 * @return indicator_name
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_ag_indicator_status_changed_get_indicator_name(const uint8_t * event){
    return (const char *) &event[12];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_NETWORK_OPERATOR_CHANGED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_network_operator_changed_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field network_operator_mode from event HFP_SUBEVENT_NETWORK_OPERATOR_CHANGED
 * @param event packet
 * @return network_operator_mode
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_network_operator_changed_get_network_operator_mode(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field network_operator_format from event HFP_SUBEVENT_NETWORK_OPERATOR_CHANGED
 * @param event packet
 * @return network_operator_format
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_network_operator_changed_get_network_operator_format(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field network_operator_name from event HFP_SUBEVENT_NETWORK_OPERATOR_CHANGED
 * @param event packet
 * @return network_operator_name
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_network_operator_changed_get_network_operator_name(const uint8_t * event){
    return (const char *) &event[7];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_EXTENDED_AUDIO_GATEWAY_ERROR
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_extended_audio_gateway_error_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field error from event HFP_SUBEVENT_EXTENDED_AUDIO_GATEWAY_ERROR
 * @param event packet
 * @return error
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_extended_audio_gateway_error_get_error(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_START_RINGING
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_start_ringing_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_RING
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_ring_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_STOP_RINGING
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_stop_ringing_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_PLACE_CALL_WITH_NUMBER
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_place_call_with_number_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field number from event HFP_SUBEVENT_PLACE_CALL_WITH_NUMBER
 * @param event packet
 * @return number
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_place_call_with_number_get_number(const uint8_t * event){
    return (const char *) &event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_ATTACH_NUMBER_TO_VOICE_TAG
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_attach_number_to_voice_tag_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_NUMBER_FOR_VOICE_TAG
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_number_for_voice_tag_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field number from event HFP_SUBEVENT_NUMBER_FOR_VOICE_TAG
 * @param event packet
 * @return number
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_number_for_voice_tag_get_number(const uint8_t * event){
    return (const char *) &event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_TRANSMIT_DTMF_CODES
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_transmit_dtmf_codes_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field dtmf from event HFP_SUBEVENT_TRANSMIT_DTMF_CODES
 * @param event packet
 * @return dtmf
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_transmit_dtmf_codes_get_dtmf(const uint8_t * event){
    return (const char *) &event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_CALL_ANSWERED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_call_answered_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_CALL_TERMINATED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_call_terminated_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_CONFERENCE_CALL
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_conference_call_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_SPEAKER_VOLUME
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_speaker_volume_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field gain from event HFP_SUBEVENT_SPEAKER_VOLUME
 * @param event packet
 * @return gain
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_speaker_volume_get_gain(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_MICROPHONE_VOLUME
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_microphone_volume_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field gain from event HFP_SUBEVENT_MICROPHONE_VOLUME
 * @param event packet
 * @return gain
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_microphone_volume_get_gain(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_CALL_WAITING_NOTIFICATION
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_call_waiting_notification_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field type from event HFP_SUBEVENT_CALL_WAITING_NOTIFICATION
 * @param event packet
 * @return type
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_call_waiting_notification_get_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field number_length from event HFP_SUBEVENT_CALL_WAITING_NOTIFICATION
 * @param event packet
 * @return number_length
 * @note: btstack_type J
 */
static inline uint8_t hfp_subevent_call_waiting_notification_get_number_length(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field number from event HFP_SUBEVENT_CALL_WAITING_NOTIFICATION
 * @param event packet
 * @return number
 * @note: btstack_type V
 */
static inline const uint8_t * hfp_subevent_call_waiting_notification_get_number(const uint8_t * event){
    return &event[7];
}
/**
 * @brief Get field alpha_length from event HFP_SUBEVENT_CALL_WAITING_NOTIFICATION
 * @param event packet
 * @return alpha_length
 * @note: btstack_type J
 */
static inline uint8_t hfp_subevent_call_waiting_notification_get_alpha_length(const uint8_t * event){
    return event[7u + event[6]];
}
/**
 * @brief Get field alpha from event HFP_SUBEVENT_CALL_WAITING_NOTIFICATION
 * @param event packet
 * @return alpha
 * @note: btstack_type V
 */
static inline const uint8_t * hfp_subevent_call_waiting_notification_get_alpha(const uint8_t * event){
    return &event[7u + event[6] + 1u];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_CALLING_LINE_IDENTIFICATION_NOTIFICATION
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_calling_line_identification_notification_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field type from event HFP_SUBEVENT_CALLING_LINE_IDENTIFICATION_NOTIFICATION
 * @param event packet
 * @return type
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_calling_line_identification_notification_get_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field number_length from event HFP_SUBEVENT_CALLING_LINE_IDENTIFICATION_NOTIFICATION
 * @param event packet
 * @return number_length
 * @note: btstack_type J
 */
static inline uint8_t hfp_subevent_calling_line_identification_notification_get_number_length(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field number from event HFP_SUBEVENT_CALLING_LINE_IDENTIFICATION_NOTIFICATION
 * @param event packet
 * @return number
 * @note: btstack_type V
 */
static inline const uint8_t * hfp_subevent_calling_line_identification_notification_get_number(const uint8_t * event){
    return &event[7];
}
/**
 * @brief Get field alpha_length from event HFP_SUBEVENT_CALLING_LINE_IDENTIFICATION_NOTIFICATION
 * @param event packet
 * @return alpha_length
 * @note: btstack_type J
 */
static inline uint8_t hfp_subevent_calling_line_identification_notification_get_alpha_length(const uint8_t * event){
    return event[7u + event[6]];
}
/**
 * @brief Get field alpha from event HFP_SUBEVENT_CALLING_LINE_IDENTIFICATION_NOTIFICATION
 * @param event packet
 * @return alpha
 * @note: btstack_type V
 */
static inline const uint8_t * hfp_subevent_calling_line_identification_notification_get_alpha(const uint8_t * event){
    return &event[7u + event[6] + 1u];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_ENHANCED_CALL_STATUS
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_enhanced_call_status_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field clcc_idx from event HFP_SUBEVENT_ENHANCED_CALL_STATUS
 * @param event packet
 * @return clcc_idx
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_call_status_get_clcc_idx(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field clcc_dir from event HFP_SUBEVENT_ENHANCED_CALL_STATUS
 * @param event packet
 * @return clcc_dir
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_call_status_get_clcc_dir(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field clcc_status from event HFP_SUBEVENT_ENHANCED_CALL_STATUS
 * @param event packet
 * @return clcc_status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_call_status_get_clcc_status(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field clcc_mode from event HFP_SUBEVENT_ENHANCED_CALL_STATUS
 * @param event packet
 * @return clcc_mode
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_call_status_get_clcc_mode(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field clcc_mpty from event HFP_SUBEVENT_ENHANCED_CALL_STATUS
 * @param event packet
 * @return clcc_mpty
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_call_status_get_clcc_mpty(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field bnip_type from event HFP_SUBEVENT_ENHANCED_CALL_STATUS
 * @param event packet
 * @return bnip_type
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_call_status_get_bnip_type(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field bnip_number from event HFP_SUBEVENT_ENHANCED_CALL_STATUS
 * @param event packet
 * @return bnip_number
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_enhanced_call_status_get_bnip_number(const uint8_t * event){
    return (const char *) &event[11];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_SUBSCRIBER_NUMBER_INFORMATION
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_subscriber_number_information_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_SUBSCRIBER_NUMBER_INFORMATION
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_subscriber_number_information_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field bnip_type from event HFP_SUBEVENT_SUBSCRIBER_NUMBER_INFORMATION
 * @param event packet
 * @return bnip_type
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_subscriber_number_information_get_bnip_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field bnip_number from event HFP_SUBEVENT_SUBSCRIBER_NUMBER_INFORMATION
 * @param event packet
 * @return bnip_number
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_subscriber_number_information_get_bnip_number(const uint8_t * event){
    return (const char *) &event[7];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_RESPONSE_AND_HOLD_STATUS
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_response_and_hold_status_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field value from event HFP_SUBEVENT_RESPONSE_AND_HOLD_STATUS
 * @param event packet
 * @return value
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_response_and_hold_status_get_value(const uint8_t * event){
    return (const char *) &event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_AT_MESSAGE_SENT
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_at_message_sent_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command from event HFP_SUBEVENT_AT_MESSAGE_SENT
 * @param event packet
 * @return command
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_at_message_sent_get_command(const uint8_t * event){
    return (const char *) &event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_AT_MESSAGE_RECEIVED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_at_message_received_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command from event HFP_SUBEVENT_AT_MESSAGE_RECEIVED
 * @param event packet
 * @return command
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_at_message_received_get_command(const uint8_t * event){
    return (const char *) &event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_IN_BAND_RING_TONE
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_in_band_ring_tone_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_IN_BAND_RING_TONE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_in_band_ring_tone_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_VOICE_RECOGNITION_ACTIVATED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_voice_recognition_activated_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_VOICE_RECOGNITION_ACTIVATED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_voice_recognition_activated_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field enhanced from event HFP_SUBEVENT_VOICE_RECOGNITION_ACTIVATED
 * @param event packet
 * @return enhanced
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_voice_recognition_activated_get_enhanced(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_VOICE_RECOGNITION_DEACTIVATED
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_voice_recognition_deactivated_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_VOICE_RECOGNITION_DEACTIVATED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_voice_recognition_deactivated_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_HF_READY_FOR_AUDIO
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_enhanced_voice_recognition_hf_ready_for_audio_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_HF_READY_FOR_AUDIO
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_voice_recognition_hf_ready_for_audio_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_READY_TO_ACCEPT_AUDIO_INPUT
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_enhanced_voice_recognition_ag_ready_to_accept_audio_input_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_READY_TO_ACCEPT_AUDIO_INPUT
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_voice_recognition_ag_ready_to_accept_audio_input_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_IS_STARTING_SOUND
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_enhanced_voice_recognition_ag_is_starting_sound_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_IS_STARTING_SOUND
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_voice_recognition_ag_is_starting_sound_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_IS_PROCESSING_AUDIO_INPUT
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_enhanced_voice_recognition_ag_is_processing_audio_input_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_IS_PROCESSING_AUDIO_INPUT
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_voice_recognition_ag_is_processing_audio_input_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_MESSAGE_SENT
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_enhanced_voice_recognition_ag_message_sent_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_MESSAGE_SENT
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_voice_recognition_ag_message_sent_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_MESSAGE
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_enhanced_voice_recognition_ag_message_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field text_id from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_MESSAGE
 * @param event packet
 * @return text_id
 * @note: btstack_type 2
 */
static inline uint16_t hfp_subevent_enhanced_voice_recognition_ag_message_get_text_id(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field text_type from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_MESSAGE
 * @param event packet
 * @return text_type
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_voice_recognition_ag_message_get_text_type(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field text_operation from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_MESSAGE
 * @param event packet
 * @return text_operation
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_enhanced_voice_recognition_ag_message_get_text_operation(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field text_length from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_MESSAGE
 * @param event packet
 * @return text_length
 * @note: btstack_type L
 */
static inline uint16_t hfp_subevent_enhanced_voice_recognition_ag_message_get_text_length(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field text from event HFP_SUBEVENT_ENHANCED_VOICE_RECOGNITION_AG_MESSAGE
 * @param event packet
 * @return text
 * @note: btstack_type V
 */
static inline const uint8_t * hfp_subevent_enhanced_voice_recognition_ag_message_get_text(const uint8_t * event){
    return &event[11];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_ECHO_CANCELING_AND_NOISE_REDUCTION_DEACTIVATE
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_echo_canceling_and_noise_reduction_deactivate_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_ECHO_CANCELING_AND_NOISE_REDUCTION_DEACTIVATE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_echo_canceling_and_noise_reduction_deactivate_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_HF_INDICATOR
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_hf_indicator_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field uuid from event HFP_SUBEVENT_HF_INDICATOR
 * @param event packet
 * @return uuid
 * @note: btstack_type 2
 */
static inline uint16_t hfp_subevent_hf_indicator_get_uuid(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field value from event HFP_SUBEVENT_HF_INDICATOR
 * @param event packet
 * @return value
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_hf_indicator_get_value(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_CUSTOM_AT_COMMAND
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_custom_at_command_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_id from event HFP_SUBEVENT_CUSTOM_AT_COMMAND
 * @param event packet
 * @return command_id
 * @note: btstack_type 2
 */
static inline uint16_t hfp_subevent_custom_at_command_get_command_id(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field command_string from event HFP_SUBEVENT_CUSTOM_AT_COMMAND
 * @param event packet
 * @return command_string
 * @note: btstack_type T
 */
static inline const char * hfp_subevent_custom_at_command_get_command_string(const uint8_t * event){
    return (const char *) &event[7];
}

/**
 * @brief Get field acl_handle from event HFP_SUBEVENT_CUSTOM_AT_MESSAGE_SENT
 * @param event packet
 * @return acl_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hfp_subevent_custom_at_message_sent_get_acl_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HFP_SUBEVENT_CUSTOM_AT_MESSAGE_SENT
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hfp_subevent_custom_at_message_sent_get_status(const uint8_t * event){
    return event[5];
}

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event ANCS_SUBEVENT_CLIENT_CONNECTED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t ancs_subevent_client_connected_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event ANCS_SUBEVENT_CLIENT_NOTIFICATION
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t ancs_subevent_client_notification_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field attribute_id from event ANCS_SUBEVENT_CLIENT_NOTIFICATION
 * @param event packet
 * @return attribute_id
 * @note: btstack_type 2
 */
static inline uint16_t ancs_subevent_client_notification_get_attribute_id(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field text from event ANCS_SUBEVENT_CLIENT_NOTIFICATION
 * @param event packet
 * @return text
 * @note: btstack_type T
 */
static inline const char * ancs_subevent_client_notification_get_text(const uint8_t * event){
    return (const char *) &event[7];
}
#endif

#ifdef ENABLE_BLE
/**
 * @brief Get field handle from event ANCS_SUBEVENT_CLIENT_DISCONNECTED
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t ancs_subevent_client_disconnected_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
#endif

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_ACCEPT
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_accept_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_SIGNALING_ACCEPT
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_accept_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field is_initiator from event AVDTP_SUBEVENT_SIGNALING_ACCEPT
 * @param event packet
 * @return is_initiator
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_accept_get_is_initiator(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field signal_identifier from event AVDTP_SUBEVENT_SIGNALING_ACCEPT
 * @param event packet
 * @return signal_identifier
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_accept_get_signal_identifier(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_REJECT
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_reject_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_SIGNALING_REJECT
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_reject_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field is_initiator from event AVDTP_SUBEVENT_SIGNALING_REJECT
 * @param event packet
 * @return is_initiator
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_reject_get_is_initiator(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field signal_identifier from event AVDTP_SUBEVENT_SIGNALING_REJECT
 * @param event packet
 * @return signal_identifier
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_reject_get_signal_identifier(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_GENERAL_REJECT
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_general_reject_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_SIGNALING_GENERAL_REJECT
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_general_reject_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field is_initiator from event AVDTP_SUBEVENT_SIGNALING_GENERAL_REJECT
 * @param event packet
 * @return is_initiator
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_general_reject_get_is_initiator(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field signal_identifier from event AVDTP_SUBEVENT_SIGNALING_GENERAL_REJECT
 * @param event packet
 * @return signal_identifier
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_general_reject_get_signal_identifier(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_connection_established_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field bd_addr from event AVDTP_SUBEVENT_SIGNALING_CONNECTION_ESTABLISHED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void avdtp_subevent_signaling_connection_established_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[5], bd_addr, 6);
}
/**
 * @brief Get field con_handle from event AVDTP_SUBEVENT_SIGNALING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_connection_established_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 11);
}
/**
 * @brief Get field status from event AVDTP_SUBEVENT_SIGNALING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_connection_established_get_status(const uint8_t * event){
    return event[13];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_CONNECTION_RELEASED
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_connection_released_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_SEP_FOUND
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_sep_found_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_SEP_FOUND
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_sep_found_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field in_use from event AVDTP_SUBEVENT_SIGNALING_SEP_FOUND
 * @param event packet
 * @return in_use
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_sep_found_get_in_use(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_SEP_FOUND
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_sep_found_get_media_type(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field sep_type from event AVDTP_SUBEVENT_SIGNALING_SEP_FOUND
 * @param event packet
 * @return sep_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_sep_found_get_sep_type(const uint8_t * event){
    return event[8];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_sbc_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_capability_get_media_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field sampling_frequency_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return sampling_frequency_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_capability_get_sampling_frequency_bitmap(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field channel_mode_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return channel_mode_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_capability_get_channel_mode_bitmap(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field block_length_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return block_length_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_capability_get_block_length_bitmap(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field subbands_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return subbands_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_capability_get_subbands_bitmap(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field allocation_method_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return allocation_method_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_capability_get_allocation_method_bitmap(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field min_bitpool_value from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return min_bitpool_value
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_capability_get_min_bitpool_value(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field max_bitpool_value from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return max_bitpool_value
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_capability_get_max_bitpool_value(const uint8_t * event){
    return event[13];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_mpeg_audio_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_capability_get_media_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field layer_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return layer_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_capability_get_layer_bitmap(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field crc from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return crc
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_capability_get_crc(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field channel_mode_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return channel_mode_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_capability_get_channel_mode_bitmap(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field media_payload_format from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return media_payload_format
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_capability_get_media_payload_format(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field sampling_frequency_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return sampling_frequency_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_capability_get_sampling_frequency_bitmap(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field vbr from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_capability_get_vbr(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field bit_rate_index_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return bit_rate_index_bitmap
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_mpeg_audio_capability_get_bit_rate_index_bitmap(const uint8_t * event){
    return little_endian_read_16(event, 13);
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_mpeg_aac_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_capability_get_media_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field object_type_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return object_type_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_capability_get_object_type_bitmap(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field sampling_frequency_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return sampling_frequency_bitmap
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_mpeg_aac_capability_get_sampling_frequency_bitmap(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field channels_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return channels_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_capability_get_channels_bitmap(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field bit_rate from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return bit_rate
 * @note: btstack_type 3
 */
static inline uint32_t avdtp_subevent_signaling_media_codec_mpeg_aac_capability_get_bit_rate(const uint8_t * event){
    return little_endian_read_24(event, 11);
}
/**
 * @brief Get field vbr from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_capability_get_vbr(const uint8_t * event){
    return event[14];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_atrac_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_capability_get_media_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field version from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return version
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_capability_get_version(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field channel_mode_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return channel_mode_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_capability_get_channel_mode_bitmap(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field sampling_frequency_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return sampling_frequency_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_capability_get_sampling_frequency_bitmap(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field vbr from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_capability_get_vbr(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field bit_rate_index_bitmap from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return bit_rate_index_bitmap
 * @note: btstack_type 3
 */
static inline uint32_t avdtp_subevent_signaling_media_codec_atrac_capability_get_bit_rate_index_bitmap(const uint8_t * event){
    return little_endian_read_24(event, 11);
}
/**
 * @brief Get field maximum_sul from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return maximum_sul
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_atrac_capability_get_maximum_sul(const uint8_t * event){
    return little_endian_read_16(event, 14);
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_other_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_other_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_other_capability_get_media_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field media_codec_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return media_codec_type
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_other_capability_get_media_codec_type(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field media_codec_information_len from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return media_codec_information_len
 * @note: btstack_type L
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_other_capability_get_media_codec_information_len(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field media_codec_information from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return media_codec_information
 * @note: btstack_type V
 */
static inline const uint8_t * avdtp_subevent_signaling_media_codec_other_capability_get_media_codec_information(const uint8_t * event){
    return &event[11];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_TRANSPORT_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_transport_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_TRANSPORT_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_transport_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_REPORTING_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_reporting_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_REPORTING_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_reporting_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_RECOVERY_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_recovery_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_RECOVERY_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_recovery_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field recovery_type from event AVDTP_SUBEVENT_SIGNALING_RECOVERY_CAPABILITY
 * @param event packet
 * @return recovery_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_recovery_capability_get_recovery_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field maximum_recovery_window_size from event AVDTP_SUBEVENT_SIGNALING_RECOVERY_CAPABILITY
 * @param event packet
 * @return maximum_recovery_window_size
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_recovery_capability_get_maximum_recovery_window_size(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field maximum_number_media_packets from event AVDTP_SUBEVENT_SIGNALING_RECOVERY_CAPABILITY
 * @param event packet
 * @return maximum_number_media_packets
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_recovery_capability_get_maximum_number_media_packets(const uint8_t * event){
    return event[8];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_CONTENT_PROTECTION_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_content_protection_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_CONTENT_PROTECTION_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_content_protection_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field cp_type from event AVDTP_SUBEVENT_SIGNALING_CONTENT_PROTECTION_CAPABILITY
 * @param event packet
 * @return cp_type
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_content_protection_capability_get_cp_type(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field cp_type_value_len from event AVDTP_SUBEVENT_SIGNALING_CONTENT_PROTECTION_CAPABILITY
 * @param event packet
 * @return cp_type_value_len
 * @note: btstack_type L
 */
static inline uint16_t avdtp_subevent_signaling_content_protection_capability_get_cp_type_value_len(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field cp_type_value from event AVDTP_SUBEVENT_SIGNALING_CONTENT_PROTECTION_CAPABILITY
 * @param event packet
 * @return cp_type_value
 * @note: btstack_type V
 */
static inline const uint8_t * avdtp_subevent_signaling_content_protection_capability_get_cp_type_value(const uint8_t * event){
    return &event[10];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MULTIPLEXING_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_multiplexing_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MULTIPLEXING_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_multiplexing_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field fragmentation from event AVDTP_SUBEVENT_SIGNALING_MULTIPLEXING_CAPABILITY
 * @param event packet
 * @return fragmentation
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_multiplexing_capability_get_fragmentation(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field transport_identifiers_num from event AVDTP_SUBEVENT_SIGNALING_MULTIPLEXING_CAPABILITY
 * @param event packet
 * @return transport_identifiers_num
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_multiplexing_capability_get_transport_identifiers_num(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field transport_session_identifier_1 from event AVDTP_SUBEVENT_SIGNALING_MULTIPLEXING_CAPABILITY
 * @param event packet
 * @return transport_session_identifier_1
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_multiplexing_capability_get_transport_session_identifier_1(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field transport_session_identifier_2 from event AVDTP_SUBEVENT_SIGNALING_MULTIPLEXING_CAPABILITY
 * @param event packet
 * @return transport_session_identifier_2
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_multiplexing_capability_get_transport_session_identifier_2(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field transport_session_identifier_3 from event AVDTP_SUBEVENT_SIGNALING_MULTIPLEXING_CAPABILITY
 * @param event packet
 * @return transport_session_identifier_3
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_multiplexing_capability_get_transport_session_identifier_3(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field tcid_1 from event AVDTP_SUBEVENT_SIGNALING_MULTIPLEXING_CAPABILITY
 * @param event packet
 * @return tcid_1
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_multiplexing_capability_get_tcid_1(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field tcid_2 from event AVDTP_SUBEVENT_SIGNALING_MULTIPLEXING_CAPABILITY
 * @param event packet
 * @return tcid_2
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_multiplexing_capability_get_tcid_2(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field tcid_3 from event AVDTP_SUBEVENT_SIGNALING_MULTIPLEXING_CAPABILITY
 * @param event packet
 * @return tcid_3
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_multiplexing_capability_get_tcid_3(const uint8_t * event){
    return event[13];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_DELAY_REPORTING_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_delay_reporting_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_DELAY_REPORTING_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_delay_reporting_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_HEADER_COMPRESSION_CAPABILITY
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_header_compression_capability_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_HEADER_COMPRESSION_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_header_compression_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field back_ch from event AVDTP_SUBEVENT_SIGNALING_HEADER_COMPRESSION_CAPABILITY
 * @param event packet
 * @return back_ch
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_header_compression_capability_get_back_ch(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field media from event AVDTP_SUBEVENT_SIGNALING_HEADER_COMPRESSION_CAPABILITY
 * @param event packet
 * @return media
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_header_compression_capability_get_media(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field recovery from event AVDTP_SUBEVENT_SIGNALING_HEADER_COMPRESSION_CAPABILITY
 * @param event packet
 * @return recovery
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_header_compression_capability_get_recovery(const uint8_t * event){
    return event[8];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_CAPABILITIES_DONE
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_capabilities_done_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_CAPABILITIES_DONE
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_capabilities_done_get_remote_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_remote_seid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field reconfigure from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return reconfigure
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_reconfigure(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_media_type(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field sampling_frequency from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return sampling_frequency
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_sampling_frequency(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field channel_mode from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return channel_mode
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_channel_mode(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field num_channels from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return num_channels
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_num_channels(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field block_length from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return block_length
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_block_length(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field subbands from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return subbands
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_subbands(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field allocation_method from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return allocation_method
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_allocation_method(const uint8_t * event){
    return event[15];
}
/**
 * @brief Get field min_bitpool_value from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return min_bitpool_value
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_min_bitpool_value(const uint8_t * event){
    return event[16];
}
/**
 * @brief Get field max_bitpool_value from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return max_bitpool_value
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_sbc_configuration_get_max_bitpool_value(const uint8_t * event){
    return event[17];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_remote_seid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field reconfigure from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return reconfigure
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_reconfigure(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_media_type(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field layer from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return layer
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_layer(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field crc from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return crc
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_crc(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field channel_mode from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return channel_mode
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_channel_mode(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field num_channels from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return num_channels
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_num_channels(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field media_payload_format from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return media_payload_format
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_media_payload_format(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field sampling_frequency from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return sampling_frequency
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_sampling_frequency(const uint8_t * event){
    return little_endian_read_16(event, 14);
}
/**
 * @brief Get field vbr from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_vbr(const uint8_t * event){
    return event[16];
}
/**
 * @brief Get field bit_rate_index from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return bit_rate_index
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_audio_configuration_get_bit_rate_index(const uint8_t * event){
    return event[17];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_mpeg_aac_configuration_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_configuration_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_configuration_get_remote_seid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field reconfigure from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return reconfigure
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_configuration_get_reconfigure(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_configuration_get_media_type(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field object_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return object_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_configuration_get_object_type(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field sampling_frequency from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return sampling_frequency
 * @note: btstack_type 3
 */
static inline uint32_t avdtp_subevent_signaling_media_codec_mpeg_aac_configuration_get_sampling_frequency(const uint8_t * event){
    return little_endian_read_24(event, 10);
}
/**
 * @brief Get field num_channels from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return num_channels
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_configuration_get_num_channels(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field bit_rate from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return bit_rate
 * @note: btstack_type 3
 */
static inline uint32_t avdtp_subevent_signaling_media_codec_mpeg_aac_configuration_get_bit_rate(const uint8_t * event){
    return little_endian_read_24(event, 14);
}
/**
 * @brief Get field vbr from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_mpeg_aac_configuration_get_vbr(const uint8_t * event){
    return event[17];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_remote_seid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field reconfigure from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return reconfigure
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_reconfigure(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_media_type(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field version from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return version
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_version(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field channel_mode from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return channel_mode
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_channel_mode(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field num_channels from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return num_channels
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_num_channels(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field sampling_frequency from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return sampling_frequency
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_sampling_frequency(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field vbr from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_vbr(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field bit_rate_index from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return bit_rate_index
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_bit_rate_index(const uint8_t * event){
    return event[15];
}
/**
 * @brief Get field maximum_sul from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return maximum_sul
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_atrac_configuration_get_maximum_sul(const uint8_t * event){
    return little_endian_read_16(event, 16);
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_other_configuration_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_other_configuration_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_other_configuration_get_remote_seid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field reconfigure from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return reconfigure
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_other_configuration_get_reconfigure(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field media_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_media_codec_other_configuration_get_media_type(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field media_codec_type from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return media_codec_type
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_other_configuration_get_media_codec_type(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field media_codec_information_len from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return media_codec_information_len
 * @note: btstack_type L
 */
static inline uint16_t avdtp_subevent_signaling_media_codec_other_configuration_get_media_codec_information_len(const uint8_t * event){
    return little_endian_read_16(event, 11);
}
/**
 * @brief Get field media_codec_information from event AVDTP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return media_codec_information
 * @note: btstack_type V
 */
static inline const uint8_t * avdtp_subevent_signaling_media_codec_other_configuration_get_media_codec_information(const uint8_t * event){
    return &event[13];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_STREAMING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_streaming_connection_established_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field bd_addr from event AVDTP_SUBEVENT_STREAMING_CONNECTION_ESTABLISHED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void avdtp_subevent_streaming_connection_established_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[5], bd_addr, 6);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_STREAMING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_streaming_connection_established_get_local_seid(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field remote_seid from event AVDTP_SUBEVENT_STREAMING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_streaming_connection_established_get_remote_seid(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field status from event AVDTP_SUBEVENT_STREAMING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_streaming_connection_established_get_status(const uint8_t * event){
    return event[13];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_STREAMING_CONNECTION_RELEASED
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_streaming_connection_released_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_STREAMING_CONNECTION_RELEASED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_streaming_connection_released_get_local_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_STREAMING_CAN_SEND_MEDIA_PACKET_NOW
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_streaming_can_send_media_packet_now_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_STREAMING_CAN_SEND_MEDIA_PACKET_NOW
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_streaming_can_send_media_packet_now_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field sequence_number from event AVDTP_SUBEVENT_STREAMING_CAN_SEND_MEDIA_PACKET_NOW
 * @param event packet
 * @return sequence_number
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_streaming_can_send_media_packet_now_get_sequence_number(const uint8_t * event){
    return little_endian_read_16(event, 6);
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_SEP_DICOVERY_DONE
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_sep_dicovery_done_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field avdtp_cid from event AVDTP_SUBEVENT_SIGNALING_DELAY_REPORT
 * @param event packet
 * @return avdtp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_delay_report_get_avdtp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event AVDTP_SUBEVENT_SIGNALING_DELAY_REPORT
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t avdtp_subevent_signaling_delay_report_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field delay_100us from event AVDTP_SUBEVENT_SIGNALING_DELAY_REPORT
 * @param event packet
 * @return delay_100us
 * @note: btstack_type 2
 */
static inline uint16_t avdtp_subevent_signaling_delay_report_get_delay_100us(const uint8_t * event){
    return little_endian_read_16(event, 6);
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_STREAMING_CAN_SEND_MEDIA_PACKET_NOW
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_streaming_can_send_media_packet_now_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_STREAMING_CAN_SEND_MEDIA_PACKET_NOW
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_streaming_can_send_media_packet_now_get_local_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_remote_seid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field reconfigure from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return reconfigure
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_reconfigure(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field media_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_media_type(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field sampling_frequency from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return sampling_frequency
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_sampling_frequency(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field channel_mode from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return channel_mode
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_channel_mode(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field num_channels from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return num_channels
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_num_channels(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field block_length from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return block_length
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_block_length(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field subbands from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return subbands
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_subbands(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field allocation_method from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return allocation_method
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_allocation_method(const uint8_t * event){
    return event[15];
}
/**
 * @brief Get field min_bitpool_value from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return min_bitpool_value
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_min_bitpool_value(const uint8_t * event){
    return event[16];
}
/**
 * @brief Get field max_bitpool_value from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CONFIGURATION
 * @param event packet
 * @return max_bitpool_value
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_configuration_get_max_bitpool_value(const uint8_t * event){
    return event[17];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_remote_seid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field reconfigure from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return reconfigure
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_reconfigure(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field media_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_media_type(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field layer from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return layer
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_layer(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field crc from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return crc
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_crc(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field channel_mode from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return channel_mode
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_channel_mode(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field num_channels from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return num_channels
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_num_channels(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field media_payload_format from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return media_payload_format
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_media_payload_format(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field sampling_frequency from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return sampling_frequency
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_sampling_frequency(const uint8_t * event){
    return little_endian_read_16(event, 14);
}
/**
 * @brief Get field vbr from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_vbr(const uint8_t * event){
    return event[16];
}
/**
 * @brief Get field bit_rate_index from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CONFIGURATION
 * @param event packet
 * @return bit_rate_index
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_configuration_get_bit_rate_index(const uint8_t * event){
    return event[17];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_mpeg_aac_configuration_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_configuration_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_configuration_get_remote_seid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field reconfigure from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return reconfigure
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_configuration_get_reconfigure(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field media_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_configuration_get_media_type(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field object_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return object_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_configuration_get_object_type(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field sampling_frequency from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return sampling_frequency
 * @note: btstack_type 3
 */
static inline uint32_t a2dp_subevent_signaling_media_codec_mpeg_aac_configuration_get_sampling_frequency(const uint8_t * event){
    return little_endian_read_24(event, 10);
}
/**
 * @brief Get field num_channels from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return num_channels
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_configuration_get_num_channels(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field bit_rate from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return bit_rate
 * @note: btstack_type 3
 */
static inline uint32_t a2dp_subevent_signaling_media_codec_mpeg_aac_configuration_get_bit_rate(const uint8_t * event){
    return little_endian_read_24(event, 14);
}
/**
 * @brief Get field vbr from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CONFIGURATION
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_configuration_get_vbr(const uint8_t * event){
    return event[17];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_remote_seid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field reconfigure from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return reconfigure
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_reconfigure(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field media_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_media_type(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field version from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return version
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_version(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field channel_mode from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return channel_mode
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_channel_mode(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field num_channels from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return num_channels
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_num_channels(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field sampling_frequency from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return sampling_frequency
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_sampling_frequency(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field vbr from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_vbr(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field bit_rate_index from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return bit_rate_index
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_bit_rate_index(const uint8_t * event){
    return event[15];
}
/**
 * @brief Get field maximum_sul from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CONFIGURATION
 * @param event packet
 * @return maximum_sul
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_atrac_configuration_get_maximum_sul(const uint8_t * event){
    return little_endian_read_16(event, 16);
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_other_configuration_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_other_configuration_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_other_configuration_get_remote_seid(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field reconfigure from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return reconfigure
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_other_configuration_get_reconfigure(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field media_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_other_configuration_get_media_type(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field media_codec_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return media_codec_type
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_other_configuration_get_media_codec_type(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field media_codec_information_len from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return media_codec_information_len
 * @note: btstack_type L
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_other_configuration_get_media_codec_information_len(const uint8_t * event){
    return little_endian_read_16(event, 11);
}
/**
 * @brief Get field media_codec_information from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CONFIGURATION
 * @param event packet
 * @return media_codec_information
 * @note: btstack_type V
 */
static inline const uint8_t * a2dp_subevent_signaling_media_codec_other_configuration_get_media_codec_information(const uint8_t * event){
    return &event[13];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_STREAM_ESTABLISHED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_stream_established_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field bd_addr from event A2DP_SUBEVENT_STREAM_ESTABLISHED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void a2dp_subevent_stream_established_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[5], bd_addr, 6);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_STREAM_ESTABLISHED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_stream_established_get_local_seid(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_STREAM_ESTABLISHED
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_stream_established_get_remote_seid(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field status from event A2DP_SUBEVENT_STREAM_ESTABLISHED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_stream_established_get_status(const uint8_t * event){
    return event[13];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_START_STREAM_REQUESTED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_start_stream_requested_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_START_STREAM_REQUESTED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_start_stream_requested_get_local_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_STREAM_STARTED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_stream_started_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_STREAM_STARTED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_stream_started_get_local_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_STREAM_SUSPENDED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_stream_suspended_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_STREAM_SUSPENDED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_stream_suspended_get_local_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_STREAM_STOPPED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_stream_stopped_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_STREAM_STOPPED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_stream_stopped_get_local_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_STREAM_RELEASED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_stream_released_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_STREAM_RELEASED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_stream_released_get_local_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_COMMAND_ACCEPTED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_command_accepted_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_COMMAND_ACCEPTED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_command_accepted_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field signal_identifier from event A2DP_SUBEVENT_COMMAND_ACCEPTED
 * @param event packet
 * @return signal_identifier
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_command_accepted_get_signal_identifier(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_COMMAND_REJECTED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_command_rejected_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_COMMAND_REJECTED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_command_rejected_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field is_initiator from event A2DP_SUBEVENT_COMMAND_REJECTED
 * @param event packet
 * @return is_initiator
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_command_rejected_get_is_initiator(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field signal_identifier from event A2DP_SUBEVENT_COMMAND_REJECTED
 * @param event packet
 * @return signal_identifier
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_command_rejected_get_signal_identifier(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_connection_established_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field bd_addr from event A2DP_SUBEVENT_SIGNALING_CONNECTION_ESTABLISHED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void a2dp_subevent_signaling_connection_established_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[5], bd_addr, 6);
}
/**
 * @brief Get field con_handle from event A2DP_SUBEVENT_SIGNALING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_connection_established_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 11);
}
/**
 * @brief Get field status from event A2DP_SUBEVENT_SIGNALING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_connection_established_get_status(const uint8_t * event){
    return event[13];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_CONNECTION_RELEASED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_connection_released_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_STREAM_RECONFIGURED
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_stream_reconfigured_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_STREAM_RECONFIGURED
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_stream_reconfigured_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field status from event A2DP_SUBEVENT_STREAM_RECONFIGURED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_stream_reconfigured_get_status(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_sbc_capability_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field media_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_capability_get_media_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field sampling_frequency_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return sampling_frequency_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_capability_get_sampling_frequency_bitmap(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field channel_mode_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return channel_mode_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_capability_get_channel_mode_bitmap(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field block_length_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return block_length_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_capability_get_block_length_bitmap(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field subbands_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return subbands_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_capability_get_subbands_bitmap(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field allocation_method_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return allocation_method_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_capability_get_allocation_method_bitmap(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field min_bitpool_value from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return min_bitpool_value
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_capability_get_min_bitpool_value(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field max_bitpool_value from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_SBC_CAPABILITY
 * @param event packet
 * @return max_bitpool_value
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_sbc_capability_get_max_bitpool_value(const uint8_t * event){
    return event[13];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_mpeg_audio_capability_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field media_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_capability_get_media_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field layer_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return layer_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_capability_get_layer_bitmap(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field crc from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return crc
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_capability_get_crc(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field channel_mode_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return channel_mode_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_capability_get_channel_mode_bitmap(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field media_payload_format from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return media_payload_format
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_capability_get_media_payload_format(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field sampling_frequency_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return sampling_frequency_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_capability_get_sampling_frequency_bitmap(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field vbr from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_audio_capability_get_vbr(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field bit_rate_index_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AUDIO_CAPABILITY
 * @param event packet
 * @return bit_rate_index_bitmap
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_mpeg_audio_capability_get_bit_rate_index_bitmap(const uint8_t * event){
    return little_endian_read_16(event, 13);
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_mpeg_aac_capability_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field media_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_capability_get_media_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field object_type_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return object_type_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_capability_get_object_type_bitmap(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field sampling_frequency_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return sampling_frequency_bitmap
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_mpeg_aac_capability_get_sampling_frequency_bitmap(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field channels_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return channels_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_capability_get_channels_bitmap(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field bit_rate from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return bit_rate
 * @note: btstack_type 3
 */
static inline uint32_t a2dp_subevent_signaling_media_codec_mpeg_aac_capability_get_bit_rate(const uint8_t * event){
    return little_endian_read_24(event, 11);
}
/**
 * @brief Get field vbr from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_MPEG_AAC_CAPABILITY
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_mpeg_aac_capability_get_vbr(const uint8_t * event){
    return event[14];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_atrac_capability_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field media_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_capability_get_media_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field version from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return version
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_capability_get_version(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field channel_mode_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return channel_mode_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_capability_get_channel_mode_bitmap(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field sampling_frequency_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return sampling_frequency_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_capability_get_sampling_frequency_bitmap(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field vbr from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return vbr
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_atrac_capability_get_vbr(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field bit_rate_index_bitmap from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return bit_rate_index_bitmap
 * @note: btstack_type 3
 */
static inline uint32_t a2dp_subevent_signaling_media_codec_atrac_capability_get_bit_rate_index_bitmap(const uint8_t * event){
    return little_endian_read_24(event, 11);
}
/**
 * @brief Get field maximum_sul from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_ATRAC_CAPABILITY
 * @param event packet
 * @return maximum_sul
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_atrac_capability_get_maximum_sul(const uint8_t * event){
    return little_endian_read_16(event, 14);
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_other_capability_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_other_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field media_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return media_type
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_media_codec_other_capability_get_media_type(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field media_codec_type from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return media_codec_type
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_other_capability_get_media_codec_type(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field media_codec_information_len from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return media_codec_information_len
 * @note: btstack_type L
 */
static inline uint16_t a2dp_subevent_signaling_media_codec_other_capability_get_media_codec_information_len(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field media_codec_information from event A2DP_SUBEVENT_SIGNALING_MEDIA_CODEC_OTHER_CAPABILITY
 * @param event packet
 * @return media_codec_information
 * @note: btstack_type V
 */
static inline const uint8_t * a2dp_subevent_signaling_media_codec_other_capability_get_media_codec_information(const uint8_t * event){
    return &event[11];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_DELAY_REPORTING_CAPABILITY
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_delay_reporting_capability_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_DELAY_REPORTING_CAPABILITY
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_delay_reporting_capability_get_remote_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_DELAY_REPORT
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_delay_report_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field local_seid from event A2DP_SUBEVENT_SIGNALING_DELAY_REPORT
 * @param event packet
 * @return local_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_delay_report_get_local_seid(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field delay_100us from event A2DP_SUBEVENT_SIGNALING_DELAY_REPORT
 * @param event packet
 * @return delay_100us
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_delay_report_get_delay_100us(const uint8_t * event){
    return little_endian_read_16(event, 6);
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_CAPABILITIES_DONE
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_capabilities_done_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field remote_seid from event A2DP_SUBEVENT_SIGNALING_CAPABILITIES_DONE
 * @param event packet
 * @return remote_seid
 * @note: btstack_type 1
 */
static inline uint8_t a2dp_subevent_signaling_capabilities_done_get_remote_seid(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field a2dp_cid from event A2DP_SUBEVENT_SIGNALING_CAPABILITIES_COMPLETE
 * @param event packet
 * @return a2dp_cid
 * @note: btstack_type 2
 */
static inline uint16_t a2dp_subevent_signaling_capabilities_complete_get_a2dp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_PLAYBACK_STATUS_CHANGED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_playback_status_changed_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_PLAYBACK_STATUS_CHANGED
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_playback_status_changed_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field play_status from event AVRCP_SUBEVENT_NOTIFICATION_PLAYBACK_STATUS_CHANGED
 * @param event packet
 * @return play_status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_playback_status_changed_get_play_status(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_TRACK_CHANGED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_track_changed_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_TRACK_CHANGED
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_track_changed_get_command_type(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_TRACK_REACHED_END
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_event_track_reached_end_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_TRACK_REACHED_END
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_event_track_reached_end_get_command_type(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_TRACK_REACHED_START
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_event_track_reached_start_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_TRACK_REACHED_START
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_event_track_reached_start_get_command_type(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_PLAYBACK_POS_CHANGED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_event_playback_pos_changed_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_PLAYBACK_POS_CHANGED
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_event_playback_pos_changed_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field playback_position from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_PLAYBACK_POS_CHANGED
 * @param event packet
 * @return playback_position
 * @note: btstack_type 4
 */
static inline uint32_t avrcp_subevent_notification_event_playback_pos_changed_get_playback_position(const uint8_t * event){
    return little_endian_read_32(event, 6);
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_BATT_STATUS_CHANGED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_event_batt_status_changed_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_BATT_STATUS_CHANGED
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_event_batt_status_changed_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field battery_status from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_BATT_STATUS_CHANGED
 * @param event packet
 * @return battery_status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_event_batt_status_changed_get_battery_status(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_SYSTEM_STATUS_CHANGED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_event_system_status_changed_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_SYSTEM_STATUS_CHANGED
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_event_system_status_changed_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field system_status from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_SYSTEM_STATUS_CHANGED
 * @param event packet
 * @return system_status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_event_system_status_changed_get_system_status(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_NOW_PLAYING_CONTENT_CHANGED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_now_playing_content_changed_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_NOW_PLAYING_CONTENT_CHANGED
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_now_playing_content_changed_get_command_type(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_AVAILABLE_PLAYERS_CHANGED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_available_players_changed_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_AVAILABLE_PLAYERS_CHANGED
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_available_players_changed_get_command_type(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_UIDS_CHANGED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_event_uids_changed_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_UIDS_CHANGED
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_event_uids_changed_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field uid_counter from event AVRCP_SUBEVENT_NOTIFICATION_EVENT_UIDS_CHANGED
 * @param event packet
 * @return uid_counter
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_event_uids_changed_get_uid_counter(const uint8_t * event){
    return little_endian_read_16(event, 6);
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_VOLUME_CHANGED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_volume_changed_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_VOLUME_CHANGED
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_volume_changed_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field absolute_volume from event AVRCP_SUBEVENT_NOTIFICATION_VOLUME_CHANGED
 * @param event packet
 * @return absolute_volume
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_volume_changed_get_absolute_volume(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_SET_ABSOLUTE_VOLUME_RESPONSE
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_set_absolute_volume_response_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_SET_ABSOLUTE_VOLUME_RESPONSE
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_set_absolute_volume_response_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field absolute_volume from event AVRCP_SUBEVENT_SET_ABSOLUTE_VOLUME_RESPONSE
 * @param event packet
 * @return absolute_volume
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_set_absolute_volume_response_get_absolute_volume(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_STATE
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_state_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event AVRCP_SUBEVENT_NOTIFICATION_STATE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_state_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field enabled from event AVRCP_SUBEVENT_NOTIFICATION_STATE
 * @param event packet
 * @return enabled
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_state_get_enabled(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field event_id from event AVRCP_SUBEVENT_NOTIFICATION_STATE
 * @param event packet
 * @return event_id
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_state_get_event_id(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field status from event AVRCP_SUBEVENT_CONNECTION_ESTABLISHED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_connection_established_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_CONNECTION_ESTABLISHED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_connection_established_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field bd_addr from event AVRCP_SUBEVENT_CONNECTION_ESTABLISHED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void avrcp_subevent_connection_established_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[6], bd_addr, 6);
}
/**
 * @brief Get field con_handle from event AVRCP_SUBEVENT_CONNECTION_ESTABLISHED
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_connection_established_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 12);
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_CONNECTION_RELEASED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_connection_released_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_SHUFFLE_AND_REPEAT_MODE
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_shuffle_and_repeat_mode_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_SHUFFLE_AND_REPEAT_MODE
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_shuffle_and_repeat_mode_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field repeat_mode from event AVRCP_SUBEVENT_SHUFFLE_AND_REPEAT_MODE
 * @param event packet
 * @return repeat_mode
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_shuffle_and_repeat_mode_get_repeat_mode(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field shuffle_mode from event AVRCP_SUBEVENT_SHUFFLE_AND_REPEAT_MODE
 * @param event packet
 * @return shuffle_mode
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_shuffle_and_repeat_mode_get_shuffle_mode(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_PLAY_STATUS
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_play_status_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_PLAY_STATUS
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_play_status_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field song_length from event AVRCP_SUBEVENT_PLAY_STATUS
 * @param event packet
 * @return song_length
 * @note: btstack_type 4
 */
static inline uint32_t avrcp_subevent_play_status_get_song_length(const uint8_t * event){
    return little_endian_read_32(event, 6);
}
/**
 * @brief Get field song_position from event AVRCP_SUBEVENT_PLAY_STATUS
 * @param event packet
 * @return song_position
 * @note: btstack_type 4
 */
static inline uint32_t avrcp_subevent_play_status_get_song_position(const uint8_t * event){
    return little_endian_read_32(event, 10);
}
/**
 * @brief Get field play_status from event AVRCP_SUBEVENT_PLAY_STATUS
 * @param event packet
 * @return play_status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_play_status_get_play_status(const uint8_t * event){
    return event[14];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_OPERATION_START
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_operation_start_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_OPERATION_START
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_operation_start_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field operation_id from event AVRCP_SUBEVENT_OPERATION_START
 * @param event packet
 * @return operation_id
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_operation_start_get_operation_id(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_OPERATION_COMPLETE
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_operation_complete_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_OPERATION_COMPLETE
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_operation_complete_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field operation_id from event AVRCP_SUBEVENT_OPERATION_COMPLETE
 * @param event packet
 * @return operation_id
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_operation_complete_get_operation_id(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_PLAYER_APPLICATION_VALUE_RESPONSE
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_player_application_value_response_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_PLAYER_APPLICATION_VALUE_RESPONSE
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_player_application_value_response_get_command_type(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_PLAY_STATUS_QUERY
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_play_status_query_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_OPERATION
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_operation_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field operation_id from event AVRCP_SUBEVENT_OPERATION
 * @param event packet
 * @return operation_id
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_operation_get_operation_id(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field button_pressed from event AVRCP_SUBEVENT_OPERATION
 * @param event packet
 * @return button_pressed
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_operation_get_button_pressed(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field operands_length from event AVRCP_SUBEVENT_OPERATION
 * @param event packet
 * @return operands_length
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_operation_get_operands_length(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field operand from event AVRCP_SUBEVENT_OPERATION
 * @param event packet
 * @return operand
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_operation_get_operand(const uint8_t * event){
    return event[8];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOW_PLAYING_TRACK_INFO
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_now_playing_track_info_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOW_PLAYING_TRACK_INFO
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_track_info_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field track from event AVRCP_SUBEVENT_NOW_PLAYING_TRACK_INFO
 * @param event packet
 * @return track
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_track_info_get_track(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOW_PLAYING_TOTAL_TRACKS_INFO
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_now_playing_total_tracks_info_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOW_PLAYING_TOTAL_TRACKS_INFO
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_total_tracks_info_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field total_tracks from event AVRCP_SUBEVENT_NOW_PLAYING_TOTAL_TRACKS_INFO
 * @param event packet
 * @return total_tracks
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_total_tracks_info_get_total_tracks(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOW_PLAYING_SONG_LENGTH_MS_INFO
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_now_playing_song_length_ms_info_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOW_PLAYING_SONG_LENGTH_MS_INFO
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_song_length_ms_info_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field song_length from event AVRCP_SUBEVENT_NOW_PLAYING_SONG_LENGTH_MS_INFO
 * @param event packet
 * @return song_length
 * @note: btstack_type 4
 */
static inline uint32_t avrcp_subevent_now_playing_song_length_ms_info_get_song_length(const uint8_t * event){
    return little_endian_read_32(event, 6);
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOW_PLAYING_TITLE_INFO
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_now_playing_title_info_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOW_PLAYING_TITLE_INFO
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_title_info_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value_len from event AVRCP_SUBEVENT_NOW_PLAYING_TITLE_INFO
 * @param event packet
 * @return value_len
 * @note: btstack_type J
 */
static inline uint8_t avrcp_subevent_now_playing_title_info_get_value_len(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field value from event AVRCP_SUBEVENT_NOW_PLAYING_TITLE_INFO
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * avrcp_subevent_now_playing_title_info_get_value(const uint8_t * event){
    return &event[7];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOW_PLAYING_ARTIST_INFO
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_now_playing_artist_info_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOW_PLAYING_ARTIST_INFO
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_artist_info_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value_len from event AVRCP_SUBEVENT_NOW_PLAYING_ARTIST_INFO
 * @param event packet
 * @return value_len
 * @note: btstack_type J
 */
static inline uint8_t avrcp_subevent_now_playing_artist_info_get_value_len(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field value from event AVRCP_SUBEVENT_NOW_PLAYING_ARTIST_INFO
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * avrcp_subevent_now_playing_artist_info_get_value(const uint8_t * event){
    return &event[7];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOW_PLAYING_ALBUM_INFO
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_now_playing_album_info_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOW_PLAYING_ALBUM_INFO
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_album_info_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value_len from event AVRCP_SUBEVENT_NOW_PLAYING_ALBUM_INFO
 * @param event packet
 * @return value_len
 * @note: btstack_type J
 */
static inline uint8_t avrcp_subevent_now_playing_album_info_get_value_len(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field value from event AVRCP_SUBEVENT_NOW_PLAYING_ALBUM_INFO
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * avrcp_subevent_now_playing_album_info_get_value(const uint8_t * event){
    return &event[7];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOW_PLAYING_GENRE_INFO
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_now_playing_genre_info_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOW_PLAYING_GENRE_INFO
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_genre_info_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value_len from event AVRCP_SUBEVENT_NOW_PLAYING_GENRE_INFO
 * @param event packet
 * @return value_len
 * @note: btstack_type J
 */
static inline uint8_t avrcp_subevent_now_playing_genre_info_get_value_len(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field value from event AVRCP_SUBEVENT_NOW_PLAYING_GENRE_INFO
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * avrcp_subevent_now_playing_genre_info_get_value(const uint8_t * event){
    return &event[7];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOW_PLAYING_COVER_ART_INFO
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_now_playing_cover_art_info_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOW_PLAYING_COVER_ART_INFO
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_cover_art_info_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value_len from event AVRCP_SUBEVENT_NOW_PLAYING_COVER_ART_INFO
 * @param event packet
 * @return value_len
 * @note: btstack_type J
 */
static inline uint8_t avrcp_subevent_now_playing_cover_art_info_get_value_len(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field value from event AVRCP_SUBEVENT_NOW_PLAYING_COVER_ART_INFO
 * @param event packet
 * @return value
 * @note: btstack_type V
 */
static inline const uint8_t * avrcp_subevent_now_playing_cover_art_info_get_value(const uint8_t * event){
    return &event[7];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOW_PLAYING_INFO_DONE
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_now_playing_info_done_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOW_PLAYING_INFO_DONE
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_info_done_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field status from event AVRCP_SUBEVENT_NOW_PLAYING_INFO_DONE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_now_playing_info_done_get_status(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_NOTIFICATION_PLAYBACK_POS_CHANGED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_notification_playback_pos_changed_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_NOTIFICATION_PLAYBACK_POS_CHANGED
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_notification_playback_pos_changed_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field playback_position_ms from event AVRCP_SUBEVENT_NOTIFICATION_PLAYBACK_POS_CHANGED
 * @param event packet
 * @return playback_position_ms
 * @note: btstack_type 4
 */
static inline uint32_t avrcp_subevent_notification_playback_pos_changed_get_playback_position_ms(const uint8_t * event){
    return little_endian_read_32(event, 6);
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_GET_CAPABILITY_EVENT_ID
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_get_capability_event_id_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_GET_CAPABILITY_EVENT_ID
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_get_capability_event_id_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field status from event AVRCP_SUBEVENT_GET_CAPABILITY_EVENT_ID
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_get_capability_event_id_get_status(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field event_id from event AVRCP_SUBEVENT_GET_CAPABILITY_EVENT_ID
 * @param event packet
 * @return event_id
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_get_capability_event_id_get_event_id(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_GET_CAPABILITY_EVENT_ID_DONE
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_get_capability_event_id_done_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_GET_CAPABILITY_EVENT_ID_DONE
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_get_capability_event_id_done_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field status from event AVRCP_SUBEVENT_GET_CAPABILITY_EVENT_ID_DONE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_get_capability_event_id_done_get_status(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_GET_CAPABILITY_COMPANY_ID
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_get_capability_company_id_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_GET_CAPABILITY_COMPANY_ID
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_get_capability_company_id_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field status from event AVRCP_SUBEVENT_GET_CAPABILITY_COMPANY_ID
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_get_capability_company_id_get_status(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field company_id from event AVRCP_SUBEVENT_GET_CAPABILITY_COMPANY_ID
 * @param event packet
 * @return company_id
 * @note: btstack_type 3
 */
static inline uint32_t avrcp_subevent_get_capability_company_id_get_company_id(const uint8_t * event){
    return little_endian_read_24(event, 7);
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_GET_CAPABILITY_COMPANY_ID_DONE
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_get_capability_company_id_done_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_GET_CAPABILITY_COMPANY_ID_DONE
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_get_capability_company_id_done_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field status from event AVRCP_SUBEVENT_GET_CAPABILITY_COMPANY_ID_DONE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_get_capability_company_id_done_get_status(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_CUSTOM_COMMAND_RESPONSE
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_custom_command_response_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field command_type from event AVRCP_SUBEVENT_CUSTOM_COMMAND_RESPONSE
 * @param event packet
 * @return command_type
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_custom_command_response_get_command_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field pdu_id from event AVRCP_SUBEVENT_CUSTOM_COMMAND_RESPONSE
 * @param event packet
 * @return pdu_id
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_custom_command_response_get_pdu_id(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field params_len from event AVRCP_SUBEVENT_CUSTOM_COMMAND_RESPONSE
 * @param event packet
 * @return params_len
 * @note: btstack_type L
 */
static inline uint16_t avrcp_subevent_custom_command_response_get_params_len(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field params from event AVRCP_SUBEVENT_CUSTOM_COMMAND_RESPONSE
 * @param event packet
 * @return params
 * @note: btstack_type V
 */
static inline const uint8_t * avrcp_subevent_custom_command_response_get_params(const uint8_t * event){
    return &event[9];
}

/**
 * @brief Get field bd_addr from event AVRCP_SUBEVENT_INCOMING_BROWSING_CONNECTION
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void avrcp_subevent_incoming_browsing_connection_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[3], bd_addr, 6);
}
/**
 * @brief Get field browsing_cid from event AVRCP_SUBEVENT_INCOMING_BROWSING_CONNECTION
 * @param event packet
 * @return browsing_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_incoming_browsing_connection_get_browsing_cid(const uint8_t * event){
    return little_endian_read_16(event, 9);
}

/**
 * @brief Get field status from event AVRCP_SUBEVENT_BROWSING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_browsing_connection_established_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field bd_addr from event AVRCP_SUBEVENT_BROWSING_CONNECTION_ESTABLISHED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void avrcp_subevent_browsing_connection_established_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[4], bd_addr, 6);
}
/**
 * @brief Get field browsing_cid from event AVRCP_SUBEVENT_BROWSING_CONNECTION_ESTABLISHED
 * @param event packet
 * @return browsing_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_browsing_connection_established_get_browsing_cid(const uint8_t * event){
    return little_endian_read_16(event, 10);
}

/**
 * @brief Get field browsing_cid from event AVRCP_SUBEVENT_BROWSING_CONNECTION_RELEASED
 * @param event packet
 * @return browsing_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_browsing_connection_released_get_browsing_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field browsing_cid from event AVRCP_SUBEVENT_BROWSING_DONE
 * @param event packet
 * @return browsing_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_browsing_done_get_browsing_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field uid_counter from event AVRCP_SUBEVENT_BROWSING_DONE
 * @param event packet
 * @return uid_counter
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_browsing_done_get_uid_counter(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field browsing_status from event AVRCP_SUBEVENT_BROWSING_DONE
 * @param event packet
 * @return browsing_status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_browsing_done_get_browsing_status(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field bluetooth_status from event AVRCP_SUBEVENT_BROWSING_DONE
 * @param event packet
 * @return bluetooth_status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_browsing_done_get_bluetooth_status(const uint8_t * event){
    return event[8];
}

/**
 * @brief Get field browsing_cid from event AVRCP_SUBEVENT_BROWSING_GET_FOLDER_ITEMS
 * @param event packet
 * @return browsing_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_browsing_get_folder_items_get_browsing_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field scope from event AVRCP_SUBEVENT_BROWSING_GET_FOLDER_ITEMS
 * @param event packet
 * @return scope
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_browsing_get_folder_items_get_scope(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field attr_bitmap from event AVRCP_SUBEVENT_BROWSING_GET_FOLDER_ITEMS
 * @param event packet
 * @return attr_bitmap
 * @note: btstack_type 4
 */
static inline uint32_t avrcp_subevent_browsing_get_folder_items_get_attr_bitmap(const uint8_t * event){
    return little_endian_read_32(event, 6);
}

/**
 * @brief Get field browsing_cid from event AVRCP_SUBEVENT_BROWSING_GET_TOTAL_NUM_ITEMS
 * @param event packet
 * @return browsing_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_browsing_get_total_num_items_get_browsing_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field scope from event AVRCP_SUBEVENT_BROWSING_GET_TOTAL_NUM_ITEMS
 * @param event packet
 * @return scope
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_browsing_get_total_num_items_get_scope(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field browsing_cid from event AVRCP_SUBEVENT_BROWSING_SET_BROWSED_PLAYER
 * @param event packet
 * @return browsing_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_browsing_set_browsed_player_get_browsing_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field player_id from event AVRCP_SUBEVENT_BROWSING_SET_BROWSED_PLAYER
 * @param event packet
 * @return player_id
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_browsing_set_browsed_player_get_player_id(const uint8_t * event){
    return little_endian_read_16(event, 5);
}

/**
 * @brief Get field status from event AVRCP_SUBEVENT_COVER_ART_CONNECTION_ESTABLISHED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_cover_art_connection_established_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field bd_addr from event AVRCP_SUBEVENT_COVER_ART_CONNECTION_ESTABLISHED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void avrcp_subevent_cover_art_connection_established_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[4], bd_addr, 6);
}
/**
 * @brief Get field avrcp_cid from event AVRCP_SUBEVENT_COVER_ART_CONNECTION_ESTABLISHED
 * @param event packet
 * @return avrcp_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_cover_art_connection_established_get_avrcp_cid(const uint8_t * event){
    return little_endian_read_16(event, 10);
}
/**
 * @brief Get field cover_art_cid from event AVRCP_SUBEVENT_COVER_ART_CONNECTION_ESTABLISHED
 * @param event packet
 * @return cover_art_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_cover_art_connection_established_get_cover_art_cid(const uint8_t * event){
    return little_endian_read_16(event, 12);
}

/**
 * @brief Get field cover_art_cid from event AVRCP_SUBEVENT_COVER_ART_OPERATION_COMPLETE
 * @param event packet
 * @return cover_art_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_cover_art_operation_complete_get_cover_art_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event AVRCP_SUBEVENT_COVER_ART_OPERATION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t avrcp_subevent_cover_art_operation_complete_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field cover_art_cid from event AVRCP_SUBEVENT_COVER_ART_CONNECTION_RELEASED
 * @param event packet
 * @return cover_art_cid
 * @note: btstack_type 2
 */
static inline uint16_t avrcp_subevent_cover_art_connection_released_get_cover_art_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field goep_cid from event GOEP_SUBEVENT_INCOMING_CONNECTION
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t goep_subevent_incoming_connection_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field address from event GOEP_SUBEVENT_INCOMING_CONNECTION
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void goep_subevent_incoming_connection_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field handle from event GOEP_SUBEVENT_INCOMING_CONNECTION
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t goep_subevent_incoming_connection_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 11);
}

/**
 * @brief Get field goep_cid from event GOEP_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t goep_subevent_connection_opened_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event GOEP_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t goep_subevent_connection_opened_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field bd_addr from event GOEP_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void goep_subevent_connection_opened_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[6], bd_addr, 6);
}
/**
 * @brief Get field con_handle from event GOEP_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t goep_subevent_connection_opened_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field incoming from event GOEP_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return incoming
 * @note: btstack_type 1
 */
static inline uint8_t goep_subevent_connection_opened_get_incoming(const uint8_t * event){
    return event[14];
}

/**
 * @brief Get field goep_cid from event GOEP_SUBEVENT_CONNECTION_CLOSED
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t goep_subevent_connection_closed_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field goep_cid from event GOEP_SUBEVENT_CAN_SEND_NOW
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t goep_subevent_can_send_now_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field pbap_cid from event PBAP_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return pbap_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_connection_opened_get_pbap_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event PBAP_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_connection_opened_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field bd_addr from event PBAP_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void pbap_subevent_connection_opened_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[6], bd_addr, 6);
}
/**
 * @brief Get field con_handle from event PBAP_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t pbap_subevent_connection_opened_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field incoming from event PBAP_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return incoming
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_connection_opened_get_incoming(const uint8_t * event){
    return event[14];
}

/**
 * @brief Get field goep_cid from event PBAP_SUBEVENT_CONNECTION_CLOSED
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_connection_closed_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field goep_cid from event PBAP_SUBEVENT_OPERATION_COMPLETED
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_operation_completed_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event PBAP_SUBEVENT_OPERATION_COMPLETED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_operation_completed_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field goep_cid from event PBAP_SUBEVENT_PHONEBOOK_SIZE
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_phonebook_size_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event PBAP_SUBEVENT_PHONEBOOK_SIZE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_phonebook_size_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field phonebook_size from event PBAP_SUBEVENT_PHONEBOOK_SIZE
 * @param event packet
 * @return phonebook_size
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_phonebook_size_get_phonebook_size(const uint8_t * event){
    return little_endian_read_16(event, 6);
}

/**
 * @brief Get field goep_cid from event PBAP_SUBEVENT_AUTHENTICATION_REQUEST
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_authentication_request_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field user_id_required from event PBAP_SUBEVENT_AUTHENTICATION_REQUEST
 * @param event packet
 * @return user_id_required
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_authentication_request_get_user_id_required(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field full_access from event PBAP_SUBEVENT_AUTHENTICATION_REQUEST
 * @param event packet
 * @return full_access
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_authentication_request_get_full_access(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field goep_cid from event PBAP_SUBEVENT_CARD_RESULT
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_card_result_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field name_len from event PBAP_SUBEVENT_CARD_RESULT
 * @param event packet
 * @return name_len
 * @note: btstack_type J
 */
static inline uint8_t pbap_subevent_card_result_get_name_len(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field name from event PBAP_SUBEVENT_CARD_RESULT
 * @param event packet
 * @return name
 * @note: btstack_type V
 */
static inline const uint8_t * pbap_subevent_card_result_get_name(const uint8_t * event){
    return &event[6];
}
/**
 * @brief Get field handle_len from event PBAP_SUBEVENT_CARD_RESULT
 * @param event packet
 * @return handle_len
 * @note: btstack_type J
 */
static inline uint8_t pbap_subevent_card_result_get_handle_len(const uint8_t * event){
    return event[6u + event[5]];
}
/**
 * @brief Get field handle from event PBAP_SUBEVENT_CARD_RESULT
 * @param event packet
 * @return handle
 * @note: btstack_type V
 */
static inline const uint8_t * pbap_subevent_card_result_get_handle(const uint8_t * event){
    return &event[6u + event[5] + 1u];
}

/**
 * @brief Get field goep_cid from event PBAP_SUBEVENT_RESET_MISSED_CALLS
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_reset_missed_calls_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field phonebook from event PBAP_SUBEVENT_RESET_MISSED_CALLS
 * @param event packet
 * @return phonebook
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_reset_missed_calls_get_phonebook(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field goep_cid from event PBAP_SUBEVENT_QUERY_PHONEBOOK_SIZE
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_query_phonebook_size_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field vcard_selector from event PBAP_SUBEVENT_QUERY_PHONEBOOK_SIZE
 * @param event packet
 * @return vcard_selector
 * @note: btstack_type 4
 */
static inline uint32_t pbap_subevent_query_phonebook_size_get_vcard_selector(const uint8_t * event){
    return little_endian_read_32(event, 5);
}
/**
 * @brief Get field vcard_selector_operator from event PBAP_SUBEVENT_QUERY_PHONEBOOK_SIZE
 * @param event packet
 * @return vcard_selector_operator
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_query_phonebook_size_get_vcard_selector_operator(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field phonebook from event PBAP_SUBEVENT_QUERY_PHONEBOOK_SIZE
 * @param event packet
 * @return phonebook
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_query_phonebook_size_get_phonebook(const uint8_t * event){
    return event[10];
}

/**
 * @brief Get field goep_cid from event PBAP_SUBEVENT_PULL_PHONEBOOK
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_pull_phonebook_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field continuation from event PBAP_SUBEVENT_PULL_PHONEBOOK
 * @param event packet
 * @return continuation
 * @note: btstack_type 4
 */
static inline uint32_t pbap_subevent_pull_phonebook_get_continuation(const uint8_t * event){
    return little_endian_read_32(event, 5);
}
/**
 * @brief Get field property_selector from event PBAP_SUBEVENT_PULL_PHONEBOOK
 * @param event packet
 * @return property_selector
 * @note: btstack_type 4
 */
static inline uint32_t pbap_subevent_pull_phonebook_get_property_selector(const uint8_t * event){
    return little_endian_read_32(event, 9);
}
/**
 * @brief Get field format from event PBAP_SUBEVENT_PULL_PHONEBOOK
 * @param event packet
 * @return format
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_pull_phonebook_get_format(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field max_list_count from event PBAP_SUBEVENT_PULL_PHONEBOOK
 * @param event packet
 * @return max_list_count
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_pull_phonebook_get_max_list_count(const uint8_t * event){
    return little_endian_read_16(event, 14);
}
/**
 * @brief Get field list_start_offset from event PBAP_SUBEVENT_PULL_PHONEBOOK
 * @param event packet
 * @return list_start_offset
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_pull_phonebook_get_list_start_offset(const uint8_t * event){
    return little_endian_read_16(event, 16);
}
/**
 * @brief Get field vcard_selector from event PBAP_SUBEVENT_PULL_PHONEBOOK
 * @param event packet
 * @return vcard_selector
 * @note: btstack_type 4
 */
static inline uint32_t pbap_subevent_pull_phonebook_get_vcard_selector(const uint8_t * event){
    return little_endian_read_32(event, 18);
}
/**
 * @brief Get field vcard_selector_operator from event PBAP_SUBEVENT_PULL_PHONEBOOK
 * @param event packet
 * @return vcard_selector_operator
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_pull_phonebook_get_vcard_selector_operator(const uint8_t * event){
    return event[22];
}
/**
 * @brief Get field phonebook from event PBAP_SUBEVENT_PULL_PHONEBOOK
 * @param event packet
 * @return phonebook
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_pull_phonebook_get_phonebook(const uint8_t * event){
    return event[23];
}

/**
 * @brief Get field goep_cid from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_pull_vcard_listing_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field continuation from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return continuation
 * @note: btstack_type 4
 */
static inline uint32_t pbap_subevent_pull_vcard_listing_get_continuation(const uint8_t * event){
    return little_endian_read_32(event, 5);
}
/**
 * @brief Get field order from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return order
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_pull_vcard_listing_get_order(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field max_list_count from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return max_list_count
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_pull_vcard_listing_get_max_list_count(const uint8_t * event){
    return little_endian_read_16(event, 10);
}
/**
 * @brief Get field list_start_offset from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return list_start_offset
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_pull_vcard_listing_get_list_start_offset(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field vcard_selector from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return vcard_selector
 * @note: btstack_type 4
 */
static inline uint32_t pbap_subevent_pull_vcard_listing_get_vcard_selector(const uint8_t * event){
    return little_endian_read_32(event, 14);
}
/**
 * @brief Get field vcard_selector_operator from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return vcard_selector_operator
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_pull_vcard_listing_get_vcard_selector_operator(const uint8_t * event){
    return event[18];
}
/**
 * @brief Get field search_property from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return search_property
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_pull_vcard_listing_get_search_property(const uint8_t * event){
    return event[19];
}
/**
 * @brief Get field search_value_len from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return search_value_len
 * @note: btstack_type J
 */
static inline uint8_t pbap_subevent_pull_vcard_listing_get_search_value_len(const uint8_t * event){
    return event[20];
}
/**
 * @brief Get field search_value from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return search_value
 * @note: btstack_type V
 */
static inline const uint8_t * pbap_subevent_pull_vcard_listing_get_search_value(const uint8_t * event){
    return &event[21];
}
/**
 * @brief Get field phonebook from event PBAP_SUBEVENT_PULL_VCARD_LISTING
 * @param event packet
 * @return phonebook
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_pull_vcard_listing_get_phonebook(const uint8_t * event){
    return event[21u + event[20]];
}

/**
 * @brief Get field goep_cid from event PBAP_SUBEVENT_PULL_VCARD_ENTRY
 * @param event packet
 * @return goep_cid
 * @note: btstack_type 2
 */
static inline uint16_t pbap_subevent_pull_vcard_entry_get_goep_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field continuation from event PBAP_SUBEVENT_PULL_VCARD_ENTRY
 * @param event packet
 * @return continuation
 * @note: btstack_type 4
 */
static inline uint32_t pbap_subevent_pull_vcard_entry_get_continuation(const uint8_t * event){
    return little_endian_read_32(event, 5);
}
/**
 * @brief Get field property_selector from event PBAP_SUBEVENT_PULL_VCARD_ENTRY
 * @param event packet
 * @return property_selector
 * @note: btstack_type 4
 */
static inline uint32_t pbap_subevent_pull_vcard_entry_get_property_selector(const uint8_t * event){
    return little_endian_read_32(event, 9);
}
/**
 * @brief Get field format from event PBAP_SUBEVENT_PULL_VCARD_ENTRY
 * @param event packet
 * @return format
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_pull_vcard_entry_get_format(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field phonebook from event PBAP_SUBEVENT_PULL_VCARD_ENTRY
 * @param event packet
 * @return phonebook
 * @note: btstack_type 1
 */
static inline uint8_t pbap_subevent_pull_vcard_entry_get_phonebook(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field name from event PBAP_SUBEVENT_PULL_VCARD_ENTRY
 * @param event packet
 * @return name
 * @note: btstack_type T
 */
static inline const char * pbap_subevent_pull_vcard_entry_get_name(const uint8_t * event){
    return (const char *) &event[15];
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_INCOMING_CONNECTION
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_incoming_connection_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field address from event HID_SUBEVENT_INCOMING_CONNECTION
 * @param event packet
 * @param Pointer to storage for address
 * @note: btstack_type B
 */
static inline void hid_subevent_incoming_connection_get_address(const uint8_t * event, bd_addr_t address){
    reverse_bytes(&event[5], address, 6);
}
/**
 * @brief Get field handle from event HID_SUBEVENT_INCOMING_CONNECTION
 * @param event packet
 * @return handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hid_subevent_incoming_connection_get_handle(const uint8_t * event){
    return little_endian_read_16(event, 11);
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_connection_opened_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HID_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hid_subevent_connection_opened_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field bd_addr from event HID_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @param Pointer to storage for bd_addr
 * @note: btstack_type B
 */
static inline void hid_subevent_connection_opened_get_bd_addr(const uint8_t * event, bd_addr_t bd_addr){
    reverse_bytes(&event[6], bd_addr, 6);
}
/**
 * @brief Get field con_handle from event HID_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t hid_subevent_connection_opened_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field incoming from event HID_SUBEVENT_CONNECTION_OPENED
 * @param event packet
 * @return incoming
 * @note: btstack_type 1
 */
static inline uint8_t hid_subevent_connection_opened_get_incoming(const uint8_t * event){
    return event[14];
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_CONNECTION_CLOSED
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_connection_closed_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_CAN_SEND_NOW
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_can_send_now_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_SUSPEND
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_suspend_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_EXIT_SUSPEND
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_exit_suspend_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_VIRTUAL_CABLE_UNPLUG
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_virtual_cable_unplug_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_GET_REPORT_RESPONSE
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_get_report_response_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field handshake_status from event HID_SUBEVENT_GET_REPORT_RESPONSE
 * @param event packet
 * @return handshake_status
 * @note: btstack_type 1
 */
static inline uint8_t hid_subevent_get_report_response_get_handshake_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field report_len from event HID_SUBEVENT_GET_REPORT_RESPONSE
 * @param event packet
 * @return report_len
 * @note: btstack_type L
 */
static inline uint16_t hid_subevent_get_report_response_get_report_len(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field report from event HID_SUBEVENT_GET_REPORT_RESPONSE
 * @param event packet
 * @return report
 * @note: btstack_type V
 */
static inline const uint8_t * hid_subevent_get_report_response_get_report(const uint8_t * event){
    return &event[8];
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_SET_REPORT_RESPONSE
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_set_report_response_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field handshake_status from event HID_SUBEVENT_SET_REPORT_RESPONSE
 * @param event packet
 * @return handshake_status
 * @note: btstack_type 1
 */
static inline uint8_t hid_subevent_set_report_response_get_handshake_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_GET_PROTOCOL_RESPONSE
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_get_protocol_response_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field handshake_status from event HID_SUBEVENT_GET_PROTOCOL_RESPONSE
 * @param event packet
 * @return handshake_status
 * @note: btstack_type 1
 */
static inline uint8_t hid_subevent_get_protocol_response_get_handshake_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field protocol_mode from event HID_SUBEVENT_GET_PROTOCOL_RESPONSE
 * @param event packet
 * @return protocol_mode
 * @note: btstack_type 1
 */
static inline uint8_t hid_subevent_get_protocol_response_get_protocol_mode(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_SET_PROTOCOL_RESPONSE
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_set_protocol_response_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field handshake_status from event HID_SUBEVENT_SET_PROTOCOL_RESPONSE
 * @param event packet
 * @return handshake_status
 * @note: btstack_type 1
 */
static inline uint8_t hid_subevent_set_protocol_response_get_handshake_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field protocol_mode from event HID_SUBEVENT_SET_PROTOCOL_RESPONSE
 * @param event packet
 * @return protocol_mode
 * @note: btstack_type 1
 */
static inline uint8_t hid_subevent_set_protocol_response_get_protocol_mode(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_REPORT
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_report_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field report_len from event HID_SUBEVENT_REPORT
 * @param event packet
 * @return report_len
 * @note: btstack_type L
 */
static inline uint16_t hid_subevent_report_get_report_len(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field report from event HID_SUBEVENT_REPORT
 * @param event packet
 * @return report
 * @note: btstack_type V
 */
static inline const uint8_t * hid_subevent_report_get_report(const uint8_t * event){
    return &event[7];
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_DESCRIPTOR_AVAILABLE
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_descriptor_available_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event HID_SUBEVENT_DESCRIPTOR_AVAILABLE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t hid_subevent_descriptor_available_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field hid_cid from event HID_SUBEVENT_SNIFF_SUBRATING_PARAMS
 * @param event packet
 * @return hid_cid
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_sniff_subrating_params_get_hid_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field host_max_latency from event HID_SUBEVENT_SNIFF_SUBRATING_PARAMS
 * @param event packet
 * @return host_max_latency
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_sniff_subrating_params_get_host_max_latency(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field host_min_timeout from event HID_SUBEVENT_SNIFF_SUBRATING_PARAMS
 * @param event packet
 * @return host_min_timeout
 * @note: btstack_type 2
 */
static inline uint16_t hid_subevent_sniff_subrating_params_get_host_min_timeout(const uint8_t * event){
    return little_endian_read_16(event, 7);
}

/**
 * @brief Get field con_handle from event HIDS_SUBEVENT_CAN_SEND_NOW
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t hids_subevent_can_send_now_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field con_handle from event HIDS_SUBEVENT_PROTOCOL_MODE
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t hids_subevent_protocol_mode_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field protocol_mode from event HIDS_SUBEVENT_PROTOCOL_MODE
 * @param event packet
 * @return protocol_mode
 * @note: btstack_type 1
 */
static inline uint8_t hids_subevent_protocol_mode_get_protocol_mode(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field con_handle from event HIDS_SUBEVENT_BOOT_MOUSE_INPUT_REPORT_ENABLE
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t hids_subevent_boot_mouse_input_report_enable_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field enable from event HIDS_SUBEVENT_BOOT_MOUSE_INPUT_REPORT_ENABLE
 * @param event packet
 * @return enable
 * @note: btstack_type 1
 */
static inline uint8_t hids_subevent_boot_mouse_input_report_enable_get_enable(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field con_handle from event HIDS_SUBEVENT_BOOT_KEYBOARD_INPUT_REPORT_ENABLE
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t hids_subevent_boot_keyboard_input_report_enable_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field enable from event HIDS_SUBEVENT_BOOT_KEYBOARD_INPUT_REPORT_ENABLE
 * @param event packet
 * @return enable
 * @note: btstack_type 1
 */
static inline uint8_t hids_subevent_boot_keyboard_input_report_enable_get_enable(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field con_handle from event HIDS_SUBEVENT_INPUT_REPORT_ENABLE
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t hids_subevent_input_report_enable_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field enable from event HIDS_SUBEVENT_INPUT_REPORT_ENABLE
 * @param event packet
 * @return enable
 * @note: btstack_type 1
 */
static inline uint8_t hids_subevent_input_report_enable_get_enable(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field con_handle from event HIDS_SUBEVENT_OUTPUT_REPORT_ENABLE
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t hids_subevent_output_report_enable_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field enable from event HIDS_SUBEVENT_OUTPUT_REPORT_ENABLE
 * @param event packet
 * @return enable
 * @note: btstack_type 1
 */
static inline uint8_t hids_subevent_output_report_enable_get_enable(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field con_handle from event HIDS_SUBEVENT_FEATURE_REPORT_ENABLE
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t hids_subevent_feature_report_enable_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field enable from event HIDS_SUBEVENT_FEATURE_REPORT_ENABLE
 * @param event packet
 * @return enable
 * @note: btstack_type 1
 */
static inline uint8_t hids_subevent_feature_report_enable_get_enable(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field con_handle from event HIDS_SUBEVENT_SUSPEND
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t hids_subevent_suspend_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field con_handle from event HIDS_SUBEVENT_EXIT_SUSPEND
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t hids_subevent_exit_suspend_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_CYCLING_POWER_START_CALIBRATION
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_cycling_power_start_calibration_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field measurement_type from event GATTSERVICE_SUBEVENT_CYCLING_POWER_START_CALIBRATION
 * @param event packet
 * @return measurement_type
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_cycling_power_start_calibration_get_measurement_type(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field is_enhanced from event GATTSERVICE_SUBEVENT_CYCLING_POWER_START_CALIBRATION
 * @param event packet
 * @return is_enhanced
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_cycling_power_start_calibration_get_is_enhanced(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_CYCLING_POWER_BROADCAST_START
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_cycling_power_broadcast_start_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_CYCLING_POWER_BROADCAST_STOP
 * @param event packet
 * @return con_handle
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_cycling_power_broadcast_stop_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field hids_cid from event GATTSERVICE_SUBEVENT_BATTERY_SERVICE_CONNECTED
 * @param event packet
 * @return hids_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_battery_service_connected_get_hids_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event GATTSERVICE_SUBEVENT_BATTERY_SERVICE_CONNECTED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_battery_service_connected_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field num_instances from event GATTSERVICE_SUBEVENT_BATTERY_SERVICE_CONNECTED
 * @param event packet
 * @return num_instances
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_battery_service_connected_get_num_instances(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field poll_bitmap from event GATTSERVICE_SUBEVENT_BATTERY_SERVICE_CONNECTED
 * @param event packet
 * @return poll_bitmap
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_battery_service_connected_get_poll_bitmap(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field hids_cid from event GATTSERVICE_SUBEVENT_BATTERY_SERVICE_LEVEL
 * @param event packet
 * @return hids_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_battery_service_level_get_hids_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field sevice_index from event GATTSERVICE_SUBEVENT_BATTERY_SERVICE_LEVEL
 * @param event packet
 * @return sevice_index
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_battery_service_level_get_sevice_index(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_BATTERY_SERVICE_LEVEL
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_battery_service_level_get_att_status(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field level from event GATTSERVICE_SUBEVENT_BATTERY_SERVICE_LEVEL
 * @param event packet
 * @return level
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_battery_service_level_get_level(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_DONE
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_device_information_done_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_DONE
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_done_get_att_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_MANUFACTURER_NAME
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_device_information_manufacturer_name_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_MANUFACTURER_NAME
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_manufacturer_name_get_att_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_MANUFACTURER_NAME
 * @param event packet
 * @return value
 * @note: btstack_type T
 */
static inline const char * gattservice_subevent_device_information_manufacturer_name_get_value(const uint8_t * event){
    return (const char *) &event[6];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_MODEL_NUMBER
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_device_information_model_number_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_MODEL_NUMBER
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_model_number_get_att_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_MODEL_NUMBER
 * @param event packet
 * @return value
 * @note: btstack_type T
 */
static inline const char * gattservice_subevent_device_information_model_number_get_value(const uint8_t * event){
    return (const char *) &event[6];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SERIAL_NUMBER
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_device_information_serial_number_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SERIAL_NUMBER
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_serial_number_get_att_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SERIAL_NUMBER
 * @param event packet
 * @return value
 * @note: btstack_type T
 */
static inline const char * gattservice_subevent_device_information_serial_number_get_value(const uint8_t * event){
    return (const char *) &event[6];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_HARDWARE_REVISION
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_device_information_hardware_revision_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_HARDWARE_REVISION
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_hardware_revision_get_att_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_HARDWARE_REVISION
 * @param event packet
 * @return value
 * @note: btstack_type T
 */
static inline const char * gattservice_subevent_device_information_hardware_revision_get_value(const uint8_t * event){
    return (const char *) &event[6];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_FIRMWARE_REVISION
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_device_information_firmware_revision_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_FIRMWARE_REVISION
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_firmware_revision_get_att_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_FIRMWARE_REVISION
 * @param event packet
 * @return value
 * @note: btstack_type T
 */
static inline const char * gattservice_subevent_device_information_firmware_revision_get_value(const uint8_t * event){
    return (const char *) &event[6];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SOFTWARE_REVISION
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_device_information_software_revision_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SOFTWARE_REVISION
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_software_revision_get_att_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SOFTWARE_REVISION
 * @param event packet
 * @return value
 * @note: btstack_type T
 */
static inline const char * gattservice_subevent_device_information_software_revision_get_value(const uint8_t * event){
    return (const char *) &event[6];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SYSTEM_ID
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_device_information_system_id_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SYSTEM_ID
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_system_id_get_att_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field manufacturer_id_low from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SYSTEM_ID
 * @param event packet
 * @return manufacturer_id_low
 * @note: btstack_type 4
 */
static inline uint32_t gattservice_subevent_device_information_system_id_get_manufacturer_id_low(const uint8_t * event){
    return little_endian_read_32(event, 6);
}
/**
 * @brief Get field manufacturer_id_high from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SYSTEM_ID
 * @param event packet
 * @return manufacturer_id_high
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_system_id_get_manufacturer_id_high(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field organizationally_unique_id from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_SYSTEM_ID
 * @param event packet
 * @return organizationally_unique_id
 * @note: btstack_type 3
 */
static inline uint32_t gattservice_subevent_device_information_system_id_get_organizationally_unique_id(const uint8_t * event){
    return little_endian_read_24(event, 11);
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_IEEE_REGULATORY_CERTIFICATION
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_device_information_ieee_regulatory_certification_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_IEEE_REGULATORY_CERTIFICATION
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_ieee_regulatory_certification_get_att_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field value_a from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_IEEE_REGULATORY_CERTIFICATION
 * @param event packet
 * @return value_a
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_device_information_ieee_regulatory_certification_get_value_a(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field value_b from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_IEEE_REGULATORY_CERTIFICATION
 * @param event packet
 * @return value_b
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_device_information_ieee_regulatory_certification_get_value_b(const uint8_t * event){
    return little_endian_read_16(event, 8);
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_PNP_ID
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_device_information_pnp_id_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_PNP_ID
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_pnp_id_get_att_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field vendor_source_id from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_PNP_ID
 * @param event packet
 * @return vendor_source_id
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_device_information_pnp_id_get_vendor_source_id(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field vendor_id from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_PNP_ID
 * @param event packet
 * @return vendor_id
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_device_information_pnp_id_get_vendor_id(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field product_id from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_PNP_ID
 * @param event packet
 * @return product_id
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_device_information_pnp_id_get_product_id(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field product_version from event GATTSERVICE_SUBEVENT_DEVICE_INFORMATION_PNP_ID
 * @param event packet
 * @return product_version
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_device_information_pnp_id_get_product_version(const uint8_t * event){
    return little_endian_read_16(event, 11);
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_SCAN_PARAMETERS_SERVICE_CONNECTED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_scan_parameters_service_connected_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field att_status from event GATTSERVICE_SUBEVENT_SCAN_PARAMETERS_SERVICE_CONNECTED
 * @param event packet
 * @return att_status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_scan_parameters_service_connected_get_att_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_SPP_SERVICE_CONNECTED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_spp_service_connected_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_SPP_SERVICE_DISCONNECTED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_spp_service_disconnected_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field hids_cid from event GATTSERVICE_SUBEVENT_HID_SERVICE_CONNECTED
 * @param event packet
 * @return hids_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_hid_service_connected_get_hids_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event GATTSERVICE_SUBEVENT_HID_SERVICE_CONNECTED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_service_connected_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field protocol_mode from event GATTSERVICE_SUBEVENT_HID_SERVICE_CONNECTED
 * @param event packet
 * @return protocol_mode
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_service_connected_get_protocol_mode(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field num_instances from event GATTSERVICE_SUBEVENT_HID_SERVICE_CONNECTED
 * @param event packet
 * @return num_instances
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_service_connected_get_num_instances(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field hids_cid from event GATTSERVICE_SUBEVENT_HID_REPORT
 * @param event packet
 * @return hids_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_hid_report_get_hids_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field service_index from event GATTSERVICE_SUBEVENT_HID_REPORT
 * @param event packet
 * @return service_index
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_report_get_service_index(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field report_id from event GATTSERVICE_SUBEVENT_HID_REPORT
 * @param event packet
 * @return report_id
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_report_get_report_id(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field report_len from event GATTSERVICE_SUBEVENT_HID_REPORT
 * @param event packet
 * @return report_len
 * @note: btstack_type L
 */
static inline uint16_t gattservice_subevent_hid_report_get_report_len(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field report from event GATTSERVICE_SUBEVENT_HID_REPORT
 * @param event packet
 * @return report
 * @note: btstack_type V
 */
static inline const uint8_t * gattservice_subevent_hid_report_get_report(const uint8_t * event){
    return &event[9];
}

/**
 * @brief Get field hids_cid from event GATTSERVICE_SUBEVENT_HID_INFORMATION
 * @param event packet
 * @return hids_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_hid_information_get_hids_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field service_index from event GATTSERVICE_SUBEVENT_HID_INFORMATION
 * @param event packet
 * @return service_index
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_information_get_service_index(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field base_usb_hid_version from event GATTSERVICE_SUBEVENT_HID_INFORMATION
 * @param event packet
 * @return base_usb_hid_version
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_hid_information_get_base_usb_hid_version(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field country_code from event GATTSERVICE_SUBEVENT_HID_INFORMATION
 * @param event packet
 * @return country_code
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_information_get_country_code(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field remote_wake from event GATTSERVICE_SUBEVENT_HID_INFORMATION
 * @param event packet
 * @return remote_wake
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_information_get_remote_wake(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field normally_connectable from event GATTSERVICE_SUBEVENT_HID_INFORMATION
 * @param event packet
 * @return normally_connectable
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_information_get_normally_connectable(const uint8_t * event){
    return event[10];
}

/**
 * @brief Get field hids_cid from event GATTSERVICE_SUBEVENT_HID_PROTOCOL_MODE
 * @param event packet
 * @return hids_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_hid_protocol_mode_get_hids_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field service_index from event GATTSERVICE_SUBEVENT_HID_PROTOCOL_MODE
 * @param event packet
 * @return service_index
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_protocol_mode_get_service_index(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field protocol_mode from event GATTSERVICE_SUBEVENT_HID_PROTOCOL_MODE
 * @param event packet
 * @return protocol_mode
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_protocol_mode_get_protocol_mode(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field hids_cid from event GATTSERVICE_SUBEVENT_HID_SERVICE_REPORTS_NOTIFICATION
 * @param event packet
 * @return hids_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_hid_service_reports_notification_get_hids_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field configuration from event GATTSERVICE_SUBEVENT_HID_SERVICE_REPORTS_NOTIFICATION
 * @param event packet
 * @return configuration
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_hid_service_reports_notification_get_configuration(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_SCAN_PARAMETERS_SERVICE_SCAN_INTERVAL_UPDATE
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_scan_parameters_service_scan_interval_update_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field max_scan_interval from event GATTSERVICE_SUBEVENT_SCAN_PARAMETERS_SERVICE_SCAN_INTERVAL_UPDATE
 * @param event packet
 * @return max_scan_interval
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_scan_parameters_service_scan_interval_update_get_max_scan_interval(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field min_scan_window from event GATTSERVICE_SUBEVENT_SCAN_PARAMETERS_SERVICE_SCAN_INTERVAL_UPDATE
 * @param event packet
 * @return min_scan_window
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_scan_parameters_service_scan_interval_update_get_min_scan_window(const uint8_t * event){
    return little_endian_read_16(event, 7);
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_BASS_SERVER_SCAN_STOPPED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_bass_server_scan_stopped_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_BASS_SERVER_SCAN_STARTED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_bass_server_scan_started_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_BASS_SERVER_BROADCAST_CODE
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_bass_server_broadcast_code_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field source_id from event GATTSERVICE_SUBEVENT_BASS_SERVER_BROADCAST_CODE
 * @param event packet
 * @return source_id
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_server_broadcast_code_get_source_id(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field broadcast_code from event GATTSERVICE_SUBEVENT_BASS_SERVER_BROADCAST_CODE
 * @param event packet
 * @param Pointer to storage for broadcast_code
 * @note: btstack_type K
 */
static inline void gattservice_subevent_bass_server_broadcast_code_get_broadcast_code(const uint8_t * event, uint8_t * broadcast_code){
    reverse_bytes(&event[6], broadcast_code, 16);
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_BASS_SERVER_SOURCE_ADDED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_bass_server_source_added_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field source_id from event GATTSERVICE_SUBEVENT_BASS_SERVER_SOURCE_ADDED
 * @param event packet
 * @return source_id
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_server_source_added_get_source_id(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field pa_sync from event GATTSERVICE_SUBEVENT_BASS_SERVER_SOURCE_ADDED
 * @param event packet
 * @return pa_sync
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_server_source_added_get_pa_sync(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_BASS_SERVER_SOURCE_MODIFIED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_bass_server_source_modified_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field source_id from event GATTSERVICE_SUBEVENT_BASS_SERVER_SOURCE_MODIFIED
 * @param event packet
 * @return source_id
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_server_source_modified_get_source_id(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field pa_sync from event GATTSERVICE_SUBEVENT_BASS_SERVER_SOURCE_MODIFIED
 * @param event packet
 * @return pa_sync
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_server_source_modified_get_pa_sync(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_BASS_SERVER_SOURCE_DELETED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_bass_server_source_deleted_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field source_id from event GATTSERVICE_SUBEVENT_BASS_SERVER_SOURCE_DELETED
 * @param event packet
 * @return source_id
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_server_source_deleted_get_source_id(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field pa_sync from event GATTSERVICE_SUBEVENT_BASS_SERVER_SOURCE_DELETED
 * @param event packet
 * @return pa_sync
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_server_source_deleted_get_pa_sync(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_BASS_CLIENT_CONNECTED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_bass_client_connected_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field bass_cid from event GATTSERVICE_SUBEVENT_BASS_CLIENT_CONNECTED
 * @param event packet
 * @return bass_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_bass_client_connected_get_bass_cid(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field status from event GATTSERVICE_SUBEVENT_BASS_CLIENT_CONNECTED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_client_connected_get_status(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field bass_cid from event GATTSERVICE_SUBEVENT_BASS_CLIENT_DISCONNECTED
 * @param event packet
 * @return bass_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_bass_client_disconnected_get_bass_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field bass_cid from event GATTSERVICE_SUBEVENT_BASS_CLIENT_SCAN_OPERATION_COMPLETE
 * @param event packet
 * @return bass_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_bass_client_scan_operation_complete_get_bass_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event GATTSERVICE_SUBEVENT_BASS_CLIENT_SCAN_OPERATION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_client_scan_operation_complete_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field opcode from event GATTSERVICE_SUBEVENT_BASS_CLIENT_SCAN_OPERATION_COMPLETE
 * @param event packet
 * @return opcode
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_client_scan_operation_complete_get_opcode(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field bass_cid from event GATTSERVICE_SUBEVENT_BASS_NOTIFY_RECEIVE_STATE_BASE
 * @param event packet
 * @return bass_cid
 * @note: btstack_type 2
 */
//  static inline uint16_t gattservice_subevent_bass_notify_receive_state_base_get_bass_cid(const uint8_t * event){
//      not implemented yet
//  }
/**
 * @brief Get field source_id from event GATTSERVICE_SUBEVENT_BASS_NOTIFY_RECEIVE_STATE_BASE
 * @param event packet
 * @return source_id
 * @note: btstack_type 1
 */
//  static inline uint8_t gattservice_subevent_bass_notify_receive_state_base_get_source_id(const uint8_t * event){
//      not implemented yet
//  }
/**
 * @brief Get field source_address_type from event GATTSERVICE_SUBEVENT_BASS_NOTIFY_RECEIVE_STATE_BASE
 * @param event packet
 * @return source_address_type
 * @note: btstack_type 1
 */
//  static inline uint8_t gattservice_subevent_bass_notify_receive_state_base_get_source_address_type(const uint8_t * event){
//      not implemented yet
//  }
/**
 * @brief Get field source_address from event GATTSERVICE_SUBEVENT_BASS_NOTIFY_RECEIVE_STATE_BASE
 * @param event packet
 * @return source_address
 * @note: btstack_type B
 */
//  static inline bd_addr_t gattservice_subevent_bass_notify_receive_state_base_get_source_address(const uint8_t * event){
//      not implemented yet
//  }
/**
 * @brief Get field source_adv_sid from event GATTSERVICE_SUBEVENT_BASS_NOTIFY_RECEIVE_STATE_BASE
 * @param event packet
 * @return source_adv_sid
 * @note: btstack_type 1
 */
//  static inline uint8_t gattservice_subevent_bass_notify_receive_state_base_get_source_adv_sid(const uint8_t * event){
//      not implemented yet
//  }
/**
 * @brief Get field broadcast_id from event GATTSERVICE_SUBEVENT_BASS_NOTIFY_RECEIVE_STATE_BASE
 * @param event packet
 * @return broadcast_id
 * @note: btstack_type 3
 */
//  static inline uint32_t gattservice_subevent_bass_notify_receive_state_base_get_broadcast_id(const uint8_t * event){
//      not implemented yet
//  }
/**
 * @brief Get field pa_sync_state from event GATTSERVICE_SUBEVENT_BASS_NOTIFY_RECEIVE_STATE_BASE
 * @param event packet
 * @return pa_sync_state
 * @note: btstack_type 1
 */
//  static inline uint8_t gattservice_subevent_bass_notify_receive_state_base_get_pa_sync_state(const uint8_t * event){
//      not implemented yet
//  }
/**
 * @brief Get field big_encryption from event GATTSERVICE_SUBEVENT_BASS_NOTIFY_RECEIVE_STATE_BASE
 * @param event packet
 * @return big_encryption
 * @note: btstack_type 1
 */
//  static inline uint8_t gattservice_subevent_bass_notify_receive_state_base_get_big_encryption(const uint8_t * event){
//      not implemented yet
//  }
/**
 * @brief Get field bad_code from event GATTSERVICE_SUBEVENT_BASS_NOTIFY_RECEIVE_STATE_BASE
 * @param event packet
 * @return bad_code
 * @note: btstack_type P
 */
//  static inline const uint8_t * gattservice_subevent_bass_notify_receive_state_base_get_bad_code(const uint8_t * event){
//      not implemented yet
//  }
/**
 * @brief Get field subgroups_num from event GATTSERVICE_SUBEVENT_BASS_NOTIFY_RECEIVE_STATE_BASE
 * @param event packet
 * @return subgroups_num
 * @note: btstack_type 1
 */
//  static inline uint8_t gattservice_subevent_bass_notify_receive_state_base_get_subgroups_num(const uint8_t * event){
//      not implemented yet
//  }

/**
 * @brief Get field bass_cid from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return bass_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_bass_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field source_id from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return source_id
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_source_id(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field bis_sync_state from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return bis_sync_state
 * @note: btstack_type 4
 */
static inline uint32_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_bis_sync_state(const uint8_t * event){
    return little_endian_read_32(event, 6);
}
/**
 * @brief Get field metadata_mask from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return metadata_mask
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_metadata_mask(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field preferred_audio_contexts_mask from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return preferred_audio_contexts_mask
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_preferred_audio_contexts_mask(const uint8_t * event){
    return little_endian_read_16(event, 11);
}
/**
 * @brief Get field streaming_audio_contexts_mask from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return streaming_audio_contexts_mask
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_streaming_audio_contexts_mask(const uint8_t * event){
    return little_endian_read_16(event, 13);
}
/**
 * @brief Get field program_info_length from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return program_info_length
 * @note: btstack_type J
 */
static inline uint8_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_program_info_length(const uint8_t * event){
    return event[15];
}
/**
 * @brief Get field program_info from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return program_info
 * @note: btstack_type V
 */
static inline const uint8_t * gattservice_subevent_bass_client_notify_receive_state_subgroup_get_program_info(const uint8_t * event){
    return &event[16];
}
/**
 * @brief Get field language_code from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return language_code
 * @note: btstack_type 3
 */
static inline uint32_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_language_code(const uint8_t * event){
    return little_endian_read_24(event, 16u + event[15]);
}
/**
 * @brief Get field ccids_num from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return ccids_num
 * @note: btstack_type J
 */
static inline uint8_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_ccids_num(const uint8_t * event){
    return event[16u + event[15] + 3u];
}
/**
 * @brief Get field ccids from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return ccids
 * @note: btstack_type V
 */
static inline const uint8_t * gattservice_subevent_bass_client_notify_receive_state_subgroup_get_ccids(const uint8_t * event){
    return &event[16u + event[15] + 3u + 1u];
}
/**
 * @brief Get field parental_rating from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return parental_rating
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_parental_rating(const uint8_t * event){
    return event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u]];
}
/**
 * @brief Get field program_info_uri_length from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return program_info_uri_length
 * @note: btstack_type J
 */
static inline uint8_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_program_info_uri_length(const uint8_t * event){
    return event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u];
}
/**
 * @brief Get field program_info_uri from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return program_info_uri
 * @note: btstack_type V
 */
static inline const uint8_t * gattservice_subevent_bass_client_notify_receive_state_subgroup_get_program_info_uri(const uint8_t * event){
    return &event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u + 1u];
}
/**
 * @brief Get field extended_metadata_type from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return extended_metadata_type
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_extended_metadata_type(const uint8_t * event){
    return little_endian_read_16(event, 16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u]);
}
/**
 * @brief Get field extended_metadata_value_length from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return extended_metadata_value_length
 * @note: btstack_type J
 */
static inline uint8_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_extended_metadata_value_length(const uint8_t * event){
    return event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u] + 2u];
}
/**
 * @brief Get field extended_metadata_value from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return extended_metadata_value
 * @note: btstack_type V
 */
static inline const uint8_t * gattservice_subevent_bass_client_notify_receive_state_subgroup_get_extended_metadata_value(const uint8_t * event){
    return &event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u] + 2u + 1u];
}
/**
 * @brief Get field vendor_specific_metadata_type from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return vendor_specific_metadata_type
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_vendor_specific_metadata_type(const uint8_t * event){
    return little_endian_read_16(event, 16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u] + 2u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u] + 2u]);
}
/**
 * @brief Get field vendor_specific_metadata_value_length from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return vendor_specific_metadata_value_length
 * @note: btstack_type J
 */
static inline uint8_t gattservice_subevent_bass_client_notify_receive_state_subgroup_get_vendor_specific_metadata_value_length(const uint8_t * event){
    return event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u] + 2u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u] + 2u] + 2u];
}
/**
 * @brief Get field vendor_specific_metadata_value from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP
 * @param event packet
 * @return vendor_specific_metadata_value
 * @note: btstack_type V
 */
static inline const uint8_t * gattservice_subevent_bass_client_notify_receive_state_subgroup_get_vendor_specific_metadata_value(const uint8_t * event){
    return &event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u] + 2u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u + 1u + event[16u + event[15] + 3u + 1u + event[16u + event[15] + 3u] + 1u] + 2u] + 2u + 1u];
}

/**
 * @brief Get field bass_cid from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFICATION_COMPLETE
 * @param event packet
 * @return bass_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_bass_client_notification_complete_get_bass_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field source_id from event GATTSERVICE_SUBEVENT_BASS_CLIENT_NOTIFICATION_COMPLETE
 * @param event packet
 * @return source_id
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_client_notification_complete_get_source_id(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field bass_cid from event GATTSERVICE_SUBEVENT_BASS_CLIENT_SOURCE_OPERATION_COMPLETE
 * @param event packet
 * @return bass_cid
 * @note: btstack_type 2
 */
static inline uint16_t gattservice_subevent_bass_client_source_operation_complete_get_bass_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event GATTSERVICE_SUBEVENT_BASS_CLIENT_SOURCE_OPERATION_COMPLETE
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_client_source_operation_complete_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field opcode from event GATTSERVICE_SUBEVENT_BASS_CLIENT_SOURCE_OPERATION_COMPLETE
 * @param event packet
 * @return opcode
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_client_source_operation_complete_get_opcode(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field source_id from event GATTSERVICE_SUBEVENT_BASS_CLIENT_SOURCE_OPERATION_COMPLETE
 * @param event packet
 * @return source_id
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_client_source_operation_complete_get_source_id(const uint8_t * event){
    return event[7];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_BASS_SERVER_CONNECTED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_bass_server_connected_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event GATTSERVICE_SUBEVENT_BASS_SERVER_CONNECTED
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t gattservice_subevent_bass_server_connected_get_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field con_handle from event GATTSERVICE_SUBEVENT_BASS_SERVER_DISCONNECTED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t gattservice_subevent_bass_server_disconnected_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}


/**
 * @brief Get field status from event MESH_SUBEVENT_PB_TRANSPORT_PDU_SENT
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_pb_transport_pdu_sent_get_status(const uint8_t * event){
    return event[3];
}

/**
 * @brief Get field status from event MESH_SUBEVENT_PB_TRANSPORT_LINK_OPEN
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_pb_transport_link_open_get_status(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_TRANSPORT_LINK_OPEN
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_transport_link_open_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 4);
}
/**
 * @brief Get field pb_type from event MESH_SUBEVENT_PB_TRANSPORT_LINK_OPEN
 * @param event packet
 * @return pb_type
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_pb_transport_link_open_get_pb_type(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_TRANSPORT_LINK_CLOSED
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_pb_transport_link_closed_get_pb_transport_cid(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field reason from event MESH_SUBEVENT_PB_TRANSPORT_LINK_CLOSED
 * @param event packet
 * @return reason
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_transport_link_closed_get_reason(const uint8_t * event){
    return little_endian_read_16(event, 4);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_ATTENTION_TIMER
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_attention_timer_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field attention_time from event MESH_SUBEVENT_PB_PROV_ATTENTION_TIMER
 * @param event packet
 * @return attention_time
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_pb_prov_attention_timer_get_attention_time(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_START_EMIT_PUBLIC_KEY_OOB
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_start_emit_public_key_oob_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_STOP_EMIT_PUBLIC_KEY_OOB
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_stop_emit_public_key_oob_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_INPUT_OOB_REQUEST
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_input_oob_request_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_START_EMIT_OUTPUT_OOB
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_start_emit_output_oob_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field output_oob from event MESH_SUBEVENT_PB_PROV_START_EMIT_OUTPUT_OOB
 * @param event packet
 * @return output_oob
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_pb_prov_start_emit_output_oob_get_output_oob(const uint8_t * event){
    return little_endian_read_32(event, 5);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_STOP_EMIT_OUTPUT_OOB
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_stop_emit_output_oob_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_START_RECEIVE_PUBLIC_KEY_OOB
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_start_receive_public_key_oob_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_STOP_RECEIVE_PUBLIC_KEY_OOB
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_stop_receive_public_key_oob_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_OUTPUT_OOB_REQUEST
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_output_oob_request_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_START_EMIT_INPUT_OOB
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_start_emit_input_oob_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field output_oob from event MESH_SUBEVENT_PB_PROV_START_EMIT_INPUT_OOB
 * @param event packet
 * @return output_oob
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_pb_prov_start_emit_input_oob_get_output_oob(const uint8_t * event){
    return little_endian_read_32(event, 5);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_STOP_EMIT_INPUT_OOB
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_stop_emit_input_oob_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_CAPABILITIES
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_capabilities_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field num_elements from event MESH_SUBEVENT_PB_PROV_CAPABILITIES
 * @param event packet
 * @return num_elements
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_pb_prov_capabilities_get_num_elements(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field algorithms from event MESH_SUBEVENT_PB_PROV_CAPABILITIES
 * @param event packet
 * @return algorithms
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_capabilities_get_algorithms(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field public_key from event MESH_SUBEVENT_PB_PROV_CAPABILITIES
 * @param event packet
 * @return public_key
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_pb_prov_capabilities_get_public_key(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field static_oob_type from event MESH_SUBEVENT_PB_PROV_CAPABILITIES
 * @param event packet
 * @return static_oob_type
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_pb_prov_capabilities_get_static_oob_type(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field output_oob_size from event MESH_SUBEVENT_PB_PROV_CAPABILITIES
 * @param event packet
 * @return output_oob_size
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_pb_prov_capabilities_get_output_oob_size(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field output_oob_action from event MESH_SUBEVENT_PB_PROV_CAPABILITIES
 * @param event packet
 * @return output_oob_action
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_capabilities_get_output_oob_action(const uint8_t * event){
    return little_endian_read_16(event, 11);
}
/**
 * @brief Get field input_oob_size from event MESH_SUBEVENT_PB_PROV_CAPABILITIES
 * @param event packet
 * @return input_oob_size
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_pb_prov_capabilities_get_input_oob_size(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field input_oob_action from event MESH_SUBEVENT_PB_PROV_CAPABILITIES
 * @param event packet
 * @return input_oob_action
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_capabilities_get_input_oob_action(const uint8_t * event){
    return little_endian_read_16(event, 14);
}

/**
 * @brief Get field pb_transport_cid from event MESH_SUBEVENT_PB_PROV_COMPLETE
 * @param event packet
 * @return pb_transport_cid
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_pb_prov_complete_get_pb_transport_cid(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field attention_time from event MESH_SUBEVENT_ATTENTION_TIMER
 * @param event packet
 * @return attention_time
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_attention_timer_get_attention_time(const uint8_t * event){
    return event[3];
}

/**
 * @brief Get field con_handle from event MESH_SUBEVENT_PROXY_CONNECTED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t mesh_subevent_proxy_connected_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field con_handle from event MESH_SUBEVENT_PROXY_PDU_SENT
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t mesh_subevent_proxy_pdu_sent_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field con_handle from event MESH_SUBEVENT_PROXY_DISCONNECTED
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t mesh_subevent_proxy_disconnected_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field con_handle from event MESH_SUBEVENT_MESSAGE_SENT
 * @param event packet
 * @return con_handle
 * @note: btstack_type H
 */
static inline hci_con_handle_t mesh_subevent_message_sent_get_con_handle(const uint8_t * event){
    return little_endian_read_16(event, 3);
}

/**
 * @brief Get field element_index from event MESH_SUBEVENT_STATE_UPDATE_BOOL
 * @param event packet
 * @return element_index
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_state_update_bool_get_element_index(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field model_identifier from event MESH_SUBEVENT_STATE_UPDATE_BOOL
 * @param event packet
 * @return model_identifier
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_state_update_bool_get_model_identifier(const uint8_t * event){
    return little_endian_read_32(event, 4);
}
/**
 * @brief Get field state_identifier from event MESH_SUBEVENT_STATE_UPDATE_BOOL
 * @param event packet
 * @return state_identifier
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_state_update_bool_get_state_identifier(const uint8_t * event){
    return little_endian_read_32(event, 8);
}
/**
 * @brief Get field reason from event MESH_SUBEVENT_STATE_UPDATE_BOOL
 * @param event packet
 * @return reason
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_state_update_bool_get_reason(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field value from event MESH_SUBEVENT_STATE_UPDATE_BOOL
 * @param event packet
 * @return value
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_state_update_bool_get_value(const uint8_t * event){
    return event[13];
}

/**
 * @brief Get field element_index from event MESH_SUBEVENT_STATE_UPDATE_INT16
 * @param event packet
 * @return element_index
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_state_update_int16_get_element_index(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field model_identifier from event MESH_SUBEVENT_STATE_UPDATE_INT16
 * @param event packet
 * @return model_identifier
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_state_update_int16_get_model_identifier(const uint8_t * event){
    return little_endian_read_32(event, 4);
}
/**
 * @brief Get field state_identifier from event MESH_SUBEVENT_STATE_UPDATE_INT16
 * @param event packet
 * @return state_identifier
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_state_update_int16_get_state_identifier(const uint8_t * event){
    return little_endian_read_32(event, 8);
}
/**
 * @brief Get field reason from event MESH_SUBEVENT_STATE_UPDATE_INT16
 * @param event packet
 * @return reason
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_state_update_int16_get_reason(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field value from event MESH_SUBEVENT_STATE_UPDATE_INT16
 * @param event packet
 * @return value
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_state_update_int16_get_value(const uint8_t * event){
    return little_endian_read_16(event, 13);
}

/**
 * @brief Get field element_index from event MESH_SUBEVENT_MESSAGE_NOT_ACKNOWLEDGED
 * @param event packet
 * @return element_index
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_message_not_acknowledged_get_element_index(const uint8_t * event){
    return event[3];
}
/**
 * @brief Get field model_identifier from event MESH_SUBEVENT_MESSAGE_NOT_ACKNOWLEDGED
 * @param event packet
 * @return model_identifier
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_message_not_acknowledged_get_model_identifier(const uint8_t * event){
    return little_endian_read_32(event, 4);
}
/**
 * @brief Get field opcode from event MESH_SUBEVENT_MESSAGE_NOT_ACKNOWLEDGED
 * @param event packet
 * @return opcode
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_message_not_acknowledged_get_opcode(const uint8_t * event){
    return little_endian_read_32(event, 8);
}
/**
 * @brief Get field dest from event MESH_SUBEVENT_MESSAGE_NOT_ACKNOWLEDGED
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_message_not_acknowledged_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 12);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_GENERIC_ON_OFF
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_generic_on_off_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event MESH_SUBEVENT_GENERIC_ON_OFF
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_generic_on_off_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field present_value from event MESH_SUBEVENT_GENERIC_ON_OFF
 * @param event packet
 * @return present_value
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_generic_on_off_get_present_value(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field target_value from event MESH_SUBEVENT_GENERIC_ON_OFF
 * @param event packet
 * @return target_value
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_generic_on_off_get_target_value(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field remaining_time_ms from event MESH_SUBEVENT_GENERIC_ON_OFF
 * @param event packet
 * @return remaining_time_ms
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_generic_on_off_get_remaining_time_ms(const uint8_t * event){
    return little_endian_read_32(event, 8);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_GENERIC_LEVEL
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_generic_level_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event MESH_SUBEVENT_GENERIC_LEVEL
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_generic_level_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field present_value from event MESH_SUBEVENT_GENERIC_LEVEL
 * @param event packet
 * @return present_value
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_generic_level_get_present_value(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field target_value from event MESH_SUBEVENT_GENERIC_LEVEL
 * @param event packet
 * @return target_value
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_generic_level_get_target_value(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field remaining_time_ms from event MESH_SUBEVENT_GENERIC_LEVEL
 * @param event packet
 * @return remaining_time_ms
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_generic_level_get_remaining_time_ms(const uint8_t * event){
    return little_endian_read_32(event, 10);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_HEALTH_PERFORM_TEST
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_health_perform_test_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field netkey_index from event MESH_SUBEVENT_HEALTH_PERFORM_TEST
 * @param event packet
 * @return netkey_index
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_health_perform_test_get_netkey_index(const uint8_t * event){
    return little_endian_read_16(event, 5);
}
/**
 * @brief Get field appkey_index from event MESH_SUBEVENT_HEALTH_PERFORM_TEST
 * @param event packet
 * @return appkey_index
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_health_perform_test_get_appkey_index(const uint8_t * event){
    return little_endian_read_16(event, 7);
}
/**
 * @brief Get field company_id from event MESH_SUBEVENT_HEALTH_PERFORM_TEST
 * @param event packet
 * @return company_id
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_health_perform_test_get_company_id(const uint8_t * event){
    return little_endian_read_16(event, 9);
}
/**
 * @brief Get field test_id from event MESH_SUBEVENT_HEALTH_PERFORM_TEST
 * @param event packet
 * @return test_id
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_health_perform_test_get_test_id(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field acknowledged from event MESH_SUBEVENT_HEALTH_PERFORM_TEST
 * @param event packet
 * @return acknowledged
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_health_perform_test_get_acknowledged(const uint8_t * event){
    return event[12];
}

/**
 * @brief Get field element_index from event MESH_SUBEVENT_HEALTH_ATTENTION_TIMER_CHANGED
 * @param event packet
 * @return element_index
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_health_attention_timer_changed_get_element_index(const uint8_t * event){
    return event[3];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_GENERIC_DEFAULT_TRANSITION_TIME
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_generic_default_transition_time_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field status from event MESH_SUBEVENT_GENERIC_DEFAULT_TRANSITION_TIME
 * @param event packet
 * @return status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_generic_default_transition_time_get_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field transition_time_gdtt from event MESH_SUBEVENT_GENERIC_DEFAULT_TRANSITION_TIME
 * @param event packet
 * @return transition_time_gdtt
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_generic_default_transition_time_get_transition_time_gdtt(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_BEACON
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_beacon_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_BEACON
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_beacon_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field secure_network_beacon_state from event MESH_SUBEVENT_CONFIGURATION_BEACON
 * @param event packet
 * @return secure_network_beacon_state
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_beacon_get_secure_network_beacon_state(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_DEFAULT_TTL
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_default_ttl_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_DEFAULT_TTL
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_default_ttl_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field default_ttl from event MESH_SUBEVENT_CONFIGURATION_DEFAULT_TTL
 * @param event packet
 * @return default_ttl
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_default_ttl_get_default_ttl(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_GATT_PROXY
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_gatt_proxy_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_GATT_PROXY
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_gatt_proxy_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field gatt_proxy_state from event MESH_SUBEVENT_CONFIGURATION_GATT_PROXY
 * @param event packet
 * @return gatt_proxy_state
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_gatt_proxy_get_gatt_proxy_state(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_RELAY
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_relay_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_RELAY
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_relay_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field relay from event MESH_SUBEVENT_CONFIGURATION_RELAY
 * @param event packet
 * @return relay
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_relay_get_relay(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field retransmit_count from event MESH_SUBEVENT_CONFIGURATION_RELAY
 * @param event packet
 * @return retransmit_count
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_relay_get_retransmit_count(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field retransmit_interval_ms from event MESH_SUBEVENT_CONFIGURATION_RELAY
 * @param event packet
 * @return retransmit_interval_ms
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_relay_get_retransmit_interval_ms(const uint8_t * event){
    return event[8];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_MODEL_PUBLICATION
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_publication_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_MODEL_PUBLICATION
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_publication_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field publish_address from event MESH_SUBEVENT_CONFIGURATION_MODEL_PUBLICATION
 * @param event packet
 * @return publish_address
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_publication_get_publish_address(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field appkey_index from event MESH_SUBEVENT_CONFIGURATION_MODEL_PUBLICATION
 * @param event packet
 * @return appkey_index
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_publication_get_appkey_index(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field credential_flag from event MESH_SUBEVENT_CONFIGURATION_MODEL_PUBLICATION
 * @param event packet
 * @return credential_flag
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_publication_get_credential_flag(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field publish_ttl from event MESH_SUBEVENT_CONFIGURATION_MODEL_PUBLICATION
 * @param event packet
 * @return publish_ttl
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_publication_get_publish_ttl(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field publish_period from event MESH_SUBEVENT_CONFIGURATION_MODEL_PUBLICATION
 * @param event packet
 * @return publish_period
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_publication_get_publish_period(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field publish_retransmit_count from event MESH_SUBEVENT_CONFIGURATION_MODEL_PUBLICATION
 * @param event packet
 * @return publish_retransmit_count
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_publication_get_publish_retransmit_count(const uint8_t * event){
    return event[13];
}
/**
 * @brief Get field publish_retransmit_interval_steps from event MESH_SUBEVENT_CONFIGURATION_MODEL_PUBLICATION
 * @param event packet
 * @return publish_retransmit_interval_steps
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_publication_get_publish_retransmit_interval_steps(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field model_identifier from event MESH_SUBEVENT_CONFIGURATION_MODEL_PUBLICATION
 * @param event packet
 * @return model_identifier
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_configuration_model_publication_get_model_identifier(const uint8_t * event){
    return little_endian_read_32(event, 15);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_MODEL_SUBSCRIPTION
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_subscription_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_MODEL_SUBSCRIPTION
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_subscription_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field address from event MESH_SUBEVENT_CONFIGURATION_MODEL_SUBSCRIPTION
 * @param event packet
 * @return address
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_subscription_get_address(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field model_identifier from event MESH_SUBEVENT_CONFIGURATION_MODEL_SUBSCRIPTION
 * @param event packet
 * @return model_identifier
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_configuration_model_subscription_get_model_identifier(const uint8_t * event){
    return little_endian_read_32(event, 8);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_MODEL_SUBSCRIPTION_LIST_ITEM
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_subscription_list_item_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_MODEL_SUBSCRIPTION_LIST_ITEM
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_subscription_list_item_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field model_identifier from event MESH_SUBEVENT_CONFIGURATION_MODEL_SUBSCRIPTION_LIST_ITEM
 * @param event packet
 * @return model_identifier
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_configuration_model_subscription_list_item_get_model_identifier(const uint8_t * event){
    return little_endian_read_32(event, 6);
}
/**
 * @brief Get field num_subscription_addresses from event MESH_SUBEVENT_CONFIGURATION_MODEL_SUBSCRIPTION_LIST_ITEM
 * @param event packet
 * @return num_subscription_addresses
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_subscription_list_item_get_num_subscription_addresses(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field subscription_address_pos from event MESH_SUBEVENT_CONFIGURATION_MODEL_SUBSCRIPTION_LIST_ITEM
 * @param event packet
 * @return subscription_address_pos
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_subscription_list_item_get_subscription_address_pos(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field subscription_address_item from event MESH_SUBEVENT_CONFIGURATION_MODEL_SUBSCRIPTION_LIST_ITEM
 * @param event packet
 * @return subscription_address_item
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_subscription_list_item_get_subscription_address_item(const uint8_t * event){
    return little_endian_read_16(event, 12);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_NETKEY_INDEX
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_netkey_index_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_NETKEY_INDEX
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_netkey_index_get_foundation_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_NETKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_netkey_index_list_item_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_NETKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_netkey_index_list_item_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field num_netkey_indexes from event MESH_SUBEVENT_CONFIGURATION_NETKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return num_netkey_indexes
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_netkey_index_list_item_get_num_netkey_indexes(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field netkey_index_pos from event MESH_SUBEVENT_CONFIGURATION_NETKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return netkey_index_pos
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_netkey_index_list_item_get_netkey_index_pos(const uint8_t * event){
    return event[7];
}
/**
 * @brief Get field netkey_index_item from event MESH_SUBEVENT_CONFIGURATION_NETKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return netkey_index_item
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_netkey_index_list_item_get_netkey_index_item(const uint8_t * event){
    return little_endian_read_16(event, 8);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_appkey_index_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_appkey_index_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field netkey_index_item from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX
 * @param event packet
 * @return netkey_index_item
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_appkey_index_get_netkey_index_item(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field appkey_index_item from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX
 * @param event packet
 * @return appkey_index_item
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_appkey_index_get_appkey_index_item(const uint8_t * event){
    return little_endian_read_16(event, 8);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_appkey_index_list_item_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_appkey_index_list_item_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field netkey_index from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return netkey_index
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_appkey_index_list_item_get_netkey_index(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field num_appkey_indexes from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return num_appkey_indexes
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_appkey_index_list_item_get_num_appkey_indexes(const uint8_t * event){
    return event[8];
}
/**
 * @brief Get field appkey_index_pos from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return appkey_index_pos
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_appkey_index_list_item_get_appkey_index_pos(const uint8_t * event){
    return event[9];
}
/**
 * @brief Get field netkey_index_item from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return netkey_index_item
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_appkey_index_list_item_get_netkey_index_item(const uint8_t * event){
    return little_endian_read_16(event, 10);
}
/**
 * @brief Get field appkey_index_item from event MESH_SUBEVENT_CONFIGURATION_APPKEY_INDEX_LIST_ITEM
 * @param event packet
 * @return appkey_index_item
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_appkey_index_list_item_get_appkey_index_item(const uint8_t * event){
    return little_endian_read_16(event, 12);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_NODE_IDENTITY
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_node_identity_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_NODE_IDENTITY
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_node_identity_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field netkey_index_item from event MESH_SUBEVENT_CONFIGURATION_NODE_IDENTITY
 * @param event packet
 * @return netkey_index_item
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_node_identity_get_netkey_index_item(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field identity_status from event MESH_SUBEVENT_CONFIGURATION_NODE_IDENTITY
 * @param event packet
 * @return identity_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_node_identity_get_identity_status(const uint8_t * event){
    return event[8];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_MODEL_APP
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_app_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_MODEL_APP
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_app_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field appkey_index from event MESH_SUBEVENT_CONFIGURATION_MODEL_APP
 * @param event packet
 * @return appkey_index
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_app_get_appkey_index(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field model_identifier from event MESH_SUBEVENT_CONFIGURATION_MODEL_APP
 * @param event packet
 * @return model_identifier
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_configuration_model_app_get_model_identifier(const uint8_t * event){
    return little_endian_read_32(event, 8);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_MODEL_APP_LIST_ITEM
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_app_list_item_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_MODEL_APP_LIST_ITEM
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_app_list_item_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field model_id from event MESH_SUBEVENT_CONFIGURATION_MODEL_APP_LIST_ITEM
 * @param event packet
 * @return model_id
 * @note: btstack_type 4
 */
static inline uint32_t mesh_subevent_configuration_model_app_list_item_get_model_id(const uint8_t * event){
    return little_endian_read_32(event, 6);
}
/**
 * @brief Get field num_appkey_indexes from event MESH_SUBEVENT_CONFIGURATION_MODEL_APP_LIST_ITEM
 * @param event packet
 * @return num_appkey_indexes
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_app_list_item_get_num_appkey_indexes(const uint8_t * event){
    return event[10];
}
/**
 * @brief Get field appkey_index_pos from event MESH_SUBEVENT_CONFIGURATION_MODEL_APP_LIST_ITEM
 * @param event packet
 * @return appkey_index_pos
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_model_app_list_item_get_appkey_index_pos(const uint8_t * event){
    return event[11];
}
/**
 * @brief Get field appkey_index_item from event MESH_SUBEVENT_CONFIGURATION_MODEL_APP_LIST_ITEM
 * @param event packet
 * @return appkey_index_item
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_model_app_list_item_get_appkey_index_item(const uint8_t * event){
    return little_endian_read_16(event, 12);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_NODE_RESET
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_node_reset_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_NODE_RESET
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_node_reset_get_foundation_status(const uint8_t * event){
    return event[5];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_FRIEND
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_friend_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_FRIEND
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_friend_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field friend_state from event MESH_SUBEVENT_CONFIGURATION_FRIEND
 * @param event packet
 * @return friend_state
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_friend_get_friend_state(const uint8_t * event){
    return event[6];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_KEY_REFRESH_PHASE
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_key_refresh_phase_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_KEY_REFRESH_PHASE
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_key_refresh_phase_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field netkey_index from event MESH_SUBEVENT_CONFIGURATION_KEY_REFRESH_PHASE
 * @param event packet
 * @return netkey_index
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_key_refresh_phase_get_netkey_index(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field phase from event MESH_SUBEVENT_CONFIGURATION_KEY_REFRESH_PHASE
 * @param event packet
 * @return phase
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_key_refresh_phase_get_phase(const uint8_t * event){
    return event[8];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_PUBLICATION
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_publication_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_PUBLICATION
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_heartbeat_publication_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field heartbeat_destination from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_PUBLICATION
 * @param event packet
 * @return heartbeat_destination
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_publication_get_heartbeat_destination(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field count_S from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_PUBLICATION
 * @param event packet
 * @return count_S
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_publication_get_count_S(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field period_S from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_PUBLICATION
 * @param event packet
 * @return period_S
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_publication_get_period_S(const uint8_t * event){
    return little_endian_read_16(event, 10);
}
/**
 * @brief Get field ttl from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_PUBLICATION
 * @param event packet
 * @return ttl
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_heartbeat_publication_get_ttl(const uint8_t * event){
    return event[12];
}
/**
 * @brief Get field features from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_PUBLICATION
 * @param event packet
 * @return features
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_publication_get_features(const uint8_t * event){
    return little_endian_read_16(event, 13);
}
/**
 * @brief Get field netkey_index from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_PUBLICATION
 * @param event packet
 * @return netkey_index
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_publication_get_netkey_index(const uint8_t * event){
    return little_endian_read_16(event, 15);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_SUBSCRIPTION
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_subscription_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_SUBSCRIPTION
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_heartbeat_subscription_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field heartbeat_destination from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_SUBSCRIPTION
 * @param event packet
 * @return heartbeat_destination
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_subscription_get_heartbeat_destination(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field heartbeat_source from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_SUBSCRIPTION
 * @param event packet
 * @return heartbeat_source
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_subscription_get_heartbeat_source(const uint8_t * event){
    return little_endian_read_16(event, 8);
}
/**
 * @brief Get field count_S from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_SUBSCRIPTION
 * @param event packet
 * @return count_S
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_subscription_get_count_S(const uint8_t * event){
    return little_endian_read_16(event, 10);
}
/**
 * @brief Get field period_S from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_SUBSCRIPTION
 * @param event packet
 * @return period_S
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_heartbeat_subscription_get_period_S(const uint8_t * event){
    return little_endian_read_16(event, 12);
}
/**
 * @brief Get field min_hops from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_SUBSCRIPTION
 * @param event packet
 * @return min_hops
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_heartbeat_subscription_get_min_hops(const uint8_t * event){
    return event[14];
}
/**
 * @brief Get field max_hops from event MESH_SUBEVENT_CONFIGURATION_HEARTBEAT_SUBSCRIPTION
 * @param event packet
 * @return max_hops
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_heartbeat_subscription_get_max_hops(const uint8_t * event){
    return event[15];
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_LOW_POWER_NODE_POLL_TIMEOUT
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_low_power_node_poll_timeout_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_LOW_POWER_NODE_POLL_TIMEOUT
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_low_power_node_poll_timeout_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field lpn_address from event MESH_SUBEVENT_CONFIGURATION_LOW_POWER_NODE_POLL_TIMEOUT
 * @param event packet
 * @return lpn_address
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_low_power_node_poll_timeout_get_lpn_address(const uint8_t * event){
    return little_endian_read_16(event, 6);
}
/**
 * @brief Get field poll_timeout from event MESH_SUBEVENT_CONFIGURATION_LOW_POWER_NODE_POLL_TIMEOUT
 * @param event packet
 * @return poll_timeout
 * @note: btstack_type 3
 */
static inline uint32_t mesh_subevent_configuration_low_power_node_poll_timeout_get_poll_timeout(const uint8_t * event){
    return little_endian_read_24(event, 8);
}

/**
 * @brief Get field dest from event MESH_SUBEVENT_CONFIGURATION_NETWORK_TRANSMIT
 * @param event packet
 * @return dest
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_network_transmit_get_dest(const uint8_t * event){
    return little_endian_read_16(event, 3);
}
/**
 * @brief Get field foundation_status from event MESH_SUBEVENT_CONFIGURATION_NETWORK_TRANSMIT
 * @param event packet
 * @return foundation_status
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_network_transmit_get_foundation_status(const uint8_t * event){
    return event[5];
}
/**
 * @brief Get field transmit_count from event MESH_SUBEVENT_CONFIGURATION_NETWORK_TRANSMIT
 * @param event packet
 * @return transmit_count
 * @note: btstack_type 1
 */
static inline uint8_t mesh_subevent_configuration_network_transmit_get_transmit_count(const uint8_t * event){
    return event[6];
}
/**
 * @brief Get field transmit_interval_steps_ms from event MESH_SUBEVENT_CONFIGURATION_NETWORK_TRANSMIT
 * @param event packet
 * @return transmit_interval_steps_ms
 * @note: btstack_type 2
 */
static inline uint16_t mesh_subevent_configuration_network_transmit_get_transmit_interval_steps_ms(const uint8_t * event){
    return little_endian_read_16(event, 7);
}



/* API_END */

#if defined __cplusplus
}
#endif

#endif // BTSTACK_EVENT_H
