// Code generated by protoc-gen-ts_proto. DO NOT EDIT.
// versions:
//   protoc-gen-ts_proto  v2.6.1
//   protoc               v5.29.3
// source: envelope.proto

/* eslint-disable */

/** An authenticated message of arbitrary type. */
export interface Envelope {
  /**
   * Message to be signed. (In JSON, this is encoded as base64.)
   * REQUIRED.
   */
  payload: Buffer;
  /**
   * String unambiguously identifying how to interpret payload.
   * REQUIRED.
   */
  payloadType: string;
  /**
   * Signature over:
   *     PAE(type, payload)
   * Where PAE is defined as:
   * PAE(type, payload) = "DSSEv1" + SP + LEN(type) + SP + type + SP + LEN(payload) + SP + payload
   * +               = concatenation
   * SP              = ASCII space [0x20]
   * "DSSEv1"        = ASCII [0x44, 0x53, 0x53, 0x45, 0x76, 0x31]
   * LEN(s)          = ASCII decimal encoding of the byte length of s, with no leading zeros
   * REQUIRED (length >= 1).
   */
  signatures: Signature[];
}

export interface Signature {
  /**
   * Signature itself. (In JSON, this is encoded as base64.)
   * REQUIRED.
   */
  sig: Buffer;
  /**
   * Unauthenticated* hint identifying which public key was used.
   * OPTIONAL.
   */
  keyid: string;
}

export const Envelope: MessageFns<Envelope> = {
  fromJSON(object: any): Envelope {
    return {
      payload: isSet(object.payload) ? Buffer.from(bytesFromBase64(object.payload)) : Buffer.alloc(0),
      payloadType: isSet(object.payloadType) ? globalThis.String(object.payloadType) : "",
      signatures: globalThis.Array.isArray(object?.signatures)
        ? object.signatures.map((e: any) => Signature.fromJSON(e))
        : [],
    };
  },

  toJSON(message: Envelope): unknown {
    const obj: any = {};
    if (message.payload.length !== 0) {
      obj.payload = base64FromBytes(message.payload);
    }
    if (message.payloadType !== "") {
      obj.payloadType = message.payloadType;
    }
    if (message.signatures?.length) {
      obj.signatures = message.signatures.map((e) => Signature.toJSON(e));
    }
    return obj;
  },
};

export const Signature: MessageFns<Signature> = {
  fromJSON(object: any): Signature {
    return {
      sig: isSet(object.sig) ? Buffer.from(bytesFromBase64(object.sig)) : Buffer.alloc(0),
      keyid: isSet(object.keyid) ? globalThis.String(object.keyid) : "",
    };
  },

  toJSON(message: Signature): unknown {
    const obj: any = {};
    if (message.sig.length !== 0) {
      obj.sig = base64FromBytes(message.sig);
    }
    if (message.keyid !== "") {
      obj.keyid = message.keyid;
    }
    return obj;
  },
};

function bytesFromBase64(b64: string): Uint8Array {
  return Uint8Array.from(globalThis.Buffer.from(b64, "base64"));
}

function base64FromBytes(arr: Uint8Array): string {
  return globalThis.Buffer.from(arr).toString("base64");
}

function isSet(value: any): boolean {
  return value !== null && value !== undefined;
}

interface MessageFns<T> {
  fromJSON(object: any): T;
  toJSON(message: T): unknown;
}
