// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ivsrealtime provides the client and types for making API
// requests to Amazon Interactive Video Service RealTime.
//
// The Amazon Interactive Video Service (IVS) real-time API is REST compatible,
// using a standard HTTP API and an AWS EventBridge event stream for responses.
// JSON is used for both requests and responses, including errors.
//
// Key Concepts
//
//   - Stage — A virtual space where participants can exchange video in real
//     time.
//
//   - Participant token — A token that authenticates a participant when
//     they join a stage.
//
//   - Participant object — Represents participants (people) in the stage
//     and contains information about them. When a token is created, it includes
//     a participant ID; when a participant uses that token to join a stage,
//     the participant is associated with that participant ID. There is a 1:1
//     mapping between participant tokens and participants.
//
// For server-side composition:
//
//   - Composition process — Composites participants of a stage into a single
//     video and forwards it to a set of outputs (e.g., IVS channels). Composition
//     endpoints support this process.
//
//   - Composition — Controls the look of the outputs, including how participants
//     are positioned in the video.
//
// For more information about your IVS live stream, also see Getting Started
// with Amazon IVS Real-Time Streaming (https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started.html).
//
// # Tagging
//
// A tag is a metadata label that you assign to an AWS resource. A tag comprises
// a key and a value, both set by you. For example, you might set a tag as topic:nature
// to label a particular video category. See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// for more information, including restrictions that apply to tags and "Tag
// naming limits and requirements"; Amazon IVS stages has no service-specific
// constraints beyond what is documented there.
//
// Tags can help you identify and organize your AWS resources. For example,
// you can use the same tag for different resources to indicate that they are
// related. You can also use tags to manage access (see Access Tags (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)).
//
// The Amazon IVS real-time API has these tag-related endpoints: TagResource,
// UntagResource, and ListTagsForResource. The following resource supports tagging:
// Stage.
//
// At most 50 tags can be applied to a resource.
//
// See https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14 for more information on this service.
//
// See ivsrealtime package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/ivsrealtime/
//
// # Using the Client
//
// To contact Amazon Interactive Video Service RealTime with the SDK use the New function to create
// a new service client. With that client you can make API requests to the service.
// These clients are safe to use concurrently.
//
// See the SDK's documentation for more information on how to use the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws.Config documentation for more information on configuring SDK clients.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the Amazon Interactive Video Service RealTime client IVSRealTime for more
// information on creating client for this service.
// https://docs.aws.amazon.com/sdk-for-go/api/service/ivsrealtime/#New
package ivsrealtime
