searchData={"items":[{"type":"module","title":"leex","doc":"Lexical analyzer generator for Erlang\n\nA regular expression based lexical analyzer generator for Erlang, similar to\n`lex` or `flex`.\n\n> #### Note {: .info }\n>\n> The `leex` module was considered experimental when it was introduced.","ref":"leex.html"},{"type":"module","title":"Default Leex Options - leex","doc":"The (host operating system) environment variable `ERL_COMPILER_OPTIONS` can be\nused to give default Leex options. Its value must be a valid Erlang term. If the\nvalue is a list, it is used as is. If it is not a list, it is put into a list.\n\nThe list is appended to any options given to `file/2`.\n\nThe list can be retrieved with `compile:env_compiler_options/0`.","ref":"leex.html#module-default-leex-options"},{"type":"module","title":"Input File Format - leex","doc":"Erlang style comments starting with a `%` are allowed in scanner files. A\ndefinition file has the following format:\n\n```text\n \n\nDefinitions.\n\n \n\nRules.\n\n \n\nErlang code.\n\n \n```\n\nThe `Definitions.`, `Rules.`, and `Erlang code` headings are mandatory\nand must start at the beginning of a source line. The ` `,\n` `, and ` ` sections are allowed to be\nempty, but there must be at least one rule.\n\nMacro definitions have the following format:\n\n```text\nNAME = VALUE\n```\n\nand there must be spaces around `=`. Macros can be used in the regular\nexpressions of rules by writing `{NAME}`.\n\n> #### Note {: .info }\n>\n> When macros are expanded in expressions, the macro calls are replaced by the\n> macro value without any form of quoting or enclosing in parentheses.\n\nRules have the following format:\n\n```text\n  :  .\n```\n\nThe ` ` must occur at the start of a line and not include any blanks; use\n`\\t` and `\\s` to include TAB and SPACE characters in the regular expression. If\n` ` matches then the corresponding ` ` is evaluated to generate a\ntoken. With the Erlang code the following predefined variables are available:\n\n- **`TokenChars`** - A list of the characters in the matched token.\n\n- **`TokenLen`** - The number of characters in the matched token.\n\n- **`TokenLine`** - The line number where the token occurred.\n\n- **`TokenCol`** - The column number where the token occurred (column of the\n  first character included in the token).\n\n- **`TokenLoc`** - Token location. Expands to `{TokenLine,TokenCol}` (even when\n  `error_location` is set to `line`).\n\nThe code must return:\n\n- **`{token,Token}`** - Return `Token` to the caller.\n\n- **`{end_token,Token}`** - Return `Token` and is last token in a tokens call.\n\n- **`skip_token`** - Skip this token completely.\n\n- **`{error,ErrString}`** - An error in the token, `ErrString` is a string\n  describing the error.\n\nIt is also possible to push back characters into the input characters with the\nfollowing returns:\n\n- `{token,Token,PushBackList}`\n- `{end_token,Token,PushBackList}`\n- `{skip_token,PushBackList}`\n\nThese have the same meanings as the normal returns but the characters in\n`PushBackList` will be prepended to the input characters and scanned for the\nnext token. Note that pushing back a newline will mean the line numbering will\nno longer be correct.\n\n> #### Note {: .info }\n>\n> Pushing back characters gives you unexpected possibilities to cause the\n> scanner to loop\\!\n\nThe following example would match a simple Erlang integer or float and return a\ntoken which could be sent to the Erlang parser:\n\n```erlang\nD = [0-9]\n\n{D}+ :\n  {token,{integer,TokenLine,list_to_integer(TokenChars)}}.\n\n{D}+\\.{D}+((E|e)(\\+|\\-)?{D}+)? :\n  {token,{float,TokenLine,list_to_float(TokenChars)}}.\n```\n\nThe Erlang code in the `Erlang code.` section is written into the output file\ndirectly after the module declaration and predefined exports declaration, making\nit possible to add extra exports, define imports, and other attributes, which are\nvisible in the whole file.","ref":"leex.html#module-input-file-format"},{"type":"module","title":"Regular Expressions - leex","doc":"The regular expressions allowed here is a subset of the set found in `egrep` and\nin the AWK programming language, as defined in the book _The AWK Programming\nLanguage_ by A. V. Aho, B. W. Kernighan, and P. J. Weinberger. They are composed of\nthe following characters:\n\n- **`c`** - Matches the non-metacharacter c.\n\n- **`\\c`** - Matches the escape sequence or literal character c.\n\n- **`.`** - Matches any character.\n\n- **`^`** - Matches the beginning of a string.\n\n- **`$`** - Matches the end of a string.\n\n- **`[abc...]`** - Character class, which matches any of the characters\n  `abc...`. Character ranges are specified by a pair of characters separated by\n  a `-`.\n\n- **`[^abc...]`** - Negated character class, which matches any character except\n  `abc...`.\n\n- **`r1 | r2`** - Alternation. It matches either `r1` or `r2`.\n\n- **`r1r2`** - Concatenation. It matches `r1` and then `r2`.\n\n- **`r+`** - Matches one or more `r`s.\n\n- **`r*`** - Matches zero or more `r`s.\n\n- **`r?`** - Matches zero or one `r`s.\n\n- **`(r)`** - Grouping. It matches `r`.\n\nThe escape sequences allowed are the same as for Erlang strings:\n\n- **`\\b`** - Backspace.\n\n- **`\\f`** - Form feed.\n\n- **`\\n`** - Newline (line feed).\n\n- **`\\r`** - Carriage return.\n\n- **`\\t`** - Tab.\n\n- **`\\e`** - Escape.\n\n- **`\\v`** - Vertical tab.\n\n- **`\\s`** - Space.\n\n- **`\\d`** - Delete.\n\n- **`\\ddd`** - The octal value `ddd`.\n\n- **`\\xhh`** - The hexadecimal value `hh`.\n\n- **`\\x{h...}`** - The hexadecimal value `h...`.\n\n- **`\\c`** - Any other character literally, for example `\\\\` for backslash, `\\\"`\n  for `\"`.\n\nThe following examples define simplified versions of a few Erlang data types:\n\n```text\nAtoms [a-z][0-9a-zA-Z_]*\n\nVariables [A-Z_][0-9a-zA-Z_]*\n\nFloats (\\+|-)?[0-9]+\\.[0-9]+((E|e)(\\+|-)?[0-9]+)?\n```\n\n> #### Note {: .info }\n>\n> Anchoring a regular expression with `^` and `$` is not implemented in the\n> current version of `leex` and generates a parse error.","ref":"leex.html#module-regular-expressions"},{"type":"function","title":"leex.file/1","doc":"","ref":"leex.html#file/1"},{"type":"function","title":"leex.file/2","doc":"Generates a lexical analyzer from the definition in the input file.\n\nThe input file has the extension `.xrl`. This is added to the filename\nif it is not given.  The resulting module is the Xrl filename without\nthe `.xrl` extension.\n\nThe current options are:\n\n- **`dfa_graph`** - Generates a `.dot` file which contains a description of the\n  DFA in a format which can be viewed with Graphviz, `www.graphviz.com`.\n\n- **`{includefile,Includefile}`** - Uses a specific or customised prologue file\n  instead of default `lib/parsetools/include/leexinc.hrl` which is otherwise\n  included.\n\n- **`{report_errors, boolean()}`** - Causes errors to be printed as they occur.\n  Default is `true`.\n\n- **`{report_warnings, boolean()}`** - Causes warnings to be printed as they\n  occur. Default is `true`.\n\n- **`{report, boolean()}`** - This is a short form for both `report_errors` and\n  `report_warnings`.\n\n- **`{return_errors, boolean()}`** - If this flag is set,\n  `{error, Errors, Warnings}` is returned when there are errors. Default is\n  `false`.\n\n- **`{return_warnings, boolean()}`** - If this flag is set, an extra field\n  containing `Warnings` is added to the tuple returned upon success. Default is\n  `false`.\n\n- **`{return, boolean()}`** - This is a short form for both `return_errors` and\n  `return_warnings`.\n\n- **`{scannerfile, Scannerfile}`** - `Scannerfile` is the name of the file that\n  will contain the Erlang scanner code that is generated. The default (`\"\"`) is\n  to add the extension `.erl` to `FileName` stripped of the `.xrl` extension.\n\n- **`{verbose, boolean()}`** - Outputs information from parsing the input file\n  and generating the internal tables.\n\n- **`{warnings_as_errors, boolean()}`** - Causes warnings to be treated as\n  errors.\n\n- **`{deterministic, boolean()}`** - Causes generated `-file()` attributes to only\n  include the basename of the file path.\n\n- **`{error_location, line | column}`** - If set to `column`, error location\n  will be `{Line,Column}` tuple instead of just `Line`. Also, `StartLoc` and\n  `EndLoc` in [`string/2`](`string/2`), [`token/3`](`token/3`), and\n  [`tokens/3`](`tokens/3`) functions will be `{Line,Column}` tuple instead of\n  just `Line`. Default is `line`. Note that you can use `TokenLoc` for token\n  location independently, even if the `error_location` is set to `line`.\n\n  Unicode characters are counted as many columns as they use bytes to represent.\n\n- **`{tab_size, pos_integer()}`** - Sets the width of `\\t` character (only\n  relevant if `error_location` is set to `column`). Default is `8`.\n\nAny of the Boolean options can be set to `true` by stating the name of the\noption. For example, `verbose` is equivalent to `{verbose, true}`.\n\nLeex will add the extension `.hrl` to the `Includefile` name and the extension\n`.erl` to the `Scannerfile` name, unless the extension is already there.","ref":"leex.html#file/2"},{"type":"function","title":"leex.format_error/1","doc":"Returns a descriptive string in English of an error reason `ErrorDescriptor`\nreturned by [`leex:file/1,2`](`file/1`) when there is an error in a regular\nexpression.","ref":"leex.html#format_error/1"},{"type":"function","title":"leex.string/1","doc":"","ref":"leex.html#string/1"},{"type":"function","title":"leex.string/2","doc":"Scans `String` and returns either all the tokens in it or an `error` tuple.\n\n`StartLoc` and `EndLoc` are either [`erl_anno:line()`](`t:erl_anno:line/0`)\nor [`erl_anno:location()`](`t:erl_anno:location/0`), depending on the\n`error_location` option.\n\n> #### Note {: .info }\n>\n> It is an error if not all of the characters in `String` are consumed.","ref":"leex.html#string/2"},{"type":"function","title":"leex.token/2","doc":"","ref":"leex.html#token/2"},{"type":"function","title":"leex.token/3","doc":"This is a re-entrant call to try and scan a single token from `Chars`.\n\nIf there are enough characters in `Chars` to either scan a token or\ndetect an error then this will be returned with\n`{done,...}`. Otherwise `{cont,Cont}` will be returned where `Cont` is\nused in the next call to `token()` with more characters to try an scan\nthe token. This is continued until a token has been scanned. `Cont` is\ninitially `[]`.\n\nIt is not designed to be called directly by an application, but is\nused through the I/O system where it can typically be called in an\napplication by:\n\n```erlang\nio:request(InFile, {get_until,unicode,Prompt,Module,token,[Loc]})\n  -> TokenRet\n```","ref":"leex.html#token/3"},{"type":"function","title":"leex.tokens/2","doc":"","ref":"leex.html#tokens/2"},{"type":"function","title":"leex.tokens/3","doc":"This is a re-entrant call to try and scan tokens from `Chars`.\n\nIf there are enough characters in `Chars` to either scan tokens or\ndetect an error then this will be returned with\n`{done,...}`. Otherwise `{cont,Cont}` will be returned where `Cont` is\nused in the next call to `tokens()` with more characters to try an\nscan the tokens. This is continued until all tokens have been\nscanned. `Cont` is initially `[]`.\n\nThis functions differs from `token` in that it will continue to scan tokens up\nto and including an `{end_token,Token}` has been scanned (see next section). It\nwill then return all the tokens. This is typically used for scanning grammars\nlike Erlang where there is an explicit end token, `'.'`. If no end token is\nfound then the whole file will be scanned and returned. If an error occurs then\nall tokens up to and including the next end token will be skipped.\n\nIt is not designed to be called directly by an application, but used through the\nI/O system where it can typically be called in an application by:\n\n```erlang\nio:request(InFile, {get_until,unicode,Prompt,Module,tokens,[Loc]})\n  -> TokensRet\n```","ref":"leex.html#tokens/3"},{"type":"type","title":"leex.error_info/0","doc":"The standard `t:error_info/0` structure that is returned from all I/O modules.\n`ErrorDescriptor` is formattable by `format_error/1`.","ref":"leex.html#t:error_info/0"},{"type":"type","title":"leex.error_ret/0","doc":"","ref":"leex.html#t:error_ret/0"},{"type":"type","title":"leex.errors/0","doc":"","ref":"leex.html#t:errors/0"},{"type":"type","title":"leex.leex_ret/0","doc":"","ref":"leex.html#t:leex_ret/0"},{"type":"type","title":"leex.ok_ret/0","doc":"","ref":"leex.html#t:ok_ret/0"},{"type":"type","title":"leex.warnings/0","doc":"","ref":"leex.html#t:warnings/0"},{"type":"module","title":"yecc","doc":"LALR-1 Parser Generator\n\nAn LALR-1 parser generator for Erlang, similar to `yacc`. Takes a BNF grammar\ndefinition as input, and produces Erlang code for a parser.\n\nTo understand this text, you also have to look at the `yacc` documentation in\nthe UNIX(TM) manual. This is most probably necessary in order to understand the\nidea of a parser generator, and the principle and problems of LALR parsing with\nfinite look-ahead.\n\nAn nice introduction to `yacc` can be found in chapter 8 of \"The UNIX\nProgramming Environment\" by Brian W. Kernighan and Rob Pike.","ref":"yecc.html"},{"type":"module","title":"Default Yecc Options - yecc","doc":"The (host operating system) environment variable `ERL_COMPILER_OPTIONS` can be\nused to give default Yecc options. Its value must be a valid Erlang term. If the\nvalue is a list, it is used as is. If it is not a list, it is put into a list.\n\nThe list is appended to any options given to `file/2`.\n\nThe list can be retrieved with `compile:env_compiler_options/0`.","ref":"yecc.html#module-default-yecc-options"},{"type":"module","title":"Pre-Processing - yecc","doc":"A `scanner` to pre-process the text (program) to be parsed is not provided\nin the `yecc` module. The scanner serves as a kind of lexicon look-up routine.\nIt is possible to write a grammar that uses only character tokens as terminal\nsymbols, thereby eliminating the need for a scanner, but this would make the\nparser larger and slower.\n\nThe user should implement a scanner that segments the input text, and turns it\ninto one or more lists of tokens. Each token should be a tuple containing\ninformation about syntactic category, position in the text (for example\nline number), and the actual terminal symbol found in the text:\n`{Category, Position, Symbol}`.\n\nIf a terminal symbol is the only member of a category, and the symbol name is\nidentical to the category name, the token format can be `{Symbol, Position}`.\n\nA list of tokens produced by the scanner should end with a special\n`end_of_input` tuple which the parser is looking for. The format of this tuple\nshould be `{Endsymbol, EndPosition}`, where `Endsymbol` is an identifier that is\ndistinguished from all the terminal and non-terminal categories of the syntax\nrules. The `Endsymbol` can be declared in the grammar file.\n\nThe simplest case is to segment the input string into a list of identifiers\n(atoms) and use those atoms both as categories and values of the tokens. For\nexample, the input string `aaa bbb 777, X` may be scanned (tokenized) as:\n\n```erlang\n[{aaa, 1}, {bbb, 1}, {777, 1}, {',' , 1}, {'X', 1},\n {'$end', 1}].\n```\n\nThis assumes that this is the first line of the input text, and that `'$end'` is\nthe distinguished `end_of_input` symbol.\n\nThe Erlang scanner in the `io` module can be used as a starting point when\nwriting a new scanner. Study `yeccscan.erl` in order to see how a filter can be\nadded on top of `io:scan_erl_form/3` to provide a scanner for Yecc that\ntokenizes grammar files before parsing them with the Yecc parser. A more general\napproach to scanner implementation is to use a scanner generator such as\n`m:leex`.","ref":"yecc.html#module-pre-processing"},{"type":"module","title":"Grammar Definition Format - yecc","doc":"Erlang style `comments`, starting with a `'%'`, are allowed in grammar files.\n\nEach `declaration` or `rule` ends with a dot (the character `'.'`).\n\nThe grammar starts with an optional `header` section. The header is put first in\nthe generated file, before the module declaration. The purpose of the header is\nto provide a means to make the documentation generated by [EDoc](`e:edoc:edoc.md`)\nlook nicer. Each header line should be enclosed in double quotes, and newlines\nwill be inserted between the lines. For example:\n\n```erlang\nHeader \"%% Copyright (C)\"\n\"%% @private\"\n\"%% @Author John\".\n```\n\nNext comes a declaration of the `nonterminal categories` to be used in the\nrules. For example:\n\n```text\nNonterminals sentence nounphrase verbphrase.\n```\n\nA non-terminal category can be used at the left-hand side (= `lhs`, or `head`)\nof a grammar rule. It can also appear at the right-hand side of rules.\n\nNext comes a declaration of the `terminal categories`, which are the categories\nof tokens produced by the scanner. For example:\n\n```text\nTerminals article adjective noun verb.\n```\n\nTerminal categories may only appear in the right hand sides (= `rhs`) of grammar\nrules.\n\nNext comes a declaration of the `rootsymbol`, or start category of the grammar.\nFor example:\n\n```text\nRootsymbol sentence.\n```\n\nThis symbol should appear in the lhs of at least one grammar rule. This is the\nmost general syntactic category which the parser ultimately will parse every\ninput string into.\n\nAfter the rootsymbol declaration comes an optional declaration of the\n`end_of_input` symbol that your scanner is expected to use. For example:\n\n```text\nEndsymbol '$end'.\n```\n\nNext comes one or more declarations of *operator precedences*, if needed. These\nare used to resolve shift/reduce conflicts (see `yacc` documentation).\n\nExamples of operator declarations:\n\n```text\nRight 100 '='.\nNonassoc 200 '==' '=/='.\nLeft 300 '+'.\nLeft 400 '*'.\nUnary 500 '-'.\n```\n\nThese declarations mean that `'='` is defined as a `right associative binary`\noperator with precedence 100, `'=='` and `'=/='` are operators with\n`no associativity`, `'+'` and `'*'` are `left associative binary` operators,\nwhere `'*'` takes precedence over `'+'` (the normal case), and `'-'` is a\n`unary` operator of higher precedence than `'*'`. The fact that '==' has no\nassociativity means that an expression like `a == b == c` is considered a syntax\nerror.\n\nCertain rules are assigned precedence: each rule gets its precedence from the\nlast terminal symbol mentioned in the right hand side of the rule. It is also\npossible to declare precedence for non-terminals, \"one level up\". This is\npractical when an operator is overloaded (see also example 3 below).\n\nNext come the *grammar rules*. Each rule has the general form\n\n```erlang\nLeft_hand_side -> Right_hand_side : Associated_code.\n```\n\nThe left hand side is a non-terminal category. The right hand side is a sequence\nof one or more non-terminal or terminal symbols with spaces between. The\nassociated code is a sequence of zero or more Erlang expressions (with commas\n`','` as separators). If the associated code is empty, the separating colon\n`':'` is also omitted. A final dot marks the end of the rule.\n\nSymbols such as `'{'`, `'.'`, and so on, have to be enclosed in single quotes\nwhen used as terminal or non-terminal symbols in grammar rules. The use of the\nsymbols `'$empty'`, `'$end'`, and `'$undefined'` should be avoided.\n\nThe last part of the grammar file is an optional section with Erlang code (=\nfunction definitions) which is included 'as is' in the resulting parser file.\nThis section must start with the pseudo declaration, or key words\n\n```text\nErlang code.\n```\n\nNo syntax rule definitions or other declarations must follow this section. To\navoid conflicts with internal variables, do not use variable names beginning\nwith two underscore characters (`'__'`) in the Erlang code in this section, or\nin the code associated with the individual syntax rules.\n\nThe optional `expect` declaration can be placed anywhere before the last\noptional section with Erlang code. It is used for suppressing the warning about\nconflicts that is ordinarily given if the grammar is ambiguous. An example:\n\n```text\nExpect 2.\n```\n\nThe warning is given if the number of shift/reduce conflicts differs from 2, or\nif there are reduce/reduce conflicts.","ref":"yecc.html#module-grammar-definition-format"},{"type":"module","title":"Examples - yecc","doc":"A grammar to parse list expressions (with empty associated code):\n\n```text\nNonterminals list elements element.\nTerminals atom '(' ')'.\nRootsymbol list.\nlist -> '(' ')'.\nlist -> '(' elements ')'.\nelements -> element.\nelements -> element elements.\nelement -> atom.\nelement -> list.\n```\n\nThis grammar can be used to generate a parser which parses list expressions,\nsuch as `(), (a), (peter charles), (a (b c) d (())), ...` provided that your\nscanner tokenizes, for example, the input `(peter charles)` as follows:\n\n```erlang\n[{'(', 1} , {atom, 1, peter}, {atom, 1, charles}, {')', 1},\n {'$end', 1}]\n```\n\nWhen a grammar rule is used by the parser to parse (part of) the input string as\na grammatical phrase, the associated code is evaluated, and the value of the\nlast expression becomes the value of the parsed phrase. This value may be used\nby the parser later to build structures that are values of higher phrases of\nwhich the current phrase is a part. The values initially associated with\nterminal category phrases, i.e. input tokens, are the token tuples themselves.\n\nBelow is an example of the grammar above with structure building code added:\n\n```text\nlist -> '(' ')' : nil.\nlist -> '(' elements ')' : '$2'.\nelements -> element : {cons, '$1', nil}.\nelements -> element elements : {cons, '$1', '$2'}.\nelement -> atom : '$1'.\nelement -> list : '$1'.\n```\n\nWith this code added to the grammar rules, the parser produces the following\nvalue (structure) when parsing the input string `(a b c).`. This still assumes\nthat this was the first input line that the scanner tokenized:\n\n```erlang\n{cons, {atom, 1, a}, {cons, {atom, 1, b},\n                            {cons, {atom, 1, c}, nil}}}\n```\n\nThe associated code contains `pseudo variables` `'$1'`, `'$2'`,\n`'$3'`, and so on.  which refer to (are bound to) the values\nassociated previously by the parser with the symbols of the right-hand\nside of the rule. When these symbols are terminal categories, the\nvalues are token tuples of the input string (see above).\n\nThe associated code may not only be used to build structures\nassociated with phrases, but may also be used for syntactic and\nsemantic tests, printout actions (for example for tracing), and so on\nduring the parsing process. Since tokens contain positional (line\nnumber) information, it is possible to produce error messages which\ncontain line numbers. If there is no associated code after the\nright-hand side of the rule, the value `'$undefined'` is associated\nwith the phrase.\n\nThe right-hand side of a grammar rule can be empty. This is indicated by using\nthe special symbol `'$empty'` as rhs. Then the list grammar above can be\nsimplified to:\n\n```text\nlist -> '(' elements ')' : '$2'.\nelements -> element elements : {cons, '$1', '$2'}.\nelements -> '$empty' : nil.\nelement -> atom : '$1'.\nelement -> list : '$1'.\n```","ref":"yecc.html#module-examples"},{"type":"module","title":"Generating a Parser - yecc","doc":"To call the parser generator, use the following command:\n\n```erlang\nyecc:file(Grammarfile).\n```\n\nAn error message from Yecc will be shown if the grammar is not of the LALR type\n(for example too ambiguous). Shift/reduce conflicts are resolved in favor of\nshifting if there are no operator precedence declarations. Refer to the `yacc`\ndocumentation on the use of operator precedence.\n\nThe output file contains Erlang source code for a parser module with module name\nequal to the `Parserfile` parameter. After compilation, the parser can be called\nas follows (the module name is assumed to be `myparser`):\n\n```erlang\nmyparser:parse(myscanner:scan(Inport))\n```\n\nThe call format can be different if a customized prologue file has been included\nwhen generating the parser instead of the default file\n`lib/parsetools/include/yeccpre.hrl`.\n\nWith the standard prologue, this call will return either `{ok, Result}`, where\n`Result` is a structure that the Erlang code of the grammar file has built, or\n`{error, {Position, Module, Message}}` if there was a syntax error in the input.\n\n`Message` is something which may be converted into a string by calling\n`Module:format_error(Message)` and printed with `io:format/3`.\n\n> #### Note {: .info }\n>\n> By default, the parser that was generated will not print out error messages to\n> the screen. The user will have to do this either by printing the returned\n> error messages, or by inserting tests and print instructions in the Erlang\n> code associated with the syntax rules of the grammar file.\n\nIt is also possible to make the parser ask for more input tokens when needed if\nthe following call format is used:\n\n```erlang\nmyparser:parse_and_scan({Function, Args})\nmyparser:parse_and_scan({Mod, Tokenizer, Args})\n```\n\nThe tokenizer `Function` is either a fun or a tuple `{Mod, Tokenizer}`. The call\n[`apply(Function, Args)`](`apply/2`) or\n[`apply({Mod, Tokenizer}, Args)`](`apply/2`) is executed whenever a new token is\nneeded. This, for example, makes it possible to parse from a file, token by\ntoken.\n\nThe tokenizer used above has to be implemented so as to return one of the\nfollowing:\n\n```erlang\n{ok, Tokens, EndPosition}\n{eof, EndPosition}\n{error, Error_description, EndPosition}\n```\n\nThis conforms to the format used by the scanner in the Erlang `io` library\nmodule.\n\nIf `{eof, EndPosition}` is returned immediately, the call to `parse_and_scan/1`\nreturns `{ok, eof}`. If `{eof, EndPosition}` is returned before the parser\nexpects end of input, `parse_and_scan/1` will, of course, return an error\nmessage (see above). Otherwise `{ok, Result}` is returned.","ref":"yecc.html#module-generating-a-parser"},{"type":"module","title":"More Examples - yecc","doc":"1\\. A grammar for parsing infix arithmetic expressions into prefix notation,\nwithout operator precedence:\n\n```text\nNonterminals E T F.\nTerminals '+' '*' '(' ')' number.\nRootsymbol E.\nE -> E '+' T: {'$2', '$1', '$3'}.\nE -> T : '$1'.\nT -> T '*' F: {'$2', '$1', '$3'}.\nT -> F : '$1'.\nF -> '(' E ')' : '$2'.\nF -> number : '$1'.\n```\n\n2\\. The same with operator precedence becomes simpler:\n\n```text\nNonterminals E.\nTerminals '+' '*' '(' ')' number.\nRootsymbol E.\nLeft 100 '+'.\nLeft 200 '*'.\nE -> E '+' E : {'$2', '$1', '$3'}.\nE -> E '*' E : {'$2', '$1', '$3'}.\nE -> '(' E ')' : '$2'.\nE -> number : '$1'.\n```\n\n3\\. An overloaded minus operator:\n\n```text\nNonterminals E uminus.\nTerminals '*' '-' number.\nRootsymbol E.\n\nLeft 100 '-'.\nLeft 200 '*'.\nUnary 300 uminus.\n\nE -> E '-' E.\nE -> E '*' E.\nE -> uminus.\nE -> number.\n\numinus -> '-' E.\n```\n\n4\\. The Yecc grammar that is used for parsing grammar files, including itself:\n\n```erlang\nNonterminals\ngrammar declaration rule head symbol symbols attached_code\ntoken tokens.\nTerminals\natom float integer reserved_symbol reserved_word string char var\n'->' ':' dot.\nRootsymbol grammar.\nEndsymbol '$end'.\ngrammar -> declaration : '$1'.\ngrammar -> rule : '$1'.\ndeclaration -> symbol symbols dot: {'$1', '$2'}.\nrule -> head '->' symbols attached_code dot: {rule, ['$1' | '$3'],\n        '$4'}.\nhead -> symbol : '$1'.\nsymbols -> symbol : ['$1'].\nsymbols -> symbol symbols : ['$1' | '$2'].\nattached_code -> ':' tokens : {erlang_code, '$2'}.\nattached_code -> '$empty' : {erlang_code,\n                 [{atom, 0, '$undefined'}]}.\ntokens -> token : ['$1'].\ntokens -> token tokens : ['$1' | '$2'].\nsymbol -> var : value_of('$1').\nsymbol -> atom : value_of('$1').\nsymbol -> integer : value_of('$1').\nsymbol -> reserved_word : value_of('$1').\ntoken -> var : '$1'.\ntoken -> atom : '$1'.\ntoken -> float : '$1'.\ntoken -> integer : '$1'.\ntoken -> string : '$1'.\ntoken -> char : '$1'.\ntoken -> reserved_symbol : {value_of('$1'), line_of('$1')}.\ntoken -> reserved_word : {value_of('$1'), line_of('$1')}.\ntoken -> '->' : {'->', line_of('$1')}.\ntoken -> ':' : {':', line_of('$1')}.\nErlang code.\nvalue_of(Token) ->\n    element(3, Token).\nline_of(Token) ->\n    element(2, Token).\n```\n\n> #### Note {: .info }\n>\n> The symbols `'->'`, and `':'` have to be treated in a special way, as they are\n> meta symbols of the grammar notation, as well as terminal symbols of the Yecc\n> grammar.\n\n5\\. The file `erl_parse.yrl` in the `lib/stdlib/src` directory contains the\ngrammar for Erlang.\n\n> #### Note {: .info }\n>\n> Syntactic tests are used in the code associated with some rules, and an error\n> is thrown (and caught by the generated parser to produce an error message)\n> when a test fails. The same effect can be achieved with a call to\n> `return_error(ErrorPosition, Message_string)`, which is defined in the\n> `yeccpre.hrl` default header file.","ref":"yecc.html#module-more-examples"},{"type":"module","title":"Files - yecc","doc":"```text\nlib/parsetools/include/yeccpre.hrl\n```","ref":"yecc.html#module-files"},{"type":"module","title":"See Also - yecc","doc":"* Aho & Johnson: 'LR Parsing', ACM Computing Surveys, vol. 6:2, 1974.\n\n* Kernighan & Pike: The UNIX programming environment, 1984.","ref":"yecc.html#module-see-also"},{"type":"function","title":"yecc.file/1","doc":"","ref":"yecc.html#file/1"},{"type":"function","title":"yecc.file/2","doc":"Generates an Erlang file with the parser for the language described by `GrammarFile`.\n\n`Grammarfile` is the file of declarations and grammar rules. Returns `ok` upon\nsuccess, or `error` if there are errors. An Erlang file containing the parser is\ncreated if there are no errors.\n\nThe options are:\n\n- **`{includefile, Includefile}`.** - Indicates a customized prologue file which\n  the user may want to use instead of the default file\n  `lib/parsetools/include/yeccpre.hrl` which is otherwise included at the\n  beginning of the resulting parser file. Note taht `Includefile` is included\n  as is in the parser file, so it must not have a module declaration of its\n  own, and it should not be compiled. It must, however, contain the necessary\n  export declarations. The default is indicated by `\"\"`.\n\n- **`{parserfile, Parserfile}`.** - `Parserfile` is the name of the file that\n  will contain the Erlang parser code that is generated. The default (`\"\"`) is\n  to add the extension `.erl` to `Grammarfile` stripped of the `.yrl` extension.\n\n- **`{report_errors, boolean()}`.** - Causes errors to be printed as they occur.\n  Default is `true`.\n\n- **`{report_warnings, boolean()}`.** - Causes warnings to be printed as they\n  occur. Default is `true`.\n\n- **`{report, boolean()}`.** - This is a short form for both `report_errors` and\n  `report_warnings`.\n\n- **`{return_errors, boolean()}`.** - If this flag is set,\n  `{error, Errors, Warnings}` is returned when there are errors. Default is\n  `false`.\n\n- **`{return_warnings, boolean()}`.** - If this flag is set, an extra field\n  containing `Warnings` is added to the tuple returned upon success. Default is\n  `false`.\n\n- **`{return, boolean()}`.** - This is a short form for both `return_errors` and\n  `return_warnings`.\n\n- **`{verbose, boolean()}`.** - Determines whether the parser generator should\n  give full information about resolved and unresolved parse action conflicts\n  (`true`), or only about those conflicts that prevent a parser from being\n  generated from the input grammar (`false`, the default).\n\n- **`{warnings_as_errors, boolean()}`** - Causes warnings to be treated as\n  errors.\n\n- **`{error_location, column | line}`.** - If the value of this flag is `line`,\n  the location of warnings and errors is a line number. If the value is\n  `column`, the location includes a line number and a column number. Default is\n  `column`.\n\n- **`{deterministic, boolean()}`** - Causes generated `-file()` attributes to only\n  include the basename of the file path.\n\nAny of the Boolean options can be set to `true` by stating the name of the\noption. For example, `verbose` is equivalent to `{verbose, true}`.\n\nThe value of the `Parserfile` option stripped of the `.erl` extension is used by\nYecc as the module name of the generated parser file.\n\nYecc will add the extension `.yrl` to the `Grammarfile` name, the extension\n`.hrl` to the `Includefile` name, and the extension `.erl` to the `Parserfile`\nname, unless the extension is already there.","ref":"yecc.html#file/2"},{"type":"function","title":"yecc.format_error/1","doc":"Returns a descriptive string in English of an error reason `ErrorDescriptor`\nreturned by `yecc:file/1,2`.\n\nThis function is mainly used by the compiler invoking Yecc.","ref":"yecc.html#format_error/1"},{"type":"type","title":"yecc.error_info/0","doc":"The standard `t:error_info/0` structure that is returned from all I/O modules.\n\n`ErrorDescriptor` is formattable by `format_error/1`.","ref":"yecc.html#t:error_info/0"},{"type":"type","title":"yecc.error_ret/0","doc":"","ref":"yecc.html#t:error_ret/0"},{"type":"type","title":"yecc.errors/0","doc":"","ref":"yecc.html#t:errors/0"},{"type":"type","title":"yecc.ok_ret/0","doc":"","ref":"yecc.html#t:ok_ret/0"},{"type":"type","title":"yecc.option/0","doc":"","ref":"yecc.html#t:option/0"},{"type":"type","title":"yecc.warnings/0","doc":"","ref":"yecc.html#t:warnings/0"},{"type":"type","title":"yecc.yecc_ret/0","doc":"","ref":"yecc.html#t:yecc_ret/0"},{"type":"extras","title":"Parsetools Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Parsetools Release Notes\n\nThis document describes the changes made to the Parsetools application.","ref":"notes.html"},{"type":"extras","title":"Parsetools 2.6 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-6"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- The `leex` documentation has been updated to use specs for documenting the generated interface.\n\n  Own Id: OTP-18796 Aux Id: [PR-7703]\n\n- yecc now wraps the `-module` attribute with `-file` to indicate the `.yrl` source file.\n\n  Own Id: OTP-18912 Aux Id: [PR-7963]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-7703]: https://github.com/erlang/otp/pull/7703\n[PR-7963]: https://github.com/erlang/otp/pull/7963\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.5 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-5"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Leex has been extended with optional column number support.\n\n  Own Id: OTP-18491 Aux Id: PR-6882","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.4.1 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-4-1"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- There is a new configure option, `--enable-deterministic-build`, which will\n  apply the `deterministic` compiler option when building Erlang/OTP. The\n  `deterministic` option has been improved to eliminate more sources of\n  non-determinism in several applications.\n\n  Own Id: OTP-18165 Aux Id: PR-5965","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.4 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-4"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- In the generated code, `yecc` will now quote all atoms coming from terminals\n  in the grammar, in order to avoid conflicts with future reserved words.\n\n  Own Id: OTP-17755","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.3.2 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- The default parser include file for yecc (`yeccpre`) will no longer crash when\n  attempting to print tokens when reporting an error.\n\n  Own Id: OTP-17721","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.3.1 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Fix a bug in Leex which caused the Erlang Compiler to generate warnings.\n\n  Own Id: OTP-17499 Aux Id: GH-4918\n\n- Fix a bug in Yecc which caused the Erlang Compiler to generate warnings.\n\n  Own Id: OTP-17535 Aux Id: GH-5067","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.3 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-3"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Add types and specifications for documentation.\n\n  Own Id: OTP-16957\n\n- Let Leex and Yecc recognize the environment variable ERL_COMPILER_OPTIONS. Add\n  Yecc option `{error_location, column | line}`.\n\n  Own Id: OTP-17023","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.2 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-2"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Remove usage and documentation of old requests of the I/O-protocol.\n\n  Own Id: OTP-15695","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.1.8 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-1-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.1.7 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-1-7"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Calls to `erlang:get_stacktrace()` are removed.\n\n  Own Id: OTP-14861","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.1.6 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Warnings about unused functions in `leexinc.hrl` are suppressed.\n\n  Own Id: OTP-14697","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.1.5 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Minor documentation fixes\n\n  Own Id: OTP-14276 Aux Id: PR-1357","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Miscellaneous updates due to atoms containing arbitrary Unicode characters.\n\n  Own Id: OTP-14285","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.1.4 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Correct counting of newlines when rules with newlines are used in Leex.\n\n  Own Id: OTP-13916 Aux Id: ERL-263\n\n- Correct handling of Unicode in Leex.\n\n  Own Id: OTP-13919","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.1.3 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Yecc generates Dialyzer suppressions to avoid warnings when operator\n  precedence declarations are used.\n\n  Own Id: OTP-13681","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.1.2 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-1-2"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Internal changes\n\n  Own Id: OTP-13551","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.1.1 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Correct the documentation of the error tuple returned by Yecc and Leex.\n\n  Own Id: OTP-13031","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.1 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-1"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- The new `-dialyzer()` attribute is used for suppressing Dialyzer warnings in\n  generated code.\n\n  Own Id: OTP-12271","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.0.12 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- The line counter becomes invalid when rules with linewrap are used. This issue\n  appears because the parsing FSM does not roll back the line counter after\n  attempting such a rule.\n\n  Own Id: OTP-12238","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.0.11 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744\n\n- A Yecc example has been updated in the documentation (Thanks to Pierre\n  Fenoll.)\n\n  Own Id: OTP-11749","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.0.10 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- A bug causing Yecc to generate badly formed parsers when encountering very\n  simple recursive rules has been fixed. (Thanks to Eric Pailleau.)\n\n  Own Id: OTP-11269\n\n- A bug where Unicode filenames combined with Latin-1 encoding could crash Yecc\n  and Leex has been fixed.\n\n  Own Id: OTP-11286","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Fix leex module\\`s inability to build unicode-aware lexers. Thanks to Pierre\n  Fenoll.\n\n  Own Id: OTP-11313","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.0.9 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-9"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Miscellaneous updates due to Unicode support.\n\n  Own Id: OTP-10820","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.0.8 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-8"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Support for Unicode has been implemented.\n\n  Own Id: OTP-10302\n\n- The file `esyntax.yrl` has been removed.\n\n  Own Id: OTP-10660","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.0.7 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-7"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Tuple funs (a two-element tuple with a module name and a function) are now\n  officially deprecated and will be removed in R16. Use '`fun M:F/A`' instead.\n  To make you aware that your system uses tuple funs, the very first time a\n  tuple fun is applied, a warning will be sent to the error logger.\n\n  Own Id: OTP-9649","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.0.6 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Dialyzer warnings have been removed.\n\n  Own Id: OTP-8318\n\n- yecc: add warnings_as_errors option(Thanks to Tuncer ayaz)\n\n  Own Id: OTP-9376\n\n- Fix incorrect order of pseudo variables in yecc example\n\n  The example is for converting from infix to prefix. This change uses to\n  correct ordering of the triplet. (Thanks to Garret Smith)\n\n  Own Id: OTP-9484\n\n- Implement or fix -Werror option\n\n  If -Werror is enabled and there are warnings no output file is written. Also\n  make sure that error/warning reporting is consistent. (Thanks to Tuncer Ayaz)\n\n  Own Id: OTP-9536\n\n- XML files have been corrected.\n\n  Own Id: OTP-9550 Aux Id: OTP-9541","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.0.5 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-5"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- The formatting of Yecc's error messages has been improved. (Thanks to Joe\n  Armstrong.)\n\n  Own Id: OTP-8919","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.0.4 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Running HiPE-compiled Yecc parsers no longer results in a `function_clause`\n  error.\n\n  Own Id: OTP-8771","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.0.3 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- Yecc failed to report reduce/reduce conflicts where one of the reductions\n  involved the root symbol. This bug has been fixed. (Thanks to Manolis\n  Papadakis.)\n\n  Own Id: OTP-8483\n\n- A bug introduced in Parsetools 1.4.4 (R12B-2) has been fixed. (Thanks to\n  Manolis Papadakis.)\n\n  Own Id: OTP-8486","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.0.2 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-2"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Cleanups suggested by tidier and modernization of types and specs.\n\n  Own Id: OTP-8455","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 2.0.1 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0-1"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Leex no longer uses the deprecated `regexp` module. (Thanks to Robert\n  Virding.).\n\n  Own Id: OTP-8231","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- A minor bug in `m:leex` has been fixed.\n\n  Own Id: OTP-8197","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 2.0 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-2-0"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Leex, a lexical analyzer generator for Erlang, has been added to Parsetools.\n  This initial version should be considered experimental; it is known that there\n  will be changes and additions. (Thanks to Robert Virding.).\n\n  Own Id: OTP-8013","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- The parsers generated by Yecc now report correct error lines when possible.\n\n  Own Id: OTP-7969","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 1.4.7 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-4-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- A bug in yeccpre.hrl introduced in R13A has been fixed.\n\n  Own Id: OTP-7945","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 1.4.6 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-4-6"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Updated file headers.\n\n  Own Id: OTP-7798","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 1.4.5 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-4-5"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- The `yecc` grammar has been augmented with an optional header section. (Thanks\n  to Richard Carlsson.)\n\n  Own Id: OTP-7292","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 1.4.4 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-4-4"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- The size of the code generated by Yecc has been reduced. The code is also\n  faster.\n\n  Macros can now be used in actions.\n\n  Own Id: OTP-7224","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 1.4.3 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-4-3"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- [`tuple_size/1`](`tuple_size/1`) and [`byte_size/1`](`byte_size/1`) have been\n  substituted for [`size/1`](`size/1`).\n\n  Own Id: OTP-7009","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 1.4.2 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-4-2"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- The size of the code generated by yecc has been reduced.\n\n  A note regarding the `includefile` option: although yecc can cope with\n  includefiles based on some earlier `yeccpre.hrl` it is recommended for\n  efficiency reasons to update includefiles as to follow the pattern in the\n  latest `yeccpre.hrl`.\n\n  Own Id: OTP-6851","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 1.4.1.1 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-4-1-1"},{"type":"extras","title":"Improvements and New Features - Parsetools Release Notes","doc":"- Minor Makefile changes.\n\n  Own Id: OTP-6689","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Parsetools 1.4.1 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- A bug concerning precedence declarations of non-terminals \"one level up\" has\n  been fixed in yecc.\n\n  Own Id: OTP-6362","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 1.4 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-4"},{"type":"extras","title":"Improvements and Fixed Bugs - Parsetools Release Notes","doc":"Several modifications of Yecc have been made:\n\n- The new functions `file/1,2` take the role of the old functions `yecc/2,3,4`.\n  The latter functions are no longer documented but are kept for backward\n  compatibility.\n- More checks of the grammar file have been implemented. Examples are warnings\n  for unused non-terminals and duplicated declarations.\n- Invalid pseudo variables are no longer replaced by `'$undefined'` but cause a\n  failure.\n- Reserved words no longer need to be quoted when used as terminals or\n  non-terminals.\n- When compiling the generated parser file errors and warnings concerning user\n  code refer to the grammar file, not the parser file.\n- Yecc emits a warning if there are conflicts in the grammar. The new\n  declaration `Expect` can be used to suppress this warning.\n- The new operator precedence declaration `Nonassoc` can be used to declare\n  operators with no associativity.\n- Precedence can be given to more than one operator with one single operator\n  precedence declaration.\n- The function `parse_and_scan/1` in the default includefile accepts\n  `{Function, A}` as well as \\{\\{M,F\\}, A\\} as tokenizer function. Exceptions in\n  the tokenizer are never caught.\n- The functions `yecc:file/1,2` can be accessed from the Erlang shell via the\n  new functions `c:y/1,2` in STDLIB.\n\nSee yecc(3) for further details.\n\nOwn Id: OTP-5366","ref":"notes.html#improvements-and-fixed-bugs"},{"type":"extras","title":"Parsetools 1.3.2 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- A bug in `Yecc` that was introduced in R9B has been removed. Another bug\n  concerning precedence declaration \"one level up\" has been fixed.\n\n  Own Id: OTP-5461","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Parsetools 1.3.1 - Parsetools Release Notes","doc":"","ref":"notes.html#parsetools-1-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Parsetools Release Notes","doc":"- A bug in the file `parsetools/include/yeccpre.hrl` caused\n  `yecc:parse_and_scan/1` to always report a parse failure when the lexer\n  reported end-of-file. This problem has been fixed.\n\n  Own Id: OTP-5369","ref":"notes.html#fixed-bugs-and-malfunctions"}],"content_type":"text/plain","producer":{"name":"ex_doc","version":[48,46,51,52,46,49]}}