/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.Strictness;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.WorkspaceConfigEventManager;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.engine.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.engine.AIEngineSettingsSerDe;
import org.jkiss.dbeaver.model.ai.registry.AIEngineConfigurationSerDeDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AISettingsEventListener;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionPersistent;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.PropertySerializationUtils;
import org.jkiss.utils.CommonUtils;

public class AISettingsRegistry {
    private static final Log log = Log.getLog(AISettingsRegistry.class);
    private static final String AI_DISABLED_KEY = "aiDisabled";
    private static final String ACTIVE_ENGINE_KEY = "activeEngine";
    private static final String ENGINE_CONFIGURATIONS_KEY = "engineConfigurations";
    public static final String AI_CONFIGURATION_JSON = "ai-configuration.json";
    private static AISettingsRegistry instance = null;
    private static final Gson readPropsGson = new GsonBuilder().setStrictness(Strictness.LENIENT).registerTypeAdapter(AISettings.class, (Object)new AIConfigurationSerDe()).create();
    private static final Gson savePropsGson = AISettingsRegistry.savePropsGson();
    private final Set<AISettingsEventListener> settingsChangedListeners = Collections.synchronizedSet(new HashSet());

    private AISettingsRegistry() {
        WorkspaceConfigEventManager.addConfigChangedListener((String)AI_CONFIGURATION_JSON, o -> {
            this.getSettingsHolder().reset();
            this.raiseChangedEvent(this);
        });
    }

    public static synchronized AISettingsRegistry getInstance() {
        if (instance == null) {
            instance = new AISettingsRegistry();
        }
        return instance;
    }

    public void addChangedListener(AISettingsEventListener listener) {
        this.settingsChangedListeners.add(listener);
    }

    public void removeChangedListener(AISettingsEventListener listener) {
        this.settingsChangedListeners.remove(listener);
    }

    private void raiseChangedEvent(AISettingsRegistry registry) {
        AISettingsEventListener[] aISettingsEventListenerArray = (AISettingsEventListener[])this.settingsChangedListeners.toArray(AISettingsEventListener[]::new);
        int n = aISettingsEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            AISettingsEventListener listener = aISettingsEventListenerArray[n2];
            listener.onSettingsUpdate(registry);
            ++n2;
        }
    }

    private AISettingsHolder getSettingsHolder() {
        SMSession sMSession = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
        if (sMSession instanceof SMSessionPersistent) {
            SMSessionPersistent session = (SMSessionPersistent)sMSession;
            return AISettingsSessionHolder.getForSession(session);
        }
        return AISettingsLocalHolder.INSTANCE;
    }

    @NotNull
    public AISettings getSettings() {
        return this.getSettingsHolder().getSettings();
    }

    @NotNull
    private static AISettings loadSettingsFromConfig() {
        AISettings settings;
        try {
            String content = AISettingsRegistry.loadConfig();
            settings = CommonUtils.isEmpty((String)content) ? AISettingsRegistry.prepareDefaultSettings() : (AISettings)readPropsGson.fromJson((Reader)new StringReader(content), AISettings.class);
        }
        catch (Exception e) {
            log.error((Object)"Error loading AI settings, falling back to defaults.", (Throwable)e);
            settings = AISettingsRegistry.prepareDefaultSettings();
        }
        if (settings.activeEngine() == null) {
            settings.setActiveEngine("openai");
        }
        return settings;
    }

    private static AISettings prepareDefaultSettings() {
        AISettings settings = new AISettings();
        if (DBWorkbench.getPlatform().getPreferenceStore().getString("ai.completion.disabled") != null) {
            settings.setAiDisabled(DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.disabled"));
        } else {
            settings.setAiDisabled(false);
        }
        Map<String, AIEngineSettings<?>> stringMap = AISettingsRegistry.getSerDes().stream().collect(Collectors.toMap(AIEngineSettingsSerDe::getId, serDe -> serDe.deserialize(null, readPropsGson)));
        settings.setEngineConfigurations(stringMap);
        return settings;
    }

    public void saveSettings(AISettings settings) {
        try {
            if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
                log.warn((Object)"The user has no permission to save AI configuration");
                return;
            }
            if (!AISettingsRegistry.saveSecretsAsPlainText()) {
                settings.saveSecrets();
            }
            String content = savePropsGson.toJson((Object)settings);
            DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(AI_CONFIGURATION_JSON, content);
            this.getSettingsHolder().setSettings(settings);
        }
        catch (Exception e) {
            log.error((Object)"Error saving AI configuration", (Throwable)e);
        }
        this.raiseChangedEvent(this);
    }

    private static String loadConfig() throws DBException {
        return DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(AI_CONFIGURATION_JSON);
    }

    public static boolean isConfigExists() throws DBException {
        String content = AISettingsRegistry.loadConfig();
        return CommonUtils.isNotEmpty((String)content);
    }

    private static List<AIEngineSettingsSerDe<?>> getSerDes() {
        ArrayList result = new ArrayList();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.dbeaver.ai.engine.settingsSerDe");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            AIEngineConfigurationSerDeDescriptor descriptor = new AIEngineConfigurationSerDeDescriptor(iConfigurationElement);
            try {
                result.add(descriptor.createInstance());
            }
            catch (DBException e) {
                throw new IllegalStateException(e);
            }
            ++n2;
        }
        return result;
    }

    public static boolean saveSecretsAsPlainText() {
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        return application.isMultiuser() || application.isDistributed();
    }

    private static Gson savePropsGson() {
        if (AISettingsRegistry.saveSecretsAsPlainText()) {
            return new GsonBuilder().setStrictness(Strictness.LENIENT).registerTypeAdapter(AISettings.class, (Object)new AIConfigurationSerDe()).create();
        }
        return PropertySerializationUtils.baseNonSecurePropertiesGsonBuilder().registerTypeAdapter(AISettings.class, (Object)new AIConfigurationSerDe()).create();
    }

    static /* synthetic */ Gson access$0() {
        return readPropsGson;
    }

    private static class AIConfigurationSerDe
    implements JsonSerializer<AISettings>,
    JsonDeserializer<AISettings> {
        private final List<AIEngineSettingsSerDe<?>> engineSerDe = AISettingsRegistry.getSerDes();

        private AIConfigurationSerDe() {
        }

        public AISettings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json == null || !json.isJsonObject()) {
                return AISettingsRegistry.prepareDefaultSettings();
            }
            JsonObject root = json.getAsJsonObject();
            AISettings aiSettings = new AISettings();
            JsonElement aiDisabledEl = root.get(AISettingsRegistry.AI_DISABLED_KEY);
            aiSettings.setAiDisabled(aiDisabledEl != null && aiDisabledEl.isJsonPrimitive() && aiDisabledEl.getAsJsonPrimitive().isBoolean() && aiDisabledEl.getAsBoolean());
            JsonElement activeEngineEl = root.get(AISettingsRegistry.ACTIVE_ENGINE_KEY);
            aiSettings.setActiveEngine(activeEngineEl != null && !activeEngineEl.isJsonNull() ? activeEngineEl.getAsString() : null);
            JsonObject ecRoot = root.has(AISettingsRegistry.ENGINE_CONFIGURATIONS_KEY) && root.get(AISettingsRegistry.ENGINE_CONFIGURATIONS_KEY).isJsonObject() ? root.getAsJsonObject(AISettingsRegistry.ENGINE_CONFIGURATIONS_KEY) : new JsonObject();
            Map<String, AIEngineSettings<?>> engineConfigurationMap = this.engineSerDe.stream().collect(Collectors.toMap(AIEngineSettingsSerDe::getId, serDe -> serDe.deserialize(ecRoot.getAsJsonObject(serDe.getId()), readPropsGson)));
            aiSettings.setEngineConfigurations(engineConfigurationMap);
            return aiSettings;
        }

        public JsonElement serialize(AISettings src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty(AISettingsRegistry.AI_DISABLED_KEY, Boolean.valueOf(src.isAiDisabled()));
            json.addProperty(AISettingsRegistry.ACTIVE_ENGINE_KEY, src.activeEngine());
            JsonObject engineConfigurations = new JsonObject();
            for (AIEngineSettingsSerDe<?> serDe : this.engineSerDe) {
                try {
                    engineConfigurations.add(serDe.getId(), (JsonElement)serDe.serialize((AIEngineSettings<?>)src.getEngineConfiguration(serDe.getId()), AISettingsRegistry.savePropsGson()));
                }
                catch (DBException e) {
                    throw new JsonParseException("Error serializing AI engine settings: " + serDe.getId(), (Throwable)e);
                }
            }
            json.add(AISettingsRegistry.ENGINE_CONFIGURATIONS_KEY, (JsonElement)engineConfigurations);
            return json;
        }
    }

    private static interface AISettingsHolder {
        public AISettings getSettings();

        public void setSettings(AISettings var1);

        public void reset();
    }

    private static class AISettingsLocalHolder
    implements AISettingsHolder {
        public static final AISettingsHolder INSTANCE = new AISettingsLocalHolder();
        private AISettings settings = null;

        private AISettingsLocalHolder() {
        }

        @Override
        public synchronized AISettings getSettings() {
            AISettings settings = this.settings;
            if (settings == null) {
                this.settings = settings = AISettingsRegistry.loadSettingsFromConfig();
            }
            return settings;
        }

        @Override
        public synchronized void setSettings(AISettings mruSettings) {
            this.settings = mruSettings;
        }

        @Override
        public synchronized void reset() {
            this.settings = null;
        }
    }

    private static class AISettingsSessionHolder
    implements AISettingsHolder {
        private static final Map<SMSessionPersistent, AISettingsSessionHolder> holderBySession = Collections.synchronizedMap(new WeakHashMap());
        private final SMSessionPersistent session;
        private volatile AISettings mruSettings = null;
        private volatile boolean settingsReadInProgress = false;

        private AISettingsSessionHolder(SMSessionPersistent session) {
            this.session = session;
        }

        public static AISettingsHolder getForSession(SMSessionPersistent session) {
            return holderBySession.computeIfAbsent(session, AISettingsSessionHolder::new);
        }

        public static void resetAll() {
            holderBySession.clear();
        }

        @Override
        public synchronized AISettings getSettings() {
            AISettings mruSettings = this.mruSettings;
            AISettings sharedSettings = (AISettings)this.session.getAttribute(AISettings.class.getName());
            if (mruSettings == null || !mruSettings.equals(sharedSettings)) {
                if (this.settingsReadInProgress) {
                    return new AISettings();
                }
                this.settingsReadInProgress = true;
                try {
                    mruSettings = AISettingsRegistry.loadSettingsFromConfig();
                    this.setSettings(mruSettings);
                }
                finally {
                    this.settingsReadInProgress = false;
                }
            }
            return mruSettings;
        }

        @Override
        public synchronized void setSettings(AISettings mruSettings) {
            this.mruSettings = mruSettings;
            this.session.setAttribute(AISettings.class.getName(), (Object)mruSettings);
        }

        @Override
        public synchronized void reset() {
            AISettingsSessionHolder.resetAll();
        }
    }
}

