# Next steps

## That's all, folks!

All good things must come to an end, and this guide is no different!

Congratulations---now you should be able to use DOSBox Staging fairly
confidently at a basic level, and we've actually touched on quite a few
intermediate topics as well. Armed with the basics, now you have a much
greater chance to figure things out on your own, and you'll be able  to ask
more specific, directed questions from the more experienced members of the
community when seeking help.

So what's next? Try setting up a few more games yourself; peruse the various
configuration options in the primary configuration file; look around on [our
wiki](https://github.com/dosbox-staging/dosbox-staging/wiki); familiarise
yourself with our [feature highlights](https://www.dosbox-staging.org/);
read the release notes on our [releases
page](https://www.dosbox-staging.org/releases/windows/)---there are plenty
of learning opportunities if you wish to delve deeper!

If you're stuck with something, you can always ask questions from the DOSBox
Staging community directly on [Discord](https://discord.gg/WwAg3Xf).

Most importantly, experiment, enjoy what classic PC gaming has to offer,
and have fun! :sunglasses:


## Further reading

As your interest in DOS gaming grows, you might be interested in learning more
about the history of PC gaming and PC hardware in general. Below is a
selection of the very best learning resources to get you started!


[RetroGrade - The ultimate guide to pre-millennial PC hardware](https://archive.org/details/RetroGrade-TheUltimateGuideToPreMillennialPCHardware)

: An excellent collection of articles that takes you through the most
important milestones of early PC hardware history, starting from its humble
beginnings in the early 1980s right until the year 2000, covering the DOS era
in its entirety and then some more.


[DOS Days](http://www.dosdays.co.uk/)

: This very comprehensive website contains a great deal of information about
DOS-era PC hardware, useful tips on setting up DOS games, and articles and
guides on a variety of DOS-related topics. It's a highly recommended resource,
and you'll inevitably end up here anyway when researching anything DOS-related
via your favourite search engine...


[Nerdly Pleasures](https://nerdlypleasures.blogspot.com/)

: Written by The Great Hierophant, there's simply no better resource online
that does such extremely thorough and comprehensive deep dives supplanted by
original research on a number of interesting DOS gaming related topics.

[PhilsComputerLab](https://www.youtube.com/channel/UCj9IJ2QvygoBJKSOnUgXIRA)

: Phil's YouTube channel offers a dizzying amount of quality content on a
variety of retro-PC related topics with a special focus on actual hardware.
Checking out his [DOS tutorials](https://www.youtube.com/playlist?list=PL5T8bmLxd_T35FG1re1k7Butn7Ncnuv6Q)
and [MIDI and wavetable](https://www.youtube.com/playlist?list=PL5T8bmLxd_T1F2g3aoYCu2brKtGTlbyY_)
series is a good start, but you can pretty much pick any of his videos
at random and I guarantee you'll learn something interesting. His aptly titled
*three-and-a-half-hour long (!)*
[Roland MT-32, CM-32L, CM-64, CM-500 Ultimate Tutorial](https://www.youtube.com/watch?v=OLvsaJ4h-VY&list=PL5T8bmLxd_T1F2g3aoYCu2brKtGTlbyY_&index=6)
is a work of art---probably there isn't anything more to say on the subject!


[DOSBox game compatibility list](https://www.dosbox.com/comp_list.php?letter=a)

: If you're having problems with a game, it's worth having a look at the game
compatibility list on the old DOSBox website. Although some information there
might be outdated (e.g., mentioning DOSBox issues that have long been fixed),
some of the comments document important issues present in the original games.
That's one very common trap to fall into, thinking that certain game bugs are
caused by emulation and therefore must be fixable at the DOSBox level. Often
they're bugs present in the original games, so you just need to live with them
or work around them.


[VOGONS](https://www.vogons.org/)

: An acronym for **Very Old Games On New Systems**, this forum is an oasis for
all retro-hardware and retro-gaming enthusiasts, mainly focusing on PC
compatibles and DOSBox-related things. The combined knowledge of the community
on all things DOS and retro-PC is next to none---try asking any obscure
question, and there's a good chance you'll get a very detailed (and correct!)
answer within a few hours.

