SYD-LOCK(1)

# NAME

syd-lock - Run a command under Landlock

# SYNOPSIS

*syd-lock* _[-hvAV]_ _[-l category[,category...]{+|-}path|port[-port]]..._ _[-r path]..._ _[-w path]..._ _[-b port[-port]]..._ _[-c port[-port]]..._ _{command [args...]}_

# DESCRIPTION

The *syd-lock* utility runs a command under Landlock. It executes a
command confined by specified Landlock sandbox categories. Categories
and their associated resources (paths or ports) are defined using the
_-l_ option. Each _-l_ option requires at least one category, followed
directly by either "+" (to explicitly grant) or "-" (to explicitly deny)
and a resource (path or port range). Multiple categories can be
combined, separated by commas, to apply permissions collectively to the
specified resource. The _-l_ option itself can be repeated. Use _-V_
option to check for Landlock support. The specific support level may be
determined by the exit code.  Use _-A_ option to check for Landlock ABI
version.

Supported sandbox categories are _read_, _write_, _exec_, _ioctl_,
_create_, _delete_, _rename_, _symlink_, _truncate_, _readdir_, _mkdir_,
_rmdir_, _mkdev_, _mkfifo_, _bind_, _connect_, and _all_. Categories
other than _bind_ and _connect_ must specify file or directory paths.
Categories _bind_ and _connect_ must specify network ports or closed
port ranges; the bind category also supports absolute UNIX domain socket
paths. For full details and specific behavior of each sandbox category,
refer to the "Sandboxing" and "Lock Sandboxing" sections of the _syd_(7)
manual page.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-v*
:< Be verbose. Print Landlock status to standard error before running the specified command.
|[ *-A*
:< Print ABI version on standard output and exit with ABI version as exit code, rather than running a command. Use for scripting.
|[ *-V*
:< Check if Landlock is supported and print ABI version, rather than running a command.
|[ *-l* _cat[,cat...]{+|-}path|port[-port]_
:< Specify sandbox categories and grant or deny them on the associated path, port or closed port range, may be repeated.
|[ *-r* _path_
:< Specify a read-only path, may be repeated. Equivalent to _-l read,readdir,exec,ioctl+path_.
|[ *-w* _path_
:< Specify a read-write path, may be repeated. Equivalent to _-l all+path_.
|[ *-b* _port[-port]_
:< Specify a port for _bind_(2), may be repeated. Equivalent to _-l bind+port_.
|[ *-c* _port[-port]_
:< Specify a port for _connect_(2), may be repeated.  Equivalent to _-l connect+port_.

# EXIT CODES

When running a command, *syd-lock* exits with the same exit code as the
command.

When running in check mode with _-A_, syd exits with ABI version as exit
code.

When running in check mode with _-V_, syd may exit with the following
exit codes:

|[ *0*
:< Fully enforced
|[ *1*
:< Partially enforced
|[ *2*
:< Not enforced
|[ *127*
:< Not supported

# ABI

Landlock ABI versioning makes it possible to adjust the security policy
according to the kernel capabilities.

# HISTORY

. First Landlock ABI, introduced with Linux 5.13: https://git.kernel.org/stable/c/17ae69aba89dbfa2139b7f8024b757ab3cc42f59
. Second Landlock ABI, introduced with Linux 5.19: https://git.kernel.org/stable/c/cb44e4f061e16be65b8a16505e121490c66d30d0
. Third Landlock ABI, introduced with Linux 6.2: https://git.kernel.org/stable/c/299e2b1967578b1442128ba8b3e86ed3427d3651
. Fourth Landlock ABI, introduced with Linux 6.7: https://git.kernel.org/stable/c/136cc1e1f5be75f57f1e0404b94ee1c8792cb07d
. Fifth Landlock ABI, introduced with Linux 6.10: https://git.kernel.org/stable/c/2fc0e7892c10734c1b7c613ef04836d57d4676d5
. Sixth Landlock ABI, introduced with Linux 6.12.

# SECURITY

Block device creation with the Landlock access right
"LANDLOCK_ACCESS_FS_MAKE_BLOCK" is never allowed.

Scoped signals and UNIX abstract sockets which were
introduced with Landlock ABI version 6 with Linux-6.12
are always enabled.

Consider prepending _syd-lock_(1) invocations with _syd-mdwe_(1) to get
W^X memory protections. See _syd-mdwe_(1) manual page for more
information.

# EXAMPLE

```
$ syd-lock wget -O/dev/null chesswob.org
$ syd-lock -l read,exec+/ wget -O/dev/null chesswob.org
/dev/null: Permission denied
$ syd-lock -l read,exec+/ -l write+/dev/null wget -O/dev/null chesswob.org
Prepended http:// to 'chesswob.org'
--2025-04-30 16:24:35--  http://chesswob.org/
Resolving chesswob.org (chesswob.org)... 95.216.39.164, fe80::468a:5bff:fe88:2141
Connecting to chesswob.org (chesswob.org)|95.216.39.164|:80... failed: Permission denied.
Connecting to chesswob.org (chesswob.org)|fe80::468a:5bff:fe88:2141|:80... failed: Permission denied.
Retrying.

^C
$ syd-lock -l read,exec+/ -l write+/dev/null -l connect+80 -l connect+443 wget -O/dev/null chesswob.org
Prepended http:// to 'chesswob.org'
--2025-04-30 16:25:59--  http://chesswob.org/
Resolving chesswob.org (chesswob.org)... 95.216.39.164, fe80::468a:5bff:fe88:2141
Connecting to chesswob.org (chesswob.org)|95.216.39.164|:80... connected.
HTTP request sent, awaiting response... 302 Moved Temporarily
Location: https://www.chesswob.org/ [following]
--2025-04-30 16:25:59--  https://www.chesswob.org/
Loaded CA certificate '/etc/ssl/certs/ca-certificates.crt'
Resolving www.chesswob.org (www.chesswob.org)... 95.216.39.164, fe80::468a:5bff:fe88:2141
Connecting to www.chesswob.org (www.chesswob.org)|95.216.39.164|:443... connected.
HTTP request sent, awaiting response... 200 OK
Length: 148827 (145K) [text/html]
Saving to: ‘/dev/null’

/dev/null                         100%[=============================================================>] 145.34K  --.-KB/s    in 0.01s

2025-04-30 16:25:59 (11.9 MB/s) - ‘/dev/null’ saved [148827/148827]
$
```

# SEE ALSO

_landlock_(7), _syd_(1), _syd_(2), _syd_(5), _syd_(7), _syd-mdwe_(1), _syd-pds_(1)

*syd* homepage: https://sydbox.exherbolinux.org/

*Landlock* homepage: https://landlock.io/

*Landlock* documentation: https://docs.kernel.org/userspace-api/landlock.html

*Landlock* admin guide: https://docs.kernel.org/admin-guide/LSM/landlock.html

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
