SYD-FORK(1)

# NAME

syd-fork - Fork fast in an infinite loop.

# SYNOPSIS

*syd-fork* _[-h]_

# DESCRIPTION

If no arguments are provided, the program will quickly create an
infinite number of child processes through forking. This is implemented
using inline assembly on x86, x86_64, arm, and aarch64 architectures,
making it significantly faster and more efficient than the bash fork
bomb.

When the *-h* flag is passed, a warning message will be displayed
advising that this program is intended for stress-testing the pid
limiter and should not be used for any other purpose. It is not intended
to be used as a joke and should be used with caution. Use of the program
is at the user's own risk. To stress-test the pid limiter, run the
program with no arguments. The program will quickly create an infinite
number of child processes through forking and it will quickly reach the
maximum number of processes that the system can handle.

# OPTIONS

|[ *-h*
:< Display help.

# EXAMPLES

To run syd-fork on April 1st at 8:00 AM UTC, you can use the _at_(1) command. This
is useful for scheduling the program to execute at a specific time for testing
or demonstration purposes. Ensure that the _at(1)_ daemon is running on your system
and that you have permission to schedule jobs with _at_(1).

```
$ echo "syd-fork" | at 08:00 April 1
```

# NOTES

Distribution maintainers are recommended to _ln_(1) "syd-fork" to "syd-fuck"
under an NSFW option to help treat anger issues.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _at_(1), _fork_(2), _ln_(1)

*syd* homepage: https://sydbox.exherbolinux.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
