// Code generated by sdkgen. DO NOT EDIT.

// nolint
package smartwebsecurity

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	smartwebsecurity "github.com/yandex-cloud/go-genproto/yandex/cloud/smartwebsecurity/v1"
)

//revive:disable

// SecurityProfileServiceClient is a smartwebsecurity.SecurityProfileServiceClient with
// lazy GRPC connection initialization.
type SecurityProfileServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements smartwebsecurity.SecurityProfileServiceClient
func (c *SecurityProfileServiceClient) Create(ctx context.Context, in *smartwebsecurity.CreateSecurityProfileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return smartwebsecurity.NewSecurityProfileServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements smartwebsecurity.SecurityProfileServiceClient
func (c *SecurityProfileServiceClient) Delete(ctx context.Context, in *smartwebsecurity.DeleteSecurityProfileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return smartwebsecurity.NewSecurityProfileServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements smartwebsecurity.SecurityProfileServiceClient
func (c *SecurityProfileServiceClient) Get(ctx context.Context, in *smartwebsecurity.GetSecurityProfileRequest, opts ...grpc.CallOption) (*smartwebsecurity.SecurityProfile, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return smartwebsecurity.NewSecurityProfileServiceClient(conn).Get(ctx, in, opts...)
}

// List implements smartwebsecurity.SecurityProfileServiceClient
func (c *SecurityProfileServiceClient) List(ctx context.Context, in *smartwebsecurity.ListSecurityProfilesRequest, opts ...grpc.CallOption) (*smartwebsecurity.ListSecurityProfilesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return smartwebsecurity.NewSecurityProfileServiceClient(conn).List(ctx, in, opts...)
}

type SecurityProfileIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *SecurityProfileServiceClient
	request *smartwebsecurity.ListSecurityProfilesRequest

	items []*smartwebsecurity.SecurityProfile
}

func (c *SecurityProfileServiceClient) SecurityProfileIterator(ctx context.Context, req *smartwebsecurity.ListSecurityProfilesRequest, opts ...grpc.CallOption) *SecurityProfileIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &SecurityProfileIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *SecurityProfileIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.SecurityProfiles
	return len(it.items) > 0
}

func (it *SecurityProfileIterator) Take(size int64) ([]*smartwebsecurity.SecurityProfile, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*smartwebsecurity.SecurityProfile

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *SecurityProfileIterator) TakeAll() ([]*smartwebsecurity.SecurityProfile, error) {
	return it.Take(0)
}

func (it *SecurityProfileIterator) Value() *smartwebsecurity.SecurityProfile {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *SecurityProfileIterator) Error() error {
	return it.err
}

// Update implements smartwebsecurity.SecurityProfileServiceClient
func (c *SecurityProfileServiceClient) Update(ctx context.Context, in *smartwebsecurity.UpdateSecurityProfileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return smartwebsecurity.NewSecurityProfileServiceClient(conn).Update(ctx, in, opts...)
}
