// Code generated by sdkgen. DO NOT EDIT.

// nolint
package licensemanager

import (
	"context"

	"google.golang.org/grpc"

	licensemanager "github.com/yandex-cloud/go-genproto/yandex/cloud/marketplace/licensemanager/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// LockServiceClient is a licensemanager.LockServiceClient with
// lazy GRPC connection initialization.
type LockServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements licensemanager.LockServiceClient
func (c *LockServiceClient) Create(ctx context.Context, in *licensemanager.CreateLockRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return licensemanager.NewLockServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements licensemanager.LockServiceClient
func (c *LockServiceClient) Delete(ctx context.Context, in *licensemanager.DeleteLockRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return licensemanager.NewLockServiceClient(conn).Delete(ctx, in, opts...)
}

// Ensure implements licensemanager.LockServiceClient
func (c *LockServiceClient) Ensure(ctx context.Context, in *licensemanager.EnsureLockRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return licensemanager.NewLockServiceClient(conn).Ensure(ctx, in, opts...)
}

// Get implements licensemanager.LockServiceClient
func (c *LockServiceClient) Get(ctx context.Context, in *licensemanager.GetLockRequest, opts ...grpc.CallOption) (*licensemanager.Lock, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return licensemanager.NewLockServiceClient(conn).Get(ctx, in, opts...)
}

// GetByInstanceAndResource implements licensemanager.LockServiceClient
func (c *LockServiceClient) GetByInstanceAndResource(ctx context.Context, in *licensemanager.GetLockByInstanceAndResourceRequest, opts ...grpc.CallOption) (*licensemanager.Lock, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return licensemanager.NewLockServiceClient(conn).GetByInstanceAndResource(ctx, in, opts...)
}

// List implements licensemanager.LockServiceClient
func (c *LockServiceClient) List(ctx context.Context, in *licensemanager.ListLocksRequest, opts ...grpc.CallOption) (*licensemanager.ListLocksResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return licensemanager.NewLockServiceClient(conn).List(ctx, in, opts...)
}

type LockIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *LockServiceClient
	request *licensemanager.ListLocksRequest

	items []*licensemanager.Lock
}

func (c *LockServiceClient) LockIterator(ctx context.Context, req *licensemanager.ListLocksRequest, opts ...grpc.CallOption) *LockIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &LockIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *LockIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Locks
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *LockIterator) Take(size int64) ([]*licensemanager.Lock, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*licensemanager.Lock

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *LockIterator) TakeAll() ([]*licensemanager.Lock, error) {
	return it.Take(0)
}

func (it *LockIterator) Value() *licensemanager.Lock {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *LockIterator) Error() error {
	return it.err
}
