// Code generated by sdkgen. DO NOT EDIT.

// nolint
package marketplace

import (
	"context"

	"google.golang.org/grpc"

	marketplace "github.com/yandex-cloud/go-genproto/yandex/cloud/k8s/marketplace/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// HelmReleaseServiceClient is a marketplace.HelmReleaseServiceClient with
// lazy GRPC connection initialization.
type HelmReleaseServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements marketplace.HelmReleaseServiceClient
func (c *HelmReleaseServiceClient) Get(ctx context.Context, in *marketplace.GetHelmReleaseRequest, opts ...grpc.CallOption) (*marketplace.HelmRelease, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return marketplace.NewHelmReleaseServiceClient(conn).Get(ctx, in, opts...)
}

// Install implements marketplace.HelmReleaseServiceClient
func (c *HelmReleaseServiceClient) Install(ctx context.Context, in *marketplace.InstallHelmReleaseRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return marketplace.NewHelmReleaseServiceClient(conn).Install(ctx, in, opts...)
}

// List implements marketplace.HelmReleaseServiceClient
func (c *HelmReleaseServiceClient) List(ctx context.Context, in *marketplace.ListHelmReleasesRequest, opts ...grpc.CallOption) (*marketplace.ListHelmReleasesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return marketplace.NewHelmReleaseServiceClient(conn).List(ctx, in, opts...)
}

type HelmReleaseIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *HelmReleaseServiceClient
	request *marketplace.ListHelmReleasesRequest

	items []*marketplace.HelmRelease
}

func (c *HelmReleaseServiceClient) HelmReleaseIterator(ctx context.Context, req *marketplace.ListHelmReleasesRequest, opts ...grpc.CallOption) *HelmReleaseIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &HelmReleaseIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *HelmReleaseIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.HelmReleases
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *HelmReleaseIterator) Take(size int64) ([]*marketplace.HelmRelease, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*marketplace.HelmRelease

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *HelmReleaseIterator) TakeAll() ([]*marketplace.HelmRelease, error) {
	return it.Take(0)
}

func (it *HelmReleaseIterator) Value() *marketplace.HelmRelease {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *HelmReleaseIterator) Error() error {
	return it.err
}

// Uninstall implements marketplace.HelmReleaseServiceClient
func (c *HelmReleaseServiceClient) Uninstall(ctx context.Context, in *marketplace.UninstallHelmReleaseRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return marketplace.NewHelmReleaseServiceClient(conn).Uninstall(ctx, in, opts...)
}

// Update implements marketplace.HelmReleaseServiceClient
func (c *HelmReleaseServiceClient) Update(ctx context.Context, in *marketplace.UpdateHelmReleaseRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return marketplace.NewHelmReleaseServiceClient(conn).Update(ctx, in, opts...)
}
