// Code generated by sdkgen. DO NOT EDIT.

// nolint
package asymmetricencryption

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	asymmetricencryption "github.com/yandex-cloud/go-genproto/yandex/cloud/kms/v1/asymmetricencryption"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// AsymmetricEncryptionKeyServiceClient is a asymmetricencryption.AsymmetricEncryptionKeyServiceClient with
// lazy GRPC connection initialization.
type AsymmetricEncryptionKeyServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements asymmetricencryption.AsymmetricEncryptionKeyServiceClient
func (c *AsymmetricEncryptionKeyServiceClient) Create(ctx context.Context, in *asymmetricencryption.CreateAsymmetricEncryptionKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return asymmetricencryption.NewAsymmetricEncryptionKeyServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements asymmetricencryption.AsymmetricEncryptionKeyServiceClient
func (c *AsymmetricEncryptionKeyServiceClient) Delete(ctx context.Context, in *asymmetricencryption.DeleteAsymmetricEncryptionKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return asymmetricencryption.NewAsymmetricEncryptionKeyServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements asymmetricencryption.AsymmetricEncryptionKeyServiceClient
func (c *AsymmetricEncryptionKeyServiceClient) Get(ctx context.Context, in *asymmetricencryption.GetAsymmetricEncryptionKeyRequest, opts ...grpc.CallOption) (*asymmetricencryption.AsymmetricEncryptionKey, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return asymmetricencryption.NewAsymmetricEncryptionKeyServiceClient(conn).Get(ctx, in, opts...)
}

// List implements asymmetricencryption.AsymmetricEncryptionKeyServiceClient
func (c *AsymmetricEncryptionKeyServiceClient) List(ctx context.Context, in *asymmetricencryption.ListAsymmetricEncryptionKeysRequest, opts ...grpc.CallOption) (*asymmetricencryption.ListAsymmetricEncryptionKeysResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return asymmetricencryption.NewAsymmetricEncryptionKeyServiceClient(conn).List(ctx, in, opts...)
}

type AsymmetricEncryptionKeyIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *AsymmetricEncryptionKeyServiceClient
	request *asymmetricencryption.ListAsymmetricEncryptionKeysRequest

	items []*asymmetricencryption.AsymmetricEncryptionKey
}

func (c *AsymmetricEncryptionKeyServiceClient) AsymmetricEncryptionKeyIterator(ctx context.Context, req *asymmetricencryption.ListAsymmetricEncryptionKeysRequest, opts ...grpc.CallOption) *AsymmetricEncryptionKeyIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &AsymmetricEncryptionKeyIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *AsymmetricEncryptionKeyIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Keys
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *AsymmetricEncryptionKeyIterator) Take(size int64) ([]*asymmetricencryption.AsymmetricEncryptionKey, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*asymmetricencryption.AsymmetricEncryptionKey

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *AsymmetricEncryptionKeyIterator) TakeAll() ([]*asymmetricencryption.AsymmetricEncryptionKey, error) {
	return it.Take(0)
}

func (it *AsymmetricEncryptionKeyIterator) Value() *asymmetricencryption.AsymmetricEncryptionKey {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *AsymmetricEncryptionKeyIterator) Error() error {
	return it.err
}

// ListAccessBindings implements asymmetricencryption.AsymmetricEncryptionKeyServiceClient
func (c *AsymmetricEncryptionKeyServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return asymmetricencryption.NewAsymmetricEncryptionKeyServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type AsymmetricEncryptionKeyAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *AsymmetricEncryptionKeyServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *AsymmetricEncryptionKeyServiceClient) AsymmetricEncryptionKeyAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *AsymmetricEncryptionKeyAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &AsymmetricEncryptionKeyAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *AsymmetricEncryptionKeyAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *AsymmetricEncryptionKeyAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *AsymmetricEncryptionKeyAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *AsymmetricEncryptionKeyAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *AsymmetricEncryptionKeyAccessBindingsIterator) Error() error {
	return it.err
}

// ListOperations implements asymmetricencryption.AsymmetricEncryptionKeyServiceClient
func (c *AsymmetricEncryptionKeyServiceClient) ListOperations(ctx context.Context, in *asymmetricencryption.ListAsymmetricEncryptionKeyOperationsRequest, opts ...grpc.CallOption) (*asymmetricencryption.ListAsymmetricEncryptionKeyOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return asymmetricencryption.NewAsymmetricEncryptionKeyServiceClient(conn).ListOperations(ctx, in, opts...)
}

type AsymmetricEncryptionKeyOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *AsymmetricEncryptionKeyServiceClient
	request *asymmetricencryption.ListAsymmetricEncryptionKeyOperationsRequest

	items []*operation.Operation
}

func (c *AsymmetricEncryptionKeyServiceClient) AsymmetricEncryptionKeyOperationsIterator(ctx context.Context, req *asymmetricencryption.ListAsymmetricEncryptionKeyOperationsRequest, opts ...grpc.CallOption) *AsymmetricEncryptionKeyOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &AsymmetricEncryptionKeyOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *AsymmetricEncryptionKeyOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *AsymmetricEncryptionKeyOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *AsymmetricEncryptionKeyOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *AsymmetricEncryptionKeyOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *AsymmetricEncryptionKeyOperationsIterator) Error() error {
	return it.err
}

// SetAccessBindings implements asymmetricencryption.AsymmetricEncryptionKeyServiceClient
func (c *AsymmetricEncryptionKeyServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return asymmetricencryption.NewAsymmetricEncryptionKeyServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// Update implements asymmetricencryption.AsymmetricEncryptionKeyServiceClient
func (c *AsymmetricEncryptionKeyServiceClient) Update(ctx context.Context, in *asymmetricencryption.UpdateAsymmetricEncryptionKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return asymmetricencryption.NewAsymmetricEncryptionKeyServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements asymmetricencryption.AsymmetricEncryptionKeyServiceClient
func (c *AsymmetricEncryptionKeyServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return asymmetricencryption.NewAsymmetricEncryptionKeyServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}
