// Code generated by sdkgen. DO NOT EDIT.

// nolint
package workload

import (
	"context"

	"google.golang.org/grpc"

	workload "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1/workload"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// FederatedCredentialServiceClient is a workload.FederatedCredentialServiceClient with
// lazy GRPC connection initialization.
type FederatedCredentialServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements workload.FederatedCredentialServiceClient
func (c *FederatedCredentialServiceClient) Create(ctx context.Context, in *workload.CreateFederatedCredentialRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return workload.NewFederatedCredentialServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements workload.FederatedCredentialServiceClient
func (c *FederatedCredentialServiceClient) Delete(ctx context.Context, in *workload.DeleteFederatedCredentialRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return workload.NewFederatedCredentialServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements workload.FederatedCredentialServiceClient
func (c *FederatedCredentialServiceClient) Get(ctx context.Context, in *workload.GetFederatedCredentialRequest, opts ...grpc.CallOption) (*workload.FederatedCredential, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return workload.NewFederatedCredentialServiceClient(conn).Get(ctx, in, opts...)
}

// List implements workload.FederatedCredentialServiceClient
func (c *FederatedCredentialServiceClient) List(ctx context.Context, in *workload.ListFederatedCredentialsRequest, opts ...grpc.CallOption) (*workload.ListFederatedCredentialsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return workload.NewFederatedCredentialServiceClient(conn).List(ctx, in, opts...)
}

type FederatedCredentialIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *FederatedCredentialServiceClient
	request *workload.ListFederatedCredentialsRequest

	items []*workload.FederatedCredential
}

func (c *FederatedCredentialServiceClient) FederatedCredentialIterator(ctx context.Context, req *workload.ListFederatedCredentialsRequest, opts ...grpc.CallOption) *FederatedCredentialIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &FederatedCredentialIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *FederatedCredentialIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.FederatedCredentials
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *FederatedCredentialIterator) Take(size int64) ([]*workload.FederatedCredential, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*workload.FederatedCredential

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *FederatedCredentialIterator) TakeAll() ([]*workload.FederatedCredential, error) {
	return it.Take(0)
}

func (it *FederatedCredentialIterator) Value() *workload.FederatedCredential {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *FederatedCredentialIterator) Error() error {
	return it.err
}
