// Code generated by sdkgen. DO NOT EDIT.

// nolint
package eventrouter

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	eventrouter "github.com/yandex-cloud/go-genproto/yandex/cloud/serverless/eventrouter/v1"
)

//revive:disable

// RuleServiceClient is a eventrouter.RuleServiceClient with
// lazy GRPC connection initialization.
type RuleServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) Create(ctx context.Context, in *eventrouter.CreateRuleRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) Delete(ctx context.Context, in *eventrouter.DeleteRuleRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).Delete(ctx, in, opts...)
}

// Disable implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) Disable(ctx context.Context, in *eventrouter.DisableRuleRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).Disable(ctx, in, opts...)
}

// Enable implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) Enable(ctx context.Context, in *eventrouter.EnableRuleRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).Enable(ctx, in, opts...)
}

// Get implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) Get(ctx context.Context, in *eventrouter.GetRuleRequest, opts ...grpc.CallOption) (*eventrouter.Rule, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).Get(ctx, in, opts...)
}

// List implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) List(ctx context.Context, in *eventrouter.ListRulesRequest, opts ...grpc.CallOption) (*eventrouter.ListRulesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).List(ctx, in, opts...)
}

type RuleIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RuleServiceClient
	request *eventrouter.ListRulesRequest

	items []*eventrouter.Rule
}

func (c *RuleServiceClient) RuleIterator(ctx context.Context, req *eventrouter.ListRulesRequest, opts ...grpc.CallOption) *RuleIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RuleIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RuleIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Rules
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RuleIterator) Take(size int64) ([]*eventrouter.Rule, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*eventrouter.Rule

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RuleIterator) TakeAll() ([]*eventrouter.Rule, error) {
	return it.Take(0)
}

func (it *RuleIterator) Value() *eventrouter.Rule {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RuleIterator) Error() error {
	return it.err
}

// ListAccessBindings implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type RuleAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RuleServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *RuleServiceClient) RuleAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *RuleAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RuleAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RuleAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RuleAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RuleAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *RuleAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RuleAccessBindingsIterator) Error() error {
	return it.err
}

// ListOperations implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) ListOperations(ctx context.Context, in *eventrouter.ListRuleOperationsRequest, opts ...grpc.CallOption) (*eventrouter.ListRuleOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).ListOperations(ctx, in, opts...)
}

type RuleOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RuleServiceClient
	request *eventrouter.ListRuleOperationsRequest

	items []*operation.Operation
}

func (c *RuleServiceClient) RuleOperationsIterator(ctx context.Context, req *eventrouter.ListRuleOperationsRequest, opts ...grpc.CallOption) *RuleOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RuleOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RuleOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RuleOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RuleOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *RuleOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RuleOperationsIterator) Error() error {
	return it.err
}

// SetAccessBindings implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// Update implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) Update(ctx context.Context, in *eventrouter.UpdateRuleRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements eventrouter.RuleServiceClient
func (c *RuleServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewRuleServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}
