// Code generated by sdkgen. DO NOT EDIT.

// nolint
package compute

import (
	"context"

	"google.golang.org/grpc"

	compute "github.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1"
)

//revive:disable

// HostTypeServiceClient is a compute.HostTypeServiceClient with
// lazy GRPC connection initialization.
type HostTypeServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements compute.HostTypeServiceClient
func (c *HostTypeServiceClient) Get(ctx context.Context, in *compute.GetHostTypeRequest, opts ...grpc.CallOption) (*compute.HostType, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewHostTypeServiceClient(conn).Get(ctx, in, opts...)
}

// List implements compute.HostTypeServiceClient
func (c *HostTypeServiceClient) List(ctx context.Context, in *compute.ListHostTypesRequest, opts ...grpc.CallOption) (*compute.ListHostTypesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewHostTypeServiceClient(conn).List(ctx, in, opts...)
}

type HostTypeIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *HostTypeServiceClient
	request *compute.ListHostTypesRequest

	items []*compute.HostType
}

func (c *HostTypeServiceClient) HostTypeIterator(ctx context.Context, req *compute.ListHostTypesRequest, opts ...grpc.CallOption) *HostTypeIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &HostTypeIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *HostTypeIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.HostTypes
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *HostTypeIterator) Take(size int64) ([]*compute.HostType, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*compute.HostType

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *HostTypeIterator) TakeAll() ([]*compute.HostType, error) {
	return it.Take(0)
}

func (it *HostTypeIterator) Value() *compute.HostType {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *HostTypeIterator) Error() error {
	return it.err
}
