// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.21.12
// source: yandex/cloud/storage/v1/bucket.proto

package storage

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Versioning int32

const (
	Versioning_VERSIONING_UNSPECIFIED Versioning = 0
	// The bucket is unversioned, i.e. versioning has never been enabled for the bucket, including at its creation.
	// Objects that are stored in the bucket have a version ID of `null`.
	//
	// To enable versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request. Note that this
	// action is irreversible, and a bucket with versioning enabled can never return to `VERSIONING_DISABLED` state.
	Versioning_VERSIONING_DISABLED Versioning = 1
	// Bucket versioning is enabled, i.e. all new objects are versioned and given a unique version ID, and objects that
	// already existed at the time versioning was enabled will be versioned and given a unique version ID when modified
	// by future requests.
	//
	// To suspend versioning, change status to `VERSIONING_SUSPENDED` via a [BucketService.Update] request. You cannot
	// disable versioning altogether for a bucket that already had it enabled; objects that had version IDs will keep
	// them.
	Versioning_VERSIONING_ENABLED Versioning = 2
	// Bucket versioning is suspended, i.e. new objects are not versioned, but objects that already existed at the time
	// versioning was suspended are still versioned and keep their version IDs.
	//
	// To resume versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request.
	Versioning_VERSIONING_SUSPENDED Versioning = 3
)

// Enum value maps for Versioning.
var (
	Versioning_name = map[int32]string{
		0: "VERSIONING_UNSPECIFIED",
		1: "VERSIONING_DISABLED",
		2: "VERSIONING_ENABLED",
		3: "VERSIONING_SUSPENDED",
	}
	Versioning_value = map[string]int32{
		"VERSIONING_UNSPECIFIED": 0,
		"VERSIONING_DISABLED":    1,
		"VERSIONING_ENABLED":     2,
		"VERSIONING_SUSPENDED":   3,
	}
)

func (x Versioning) Enum() *Versioning {
	p := new(Versioning)
	*p = x
	return p
}

func (x Versioning) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Versioning) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[0].Descriptor()
}

func (Versioning) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[0]
}

func (x Versioning) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Versioning.Descriptor instead.
func (Versioning) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{0}
}

type ACL_Grant_Permission int32

const (
	ACL_Grant_PERMISSION_UNSPECIFIED ACL_Grant_Permission = 0
	// Allows grantee the `PERMISSION_WRITE`, `PERMISSION_WRITE_ACP`, `PERMISSION_READ`, and `PERMISSION_READ_ACP`
	// on the bucket.
	//
	// Maps to `x-amz-grant-full-control` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
	// Amazon S3-compatible HTTP API.
	ACL_Grant_PERMISSION_FULL_CONTROL ACL_Grant_Permission = 1
	// Allows grantee to create new objects in the bucket. For the bucket and object owners of existing objects, also
	// allows deletions and overwrites of those objects.
	//
	// Maps to `x-amz-grant-write` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
	// S3-compatible HTTP API.
	ACL_Grant_PERMISSION_WRITE ACL_Grant_Permission = 2
	// Allows grantee to write the ACL for the bucket.
	//
	// Maps to `x-amz-grant-write-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
	// Amazon S3-compatible HTTP API.
	ACL_Grant_PERMISSION_WRITE_ACP ACL_Grant_Permission = 3
	// Allows grantee to list the objects in the bucket.
	//
	// Maps to `x-amz-grant-read` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
	// S3-compatible HTTP API.
	ACL_Grant_PERMISSION_READ ACL_Grant_Permission = 4
	// Allows grantee to read the bucket ACL
	//
	// Maps to `x-amz-grant-read-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
	// Amazon S3-compatible HTTP API.
	ACL_Grant_PERMISSION_READ_ACP ACL_Grant_Permission = 5
)

// Enum value maps for ACL_Grant_Permission.
var (
	ACL_Grant_Permission_name = map[int32]string{
		0: "PERMISSION_UNSPECIFIED",
		1: "PERMISSION_FULL_CONTROL",
		2: "PERMISSION_WRITE",
		3: "PERMISSION_WRITE_ACP",
		4: "PERMISSION_READ",
		5: "PERMISSION_READ_ACP",
	}
	ACL_Grant_Permission_value = map[string]int32{
		"PERMISSION_UNSPECIFIED":  0,
		"PERMISSION_FULL_CONTROL": 1,
		"PERMISSION_WRITE":        2,
		"PERMISSION_WRITE_ACP":    3,
		"PERMISSION_READ":         4,
		"PERMISSION_READ_ACP":     5,
	}
)

func (x ACL_Grant_Permission) Enum() *ACL_Grant_Permission {
	p := new(ACL_Grant_Permission)
	*p = x
	return p
}

func (x ACL_Grant_Permission) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ACL_Grant_Permission) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[1].Descriptor()
}

func (ACL_Grant_Permission) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[1]
}

func (x ACL_Grant_Permission) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ACL_Grant_Permission.Descriptor instead.
func (ACL_Grant_Permission) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{2, 0, 0}
}

type ACL_Grant_GrantType int32

const (
	ACL_Grant_GRANT_TYPE_UNSPECIFIED ACL_Grant_GrantType = 0
	// A grantee is an [account on the platform](/docs/iam/concepts/#accounts).
	//
	// For this grantee type, you need to specify the user ID in [Bucket.acl.grants.grantee_id] field. To get user ID, see
	// [instruction](/docs/iam/operations/users/get).
	//
	// Maps to using `id="*"` value for `x-amz-grant-*` header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput)
	// method of Amazon S3-compatible HTTP API).
	ACL_Grant_GRANT_TYPE_ACCOUNT ACL_Grant_GrantType = 1
	// Grantees are all authenticated users, both from your clouds and other users' clouds. Access
	// permission to this group allows any account on the platform to access the resource via a signed (authenticated)
	// request.
	//
	// Maps to using `uri="http://acs.amazonaws.com/groups/global/AuthenticatedUsers"` value for `x-amz-grant-*`
	// header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
	ACL_Grant_GRANT_TYPE_ALL_AUTHENTICATED_USERS ACL_Grant_GrantType = 2
	// Grantees are all internet users. Access permission to this group allows anyone in the world access to the
	// resource via signed (authenticated) or unsigned (anonymous) requests.
	//
	// Maps to using `uri="http://acs.amazonaws.com/groups/global/AllUsers"` value for `x-amz-grant-*` header
	// ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
	ACL_Grant_GRANT_TYPE_ALL_USERS ACL_Grant_GrantType = 3
)

// Enum value maps for ACL_Grant_GrantType.
var (
	ACL_Grant_GrantType_name = map[int32]string{
		0: "GRANT_TYPE_UNSPECIFIED",
		1: "GRANT_TYPE_ACCOUNT",
		2: "GRANT_TYPE_ALL_AUTHENTICATED_USERS",
		3: "GRANT_TYPE_ALL_USERS",
	}
	ACL_Grant_GrantType_value = map[string]int32{
		"GRANT_TYPE_UNSPECIFIED":             0,
		"GRANT_TYPE_ACCOUNT":                 1,
		"GRANT_TYPE_ALL_AUTHENTICATED_USERS": 2,
		"GRANT_TYPE_ALL_USERS":               3,
	}
)

func (x ACL_Grant_GrantType) Enum() *ACL_Grant_GrantType {
	p := new(ACL_Grant_GrantType)
	*p = x
	return p
}

func (x ACL_Grant_GrantType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ACL_Grant_GrantType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[2].Descriptor()
}

func (ACL_Grant_GrantType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[2]
}

func (x ACL_Grant_GrantType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ACL_Grant_GrantType.Descriptor instead.
func (ACL_Grant_GrantType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{2, 0, 1}
}

// List of HTTP methods that are allowed by the CORS rule.
//
// When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
// S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against the
// list of the allowed methods. If there is a match, all the allowed methods are listed in the
// `Access-Control-Allow-Methods` header of the response.
type CorsRule_Method int32

const (
	CorsRule_METHOD_UNSPECIFIED CorsRule_Method = 0
	// HTTP `GET` method.
	CorsRule_METHOD_GET CorsRule_Method = 1
	// HTTP `HEAD` method.
	CorsRule_METHOD_HEAD CorsRule_Method = 2
	// HTTP `POST` method.
	CorsRule_METHOD_POST CorsRule_Method = 3
	// HTTP `PUT` method.
	CorsRule_METHOD_PUT CorsRule_Method = 4
	// HTTP `DELETE` method.
	CorsRule_METHOD_DELETE CorsRule_Method = 5
)

// Enum value maps for CorsRule_Method.
var (
	CorsRule_Method_name = map[int32]string{
		0: "METHOD_UNSPECIFIED",
		1: "METHOD_GET",
		2: "METHOD_HEAD",
		3: "METHOD_POST",
		4: "METHOD_PUT",
		5: "METHOD_DELETE",
	}
	CorsRule_Method_value = map[string]int32{
		"METHOD_UNSPECIFIED": 0,
		"METHOD_GET":         1,
		"METHOD_HEAD":        2,
		"METHOD_POST":        3,
		"METHOD_PUT":         4,
		"METHOD_DELETE":      5,
	}
)

func (x CorsRule_Method) Enum() *CorsRule_Method {
	p := new(CorsRule_Method)
	*p = x
	return p
}

func (x CorsRule_Method) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CorsRule_Method) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[3].Descriptor()
}

func (CorsRule_Method) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[3]
}

func (x CorsRule_Method) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CorsRule_Method.Descriptor instead.
func (CorsRule_Method) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{4, 0}
}

type WebsiteSettings_Protocol int32

const (
	WebsiteSettings_PROTOCOL_UNSPECIFIED WebsiteSettings_Protocol = 0
	// `http` scheme.
	WebsiteSettings_PROTOCOL_HTTP WebsiteSettings_Protocol = 1
	// `https` scheme.
	WebsiteSettings_PROTOCOL_HTTPS WebsiteSettings_Protocol = 2
)

// Enum value maps for WebsiteSettings_Protocol.
var (
	WebsiteSettings_Protocol_name = map[int32]string{
		0: "PROTOCOL_UNSPECIFIED",
		1: "PROTOCOL_HTTP",
		2: "PROTOCOL_HTTPS",
	}
	WebsiteSettings_Protocol_value = map[string]int32{
		"PROTOCOL_UNSPECIFIED": 0,
		"PROTOCOL_HTTP":        1,
		"PROTOCOL_HTTPS":       2,
	}
)

func (x WebsiteSettings_Protocol) Enum() *WebsiteSettings_Protocol {
	p := new(WebsiteSettings_Protocol)
	*p = x
	return p
}

func (x WebsiteSettings_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WebsiteSettings_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[4].Descriptor()
}

func (WebsiteSettings_Protocol) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[4]
}

func (x WebsiteSettings_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WebsiteSettings_Protocol.Descriptor instead.
func (WebsiteSettings_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5, 0}
}

// A resource for type of TLS certificate source.
type HTTPSConfig_SourceType int32

const (
	HTTPSConfig_SOURCE_TYPE_UNSPECIFIED HTTPSConfig_SourceType = 0
	// Your certificate, uploaded directly.
	HTTPSConfig_SOURCE_TYPE_SELF_MANAGED HTTPSConfig_SourceType = 1
	// Certificate managed by Certificate Manager.
	HTTPSConfig_SOURCE_TYPE_MANAGED_BY_CERTIFICATE_MANAGER HTTPSConfig_SourceType = 2
)

// Enum value maps for HTTPSConfig_SourceType.
var (
	HTTPSConfig_SourceType_name = map[int32]string{
		0: "SOURCE_TYPE_UNSPECIFIED",
		1: "SOURCE_TYPE_SELF_MANAGED",
		2: "SOURCE_TYPE_MANAGED_BY_CERTIFICATE_MANAGER",
	}
	HTTPSConfig_SourceType_value = map[string]int32{
		"SOURCE_TYPE_UNSPECIFIED":                    0,
		"SOURCE_TYPE_SELF_MANAGED":                   1,
		"SOURCE_TYPE_MANAGED_BY_CERTIFICATE_MANAGER": 2,
	}
)

func (x HTTPSConfig_SourceType) Enum() *HTTPSConfig_SourceType {
	p := new(HTTPSConfig_SourceType)
	*p = x
	return p
}

func (x HTTPSConfig_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPSConfig_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[5].Descriptor()
}

func (HTTPSConfig_SourceType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[5]
}

func (x HTTPSConfig_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPSConfig_SourceType.Descriptor instead.
func (HTTPSConfig_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{12, 0}
}

// Activity status of the object lock settings on the bucket
type ObjectLock_ObjectLockStatus int32

const (
	ObjectLock_OBJECT_LOCK_STATUS_UNSPECIFIED ObjectLock_ObjectLockStatus = 0
	ObjectLock_OBJECT_LOCK_STATUS_DISABLED    ObjectLock_ObjectLockStatus = 1
	ObjectLock_OBJECT_LOCK_STATUS_ENABLED     ObjectLock_ObjectLockStatus = 2
)

// Enum value maps for ObjectLock_ObjectLockStatus.
var (
	ObjectLock_ObjectLockStatus_name = map[int32]string{
		0: "OBJECT_LOCK_STATUS_UNSPECIFIED",
		1: "OBJECT_LOCK_STATUS_DISABLED",
		2: "OBJECT_LOCK_STATUS_ENABLED",
	}
	ObjectLock_ObjectLockStatus_value = map[string]int32{
		"OBJECT_LOCK_STATUS_UNSPECIFIED": 0,
		"OBJECT_LOCK_STATUS_DISABLED":    1,
		"OBJECT_LOCK_STATUS_ENABLED":     2,
	}
)

func (x ObjectLock_ObjectLockStatus) Enum() *ObjectLock_ObjectLockStatus {
	p := new(ObjectLock_ObjectLockStatus)
	*p = x
	return p
}

func (x ObjectLock_ObjectLockStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ObjectLock_ObjectLockStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[6].Descriptor()
}

func (ObjectLock_ObjectLockStatus) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[6]
}

func (x ObjectLock_ObjectLockStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ObjectLock_ObjectLockStatus.Descriptor instead.
func (ObjectLock_ObjectLockStatus) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{13, 0}
}

// Lock type
type ObjectLock_DefaultRetention_Mode int32

const (
	ObjectLock_DefaultRetention_MODE_UNSPECIFIED ObjectLock_DefaultRetention_Mode = 0
	ObjectLock_DefaultRetention_MODE_GOVERNANCE  ObjectLock_DefaultRetention_Mode = 1
	ObjectLock_DefaultRetention_MODE_COMPLIANCE  ObjectLock_DefaultRetention_Mode = 2
)

// Enum value maps for ObjectLock_DefaultRetention_Mode.
var (
	ObjectLock_DefaultRetention_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "MODE_GOVERNANCE",
		2: "MODE_COMPLIANCE",
	}
	ObjectLock_DefaultRetention_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"MODE_GOVERNANCE":  1,
		"MODE_COMPLIANCE":  2,
	}
)

func (x ObjectLock_DefaultRetention_Mode) Enum() *ObjectLock_DefaultRetention_Mode {
	p := new(ObjectLock_DefaultRetention_Mode)
	*p = x
	return p
}

func (x ObjectLock_DefaultRetention_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ObjectLock_DefaultRetention_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[7].Descriptor()
}

func (ObjectLock_DefaultRetention_Mode) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[7]
}

func (x ObjectLock_DefaultRetention_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ObjectLock_DefaultRetention_Mode.Descriptor instead.
func (ObjectLock_DefaultRetention_Mode) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{13, 0, 0}
}

// A bucket resource.
// For details about the concept, see [documentation](/docs/storage/concepts/bucket).
type Bucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the bucket. Always equal to [name], which has priority.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the bucket.
	//
	// The name is unique within the platform. For naming limitations and rules, see
	// [documentation](/docs/storage/concepts/bucket#naming).
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the folder that the bucket belongs to.
	FolderId string `protobuf:"bytes,3,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Flags for configuring public (anonymous) access to the bucket's content and settings.
	// For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
	AnonymousAccessFlags *AnonymousAccessFlags `protobuf:"bytes,4,opt,name=anonymous_access_flags,json=anonymousAccessFlags,proto3" json:"anonymous_access_flags,omitempty"`
	// Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
	// (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	DefaultStorageClass string `protobuf:"bytes,5,opt,name=default_storage_class,json=defaultStorageClass,proto3" json:"default_storage_class,omitempty"`
	// Bucket versioning status.
	// For details, see [documentation](/docs/storage/concepts/versioning).
	Versioning Versioning `protobuf:"varint,6,opt,name=versioning,proto3,enum=yandex.cloud.storage.v1.Versioning" json:"versioning,omitempty"`
	// Maximum size of the bucket, in bytes.
	// For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
	MaxSize int64 `protobuf:"varint,7,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
	// For details, see [documentation](/docs/storage/concepts/policy).
	Policy *structpb.Struct `protobuf:"bytes,8,opt,name=policy,proto3" json:"policy,omitempty"`
	// Access control list (ACL) of the bucket.
	// For details, see [documentation](/docs/storage/concepts/acl).
	Acl *ACL `protobuf:"bytes,9,opt,name=acl,proto3" json:"acl,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
	// For details, see [documentation](/docs/storage/concepts/cors).
	Cors []*CorsRule `protobuf:"bytes,11,rep,name=cors,proto3" json:"cors,omitempty"`
	// Configuration for hosting a static website in the bucket.
	// For details, see [documentation](/docs/storage/concepts/hosting).
	WebsiteSettings *WebsiteSettings `protobuf:"bytes,12,opt,name=website_settings,json=websiteSettings,proto3" json:"website_settings,omitempty"`
	// List of object lifecycle rules for the bucket.
	// For details, see [documentation](/docs/storage/concepts/lifecycles).
	LifecycleRules []*LifecycleRule `protobuf:"bytes,13,rep,name=lifecycle_rules,json=lifecycleRules,proto3" json:"lifecycle_rules,omitempty"`
	// List of tags for the bucket.
	// For details, see [documentation](/docs/resource-manager/concepts/labels).
	Tags []*Tag `protobuf:"bytes,14,rep,name=tags,proto3" json:"tags,omitempty"`
	// Configuration for object lock on the bucket.
	// For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
	ObjectLock *ObjectLock `protobuf:"bytes,15,opt,name=object_lock,json=objectLock,proto3" json:"object_lock,omitempty"`
	// Configuration for bucket's encryption
	// For details, see [documentation](/docs/storage/concepts/encryption)
	Encryption *Encryption `protobuf:"bytes,16,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// Bucket allowed private endpoints.
	AllowedPrivateEndpoints *BucketAllowedPrivateEndpoints `protobuf:"bytes,17,opt,name=allowed_private_endpoints,json=allowedPrivateEndpoints,proto3" json:"allowed_private_endpoints,omitempty"`
}

func (x *Bucket) Reset() {
	*x = Bucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket) ProtoMessage() {}

func (x *Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket.ProtoReflect.Descriptor instead.
func (*Bucket) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{0}
}

func (x *Bucket) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Bucket) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Bucket) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Bucket) GetAnonymousAccessFlags() *AnonymousAccessFlags {
	if x != nil {
		return x.AnonymousAccessFlags
	}
	return nil
}

func (x *Bucket) GetDefaultStorageClass() string {
	if x != nil {
		return x.DefaultStorageClass
	}
	return ""
}

func (x *Bucket) GetVersioning() Versioning {
	if x != nil {
		return x.Versioning
	}
	return Versioning_VERSIONING_UNSPECIFIED
}

func (x *Bucket) GetMaxSize() int64 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

func (x *Bucket) GetPolicy() *structpb.Struct {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *Bucket) GetAcl() *ACL {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *Bucket) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Bucket) GetCors() []*CorsRule {
	if x != nil {
		return x.Cors
	}
	return nil
}

func (x *Bucket) GetWebsiteSettings() *WebsiteSettings {
	if x != nil {
		return x.WebsiteSettings
	}
	return nil
}

func (x *Bucket) GetLifecycleRules() []*LifecycleRule {
	if x != nil {
		return x.LifecycleRules
	}
	return nil
}

func (x *Bucket) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Bucket) GetObjectLock() *ObjectLock {
	if x != nil {
		return x.ObjectLock
	}
	return nil
}

func (x *Bucket) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *Bucket) GetAllowedPrivateEndpoints() *BucketAllowedPrivateEndpoints {
	if x != nil {
		return x.AllowedPrivateEndpoints
	}
	return nil
}

type Tag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key of the bucket tag.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value of the bucket tag.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Tag) Reset() {
	*x = Tag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tag) ProtoMessage() {}

func (x *Tag) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tag.ProtoReflect.Descriptor instead.
func (*Tag) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{1}
}

func (x *Tag) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Tag) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type ACL struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of permissions granted and the grantees.
	Grants []*ACL_Grant `protobuf:"bytes,1,rep,name=grants,proto3" json:"grants,omitempty"`
}

func (x *ACL) Reset() {
	*x = ACL{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ACL) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ACL) ProtoMessage() {}

func (x *ACL) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ACL.ProtoReflect.Descriptor instead.
func (*ACL) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{2}
}

func (x *ACL) GetGrants() []*ACL_Grant {
	if x != nil {
		return x.Grants
	}
	return nil
}

type AnonymousAccessFlags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies whether public (anonymous) access to read objects in the bucket is enabled.
	Read *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=read,proto3" json:"read,omitempty"`
	// Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
	List *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=list,proto3" json:"list,omitempty"`
	// Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
	// [static website hosting](/docs/storage/concepts/hosting), and
	// [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
	ConfigRead *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=config_read,json=configRead,proto3" json:"config_read,omitempty"`
}

func (x *AnonymousAccessFlags) Reset() {
	*x = AnonymousAccessFlags{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnonymousAccessFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnonymousAccessFlags) ProtoMessage() {}

func (x *AnonymousAccessFlags) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnonymousAccessFlags.ProtoReflect.Descriptor instead.
func (*AnonymousAccessFlags) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{3}
}

func (x *AnonymousAccessFlags) GetRead() *wrapperspb.BoolValue {
	if x != nil {
		return x.Read
	}
	return nil
}

func (x *AnonymousAccessFlags) GetList() *wrapperspb.BoolValue {
	if x != nil {
		return x.List
	}
	return nil
}

func (x *AnonymousAccessFlags) GetConfigRead() *wrapperspb.BoolValue {
	if x != nil {
		return x.ConfigRead
	}
	return nil
}

// A CORS rule resource.
// For details about the concept, see [documentation](/docs/storage/concepts/cors).
type CorsRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the CORS rule.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// List of HTTP methods allowed by the CORS rule.
	//
	// When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
	// [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
	// the list of the allowed methods. If there is a match, all the allowed methods are listed in the
	// `Access-Control-Allow-Methods` header of the response.
	AllowedMethods []CorsRule_Method `protobuf:"varint,2,rep,packed,name=allowed_methods,json=allowedMethods,proto3,enum=yandex.cloud.storage.v1.CorsRule_Method" json:"allowed_methods,omitempty"`
	// List of HTTP headers allowed by the CORS rule.
	//
	// When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
	// [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
	// the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
	// `Access-Control-Allow-Headers` header of the response.
	//
	// Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
	// For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
	AllowedHeaders []string `protobuf:"bytes,3,rep,name=allowed_headers,json=allowedHeaders,proto3" json:"allowed_headers,omitempty"`
	// List of request origins allowed by the CORS rule.
	//
	// Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
	// For example, `http://*.example.com` value will allow requests originating from all subdomains of `example.com`.
	AllowedOrigins []string `protobuf:"bytes,4,rep,name=allowed_origins,json=allowedOrigins,proto3" json:"allowed_origins,omitempty"`
	// List of headers contained in responses to CORS requests that can be accessed by applications.
	ExposeHeaders []string `protobuf:"bytes,5,rep,name=expose_headers,json=exposeHeaders,proto3" json:"expose_headers,omitempty"`
	// Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
	// object requested, the HTTP method, and the origin.
	MaxAgeSeconds *wrapperspb.Int64Value `protobuf:"bytes,6,opt,name=max_age_seconds,json=maxAgeSeconds,proto3" json:"max_age_seconds,omitempty"`
}

func (x *CorsRule) Reset() {
	*x = CorsRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CorsRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorsRule) ProtoMessage() {}

func (x *CorsRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorsRule.ProtoReflect.Descriptor instead.
func (*CorsRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{4}
}

func (x *CorsRule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CorsRule) GetAllowedMethods() []CorsRule_Method {
	if x != nil {
		return x.AllowedMethods
	}
	return nil
}

func (x *CorsRule) GetAllowedHeaders() []string {
	if x != nil {
		return x.AllowedHeaders
	}
	return nil
}

func (x *CorsRule) GetAllowedOrigins() []string {
	if x != nil {
		return x.AllowedOrigins
	}
	return nil
}

func (x *CorsRule) GetExposeHeaders() []string {
	if x != nil {
		return x.ExposeHeaders
	}
	return nil
}

func (x *CorsRule) GetMaxAgeSeconds() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxAgeSeconds
	}
	return nil
}

type WebsiteSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key of the index page object that is returned when a response is made to the root of the website.
	//
	// Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
	//
	// If specified, the index page object must be located in the root of the bucket.
	Index string `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// Key of the error page object that is returned when an error occurs.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// Configuration for redirecting all requests sent to the website.
	//
	// Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
	// If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
	RedirectAllRequests *WebsiteSettings_Scheme `protobuf:"bytes,3,opt,name=redirect_all_requests,json=redirectAllRequests,proto3" json:"redirect_all_requests,omitempty"`
	// List of redirect rules.
	RoutingRules []*WebsiteSettings_RoutingRule `protobuf:"bytes,4,rep,name=routing_rules,json=routingRules,proto3" json:"routing_rules,omitempty"`
}

func (x *WebsiteSettings) Reset() {
	*x = WebsiteSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebsiteSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebsiteSettings) ProtoMessage() {}

func (x *WebsiteSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebsiteSettings.ProtoReflect.Descriptor instead.
func (*WebsiteSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5}
}

func (x *WebsiteSettings) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *WebsiteSettings) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *WebsiteSettings) GetRedirectAllRequests() *WebsiteSettings_Scheme {
	if x != nil {
		return x.RedirectAllRequests
	}
	return nil
}

func (x *WebsiteSettings) GetRoutingRules() []*WebsiteSettings_RoutingRule {
	if x != nil {
		return x.RoutingRules
	}
	return nil
}

// An object lifecycle rule resource for the bucket.
// For details about the concept, see [documentation](/docs/storage/concepts/lifecycles).
type LifecycleRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the rule. Provided by the client or generated at creation time.
	Id *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Indicates whether the rule is in effect.
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Filter that identifies the objects to which the rule applies.
	//
	// If not specified, the rule applies to all objects in the bucket.
	Filter *LifecycleRule_RuleFilter `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expiration rule.
	//
	// The expiration of an object is described as follows.
	//
	// For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
	// recovered.
	//
	// For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
	// object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
	// the current version of the object.
	//
	// For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
	// the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
	// delete marker becomes the current version of the object.
	Expiration *LifecycleRule_Expiration `protobuf:"bytes,4,opt,name=expiration,proto3" json:"expiration,omitempty"`
	// List of transition rules.
	//
	// The transition of an object is described as follows.
	//
	// For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
	// specified storage class.
	//
	// For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
	// (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
	Transitions []*LifecycleRule_Transition `protobuf:"bytes,5,rep,name=transitions,proto3" json:"transitions,omitempty"`
	// Configuration for aborting incomplete [multipart uploads](/docs/storage/concepts/multipart).
	AbortIncompleteMultipartUpload *LifecycleRule_AfterDays `protobuf:"bytes,6,opt,name=abort_incomplete_multipart_upload,json=abortIncompleteMultipartUpload,proto3" json:"abort_incomplete_multipart_upload,omitempty"`
	// Expiration rule for non-current versions of objects in a bucket with versioning enabled ([Bucket.versioning] is
	// `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
	//
	// At expiration, the non-current version of the object is deleted and cannot be recovered.
	NoncurrentExpiration *LifecycleRule_NoncurrentExpiration `protobuf:"bytes,7,opt,name=noncurrent_expiration,json=noncurrentExpiration,proto3" json:"noncurrent_expiration,omitempty"`
	// List of transition rules for non-current versions of objects in a bucket with versioning enabled
	// ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
	//
	// At transition, the non-current version of the object is transitioned to the specified storage class.
	NoncurrentTransitions []*LifecycleRule_NoncurrentTransition `protobuf:"bytes,8,rep,name=noncurrent_transitions,json=noncurrentTransitions,proto3" json:"noncurrent_transitions,omitempty"`
	// Expiration rule for non-current delete markers of an objects in a bucket with versioning
	// enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
	// Works in the same way as noncurrent_expiration rule, but only for delete markers.
	//
	// At expiration, the non-current delete marker of the object is deleted and cannot be recovered.
	NoncurrentDeleteMarkers *LifecycleRule_NoncurrentDeleteMarkers `protobuf:"bytes,9,opt,name=noncurrent_delete_markers,json=noncurrentDeleteMarkers,proto3" json:"noncurrent_delete_markers,omitempty"`
}

func (x *LifecycleRule) Reset() {
	*x = LifecycleRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecycleRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule) ProtoMessage() {}

func (x *LifecycleRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule.ProtoReflect.Descriptor instead.
func (*LifecycleRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6}
}

func (x *LifecycleRule) GetId() *wrapperspb.StringValue {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *LifecycleRule) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *LifecycleRule) GetFilter() *LifecycleRule_RuleFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *LifecycleRule) GetExpiration() *LifecycleRule_Expiration {
	if x != nil {
		return x.Expiration
	}
	return nil
}

func (x *LifecycleRule) GetTransitions() []*LifecycleRule_Transition {
	if x != nil {
		return x.Transitions
	}
	return nil
}

func (x *LifecycleRule) GetAbortIncompleteMultipartUpload() *LifecycleRule_AfterDays {
	if x != nil {
		return x.AbortIncompleteMultipartUpload
	}
	return nil
}

func (x *LifecycleRule) GetNoncurrentExpiration() *LifecycleRule_NoncurrentExpiration {
	if x != nil {
		return x.NoncurrentExpiration
	}
	return nil
}

func (x *LifecycleRule) GetNoncurrentTransitions() []*LifecycleRule_NoncurrentTransition {
	if x != nil {
		return x.NoncurrentTransitions
	}
	return nil
}

func (x *LifecycleRule) GetNoncurrentDeleteMarkers() *LifecycleRule_NoncurrentDeleteMarkers {
	if x != nil {
		return x.NoncurrentDeleteMarkers
	}
	return nil
}

type Counters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total size of objects uploaded in single operation, in bytes.
	SimpleObjectSize int64 `protobuf:"varint,1,opt,name=simple_object_size,json=simpleObjectSize,proto3" json:"simple_object_size,omitempty"`
	// Number of objects uploaded in single operation.
	SimpleObjectCount int64 `protobuf:"varint,2,opt,name=simple_object_count,json=simpleObjectCount,proto3" json:"simple_object_count,omitempty"`
	// Total size of uploaded parts in incomplete multipart uploads, in bytes.
	ObjectsPartsSize int64 `protobuf:"varint,3,opt,name=objects_parts_size,json=objectsPartsSize,proto3" json:"objects_parts_size,omitempty"`
	// Number of uploaded parts in incomplete multipart uploads.
	ObjectsPartsCount int64 `protobuf:"varint,4,opt,name=objects_parts_count,json=objectsPartsCount,proto3" json:"objects_parts_count,omitempty"`
	// Total size of objects uploaded in multiple parts, in bytes.
	MultipartObjectsSize int64 `protobuf:"varint,5,opt,name=multipart_objects_size,json=multipartObjectsSize,proto3" json:"multipart_objects_size,omitempty"`
	// Number of objects uploaded in multiple parts.
	MultipartObjectsCount int64 `protobuf:"varint,6,opt,name=multipart_objects_count,json=multipartObjectsCount,proto3" json:"multipart_objects_count,omitempty"`
	// Number of incomplete multipart uploads.
	ActiveMultipartCount int64 `protobuf:"varint,7,opt,name=active_multipart_count,json=activeMultipartCount,proto3" json:"active_multipart_count,omitempty"`
}

func (x *Counters) Reset() {
	*x = Counters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Counters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Counters) ProtoMessage() {}

func (x *Counters) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Counters.ProtoReflect.Descriptor instead.
func (*Counters) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{7}
}

func (x *Counters) GetSimpleObjectSize() int64 {
	if x != nil {
		return x.SimpleObjectSize
	}
	return 0
}

func (x *Counters) GetSimpleObjectCount() int64 {
	if x != nil {
		return x.SimpleObjectCount
	}
	return 0
}

func (x *Counters) GetObjectsPartsSize() int64 {
	if x != nil {
		return x.ObjectsPartsSize
	}
	return 0
}

func (x *Counters) GetObjectsPartsCount() int64 {
	if x != nil {
		return x.ObjectsPartsCount
	}
	return 0
}

func (x *Counters) GetMultipartObjectsSize() int64 {
	if x != nil {
		return x.MultipartObjectsSize
	}
	return 0
}

func (x *Counters) GetMultipartObjectsCount() int64 {
	if x != nil {
		return x.MultipartObjectsCount
	}
	return 0
}

func (x *Counters) GetActiveMultipartCount() int64 {
	if x != nil {
		return x.ActiveMultipartCount
	}
	return 0
}

// A resource for size of available space in a bucket for a storage class.
type OptionalSizeByClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Storage class. Supported classes are standard storage (`STANDARD`), cold storage (`COLD`, `STANDARD_IA`, `NEARLINE`
	// all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	StorageClass string `protobuf:"bytes,1,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// Size of available space in the bucket for the storage class.
	ClassSize *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=class_size,json=classSize,proto3" json:"class_size,omitempty"`
}

func (x *OptionalSizeByClass) Reset() {
	*x = OptionalSizeByClass{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OptionalSizeByClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OptionalSizeByClass) ProtoMessage() {}

func (x *OptionalSizeByClass) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OptionalSizeByClass.ProtoReflect.Descriptor instead.
func (*OptionalSizeByClass) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{8}
}

func (x *OptionalSizeByClass) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

func (x *OptionalSizeByClass) GetClassSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.ClassSize
	}
	return nil
}

// A resource for size of used space in a bucket for a storage class.
type SizeByClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Storage class. Supported classes are standard storage (`STANDARD`), cold storage (`COLD`, `STANDARD_IA`, `NEARLINE`
	// all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	StorageClass string `protobuf:"bytes,1,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// Size of used space in the bucket for the storage class.
	ClassSize int64 `protobuf:"varint,2,opt,name=class_size,json=classSize,proto3" json:"class_size,omitempty"`
}

func (x *SizeByClass) Reset() {
	*x = SizeByClass{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SizeByClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SizeByClass) ProtoMessage() {}

func (x *SizeByClass) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SizeByClass.ProtoReflect.Descriptor instead.
func (*SizeByClass) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{9}
}

func (x *SizeByClass) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

func (x *SizeByClass) GetClassSize() int64 {
	if x != nil {
		return x.ClassSize
	}
	return 0
}

// A resource for object-related statistics for a storage class by type of upload (simple vs. multipart).
type CountersByClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Storage class. Supported classes are standard storage (`STANDARD`), cold storage (`COLD`, `STANDARD_IA`, `NEARLINE`
	// all synonyms), and ice storage (`ice` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	StorageClass string `protobuf:"bytes,1,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// Object-related statistics for the storage class by type of upload.
	Counters *Counters `protobuf:"bytes,2,opt,name=counters,proto3" json:"counters,omitempty"`
}

func (x *CountersByClass) Reset() {
	*x = CountersByClass{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CountersByClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CountersByClass) ProtoMessage() {}

func (x *CountersByClass) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CountersByClass.ProtoReflect.Descriptor instead.
func (*CountersByClass) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{10}
}

func (x *CountersByClass) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

func (x *CountersByClass) GetCounters() *Counters {
	if x != nil {
		return x.Counters
	}
	return nil
}

// A bucket statistics resource.
type BucketStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Maximum size of the bucket, in bytes.
	MaxSize *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// Size of used space in the bucket, in bytes.
	UsedSize int64 `protobuf:"varint,3,opt,name=used_size,json=usedSize,proto3" json:"used_size,omitempty"`
	// Size of available space in the bucket by storage class, in bytes.
	StorageClassMaxSizes []*OptionalSizeByClass `protobuf:"bytes,4,rep,name=storage_class_max_sizes,json=storageClassMaxSizes,proto3" json:"storage_class_max_sizes,omitempty"`
	// Size of used space in the bucket by storage class, in bytes.
	StorageClassUsedSizes []*SizeByClass `protobuf:"bytes,5,rep,name=storage_class_used_sizes,json=storageClassUsedSizes,proto3" json:"storage_class_used_sizes,omitempty"`
	// Object-related statistics by storage class and type of upload (simple vs. multipart), in bytes.
	StorageClassCounters []*CountersByClass `protobuf:"bytes,6,rep,name=storage_class_counters,json=storageClassCounters,proto3" json:"storage_class_counters,omitempty"`
	// Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
	// (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	DefaultStorageClass *wrapperspb.StringValue `protobuf:"bytes,7,opt,name=default_storage_class,json=defaultStorageClass,proto3" json:"default_storage_class,omitempty"`
	// Flags for configuring public (anonymous) access to the bucket's content and settings.
	// For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
	AnonymousAccessFlags *AnonymousAccessFlags `protobuf:"bytes,8,opt,name=anonymous_access_flags,json=anonymousAccessFlags,proto3" json:"anonymous_access_flags,omitempty"`
	// Bucket creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Bucket latest update timestamp.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
}

func (x *BucketStats) Reset() {
	*x = BucketStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BucketStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketStats) ProtoMessage() {}

func (x *BucketStats) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BucketStats.ProtoReflect.Descriptor instead.
func (*BucketStats) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{11}
}

func (x *BucketStats) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BucketStats) GetMaxSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxSize
	}
	return nil
}

func (x *BucketStats) GetUsedSize() int64 {
	if x != nil {
		return x.UsedSize
	}
	return 0
}

func (x *BucketStats) GetStorageClassMaxSizes() []*OptionalSizeByClass {
	if x != nil {
		return x.StorageClassMaxSizes
	}
	return nil
}

func (x *BucketStats) GetStorageClassUsedSizes() []*SizeByClass {
	if x != nil {
		return x.StorageClassUsedSizes
	}
	return nil
}

func (x *BucketStats) GetStorageClassCounters() []*CountersByClass {
	if x != nil {
		return x.StorageClassCounters
	}
	return nil
}

func (x *BucketStats) GetDefaultStorageClass() *wrapperspb.StringValue {
	if x != nil {
		return x.DefaultStorageClass
	}
	return nil
}

func (x *BucketStats) GetAnonymousAccessFlags() *AnonymousAccessFlags {
	if x != nil {
		return x.AnonymousAccessFlags
	}
	return nil
}

func (x *BucketStats) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *BucketStats) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

// A resource for HTTPS configuration of a bucket.
type HTTPSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of TLS certificate source.
	SourceType HTTPSConfig_SourceType `protobuf:"varint,2,opt,name=source_type,json=sourceType,proto3,enum=yandex.cloud.storage.v1.HTTPSConfig_SourceType" json:"source_type,omitempty"`
	// Issuer of the TLS certificate.
	Issuer *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// Subject of the TLS certificate.
	Subject *wrapperspb.StringValue `protobuf:"bytes,4,opt,name=subject,proto3" json:"subject,omitempty"`
	// List of DNS names of the TLS certificate (Subject Alternative Name field).
	DnsNames []string `protobuf:"bytes,5,rep,name=dns_names,json=dnsNames,proto3" json:"dns_names,omitempty"`
	// Start of the TLS certificate validity period (Not Before field).
	NotBefore *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=not_before,json=notBefore,proto3" json:"not_before,omitempty"`
	// End of the TLS certificate validity period (Not After field)
	NotAfter *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=not_after,json=notAfter,proto3" json:"not_after,omitempty"`
	// ID of the TLS certificate in Certificate Manager.
	//
	// To get information about the certificate from Certificate Manager, make a
	// [yandex.cloud.certificatemanager.v1.CertificateService.Get] request.
	CertificateId string `protobuf:"bytes,8,opt,name=certificate_id,json=certificateId,proto3" json:"certificate_id,omitempty"`
}

func (x *HTTPSConfig) Reset() {
	*x = HTTPSConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPSConfig) ProtoMessage() {}

func (x *HTTPSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPSConfig.ProtoReflect.Descriptor instead.
func (*HTTPSConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{12}
}

func (x *HTTPSConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPSConfig) GetSourceType() HTTPSConfig_SourceType {
	if x != nil {
		return x.SourceType
	}
	return HTTPSConfig_SOURCE_TYPE_UNSPECIFIED
}

func (x *HTTPSConfig) GetIssuer() *wrapperspb.StringValue {
	if x != nil {
		return x.Issuer
	}
	return nil
}

func (x *HTTPSConfig) GetSubject() *wrapperspb.StringValue {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *HTTPSConfig) GetDnsNames() []string {
	if x != nil {
		return x.DnsNames
	}
	return nil
}

func (x *HTTPSConfig) GetNotBefore() *timestamppb.Timestamp {
	if x != nil {
		return x.NotBefore
	}
	return nil
}

func (x *HTTPSConfig) GetNotAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.NotAfter
	}
	return nil
}

func (x *HTTPSConfig) GetCertificateId() string {
	if x != nil {
		return x.CertificateId
	}
	return ""
}

// A resource for Object Lock configuration of a bucket.
// For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
type ObjectLock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status           ObjectLock_ObjectLockStatus  `protobuf:"varint,2,opt,name=status,proto3,enum=yandex.cloud.storage.v1.ObjectLock_ObjectLockStatus" json:"status,omitempty"`
	DefaultRetention *ObjectLock_DefaultRetention `protobuf:"bytes,3,opt,name=default_retention,json=defaultRetention,proto3" json:"default_retention,omitempty"`
}

func (x *ObjectLock) Reset() {
	*x = ObjectLock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectLock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectLock) ProtoMessage() {}

func (x *ObjectLock) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectLock.ProtoReflect.Descriptor instead.
func (*ObjectLock) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{13}
}

func (x *ObjectLock) GetStatus() ObjectLock_ObjectLockStatus {
	if x != nil {
		return x.Status
	}
	return ObjectLock_OBJECT_LOCK_STATUS_UNSPECIFIED
}

func (x *ObjectLock) GetDefaultRetention() *ObjectLock_DefaultRetention {
	if x != nil {
		return x.DefaultRetention
	}
	return nil
}

type Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rules []*Encryption_EncryptionRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *Encryption) Reset() {
	*x = Encryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption) ProtoMessage() {}

func (x *Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption.ProtoReflect.Descriptor instead.
func (*Encryption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{14}
}

func (x *Encryption) GetRules() []*Encryption_EncryptionRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

type BucketAllowedPrivateEndpoints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// if true, private endpoints white list check is enabled
	// even if private_endpoints list is empty
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// white list of private endpoints bucket accessible from
	PrivateEndpoints []string `protobuf:"bytes,2,rep,name=private_endpoints,json=privateEndpoints,proto3" json:"private_endpoints,omitempty"`
}

func (x *BucketAllowedPrivateEndpoints) Reset() {
	*x = BucketAllowedPrivateEndpoints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BucketAllowedPrivateEndpoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketAllowedPrivateEndpoints) ProtoMessage() {}

func (x *BucketAllowedPrivateEndpoints) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BucketAllowedPrivateEndpoints.ProtoReflect.Descriptor instead.
func (*BucketAllowedPrivateEndpoints) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{15}
}

func (x *BucketAllowedPrivateEndpoints) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *BucketAllowedPrivateEndpoints) GetPrivateEndpoints() []string {
	if x != nil {
		return x.PrivateEndpoints
	}
	return nil
}

// A grant resource, used to specify the permission granted and the grantee.
type ACL_Grant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Permission granted by the grant.
	Permission ACL_Grant_Permission `protobuf:"varint,1,opt,name=permission,proto3,enum=yandex.cloud.storage.v1.ACL_Grant_Permission" json:"permission,omitempty"`
	// The grantee type for the grant.
	GrantType ACL_Grant_GrantType `protobuf:"varint,2,opt,name=grant_type,json=grantType,proto3,enum=yandex.cloud.storage.v1.ACL_Grant_GrantType" json:"grant_type,omitempty"`
	// ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
	GranteeId string `protobuf:"bytes,3,opt,name=grantee_id,json=granteeId,proto3" json:"grantee_id,omitempty"`
}

func (x *ACL_Grant) Reset() {
	*x = ACL_Grant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ACL_Grant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ACL_Grant) ProtoMessage() {}

func (x *ACL_Grant) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ACL_Grant.ProtoReflect.Descriptor instead.
func (*ACL_Grant) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ACL_Grant) GetPermission() ACL_Grant_Permission {
	if x != nil {
		return x.Permission
	}
	return ACL_Grant_PERMISSION_UNSPECIFIED
}

func (x *ACL_Grant) GetGrantType() ACL_Grant_GrantType {
	if x != nil {
		return x.GrantType
	}
	return ACL_Grant_GRANT_TYPE_UNSPECIFIED
}

func (x *ACL_Grant) GetGranteeId() string {
	if x != nil {
		return x.GranteeId
	}
	return ""
}

// A configuration resource for redirecting all requests sent to the website.
type WebsiteSettings_Scheme struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Scheme of the redirect URI.
	Protocol WebsiteSettings_Protocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=yandex.cloud.storage.v1.WebsiteSettings_Protocol" json:"protocol,omitempty"`
	// Hostname of the redirect URI.
	Hostname string `protobuf:"bytes,2,opt,name=hostname,proto3" json:"hostname,omitempty"`
}

func (x *WebsiteSettings_Scheme) Reset() {
	*x = WebsiteSettings_Scheme{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebsiteSettings_Scheme) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebsiteSettings_Scheme) ProtoMessage() {}

func (x *WebsiteSettings_Scheme) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebsiteSettings_Scheme.ProtoReflect.Descriptor instead.
func (*WebsiteSettings_Scheme) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5, 0}
}

func (x *WebsiteSettings_Scheme) GetProtocol() WebsiteSettings_Protocol {
	if x != nil {
		return x.Protocol
	}
	return WebsiteSettings_PROTOCOL_UNSPECIFIED
}

func (x *WebsiteSettings_Scheme) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

type WebsiteSettings_Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// HTTP status code (number only) that must match for the redirect to apply.
	HttpErrorCodeReturnedEquals string `protobuf:"bytes,1,opt,name=http_error_code_returned_equals,json=httpErrorCodeReturnedEquals,proto3" json:"http_error_code_returned_equals,omitempty"`
	// Prefix of the object key from which requests are redirected.
	KeyPrefixEquals string `protobuf:"bytes,2,opt,name=key_prefix_equals,json=keyPrefixEquals,proto3" json:"key_prefix_equals,omitempty"`
}

func (x *WebsiteSettings_Condition) Reset() {
	*x = WebsiteSettings_Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebsiteSettings_Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebsiteSettings_Condition) ProtoMessage() {}

func (x *WebsiteSettings_Condition) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebsiteSettings_Condition.ProtoReflect.Descriptor instead.
func (*WebsiteSettings_Condition) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5, 1}
}

func (x *WebsiteSettings_Condition) GetHttpErrorCodeReturnedEquals() string {
	if x != nil {
		return x.HttpErrorCodeReturnedEquals
	}
	return ""
}

func (x *WebsiteSettings_Condition) GetKeyPrefixEquals() string {
	if x != nil {
		return x.KeyPrefixEquals
	}
	return ""
}

type WebsiteSettings_Redirect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Hostname of the redirect URI.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// HTTP status code of the redirect response.
	//
	// Default value: `"301"`.
	HttpRedirectCode string `protobuf:"bytes,2,opt,name=http_redirect_code,json=httpRedirectCode,proto3" json:"http_redirect_code,omitempty"`
	// Scheme of the redirect URI.
	Protocol WebsiteSettings_Protocol `protobuf:"varint,3,opt,name=protocol,proto3,enum=yandex.cloud.storage.v1.WebsiteSettings_Protocol" json:"protocol,omitempty"`
	// Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
	//
	// At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
	ReplaceKeyPrefixWith string `protobuf:"bytes,4,opt,name=replace_key_prefix_with,json=replaceKeyPrefixWith,proto3" json:"replace_key_prefix_with,omitempty"`
	// New object key.
	//
	// At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
	ReplaceKeyWith string `protobuf:"bytes,5,opt,name=replace_key_with,json=replaceKeyWith,proto3" json:"replace_key_with,omitempty"`
}

func (x *WebsiteSettings_Redirect) Reset() {
	*x = WebsiteSettings_Redirect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebsiteSettings_Redirect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebsiteSettings_Redirect) ProtoMessage() {}

func (x *WebsiteSettings_Redirect) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebsiteSettings_Redirect.ProtoReflect.Descriptor instead.
func (*WebsiteSettings_Redirect) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5, 2}
}

func (x *WebsiteSettings_Redirect) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *WebsiteSettings_Redirect) GetHttpRedirectCode() string {
	if x != nil {
		return x.HttpRedirectCode
	}
	return ""
}

func (x *WebsiteSettings_Redirect) GetProtocol() WebsiteSettings_Protocol {
	if x != nil {
		return x.Protocol
	}
	return WebsiteSettings_PROTOCOL_UNSPECIFIED
}

func (x *WebsiteSettings_Redirect) GetReplaceKeyPrefixWith() string {
	if x != nil {
		return x.ReplaceKeyPrefixWith
	}
	return ""
}

func (x *WebsiteSettings_Redirect) GetReplaceKeyWith() string {
	if x != nil {
		return x.ReplaceKeyWith
	}
	return ""
}

// List of redirect rules.
type WebsiteSettings_RoutingRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Redirect condition.
	Condition *WebsiteSettings_Condition `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	// Redirect instructions.
	Redirect *WebsiteSettings_Redirect `protobuf:"bytes,2,opt,name=redirect,proto3" json:"redirect,omitempty"`
}

func (x *WebsiteSettings_RoutingRule) Reset() {
	*x = WebsiteSettings_RoutingRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebsiteSettings_RoutingRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebsiteSettings_RoutingRule) ProtoMessage() {}

func (x *WebsiteSettings_RoutingRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebsiteSettings_RoutingRule.ProtoReflect.Descriptor instead.
func (*WebsiteSettings_RoutingRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5, 3}
}

func (x *WebsiteSettings_RoutingRule) GetCondition() *WebsiteSettings_Condition {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *WebsiteSettings_RoutingRule) GetRedirect() *WebsiteSettings_Redirect {
	if x != nil {
		return x.Redirect
	}
	return nil
}

type LifecycleRule_AfterDays struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
	// aborted.
	DaysAfterExpiration *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=days_after_expiration,json=daysAfterExpiration,proto3" json:"days_after_expiration,omitempty"`
}

func (x *LifecycleRule_AfterDays) Reset() {
	*x = LifecycleRule_AfterDays{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecycleRule_AfterDays) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_AfterDays) ProtoMessage() {}

func (x *LifecycleRule_AfterDays) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_AfterDays.ProtoReflect.Descriptor instead.
func (*LifecycleRule_AfterDays) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 0}
}

func (x *LifecycleRule_AfterDays) GetDaysAfterExpiration() *wrapperspb.Int64Value {
	if x != nil {
		return x.DaysAfterExpiration
	}
	return nil
}

type LifecycleRule_NoncurrentDeleteMarkers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time period, in number of days since the version of a delete marker was classified as non-current, after which
	// the delete marker expires.
	NoncurrentDays *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=noncurrent_days,json=noncurrentDays,proto3" json:"noncurrent_days,omitempty"`
}

func (x *LifecycleRule_NoncurrentDeleteMarkers) Reset() {
	*x = LifecycleRule_NoncurrentDeleteMarkers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecycleRule_NoncurrentDeleteMarkers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_NoncurrentDeleteMarkers) ProtoMessage() {}

func (x *LifecycleRule_NoncurrentDeleteMarkers) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_NoncurrentDeleteMarkers.ProtoReflect.Descriptor instead.
func (*LifecycleRule_NoncurrentDeleteMarkers) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 1}
}

func (x *LifecycleRule_NoncurrentDeleteMarkers) GetNoncurrentDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.NoncurrentDays
	}
	return nil
}

type LifecycleRule_NoncurrentExpiration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time period, in number of days since the version of an object was classified as non-current, after which the
	// version expires.
	NoncurrentDays *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=noncurrent_days,json=noncurrentDays,proto3" json:"noncurrent_days,omitempty"`
}

func (x *LifecycleRule_NoncurrentExpiration) Reset() {
	*x = LifecycleRule_NoncurrentExpiration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecycleRule_NoncurrentExpiration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_NoncurrentExpiration) ProtoMessage() {}

func (x *LifecycleRule_NoncurrentExpiration) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_NoncurrentExpiration.ProtoReflect.Descriptor instead.
func (*LifecycleRule_NoncurrentExpiration) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 2}
}

func (x *LifecycleRule_NoncurrentExpiration) GetNoncurrentDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.NoncurrentDays
	}
	return nil
}

// List of transition rules for non-current versions of objects in a bucket with versioning enabled
// ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
//
// At transition, the non-current version of the object is transitioned to the specified storage class.
type LifecycleRule_NoncurrentTransition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time period, in number of days since the version of an object was classified as non-current, after which the
	// version is transitioned.
	NoncurrentDays *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=noncurrent_days,json=noncurrentDays,proto3" json:"noncurrent_days,omitempty"`
	// Storage class to which a non-current version of an object is transitioned from standard storage.
	//
	// The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
	// to standard storage and transitions to or from ice storage are not allowed.
	StorageClass string `protobuf:"bytes,2,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
}

func (x *LifecycleRule_NoncurrentTransition) Reset() {
	*x = LifecycleRule_NoncurrentTransition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecycleRule_NoncurrentTransition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_NoncurrentTransition) ProtoMessage() {}

func (x *LifecycleRule_NoncurrentTransition) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_NoncurrentTransition.ProtoReflect.Descriptor instead.
func (*LifecycleRule_NoncurrentTransition) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 3}
}

func (x *LifecycleRule_NoncurrentTransition) GetNoncurrentDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.NoncurrentDays
	}
	return nil
}

func (x *LifecycleRule_NoncurrentTransition) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

// List of transition rules.
//
// The transition of an object is described as follows.
//
// For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
// specified storage class.
//
// For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
// (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
type LifecycleRule_Transition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specific date of object transition.
	//
	// The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
	// transitioned immediately.
	//
	// At most one of [date] and [days] fields can be specified.
	Date *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// Time period, in number of days from the creation or modification of the object, after which an object is
	// transitioned.
	//
	// At most one of [days] and [date] fields can be specified.
	Days *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=days,proto3" json:"days,omitempty"`
	// Storage class to which an object is transitioned from standard storage.
	//
	// The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
	// to standard storage and transitions to or from ice storage are not allowed.
	StorageClass string `protobuf:"bytes,4,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
}

func (x *LifecycleRule_Transition) Reset() {
	*x = LifecycleRule_Transition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecycleRule_Transition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_Transition) ProtoMessage() {}

func (x *LifecycleRule_Transition) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_Transition.ProtoReflect.Descriptor instead.
func (*LifecycleRule_Transition) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 4}
}

func (x *LifecycleRule_Transition) GetDate() *timestamppb.Timestamp {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *LifecycleRule_Transition) GetDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.Days
	}
	return nil
}

func (x *LifecycleRule_Transition) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

type LifecycleRule_Expiration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specific date of object expiration.
	//
	// The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
	// immediately.
	//
	// Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
	Date *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// Time period, in number of days from the creation or modification of the object, after which an object expires.
	//
	// Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
	Days *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=days,proto3" json:"days,omitempty"`
	// Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
	// delete marker) is removed at the object's expiration.
	//
	// Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
	ExpiredObjectDeleteMarker *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=expired_object_delete_marker,json=expiredObjectDeleteMarker,proto3" json:"expired_object_delete_marker,omitempty"`
}

func (x *LifecycleRule_Expiration) Reset() {
	*x = LifecycleRule_Expiration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecycleRule_Expiration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_Expiration) ProtoMessage() {}

func (x *LifecycleRule_Expiration) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_Expiration.ProtoReflect.Descriptor instead.
func (*LifecycleRule_Expiration) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 5}
}

func (x *LifecycleRule_Expiration) GetDate() *timestamppb.Timestamp {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *LifecycleRule_Expiration) GetDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.Days
	}
	return nil
}

func (x *LifecycleRule_Expiration) GetExpiredObjectDeleteMarker() *wrapperspb.BoolValue {
	if x != nil {
		return x.ExpiredObjectDeleteMarker
	}
	return nil
}

type LifecycleRule_RuleFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key prefix that the object must have in order for the rule to apply.
	Prefix string `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Size that the object must be greater.
	ObjectSizeGreaterThan *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=object_size_greater_than,json=objectSizeGreaterThan,proto3" json:"object_size_greater_than,omitempty"`
	// Size that the object must be less t.
	ObjectSizeLessThan *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=object_size_less_than,json=objectSizeLessThan,proto3" json:"object_size_less_than,omitempty"`
	// Tags that the object's tag set must have for the rule to apply.
	Tag *Tag `protobuf:"bytes,4,opt,name=tag,proto3" json:"tag,omitempty"`
	// Apply a logical AND to all of the predicates configured inside the And operator.
	AndOperator *LifecycleRule_RuleFilter_And `protobuf:"bytes,5,opt,name=and_operator,json=andOperator,proto3" json:"and_operator,omitempty"`
}

func (x *LifecycleRule_RuleFilter) Reset() {
	*x = LifecycleRule_RuleFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecycleRule_RuleFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_RuleFilter) ProtoMessage() {}

func (x *LifecycleRule_RuleFilter) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_RuleFilter.ProtoReflect.Descriptor instead.
func (*LifecycleRule_RuleFilter) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 6}
}

func (x *LifecycleRule_RuleFilter) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *LifecycleRule_RuleFilter) GetObjectSizeGreaterThan() *wrapperspb.Int64Value {
	if x != nil {
		return x.ObjectSizeGreaterThan
	}
	return nil
}

func (x *LifecycleRule_RuleFilter) GetObjectSizeLessThan() *wrapperspb.Int64Value {
	if x != nil {
		return x.ObjectSizeLessThan
	}
	return nil
}

func (x *LifecycleRule_RuleFilter) GetTag() *Tag {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *LifecycleRule_RuleFilter) GetAndOperator() *LifecycleRule_RuleFilter_And {
	if x != nil {
		return x.AndOperator
	}
	return nil
}

type LifecycleRule_RuleFilter_And struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Prefix                string                 `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	ObjectSizeGreaterThan *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=object_size_greater_than,json=objectSizeGreaterThan,proto3" json:"object_size_greater_than,omitempty"`
	ObjectSizeLessThan    *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=object_size_less_than,json=objectSizeLessThan,proto3" json:"object_size_less_than,omitempty"`
	Tag                   []*Tag                 `protobuf:"bytes,4,rep,name=tag,proto3" json:"tag,omitempty"`
}

func (x *LifecycleRule_RuleFilter_And) Reset() {
	*x = LifecycleRule_RuleFilter_And{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecycleRule_RuleFilter_And) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_RuleFilter_And) ProtoMessage() {}

func (x *LifecycleRule_RuleFilter_And) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_RuleFilter_And.ProtoReflect.Descriptor instead.
func (*LifecycleRule_RuleFilter_And) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 6, 0}
}

func (x *LifecycleRule_RuleFilter_And) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *LifecycleRule_RuleFilter_And) GetObjectSizeGreaterThan() *wrapperspb.Int64Value {
	if x != nil {
		return x.ObjectSizeGreaterThan
	}
	return nil
}

func (x *LifecycleRule_RuleFilter_And) GetObjectSizeLessThan() *wrapperspb.Int64Value {
	if x != nil {
		return x.ObjectSizeLessThan
	}
	return nil
}

func (x *LifecycleRule_RuleFilter_And) GetTag() []*Tag {
	if x != nil {
		return x.Tag
	}
	return nil
}

// Default lock configuration for added objects
type ObjectLock_DefaultRetention struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mode ObjectLock_DefaultRetention_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=yandex.cloud.storage.v1.ObjectLock_DefaultRetention_Mode" json:"mode,omitempty"`
	// Types that are assignable to Period:
	//
	//	*ObjectLock_DefaultRetention_Days
	//	*ObjectLock_DefaultRetention_Years
	Period isObjectLock_DefaultRetention_Period `protobuf_oneof:"period"`
}

func (x *ObjectLock_DefaultRetention) Reset() {
	*x = ObjectLock_DefaultRetention{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectLock_DefaultRetention) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectLock_DefaultRetention) ProtoMessage() {}

func (x *ObjectLock_DefaultRetention) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectLock_DefaultRetention.ProtoReflect.Descriptor instead.
func (*ObjectLock_DefaultRetention) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{13, 0}
}

func (x *ObjectLock_DefaultRetention) GetMode() ObjectLock_DefaultRetention_Mode {
	if x != nil {
		return x.Mode
	}
	return ObjectLock_DefaultRetention_MODE_UNSPECIFIED
}

func (m *ObjectLock_DefaultRetention) GetPeriod() isObjectLock_DefaultRetention_Period {
	if m != nil {
		return m.Period
	}
	return nil
}

func (x *ObjectLock_DefaultRetention) GetDays() int64 {
	if x, ok := x.GetPeriod().(*ObjectLock_DefaultRetention_Days); ok {
		return x.Days
	}
	return 0
}

func (x *ObjectLock_DefaultRetention) GetYears() int64 {
	if x, ok := x.GetPeriod().(*ObjectLock_DefaultRetention_Years); ok {
		return x.Years
	}
	return 0
}

type isObjectLock_DefaultRetention_Period interface {
	isObjectLock_DefaultRetention_Period()
}

type ObjectLock_DefaultRetention_Days struct {
	// Number of days for locking
	Days int64 `protobuf:"varint,2,opt,name=days,proto3,oneof"`
}

type ObjectLock_DefaultRetention_Years struct {
	// Number of years for locking
	Years int64 `protobuf:"varint,3,opt,name=years,proto3,oneof"`
}

func (*ObjectLock_DefaultRetention_Days) isObjectLock_DefaultRetention_Period() {}

func (*ObjectLock_DefaultRetention_Years) isObjectLock_DefaultRetention_Period() {}

type Encryption_EncryptionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KmsMasterKeyId string `protobuf:"bytes,1,opt,name=kms_master_key_id,json=kmsMasterKeyId,proto3" json:"kms_master_key_id,omitempty"`
	SseAlgorithm   string `protobuf:"bytes,2,opt,name=sse_algorithm,json=sseAlgorithm,proto3" json:"sse_algorithm,omitempty"`
}

func (x *Encryption_EncryptionRule) Reset() {
	*x = Encryption_EncryptionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Encryption_EncryptionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_EncryptionRule) ProtoMessage() {}

func (x *Encryption_EncryptionRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_EncryptionRule.ProtoReflect.Descriptor instead.
func (*Encryption_EncryptionRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{14, 0}
}

func (x *Encryption_EncryptionRule) GetKmsMasterKeyId() string {
	if x != nil {
		return x.KmsMasterKeyId
	}
	return ""
}

func (x *Encryption_EncryptionRule) GetSseAlgorithm() string {
	if x != nil {
		return x.SseAlgorithm
	}
	return ""
}

var File_yandex_cloud_storage_v1_bucket_proto protoreflect.FileDescriptor

var file_yandex_cloud_storage_v1_bucket_proto_rawDesc = []byte{
	0x0a, 0x24, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xec, 0x07,
	0x0a, 0x06, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x63, 0x0a, 0x16, 0x61, 0x6e, 0x6f,
	0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x14, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d,
	0x6f, 0x75, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x32,
	0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x12, 0x43, 0x0a, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x61, 0x78, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x2e, 0x0a, 0x03, 0x61, 0x63, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x43, 0x4c, 0x52, 0x03,
	0x61, 0x63, 0x6c, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x35,
	0x0a, 0x04, 0x63, 0x6f, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x04, 0x63, 0x6f, 0x72, 0x73, 0x12, 0x53, 0x0a, 0x10, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x73, 0x69, 0x74,
	0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x77, 0x65, 0x62, 0x73, 0x69,
	0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4f, 0x0a, 0x0f, 0x6c, 0x69,
	0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x0d, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x6c, 0x69, 0x66,
	0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x04, 0x74,
	0x61, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x44, 0x0a,
	0x0b, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x52, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4c,
	0x6f, 0x63, 0x6b, 0x12, 0x43, 0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x19, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x52, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x2d, 0x0a, 0x03,
	0x54, 0x61, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xbc, 0x04, 0x0a, 0x03,
	0x41, 0x43, 0x4c, 0x12, 0x3a, 0x0a, 0x06, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x43,
	0x4c, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x1a,
	0xf8, 0x03, 0x0a, 0x05, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0a, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x43, 0x4c, 0x2e, 0x47, 0x72, 0x61, 0x6e,
	0x74, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x04, 0xe8, 0xc7,
	0x31, 0x01, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x51,
	0x0a, 0x0a, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x43, 0x4c,
	0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x09, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x49, 0x64,
	0x22, 0xa3, 0x01, 0x0a, 0x0a, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x1a, 0x0a, 0x16, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x50,
	0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x43,
	0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x45, 0x52, 0x4d,
	0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x02, 0x12, 0x18,
	0x0a, 0x14, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x57, 0x52, 0x49,
	0x54, 0x45, 0x5f, 0x41, 0x43, 0x50, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x45, 0x52, 0x4d,
	0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x04, 0x12, 0x17, 0x0a,
	0x13, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x44,
	0x5f, 0x41, 0x43, 0x50, 0x10, 0x05, 0x22, 0x81, 0x01, 0x0a, 0x09, 0x47, 0x72, 0x61, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x16, 0x0a, 0x12, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41,
	0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x26, 0x0a, 0x22, 0x47, 0x52, 0x41, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x45,
	0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x53, 0x10, 0x02,
	0x12, 0x18, 0x0a, 0x14, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41,
	0x4c, 0x4c, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x53, 0x10, 0x03, 0x22, 0xb3, 0x01, 0x0a, 0x14, 0x41,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x6c,
	0x61, 0x67, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x72, 0x65, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x72,
	0x65, 0x61, 0x64, 0x12, 0x2e, 0x0a, 0x04, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x6c,
	0x69, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x72, 0x65,
	0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x61, 0x64,
	0x22, 0xb6, 0x03, 0x0a, 0x08, 0x43, 0x6f, 0x72, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x5d, 0x0a,
	0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x72, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x42, 0x0a, 0x82, 0xc8, 0x31, 0x02, 0x3e, 0x30, 0x90, 0xc8, 0x31, 0x01, 0x52, 0x0e, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x27, 0x0a, 0x0f,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x2f, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x5f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x06,
	0x82, 0xc8, 0x31, 0x02, 0x3e, 0x30, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65,
	0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d,
	0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x43, 0x0a,
	0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x41, 0x67, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x22, 0x75, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x16, 0x0a, 0x12,
	0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x47,
	0x45, 0x54, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x48,
	0x45, 0x41, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f,
	0x50, 0x4f, 0x53, 0x54, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44,
	0x5f, 0x50, 0x55, 0x54, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44,
	0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x05, 0x22, 0x90, 0x08, 0x0a, 0x0f, 0x57, 0x65,
	0x62, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x14, 0x0a,
	0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x63, 0x0a, 0x15, 0x72, 0x65, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x52, 0x13, 0x72, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x59,
	0x0a, 0x0d, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x57, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0c, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x1a, 0x73, 0x0a, 0x06, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x57, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x7d,
	0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x1f, 0x68,
	0x74, 0x74, 0x70, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x72,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x5f, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x1b, 0x68, 0x74, 0x74, 0x70, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x64, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x45, 0x71, 0x75, 0x61, 0x6c,
	0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6b, 0x65,
	0x79, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x45, 0x71, 0x75, 0x61, 0x6c, 0x73, 0x1a, 0x9e, 0x02,
	0x0a, 0x08, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f,
	0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f,
	0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x12, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72,
	0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x18, 0xf2, 0xc7, 0x31, 0x14, 0x33, 0x28, 0x30, 0x5b, 0x31, 0x2d, 0x39, 0x5d,
	0x7c, 0x5b, 0x31, 0x2d, 0x39, 0x5d, 0x5b, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x52, 0x10, 0x68, 0x74,
	0x74, 0x70, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x4d,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x73, 0x69,
	0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x35, 0x0a,
	0x17, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x57, 0x69, 0x74, 0x68, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x57, 0x69, 0x74, 0x68, 0x1a, 0xae,
	0x01, 0x0a, 0x0b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x50,
	0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x73,
	0x69, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4d, 0x0a, 0x08, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62,
	0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x65, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x08, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x22,
	0x4b, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x18, 0x0a, 0x14, 0x50,
	0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f,
	0x4c, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x52, 0x4f, 0x54,
	0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x53, 0x10, 0x02, 0x22, 0x8b, 0x11, 0x0a,
	0x0d, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x2c,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x02, 0x69, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x49, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x52,
	0x75, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x51, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x45, 0x78,
	0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c,
	0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7b, 0x0a, 0x21, 0x61, 0x62, 0x6f,
	0x72, 0x74, 0x5f, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x41, 0x66, 0x74,
	0x65, 0x72, 0x44, 0x61, 0x79, 0x73, 0x52, 0x1e, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x63,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x61, 0x72, 0x74,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x70, 0x0a, 0x15, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x4e, 0x6f,
	0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x14, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x45, 0x78,
	0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x16, 0x6e, 0x6f, 0x6e, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65,
	0x2e, 0x4e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7a, 0x0a, 0x19,
	0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79,
	0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x4e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x52,
	0x17, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x1a, 0x5c, 0x0a, 0x09, 0x41, 0x66, 0x74, 0x65,
	0x72, 0x44, 0x61, 0x79, 0x73, 0x12, 0x4f, 0x0a, 0x15, 0x64, 0x61, 0x79, 0x73, 0x5f, 0x61, 0x66,
	0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x13, 0x64, 0x61, 0x79, 0x73, 0x41, 0x66, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x69,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x5f, 0x0a, 0x17, 0x4e, 0x6f, 0x6e, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x12, 0x44, 0x0a, 0x0f, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x64, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x44, 0x61, 0x79, 0x73, 0x1a, 0x5c, 0x0a, 0x14, 0x4e, 0x6f, 0x6e, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x44, 0x0a, 0x0f, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61,
	0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x44, 0x61, 0x79, 0x73, 0x1a, 0x87, 0x01, 0x0a, 0x14, 0x4e, 0x6f, 0x6e, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44,
	0x0a, 0x0f, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x79,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x6e, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x44, 0x61, 0x79, 0x73, 0x12, 0x29, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31,
	0x01, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x1a,
	0x9e, 0x01, 0x0a, 0x0a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e,
	0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x12, 0x2f,
	0x0a, 0x04, 0x64, 0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x64, 0x61, 0x79, 0x73, 0x12,
	0x29, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x0c, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04,
	0x1a, 0xca, 0x01, 0x0a, 0x0a, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2e, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x12,
	0x2f, 0x0a, 0x04, 0x64, 0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x64, 0x61, 0x79, 0x73,
	0x12, 0x5b, 0x0a, 0x1c, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x19, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x1a, 0xca, 0x04,
	0x0a, 0x0a, 0x52, 0x75, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x12, 0x54, 0x0a, 0x18, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x15, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x47,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x54, 0x68, 0x61, 0x6e, 0x12, 0x4e, 0x0a, 0x15, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74,
	0x68, 0x61, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x69,
	0x7a, 0x65, 0x4c, 0x65, 0x73, 0x73, 0x54, 0x68, 0x61, 0x6e, 0x12, 0x2e, 0x0a, 0x03, 0x74, 0x61,
	0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x67, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x58, 0x0a, 0x0c, 0x61, 0x6e,
	0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x2e, 0x41, 0x6e, 0x64, 0x52, 0x0b, 0x61, 0x6e, 0x64, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x1a, 0xf3, 0x01, 0x0a, 0x03, 0x41, 0x6e, 0x64, 0x12, 0x16, 0x0a, 0x06,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x12, 0x54, 0x0a, 0x18, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x15, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x47,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x54, 0x68, 0x61, 0x6e, 0x12, 0x4e, 0x0a, 0x15, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74,
	0x68, 0x61, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x69,
	0x7a, 0x65, 0x4c, 0x65, 0x73, 0x73, 0x54, 0x68, 0x61, 0x6e, 0x12, 0x2e, 0x0a, 0x03, 0x74, 0x61,
	0x67, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x67, 0x52, 0x03, 0x74, 0x61, 0x67, 0x22, 0xea, 0x02, 0x0a, 0x08, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x69, 0x6d, 0x70, 0x6c,
	0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x10, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x11, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x10, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x50, 0x61, 0x72, 0x74, 0x73, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x11, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x50, 0x61, 0x72, 0x74, 0x73, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x61, 0x72, 0x74,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x14, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x61, 0x72, 0x74, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x70, 0x61, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x34, 0x0a, 0x16, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x14, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x61,
	0x72, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x76, 0x0a, 0x13, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x12, 0x3a, 0x0a, 0x0a, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0x51, 0x0a, 0x0b, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x53, 0x69,
	0x7a, 0x65, 0x22, 0x75, 0x0a, 0x0f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x42, 0x79,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x3d, 0x0a, 0x08, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x08, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x22, 0xc7, 0x05, 0x0a, 0x0b, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a,
	0x08, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x6d, 0x61,
	0x78, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x75, 0x73, 0x65, 0x64, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x63, 0x0a, 0x17, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x52, 0x14, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4d,
	0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x73, 0x12, 0x5d, 0x0a, 0x18, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52,
	0x15, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x55, 0x73, 0x65,
	0x64, 0x53, 0x69, 0x7a, 0x65, 0x73, 0x12, 0x5e, 0x0a, 0x16, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x42, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x52, 0x14, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x50, 0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x63, 0x0a, 0x16, 0x61, 0x6e, 0x6f, 0x6e,
	0x79, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x14, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f,
	0x75, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x39, 0x0a,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x74, 0x22, 0x92, 0x04, 0x0a, 0x0b, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12,
	0x36, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07,
	0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x6e, 0x73, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x64, 0x6e, 0x73, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x6e, 0x6f, 0x74, 0x5f, 0x62, 0x65, 0x66, 0x6f,
	0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x6e, 0x6f, 0x74, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x12,
	0x37, 0x0a, 0x09, 0x6e, 0x6f, 0x74, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08,
	0x6e, 0x6f, 0x74, 0x41, 0x66, 0x74, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x22,
	0x77, 0x0a, 0x0a, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a,
	0x17, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x4c, 0x46, 0x5f, 0x4d,
	0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10, 0x01, 0x12, 0x2e, 0x0a, 0x2a, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f,
	0x42, 0x59, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x4d,
	0x41, 0x4e, 0x41, 0x47, 0x45, 0x52, 0x10, 0x02, 0x22, 0xa0, 0x04, 0x0a, 0x0a, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x12, 0x4c, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x2e, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x61, 0x0a, 0x11, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xe7, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4c, 0x6f, 0x63, 0x6b,
	0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x04,
	0x64, 0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x04, 0x64, 0x61,
	0x79, 0x73, 0x12, 0x16, 0x0a, 0x05, 0x79, 0x65, 0x61, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x00, 0x52, 0x05, 0x79, 0x65, 0x61, 0x72, 0x73, 0x22, 0x46, 0x0a, 0x04, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x47, 0x4f, 0x56, 0x45, 0x52, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x13, 0x0a,
	0x0f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x49, 0x41, 0x4e, 0x43, 0x45,
	0x10, 0x02, 0x42, 0x0e, 0x0a, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x04, 0xc0, 0xc1,
	0x31, 0x01, 0x22, 0x77, 0x0a, 0x10, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4c, 0x6f, 0x63, 0x6b,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x22, 0x0a, 0x1e, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54,
	0x5f, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x4f, 0x42,
	0x4a, 0x45, 0x43, 0x54, 0x5f, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x4f,
	0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55,
	0x53, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0xb8, 0x01, 0x0a, 0x0a,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x05, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x1a, 0x60, 0x0a, 0x0e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x29, 0x0a, 0x11, 0x6b, 0x6d, 0x73, 0x5f, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6b, 0x6d, 0x73, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x49,
	0x64, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x73, 0x65, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x73, 0x65, 0x41, 0x6c, 0x67,
	0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x22, 0x66, 0x0a, 0x1d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x2b, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2a, 0x73,
	0x0a, 0x0a, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x1a, 0x0a, 0x16,
	0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x56, 0x45, 0x52, 0x53,
	0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x16, 0x0a, 0x12, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f,
	0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x56, 0x45, 0x52,
	0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45,
	0x44, 0x10, 0x03, 0x42, 0x62, 0x0a, 0x1b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x5a, 0x43, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x3b,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_storage_v1_bucket_proto_rawDescOnce sync.Once
	file_yandex_cloud_storage_v1_bucket_proto_rawDescData = file_yandex_cloud_storage_v1_bucket_proto_rawDesc
)

func file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP() []byte {
	file_yandex_cloud_storage_v1_bucket_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_storage_v1_bucket_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_storage_v1_bucket_proto_rawDescData)
	})
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescData
}

var file_yandex_cloud_storage_v1_bucket_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_yandex_cloud_storage_v1_bucket_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_yandex_cloud_storage_v1_bucket_proto_goTypes = []any{
	(Versioning)(0),                               // 0: yandex.cloud.storage.v1.Versioning
	(ACL_Grant_Permission)(0),                     // 1: yandex.cloud.storage.v1.ACL.Grant.Permission
	(ACL_Grant_GrantType)(0),                      // 2: yandex.cloud.storage.v1.ACL.Grant.GrantType
	(CorsRule_Method)(0),                          // 3: yandex.cloud.storage.v1.CorsRule.Method
	(WebsiteSettings_Protocol)(0),                 // 4: yandex.cloud.storage.v1.WebsiteSettings.Protocol
	(HTTPSConfig_SourceType)(0),                   // 5: yandex.cloud.storage.v1.HTTPSConfig.SourceType
	(ObjectLock_ObjectLockStatus)(0),              // 6: yandex.cloud.storage.v1.ObjectLock.ObjectLockStatus
	(ObjectLock_DefaultRetention_Mode)(0),         // 7: yandex.cloud.storage.v1.ObjectLock.DefaultRetention.Mode
	(*Bucket)(nil),                                // 8: yandex.cloud.storage.v1.Bucket
	(*Tag)(nil),                                   // 9: yandex.cloud.storage.v1.Tag
	(*ACL)(nil),                                   // 10: yandex.cloud.storage.v1.ACL
	(*AnonymousAccessFlags)(nil),                  // 11: yandex.cloud.storage.v1.AnonymousAccessFlags
	(*CorsRule)(nil),                              // 12: yandex.cloud.storage.v1.CorsRule
	(*WebsiteSettings)(nil),                       // 13: yandex.cloud.storage.v1.WebsiteSettings
	(*LifecycleRule)(nil),                         // 14: yandex.cloud.storage.v1.LifecycleRule
	(*Counters)(nil),                              // 15: yandex.cloud.storage.v1.Counters
	(*OptionalSizeByClass)(nil),                   // 16: yandex.cloud.storage.v1.OptionalSizeByClass
	(*SizeByClass)(nil),                           // 17: yandex.cloud.storage.v1.SizeByClass
	(*CountersByClass)(nil),                       // 18: yandex.cloud.storage.v1.CountersByClass
	(*BucketStats)(nil),                           // 19: yandex.cloud.storage.v1.BucketStats
	(*HTTPSConfig)(nil),                           // 20: yandex.cloud.storage.v1.HTTPSConfig
	(*ObjectLock)(nil),                            // 21: yandex.cloud.storage.v1.ObjectLock
	(*Encryption)(nil),                            // 22: yandex.cloud.storage.v1.Encryption
	(*BucketAllowedPrivateEndpoints)(nil),         // 23: yandex.cloud.storage.v1.BucketAllowedPrivateEndpoints
	(*ACL_Grant)(nil),                             // 24: yandex.cloud.storage.v1.ACL.Grant
	(*WebsiteSettings_Scheme)(nil),                // 25: yandex.cloud.storage.v1.WebsiteSettings.Scheme
	(*WebsiteSettings_Condition)(nil),             // 26: yandex.cloud.storage.v1.WebsiteSettings.Condition
	(*WebsiteSettings_Redirect)(nil),              // 27: yandex.cloud.storage.v1.WebsiteSettings.Redirect
	(*WebsiteSettings_RoutingRule)(nil),           // 28: yandex.cloud.storage.v1.WebsiteSettings.RoutingRule
	(*LifecycleRule_AfterDays)(nil),               // 29: yandex.cloud.storage.v1.LifecycleRule.AfterDays
	(*LifecycleRule_NoncurrentDeleteMarkers)(nil), // 30: yandex.cloud.storage.v1.LifecycleRule.NoncurrentDeleteMarkers
	(*LifecycleRule_NoncurrentExpiration)(nil),    // 31: yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration
	(*LifecycleRule_NoncurrentTransition)(nil),    // 32: yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition
	(*LifecycleRule_Transition)(nil),              // 33: yandex.cloud.storage.v1.LifecycleRule.Transition
	(*LifecycleRule_Expiration)(nil),              // 34: yandex.cloud.storage.v1.LifecycleRule.Expiration
	(*LifecycleRule_RuleFilter)(nil),              // 35: yandex.cloud.storage.v1.LifecycleRule.RuleFilter
	(*LifecycleRule_RuleFilter_And)(nil),          // 36: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.And
	(*ObjectLock_DefaultRetention)(nil),           // 37: yandex.cloud.storage.v1.ObjectLock.DefaultRetention
	(*Encryption_EncryptionRule)(nil),             // 38: yandex.cloud.storage.v1.Encryption.EncryptionRule
	(*structpb.Struct)(nil),                       // 39: google.protobuf.Struct
	(*timestamppb.Timestamp)(nil),                 // 40: google.protobuf.Timestamp
	(*wrapperspb.BoolValue)(nil),                  // 41: google.protobuf.BoolValue
	(*wrapperspb.Int64Value)(nil),                 // 42: google.protobuf.Int64Value
	(*wrapperspb.StringValue)(nil),                // 43: google.protobuf.StringValue
}
var file_yandex_cloud_storage_v1_bucket_proto_depIdxs = []int32{
	11, // 0: yandex.cloud.storage.v1.Bucket.anonymous_access_flags:type_name -> yandex.cloud.storage.v1.AnonymousAccessFlags
	0,  // 1: yandex.cloud.storage.v1.Bucket.versioning:type_name -> yandex.cloud.storage.v1.Versioning
	39, // 2: yandex.cloud.storage.v1.Bucket.policy:type_name -> google.protobuf.Struct
	10, // 3: yandex.cloud.storage.v1.Bucket.acl:type_name -> yandex.cloud.storage.v1.ACL
	40, // 4: yandex.cloud.storage.v1.Bucket.created_at:type_name -> google.protobuf.Timestamp
	12, // 5: yandex.cloud.storage.v1.Bucket.cors:type_name -> yandex.cloud.storage.v1.CorsRule
	13, // 6: yandex.cloud.storage.v1.Bucket.website_settings:type_name -> yandex.cloud.storage.v1.WebsiteSettings
	14, // 7: yandex.cloud.storage.v1.Bucket.lifecycle_rules:type_name -> yandex.cloud.storage.v1.LifecycleRule
	9,  // 8: yandex.cloud.storage.v1.Bucket.tags:type_name -> yandex.cloud.storage.v1.Tag
	21, // 9: yandex.cloud.storage.v1.Bucket.object_lock:type_name -> yandex.cloud.storage.v1.ObjectLock
	22, // 10: yandex.cloud.storage.v1.Bucket.encryption:type_name -> yandex.cloud.storage.v1.Encryption
	23, // 11: yandex.cloud.storage.v1.Bucket.allowed_private_endpoints:type_name -> yandex.cloud.storage.v1.BucketAllowedPrivateEndpoints
	24, // 12: yandex.cloud.storage.v1.ACL.grants:type_name -> yandex.cloud.storage.v1.ACL.Grant
	41, // 13: yandex.cloud.storage.v1.AnonymousAccessFlags.read:type_name -> google.protobuf.BoolValue
	41, // 14: yandex.cloud.storage.v1.AnonymousAccessFlags.list:type_name -> google.protobuf.BoolValue
	41, // 15: yandex.cloud.storage.v1.AnonymousAccessFlags.config_read:type_name -> google.protobuf.BoolValue
	3,  // 16: yandex.cloud.storage.v1.CorsRule.allowed_methods:type_name -> yandex.cloud.storage.v1.CorsRule.Method
	42, // 17: yandex.cloud.storage.v1.CorsRule.max_age_seconds:type_name -> google.protobuf.Int64Value
	25, // 18: yandex.cloud.storage.v1.WebsiteSettings.redirect_all_requests:type_name -> yandex.cloud.storage.v1.WebsiteSettings.Scheme
	28, // 19: yandex.cloud.storage.v1.WebsiteSettings.routing_rules:type_name -> yandex.cloud.storage.v1.WebsiteSettings.RoutingRule
	43, // 20: yandex.cloud.storage.v1.LifecycleRule.id:type_name -> google.protobuf.StringValue
	35, // 21: yandex.cloud.storage.v1.LifecycleRule.filter:type_name -> yandex.cloud.storage.v1.LifecycleRule.RuleFilter
	34, // 22: yandex.cloud.storage.v1.LifecycleRule.expiration:type_name -> yandex.cloud.storage.v1.LifecycleRule.Expiration
	33, // 23: yandex.cloud.storage.v1.LifecycleRule.transitions:type_name -> yandex.cloud.storage.v1.LifecycleRule.Transition
	29, // 24: yandex.cloud.storage.v1.LifecycleRule.abort_incomplete_multipart_upload:type_name -> yandex.cloud.storage.v1.LifecycleRule.AfterDays
	31, // 25: yandex.cloud.storage.v1.LifecycleRule.noncurrent_expiration:type_name -> yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration
	32, // 26: yandex.cloud.storage.v1.LifecycleRule.noncurrent_transitions:type_name -> yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition
	30, // 27: yandex.cloud.storage.v1.LifecycleRule.noncurrent_delete_markers:type_name -> yandex.cloud.storage.v1.LifecycleRule.NoncurrentDeleteMarkers
	42, // 28: yandex.cloud.storage.v1.OptionalSizeByClass.class_size:type_name -> google.protobuf.Int64Value
	15, // 29: yandex.cloud.storage.v1.CountersByClass.counters:type_name -> yandex.cloud.storage.v1.Counters
	42, // 30: yandex.cloud.storage.v1.BucketStats.max_size:type_name -> google.protobuf.Int64Value
	16, // 31: yandex.cloud.storage.v1.BucketStats.storage_class_max_sizes:type_name -> yandex.cloud.storage.v1.OptionalSizeByClass
	17, // 32: yandex.cloud.storage.v1.BucketStats.storage_class_used_sizes:type_name -> yandex.cloud.storage.v1.SizeByClass
	18, // 33: yandex.cloud.storage.v1.BucketStats.storage_class_counters:type_name -> yandex.cloud.storage.v1.CountersByClass
	43, // 34: yandex.cloud.storage.v1.BucketStats.default_storage_class:type_name -> google.protobuf.StringValue
	11, // 35: yandex.cloud.storage.v1.BucketStats.anonymous_access_flags:type_name -> yandex.cloud.storage.v1.AnonymousAccessFlags
	40, // 36: yandex.cloud.storage.v1.BucketStats.created_at:type_name -> google.protobuf.Timestamp
	40, // 37: yandex.cloud.storage.v1.BucketStats.updated_at:type_name -> google.protobuf.Timestamp
	5,  // 38: yandex.cloud.storage.v1.HTTPSConfig.source_type:type_name -> yandex.cloud.storage.v1.HTTPSConfig.SourceType
	43, // 39: yandex.cloud.storage.v1.HTTPSConfig.issuer:type_name -> google.protobuf.StringValue
	43, // 40: yandex.cloud.storage.v1.HTTPSConfig.subject:type_name -> google.protobuf.StringValue
	40, // 41: yandex.cloud.storage.v1.HTTPSConfig.not_before:type_name -> google.protobuf.Timestamp
	40, // 42: yandex.cloud.storage.v1.HTTPSConfig.not_after:type_name -> google.protobuf.Timestamp
	6,  // 43: yandex.cloud.storage.v1.ObjectLock.status:type_name -> yandex.cloud.storage.v1.ObjectLock.ObjectLockStatus
	37, // 44: yandex.cloud.storage.v1.ObjectLock.default_retention:type_name -> yandex.cloud.storage.v1.ObjectLock.DefaultRetention
	38, // 45: yandex.cloud.storage.v1.Encryption.rules:type_name -> yandex.cloud.storage.v1.Encryption.EncryptionRule
	1,  // 46: yandex.cloud.storage.v1.ACL.Grant.permission:type_name -> yandex.cloud.storage.v1.ACL.Grant.Permission
	2,  // 47: yandex.cloud.storage.v1.ACL.Grant.grant_type:type_name -> yandex.cloud.storage.v1.ACL.Grant.GrantType
	4,  // 48: yandex.cloud.storage.v1.WebsiteSettings.Scheme.protocol:type_name -> yandex.cloud.storage.v1.WebsiteSettings.Protocol
	4,  // 49: yandex.cloud.storage.v1.WebsiteSettings.Redirect.protocol:type_name -> yandex.cloud.storage.v1.WebsiteSettings.Protocol
	26, // 50: yandex.cloud.storage.v1.WebsiteSettings.RoutingRule.condition:type_name -> yandex.cloud.storage.v1.WebsiteSettings.Condition
	27, // 51: yandex.cloud.storage.v1.WebsiteSettings.RoutingRule.redirect:type_name -> yandex.cloud.storage.v1.WebsiteSettings.Redirect
	42, // 52: yandex.cloud.storage.v1.LifecycleRule.AfterDays.days_after_expiration:type_name -> google.protobuf.Int64Value
	42, // 53: yandex.cloud.storage.v1.LifecycleRule.NoncurrentDeleteMarkers.noncurrent_days:type_name -> google.protobuf.Int64Value
	42, // 54: yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration.noncurrent_days:type_name -> google.protobuf.Int64Value
	42, // 55: yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition.noncurrent_days:type_name -> google.protobuf.Int64Value
	40, // 56: yandex.cloud.storage.v1.LifecycleRule.Transition.date:type_name -> google.protobuf.Timestamp
	42, // 57: yandex.cloud.storage.v1.LifecycleRule.Transition.days:type_name -> google.protobuf.Int64Value
	40, // 58: yandex.cloud.storage.v1.LifecycleRule.Expiration.date:type_name -> google.protobuf.Timestamp
	42, // 59: yandex.cloud.storage.v1.LifecycleRule.Expiration.days:type_name -> google.protobuf.Int64Value
	41, // 60: yandex.cloud.storage.v1.LifecycleRule.Expiration.expired_object_delete_marker:type_name -> google.protobuf.BoolValue
	42, // 61: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.object_size_greater_than:type_name -> google.protobuf.Int64Value
	42, // 62: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.object_size_less_than:type_name -> google.protobuf.Int64Value
	9,  // 63: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.tag:type_name -> yandex.cloud.storage.v1.Tag
	36, // 64: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.and_operator:type_name -> yandex.cloud.storage.v1.LifecycleRule.RuleFilter.And
	42, // 65: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.And.object_size_greater_than:type_name -> google.protobuf.Int64Value
	42, // 66: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.And.object_size_less_than:type_name -> google.protobuf.Int64Value
	9,  // 67: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.And.tag:type_name -> yandex.cloud.storage.v1.Tag
	7,  // 68: yandex.cloud.storage.v1.ObjectLock.DefaultRetention.mode:type_name -> yandex.cloud.storage.v1.ObjectLock.DefaultRetention.Mode
	69, // [69:69] is the sub-list for method output_type
	69, // [69:69] is the sub-list for method input_type
	69, // [69:69] is the sub-list for extension type_name
	69, // [69:69] is the sub-list for extension extendee
	0,  // [0:69] is the sub-list for field type_name
}

func init() { file_yandex_cloud_storage_v1_bucket_proto_init() }
func file_yandex_cloud_storage_v1_bucket_proto_init() {
	if File_yandex_cloud_storage_v1_bucket_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Bucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Tag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ACL); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*AnonymousAccessFlags); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*CorsRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*WebsiteSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*LifecycleRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Counters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*OptionalSizeByClass); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*SizeByClass); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*CountersByClass); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*BucketStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*HTTPSConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*ObjectLock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*Encryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*BucketAllowedPrivateEndpoints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*ACL_Grant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*WebsiteSettings_Scheme); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*WebsiteSettings_Condition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*WebsiteSettings_Redirect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*WebsiteSettings_RoutingRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*LifecycleRule_AfterDays); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*LifecycleRule_NoncurrentDeleteMarkers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*LifecycleRule_NoncurrentExpiration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*LifecycleRule_NoncurrentTransition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[25].Exporter = func(v any, i int) any {
			switch v := v.(*LifecycleRule_Transition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[26].Exporter = func(v any, i int) any {
			switch v := v.(*LifecycleRule_Expiration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[27].Exporter = func(v any, i int) any {
			switch v := v.(*LifecycleRule_RuleFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[28].Exporter = func(v any, i int) any {
			switch v := v.(*LifecycleRule_RuleFilter_And); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[29].Exporter = func(v any, i int) any {
			switch v := v.(*ObjectLock_DefaultRetention); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_proto_msgTypes[30].Exporter = func(v any, i int) any {
			switch v := v.(*Encryption_EncryptionRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_storage_v1_bucket_proto_msgTypes[29].OneofWrappers = []any{
		(*ObjectLock_DefaultRetention_Days)(nil),
		(*ObjectLock_DefaultRetention_Years)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_storage_v1_bucket_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_storage_v1_bucket_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_storage_v1_bucket_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_storage_v1_bucket_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_storage_v1_bucket_proto_msgTypes,
	}.Build()
	File_yandex_cloud_storage_v1_bucket_proto = out.File
	file_yandex_cloud_storage_v1_bucket_proto_rawDesc = nil
	file_yandex_cloud_storage_v1_bucket_proto_goTypes = nil
	file_yandex_cloud_storage_v1_bucket_proto_depIdxs = nil
}
