// Package v3 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/egoscale/v3/generator version v0.0.1 DO NOT EDIT.
package v3

import (
	"net"
	"time"
)

type AccessKeyType string

const (
	AccessKeyTypeRestricted   AccessKeyType = "restricted"
	AccessKeyTypeUnrestricted AccessKeyType = "unrestricted"
)

type AccessKeyVersion string

const (
	AccessKeyVersionV2 AccessKeyVersion = "v2"
	AccessKeyVersionV1 AccessKeyVersion = "v1"
)

// IAM Access Key
type AccessKey struct {
	// IAM Access Key
	Key string `json:"key,omitempty"`
	// IAM Access Key name
	Name string `json:"name,omitempty"`
	// IAM Access Key operations
	Operations []string `json:"operations,omitempty"`
	// IAM Access Key Resources
	Resources []AccessKeyResource `json:"resources,omitempty"`
	// IAM Access Key Secret
	Secret string `json:"secret,omitempty"`
	// IAM Access Key tags
	Tags []string `json:"tags,omitempty"`
	// IAM Access Key type
	Type AccessKeyType `json:"type,omitempty"`
	// IAM Access Key version
	Version AccessKeyVersion `json:"version,omitempty"`
}

// Access key operation
type AccessKeyOperation struct {
	// Name of the operation
	Operation string `json:"operation,omitempty"`
	// Tags associated with the operation
	Tags []string `json:"tags,omitempty"`
}

type AccessKeyResourceDomain string

const (
	AccessKeyResourceDomainPartner AccessKeyResourceDomain = "partner"
	AccessKeyResourceDomainSOS     AccessKeyResourceDomain = "sos"
)

type AccessKeyResourceResourceType string

const (
	AccessKeyResourceResourceTypeProduct AccessKeyResourceResourceType = "product"
	AccessKeyResourceResourceTypeBucket  AccessKeyResourceResourceType = "bucket"
)

// Access key resource
type AccessKeyResource struct {
	// Resource domain
	Domain AccessKeyResourceDomain `json:"domain,omitempty"`
	// Resource name
	ResourceName string `json:"resource-name,omitempty"`
	// Resource type
	ResourceType AccessKeyResourceResourceType `json:"resource-type,omitempty"`
}

// Anti-affinity Group
type AntiAffinityGroup struct {
	// Anti-affinity Group description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Anti-affinity Group ID
	ID UUID `json:"id,omitempty"`
	// Anti-affinity Group instances
	Instances []Instance `json:"instances,omitempty"`
	// Anti-affinity Group name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
}

type BlockStorageSnapshotState string

const (
	BlockStorageSnapshotStatePartiallyDestroyed BlockStorageSnapshotState = "partially-destroyed"
	BlockStorageSnapshotStateDestroying         BlockStorageSnapshotState = "destroying"
	BlockStorageSnapshotStateCreating           BlockStorageSnapshotState = "creating"
	BlockStorageSnapshotStateCreated            BlockStorageSnapshotState = "created"
	BlockStorageSnapshotStatePromoting          BlockStorageSnapshotState = "promoting"
	BlockStorageSnapshotStateError              BlockStorageSnapshotState = "error"
	BlockStorageSnapshotStateDestroyed          BlockStorageSnapshotState = "destroyed"
	BlockStorageSnapshotStateAllocated          BlockStorageSnapshotState = "allocated"
)

// Block storage snapshot
type BlockStorageSnapshot struct {
	// Target block storage volume
	BlockStorageVolume *BlockStorageVolumeTarget `json:"block-storage-volume,omitempty"`
	// Snapshot creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Snapshot ID
	ID     UUID   `json:"id,omitempty"`
	Labels Labels `json:"labels,omitempty"`
	// Snapshot name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Snapshot size
	Size int64 `json:"size,omitempty" validate:"omitempty,gte=10"`
	// Snapshot state
	State BlockStorageSnapshotState `json:"state,omitempty"`
	// Original Volume size
	VolumeSize int64 `json:"volume-size,omitempty" validate:"omitempty,gte=0"`
}

// Target block storage snapshot
type BlockStorageSnapshotTarget struct {
	// Block storage snapshot ID
	ID UUID `json:"id,omitempty"`
}

type BlockStorageVolumeState string

const (
	BlockStorageVolumeStateSnapshotting BlockStorageVolumeState = "snapshotting"
	BlockStorageVolumeStateDeleted      BlockStorageVolumeState = "deleted"
	BlockStorageVolumeStateCreating     BlockStorageVolumeState = "creating"
	BlockStorageVolumeStateDetached     BlockStorageVolumeState = "detached"
	BlockStorageVolumeStateDeleting     BlockStorageVolumeState = "deleting"
	BlockStorageVolumeStateAttaching    BlockStorageVolumeState = "attaching"
	BlockStorageVolumeStateError        BlockStorageVolumeState = "error"
	BlockStorageVolumeStateAttached     BlockStorageVolumeState = "attached"
	BlockStorageVolumeStateDetaching    BlockStorageVolumeState = "detaching"
)

// Block storage volume
type BlockStorageVolume struct {
	// Volume snapshots, if any
	BlockStorageSnapshots []BlockStorageSnapshotTarget `json:"block-storage-snapshots,omitempty"`
	// Volume block size
	Blocksize int64 `json:"blocksize,omitempty" validate:"omitempty,gte=0"`
	// Volume creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Volume ID
	ID UUID `json:"id,omitempty"`
	// Target Instance
	Instance *InstanceTarget `json:"instance,omitempty"`
	Labels   Labels          `json:"labels,omitempty"`
	// Volume name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Volume size
	Size int64 `json:"size,omitempty" validate:"omitempty,gte=10"`
	// Volume state
	State BlockStorageVolumeState `json:"state,omitempty"`
}

// Target block storage volume
type BlockStorageVolumeTarget struct {
	// Block storage volume ID
	ID UUID `json:"id,omitempty"`
}

// DBaaS plan backup config
type DBAASBackupConfig struct {
	// Interval of taking a frequent backup in service types supporting different backup schedules
	FrequentIntervalMinutes int64 `json:"frequent-interval-minutes,omitempty" validate:"omitempty,gte=0"`
	// Maximum age of the oldest frequent backup in service types supporting different backup schedules
	FrequentOldestAgeMinutes int64 `json:"frequent-oldest-age-minutes,omitempty" validate:"omitempty,gte=0"`
	// Interval of taking a frequent backup in service types supporting different backup schedules
	InfrequentIntervalMinutes int64 `json:"infrequent-interval-minutes,omitempty" validate:"omitempty,gte=0"`
	// Maximum age of the oldest infrequent backup in service types supporting different backup schedules
	InfrequentOldestAgeMinutes int64 `json:"infrequent-oldest-age-minutes,omitempty" validate:"omitempty,gte=0"`
	// The interval, in hours, at which backups are generated.
	// For some services, like PostgreSQL, this is the interval
	// at which full snapshots are taken and continuous incremental
	// backup stream is maintained in addition to that.
	Interval int64 `json:"interval,omitempty" validate:"omitempty,gt=0"`
	// Maximum number of backups to keep. Zero when no backups are created.
	MaxCount int64 `json:"max-count,omitempty" validate:"omitempty,gte=0"`
	// Mechanism how backups can be restored. 'regular'
	// means a backup is restored as is so that the system
	// is restored to the state it was when the backup was generated.
	// 'pitr' means point-in-time-recovery, which allows restoring the system to any state since the first available full snapshot.
	RecoveryMode string `json:"recovery-mode,omitempty"`
}

type DBAASDatabaseName string

type DBAASDatadogTag struct {
	// Optional tag explanation
	Comment string `json:"comment,omitempty" validate:"omitempty,lte=1024"`
	// Tag value
	Tag string `json:"tag" validate:"required,gte=1,lte=200"`
}

type DBAASEndpointDatadogCommon struct {
	// Custom tags provided by user
	DatadogTags []DBAASDatadogTag `json:"datadog-tags,omitempty"`
	// Disable consumer group metrics
	DisableConsumerStats *bool `json:"disable-consumer-stats,omitempty"`
	// Number of separate instances to fetch kafka consumer statistics with
	KafkaConsumerCheckInstances int64 `json:"kafka-consumer-check-instances,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Number of seconds that datadog will wait to get consumer statistics from brokers
	KafkaConsumerStatsTimeout int64 `json:"kafka-consumer-stats-timeout,omitempty" validate:"omitempty,gte=2,lte=300"`
	// Maximum number of partition contexts to send
	MaxPartitionContexts int64 `json:"max-partition-contexts,omitempty" validate:"omitempty,gte=200,lte=200000"`
}

type DBAASEndpointDatadogInputCreateSettings struct {
	// Datadog API key
	DatadogAPIKey string `json:"datadog-api-key" validate:"required,gte=1,lte=256"`
	// Custom tags provided by user
	DatadogTags []DBAASDatadogTag `json:"datadog-tags,omitempty"`
	// Disable consumer group metrics
	DisableConsumerStats *bool `json:"disable-consumer-stats,omitempty"`
	// Number of separate instances to fetch kafka consumer statistics with
	KafkaConsumerCheckInstances int64 `json:"kafka-consumer-check-instances,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Number of seconds that datadog will wait to get consumer statistics from brokers
	KafkaConsumerStatsTimeout int64 `json:"kafka-consumer-stats-timeout,omitempty" validate:"omitempty,gte=2,lte=300"`
	// Maximum number of partition contexts to send
	MaxPartitionContexts int64           `json:"max-partition-contexts,omitempty" validate:"omitempty,gte=200,lte=200000"`
	Site                 EnumDatadogSite `json:"site" validate:"required"`
}

type DBAASEndpointDatadogInputCreate struct {
	Settings *DBAASEndpointDatadogInputCreateSettings `json:"settings,omitempty"`
}

type DBAASEndpointDatadogInputUpdateSettings struct {
	// Datadog API key
	DatadogAPIKey string `json:"datadog-api-key,omitempty" validate:"omitempty,gte=1,lte=256"`
	// Custom tags provided by user
	DatadogTags []DBAASDatadogTag `json:"datadog-tags,omitempty"`
	// Disable consumer group metrics
	DisableConsumerStats *bool `json:"disable-consumer-stats,omitempty"`
	// Number of separate instances to fetch kafka consumer statistics with
	KafkaConsumerCheckInstances int64 `json:"kafka-consumer-check-instances,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Number of seconds that datadog will wait to get consumer statistics from brokers
	KafkaConsumerStatsTimeout int64 `json:"kafka-consumer-stats-timeout,omitempty" validate:"omitempty,gte=2,lte=300"`
	// Maximum number of partition contexts to send
	MaxPartitionContexts int64           `json:"max-partition-contexts,omitempty" validate:"omitempty,gte=200,lte=200000"`
	Site                 EnumDatadogSite `json:"site,omitempty"`
}

type DBAASEndpointDatadogInputUpdate struct {
	Settings *DBAASEndpointDatadogInputUpdateSettings `json:"settings,omitempty"`
}

// External integration DataDog configuration
type DBAASEndpointDatadogSettingsSettings struct {
	// Custom tags provided by user
	DatadogTags []DBAASDatadogTag `json:"datadog-tags,omitempty"`
	// Disable consumer group metrics
	DisableConsumerStats *bool `json:"disable-consumer-stats,omitempty"`
	// Number of separate instances to fetch kafka consumer statistics with
	KafkaConsumerCheckInstances int64 `json:"kafka-consumer-check-instances,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Number of seconds that datadog will wait to get consumer statistics from brokers
	KafkaConsumerStatsTimeout int64 `json:"kafka-consumer-stats-timeout,omitempty" validate:"omitempty,gte=2,lte=300"`
	// Maximum number of partition contexts to send
	MaxPartitionContexts int64           `json:"max-partition-contexts,omitempty" validate:"omitempty,gte=200,lte=200000"`
	Site                 EnumDatadogSite `json:"site,omitempty"`
}

type DBAASEndpointDatadogSettings struct {
	// External integration DataDog configuration
	Settings *DBAASEndpointDatadogSettingsSettings `json:"settings,omitempty"`
}

type DBAASEndpointElasticsearch struct {
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// Elasticsearch index prefix
	IndexPrefix string `json:"index-prefix" validate:"required,gte=1,lte=1000"`
	// Elasticsearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// Elasticsearch connection URL
	URL string `json:"url" validate:"required,gte=12,lte=2048"`
}

type DBAASEndpointElasticsearchInputCreateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// Elasticsearch index prefix
	IndexPrefix string `json:"index-prefix" validate:"required,gte=1,lte=1000"`
	// Elasticsearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// Elasticsearch connection URL
	URL string `json:"url" validate:"required,gte=12,lte=2048"`
}

type DBAASEndpointElasticsearchInputCreate struct {
	Settings *DBAASEndpointElasticsearchInputCreateSettings `json:"settings,omitempty"`
}

type DBAASEndpointElasticsearchInputUpdateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// Elasticsearch index prefix
	IndexPrefix string `json:"index-prefix,omitempty" validate:"omitempty,gte=1,lte=1000"`
	// Elasticsearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// Elasticsearch connection URL
	URL string `json:"url,omitempty" validate:"omitempty,gte=12,lte=2048"`
}

type DBAASEndpointElasticsearchInputUpdate struct {
	Settings *DBAASEndpointElasticsearchInputUpdateSettings `json:"settings,omitempty"`
}

type DBAASEndpointElasticsearchOptionalFields struct {
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// Elasticsearch index prefix
	IndexPrefix string `json:"index-prefix,omitempty" validate:"omitempty,gte=1,lte=1000"`
	// Elasticsearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// Elasticsearch connection URL
	URL string `json:"url,omitempty" validate:"omitempty,gte=12,lte=2048"`
}

type DBAASEndpointElasticsearchOutput struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name     string                                    `json:"name,omitempty"`
	Settings *DBAASEndpointElasticsearchOptionalFields `json:"settings,omitempty"`
	Type     EnumExternalEndpointTypes                 `json:"type,omitempty"`
}

type DBAASEndpointElasticsearchSecrets struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
}

// External integration Prometheus configuration
type DBAASEndpointExternalPrometheusOutputSettings struct {
	// Prometheus basic authentication username
	BasicAuthUsername string `json:"basic-auth-username,omitempty" validate:"omitempty,gte=5,lte=32"`
}

type DBAASEndpointExternalPrometheusOutput struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name string `json:"name,omitempty"`
	// External integration Prometheus configuration
	Settings *DBAASEndpointExternalPrometheusOutputSettings `json:"settings,omitempty"`
	Type     EnumExternalEndpointTypes                      `json:"type,omitempty"`
}

type DBAASEndpointOpensearch struct {
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// OpenSearch index prefix
	IndexPrefix string `json:"index-prefix" validate:"required,gte=1,lte=1000"`
	// OpenSearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// OpenSearch connection URL
	URL string `json:"url" validate:"required,gte=12,lte=2048"`
}

type DBAASEndpointOpensearchInputCreateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// OpenSearch index prefix
	IndexPrefix string `json:"index-prefix" validate:"required,gte=1,lte=1000"`
	// OpenSearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// OpenSearch connection URL
	URL string `json:"url" validate:"required,gte=12,lte=2048"`
}

type DBAASEndpointOpensearchInputCreate struct {
	Settings *DBAASEndpointOpensearchInputCreateSettings `json:"settings,omitempty"`
}

type DBAASEndpointOpensearchInputUpdateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// OpenSearch index prefix
	IndexPrefix string `json:"index-prefix,omitempty" validate:"omitempty,gte=1,lte=1000"`
	// OpenSearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// OpenSearch connection URL
	URL string `json:"url,omitempty" validate:"omitempty,gte=12,lte=2048"`
}

type DBAASEndpointOpensearchInputUpdate struct {
	Settings *DBAASEndpointOpensearchInputUpdateSettings `json:"settings,omitempty"`
}

type DBAASEndpointOpensearchOptionalFields struct {
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// OpenSearch index prefix
	IndexPrefix string `json:"index-prefix,omitempty" validate:"omitempty,gte=1,lte=1000"`
	// OpenSearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// OpenSearch connection URL
	URL string `json:"url,omitempty" validate:"omitempty,gte=12,lte=2048"`
}

type DBAASEndpointOpensearchOutput struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name     string                                 `json:"name,omitempty"`
	Settings *DBAASEndpointOpensearchOptionalFields `json:"settings,omitempty"`
	Type     EnumExternalEndpointTypes              `json:"type,omitempty"`
}

type DBAASEndpointOpensearchSecrets struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
}

type DBAASEndpointPrometheus struct {
	// Prometheus basic authentication username
	BasicAuthUsername string `json:"basic-auth-username,omitempty" validate:"omitempty,gte=5,lte=32"`
}

type DBAASEndpointPrometheusPayloadSettings struct {
	// Prometheus basic authentication password
	BasicAuthPassword string `json:"basic-auth-password,omitempty" validate:"omitempty,gte=8,lte=64"`
	// Prometheus basic authentication username
	BasicAuthUsername string `json:"basic-auth-username,omitempty" validate:"omitempty,gte=5,lte=32"`
}

type DBAASEndpointPrometheusPayload struct {
	Settings *DBAASEndpointPrometheusPayloadSettings `json:"settings,omitempty"`
}

type DBAASEndpointPrometheusSecrets struct {
	// Prometheus basic authentication password
	BasicAuthPassword string `json:"basic-auth-password,omitempty" validate:"omitempty,gte=8,lte=64"`
}

type DBAASEndpointRsyslog struct {
	Format EnumRsyslogFormat `json:"format" validate:"required"`
	// Custom syslog message format
	Logline string `json:"logline,omitempty" validate:"omitempty,gte=1,lte=512"`
	// Rsyslog max message size
	MaxMessageSize int64 `json:"max-message-size,omitempty" validate:"omitempty,gte=2048,lte=2.147483647e+09"`
	// Rsyslog server port
	Port int64 `json:"port" validate:"required,gte=1,lte=65535"`
	// Structured data block for log message
	SD string `json:"sd,omitempty" validate:"omitempty,lte=1024"`
	// Rsyslog server IP address or hostname
	Server string `json:"server" validate:"required,gte=4,lte=255"`
	// Require TLS
	Tls *bool `json:"tls" validate:"required"`
}

type DBAASEndpointRsyslogInputCreateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// PEM encoded client certificate
	Cert   string            `json:"cert,omitempty" validate:"omitempty,lte=16384"`
	Format EnumRsyslogFormat `json:"format" validate:"required"`
	// PEM encoded client key
	Key string `json:"key,omitempty" validate:"omitempty,lte=16384"`
	// Custom syslog message format
	Logline string `json:"logline,omitempty" validate:"omitempty,gte=1,lte=512"`
	// Rsyslog max message size
	MaxMessageSize int64 `json:"max-message-size,omitempty" validate:"omitempty,gte=2048,lte=2.147483647e+09"`
	// Rsyslog server port
	Port int64 `json:"port" validate:"required,gte=1,lte=65535"`
	// Structured data block for log message
	SD string `json:"sd,omitempty" validate:"omitempty,lte=1024"`
	// Rsyslog server IP address or hostname
	Server string `json:"server" validate:"required,gte=4,lte=255"`
	// Require TLS
	Tls *bool `json:"tls" validate:"required"`
}

type DBAASEndpointRsyslogInputCreate struct {
	Settings *DBAASEndpointRsyslogInputCreateSettings `json:"settings,omitempty"`
}

type DBAASEndpointRsyslogInputUpdateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// PEM encoded client certificate
	Cert   string            `json:"cert,omitempty" validate:"omitempty,lte=16384"`
	Format EnumRsyslogFormat `json:"format,omitempty"`
	// PEM encoded client key
	Key string `json:"key,omitempty" validate:"omitempty,lte=16384"`
	// Custom syslog message format
	Logline string `json:"logline,omitempty" validate:"omitempty,gte=1,lte=512"`
	// Rsyslog max message size
	MaxMessageSize int64 `json:"max-message-size,omitempty" validate:"omitempty,gte=2048,lte=2.147483647e+09"`
	// Rsyslog server port
	Port int64 `json:"port,omitempty" validate:"omitempty,gte=1,lte=65535"`
	// Structured data block for log message
	SD string `json:"sd,omitempty" validate:"omitempty,lte=1024"`
	// Rsyslog server IP address or hostname
	Server string `json:"server,omitempty" validate:"omitempty,gte=4,lte=255"`
	// Require TLS
	Tls *bool `json:"tls,omitempty"`
}

type DBAASEndpointRsyslogInputUpdate struct {
	Settings *DBAASEndpointRsyslogInputUpdateSettings `json:"settings,omitempty"`
}

type DBAASEndpointRsyslogOptionalFields struct {
	Format EnumRsyslogFormat `json:"format,omitempty"`
	// Custom syslog message format
	Logline string `json:"logline,omitempty" validate:"omitempty,gte=1,lte=512"`
	// Rsyslog max message size
	MaxMessageSize int64 `json:"max-message-size,omitempty" validate:"omitempty,gte=2048,lte=2.147483647e+09"`
	// Rsyslog server port
	Port int64 `json:"port,omitempty" validate:"omitempty,gte=1,lte=65535"`
	// Structured data block for log message
	SD string `json:"sd,omitempty" validate:"omitempty,lte=1024"`
	// Rsyslog server IP address or hostname
	Server string `json:"server,omitempty" validate:"omitempty,gte=4,lte=255"`
	// Require TLS
	Tls *bool `json:"tls,omitempty"`
}

type DBAASEndpointRsyslogSecrets struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// PEM encoded client certificate
	Cert string `json:"cert,omitempty" validate:"omitempty,lte=16384"`
	// PEM encoded client key
	Key string `json:"key,omitempty" validate:"omitempty,lte=16384"`
}

type DBAASExternalEndpoint struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name string                    `json:"name,omitempty"`
	Type EnumExternalEndpointTypes `json:"type,omitempty"`
}

// External integration DataDog configuration
type DBAASExternalEndpointDatadogOutputSettings struct {
	// Custom tags provided by user
	DatadogTags []DBAASDatadogTag `json:"datadog-tags,omitempty"`
	// Disable consumer group metrics
	DisableConsumerStats *bool `json:"disable-consumer-stats,omitempty"`
	// Number of separate instances to fetch kafka consumer statistics with
	KafkaConsumerCheckInstances int64 `json:"kafka-consumer-check-instances,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Number of seconds that datadog will wait to get consumer statistics from brokers
	KafkaConsumerStatsTimeout int64 `json:"kafka-consumer-stats-timeout,omitempty" validate:"omitempty,gte=2,lte=300"`
	// Maximum number of partition contexts to send
	MaxPartitionContexts int64           `json:"max-partition-contexts,omitempty" validate:"omitempty,gte=200,lte=200000"`
	Site                 EnumDatadogSite `json:"site,omitempty"`
}

type DBAASExternalEndpointDatadogOutput struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name string `json:"name,omitempty"`
	// External integration DataDog configuration
	Settings *DBAASExternalEndpointDatadogOutputSettings `json:"settings,omitempty"`
	Type     EnumExternalEndpointTypes                   `json:"type,omitempty"`
}

type DBAASExternalEndpointRsyslogOutput struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name     string                              `json:"name,omitempty"`
	Settings *DBAASEndpointRsyslogOptionalFields `json:"settings,omitempty"`
	Type     EnumExternalEndpointTypes           `json:"type,omitempty"`
}

// Integrations with other services
type DBAASExternalIntegration struct {
	// Description of the integration
	Description string `json:"description" validate:"required"`
	// External destination endpoint id
	DestEndpointID string `json:"dest-endpoint-id,omitempty"`
	// External destination endpoint name
	DestEndpointName string `json:"dest-endpoint-name,omitempty"`
	// Endpoint integration UUID
	IntegrationID UUID `json:"integration-id,omitempty"`
	// DBaaS source service name
	SourceServiceName string               `json:"source-service-name" validate:"required"`
	SourceServiceType DBAASServiceTypeName `json:"source-service-type" validate:"required,gte=0,lte=64"`
	// Integration status
	Status string                    `json:"status,omitempty"`
	Type   EnumExternalEndpointTypes `json:"type" validate:"required"`
}

type DBAASIntegration struct {
	// Description of the integration
	Description string `json:"description,omitempty"`
	// Destination service name
	Dest string `json:"dest,omitempty"`
	// Integration id
	ID UUID `json:"id,omitempty"`
	// Whether the integration is active or not
	ISActive *bool `json:"is-active,omitempty"`
	// Whether the integration is enabled or not
	ISEnabled *bool `json:"is-enabled,omitempty"`
	// Integration settings
	Settings map[string]any `json:"settings,omitempty"`
	// Source service name
	Source string `json:"source,omitempty"`
	// Integration status
	Status string `json:"status,omitempty"`
	// Integration type
	Type string `json:"type,omitempty"`
}

type DBAASIntegrationSettingsDatadog struct {
	// Database monitoring: view query metrics, explain plans, and execution details. Correlate queries with host metrics.
	DatadogDbmEnabled *bool `json:"datadog-dbm-enabled,omitempty"`
	// Integrate PgBouncer with Datadog to track connection pool metrics and monitor application traffic.
	DatadogPgbouncerEnabled *bool `json:"datadog-pgbouncer-enabled,omitempty"`
}

// A JSON schema of additional settings of the integration.
type DBAASIntegrationTypeSettings struct {
	AdditionalProperties *bool          `json:"additionalProperties,omitempty"`
	Properties           map[string]any `json:"properties,omitempty"`
	Title                string         `json:"title,omitempty"`
	Type                 string         `json:"type,omitempty"`
}

type DBAASIntegrationType struct {
	// The description of the destination service types.
	DestDescription string `json:"dest-description,omitempty"`
	// A list of the destination service types the integration supports.
	DestServiceTypes []string `json:"dest-service-types,omitempty"`
	// A JSON schema of additional settings of the integration.
	Settings *DBAASIntegrationTypeSettings `json:"settings,omitempty"`
	// The description of the source service types.
	SourceDescription string `json:"source-description,omitempty"`
	// A list of the source service types the integration supports.
	SourceServiceTypes []string `json:"source-service-types,omitempty"`
	// The type of the integration.
	Type string `json:"type,omitempty"`
}

type DBAASKafkaAclID string

type DBAASKafkaAcls struct {
	SchemaRegistryAcl []DBAASKafkaSchemaRegistryAclEntry `json:"schema-registry-acl,omitempty"`
	TopicAcl          []DBAASKafkaTopicAclEntry          `json:"topic-acl,omitempty"`
}

type DBAASKafkaSchemaRegistryAclEntryPermission string

const (
	DBAASKafkaSchemaRegistryAclEntryPermissionSchemaRegistryRead  DBAASKafkaSchemaRegistryAclEntryPermission = "schema_registry_read"
	DBAASKafkaSchemaRegistryAclEntryPermissionSchemaRegistryWrite DBAASKafkaSchemaRegistryAclEntryPermission = "schema_registry_write"
)

type DBAASKafkaSchemaRegistryAclEntry struct {
	ID DBAASKafkaAclID `json:"id,omitempty" validate:"omitempty,gte=1,lte=40"`
	// Kafka Schema Registry permission
	Permission DBAASKafkaSchemaRegistryAclEntryPermission `json:"permission" validate:"required"`
	// Kafka Schema Registry name or pattern
	Resource string `json:"resource" validate:"required,gte=1,lte=249"`
	// Kafka username or username pattern
	Username string `json:"username" validate:"required,gte=1,lte=64"`
}

type DBAASKafkaTopicAclEntryPermission string

const (
	DBAASKafkaTopicAclEntryPermissionAdmin     DBAASKafkaTopicAclEntryPermission = "admin"
	DBAASKafkaTopicAclEntryPermissionRead      DBAASKafkaTopicAclEntryPermission = "read"
	DBAASKafkaTopicAclEntryPermissionReadwrite DBAASKafkaTopicAclEntryPermission = "readwrite"
	DBAASKafkaTopicAclEntryPermissionWrite     DBAASKafkaTopicAclEntryPermission = "write"
)

type DBAASKafkaTopicAclEntry struct {
	ID DBAASKafkaAclID `json:"id,omitempty" validate:"omitempty,gte=1,lte=40"`
	// Kafka permission
	Permission DBAASKafkaTopicAclEntryPermission `json:"permission" validate:"required"`
	// Kafka topic name or pattern
	Topic string `json:"topic" validate:"required,gte=1,lte=249"`
	// Kafka username or username pattern
	Username string `json:"username" validate:"required,gte=1,lte=64"`
}

type DBAASMigrationStatusDetails struct {
	// Migrated db name (PG) or number (Redis)
	Dbname string `json:"dbname,omitempty"`
	// Error message in case that migration has failed
	Error string `json:"error,omitempty"`
	// Migration method
	Method string              `json:"method,omitempty"`
	Status EnumMigrationStatus `json:"status,omitempty"`
}

type DBAASMigrationStatus struct {
	// Migration status per database
	Details []DBAASMigrationStatusDetails `json:"details,omitempty"`
	// Error message in case that migration has failed
	Error string `json:"error,omitempty"`
	// Redis only: how many seconds since last I/O with redis master
	MasterLastIoSecondsAgo int64                `json:"master-last-io-seconds-ago,omitempty"`
	MasterLinkStatus       EnumMasterLinkStatus `json:"master-link-status,omitempty"`
	// Migration method. Empty in case of multiple methods or error
	Method string `json:"method,omitempty"`
	// Migration status
	Status string `json:"status,omitempty"`
}

type DBAASMysqlDatabaseName string

type DBAASNodeStateRole string

const (
	DBAASNodeStateRoleStandby     DBAASNodeStateRole = "standby"
	DBAASNodeStateRoleMaster      DBAASNodeStateRole = "master"
	DBAASNodeStateRoleReadReplica DBAASNodeStateRole = "read-replica"
)

type DBAASNodeStateState string

const (
	DBAASNodeStateStateLeaving     DBAASNodeStateState = "leaving"
	DBAASNodeStateStateRunning     DBAASNodeStateState = "running"
	DBAASNodeStateStateSyncingData DBAASNodeStateState = "syncing_data"
	DBAASNodeStateStateSettingUPVm DBAASNodeStateState = "setting_up_vm"
	DBAASNodeStateStateUnknown     DBAASNodeStateState = "unknown"
)

// Automatic maintenance settings
type DBAASNodeState struct {
	// Name of the service node
	Name string `json:"name" validate:"required"`
	// Extra information regarding the progress for current state
	ProgressUpdates []DBAASNodeStateProgressUpdate `json:"progress-updates,omitempty"`
	// Role of this node. Only returned for a subset of service types
	Role DBAASNodeStateRole `json:"role,omitempty"`
	// Current state of the service node
	State DBAASNodeStateState `json:"state" validate:"required"`
}

type DBAASNodeStateProgressUpdatePhase string

const (
	DBAASNodeStateProgressUpdatePhaseStream     DBAASNodeStateProgressUpdatePhase = "stream"
	DBAASNodeStateProgressUpdatePhaseBasebackup DBAASNodeStateProgressUpdatePhase = "basebackup"
	DBAASNodeStateProgressUpdatePhasePrepare    DBAASNodeStateProgressUpdatePhase = "prepare"
	DBAASNodeStateProgressUpdatePhaseFinalize   DBAASNodeStateProgressUpdatePhase = "finalize"
)

// Extra information regarding the progress for current state
type DBAASNodeStateProgressUpdate struct {
	// Indicates whether this phase has been completed or not
	Completed *bool `json:"completed" validate:"required"`
	// Current progress for this phase. May be missing or null.
	Current int64 `json:"current,omitempty" validate:"omitempty,gte=0"`
	// Maximum progress value for this phase. May be missing or null. May change.
	Max int64 `json:"max,omitempty" validate:"omitempty,gte=0"`
	// Minimum progress value for this phase. May be missing or null.
	Min int64 `json:"min,omitempty" validate:"omitempty,gte=0"`
	// Key identifying this phase
	Phase DBAASNodeStateProgressUpdatePhase `json:"phase" validate:"required"`
	// Unit for current/min/max values. New units may be added.
	// If null should be treated as generic unit
	Unit string `json:"unit,omitempty"`
}

type DBAASOpensearchAclConfigAclsRules struct {
	// OpenSearch index pattern
	Index      string                       `json:"index" validate:"required,lte=249"`
	Permission EnumOpensearchRulePermission `json:"permission,omitempty"`
}

type DBAASOpensearchAclConfigAcls struct {
	Rules    []DBAASOpensearchAclConfigAclsRules `json:"rules,omitempty"`
	Username DBAASUserUsername                   `json:"username,omitempty" validate:"omitempty,gte=1,lte=64"`
}

type DBAASOpensearchAclConfig struct {
	// Enable OpenSearch ACLs. When disabled authenticated service users have unrestricted access.
	AclEnabled *bool `json:"acl-enabled,omitempty"`
	// List of OpenSearch ACLs
	Acls []DBAASOpensearchAclConfigAcls `json:"acls,omitempty"`
	// Enable to enforce index rules in a limited fashion for requests that use the _mget, _msearch, and _bulk APIs
	ExtendedAclEnabled *bool `json:"extended-acl-enabled,omitempty"`
}

type DBAASPGDatabaseName string

type DBAASPGPoolName string

type DBAASPGPoolSize int64

type DBAASPGPoolUsername string

type DBAASPGTargetVersions string

const (
	DBAASPGTargetVersions14 DBAASPGTargetVersions = "14"
	DBAASPGTargetVersions15 DBAASPGTargetVersions = "15"
	DBAASPGTargetVersions12 DBAASPGTargetVersions = "12"
	DBAASPGTargetVersions13 DBAASPGTargetVersions = "13"
	DBAASPGTargetVersions16 DBAASPGTargetVersions = "16"
)

// DBaaS plan
type DBAASPlan struct {
	// Requires authorization or publicly available
	Authorized *bool `json:"authorized,omitempty"`
	// DBaaS plan backup config
	BackupConfig *DBAASBackupConfig `json:"backup-config,omitempty"`
	// DBaaS plan disk space
	DiskSpace int64 `json:"disk-space,omitempty"`
	// DBaaS plan max memory allocated percentage
	MaxMemoryPercent int64 `json:"max-memory-percent,omitempty" validate:"omitempty,gt=0"`
	// DBaaS plan name
	Name string `json:"name,omitempty"`
	// DBaaS plan node count
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gt=0"`
	// DBaaS plan CPU count per node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gt=0"`
	// DBaaS plan memory count per node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gt=0"`
}

type DBAASPostgresUsersUsers struct {
	AllowReplication *bool             `json:"allow-replication,omitempty"`
	Username         DBAASUserUsername `json:"username" validate:"required,gte=1,lte=64"`
}

type DBAASPostgresUsers struct {
	Users []DBAASPostgresUsersUsers `json:"users,omitempty"`
}

// List of backups for the service
type DBAASServiceBackup struct {
	// Internal name of this backup
	BackupName string `json:"backup-name" validate:"required"`
	// Backup timestamp (ISO 8601)
	BackupTime time.Time `json:"backup-time" validate:"required"`
	// Backup's original size before compression
	DataSize int64 `json:"data-size" validate:"required,gte=0"`
}

type DBAASServiceCommon struct {
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	Name         DBAASServiceName   `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan  string           `json:"plan" validate:"required"`
	State EnumServiceState `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

type DBAASServiceComponentsRoute string

const (
	DBAASServiceComponentsRouteDynamic     DBAASServiceComponentsRoute = "dynamic"
	DBAASServiceComponentsRoutePrivate     DBAASServiceComponentsRoute = "private"
	DBAASServiceComponentsRoutePublic      DBAASServiceComponentsRoute = "public"
	DBAASServiceComponentsRoutePrivatelink DBAASServiceComponentsRoute = "privatelink"
)

type DBAASServiceComponentsUsage string

const (
	DBAASServiceComponentsUsagePrimary DBAASServiceComponentsUsage = "primary"
	DBAASServiceComponentsUsageReplica DBAASServiceComponentsUsage = "replica"
)

// Service component information objects
type DBAASServiceComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host                      string              `json:"host" validate:"required"`
	KafkaAuthenticationMethod EnumKafkaAuthMethod `json:"kafka-authentication-method,omitempty"`
	// Path component of the service URL (useful only if service component is HTTP or HTTPS endpoint)
	Path string `json:"path,omitempty"`
	// Port number for connecting to the service component
	Port int64 `json:"port" validate:"required,gte=0,lte=65535"`
	// Network access route
	Route DBAASServiceComponentsRoute `json:"route" validate:"required"`
	// Whether the endpoint is encrypted or accepts plaintext.
	// By default endpoints are always encrypted and
	// this property is only included for service components that may disable encryption.
	SSL *bool `json:"ssl,omitempty"`
	// DNS usage name
	Usage DBAASServiceComponentsUsage `json:"usage" validate:"required"`
}

type DBAASServiceGrafanaComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// Grafana connection information properties
type DBAASServiceGrafanaConnectionInfo struct {
	Password string `json:"password,omitempty"`
	URI      string `json:"uri,omitempty"`
	Username string `json:"username,omitempty"`
}

type DBAASServiceGrafanaUsers struct {
	Password string `json:"password,omitempty"`
	Type     string `json:"type,omitempty"`
	Username string `json:"username,omitempty"`
}

type DBAASServiceGrafana struct {
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceGrafanaComponents `json:"components,omitempty"`
	// Grafana connection information properties
	ConnectionInfo *DBAASServiceGrafanaConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// DbaaS service description
	Description string `json:"description,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Grafana settings
	GrafanaSettings *JSONSchemaGrafana `json:"grafana-settings,omitempty"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allowed CIDR address blocks for incoming connections
	IPFilter []string `json:"ip-filter,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	Name        DBAASServiceName         `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan  string           `json:"plan" validate:"required"`
	State EnumServiceState `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServiceGrafanaUsers `json:"users,omitempty"`
	// Grafana version
	Version string `json:"version,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

// Kafka authentication methods
type DBAASServiceKafkaAuthenticationMethods struct {
	// Whether certificate/SSL authentication is enabled
	Certificate *bool `json:"certificate,omitempty"`
	// Whether SASL authentication is enabled
	Sasl *bool `json:"sasl,omitempty"`
}

type DBAASServiceKafkaComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host                      string              `json:"host" validate:"required"`
	KafkaAuthenticationMethod EnumKafkaAuthMethod `json:"kafka-authentication-method,omitempty"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// Kafka connection information properties
type DBAASServiceKafkaConnectionInfo struct {
	AccessCert  string   `json:"access-cert,omitempty"`
	AccessKey   string   `json:"access-key,omitempty"`
	ConnectURI  string   `json:"connect-uri,omitempty"`
	Nodes       []string `json:"nodes,omitempty"`
	RegistryURI string   `json:"registry-uri,omitempty"`
	RestURI     string   `json:"rest-uri,omitempty"`
}

type DBAASServiceKafkaUsers struct {
	AccessCert       string    `json:"access-cert,omitempty"`
	AccessCertExpiry time.Time `json:"access-cert-expiry,omitempty"`
	AccessKey        string    `json:"access-key,omitempty"`
	Password         string    `json:"password,omitempty"`
	Type             string    `json:"type,omitempty"`
	Username         string    `json:"username,omitempty"`
}

type DBAASServiceKafka struct {
	// Kafka authentication methods
	AuthenticationMethods *DBAASServiceKafkaAuthenticationMethods `json:"authentication-methods,omitempty"`
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceKafkaComponents `json:"components,omitempty"`
	// Kafka connection information properties
	ConnectionInfo *DBAASServiceKafkaConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IPFilter []string `json:"ip-filter,omitempty"`
	// Whether Kafka Connect is enabled
	KafkaConnectEnabled *bool `json:"kafka-connect-enabled,omitempty"`
	// Kafka Connect configuration values
	KafkaConnectSettings JSONSchemaKafkaConnect `json:"kafka-connect-settings,omitempty"`
	// Whether Kafka REST is enabled
	KafkaRestEnabled *bool `json:"kafka-rest-enabled,omitempty"`
	// Kafka REST configuration
	KafkaRestSettings JSONSchemaKafkaRest `json:"kafka-rest-settings,omitempty"`
	// Kafka broker configuration values
	KafkaSettings JSONSchemaKafka `json:"kafka-settings,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	Name        DBAASServiceName         `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan string `json:"plan" validate:"required"`
	// Whether Schema-Registry is enabled
	SchemaRegistryEnabled *bool `json:"schema-registry-enabled,omitempty"`
	// Schema Registry configuration
	SchemaRegistrySettings JSONSchemaSchemaRegistry `json:"schema-registry-settings,omitempty"`
	State                  EnumServiceState         `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServiceKafkaUsers `json:"users,omitempty"`
	// Kafka version
	Version string `json:"version,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

type DBAASServiceLogsLogs struct {
	Message string `json:"message,omitempty"`
	Node    string `json:"node,omitempty"`
	Time    string `json:"time,omitempty"`
	Unit    string `json:"unit,omitempty"`
}

type DBAASServiceLogs struct {
	FirstLogOffset string                 `json:"first-log-offset,omitempty"`
	Logs           []DBAASServiceLogsLogs `json:"logs,omitempty"`
	Offset         string                 `json:"offset,omitempty"`
}

type DBAASServiceMaintenanceDow string

const (
	DBAASServiceMaintenanceDowSaturday  DBAASServiceMaintenanceDow = "saturday"
	DBAASServiceMaintenanceDowTuesday   DBAASServiceMaintenanceDow = "tuesday"
	DBAASServiceMaintenanceDowNever     DBAASServiceMaintenanceDow = "never"
	DBAASServiceMaintenanceDowWednesday DBAASServiceMaintenanceDow = "wednesday"
	DBAASServiceMaintenanceDowSunday    DBAASServiceMaintenanceDow = "sunday"
	DBAASServiceMaintenanceDowFriday    DBAASServiceMaintenanceDow = "friday"
	DBAASServiceMaintenanceDowMonday    DBAASServiceMaintenanceDow = "monday"
	DBAASServiceMaintenanceDowThursday  DBAASServiceMaintenanceDow = "thursday"
)

// Automatic maintenance settings
type DBAASServiceMaintenance struct {
	// Day of week for installing updates
	Dow DBAASServiceMaintenanceDow `json:"dow" validate:"required"`
	// Time for installing updates, UTC
	Time string `json:"time" validate:"required,gte=8,lte=8"`
	// List of updates waiting to be installed
	Updates []DBAASServiceUpdate `json:"updates" validate:"required"`
}

// Backup schedule
type DBAASServiceMysqlBackupSchedule struct {
	// The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
	BackupHour int64 `json:"backup-hour,omitempty" validate:"omitempty,gte=0,lte=23"`
	// The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
	BackupMinute int64 `json:"backup-minute,omitempty" validate:"omitempty,gte=0,lte=59"`
}

type DBAASServiceMysqlComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// MySQL connection information properties
type DBAASServiceMysqlConnectionInfo struct {
	Params  []map[string]string `json:"params,omitempty"`
	Standby []string            `json:"standby,omitempty"`
	URI     []string            `json:"uri,omitempty"`
}

type DBAASServiceMysqlUsers struct {
	Authentication string `json:"authentication,omitempty"`
	Password       string `json:"password,omitempty"`
	Type           string `json:"type,omitempty"`
	Username       string `json:"username,omitempty"`
}

type DBAASServiceMysql struct {
	// Backup schedule
	BackupSchedule *DBAASServiceMysqlBackupSchedule `json:"backup-schedule,omitempty"`
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceMysqlComponents `json:"components,omitempty"`
	// MySQL connection information properties
	ConnectionInfo *DBAASServiceMysqlConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// List of MySQL databases
	Databases []DBAASMysqlDatabaseName `json:"databases,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allowed CIDR address blocks for incoming connections
	IPFilter []string `json:"ip-filter,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	// mysql.conf configuration values
	MysqlSettings JSONSchemaMysql  `json:"mysql-settings,omitempty"`
	Name          DBAASServiceName `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan  string           `json:"plan" validate:"required"`
	State EnumServiceState `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServiceMysqlUsers `json:"users,omitempty"`
	// MySQL version
	Version string `json:"version,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

type DBAASServiceName string

type DBAASServiceNotificationLevel string

const (
	DBAASServiceNotificationLevelWarning DBAASServiceNotificationLevel = "warning"
	DBAASServiceNotificationLevelNotice  DBAASServiceNotificationLevel = "notice"
)

type DBAASServiceNotificationType string

const (
	DBAASServiceNotificationTypeServicePoweredOffRemoval DBAASServiceNotificationType = "service_powered_off_removal"
	DBAASServiceNotificationTypeServiceEndOfLife         DBAASServiceNotificationType = "service_end_of_life"
)

// Service notifications
type DBAASServiceNotification struct {
	// Notification level
	Level DBAASServiceNotificationLevel `json:"level" validate:"required"`
	// Human notification message
	Message string `json:"message" validate:"required,gte=1,lte=1024"`
	// Notification type
	Metadata map[string]any `json:"metadata" validate:"required"`
	// Notification type
	Type DBAASServiceNotificationType `json:"type" validate:"required"`
}

type DBAASServiceOpensearchComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// Opensearch connection information properties
type DBAASServiceOpensearchConnectionInfo struct {
	DashboardURI string   `json:"dashboard-uri,omitempty"`
	Password     string   `json:"password,omitempty"`
	URI          []string `json:"uri,omitempty"`
	Username     string   `json:"username,omitempty"`
}

type DBAASServiceOpensearchIndexPatternsSortingAlgorithm string

const (
	DBAASServiceOpensearchIndexPatternsSortingAlgorithmAlphabetical DBAASServiceOpensearchIndexPatternsSortingAlgorithm = "alphabetical"
	DBAASServiceOpensearchIndexPatternsSortingAlgorithmCreationDate DBAASServiceOpensearchIndexPatternsSortingAlgorithm = "creation_date"
)

type DBAASServiceOpensearchIndexPatterns struct {
	// Maximum number of indexes to keep
	MaxIndexCount int64 `json:"max-index-count,omitempty" validate:"omitempty,gte=0"`
	// fnmatch pattern
	Pattern string `json:"pattern,omitempty" validate:"omitempty,lte=1024"`
	// Deletion sorting algorithm
	SortingAlgorithm DBAASServiceOpensearchIndexPatternsSortingAlgorithm `json:"sorting-algorithm,omitempty"`
}

// Template settings for all new indexes
type DBAASServiceOpensearchIndexTemplate struct {
	// The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps to prevent out of memory errors when a document contains too many nested objects. Default is 10000.
	MappingNestedObjectsLimit int64 `json:"mapping-nested-objects-limit,omitempty" validate:"omitempty,gte=0,lte=100000"`
	// The number of replicas each primary shard has.
	NumberOfReplicas int64 `json:"number-of-replicas,omitempty" validate:"omitempty,gte=0,lte=29"`
	// The number of primary shards that an index should have.
	NumberOfShards int64 `json:"number-of-shards,omitempty" validate:"omitempty,gte=1,lte=1024"`
}

// OpenSearch Dashboards settings
type DBAASServiceOpensearchOpensearchDashboards struct {
	// Enable or disable OpenSearch Dashboards (default: true)
	Enabled *bool `json:"enabled,omitempty"`
	// Limits the maximum amount of memory (in MiB) the OpenSearch Dashboards process can use. This sets the max_old_space_size option of the nodejs running the OpenSearch Dashboards. Note: the memory reserved by OpenSearch Dashboards is not available for OpenSearch. (default: 128)
	MaxOldSpaceSize int64 `json:"max-old-space-size,omitempty" validate:"omitempty,gte=64,lte=1024"`
	// Timeout in milliseconds for requests made by OpenSearch Dashboards towards OpenSearch (default: 30000)
	OpensearchRequestTimeout int64 `json:"opensearch-request-timeout,omitempty" validate:"omitempty,gte=5000,lte=120000"`
}

type DBAASServiceOpensearchUsers struct {
	Password string `json:"password,omitempty"`
	Type     string `json:"type,omitempty"`
	Username string `json:"username,omitempty"`
}

type DBAASServiceOpensearch struct {
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceOpensearchComponents `json:"components,omitempty"`
	// Opensearch connection information properties
	ConnectionInfo *DBAASServiceOpensearchConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// DbaaS service description
	Description string `json:"description,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Allows you to create glob style patterns and set a max number of indexes matching this pattern you want to keep. Creating indexes exceeding this value will cause the oldest one to get deleted. You could for example create a pattern looking like 'logs.?' and then create index logs.1, logs.2 etc, it will delete logs.1 once you create logs.6. Do note 'logs.?' does not apply to logs.10. Note: Setting max_index_count to 0 will do nothing and the pattern gets ignored.
	IndexPatterns []DBAASServiceOpensearchIndexPatterns `json:"index-patterns,omitempty"`
	// Template settings for all new indexes
	IndexTemplate *DBAASServiceOpensearchIndexTemplate `json:"index-template,omitempty"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allowed CIDR address blocks for incoming connections
	IPFilter []string `json:"ip-filter,omitempty"`
	// Aiven automation resets index.refresh_interval to default value for every index to be sure that indices are always visible to search. If it doesn't fit your case, you can disable this by setting up this flag to true.
	KeepIndexRefreshInterval *bool `json:"keep-index-refresh-interval,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	// Maximum number of indexes to keep before deleting the oldest one
	MaxIndexCount int64            `json:"max-index-count,omitempty" validate:"omitempty,gte=0"`
	Name          DBAASServiceName `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// OpenSearch Dashboards settings
	OpensearchDashboards *DBAASServiceOpensearchOpensearchDashboards `json:"opensearch-dashboards,omitempty"`
	// OpenSearch settings
	OpensearchSettings JSONSchemaOpensearch `json:"opensearch-settings,omitempty"`
	// Subscription plan
	Plan  string           `json:"plan" validate:"required"`
	State EnumServiceState `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServiceOpensearchUsers `json:"users,omitempty"`
	// OpenSearch version
	Version string `json:"version,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

// Backup schedule
type DBAASServicePGBackupSchedule struct {
	// The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
	BackupHour int64 `json:"backup-hour,omitempty" validate:"omitempty,gte=0,lte=23"`
	// The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
	BackupMinute int64 `json:"backup-minute,omitempty" validate:"omitempty,gte=0,lte=59"`
}

type DBAASServicePGComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// PG connection information properties
type DBAASServicePGConnectionInfo struct {
	Params  []map[string]string `json:"params,omitempty"`
	Standby []string            `json:"standby,omitempty"`
	Syncing []string            `json:"syncing,omitempty"`
	URI     []string            `json:"uri,omitempty"`
}

type DBAASServicePGConnectionPools struct {
	// Connection URI for the DB pool
	ConnectionURI string              `json:"connection-uri" validate:"required"`
	Database      DBAASDatabaseName   `json:"database" validate:"required,gte=1,lte=40"`
	Mode          EnumPGPoolMode      `json:"mode" validate:"required"`
	Name          DBAASPGPoolName     `json:"name" validate:"required,gte=1,lte=63"`
	Size          DBAASPGPoolSize     `json:"size" validate:"required,gte=1,lte=10000"`
	Username      DBAASPGPoolUsername `json:"username" validate:"required,gte=1,lte=64"`
}

// List of service users
type DBAASServicePGUsers struct {
	AllowReplication *bool `json:"allow-replication,omitempty"`
	// Account password. A missing field indicates a user overridden password.
	Password string `json:"password,omitempty"`
	// Account type
	Type string `json:"type" validate:"required"`
	// Account username
	Username string `json:"username" validate:"required"`
}

type DBAASServicePG struct {
	// Backup schedule
	BackupSchedule *DBAASServicePGBackupSchedule `json:"backup-schedule,omitempty"`
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServicePGComponents `json:"components,omitempty"`
	// PG connection information properties
	ConnectionInfo *DBAASServicePGConnectionInfo `json:"connection-info,omitempty"`
	// PostgreSQL PGBouncer connection pools
	ConnectionPools []DBAASServicePGConnectionPools `json:"connection-pools,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// List of PostgreSQL databases
	Databases []DBAASDatabaseName `json:"databases,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allowed CIDR address blocks for incoming connections
	IPFilter []string `json:"ip-filter,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	// Maximum number of connections allowed to an instance
	MaxConnections int64            `json:"max-connections,omitempty" validate:"omitempty,gt=0"`
	Name           DBAASServiceName `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// postgresql.conf configuration values
	PGSettings JSONSchemaPG `json:"pg-settings,omitempty"`
	// System-wide settings for pgbouncer.
	PgbouncerSettings *JSONSchemaPgbouncer `json:"pgbouncer-settings,omitempty"`
	// System-wide settings for pglookout.
	PglookoutSettings *JSONSchemaPglookout `json:"pglookout-settings,omitempty"`
	// Subscription plan
	Plan string `json:"plan" validate:"required"`
	// Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
	SharedBuffersPercentage int64                        `json:"shared-buffers-percentage,omitempty" validate:"omitempty,gte=20,lte=60"`
	State                   EnumServiceState             `json:"state,omitempty"`
	SynchronousReplication  EnumPGSynchronousReplication `json:"synchronous-replication,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`
	// System-wide settings for the timescaledb extension
	TimescaledbSettings *JSONSchemaTimescaledb `json:"timescaledb-settings,omitempty"`
	Type                DBAASServiceTypeName   `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServicePGUsers `json:"users,omitempty"`
	// PostgreSQL version
	Version string `json:"version,omitempty"`
	// Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
	WorkMem int64 `json:"work-mem,omitempty" validate:"omitempty,gte=1,lte=1024"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

type DBAASServiceRedisComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	// Whether the endpoint is encrypted or accepts plaintext.
	// By default endpoints are always encrypted and
	// this property is only included for service components that may disable encryption.
	SSL   *bool              `json:"ssl,omitempty"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// Redis connection information properties
type DBAASServiceRedisConnectionInfo struct {
	Password string   `json:"password,omitempty"`
	Slave    []string `json:"slave,omitempty"`
	URI      []string `json:"uri,omitempty"`
}

type DBAASServiceRedisUsersAccessControl struct {
	Categories []string `json:"categories,omitempty"`
	Channels   []string `json:"channels,omitempty"`
	Commands   []string `json:"commands,omitempty"`
	Keys       []string `json:"keys,omitempty"`
}

type DBAASServiceRedisUsers struct {
	AccessControl *DBAASServiceRedisUsersAccessControl `json:"access-control,omitempty"`
	Password      string                               `json:"password,omitempty"`
	Type          string                               `json:"type,omitempty"`
	Username      string                               `json:"username,omitempty"`
}

type DBAASServiceRedis struct {
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceRedisComponents `json:"components,omitempty"`
	// Redis connection information properties
	ConnectionInfo *DBAASServiceRedisConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allowed CIDR address blocks for incoming connections
	IPFilter []string `json:"ip-filter,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	Name        DBAASServiceName         `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan string `json:"plan" validate:"required"`
	// Redis settings
	RedisSettings *JSONSchemaRedis `json:"redis-settings,omitempty"`
	State         EnumServiceState `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServiceRedisUsers `json:"users,omitempty"`
	// Redis version
	Version string `json:"version,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

// DBaaS service
type DBAASServiceType struct {
	// DbaaS service available versions
	AvailableVersions []string `json:"available-versions,omitempty"`
	// DbaaS service default version
	DefaultVersion string `json:"default-version,omitempty"`
	// DbaaS service description
	Description string               `json:"description,omitempty"`
	Name        DBAASServiceTypeName `json:"name,omitempty" validate:"omitempty,gte=0,lte=64"`
	// DbaaS service plans
	Plans []DBAASPlan `json:"plans,omitempty"`
}

type DBAASServiceTypeName string

// Update waiting to be installed
type DBAASServiceUpdate struct {
	// Deadline for installing the update
	Deadline time.Time `json:"deadline,omitempty"`
	// Description of the update
	Description string `json:"description,omitempty"`
	// The earliest time the update will be automatically applied
	StartAfter time.Time `json:"start-after,omitempty"`
	// The time when the update will be automatically applied
	StartAT time.Time `json:"start-at,omitempty"`
}

type DBAASTaskResultCodes struct {
	Code   string `json:"code,omitempty"`
	Dbname string `json:"dbname,omitempty"`
}

type DBAASTask struct {
	CreateTime  time.Time              `json:"create-time,omitempty"`
	ID          UUID                   `json:"id,omitempty"`
	Result      string                 `json:"result,omitempty"`
	ResultCodes []DBAASTaskResultCodes `json:"result-codes,omitempty"`
	Success     *bool                  `json:"success,omitempty"`
	TaskType    string                 `json:"task-type,omitempty"`
}

// Grafana User secrets
type DBAASUserGrafanaSecrets struct {
	// Grafana password
	Password string `json:"password,omitempty"`
	// Grafana username
	Username string `json:"username,omitempty"`
}

// Kafka Connect secrets
type DBAASUserKafkaConnectSecrets struct {
	// Kafka Connect password
	Password string `json:"password,omitempty"`
	// Kafka Connect username
	Username string `json:"username,omitempty"`
}

// Kafka User secrets
type DBAASUserKafkaSecrets struct {
	// Kafka certificate
	AccessCert       string    `json:"access-cert,omitempty"`
	AccessCertExpiry time.Time `json:"access-cert-expiry,omitempty"`
	// Kafka access key
	AccessKey string `json:"access-key,omitempty"`
	// Kafka password
	Password string `json:"password,omitempty"`
	// Kafka username
	Username string `json:"username,omitempty"`
}

// MySQL User secrets
type DBAASUserMysqlSecrets struct {
	// MySQL password
	Password string `json:"password,omitempty"`
	// MySQL username
	Username string `json:"username,omitempty"`
}

// Opensearch User secrets
type DBAASUserOpensearchSecrets struct {
	// Opensearch password
	Password string `json:"password,omitempty"`
	// Opensearch username
	Username string `json:"username,omitempty"`
}

type DBAASUserPassword string

// Postgres User secrets
type DBAASUserPostgresSecrets struct {
	// Postgres password
	Password string `json:"password,omitempty"`
	// Postgres username
	Username string `json:"username,omitempty"`
}

// Redis User secrets
type DBAASUserRedisSecrets struct {
	// Redis password
	Password string `json:"password,omitempty"`
	// Redis username
	Username string `json:"username,omitempty"`
}

type DBAASUserUsername string

type DeployTargetType string

const (
	DeployTargetTypeEdge      DeployTargetType = "edge"
	DeployTargetTypeDedicated DeployTargetType = "dedicated"
)

// Deploy target
type DeployTarget struct {
	// Deploy Target description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Deploy Target ID
	ID UUID `json:"id" validate:"required"`
	// Deploy Target name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Deploy Target type
	Type DeployTargetType `json:"type,omitempty"`
}

// DNS domain
type DNSDomain struct {
	// DNS domain creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// DNS domain ID
	ID UUID `json:"id,omitempty"`
	// DNS domain unicode name
	UnicodeName string `json:"unicode-name,omitempty" validate:"omitempty,gte=1,lte=255"`
}

type DNSDomainRecordType string

const (
	DNSDomainRecordTypeNS    DNSDomainRecordType = "NS"
	DNSDomainRecordTypeCAA   DNSDomainRecordType = "CAA"
	DNSDomainRecordTypeNAPTR DNSDomainRecordType = "NAPTR"
	DNSDomainRecordTypePOOL  DNSDomainRecordType = "POOL"
	DNSDomainRecordTypeA     DNSDomainRecordType = "A"
	DNSDomainRecordTypeHINFO DNSDomainRecordType = "HINFO"
	DNSDomainRecordTypeCNAME DNSDomainRecordType = "CNAME"
	DNSDomainRecordTypeSOA   DNSDomainRecordType = "SOA"
	DNSDomainRecordTypeSSHFP DNSDomainRecordType = "SSHFP"
	DNSDomainRecordTypeSRV   DNSDomainRecordType = "SRV"
	DNSDomainRecordTypeAAAA  DNSDomainRecordType = "AAAA"
	DNSDomainRecordTypeMX    DNSDomainRecordType = "MX"
	DNSDomainRecordTypeTXT   DNSDomainRecordType = "TXT"
	DNSDomainRecordTypeALIAS DNSDomainRecordType = "ALIAS"
	DNSDomainRecordTypeURL   DNSDomainRecordType = "URL"
	DNSDomainRecordTypeSPF   DNSDomainRecordType = "SPF"
)

// DNS domain record
type DNSDomainRecord struct {
	// DNS domain record content
	Content string `json:"content,omitempty"`
	// DNS domain record creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// DNS domain record ID
	ID UUID `json:"id,omitempty"`
	// DNS domain record name
	Name string `json:"name,omitempty"`
	// DNS domain record priority
	Priority int64 `json:"priority,omitempty" validate:"omitempty,gte=0"`
	// DNS domain record TTL
	Ttl int64 `json:"ttl,omitempty" validate:"omitempty,gte=0"`
	// DNS domain record type
	Type DNSDomainRecordType `json:"type,omitempty"`
	// DNS domain record update date
	UpdatedAT time.Time `json:"updated-at,omitempty"`
}

type DomainName string

type ElasticIPAddressfamily string

const (
	ElasticIPAddressfamilyInet4 ElasticIPAddressfamily = "inet4"
	ElasticIPAddressfamilyInet6 ElasticIPAddressfamily = "inet6"
)

// Elastic IP
type ElasticIP struct {
	// Elastic IP address family
	Addressfamily ElasticIPAddressfamily `json:"addressfamily,omitempty"`
	// Elastic IP cidr
	Cidr string `json:"cidr,omitempty"`
	// Elastic IP description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Elastic IP address healthcheck
	Healthcheck *ElasticIPHealthcheck `json:"healthcheck,omitempty"`
	// Elastic IP ID
	ID UUID `json:"id,omitempty"`
	// Elastic IP address
	IP     string `json:"ip,omitempty"`
	Labels Labels `json:"labels,omitempty"`
}

type ElasticIPHealthcheckMode string

const (
	ElasticIPHealthcheckModeTCP   ElasticIPHealthcheckMode = "tcp"
	ElasticIPHealthcheckModeHTTP  ElasticIPHealthcheckMode = "http"
	ElasticIPHealthcheckModeHttps ElasticIPHealthcheckMode = "https"
)

// Elastic IP address healthcheck
type ElasticIPHealthcheck struct {
	// Interval between the checks in seconds (default: 10)
	Interval int64 `json:"interval,omitempty" validate:"omitempty,gte=5,lte=300"`
	// Health check mode
	Mode ElasticIPHealthcheckMode `json:"mode" validate:"required"`
	// Health check port
	Port int64 `json:"port" validate:"required,gte=1,lte=65535"`
	// Number of attempts before considering the target unhealthy (default: 3)
	StrikesFail int64 `json:"strikes-fail,omitempty" validate:"omitempty,gte=1,lte=20"`
	// Number of attempts before considering the target healthy (default: 2)
	StrikesOk int64 `json:"strikes-ok,omitempty" validate:"omitempty,gte=1,lte=20"`
	// Health check timeout value in seconds (default: 2)
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=2,lte=60"`
	// Skip TLS verification
	TlsSkipVerify *bool `json:"tls-skip-verify,omitempty"`
	// An optional domain or subdomain to check TLS against
	TlsSNI string `json:"tls-sni,omitempty" validate:"omitempty,gte=1,lte=255"`
	// An endpoint to use for the health check, for example '/status'
	URI string `json:"uri,omitempty" validate:"omitempty,gte=1,lte=255"`
}

type EnumComponentRoute string

const (
	EnumComponentRouteDynamic     EnumComponentRoute = "dynamic"
	EnumComponentRoutePrivate     EnumComponentRoute = "private"
	EnumComponentRoutePublic      EnumComponentRoute = "public"
	EnumComponentRoutePrivatelink EnumComponentRoute = "privatelink"
)

type EnumComponentUsage string

const (
	EnumComponentUsagePrimary EnumComponentUsage = "primary"
	EnumComponentUsageReplica EnumComponentUsage = "replica"
)

type EnumDatadogSite string

const (
	EnumDatadogSiteUs3DatadoghqCom EnumDatadogSite = "us3.datadoghq.com"
	EnumDatadogSiteDdogGovCom      EnumDatadogSite = "ddog-gov.com"
	EnumDatadogSiteDatadoghqEU     EnumDatadogSite = "datadoghq.eu"
	EnumDatadogSiteUs5DatadoghqCom EnumDatadogSite = "us5.datadoghq.com"
	EnumDatadogSiteAp1DatadoghqCom EnumDatadogSite = "ap1.datadoghq.com"
	EnumDatadogSiteDatadoghqCom    EnumDatadogSite = "datadoghq.com"
)

type EnumExternalEndpointTypes string

const (
	EnumExternalEndpointTypesPrometheus    EnumExternalEndpointTypes = "prometheus"
	EnumExternalEndpointTypesOpensearch    EnumExternalEndpointTypes = "opensearch"
	EnumExternalEndpointTypesRsyslog       EnumExternalEndpointTypes = "rsyslog"
	EnumExternalEndpointTypesDatadog       EnumExternalEndpointTypes = "datadog"
	EnumExternalEndpointTypesElasticsearch EnumExternalEndpointTypes = "elasticsearch"
)

type EnumIntegrationTypes string

const (
	EnumIntegrationTypesDatasource EnumIntegrationTypes = "datasource"
	EnumIntegrationTypesLogs       EnumIntegrationTypes = "logs"
	EnumIntegrationTypesMetrics    EnumIntegrationTypes = "metrics"
)

type EnumKafkaAuthMethod string

const (
	EnumKafkaAuthMethodCertificate EnumKafkaAuthMethod = "certificate"
	EnumKafkaAuthMethodSasl        EnumKafkaAuthMethod = "sasl"
)

type EnumMasterLinkStatus string

const (
	EnumMasterLinkStatusUP   EnumMasterLinkStatus = "up"
	EnumMasterLinkStatusDown EnumMasterLinkStatus = "down"
)

type EnumMigrationMethod string

const (
	EnumMigrationMethodDump        EnumMigrationMethod = "dump"
	EnumMigrationMethodReplication EnumMigrationMethod = "replication"
)

type EnumMigrationStatus string

const (
	EnumMigrationStatusRunning EnumMigrationStatus = "running"
	EnumMigrationStatusSyncing EnumMigrationStatus = "syncing"
	EnumMigrationStatusFailed  EnumMigrationStatus = "failed"
	EnumMigrationStatusDone    EnumMigrationStatus = "done"
)

type EnumMysqlAuthenticationPlugin string

const (
	EnumMysqlAuthenticationPluginCachingSha2Password EnumMysqlAuthenticationPlugin = "caching_sha2_password"
	EnumMysqlAuthenticationPluginMysqlNativePassword EnumMysqlAuthenticationPlugin = "mysql_native_password"
)

type EnumOpensearchRulePermission string

const (
	EnumOpensearchRulePermissionAdmin     EnumOpensearchRulePermission = "admin"
	EnumOpensearchRulePermissionRead      EnumOpensearchRulePermission = "read"
	EnumOpensearchRulePermissionDeny      EnumOpensearchRulePermission = "deny"
	EnumOpensearchRulePermissionReadwrite EnumOpensearchRulePermission = "readwrite"
	EnumOpensearchRulePermissionWrite     EnumOpensearchRulePermission = "write"
)

type EnumPGPoolMode string

const (
	EnumPGPoolModeTransaction EnumPGPoolMode = "transaction"
	EnumPGPoolModeStatement   EnumPGPoolMode = "statement"
	EnumPGPoolModeSession     EnumPGPoolMode = "session"
)

type EnumPGSynchronousReplication string

const (
	EnumPGSynchronousReplicationQuorum EnumPGSynchronousReplication = "quorum"
	EnumPGSynchronousReplicationOff    EnumPGSynchronousReplication = "off"
)

type EnumPGVariant string

const (
	EnumPGVariantTimescale EnumPGVariant = "timescale"
	EnumPGVariantAiven     EnumPGVariant = "aiven"
)

type EnumRsyslogFormat string

const (
	EnumRsyslogFormatCustom  EnumRsyslogFormat = "custom"
	EnumRsyslogFormatRfc3164 EnumRsyslogFormat = "rfc3164"
	EnumRsyslogFormatRfc5424 EnumRsyslogFormat = "rfc5424"
)

type EnumServiceState string

const (
	EnumServiceStateRunning     EnumServiceState = "running"
	EnumServiceStateRebuilding  EnumServiceState = "rebuilding"
	EnumServiceStateRebalancing EnumServiceState = "rebalancing"
	EnumServiceStatePoweroff    EnumServiceState = "poweroff"
)

type EnumSortOrder string

const (
	EnumSortOrderDesc EnumSortOrder = "desc"
	EnumSortOrderAsc  EnumSortOrder = "asc"
)

// A notable Mutation Event which happened on the infrastructure
type Event struct {
	// Body parameters (free form map)
	BodyParams map[string]any `json:"body-params,omitempty"`
	// Operation processing time
	ElapsedMS int64 `json:"elapsed-ms,omitempty" validate:"omitempty,gt=0"`
	// Query string parameters (free form map)
	GetParams map[string]any `json:"get-params,omitempty"`
	// Operation handler name
	Handler string `json:"handler,omitempty"`
	// IAM API Key
	IAMAPIKey *IAMAPIKey `json:"iam-api-key,omitempty"`
	// IAM Role
	IAMRole *IAMRole `json:"iam-role,omitempty"`
	// User
	IAMUser *User `json:"iam-user,omitempty"`
	// Operation message
	Message string `json:"message,omitempty"`
	// URI path parameters (free form map)
	PathParams map[string]any `json:"path-params,omitempty"`
	// Operation unique identifier
	RequestID string `json:"request-id,omitempty"`
	// Client IP address
	SourceIP string `json:"source-ip,omitempty"`
	// Operation HTTP status
	Status int64 `json:"status,omitempty" validate:"omitempty,gt=0"`
	// Time at which the event happened, millisecond resolution
	Timestamp time.Time `json:"timestamp,omitempty"`
	// Operation request URI
	URI string `json:"uri,omitempty"`
	// Operation targeted zone
	Zone string `json:"zone,omitempty"`
}

// IAM API Key
type IAMAPIKey struct {
	// IAM API Key
	Key string `json:"key,omitempty"`
	// IAM API Key name
	Name string `json:"name,omitempty"`
	// IAM API Key Role ID
	RoleID UUID `json:"role-id,omitempty"`
}

// IAM API Key
type IAMAPIKeyCreated struct {
	// IAM API Key
	Key string `json:"key,omitempty"`
	// IAM API Key name
	Name string `json:"name,omitempty"`
	// IAM API Key Role ID
	RoleID UUID `json:"role-id,omitempty"`
	// IAM API Key Secret
	Secret string `json:"secret,omitempty"`
}

type IAMPolicyDefaultServiceStrategy string

const (
	IAMPolicyDefaultServiceStrategyAllow IAMPolicyDefaultServiceStrategy = "allow"
	IAMPolicyDefaultServiceStrategyDeny  IAMPolicyDefaultServiceStrategy = "deny"
)

// Policy
type IAMPolicy struct {
	// IAM default service strategy
	DefaultServiceStrategy IAMPolicyDefaultServiceStrategy `json:"default-service-strategy" validate:"required"`
	// IAM services
	Services map[string]IAMServicePolicy `json:"services" validate:"required"`
}

// IAM Role
type IAMRole struct {
	// IAM Role description
	Description string `json:"description,omitempty" validate:"omitempty,gte=1,lte=255"`
	// IAM Role mutability
	Editable *bool `json:"editable,omitempty"`
	// IAM Role ID
	ID     UUID   `json:"id,omitempty"`
	Labels Labels `json:"labels,omitempty"`
	// IAM Role name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// IAM Role permissions
	Permissions []string `json:"permissions,omitempty"`
	// Policy
	Policy *IAMPolicy `json:"policy,omitempty"`
}

type IAMServicePolicyType string

const (
	IAMServicePolicyTypeRules IAMServicePolicyType = "rules"
	IAMServicePolicyTypeAllow IAMServicePolicyType = "allow"
	IAMServicePolicyTypeDeny  IAMServicePolicyType = "deny"
)

type IAMServicePolicy struct {
	Rules []IAMServicePolicyRule `json:"rules,omitempty"`
	Type  IAMServicePolicyType   `json:"type,omitempty"`
}

type IAMServicePolicyRuleAction string

const (
	IAMServicePolicyRuleActionAllow IAMServicePolicyRuleAction = "allow"
	IAMServicePolicyRuleActionDeny  IAMServicePolicyRuleAction = "deny"
)

type IAMServicePolicyRule struct {
	Action     IAMServicePolicyRuleAction `json:"action,omitempty"`
	Expression string                     `json:"expression,omitempty"`
	Resources  []string                   `json:"resources,omitempty"`
}

// Private Network
type InstancePrivateNetworks struct {
	// Private Network ID
	ID UUID `json:"id,omitempty"`
	// Private Network MAC address
	MACAddress string `json:"mac-address,omitempty"`
}

// Instance
type Instance struct {
	// Instance Anti-affinity Groups
	AntiAffinityGroups []AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	// Instance creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`
	// Instance disk size in GiB
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=10,lte=51200"`
	// Instance Elastic IPs
	ElasticIPS []ElasticIP `json:"elastic-ips,omitempty"`
	// Instance ID
	ID UUID `json:"id,omitempty"`
	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`
	// Instance IPv6 address
	Ipv6Address string `json:"ipv6-address,omitempty"`
	Labels      Labels `json:"labels,omitempty"`
	// Instance MAC address
	MACAddress string `json:"mac-address,omitempty"`
	// Resource manager
	Manager *Manager `json:"manager,omitempty"`
	// Instance name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Instance Private Networks
	PrivateNetworks []InstancePrivateNetworks `json:"private-networks,omitempty"`
	// Instance public IPv4 address
	PublicIP           net.IP             `json:"public-ip,omitempty"`
	PublicIPAssignment PublicIPAssignment `json:"public-ip-assignment,omitempty"`
	// Instance Security Groups
	SecurityGroups []SecurityGroup `json:"security-groups,omitempty"`
	// Instance Snapshots
	Snapshots []Snapshot `json:"snapshots,omitempty"`
	// SSH key
	SSHKey *SSHKey `json:"ssh-key,omitempty"`
	// Instance SSH Keys
	SSHKeys []SSHKey      `json:"ssh-keys,omitempty"`
	State   InstanceState `json:"state,omitempty"`
	// Instance template
	Template *Template `json:"template,omitempty"`
	// Instance Cloud-init user-data (base64 encoded)
	UserData string `json:"user-data,omitempty" validate:"omitempty,gte=1"`
}

// Instance password
type InstancePassword struct {
	// Password
	Password string `json:"password,omitempty"`
}

type InstancePoolState string

const (
	InstancePoolStateScalingUP   InstancePoolState = "scaling-up"
	InstancePoolStateScalingDown InstancePoolState = "scaling-down"
	InstancePoolStateDestroying  InstancePoolState = "destroying"
	InstancePoolStateCreating    InstancePoolState = "creating"
	InstancePoolStateSuspended   InstancePoolState = "suspended"
	InstancePoolStateRunning     InstancePoolState = "running"
	InstancePoolStateUpdating    InstancePoolState = "updating"
)

// Instance Pool
type InstancePool struct {
	// Instance Pool Anti-affinity Groups
	AntiAffinityGroups []AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`
	// Instance Pool description
	Description string `json:"description,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Instances disk size in GiB
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=10,lte=51200"`
	// Instances Elastic IPs
	ElasticIPS []ElasticIP `json:"elastic-ips,omitempty"`
	// Instance Pool ID
	ID UUID `json:"id,omitempty"`
	// The instances created by the Instance Pool will be prefixed with this value (default: pool)
	InstancePrefix string `json:"instance-prefix,omitempty" validate:"omitempty,gte=1,lte=30"`
	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`
	// Instances
	Instances []Instance `json:"instances,omitempty"`
	// Enable IPv6 for instances
	Ipv6Enabled *bool  `json:"ipv6-enabled,omitempty"`
	Labels      Labels `json:"labels,omitempty"`
	// Resource manager
	Manager *Manager `json:"manager,omitempty"`
	// Minimum number of running instances
	MinAvailable int64 `json:"min-available,omitempty" validate:"omitempty,gte=0"`
	// Instance Pool name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Instance Pool Private Networks
	PrivateNetworks    []PrivateNetwork   `json:"private-networks,omitempty"`
	PublicIPAssignment PublicIPAssignment `json:"public-ip-assignment,omitempty"`
	// Instance Pool Security Groups
	SecurityGroups []SecurityGroup `json:"security-groups,omitempty"`
	// Number of instances
	Size int64 `json:"size,omitempty" validate:"omitempty,gt=0"`
	// SSH key
	SSHKey *SSHKey `json:"ssh-key,omitempty"`
	// Instances SSH keys
	SSHKeys []SSHKey `json:"ssh-keys,omitempty"`
	// Instance Pool state
	State InstancePoolState `json:"state,omitempty"`
	// Instance template
	Template *Template `json:"template,omitempty"`
	// Instances Cloud-init user-data
	UserData string `json:"user-data,omitempty" validate:"omitempty,gte=1"`
}

type InstanceState string

const (
	InstanceStateExpunging  InstanceState = "expunging"
	InstanceStateStarting   InstanceState = "starting"
	InstanceStateDestroying InstanceState = "destroying"
	InstanceStateRunning    InstanceState = "running"
	InstanceStateStopping   InstanceState = "stopping"
	InstanceStateStopped    InstanceState = "stopped"
	InstanceStateMigrating  InstanceState = "migrating"
	InstanceStateError      InstanceState = "error"
	InstanceStateDestroyed  InstanceState = "destroyed"
)

// Target Instance
type InstanceTarget struct {
	// Instance ID
	ID UUID `json:"id,omitempty"`
}

type InstanceTypeFamily string

const (
	InstanceTypeFamilyGpu3     InstanceTypeFamily = "gpu3"
	InstanceTypeFamilyGpu2     InstanceTypeFamily = "gpu2"
	InstanceTypeFamilyGpu      InstanceTypeFamily = "gpu"
	InstanceTypeFamilyMemory   InstanceTypeFamily = "memory"
	InstanceTypeFamilyStorage  InstanceTypeFamily = "storage"
	InstanceTypeFamilyStandard InstanceTypeFamily = "standard"
	InstanceTypeFamilyColossus InstanceTypeFamily = "colossus"
	InstanceTypeFamilyCPU      InstanceTypeFamily = "cpu"
)

type InstanceTypeSize string

const (
	InstanceTypeSizeLarge      InstanceTypeSize = "large"
	InstanceTypeSizeHuge       InstanceTypeSize = "huge"
	InstanceTypeSizeJumbo      InstanceTypeSize = "jumbo"
	InstanceTypeSizeMedium     InstanceTypeSize = "medium"
	InstanceTypeSizeMega       InstanceTypeSize = "mega"
	InstanceTypeSizeSmall      InstanceTypeSize = "small"
	InstanceTypeSizeExtraLarge InstanceTypeSize = "extra-large"
	InstanceTypeSizeTitan      InstanceTypeSize = "titan"
	InstanceTypeSizeMicro      InstanceTypeSize = "micro"
	InstanceTypeSizeColossus   InstanceTypeSize = "colossus"
	InstanceTypeSizeTiny       InstanceTypeSize = "tiny"
)

// Compute instance type
type InstanceType struct {
	// Requires authorization or publicly available
	Authorized *bool `json:"authorized,omitempty"`
	// CPU count
	Cpus int64 `json:"cpus,omitempty" validate:"omitempty,gt=0"`
	// Instance type family
	Family InstanceTypeFamily `json:"family,omitempty"`
	// GPU count
	Gpus int64 `json:"gpus,omitempty" validate:"omitempty,gt=0"`
	// Instance type ID
	ID UUID `json:"id,omitempty"`
	// Available memory
	Memory int64 `json:"memory,omitempty" validate:"omitempty,gt=0"`
	// Instance type size
	Size InstanceTypeSize `json:"size,omitempty"`
	// Instance Type available zones
	Zones []ZoneName `json:"zones,omitempty"`
}

type JSONSchemaGrafanaAlertingErrorORTimeout string

const (
	JSONSchemaGrafanaAlertingErrorORTimeoutAlerting  JSONSchemaGrafanaAlertingErrorORTimeout = "alerting"
	JSONSchemaGrafanaAlertingErrorORTimeoutKeepState JSONSchemaGrafanaAlertingErrorORTimeout = "keep_state"
)

type JSONSchemaGrafanaAlertingNodataORNullvalues string

const (
	JSONSchemaGrafanaAlertingNodataORNullvaluesAlerting  JSONSchemaGrafanaAlertingNodataORNullvalues = "alerting"
	JSONSchemaGrafanaAlertingNodataORNullvaluesNOData    JSONSchemaGrafanaAlertingNodataORNullvalues = "no_data"
	JSONSchemaGrafanaAlertingNodataORNullvaluesKeepState JSONSchemaGrafanaAlertingNodataORNullvalues = "keep_state"
	JSONSchemaGrafanaAlertingNodataORNullvaluesOk        JSONSchemaGrafanaAlertingNodataORNullvalues = "ok"
)

type JSONSchemaGrafanaCookieSamesite string

const (
	JSONSchemaGrafanaCookieSamesiteLax    JSONSchemaGrafanaCookieSamesite = "lax"
	JSONSchemaGrafanaCookieSamesiteStrict JSONSchemaGrafanaCookieSamesite = "strict"
	JSONSchemaGrafanaCookieSamesiteNone   JSONSchemaGrafanaCookieSamesite = "none"
)

type JSONSchemaGrafanaUserAutoAssignOrgRole string

const (
	JSONSchemaGrafanaUserAutoAssignOrgRoleViewer JSONSchemaGrafanaUserAutoAssignOrgRole = "Viewer"
	JSONSchemaGrafanaUserAutoAssignOrgRoleAdmin  JSONSchemaGrafanaUserAutoAssignOrgRole = "Admin"
	JSONSchemaGrafanaUserAutoAssignOrgRoleEditor JSONSchemaGrafanaUserAutoAssignOrgRole = "Editor"
)

// Grafana settings
type JSONSchemaGrafana struct {
	// Enable or disable Grafana legacy alerting functionality. This should not be enabled with unified_alerting_enabled.
	AlertingEnabled *bool `json:"alerting_enabled,omitempty"`
	// Default error or timeout setting for new alerting rules
	AlertingErrorORTimeout JSONSchemaGrafanaAlertingErrorORTimeout `json:"alerting_error_or_timeout,omitempty"`
	// Max number of alert annotations that Grafana stores. 0 (default) keeps all alert annotations.
	AlertingMaxAnnotationsToKeep int `json:"alerting_max_annotations_to_keep,omitempty" validate:"omitempty,gte=0,lte=1e+06"`
	// Default value for 'no data or null values' for new alerting rules
	AlertingNodataORNullvalues JSONSchemaGrafanaAlertingNodataORNullvalues `json:"alerting_nodata_or_nullvalues,omitempty"`
	// Allow embedding Grafana dashboards with iframe/frame/object/embed tags. Disabled by default to limit impact of clickjacking
	AllowEmbedding *bool `json:"allow_embedding,omitempty"`
	// Azure AD OAuth integration
	AuthAzuread map[string]any `json:"auth_azuread,omitempty"`
	// Enable or disable basic authentication form, used by Grafana built-in login
	AuthBasicEnabled *bool `json:"auth_basic_enabled,omitempty"`
	// Generic OAuth integration
	AuthGenericOauth map[string]any `json:"auth_generic_oauth,omitempty"`
	// Github Auth integration
	AuthGithub map[string]any `json:"auth_github,omitempty"`
	// GitLab Auth integration
	AuthGitlab map[string]any `json:"auth_gitlab,omitempty"`
	// Google Auth integration
	AuthGoogle map[string]any `json:"auth_google,omitempty"`
	// Cookie SameSite attribute: 'strict' prevents sending cookie for cross-site requests, effectively disabling direct linking from other sites to Grafana. 'lax' is the default value.
	CookieSamesite JSONSchemaGrafanaCookieSamesite `json:"cookie_samesite,omitempty"`
	// This feature is new in Grafana 9 and is quite resource intensive. It may cause low-end plans to work more slowly while the dashboard previews are rendering.
	DashboardPreviewsEnabled *bool `json:"dashboard_previews_enabled,omitempty"`
	// Signed sequence of decimal numbers, followed by a unit suffix (ms, s, m, h, d), e.g. 30s, 1h
	DashboardsMinRefreshInterval string `json:"dashboards_min_refresh_interval,omitempty" validate:"omitempty,lte=16"`
	// Dashboard versions to keep per dashboard
	DashboardsVersionsToKeep int `json:"dashboards_versions_to_keep,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Send 'X-Grafana-User' header to data source
	DataproxySendUserHeader *bool `json:"dataproxy_send_user_header,omitempty"`
	// Timeout for data proxy requests in seconds
	DataproxyTimeout int `json:"dataproxy_timeout,omitempty" validate:"omitempty,gte=15,lte=90"`
	// Grafana date format specifications
	DateFormats map[string]any `json:"date_formats,omitempty"`
	// Set to true to disable gravatar. Defaults to false (gravatar is enabled)
	DisableGravatar *bool `json:"disable_gravatar,omitempty"`
	// Editors can manage folders, teams and dashboards created by them
	EditorsCanAdmin *bool `json:"editors_can_admin,omitempty"`
	// Google Analytics ID
	GoogleAnalyticsUAID string `json:"google_analytics_ua_id,omitempty" validate:"omitempty,lte=64"`
	// Enable Grafana /metrics endpoint
	MetricsEnabled *bool `json:"metrics_enabled,omitempty"`
	// Enforce user lookup based on email instead of the unique ID provided by the IdP
	OauthAllowInsecureEmailLookup *bool `json:"oauth_allow_insecure_email_lookup,omitempty"`
	// Store logs for the service so that they are available in the HTTP API and console.
	ServiceLog *bool `json:"service_log,omitempty"`
	// SMTP server settings
	SMTPServer map[string]any `json:"smtp_server,omitempty"`
	// Enable or disable Grafana unified alerting functionality. By default this is enabled and any legacy alerts will be migrated on upgrade to Grafana 9+. To stay on legacy alerting, set unified_alerting_enabled to false and alerting_enabled to true. See https://grafana.com/docs/grafana/latest/alerting/set-up/migrating-alerts/ for more details.
	UnifiedAlertingEnabled *bool `json:"unified_alerting_enabled,omitempty"`
	// Auto-assign new users on signup to main organization. Defaults to false
	UserAutoAssignOrg *bool `json:"user_auto_assign_org,omitempty"`
	// Set role for new signups. Defaults to Viewer
	UserAutoAssignOrgRole JSONSchemaGrafanaUserAutoAssignOrgRole `json:"user_auto_assign_org_role,omitempty"`
	// Users with view-only permission can edit but not save dashboards
	ViewersCanEdit *bool `json:"viewers_can_edit,omitempty"`
}

// Kafka broker configuration values
type JSONSchemaKafka map[string]any

// Kafka Connect configuration values
type JSONSchemaKafkaConnect map[string]any

// Kafka REST configuration
type JSONSchemaKafkaRest map[string]any

// mysql.conf configuration values
type JSONSchemaMysql map[string]any

// OpenSearch settings
type JSONSchemaOpensearch map[string]any

// postgresql.conf configuration values
type JSONSchemaPG map[string]any

type JSONSchemaPgbouncerAutodbPoolMode string

const (
	JSONSchemaPgbouncerAutodbPoolModeTransaction JSONSchemaPgbouncerAutodbPoolMode = "transaction"
	JSONSchemaPgbouncerAutodbPoolModeSession     JSONSchemaPgbouncerAutodbPoolMode = "session"
	JSONSchemaPgbouncerAutodbPoolModeStatement   JSONSchemaPgbouncerAutodbPoolMode = "statement"
)

// System-wide settings for pgbouncer.
type JSONSchemaPgbouncer struct {
	// If the automatically created database pools have been unused this many seconds, they are freed. If 0 then timeout is disabled. [seconds]
	AutodbIdleTimeout int `json:"autodb_idle_timeout,omitempty" validate:"omitempty,gte=0,lte=86400"`
	// Do not allow more than this many server connections per database (regardless of user). Setting it to 0 means unlimited.
	AutodbMaxDBConnections int `json:"autodb_max_db_connections,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// PGBouncer pool mode
	AutodbPoolMode JSONSchemaPgbouncerAutodbPoolMode `json:"autodb_pool_mode,omitempty"`
	// If non-zero then create automatically a pool of that size per user when a pool doesn't exist.
	AutodbPoolSize int `json:"autodb_pool_size,omitempty" validate:"omitempty,gte=0,lte=10000"`
	// List of parameters to ignore when given in startup packet
	IgnoreStartupParameters []string `json:"ignore_startup_parameters,omitempty"`
	// Add more server connections to pool if below this number. Improves behavior when usual load comes suddenly back after period of total inactivity. The value is effectively capped at the pool size.
	MinPoolSize int `json:"min_pool_size,omitempty" validate:"omitempty,gte=0,lte=10000"`
	// If a server connection has been idle more than this many seconds it will be dropped. If 0 then timeout is disabled. [seconds]
	ServerIdleTimeout int `json:"server_idle_timeout,omitempty" validate:"omitempty,gte=0,lte=86400"`
	// The pooler will close an unused server connection that has been connected longer than this. [seconds]
	ServerLifetime int `json:"server_lifetime,omitempty" validate:"omitempty,gte=60,lte=86400"`
	// Run server_reset_query (DISCARD ALL) in all pooling modes
	ServerResetQueryAlways *bool `json:"server_reset_query_always,omitempty"`
}

// System-wide settings for pglookout.
type JSONSchemaPglookout struct {
	// Number of seconds of master unavailability before triggering database failover to standby
	MaxFailoverReplicationTimeLag int `json:"max_failover_replication_time_lag,omitempty" validate:"omitempty,gte=10,lte=9.223372036854776e+18"`
}

type JSONSchemaRedisAclChannelsDefault string

const (
	JSONSchemaRedisAclChannelsDefaultAllchannels   JSONSchemaRedisAclChannelsDefault = "allchannels"
	JSONSchemaRedisAclChannelsDefaultResetchannels JSONSchemaRedisAclChannelsDefault = "resetchannels"
)

type JSONSchemaRedisMaxmemoryPolicy string

const (
	JSONSchemaRedisMaxmemoryPolicyNoeviction     JSONSchemaRedisMaxmemoryPolicy = "noeviction"
	JSONSchemaRedisMaxmemoryPolicyAllkeysLru     JSONSchemaRedisMaxmemoryPolicy = "allkeys-lru"
	JSONSchemaRedisMaxmemoryPolicyVolatileLru    JSONSchemaRedisMaxmemoryPolicy = "volatile-lru"
	JSONSchemaRedisMaxmemoryPolicyAllkeysRandom  JSONSchemaRedisMaxmemoryPolicy = "allkeys-random"
	JSONSchemaRedisMaxmemoryPolicyVolatileRandom JSONSchemaRedisMaxmemoryPolicy = "volatile-random"
	JSONSchemaRedisMaxmemoryPolicyVolatileTtl    JSONSchemaRedisMaxmemoryPolicy = "volatile-ttl"
	JSONSchemaRedisMaxmemoryPolicyVolatileLfu    JSONSchemaRedisMaxmemoryPolicy = "volatile-lfu"
	JSONSchemaRedisMaxmemoryPolicyAllkeysLfu     JSONSchemaRedisMaxmemoryPolicy = "allkeys-lfu"
)

type JSONSchemaRedisPersistence string

const (
	JSONSchemaRedisPersistenceOff JSONSchemaRedisPersistence = "off"
	JSONSchemaRedisPersistenceRdb JSONSchemaRedisPersistence = "rdb"
)

// Redis settings
type JSONSchemaRedis struct {
	// Determines default pub/sub channels' ACL for new users if ACL is not supplied. When this option is not defined, all_channels is assumed to keep backward compatibility. This option doesn't affect Redis configuration acl-pubsub-default.
	AclChannelsDefault JSONSchemaRedisAclChannelsDefault `json:"acl_channels_default,omitempty"`
	// Set Redis IO thread count. Changing this will cause a restart of the Redis service.
	IoThreads int `json:"io_threads,omitempty" validate:"omitempty,gte=1,lte=32"`
	// LFU maxmemory-policy counter decay time in minutes
	LfuDecayTime int `json:"lfu_decay_time,omitempty" validate:"omitempty,gte=1,lte=120"`
	// Counter logarithm factor for volatile-lfu and allkeys-lfu maxmemory-policies
	LfuLogFactor int `json:"lfu_log_factor,omitempty" validate:"omitempty,gte=0,lte=100"`
	// Redis maxmemory-policy
	MaxmemoryPolicy JSONSchemaRedisMaxmemoryPolicy `json:"maxmemory_policy,omitempty"`
	// Set notify-keyspace-events option
	NotifyKeyspaceEvents string `json:"notify_keyspace_events,omitempty" validate:"omitempty,lte=32"`
	// Set number of Redis databases. Changing this will cause a restart of the Redis service.
	NumberOfDatabases int `json:"number_of_databases,omitempty" validate:"omitempty,gte=1,lte=128"`
	// When persistence is 'rdb', Redis does RDB dumps each 10 minutes if any key is changed. Also RDB dumps are done according to backup schedule for backup purposes. When persistence is 'off', no RDB dumps and backups are done, so data can be lost at any moment if service is restarted for any reason, or if service is powered off. Also service can't be forked.
	Persistence JSONSchemaRedisPersistence `json:"persistence,omitempty"`
	// Set output buffer limit for pub / sub clients in MB. The value is the hard limit, the soft limit is 1/4 of the hard limit. When setting the limit, be mindful of the available memory in the selected service plan.
	PubsubClientOutputBufferLimit int `json:"pubsub_client_output_buffer_limit,omitempty" validate:"omitempty,gte=32,lte=512"`
	// Require SSL to access Redis
	SSL *bool `json:"ssl,omitempty"`
	// Redis idle connection timeout in seconds
	Timeout int `json:"timeout,omitempty" validate:"omitempty,gte=0,lte=3.1536e+07"`
}

// Schema Registry configuration
type JSONSchemaSchemaRegistry map[string]any

// System-wide settings for the timescaledb extension
type JSONSchemaTimescaledb struct {
	// The number of background workers for timescaledb operations. You should configure this setting to the sum of your number of databases and the total number of concurrent background workers you want running at any given point in time.
	MaxBackgroundWorkers int `json:"max_background_workers,omitempty" validate:"omitempty,gte=1,lte=4096"`
}

// Kubelet image GC options
type KubeletImageGC struct {
	HighThreshold int64  `json:"high-threshold,omitempty" validate:"omitempty,gte=0"`
	LowThreshold  int64  `json:"low-threshold,omitempty" validate:"omitempty,gte=0"`
	MinAge        string `json:"min-age,omitempty"`
}

type Labels map[string]string

type LoadBalancerState string

const (
	LoadBalancerStateCreating  LoadBalancerState = "creating"
	LoadBalancerStateMigrated  LoadBalancerState = "migrated"
	LoadBalancerStateDeleting  LoadBalancerState = "deleting"
	LoadBalancerStateRunning   LoadBalancerState = "running"
	LoadBalancerStateMigrating LoadBalancerState = "migrating"
	LoadBalancerStateError     LoadBalancerState = "error"
)

// Load Balancer
type LoadBalancer struct {
	// Load Balancer creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Load Balancer description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Load Balancer ID
	ID UUID `json:"id,omitempty"`
	// Load Balancer public IP
	IP     net.IP `json:"ip,omitempty"`
	Labels Labels `json:"labels,omitempty"`
	// Load Balancer name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Load Balancer Services
	Services []LoadBalancerService `json:"services,omitempty"`
	// Load Balancer state
	State LoadBalancerState `json:"state,omitempty"`
}

type LoadBalancerServerStatusStatus string

const (
	LoadBalancerServerStatusStatusFailure LoadBalancerServerStatusStatus = "failure"
	LoadBalancerServerStatusStatusSuccess LoadBalancerServerStatusStatus = "success"
)

// Load Balancer Service status
type LoadBalancerServerStatus struct {
	// Backend server public IP
	PublicIP net.IP `json:"public-ip,omitempty"`
	// Status of the instance's healthcheck
	Status LoadBalancerServerStatusStatus `json:"status,omitempty"`
}

type LoadBalancerServiceProtocol string

const (
	LoadBalancerServiceProtocolTCP LoadBalancerServiceProtocol = "tcp"
	LoadBalancerServiceProtocolUDP LoadBalancerServiceProtocol = "udp"
)

type LoadBalancerServiceState string

const (
	LoadBalancerServiceStateCreating LoadBalancerServiceState = "creating"
	LoadBalancerServiceStateDeleting LoadBalancerServiceState = "deleting"
	LoadBalancerServiceStateRunning  LoadBalancerServiceState = "running"
	LoadBalancerServiceStateUpdating LoadBalancerServiceState = "updating"
	LoadBalancerServiceStateError    LoadBalancerServiceState = "error"
)

type LoadBalancerServiceStrategy string

const (
	LoadBalancerServiceStrategyRoundRobin LoadBalancerServiceStrategy = "round-robin"
	LoadBalancerServiceStrategyMaglevHash LoadBalancerServiceStrategy = "maglev-hash"
	LoadBalancerServiceStrategySourceHash LoadBalancerServiceStrategy = "source-hash"
)

// Load Balancer Service
type LoadBalancerService struct {
	// Load Balancer Service description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Load Balancer Service healthcheck
	Healthcheck *LoadBalancerServiceHealthcheck `json:"healthcheck,omitempty"`
	// Healthcheck status per backend server
	HealthcheckStatus []LoadBalancerServerStatus `json:"healthcheck-status,omitempty"`
	// Load Balancer Service ID
	ID UUID `json:"id,omitempty"`
	// Instance Pool
	InstancePool *InstancePool `json:"instance-pool,omitempty"`
	// Load Balancer Service name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Port exposed on the Load Balancer's public IP
	Port int64 `json:"port,omitempty" validate:"omitempty,gt=0"`
	// Network traffic protocol
	Protocol LoadBalancerServiceProtocol `json:"protocol,omitempty"`
	// Load Balancer Service state
	State LoadBalancerServiceState `json:"state,omitempty"`
	// Load balancing strategy
	Strategy LoadBalancerServiceStrategy `json:"strategy,omitempty"`
	// Port on which the network traffic will be forwarded to on the receiving instance
	TargetPort int64 `json:"target-port,omitempty" validate:"omitempty,gt=0"`
}

type LoadBalancerServiceHealthcheckMode string

const (
	LoadBalancerServiceHealthcheckModeTCP   LoadBalancerServiceHealthcheckMode = "tcp"
	LoadBalancerServiceHealthcheckModeHTTP  LoadBalancerServiceHealthcheckMode = "http"
	LoadBalancerServiceHealthcheckModeHttps LoadBalancerServiceHealthcheckMode = "https"
)

// Load Balancer Service healthcheck
type LoadBalancerServiceHealthcheck struct {
	// Healthcheck interval (default: 10). Must be greater than or equal to Timeout
	Interval int64 `json:"interval,omitempty" validate:"omitempty,gte=5,lte=300"`
	// Healthcheck mode
	Mode LoadBalancerServiceHealthcheckMode `json:"mode,omitempty"`
	// Healthcheck port
	Port int64 `json:"port,omitempty" validate:"omitempty,gte=1,lte=65535"`
	// Number of retries before considering a Service failed
	Retries int64 `json:"retries,omitempty" validate:"omitempty,gte=1,lte=20"`
	// Healthcheck timeout value (default: 2). Must be lower than or equal to Interval
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=2,lte=60"`
	// SNI domain for HTTPS healthchecks
	TlsSNI string `json:"tls-sni,omitempty" validate:"omitempty,gte=1,lte=255"`
	// An endpoint to use for the HTTP healthcheck, e.g. '/status'
	URI string `json:"uri,omitempty" validate:"omitempty,gte=1,lte=255"`
}

type ManagerType string

const (
	ManagerTypeSKSNodepool  ManagerType = "sks-nodepool"
	ManagerTypeInstancePool ManagerType = "instance-pool"
)

// Resource manager
type Manager struct {
	// Manager ID
	ID UUID `json:"id,omitempty"`
	// Manager type
	Type ManagerType `json:"type,omitempty"`
}

type OperationReason string

const (
	OperationReasonIncorrect   OperationReason = "incorrect"
	OperationReasonUnknown     OperationReason = "unknown"
	OperationReasonUnavailable OperationReason = "unavailable"
	OperationReasonForbidden   OperationReason = "forbidden"
	OperationReasonBusy        OperationReason = "busy"
	OperationReasonFault       OperationReason = "fault"
	OperationReasonPartial     OperationReason = "partial"
	OperationReasonNotFound    OperationReason = "not-found"
	OperationReasonInterrupted OperationReason = "interrupted"
	OperationReasonUnsupported OperationReason = "unsupported"
	OperationReasonConflict    OperationReason = "conflict"
)

// Related resource reference
type OperationReference struct {
	// Command name
	Command string `json:"command,omitempty"`
	// Reference ID
	ID UUID `json:"id,omitempty"`
	// Link to the referenced resource
	Link string `json:"link,omitempty"`
}

type OperationState string

const (
	OperationStateFailure OperationState = "failure"
	OperationStatePending OperationState = "pending"
	OperationStateSuccess OperationState = "success"
	OperationStateTimeout OperationState = "timeout"
)

// Operation
type Operation struct {
	// Operation ID
	ID UUID `json:"id,omitempty"`
	// Operation message
	Message string `json:"message,omitempty"`
	// Operation failure reason
	Reason OperationReason `json:"reason,omitempty"`
	// Related resource reference
	Reference *OperationReference `json:"reference,omitempty"`
	// Operation status
	State OperationState `json:"state,omitempty"`
}

// Organization
type Organization struct {
	// Organization address
	Address string `json:"address,omitempty"`
	// Organization balance
	Balance float64 `json:"balance,omitempty"`
	// Organization city
	City string `json:"city,omitempty"`
	// Organization country
	Country string `json:"country,omitempty"`
	// Organization currency
	Currency string `json:"currency,omitempty"`
	// Organization ID
	ID UUID `json:"id,omitempty"`
	// Organization name
	Name string `json:"name,omitempty"`
	// Organization postcode
	Postcode string `json:"postcode,omitempty"`
}

// Private Network
type PrivateNetwork struct {
	// Private Network description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Private Network end IP address
	EndIP net.IP `json:"end-ip,omitempty"`
	// Private Network ID
	ID     UUID   `json:"id,omitempty"`
	Labels Labels `json:"labels,omitempty"`
	// Private Network leased IP addresses
	Leases []PrivateNetworkLease `json:"leases,omitempty"`
	// Private Network name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Private Network netmask
	Netmask net.IP `json:"netmask,omitempty"`
	// Private Network DHCP Options
	Options *PrivateNetworkOptions `json:"options,omitempty"`
	// Private Network start IP address
	StartIP net.IP `json:"start-ip,omitempty"`
	// Private Network VXLAN ID
	Vni int64 `json:"vni,omitempty" validate:"omitempty,gt=0"`
}

// Private Network leased IP address
type PrivateNetworkLease struct {
	// Attached instance ID
	InstanceID UUID `json:"instance-id,omitempty"`
	// Private Network IP address
	IP net.IP `json:"ip,omitempty"`
}

// Private Network DHCP Options
type PrivateNetworkOptions struct {
	// DNS Servers
	DNSServers []net.IP `json:"dns-servers,omitempty"`
	// Routers
	Routers []net.IP `json:"routers,omitempty"`
}

type PublicIPAssignment string

const (
	PublicIPAssignmentInet4 PublicIPAssignment = "inet4"
	PublicIPAssignmentDual  PublicIPAssignment = "dual"
	PublicIPAssignmentNone  PublicIPAssignment = "none"
)

// Organization Quota
type Quota struct {
	// Resource Limit. -1 for Unlimited
	Limit int64 `json:"limit,omitempty"`
	// Resource Name
	Resource string `json:"resource,omitempty"`
	// Resource Usage
	Usage int64 `json:"usage,omitempty"`
}

// Resource
type Resource struct {
	// Resource ID
	ID UUID `json:"id,omitempty"`
	// Resource name
	Name string `json:"name,omitempty"`
}

type ReverseDNSRecord struct {
	DomainName DomainName `json:"domain-name,omitempty" validate:"omitempty,gte=1,lte=253"`
}

// Security Group
type SecurityGroup struct {
	// Security Group description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Security Group external sources
	ExternalSources []string `json:"external-sources,omitempty"`
	// Security Group ID
	ID UUID `json:"id,omitempty"`
	// Security Group name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Security Group rules
	Rules []SecurityGroupRule `json:"rules,omitempty"`
}

type SecurityGroupResourceVisibility string

const (
	SecurityGroupResourceVisibilityPrivate SecurityGroupResourceVisibility = "private"
	SecurityGroupResourceVisibilityPublic  SecurityGroupResourceVisibility = "public"
)

// Security Group
type SecurityGroupResource struct {
	// Security Group ID
	ID UUID `json:"id,omitempty"`
	// Security Group name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Whether this points to a public security group. This is only valid when in the context of
	// a rule addition which uses a public security group as a source or destination.
	Visibility SecurityGroupResourceVisibility `json:"visibility,omitempty"`
}

type SecurityGroupRuleFlowDirection string

const (
	SecurityGroupRuleFlowDirectionIngress SecurityGroupRuleFlowDirection = "ingress"
	SecurityGroupRuleFlowDirectionEgress  SecurityGroupRuleFlowDirection = "egress"
)

// ICMP details
type SecurityGroupRuleICMP struct {
	Code int64 `json:"code,omitempty" validate:"omitempty,gte=-1,lte=254"`
	Type int64 `json:"type,omitempty" validate:"omitempty,gte=-1,lte=254"`
}

type SecurityGroupRuleProtocol string

const (
	SecurityGroupRuleProtocolTCP    SecurityGroupRuleProtocol = "tcp"
	SecurityGroupRuleProtocolEsp    SecurityGroupRuleProtocol = "esp"
	SecurityGroupRuleProtocolICMP   SecurityGroupRuleProtocol = "icmp"
	SecurityGroupRuleProtocolUDP    SecurityGroupRuleProtocol = "udp"
	SecurityGroupRuleProtocolGre    SecurityGroupRuleProtocol = "gre"
	SecurityGroupRuleProtocolAh     SecurityGroupRuleProtocol = "ah"
	SecurityGroupRuleProtocolIpip   SecurityGroupRuleProtocol = "ipip"
	SecurityGroupRuleProtocolIcmpv6 SecurityGroupRuleProtocol = "icmpv6"
)

// Security Group rule
type SecurityGroupRule struct {
	// Security Group rule description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// End port of the range
	EndPort int64 `json:"end-port,omitempty" validate:"omitempty,gte=1,lte=65535"`
	// Network flow direction to match
	FlowDirection SecurityGroupRuleFlowDirection `json:"flow-direction,omitempty"`
	// ICMP details
	ICMP *SecurityGroupRuleICMP `json:"icmp,omitempty"`
	// Security Group rule ID
	ID UUID `json:"id,omitempty"`
	// CIDR-formatted network allowed
	Network string `json:"network,omitempty"`
	// Network protocol
	Protocol SecurityGroupRuleProtocol `json:"protocol,omitempty"`
	// Security Group
	SecurityGroup *SecurityGroupResource `json:"security-group,omitempty"`
	// Start port of the range
	StartPort int64 `json:"start-port,omitempty" validate:"omitempty,gte=1,lte=65535"`
}

type SKSClusterCni string

const (
	SKSClusterCniCalico SKSClusterCni = "calico"
	SKSClusterCniCilium SKSClusterCni = "cilium"
)

type SKSClusterLevel string

const (
	SKSClusterLevelStarter SKSClusterLevel = "starter"
	SKSClusterLevelPro     SKSClusterLevel = "pro"
)

type SKSClusterState string

const (
	SKSClusterStateRotatingCcmCredentials SKSClusterState = "rotating-ccm-credentials"
	SKSClusterStateCreating               SKSClusterState = "creating"
	SKSClusterStateUpgrading              SKSClusterState = "upgrading"
	SKSClusterStateDeleting               SKSClusterState = "deleting"
	SKSClusterStateRunning                SKSClusterState = "running"
	SKSClusterStateSuspending             SKSClusterState = "suspending"
	SKSClusterStateUpdating               SKSClusterState = "updating"
	SKSClusterStateError                  SKSClusterState = "error"
)

// SKS Cluster
type SKSCluster struct {
	// Cluster addons
	Addons []string `json:"addons,omitempty"`
	// Enable auto upgrade of the control plane to the latest patch version available
	AutoUpgrade *bool `json:"auto-upgrade,omitempty"`
	// Cluster CNI
	Cni SKSClusterCni `json:"cni,omitempty"`
	// Cluster creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Cluster description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Cluster endpoint
	Endpoint string `json:"endpoint,omitempty"`
	// Cluster ID
	ID     UUID   `json:"id,omitempty"`
	Labels Labels `json:"labels,omitempty"`
	// Cluster level
	Level SKSClusterLevel `json:"level,omitempty"`
	// Cluster name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Cluster Nodepools
	Nodepools []SKSNodepool `json:"nodepools,omitempty"`
	// Cluster state
	State SKSClusterState `json:"state,omitempty"`
	// Control plane Kubernetes version
	Version string `json:"version,omitempty"`
}

type SKSClusterDeprecatedResource map[string]string

// Kubeconfig request for a SKS cluster
type SKSKubeconfigRequest struct {
	// List of roles. The certificate present in the Kubeconfig will have these roles set in the Org field.
	Groups []string `json:"groups,omitempty"`
	// Validity in seconds of the Kubeconfig user certificate (default: 30 days)
	Ttl int64 `json:"ttl,omitempty" validate:"omitempty,gt=0"`
	// User name in the generated Kubeconfig. The certificate present in the Kubeconfig will also have this name set for the CN field.
	User string `json:"user,omitempty"`
}

type SKSNodepoolPublicIPAssignment string

const (
	SKSNodepoolPublicIPAssignmentInet4 SKSNodepoolPublicIPAssignment = "inet4"
	SKSNodepoolPublicIPAssignmentDual  SKSNodepoolPublicIPAssignment = "dual"
)

type SKSNodepoolState string

const (
	SKSNodepoolStateRenewingToken SKSNodepoolState = "renewing-token"
	SKSNodepoolStateCreating      SKSNodepoolState = "creating"
	SKSNodepoolStateDeleting      SKSNodepoolState = "deleting"
	SKSNodepoolStateRunning       SKSNodepoolState = "running"
	SKSNodepoolStateScaling       SKSNodepoolState = "scaling"
	SKSNodepoolStateUpdating      SKSNodepoolState = "updating"
	SKSNodepoolStateError         SKSNodepoolState = "error"
)

// SKS Nodepool
type SKSNodepool struct {
	// Nodepool addons
	Addons []string `json:"addons,omitempty"`
	// Nodepool Anti-affinity Groups
	AntiAffinityGroups []AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	// Nodepool creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`
	// Nodepool description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Nodepool instances disk size in GiB
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=20,lte=51200"`
	// Nodepool ID
	ID UUID `json:"id,omitempty"`
	// Instance Pool
	InstancePool *InstancePool `json:"instance-pool,omitempty"`
	// The instances created by the Nodepool will be prefixed with this value (default: pool)
	InstancePrefix string `json:"instance-prefix,omitempty" validate:"omitempty,gte=1,lte=30"`
	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`
	// Kubelet image GC options
	KubeletImageGC *KubeletImageGC `json:"kubelet-image-gc,omitempty"`
	Labels         Labels          `json:"labels,omitempty"`
	// Nodepool name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Nodepool Private Networks
	PrivateNetworks []PrivateNetwork `json:"private-networks,omitempty"`
	// Nodepool public IP assignment of the Instances:
	// * IPv4 and IPv6 (`dual`) addressing.
	// * IPv4 and IPv6 (`dual`) addressing.
	PublicIPAssignment SKSNodepoolPublicIPAssignment `json:"public-ip-assignment,omitempty"`
	// Nodepool Security Groups
	SecurityGroups []SecurityGroup `json:"security-groups,omitempty"`
	// Number of instances
	Size int64 `json:"size,omitempty" validate:"omitempty,gt=0"`
	// Nodepool state
	State  SKSNodepoolState  `json:"state,omitempty"`
	Taints SKSNodepoolTaints `json:"taints,omitempty"`
	// Instance template
	Template *Template `json:"template,omitempty"`
	// Nodepool version
	Version string `json:"version,omitempty"`
}

type SKSNodepoolTaintEffect string

const (
	SKSNodepoolTaintEffectNoExecute        SKSNodepoolTaintEffect = "NoExecute"
	SKSNodepoolTaintEffectNoSchedule       SKSNodepoolTaintEffect = "NoSchedule"
	SKSNodepoolTaintEffectPreferNoSchedule SKSNodepoolTaintEffect = "PreferNoSchedule"
)

// Nodepool taint
type SKSNodepoolTaint struct {
	// Nodepool taint effect
	Effect SKSNodepoolTaintEffect `json:"effect" validate:"required"`
	// Nodepool taint value
	Value string `json:"value" validate:"required,gte=1,lte=255"`
}

type SKSNodepoolTaints map[string]SKSNodepoolTaint

// SKS Cluster OpenID config map
type SKSOidc struct {
	// OpenID client ID
	ClientID string `json:"client-id" validate:"required,gte=1,lte=255"`
	// JWT claim to use as the user's group
	GroupsClaim string `json:"groups-claim,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Prefix prepended to group claims
	GroupsPrefix string `json:"groups-prefix,omitempty" validate:"omitempty,gte=1,lte=255"`
	// OpenID provider URL
	IssuerURL string `json:"issuer-url" validate:"required,gte=1,lte=255"`
	// A key value map that describes a required claim in the ID Token
	RequiredClaim map[string]string `json:"required-claim,omitempty"`
	// JWT claim to use as the user name
	UsernameClaim string `json:"username-claim,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Prefix prepended to username claims
	UsernamePrefix string `json:"username-prefix,omitempty" validate:"omitempty,gte=1,lte=255"`
}

// Exported snapshot information
type SnapshotExport struct {
	// Exported snapshot disk file MD5 checksum
	Md5sum string `json:"md5sum,omitempty"`
	// Exported snapshot disk file pre-signed URL
	PresignedURL string `json:"presigned-url,omitempty"`
}

type SnapshotState string

const (
	SnapshotStateSnapshotting SnapshotState = "snapshotting"
	SnapshotStateDeleted      SnapshotState = "deleted"
	SnapshotStateExporting    SnapshotState = "exporting"
	SnapshotStateReady        SnapshotState = "ready"
	SnapshotStateDeleting     SnapshotState = "deleting"
	SnapshotStateError        SnapshotState = "error"
	SnapshotStateExported     SnapshotState = "exported"
)

// Snapshot
type Snapshot struct {
	// Snapshot creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Exported snapshot information
	Export *SnapshotExport `json:"export,omitempty"`
	// Snapshot ID
	ID UUID `json:"id,omitempty"`
	// Instance
	Instance *Instance `json:"instance,omitempty"`
	// Snapshot name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Snapshot size in GiB
	Size int64 `json:"size,omitempty" validate:"omitempty,gte=10,lte=51200"`
	// Snapshot state
	State SnapshotState `json:"state,omitempty"`
}

// SOS Bucket usage
type SOSBucketUsage struct {
	// SOS Bucket creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// SOS Bucket name
	Name string `json:"name,omitempty"`
	// SOS Bucket size in B
	Size     int64    `json:"size,omitempty" validate:"omitempty,gte=0"`
	ZoneName ZoneName `json:"zone-name,omitempty"`
}

// SSH key
type SSHKey struct {
	// SSH key fingerprint
	Fingerprint string `json:"fingerprint,omitempty"`
	// SSH key name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
}

type TemplateBootMode string

const (
	TemplateBootModeLegacy TemplateBootMode = "legacy"
	TemplateBootModeUefi   TemplateBootMode = "uefi"
)

type TemplateVisibility string

const (
	TemplateVisibilityPrivate TemplateVisibility = "private"
	TemplateVisibilityPublic  TemplateVisibility = "public"
)

// Instance template
type Template struct {
	// Boot mode (default: legacy)
	BootMode TemplateBootMode `json:"boot-mode,omitempty"`
	// Template build
	Build string `json:"build,omitempty"`
	// Template MD5 checksum
	Checksum string `json:"checksum,omitempty"`
	// Template creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Template default user
	DefaultUser string `json:"default-user,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Template description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Template family
	Family string `json:"family,omitempty"`
	// Template ID
	ID UUID `json:"id,omitempty"`
	// Template maintainer
	Maintainer string `json:"maintainer,omitempty"`
	// Template name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Enable password-based login
	PasswordEnabled *bool `json:"password-enabled,omitempty"`
	// Template size
	Size int64 `json:"size,omitempty" validate:"omitempty,gt=0"`
	// Enable SSH key-based login
	SSHKeyEnabled *bool `json:"ssh-key-enabled,omitempty"`
	// Template source URL
	URL string `json:"url,omitempty"`
	// Template version
	Version string `json:"version,omitempty"`
	// Template visibility
	Visibility TemplateVisibility `json:"visibility,omitempty"`
	// Zones availability
	Zones []ZoneName `json:"zones,omitempty"`
}

// User
type User struct {
	// User Email
	Email string `json:"email" validate:"required"`
	// User ID
	ID UUID `json:"id,omitempty"`
	// True if the user has not yet created an Exoscale account
	Pending *bool `json:"pending,omitempty"`
	// IAM Role
	Role *IAMRole `json:"role" validate:"required"`
	// SSO enabled
	Sso *bool `json:"sso,omitempty"`
	// Two Factor Authentication enabled
	TwoFactorAuthentication *bool `json:"two-factor-authentication,omitempty"`
}

// Zone
type Zone struct {
	// Zone API endpoint
	APIEndpoint Endpoint `json:"api-endpoint,omitempty"`
	Name        ZoneName `json:"name,omitempty"`
	// Zone SOS endpoint
	SOSEndpoint Endpoint `json:"sos-endpoint,omitempty"`
}

type ZoneName string

const (
	ZoneNameCHDk2  ZoneName = "ch-dk-2"
	ZoneNameDEMuc1 ZoneName = "de-muc-1"
	ZoneNameCHGva2 ZoneName = "ch-gva-2"
	ZoneNameATVie1 ZoneName = "at-vie-1"
	ZoneNameDEFra1 ZoneName = "de-fra-1"
	ZoneNameBGSof1 ZoneName = "bg-sof-1"
	ZoneNameATVie2 ZoneName = "at-vie-2"
)
