// Code generated by smithy-go-codegen DO NOT EDIT.

package lightsail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lightsail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing Amazon Lightsail content delivery network (CDN)
// distribution.
//
// Use this action to update the configuration of your existing distribution.
func (c *Client) UpdateDistribution(ctx context.Context, params *UpdateDistributionInput, optFns ...func(*Options)) (*UpdateDistributionOutput, error) {
	if params == nil {
		params = &UpdateDistributionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDistribution", params, optFns, c.addOperationUpdateDistributionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDistributionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDistributionInput struct {

	// The name of the distribution to update.
	//
	// Use the GetDistributions action to get a list of distribution names that you
	// can specify.
	//
	// This member is required.
	DistributionName *string

	// An object that describes the cache behavior settings for the distribution.
	//
	// The cacheBehaviorSettings specified in your UpdateDistributionRequest will
	// replace your distribution's existing settings.
	CacheBehaviorSettings *types.CacheSettings

	// An array of objects that describe the per-path cache behavior for the
	// distribution.
	CacheBehaviors []types.CacheBehaviorPerPath

	// The name of the SSL/TLS certificate that you want to attach to the distribution.
	//
	// Only certificates with a status of ISSUED can be attached to a distribution.
	//
	// Use the [GetCertificates] action to get a list of certificate names that you can specify.
	//
	// [GetCertificates]: https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetCertificates.html
	CertificateName *string

	// An object that describes the default cache behavior for the distribution.
	DefaultCacheBehavior *types.CacheBehavior

	// Indicates whether to enable the distribution.
	IsEnabled *bool

	// An object that describes the origin resource for the distribution, such as a
	// Lightsail instance, bucket, or load balancer.
	//
	// The distribution pulls, caches, and serves content from the origin.
	Origin *types.InputOrigin

	// Indicates whether the default SSL/TLS certificate is attached to the
	// distribution. The default value is true . When true , the distribution uses the
	// default domain name such as d111111abcdef8.cloudfront.net .
	//
	// Set this value to false to attach a new certificate to the distribution.
	UseDefaultCertificate *bool

	// Use this parameter to update the minimum TLS protocol version for the SSL/TLS
	// certificate that's attached to the distribution.
	ViewerMinimumTlsProtocolVersion types.ViewerMinimumTlsProtocolVersionEnum

	noSmithyDocumentSerde
}

type UpdateDistributionOutput struct {

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected by the
	// request.
	Operation *types.Operation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDistributionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateDistribution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateDistribution{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDistribution"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDistributionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDistribution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDistribution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDistribution",
	}
}
