package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDnsGtmAccessStrategy invokes the alidns.DescribeDnsGtmAccessStrategy API synchronously
func (client *Client) DescribeDnsGtmAccessStrategy(request *DescribeDnsGtmAccessStrategyRequest) (response *DescribeDnsGtmAccessStrategyResponse, err error) {
	response = CreateDescribeDnsGtmAccessStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDnsGtmAccessStrategyWithChan invokes the alidns.DescribeDnsGtmAccessStrategy API asynchronously
func (client *Client) DescribeDnsGtmAccessStrategyWithChan(request *DescribeDnsGtmAccessStrategyRequest) (<-chan *DescribeDnsGtmAccessStrategyResponse, <-chan error) {
	responseChan := make(chan *DescribeDnsGtmAccessStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDnsGtmAccessStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDnsGtmAccessStrategyWithCallback invokes the alidns.DescribeDnsGtmAccessStrategy API asynchronously
func (client *Client) DescribeDnsGtmAccessStrategyWithCallback(request *DescribeDnsGtmAccessStrategyRequest, callback func(response *DescribeDnsGtmAccessStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDnsGtmAccessStrategyResponse
		var err error
		defer close(result)
		response, err = client.DescribeDnsGtmAccessStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDnsGtmAccessStrategyRequest is the request struct for api DescribeDnsGtmAccessStrategy
type DescribeDnsGtmAccessStrategyRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	StrategyId   string `position:"Query" name:"StrategyId"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeDnsGtmAccessStrategyResponse is the response struct for api DescribeDnsGtmAccessStrategy
type DescribeDnsGtmAccessStrategyResponse struct {
	*responses.BaseResponse
	FailoverMinAvailableAddrNum int                                 `json:"FailoverMinAvailableAddrNum" xml:"FailoverMinAvailableAddrNum"`
	DefaultAddrPoolType         string                              `json:"DefaultAddrPoolType" xml:"DefaultAddrPoolType"`
	DefaultAvailableAddrNum     int                                 `json:"DefaultAvailableAddrNum" xml:"DefaultAvailableAddrNum"`
	StrategyId                  string                              `json:"StrategyId" xml:"StrategyId"`
	FailoverAddrPoolGroupStatus string                              `json:"FailoverAddrPoolGroupStatus" xml:"FailoverAddrPoolGroupStatus"`
	FailoverAvailableAddrNum    int                                 `json:"FailoverAvailableAddrNum" xml:"FailoverAvailableAddrNum"`
	FailoverLbaStrategy         string                              `json:"FailoverLbaStrategy" xml:"FailoverLbaStrategy"`
	DefaultMaxReturnAddrNum     int                                 `json:"DefaultMaxReturnAddrNum" xml:"DefaultMaxReturnAddrNum"`
	StrategyMode                string                              `json:"StrategyMode" xml:"StrategyMode"`
	CreateTimestamp             int64                               `json:"CreateTimestamp" xml:"CreateTimestamp"`
	DefaultLbaStrategy          string                              `json:"DefaultLbaStrategy" xml:"DefaultLbaStrategy"`
	DefaultAddrPoolGroupStatus  string                              `json:"DefaultAddrPoolGroupStatus" xml:"DefaultAddrPoolGroupStatus"`
	FailoverAddrPoolType        string                              `json:"FailoverAddrPoolType" xml:"FailoverAddrPoolType"`
	RequestId                   string                              `json:"RequestId" xml:"RequestId"`
	InstanceId                  string                              `json:"InstanceId" xml:"InstanceId"`
	DefaultLatencyOptimization  string                              `json:"DefaultLatencyOptimization" xml:"DefaultLatencyOptimization"`
	EffectiveAddrPoolGroupType  string                              `json:"EffectiveAddrPoolGroupType" xml:"EffectiveAddrPoolGroupType"`
	CreateTime                  string                              `json:"CreateTime" xml:"CreateTime"`
	DefaultMinAvailableAddrNum  int                                 `json:"DefaultMinAvailableAddrNum" xml:"DefaultMinAvailableAddrNum"`
	FailoverLatencyOptimization string                              `json:"FailoverLatencyOptimization" xml:"FailoverLatencyOptimization"`
	StrategyName                string                              `json:"StrategyName" xml:"StrategyName"`
	FailoverMaxReturnAddrNum    int                                 `json:"FailoverMaxReturnAddrNum" xml:"FailoverMaxReturnAddrNum"`
	AccessMode                  string                              `json:"AccessMode" xml:"AccessMode"`
	FailoverAddrPools           FailoverAddrPools                   `json:"FailoverAddrPools" xml:"FailoverAddrPools"`
	DefaultAddrPools            DefaultAddrPools                    `json:"DefaultAddrPools" xml:"DefaultAddrPools"`
	Lines                       LinesInDescribeDnsGtmAccessStrategy `json:"Lines" xml:"Lines"`
}

// CreateDescribeDnsGtmAccessStrategyRequest creates a request to invoke DescribeDnsGtmAccessStrategy API
func CreateDescribeDnsGtmAccessStrategyRequest() (request *DescribeDnsGtmAccessStrategyRequest) {
	request = &DescribeDnsGtmAccessStrategyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDnsGtmAccessStrategy", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDnsGtmAccessStrategyResponse creates a response to parse from DescribeDnsGtmAccessStrategy response
func CreateDescribeDnsGtmAccessStrategyResponse() (response *DescribeDnsGtmAccessStrategyResponse) {
	response = &DescribeDnsGtmAccessStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
