---
category: documentation
title: FAQ
---

# FAQ

## How can I write the annotations which grpc-gateway requires?
The gRPC-Gateway follows the spec of
[`google.api.HttpRule`](https://github.com/googleapis/googleapis/blob/master/google/api/http.proto),
so first check out the documentation if it is feasible in the spec.

See also [a past discussion](https://groups.google.com/d/msg/grpc-io/Xqx80hG0D44/VNCDHjeE6pUJ)
in the grpc-io mailing list.

## I want to support a certain style of HTTP request but the code generated by grpc-gateway does not. How can I support this style?
See the question above at first.

The gRPC-Gateway is intended to cover 80% of use cases without forcing you to write comprehensive but
complicated annotations. So the gateway itself does not always cover all the use cases you
have by design. In other words, the gateway automates typical boring boilerplate mapping
between gRPC and HTTP/1 communication, but it does not do arbitrarily complex custom mappings for you.

On the other hand, you can still add whatever you want as a middleware which wraps
[`runtime.ServeMux`](https://pkg.go.dev/github.com/grpc-ecosystem/grpc-gateway/runtime?tab=doc#ServeMux).
Since `runtime.ServeMux` is just a standard [`http.Handler`](http://golang.org/pkg/http#Handler),
you can easily write a custom wrapper of `runtime.ServeMux`, leveraged with existing third-party
libraries in Go.
e.g. https://github.com/grpc-ecosystem/grpc-gateway/blob/master/examples/internal/gateway/main.go

## My gRPC server is written in (Scala|C++|Ruby|Haskell|....). Is there a (Scala|C++|Ruby|Haskell|....) version of grpc-gateway?

AFAIK, no. But it should not be a big issue because the reverse-proxy which grpc-gateway generates
usually works as an independent process and communicates with your gRPC server over TCP or a unix-domain socket.

## Why are the models in the swagger specification prefixed with the last part of the proto package name?

The reason to generate the prefixes is that we don't have a guaranteed unique namespace.
If two packages produce different Foo messages then we will have trouble.

## Why not strip the prefix?

When a message is added which happens to conflict with another message
(e.g. by importing a message with the same name from a different package)
it will break code that is very far away from the code that changed.
This is in an effort to adhere to the
[principle of least astonishment](https://en.wikipedia.org/wiki/Principle_of_least_astonishment).
