// Code generated by assets compiler. DO NOT EDIT.

package tcl

var (
	assets = map[string]string{
		"/auto.tcl":                                "# auto.tcl --\n#\n# utility procs formerly in init.tcl dealing with auto execution of commands\n# and can be auto loaded themselves.\n#\n# Copyright (c) 1991-1993 The Regents of the University of California.\n# Copyright (c) 1994-1998 Sun Microsystems, Inc.\n#\n# See the file \"license.terms\" for information on usage and redistribution of\n# this file, and for a DISCLAIMER OF ALL WARRANTIES.\n#\n\n# auto_reset --\n#\n# Destroy all cached information for auto-loading and auto-execution, so that\n# the information gets recomputed the next time it's needed.  Also delete any\n# commands that are listed in the auto-load index.\n#\n# Arguments:\n# None.\n\nproc auto_reset {} {\n    global auto_execs auto_index auto_path\n    if {[array exists auto_index]} {\n\tforeach cmdName [array names auto_index] {\n\t    set fqcn [namespace which $cmdName]\n\t    if {$fqcn eq \"\"} {\n\t\tcontinue\n\t    }\n\t    rename $fqcn {}\n\t}\n    }\n    unset -nocomplain auto_execs auto_index ::tcl::auto_oldpath\n    if {[catch {llength $auto_path}]} {\n\tset auto_path [list [info library]]\n    } elseif {[info library] ni $auto_path} {\n\tlappend auto_path [info library]\n    }\n}\n\n# tcl_findLibrary --\n#\n#\tThis is a utility for extensions that searches for a library directory\n#\tusing a canonical searching algorithm. A side effect is to source the\n#\tinitialization script and set a global library variable.\n#\n# Arguments:\n# \tbasename\tPrefix of the directory name, (e.g., \"tk\")\n#\tversion\t\tVersion number of the package, (e.g., \"8.0\")\n#\tpatch\t\tPatchlevel of the package, (e.g., \"8.0.3\")\n#\tinitScript\tInitialization script to source (e.g., tk.tcl)\n#\tenVarName\tenvironment variable to honor (e.g., TK_LIBRARY)\n#\tvarName\t\tGlobal variable to set when done (e.g., tk_library)\n\nproc tcl_findLibrary {basename version patch initScript enVarName varName} {\n    upvar #0 $varName the_library\n    global auto_path env tcl_platform\n\n    set dirs {}\n    set errors {}\n\n    # The C application may have hardwired a path, which we honor\n\n    if {[info exists the_library] && $the_library ne \"\"} {\n\tlappend dirs $the_library\n    } else {\n\t# Do the canonical search\n\n\t# 1. From an environment variable, if it exists.  Placing this first\n\t#    gives the end-user ultimate control to work-around any bugs, or\n\t#    to customize.\n\n\tif {[info exists env($enVarName)]} {\n\t    lappend dirs $env($enVarName)\n\t}\n\n\t# 2. In the package script directory registered within the\n\t#    configuration of the package itself.\n\n\tcatch {\n\t    lappend dirs [::${basename}::pkgconfig get scriptdir,runtime]\n\t}\n\n\t# 3. Relative to auto_path directories.  This checks relative to the\n\t# Tcl library as well as allowing loading of libraries added to the\n\t# auto_path that is not relative to the core library or binary paths.\n\tforeach d $auto_path {\n\t    lappend dirs [file join $d $basename$version]\n\t    if {$tcl_platform(platform) eq \"unix\"\n\t\t    && $tcl_platform(os) eq \"Darwin\"} {\n\t\t# 4. On MacOSX, check the Resources/Scripts subdir too\n\t\tlappend dirs [file join $d $basename$version Resources Scripts]\n\t    }\n\t}\n\n\t# 3. Various locations relative to the executable\n\t# ../lib/foo1.0\t\t(From bin directory in install hierarchy)\n\t# ../../lib/foo1.0\t(From bin/arch directory in install hierarchy)\n\t# ../library\t\t(From unix directory in build hierarchy)\n\t#\n\t# Remaining locations are out of date (when relevant, they ought to be\n\t# covered by the $::auto_path seach above) and disabled.\n\t#\n\t# ../../library\t\t(From unix/arch directory in build hierarchy)\n\t# ../../foo1.0.1/library\n\t#\t\t(From unix directory in parallel build hierarchy)\n\t# ../../../foo1.0.1/library\n\t#\t\t(From unix/arch directory in parallel build hierarchy)\n\n\tset parentDir [file dirname [file dirname [info nameofexecutable]]]\n\tset grandParentDir [file dirname $parentDir]\n\tlappend dirs [file join $parentDir lib $basename$version]\n\tlappend dirs [file join $grandParentDir lib $basename$version]\n\tlappend dirs [file join $parentDir library]\n\tif {0} {\n\t    lappend dirs [file join $grandParentDir library]\n\t    lappend dirs [file join $grandParentDir $basename$patch library]\n\t    lappend dirs [file join [file dirname $grandParentDir] \\\n\t\t\t      $basename$patch library]\n\t}\n    }\n    # uniquify $dirs in order\n    array set seen {}\n    foreach i $dirs {\n\t# Make sure $i is unique under normalization. Avoid repeated [source].\n\tif {[interp issafe]} {\n\t    # Safe interps have no [file normalize].\n\t    set norm $i\n\t} else {\n\t    set norm [file normalize $i]\n\t}\n\tif {[info exists seen($norm)]} {\n\t    continue\n\t}\n\tset seen($norm) {}\n\n\tset the_library $i\n\tset file [file join $i $initScript]\n\n\t# source everything when in a safe interpreter because we have a\n\t# source command, but no file exists command\n\n        if {[interp issafe] || [file exists $file]} {\n            if {![catch {uplevel #0 [list source $file]} msg opts]} {\n                return\n            }\n\t    append errors \"$file: $msg\\n\"\n\t    append errors [dict get $opts -errorinfo]\\n\n        }\n    }\n    unset -nocomplain the_library\n    set msg \"Can't find a usable $initScript in the following directories: \\n\"\n    append msg \"    $dirs\\n\\n\"\n    append msg \"$errors\\n\\n\"\n    append msg \"This probably means that $basename wasn't installed properly.\\n\"\n    error $msg\n}\n\n\n# ----------------------------------------------------------------------\n# auto_mkindex\n# ----------------------------------------------------------------------\n# The following procedures are used to generate the tclIndex file from Tcl\n# source files.  They use a special safe interpreter to parse Tcl source\n# files, writing out index entries as \"proc\" commands are encountered.  This\n# implementation won't work in a safe interpreter, since a safe interpreter\n# can't create the special parser and mess with its commands.\n\nif {[interp issafe]} {\n    return\t;# Stop sourcing the file here\n}\n\n# auto_mkindex --\n# Regenerate a tclIndex file from Tcl source files.  Takes as argument the\n# name of the directory in which the tclIndex file is to be placed, followed\n# by any number of glob patterns to use in that directory to locate all of the\n# relevant files.\n#\n# Arguments:\n# dir -\t\tName of the directory in which to create an index.\n\n# args -\tAny number of additional arguments giving the names of files\n#\t\twithin dir.  If no additional are given auto_mkindex will look\n#\t\tfor *.tcl.\n\nproc auto_mkindex {dir args} {\n    if {[interp issafe]} {\n\terror \"can't generate index within safe interpreter\"\n    }\n\n    set oldDir [pwd]\n    cd $dir\n\n    append index \"# Tcl autoload index file, version 2.0\\n\"\n    append index \"# This file is generated by the \\\"auto_mkindex\\\" command\\n\"\n    append index \"# and sourced to set up indexing information for one or\\n\"\n    append index \"# more commands.  Typically each line is a command that\\n\"\n    append index \"# sets an element in the auto_index array, where the\\n\"\n    append index \"# element name is the name of a command and the value is\\n\"\n    append index \"# a script that loads the command.\\n\\n\"\n    if {![llength $args]} {\n\tset args *.tcl\n    }\n\n    auto_mkindex_parser::init\n    foreach file [lsort [glob -- {*}$args]] {\n\ttry {\n\t    append index [auto_mkindex_parser::mkindex $file]\n\t} on error {msg opts} {\n\t    cd $oldDir\n\t    return -options $opts $msg\n\t}\n    }\n    auto_mkindex_parser::cleanup\n\n    set fid [open \"tclIndex\" w]\n    puts -nonewline $fid $index\n    close $fid\n    cd $oldDir\n}\n\n# Original version of auto_mkindex that just searches the source code for\n# \"proc\" at the beginning of the line.\n\nproc auto_mkindex_old {dir args} {\n    set oldDir [pwd]\n    cd $dir\n    set dir [pwd]\n    append index \"# Tcl autoload index file, version 2.0\\n\"\n    append index \"# This file is generated by the \\\"auto_mkindex\\\" command\\n\"\n    append index \"# and sourced to set up indexing information for one or\\n\"\n    append index \"# more commands.  Typically each line is a command that\\n\"\n    append index \"# sets an element in the auto_index array, where the\\n\"\n    append index \"# element name is the name of a command and the value is\\n\"\n    append index \"# a script that loads the command.\\n\\n\"\n    if {![llength $args]} {\n\tset args *.tcl\n    }\n    foreach file [lsort [glob -- {*}$args]] {\n\tset f \"\"\n\tset error [catch {\n\t    set f [open $file]\n\t    fconfigure $f -eofchar \"\\032 {}\"\n\t    while {[gets $f line] >= 0} {\n\t\tif {[regexp {^proc[ \t]+([^ \t]*)} $line match procName]} {\n\t\t    set procName [lindex [auto_qualify $procName \"::\"] 0]\n\t\t    append index \"set [list auto_index($procName)]\"\n\t\t    append index \" \\[list source \\[file join \\$dir [list $file]\\]\\]\\n\"\n\t\t}\n\t    }\n\t    close $f\n\t} msg opts]\n\tif {$error} {\n\t    catch {close $f}\n\t    cd $oldDir\n\t    return -options $opts $msg\n\t}\n    }\n    set f \"\"\n    set error [catch {\n\tset f [open tclIndex w]\n\tputs -nonewline $f $index\n\tclose $f\n\tcd $oldDir\n    } msg opts]\n    if {$error} {\n\tcatch {close $f}\n\tcd $oldDir\n\terror $msg $info $code\n\treturn -options $opts $msg\n    }\n}\n\n# Create a safe interpreter that can be used to parse Tcl source files\n# generate a tclIndex file for autoloading.  This interp contains commands for\n# things that need index entries.  Each time a command is executed, it writes\n# an entry out to the index file.\n\nnamespace eval auto_mkindex_parser {\n    variable parser \"\"          ;# parser used to build index\n    variable index \"\"           ;# maintains index as it is built\n    variable scriptFile \"\"      ;# name of file being processed\n    variable contextStack \"\"    ;# stack of namespace scopes\n    variable imports \"\"         ;# keeps track of all imported cmds\n    variable initCommands       ;# list of commands that create aliases\n    if {![info exists initCommands]} {\n\tset initCommands [list]\n    }\n\n    proc init {} {\n\tvariable parser\n\tvariable initCommands\n\n\tif {![interp issafe]} {\n\t    set parser [interp create -safe]\n\t    $parser hide info\n\t    $parser hide rename\n\t    $parser hide proc\n\t    $parser hide namespace\n\t    $parser hide eval\n\t    $parser hide puts\n\t    foreach ns [$parser invokehidden namespace children ::] {\n\t\t# MUST NOT DELETE \"::tcl\" OR BAD THINGS HAPPEN!\n\t\tif {$ns eq \"::tcl\"} continue\n\t\t$parser invokehidden namespace delete $ns\n\t    }\n\t    foreach cmd [$parser invokehidden info commands ::*] {\n\t\t$parser invokehidden rename $cmd {}\n\t    }\n\t    $parser invokehidden proc unknown {args} {}\n\n\t    # We'll need access to the \"namespace\" command within the\n\t    # interp.  Put it back, but move it out of the way.\n\n\t    $parser expose namespace\n\t    $parser invokehidden rename namespace _%@namespace\n\t    $parser expose eval\n\t    $parser invokehidden rename eval _%@eval\n\n\t    # Install all the registered psuedo-command implementations\n\n\t    foreach cmd $initCommands {\n\t\teval $cmd\n\t    }\n\t}\n    }\n    proc cleanup {} {\n\tvariable parser\n\tinterp delete $parser\n\tunset parser\n    }\n}\n\n# auto_mkindex_parser::mkindex --\n#\n# Used by the \"auto_mkindex\" command to create a \"tclIndex\" file for the given\n# Tcl source file.  Executes the commands in the file, and handles things like\n# the \"proc\" command by adding an entry for the index file.  Returns a string\n# that represents the index file.\n#\n# Arguments:\n#\tfile\tName of Tcl source file to be indexed.\n\nproc auto_mkindex_parser::mkindex {file} {\n    variable parser\n    variable index\n    variable scriptFile\n    variable contextStack\n    variable imports\n\n    set scriptFile $file\n\n    set fid [open $file]\n    fconfigure $fid -eofchar \"\\032 {}\"\n    set contents [read $fid]\n    close $fid\n\n    # There is one problem with sourcing files into the safe interpreter:\n    # references like \"$x\" will fail since code is not really being executed\n    # and variables do not really exist.  To avoid this, we replace all $ with\n    # \\0 (literally, the null char) later, when getting proc names we will\n    # have to reverse this replacement, in case there were any $ in the proc\n    # name.  This will cause a problem if somebody actually tries to have a \\0\n    # in their proc name.  Too bad for them.\n    set contents [string map [list \\$ \\0] $contents]\n\n    set index \"\"\n    set contextStack \"\"\n    set imports \"\"\n\n    $parser eval $contents\n\n    foreach name $imports {\n\tcatch {$parser eval [list _%@namespace forget $name]}\n    }\n    return $index\n}\n\n# auto_mkindex_parser::hook command\n#\n# Registers a Tcl command to evaluate when initializing the child interpreter\n# used by the mkindex parser.  The command is evaluated in the parent\n# interpreter, and can use the variable auto_mkindex_parser::parser to get to\n# the child\n\nproc auto_mkindex_parser::hook {cmd} {\n    variable initCommands\n\n    lappend initCommands $cmd\n}\n\n# auto_mkindex_parser::slavehook command\n#\n# Registers a Tcl command to evaluate when initializing the child interpreter\n# used by the mkindex parser.  The command is evaluated in the child\n# interpreter.\n\nproc auto_mkindex_parser::slavehook {cmd} {\n    variable initCommands\n\n    # The $parser variable is defined to be the name of the child interpreter\n    # when this command is used later.\n\n    lappend initCommands \"\\$parser eval [list $cmd]\"\n}\n\n# auto_mkindex_parser::command --\n#\n# Registers a new command with the \"auto_mkindex_parser\" interpreter that\n# parses Tcl files.  These commands are fake versions of things like the\n# \"proc\" command.  When you execute them, they simply write out an entry to a\n# \"tclIndex\" file for auto-loading.\n#\n# This procedure allows extensions to register their own commands with the\n# auto_mkindex facility.  For example, a package like [incr Tcl] might\n# register a \"class\" command so that class definitions could be added to a\n# \"tclIndex\" file for auto-loading.\n#\n# Arguments:\n#\tname \tName of command recognized in Tcl files.\n#\targlist\tArgument list for command.\n#\tbody \tImplementation of command to handle indexing.\n\nproc auto_mkindex_parser::command {name arglist body} {\n    hook [list auto_mkindex_parser::commandInit $name $arglist $body]\n}\n\n# auto_mkindex_parser::commandInit --\n#\n# This does the actual work set up by auto_mkindex_parser::command. This is\n# called when the interpreter used by the parser is created.\n#\n# Arguments:\n#\tname \tName of command recognized in Tcl files.\n#\targlist\tArgument list for command.\n#\tbody \tImplementation of command to handle indexing.\n\nproc auto_mkindex_parser::commandInit {name arglist body} {\n    variable parser\n\n    set ns [namespace qualifiers $name]\n    set tail [namespace tail $name]\n    if {$ns eq \"\"} {\n\tset fakeName [namespace current]::_%@fake_$tail\n    } else {\n\tset fakeName [namespace current]::[string map {:: _} _%@fake_$name]\n    }\n    proc $fakeName $arglist $body\n\n    # YUK!  Tcl won't let us alias fully qualified command names, so we can't\n    # handle names like \"::itcl::class\".  Instead, we have to build procs with\n    # the fully qualified names, and have the procs point to the aliases.\n\n    if {[string match *::* $name]} {\n\tset exportCmd [list _%@namespace export [namespace tail $name]]\n\t$parser eval [list _%@namespace eval $ns $exportCmd]\n\n\t# The following proc definition does not work if you want to tolerate\n\t# space or something else diabolical in the procedure name, (i.e.,\n\t# space in $alias). The following does not work:\n\t#   \"_%@eval {$alias} \\$args\"\n\t# because $alias gets concat'ed to $args.  The following does not work\n\t# because $cmd is somehow undefined\n\t#   \"set cmd {$alias} \\; _%@eval {\\$cmd} \\$args\"\n\t# A gold star to someone that can make test autoMkindex-3.3 work\n\t# properly\n\n\tset alias [namespace tail $fakeName]\n\t$parser invokehidden proc $name {args} \"_%@eval {$alias} \\$args\"\n\t$parser alias $alias $fakeName\n    } else {\n\t$parser alias $name $fakeName\n    }\n    return\n}\n\n# auto_mkindex_parser::fullname --\n#\n# Used by commands like \"proc\" within the auto_mkindex parser.  Returns the\n# qualified namespace name for the \"name\" argument.  If the \"name\" does not\n# start with \"::\", elements are added from the current namespace stack to\n# produce a qualified name.  Then, the name is examined to see whether or not\n# it should really be qualified.  If the name has more than the leading \"::\",\n# it is returned as a fully qualified name.  Otherwise, it is returned as a\n# simple name.  That way, the Tcl autoloader will recognize it properly.\n#\n# Arguments:\n# name -\t\tName that is being added to index.\n\nproc auto_mkindex_parser::fullname {name} {\n    variable contextStack\n\n    if {![string match ::* $name]} {\n\tforeach ns $contextStack {\n\t    set name \"${ns}::$name\"\n\t    if {[string match ::* $name]} {\n\t\tbreak\n\t    }\n\t}\n    }\n\n    if {[namespace qualifiers $name] eq \"\"} {\n\tset name [namespace tail $name]\n    } elseif {![string match ::* $name]} {\n\tset name \"::$name\"\n    }\n\n    # Earlier, mkindex replaced all $'s with \\0.  Now, we have to reverse that\n    # replacement.\n    return [string map [list \\0 \\$] $name]\n}\n\n# auto_mkindex_parser::indexEntry --\n#\n# Used by commands like \"proc\" within the auto_mkindex parser to add a\n# correctly-quoted entry to the index. This is shared code so it is done\n# *right*, in one place.\n#\n# Arguments:\n# name -\t\tName that is being added to index.\n\nproc auto_mkindex_parser::indexEntry {name} {\n    variable index\n    variable scriptFile\n\n    # We convert all metacharacters to their backslashed form, and pre-split\n    # the file name that we know about (which will be a proper list, and so\n    # correctly quoted).\n\n    set name [string range [list \\}[fullname $name]] 2 end]\n    set filenameParts [file split $scriptFile]\n\n    append index [format \\\n\t    {set auto_index(%s) [list source [file join $dir %s]]%s} \\\n\t    $name $filenameParts \\n]\n    return\n}\n\nif {[llength $::auto_mkindex_parser::initCommands]} {\n    return\n}\n\n# Register all of the procedures for the auto_mkindex parser that will build\n# the \"tclIndex\" file.\n\n# AUTO MKINDEX:  proc name arglist body\n# Adds an entry to the auto index list for the given procedure name.\n\nauto_mkindex_parser::command proc {name args} {\n    indexEntry $name\n}\n\n# Conditionally add support for Tcl byte code files.  There are some tricky\n# details here.  First, we need to get the tbcload library initialized in the\n# current interpreter.  We cannot load tbcload into the child until we have\n# done so because it needs access to the tcl_patchLevel variable.  Second,\n# because the package index file may defer loading the library until we invoke\n# a command, we need to explicitly invoke auto_load to force it to be loaded.\n# This should be a noop if the package has already been loaded\n\nauto_mkindex_parser::hook {\n    try {\n\tpackage require tbcload\n    } on error {} {\n\t# OK, don't have it so do nothing\n    } on ok {} {\n\tif {[namespace which -command tbcload::bcproc] eq \"\"} {\n\t    auto_load tbcload::bcproc\n\t}\n\tload {} tbcload $auto_mkindex_parser::parser\n\n\t# AUTO MKINDEX:  tbcload::bcproc name arglist body\n\t# Adds an entry to the auto index list for the given pre-compiled\n\t# procedure name.\n\n\tauto_mkindex_parser::commandInit tbcload::bcproc {name args} {\n\t    indexEntry $name\n\t}\n    }\n}\n\n# AUTO MKINDEX:  namespace eval name command ?arg arg...?\n# Adds the namespace name onto the context stack and evaluates the associated\n# body of commands.\n#\n# AUTO MKINDEX:  namespace import ?-force? pattern ?pattern...?\n# Performs the \"import\" action in the parser interpreter.  This is important\n# for any commands contained in a namespace that affect the index.  For\n# example, a script may say \"itcl::class ...\", or it may import \"itcl::*\" and\n# then say \"class ...\".  This procedure does the import operation, but keeps\n# track of imported patterns so we can remove the imports later.\n\nauto_mkindex_parser::command namespace {op args} {\n    switch -- $op {\n\teval {\n\t    variable parser\n\t    variable contextStack\n\n\t    set name [lindex $args 0]\n\t    set args [lrange $args 1 end]\n\n\t    set contextStack [linsert $contextStack 0 $name]\n\t    $parser eval [list _%@namespace eval $name] $args\n\t    set contextStack [lrange $contextStack 1 end]\n\t}\n\timport {\n\t    variable parser\n\t    variable imports\n\t    foreach pattern $args {\n\t\tif {$pattern ne \"-force\"} {\n\t\t    lappend imports $pattern\n\t\t}\n\t    }\n\t    catch {$parser eval \"_%@namespace import $args\"}\n\t}\n\tensemble {\n\t    variable parser\n\t    variable contextStack\n\t    if {[lindex $args 0] eq \"create\"} {\n\t\tset name ::[join [lreverse $contextStack] ::]\n\t\tcatch {\n\t\t    set name [dict get [lrange $args 1 end] -command]\n\t\t    if {![string match ::* $name]} {\n\t\t\tset name ::[join [lreverse $contextStack] ::]$name\n\t\t    }\n\t\t    regsub -all ::+ $name :: name\n\t\t}\n\t\t# create artifical proc to force an entry in the tclIndex\n\t\t$parser eval [list ::proc $name {} {}]\n\t    }\n\t}\n    }\n}\n\n# AUTO MKINDEX:  oo::class create name ?definition?\n# Adds an entry to the auto index list for the given class name.\nauto_mkindex_parser::command oo::class {op name {body \"\"}} {\n    if {$op eq \"create\"} {\n\tindexEntry $name\n    }\n}\nauto_mkindex_parser::command class {op name {body \"\"}} {\n    if {$op eq \"create\"} {\n\tindexEntry $name\n    }\n}\n\nreturn\n",
		"/clock.tcl":                               "#----------------------------------------------------------------------\n#\n# clock.tcl --\n#\n#\tThis file implements the portions of the [clock] ensemble that are\n#\tcoded in Tcl.  Refer to the users' manual to see the description of\n#\tthe [clock] command and its subcommands.\n#\n#\n#----------------------------------------------------------------------\n#\n# Copyright (c) 2004-2007 Kevin B. Kenny\n# See the file \"license.terms\" for information on usage and redistribution\n# of this file, and for a DISCLAIMER OF ALL WARRANTIES.\n#\n#----------------------------------------------------------------------\n\n# We must have message catalogs that support the root locale, and we need\n# access to the Registry on Windows systems.\n\nuplevel \\#0 {\n    package require msgcat 1.6\n    if { $::tcl_platform(platform) eq {windows} } {\n\tif { [catch { package require registry 1.1 }] } {\n\t    namespace eval ::tcl::clock [list variable NoRegistry {}]\n\t}\n    }\n}\n\n# Put the library directory into the namespace for the ensemble so that the\n# library code can find message catalogs and time zone definition files.\n\nnamespace eval ::tcl::clock \\\n    [list variable LibDir [file dirname [info script]]]\n\n#----------------------------------------------------------------------\n#\n# clock --\n#\n#\tManipulate times.\n#\n# The 'clock' command manipulates time.  Refer to the user documentation for\n# the available subcommands and what they do.\n#\n#----------------------------------------------------------------------\n\nnamespace eval ::tcl::clock {\n\n    # Export the subcommands\n\n    namespace export format\n    namespace export clicks\n    namespace export microseconds\n    namespace export milliseconds\n    namespace export scan\n    namespace export seconds\n    namespace export add\n\n    # Import the message catalog commands that we use.\n\n    namespace import ::msgcat::mcload\n    namespace import ::msgcat::mclocale\n    namespace import ::msgcat::mc\n    namespace import ::msgcat::mcpackagelocale\n\n}\n\n#----------------------------------------------------------------------\n#\n# ::tcl::clock::Initialize --\n#\n#\tFinish initializing the 'clock' subsystem\n#\n# Results:\n#\tNone.\n#\n# Side effects:\n#\tNamespace variable in the 'clock' subsystem are initialized.\n#\n# The '::tcl::clock::Initialize' procedure initializes the namespace variables\n# and root locale message catalog for the 'clock' subsystem.  It is broken\n# into a procedure rather than simply evaluated as a script so that it will be\n# able to use local variables, avoiding the dangers of 'creative writing' as\n# in Bug 1185933.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::Initialize {} {\n\n    rename ::tcl::clock::Initialize {}\n\n    variable LibDir\n\n    # Define the Greenwich time zone\n\n    proc InitTZData {} {\n\tvariable TZData\n\tarray unset TZData\n\tset TZData(:Etc/GMT) {\n\t    {-9223372036854775808 0 0 GMT}\n\t}\n\tset TZData(:GMT) $TZData(:Etc/GMT)\n\tset TZData(:Etc/UTC) {\n\t    {-9223372036854775808 0 0 UTC}\n\t}\n\tset TZData(:UTC) $TZData(:Etc/UTC)\n\tset TZData(:localtime) {}\n    }\n    InitTZData\n\n    mcpackagelocale set {}\n    ::msgcat::mcpackageconfig set mcfolder [file join $LibDir msgs]\n    ::msgcat::mcpackageconfig set unknowncmd \"\"\n    ::msgcat::mcpackageconfig set changecmd ChangeCurrentLocale\n\n    # Define the message catalog for the root locale.\n\n    ::msgcat::mcmset {} {\n\tAM {am}\n\tBCE {B.C.E.}\n\tCE {C.E.}\n\tDATE_FORMAT {%m/%d/%Y}\n\tDATE_TIME_FORMAT {%a %b %e %H:%M:%S %Y}\n\tDAYS_OF_WEEK_ABBREV\t{\n\t    Sun Mon Tue Wed Thu Fri Sat\n\t}\n\tDAYS_OF_WEEK_FULL\t{\n\t    Sunday Monday Tuesday Wednesday Thursday Friday Saturday\n\t}\n\tGREGORIAN_CHANGE_DATE\t2299161\n\tLOCALE_DATE_FORMAT {%m/%d/%Y}\n\tLOCALE_DATE_TIME_FORMAT {%a %b %e %H:%M:%S %Y}\n\tLOCALE_ERAS {}\n\tLOCALE_NUMERALS\t\t{\n\t    00 01 02 03 04 05 06 07 08 09\n\t    10 11 12 13 14 15 16 17 18 19\n\t    20 21 22 23 24 25 26 27 28 29\n\t    30 31 32 33 34 35 36 37 38 39\n\t    40 41 42 43 44 45 46 47 48 49\n\t    50 51 52 53 54 55 56 57 58 59\n\t    60 61 62 63 64 65 66 67 68 69\n\t    70 71 72 73 74 75 76 77 78 79\n\t    80 81 82 83 84 85 86 87 88 89\n\t    90 91 92 93 94 95 96 97 98 99\n\t}\n\tLOCALE_TIME_FORMAT {%H:%M:%S}\n\tLOCALE_YEAR_FORMAT {%EC%Ey}\n\tMONTHS_ABBREV\t\t{\n\t    Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec\n\t}\n\tMONTHS_FULL\t\t{\n\t    \tJanuary\t\tFebruary\tMarch\n\t    \tApril\t\tMay\t\tJune\n\t    \tJuly\t\tAugust\t\tSeptember\n\t\tOctober\t\tNovember\tDecember\n\t}\n\tPM {pm}\n\tTIME_FORMAT {%H:%M:%S}\n\tTIME_FORMAT_12 {%I:%M:%S %P}\n\tTIME_FORMAT_24 {%H:%M}\n\tTIME_FORMAT_24_SECS {%H:%M:%S}\n    }\n\n    # Define a few Gregorian change dates for other locales.  In most cases\n    # the change date follows a language, because a nation's colonies changed\n    # at the same time as the nation itself.  In many cases, different\n    # national boundaries existed; the dominating rule is to follow the\n    # nation's capital.\n\n    # Italy, Spain, Portugal, Poland\n\n    ::msgcat::mcset it GREGORIAN_CHANGE_DATE 2299161\n    ::msgcat::mcset es GREGORIAN_CHANGE_DATE 2299161\n    ::msgcat::mcset pt GREGORIAN_CHANGE_DATE 2299161\n    ::msgcat::mcset pl GREGORIAN_CHANGE_DATE 2299161\n\n    # France, Austria\n\n    ::msgcat::mcset fr GREGORIAN_CHANGE_DATE 2299227\n\n    # For Belgium, we follow Southern Netherlands; Liege Diocese changed\n    # several weeks later.\n\n    ::msgcat::mcset fr_BE GREGORIAN_CHANGE_DATE 2299238\n    ::msgcat::mcset nl_BE GREGORIAN_CHANGE_DATE 2299238\n\n    # Austria\n\n    ::msgcat::mcset de_AT GREGORIAN_CHANGE_DATE 2299527\n\n    # Hungary\n\n    ::msgcat::mcset hu GREGORIAN_CHANGE_DATE 2301004\n\n    # Germany, Norway, Denmark (Catholic Germany changed earlier)\n\n    ::msgcat::mcset de_DE GREGORIAN_CHANGE_DATE 2342032\n    ::msgcat::mcset nb GREGORIAN_CHANGE_DATE 2342032\n    ::msgcat::mcset nn GREGORIAN_CHANGE_DATE 2342032\n    ::msgcat::mcset no GREGORIAN_CHANGE_DATE 2342032\n    ::msgcat::mcset da GREGORIAN_CHANGE_DATE 2342032\n\n    # Holland (Brabant, Gelderland, Flanders, Friesland, etc. changed at\n    # various times)\n\n    ::msgcat::mcset nl GREGORIAN_CHANGE_DATE 2342165\n\n    # Protestant Switzerland (Catholic cantons changed earlier)\n\n    ::msgcat::mcset fr_CH GREGORIAN_CHANGE_DATE 2361342\n    ::msgcat::mcset it_CH GREGORIAN_CHANGE_DATE 2361342\n    ::msgcat::mcset de_CH GREGORIAN_CHANGE_DATE 2361342\n\n    # English speaking countries\n\n    ::msgcat::mcset en GREGORIAN_CHANGE_DATE 2361222\n\n    # Sweden (had several changes onto and off of the Gregorian calendar)\n\n    ::msgcat::mcset sv GREGORIAN_CHANGE_DATE 2361390\n\n    # Russia\n\n    ::msgcat::mcset ru GREGORIAN_CHANGE_DATE 2421639\n\n    # Romania (Transylvania changed earler - perhaps de_RO should show the\n    # earlier date?)\n\n    ::msgcat::mcset ro GREGORIAN_CHANGE_DATE 2422063\n\n    # Greece\n\n    ::msgcat::mcset el GREGORIAN_CHANGE_DATE 2423480\n\n    #------------------------------------------------------------------\n    #\n    #\t\t\t\tCONSTANTS\n    #\n    #------------------------------------------------------------------\n\n    # Paths at which binary time zone data for the Olson libraries are known\n    # to reside on various operating systems\n\n    variable ZoneinfoPaths {}\n    foreach path {\n\t/usr/share/zoneinfo\n\t/usr/share/lib/zoneinfo\n\t/usr/lib/zoneinfo\n\t/usr/local/etc/zoneinfo\n    } {\n\tif { [file isdirectory $path] } {\n\t    lappend ZoneinfoPaths $path\n\t}\n    }\n\n    # Define the directories for time zone data and message catalogs.\n\n    variable DataDir [file join $LibDir tzdata]\n\n    # Number of days in the months, in common years and leap years.\n\n    variable DaysInRomanMonthInCommonYear \\\n\t{ 31 28 31 30 31 30 31 31 30 31 30 31 }\n    variable DaysInRomanMonthInLeapYear \\\n\t{ 31 29 31 30 31 30 31 31 30 31 30 31 }\n    variable DaysInPriorMonthsInCommonYear [list 0]\n    variable DaysInPriorMonthsInLeapYear [list 0]\n    set i 0\n    foreach j $DaysInRomanMonthInCommonYear {\n\tlappend DaysInPriorMonthsInCommonYear [incr i $j]\n    }\n    set i 0\n    foreach j $DaysInRomanMonthInLeapYear {\n\tlappend DaysInPriorMonthsInLeapYear [incr i $j]\n    }\n\n    # Another epoch (Hi, Jeff!)\n\n    variable Roddenberry 1946\n\n    # Integer ranges\n\n    variable MINWIDE -9223372036854775808\n    variable MAXWIDE 9223372036854775807\n\n    # Day before Leap Day\n\n    variable FEB_28\t       58\n\n    # Translation table to map Windows TZI onto cities, so that the Olson\n    # rules can apply.  In some cases the mapping is ambiguous, so it's wise\n    # to specify $::env(TCL_TZ) rather than simply depending on the system\n    # time zone.\n\n    # The keys are long lists of values obtained from the time zone\n    # information in the Registry.  In order, the list elements are:\n    # \tBias StandardBias DaylightBias\n    #   StandardDate.wYear StandardDate.wMonth StandardDate.wDayOfWeek\n    #   StandardDate.wDay StandardDate.wHour StandardDate.wMinute\n    #   StandardDate.wSecond StandardDate.wMilliseconds\n    #   DaylightDate.wYear DaylightDate.wMonth DaylightDate.wDayOfWeek\n    #   DaylightDate.wDay DaylightDate.wHour DaylightDate.wMinute\n    #   DaylightDate.wSecond DaylightDate.wMilliseconds\n    # The values are the names of time zones where those rules apply.  There\n    # is considerable ambiguity in certain zones; an attempt has been made to\n    # make a reasonable guess, but this table needs to be taken with a grain\n    # of salt.\n\n    variable WinZoneInfo [dict create {*}{\n\t{-43200 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}  :Pacific/Kwajalein\n\t{-39600 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}\t :Pacific/Midway\n\t{-36000 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}  :Pacific/Honolulu\n        {-32400 0 3600 0 11 0 1 2 0 0 0 0 3 0 2 2 0 0 0} :America/Anchorage\n        {-28800 0 3600 0 11 0 1 2 0 0 0 0 3 0 2 2 0 0 0} :America/Los_Angeles\n        {-28800 0 3600 0 10 0 5 2 0 0 0 0 4 0 1 2 0 0 0} :America/Tijuana\n        {-25200 0 3600 0 11 0 1 2 0 0 0 0 3 0 2 2 0 0 0} :America/Denver\n        {-25200 0 3600 0 10 0 5 2 0 0 0 0 4 0 1 2 0 0 0} :America/Chihuahua\n\t{-25200 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}  :America/Phoenix\n\t{-21600 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}  :America/Regina\n\t{-21600 0 3600 0 11 0 1 2 0 0 0 0 3 0 2 2 0 0 0} :America/Chicago\n        {-21600 0 3600 0 10 0 5 2 0 0 0 0 4 0 1 2 0 0 0} :America/Mexico_City\n\t{-18000 0 3600 0 11 0 1 2 0 0 0 0 3 0 2 2 0 0 0} :America/New_York\n\t{-18000 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}  :America/Indianapolis\n\t{-14400 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}  :America/Caracas\n        {-14400 0 3600 0 3 6 2 23 59 59 999 0 10 6 2 23 59 59 999}\n\t\t\t\t\t\t\t :America/Santiago\n        {-14400 0 3600 0 2 0 5 2 0 0 0 0 11 0 1 2 0 0 0} :America/Manaus\n        {-14400 0 3600 0 11 0 1 2 0 0 0 0 3 0 2 2 0 0 0} :America/Halifax\n\t{-12600 0 3600 0 10 0 5 2 0 0 0 0 4 0 1 2 0 0 0} :America/St_Johns\n\t{-10800 0 3600 0 2 0 2 2 0 0 0 0 10 0 3 2 0 0 0} :America/Sao_Paulo\n\t{-10800 0 3600 0 10 0 5 2 0 0 0 0 4 0 1 2 0 0 0} :America/Godthab\n\t{-10800 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}  :America/Buenos_Aires\n        {-10800 0 3600 0 2 0 5 2 0 0 0 0 11 0 1 2 0 0 0} :America/Bahia\n        {-10800 0 3600 0 3 0 2 2 0 0 0 0 10 0 1 2 0 0 0} :America/Montevideo\n\t{-7200 0 3600 0 9 0 5 2 0 0 0 0 3 0 5 2 0 0 0}   :America/Noronha\n\t{-3600 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}  :Atlantic/Azores\n\t{-3600 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Atlantic/Cape_Verde\n\t{0 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}       :UTC\n\t{0 0 3600 0 10 0 5 2 0 0 0 0 3 0 5 1 0 0 0}      :Europe/London\n\t{3600 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}    :Africa/Kinshasa\n\t{3600 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}   :CET\n        {7200 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}    :Africa/Harare\n        {7200 0 3600 0 9 4 5 23 59 59 0 0 4 4 5 23 59 59 0}\n\t\t\t      \t\t\t\t :Africa/Cairo\n\t{7200 0 3600 0 10 0 5 4 0 0 0 0 3 0 5 3 0 0 0}   :Europe/Helsinki\n        {7200 0 3600 0 9 0 3 2 0 0 0 0 3 5 5 2 0 0 0}    :Asia/Jerusalem\n\t{7200 0 3600 0 9 0 5 1 0 0 0 0 3 0 5 0 0 0 0}    :Europe/Bucharest\n\t{7200 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}   :Europe/Athens\n        {7200 0 3600 0 9 5 5 1 0 0 0 0 3 4 5 0 0 0 0}    :Asia/Amman\n        {7200 0 3600 0 10 6 5 23 59 59 999 0 3 0 5 0 0 0 0}\n\t\t\t\t\t\t\t :Asia/Beirut\n        {7200 0 -3600 0 4 0 1 2 0 0 0 0 9 0 1 2 0 0 0}   :Africa/Windhoek\n\t{10800 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Riyadh\n\t{10800 0 3600 0 10 0 1 4 0 0 0 0 4 0 1 3 0 0 0}  :Asia/Baghdad\n\t{10800 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}  :Europe/Moscow\n\t{12600 0 3600 0 9 2 4 2 0 0 0 0 3 0 1 2 0 0 0}   :Asia/Tehran\n        {14400 0 3600 0 10 0 5 5 0 0 0 0 3 0 5 4 0 0 0}  :Asia/Baku\n\t{14400 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Muscat\n\t{14400 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}  :Asia/Tbilisi\n\t{16200 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Kabul\n\t{18000 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Karachi\n\t{18000 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}  :Asia/Yekaterinburg\n\t{19800 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Calcutta\n\t{20700 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Katmandu\n\t{21600 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Dhaka\n\t{21600 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}  :Asia/Novosibirsk\n\t{23400 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Rangoon\n\t{25200 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Bangkok\n\t{25200 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}  :Asia/Krasnoyarsk\n\t{28800 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Chongqing\n\t{28800 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}  :Asia/Irkutsk\n\t{32400 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Asia/Tokyo\n\t{32400 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}  :Asia/Yakutsk\n\t{34200 0 3600 0 3 0 5 3 0 0 0 0 10 0 5 2 0 0 0}  :Australia/Adelaide\n\t{34200 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Australia/Darwin\n\t{36000 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Australia/Brisbane\n\t{36000 0 3600 0 10 0 5 3 0 0 0 0 3 0 5 2 0 0 0}  :Asia/Vladivostok\n\t{36000 0 3600 0 3 0 5 3 0 0 0 0 10 0 1 2 0 0 0}  :Australia/Hobart\n\t{36000 0 3600 0 3 0 5 3 0 0 0 0 10 0 5 2 0 0 0}  :Australia/Sydney\n\t{39600 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Pacific/Noumea\n\t{43200 0 3600 0 3 0 3 3 0 0 0 0 10 0 1 2 0 0 0}  :Pacific/Auckland\n\t{43200 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Pacific/Fiji\n\t{46800 0 3600 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}   :Pacific/Tongatapu\n    }]\n\n    # Groups of fields that specify the date, priorities, and code bursts that\n    # determine Julian Day Number given those groups.  The code in [clock\n    # scan] will choose the highest priority (lowest numbered) set of fields\n    # that determines the date.\n\n    variable DateParseActions {\n\n\t{ seconds } 0 {}\n\n\t{ julianDay } 1 {}\n\n\t{ era century yearOfCentury month dayOfMonth } 2 {\n\t    dict set date year [expr { 100 * [dict get $date century]\n\t\t\t\t       + [dict get $date yearOfCentury] }]\n\t    set date [GetJulianDayFromEraYearMonthDay $date[set date {}] \\\n\t\t\t  $changeover]\n\t}\n\t{ era century yearOfCentury dayOfYear } 2 {\n\t    dict set date year [expr { 100 * [dict get $date century]\n\t\t\t\t       + [dict get $date yearOfCentury] }]\n\t    set date [GetJulianDayFromEraYearDay $date[set date {}] \\\n\t\t\t  $changeover]\n\t}\n\n\t{ century yearOfCentury month dayOfMonth } 3 {\n\t    dict set date era CE\n\t    dict set date year [expr { 100 * [dict get $date century]\n\t\t\t\t       + [dict get $date yearOfCentury] }]\n\t    set date [GetJulianDayFromEraYearMonthDay $date[set date {}] \\\n\t\t\t  $changeover]\n\t}\n\t{ century yearOfCentury dayOfYear } 3 {\n\t    dict set date era CE\n\t    dict set date year [expr { 100 * [dict get $date century]\n\t\t\t\t       + [dict get $date yearOfCentury] }]\n\t    set date [GetJulianDayFromEraYearDay $date[set date {}] \\\n\t\t\t  $changeover]\n\t}\n\t{ iso8601Century iso8601YearOfCentury iso8601Week dayOfWeek } 3 {\n\t    dict set date era CE\n\t    dict set date iso8601Year \\\n\t\t[expr { 100 * [dict get $date iso8601Century]\n\t\t\t+ [dict get $date iso8601YearOfCentury] }]\n\t    set date [GetJulianDayFromEraYearWeekDay $date[set date {}] \\\n\t\t\t $changeover]\n\t}\n\n\t{ yearOfCentury month dayOfMonth } 4 {\n\t    set date [InterpretTwoDigitYear $date[set date {}] $baseTime]\n\t    dict set date era CE\n\t    set date [GetJulianDayFromEraYearMonthDay $date[set date {}] \\\n\t\t\t  $changeover]\n\t}\n\t{ yearOfCentury dayOfYear } 4 {\n\t    set date [InterpretTwoDigitYear $date[set date {}] $baseTime]\n\t    dict set date era CE\n\t    set date [GetJulianDayFromEraYearDay $date[set date {}] \\\n\t\t\t  $changeover]\n\t}\n\t{ iso8601YearOfCentury iso8601Week dayOfWeek } 4 {\n\t    set date [InterpretTwoDigitYear \\\n\t\t\t  $date[set date {}] $baseTime \\\n\t\t\t  iso8601YearOfCentury iso8601Year]\n\t    dict set date era CE\n\t    set date [GetJulianDayFromEraYearWeekDay $date[set date {}] \\\n\t\t\t $changeover]\n\t}\n\n\t{ month dayOfMonth } 5 {\n\t    set date [AssignBaseYear $date[set date {}] \\\n\t\t\t  $baseTime $timeZone $changeover]\n\t    set date [GetJulianDayFromEraYearMonthDay $date[set date {}] \\\n\t\t\t  $changeover]\n\t}\n\t{ dayOfYear } 5 {\n\t    set date [AssignBaseYear $date[set date {}] \\\n\t\t\t  $baseTime $timeZone $changeover]\n\t    set date [GetJulianDayFromEraYearDay $date[set date {}] \\\n\t\t\t $changeover]\n\t}\n\t{ iso8601Week dayOfWeek } 5 {\n\t    set date [AssignBaseIso8601Year $date[set date {}] \\\n\t\t\t  $baseTime $timeZone $changeover]\n\t    set date [GetJulianDayFromEraYearWeekDay $date[set date {}] \\\n\t\t\t $changeover]\n\t}\n\n\t{ dayOfMonth } 6 {\n\t    set date [AssignBaseMonth $date[set date {}] \\\n\t\t\t  $baseTime $timeZone $changeover]\n\t    set date [GetJulianDayFromEraYearMonthDay $date[set date {}] \\\n\t\t\t  $changeover]\n\t}\n\n\t{ dayOfWeek } 7 {\n\t    set date [AssignBaseWeek $date[set date {}] \\\n\t\t\t  $baseTime $timeZone $changeover]\n\t    set date [GetJulianDayFromEraYearWeekDay $date[set date {}] \\\n\t\t\t $changeover]\n\t}\n\n\t{} 8 {\n\t    set date [AssignBaseJulianDay $date[set date {}] \\\n\t\t\t  $baseTime $timeZone $changeover]\n\t}\n    }\n\n    # Groups of fields that specify time of day, priorities, and code that\n    # processes them\n\n    variable TimeParseActions {\n\n\tseconds 1 {}\n\n\t{ hourAMPM minute second amPmIndicator } 2 {\n\t    dict set date secondOfDay [InterpretHMSP $date]\n\t}\n\t{ hour minute second } 2 {\n\t    dict set date secondOfDay [InterpretHMS $date]\n\t}\n\n\t{ hourAMPM minute amPmIndicator } 3 {\n\t    dict set date second 0\n\t    dict set date secondOfDay [InterpretHMSP $date]\n\t}\n\t{ hour minute } 3 {\n\t    dict set date second 0\n\t    dict set date secondOfDay [InterpretHMS $date]\n\t}\n\n\t{ hourAMPM amPmIndicator } 4 {\n\t    dict set date minute 0\n\t    dict set date second 0\n\t    dict set date secondOfDay [InterpretHMSP $date]\n\t}\n\t{ hour } 4 {\n\t    dict set date minute 0\n\t    dict set date second 0\n\t    dict set date secondOfDay [InterpretHMS $date]\n\t}\n\n\t{ } 5 {\n\t    dict set date secondOfDay 0\n\t}\n    }\n\n    # Legacy time zones, used primarily for parsing RFC822 dates.\n\n    variable LegacyTimeZone [dict create \\\n\tgmt\t+0000 \\\n\tut\t+0000 \\\n\tutc\t+0000 \\\n\tbst\t+0100 \\\n\twet\t+0000 \\\n\twat\t-0100 \\\n\tat\t-0200 \\\n\tnft\t-0330 \\\n\tnst\t-0330 \\\n\tndt\t-0230 \\\n\tast\t-0400 \\\n\tadt\t-0300 \\\n\test\t-0500 \\\n\tedt\t-0400 \\\n\tcst\t-0600 \\\n\tcdt\t-0500 \\\n\tmst\t-0700 \\\n\tmdt\t-0600 \\\n\tpst\t-0800 \\\n\tpdt\t-0700 \\\n\tyst\t-0900 \\\n\tydt\t-0800 \\\n\thst\t-1000 \\\n\thdt\t-0900 \\\n\tcat\t-1000 \\\n\tahst\t-1000 \\\n\tnt\t-1100 \\\n\tidlw\t-1200 \\\n\tcet\t+0100 \\\n\tcest\t+0200 \\\n\tmet\t+0100 \\\n\tmewt\t+0100 \\\n\tmest\t+0200 \\\n\tswt\t+0100 \\\n\tsst\t+0200 \\\n\tfwt\t+0100 \\\n\tfst\t+0200 \\\n\teet\t+0200 \\\n\teest\t+0300 \\\n\tbt\t+0300 \\\n\tit\t+0330 \\\n\tzp4\t+0400 \\\n\tzp5\t+0500 \\\n\tist\t+0530 \\\n\tzp6\t+0600 \\\n\twast\t+0700 \\\n\twadt\t+0800 \\\n\tjt\t+0730 \\\n\tcct\t+0800 \\\n\tjst\t+0900 \\\n\tkst     +0900 \\\n\tcast\t+0930 \\\n        jdt     +1000 \\\n        kdt     +1000 \\\n\tcadt\t+1030 \\\n\teast\t+1000 \\\n\teadt\t+1030 \\\n\tgst\t+1000 \\\n\tnzt\t+1200 \\\n\tnzst\t+1200 \\\n\tnzdt\t+1300 \\\n\tidle\t+1200 \\\n\ta\t+0100 \\\n\tb\t+0200 \\\n\tc\t+0300 \\\n\td\t+0400 \\\n\te\t+0500 \\\n\tf\t+0600 \\\n\tg\t+0700 \\\n\th\t+0800 \\\n\ti\t+0900 \\\n\tk\t+1000 \\\n\tl\t+1100 \\\n\tm\t+1200 \\\n\tn\t-0100 \\\n\to\t-0200 \\\n\tp\t-0300 \\\n\tq\t-0400 \\\n\tr\t-0500 \\\n\ts\t-0600 \\\n\tt\t-0700 \\\n\tu\t-0800 \\\n\tv\t-0900 \\\n\tw\t-1000 \\\n\tx\t-1100 \\\n\ty\t-1200 \\\n\tz\t+0000 \\\n    ]\n\n    # Caches\n\n    variable LocaleNumeralCache {};\t# Dictionary whose keys are locale\n\t\t\t\t\t# names and whose values are pairs\n\t\t\t\t\t# comprising regexes matching numerals\n\t\t\t\t\t# in the given locales and dictionaries\n\t\t\t\t\t# mapping the numerals to their numeric\n\t\t\t\t\t# values.\n    # variable CachedSystemTimeZone;    # If 'CachedSystemTimeZone' exists,\n\t\t\t\t\t# it contains the value of the\n\t\t\t\t\t# system time zone, as determined from\n\t\t\t\t\t# the environment.\n    variable TimeZoneBad {};\t        # Dictionary whose keys are time zone\n    \t\t\t\t\t# names and whose values are 1 if\n\t\t\t\t\t# the time zone is unknown and 0\n    \t\t\t\t\t# if it is known.\n    variable TZData;\t\t\t# Array whose keys are time zone names\n\t\t\t\t\t# and whose values are lists of quads\n\t\t\t\t\t# comprising start time, UTC offset,\n\t\t\t\t\t# Daylight Saving Time indicator, and\n\t\t\t\t\t# time zone abbreviation.\n    variable FormatProc;\t\t# Array mapping format group\n\t\t\t\t\t# and locale to the name of a procedure\n\t\t\t\t\t# that renders the given format\n}\n::tcl::clock::Initialize\n\n#----------------------------------------------------------------------\n#\n# clock format --\n#\n#\tFormats a count of seconds since the Posix Epoch as a time of day.\n#\n# The 'clock format' command formats times of day for output.  Refer to the\n# user documentation to see what it does.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::format { args } {\n\n    variable FormatProc\n    variable TZData\n\n    lassign [ParseFormatArgs {*}$args] format locale timezone\n    set locale [string tolower $locale]\n    set clockval [lindex $args 0]\n\n    # Get the data for time changes in the given zone\n\n    if {$timezone eq \"\"} {\n\tset timezone [GetSystemTimeZone]\n    }\n    if {![info exists TZData($timezone)]} {\n\tif {[catch {SetupTimeZone $timezone} retval opts]} {\n\t    dict unset opts -errorinfo\n\t    return -options $opts $retval\n\t}\n    }\n\n    # Build a procedure to format the result. Cache the built procedure's name\n    # in the 'FormatProc' array to avoid losing its internal representation,\n    # which contains the name resolution.\n\n    set procName formatproc'$format'$locale\n    set procName [namespace current]::[string map {: {\\:} \\\\ {\\\\}} $procName]\n    if {[info exists FormatProc($procName)]} {\n\tset procName $FormatProc($procName)\n    } else {\n\tset FormatProc($procName) \\\n\t    [ParseClockFormatFormat $procName $format $locale]\n    }\n\n    return [$procName $clockval $timezone]\n\n}\n\n#----------------------------------------------------------------------\n#\n# ParseClockFormatFormat --\n#\n#\tBuilds and caches a procedure that formats a time value.\n#\n# Parameters:\n#\tformat -- Format string to use\n#\tlocale -- Locale in which the format string is to be interpreted\n#\n# Results:\n#\tReturns the name of the newly-built procedure.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::ParseClockFormatFormat {procName format locale} {\n\n    if {[namespace which $procName] ne {}} {\n\treturn $procName\n    }\n\n    # Map away the locale-dependent composite format groups\n\n    EnterLocale $locale\n\n    # Change locale if a fresh locale has been given on the command line.\n\n    try {\n\treturn [ParseClockFormatFormat2 $format $locale $procName]\n    } trap CLOCK {result opts} {\n\tdict unset opts -errorinfo\n\treturn -options $opts $result\n    }\n}\n\nproc ::tcl::clock::ParseClockFormatFormat2 {format locale procName} {\n    set didLocaleEra 0\n    set didLocaleNumerals 0\n    set preFormatCode \\\n\t[string map [list @GREGORIAN_CHANGE_DATE@ \\\n\t\t\t\t       [mc GREGORIAN_CHANGE_DATE]] \\\n\t     {\n\t\t variable TZData\n\t\t set date [GetDateFields $clockval \\\n\t\t\t       $TZData($timezone) \\\n\t\t\t       @GREGORIAN_CHANGE_DATE@]\n\t     }]\n    set formatString {}\n    set substituents {}\n    set state {}\n\n    set format [LocalizeFormat $locale $format]\n\n    foreach char [split $format {}] {\n\tswitch -exact -- $state {\n\t    {} {\n\t\tif { [string equal % $char] } {\n\t\t    set state percent\n\t\t} else {\n\t\t    append formatString $char\n\t\t}\n\t    }\n\t    percent {\t\t\t# Character following a '%' character\n\t\tset state {}\n\t\tswitch -exact -- $char {\n\t\t    % {\t\t\t# A literal character, '%'\n\t\t\tappend formatString %%\n\t\t    }\n\t\t    a {\t\t\t# Day of week, abbreviated\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    [string map \\\n\t\t\t\t [list @DAYS_OF_WEEK_ABBREV@ \\\n\t\t\t\t      [list [mc DAYS_OF_WEEK_ABBREV]]] \\\n\t\t\t\t { [lindex @DAYS_OF_WEEK_ABBREV@ \\\n\t\t\t\t\t[expr {[dict get $date dayOfWeek] \\\n\t\t\t\t\t\t   % 7}]]}]\n\t\t    }\n\t\t    A {\t\t\t# Day of week, spelt out.\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    [string map \\\n\t\t\t\t [list @DAYS_OF_WEEK_FULL@ \\\n\t\t\t\t      [list [mc DAYS_OF_WEEK_FULL]]] \\\n\t\t\t\t { [lindex @DAYS_OF_WEEK_FULL@ \\\n\t\t\t\t\t[expr {[dict get $date dayOfWeek] \\\n\t\t\t\t\t\t   % 7}]]}]\n\t\t    }\n\t\t    b - h {\t\t# Name of month, abbreviated.\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    [string map \\\n\t\t\t\t [list @MONTHS_ABBREV@ \\\n\t\t\t\t      [list [mc MONTHS_ABBREV]]] \\\n\t\t\t\t { [lindex @MONTHS_ABBREV@ \\\n\t\t\t\t\t[expr {[dict get $date month]-1}]]}]\n\t\t    }\n\t\t    B {\t\t\t# Name of month, spelt out\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    [string map \\\n\t\t\t\t [list @MONTHS_FULL@ \\\n\t\t\t\t      [list [mc MONTHS_FULL]]] \\\n\t\t\t\t { [lindex @MONTHS_FULL@ \\\n\t\t\t\t\t[expr {[dict get $date month]-1}]]}]\n\t\t    }\n\t\t    C {\t\t\t# Century number\n\t\t\tappend formatString %02d\n\t\t\tappend substituents \\\n\t\t\t    { [expr {[dict get $date year] / 100}]}\n\t\t    }\n\t\t    d {\t\t\t# Day of month, with leading zero\n\t\t\tappend formatString %02d\n\t\t\tappend substituents { [dict get $date dayOfMonth]}\n\t\t    }\n\t\t    e {\t\t\t# Day of month, without leading zero\n\t\t\tappend formatString %2d\n\t\t\tappend substituents { [dict get $date dayOfMonth]}\n\t\t    }\n\t\t    E {\t\t\t# Format group in a locale-dependent\n\t\t\t\t\t# alternative era\n\t\t\tset state percentE\n\t\t\tif {!$didLocaleEra} {\n\t\t\t    append preFormatCode \\\n\t\t\t\t[string map \\\n\t\t\t\t     [list @LOCALE_ERAS@ \\\n\t\t\t\t\t  [list [mc LOCALE_ERAS]]] \\\n\t\t\t\t     {\n\t\t\t\t\t set date [GetLocaleEra \\\n\t\t\t\t\t\t       $date[set date {}] \\\n\t\t\t\t\t\t       @LOCALE_ERAS@]}] \\n\n\t\t\t    set didLocaleEra 1\n\t\t\t}\n\t\t\tif {!$didLocaleNumerals} {\n\t\t\t    append preFormatCode \\\n\t\t\t\t[list set localeNumerals \\\n\t\t\t\t     [mc LOCALE_NUMERALS]] \\n\n\t\t\t    set didLocaleNumerals 1\n\t\t\t}\n\t\t    }\n\t\t    g {\t\t\t# Two-digit year relative to ISO8601\n\t\t\t\t\t# week number\n\t\t\tappend formatString %02d\n\t\t\tappend substituents \\\n\t\t\t    { [expr { [dict get $date iso8601Year] % 100 }]}\n\t\t    }\n\t\t    G {\t\t\t# Four-digit year relative to ISO8601\n\t\t\t\t\t# week number\n\t\t\tappend formatString %02d\n\t\t\tappend substituents { [dict get $date iso8601Year]}\n\t\t    }\n\t\t    H {\t\t\t# Hour in the 24-hour day, leading zero\n\t\t\tappend formatString %02d\n\t\t\tappend substituents \\\n\t\t\t    { [expr { [dict get $date localSeconds] \\\n\t\t\t\t\t  / 3600 % 24}]}\n\t\t    }\n\t\t    I {\t\t\t# Hour AM/PM, with leading zero\n\t\t\tappend formatString %02d\n\t\t\tappend substituents \\\n\t\t\t    { [expr { ( ( ( [dict get $date localSeconds] \\\n\t\t\t\t\t    % 86400 ) \\\n\t\t\t\t\t  + 86400 \\\n\t\t\t\t\t  - 3600 ) \\\n\t\t\t\t\t/ 3600 ) \\\n\t\t\t\t      % 12 + 1 }] }\n\t\t    }\n\t\t    j {\t\t\t# Day of year (001-366)\n\t\t\tappend formatString %03d\n\t\t\tappend substituents { [dict get $date dayOfYear]}\n\t\t    }\n\t\t    J {\t\t\t# Julian Day Number\n\t\t\tappend formatString %07ld\n\t\t\tappend substituents { [dict get $date julianDay]}\n\t\t    }\n\t\t    k {\t\t\t# Hour (0-23), no leading zero\n\t\t\tappend formatString %2d\n\t\t\tappend substituents \\\n\t\t\t    { [expr { [dict get $date localSeconds]\n\t\t\t\t      / 3600\n\t\t\t\t      % 24 }]}\n\t\t    }\n\t\t    l {\t\t\t# Hour (12-11), no leading zero\n\t\t\tappend formatString %2d\n\t\t\tappend substituents \\\n\t\t\t    { [expr { ( ( ( [dict get $date localSeconds]\n\t\t\t\t\t   % 86400 )\n\t\t\t\t\t + 86400\n\t\t\t\t\t - 3600 )\n\t\t\t\t       / 3600 )\n\t\t\t\t     % 12 + 1 }]}\n\t\t    }\n\t\t    m {\t\t\t# Month number, leading zero\n\t\t\tappend formatString %02d\n\t\t\tappend substituents { [dict get $date month]}\n\t\t    }\n\t\t    M {\t\t\t# Minute of the hour, leading zero\n\t\t\tappend formatString %02d\n\t\t\tappend substituents \\\n\t\t\t    { [expr { [dict get $date localSeconds]\n\t\t\t\t      / 60\n\t\t\t\t      % 60 }]}\n\t\t    }\n\t\t    n {\t\t\t# A literal newline\n\t\t\tappend formatString \\n\n\t\t    }\n\t\t    N {\t\t\t# Month number, no leading zero\n\t\t\tappend formatString %2d\n\t\t\tappend substituents { [dict get $date month]}\n\t\t    }\n\t\t    O {\t\t\t# A format group in the locale's\n\t\t\t\t\t# alternative numerals\n\t\t\tset state percentO\n\t\t\tif {!$didLocaleNumerals} {\n\t\t\t    append preFormatCode \\\n\t\t\t\t[list set localeNumerals \\\n\t\t\t\t     [mc LOCALE_NUMERALS]] \\n\n\t\t\t    set didLocaleNumerals 1\n\t\t\t}\n\t\t    }\n\t\t    p {\t\t\t# Localized 'AM' or 'PM' indicator\n\t\t\t\t\t# converted to uppercase\n\t\t\tappend formatString %s\n\t\t\tappend preFormatCode \\\n\t\t\t    [list set AM [string toupper [mc AM]]] \\n \\\n\t\t\t    [list set PM [string toupper [mc PM]]] \\n\n\t\t\tappend substituents \\\n\t\t\t    { [expr {(([dict get $date localSeconds]\n\t\t\t\t       % 86400) < 43200) ?\n\t\t\t\t     $AM : $PM}]}\n\t\t    }\n\t\t    P {\t\t\t# Localized 'AM' or 'PM' indicator\n\t\t\tappend formatString %s\n\t\t\tappend preFormatCode \\\n\t\t\t    [list set am [mc AM]] \\n \\\n\t\t\t    [list set pm [mc PM]] \\n\n\t\t\tappend substituents \\\n\t\t\t    { [expr {(([dict get $date localSeconds]\n\t\t\t\t       % 86400) < 43200) ?\n\t\t\t\t     $am : $pm}]}\n\n\t\t    }\n\t\t    Q {\t\t\t# Hi, Jeff!\n\t\t\tappend formatString %s\n\t\t\tappend substituents { [FormatStarDate $date]}\n\t\t    }\n\t\t    s {\t\t\t# Seconds from the Posix Epoch\n\t\t\tappend formatString %s\n\t\t\tappend substituents { [dict get $date seconds]}\n\t\t    }\n\t\t    S {\t\t\t# Second of the minute, with\n\t\t\t# leading zero\n\t\t\tappend formatString %02d\n\t\t\tappend substituents \\\n\t\t\t    { [expr { [dict get $date localSeconds]\n\t\t\t\t      % 60 }]}\n\t\t    }\n\t\t    t {\t\t\t# A literal tab character\n\t\t\tappend formatString \\t\n\t\t    }\n\t\t    u {\t\t\t# Day of the week (1-Monday, 7-Sunday)\n\t\t\tappend formatString %1d\n\t\t\tappend substituents { [dict get $date dayOfWeek]}\n\t\t    }\n\t\t    U {\t\t\t# Week of the year (00-53). The\n\t\t\t\t\t# first Sunday of the year is the\n\t\t\t\t\t# first day of week 01\n\t\t\tappend formatString %02d\n\t\t\tappend preFormatCode {\n\t\t\t    set dow [dict get $date dayOfWeek]\n\t\t\t    if { $dow == 7 } {\n\t\t\t\tset dow 0\n\t\t\t    }\n\t\t\t    incr dow\n\t\t\t    set UweekNumber \\\n\t\t\t\t[expr { ( [dict get $date dayOfYear]\n\t\t\t\t\t  - $dow + 7 )\n\t\t\t\t\t/ 7 }]\n\t\t\t}\n\t\t\tappend substituents { $UweekNumber}\n\t\t    }\n\t\t    V {\t\t\t# The ISO8601 week number\n\t\t\tappend formatString %02d\n\t\t\tappend substituents { [dict get $date iso8601Week]}\n\t\t    }\n\t\t    w {\t\t\t# Day of the week (0-Sunday,\n\t\t\t\t\t# 6-Saturday)\n\t\t\tappend formatString %1d\n\t\t\tappend substituents \\\n\t\t\t    { [expr { [dict get $date dayOfWeek] % 7 }]}\n\t\t    }\n\t\t    W {\t\t\t# Week of the year (00-53). The first\n\t\t\t\t\t# Monday of the year is the first day\n\t\t\t\t\t# of week 01.\n\t\t\tappend preFormatCode {\n\t\t\t    set WweekNumber \\\n\t\t\t\t[expr { ( [dict get $date dayOfYear]\n\t\t\t\t\t  - [dict get $date dayOfWeek]\n\t\t\t\t\t  + 7 )\n\t\t\t\t\t/ 7 }]\n\t\t\t}\n\t\t\tappend formatString %02d\n\t\t\tappend substituents { $WweekNumber}\n\t\t    }\n\t\t    y {\t\t\t# The two-digit year of the century\n\t\t\tappend formatString %02d\n\t\t\tappend substituents \\\n\t\t\t    { [expr { [dict get $date year] % 100 }]}\n\t\t    }\n\t\t    Y {\t\t\t# The four-digit year\n\t\t\tappend formatString %04d\n\t\t\tappend substituents { [dict get $date year]}\n\t\t    }\n\t\t    z {\t\t\t# The time zone as hours and minutes\n\t\t\t\t\t# east (+) or west (-) of Greenwich\n\t\t\tappend formatString %s\n\t\t\tappend substituents { [FormatNumericTimeZone \\\n\t\t\t\t\t\t   [dict get $date tzOffset]]}\n\t\t    }\n\t\t    Z {\t\t\t# The name of the time zone\n\t\t\tappend formatString %s\n\t\t\tappend substituents { [dict get $date tzName]}\n\t\t    }\n\t\t    % {\t\t\t# A literal percent character\n\t\t\tappend formatString %%\n\t\t    }\n\t\t    default {\t\t# An unknown escape sequence\n\t\t\tappend formatString %% $char\n\t\t    }\n\t\t}\n\t    }\n\t    percentE {\t\t\t# Character following %E\n\t\tset state {}\n\t\tswitch -exact -- $char {\n\t\t    E {\n\t\t\tappend formatString %s\n\t\t\tappend substituents { } \\\n\t\t\t    [string map \\\n\t\t\t\t [list @BCE@ [list [mc BCE]] \\\n\t\t\t\t      @CE@ [list [mc CE]]] \\\n\t\t\t\t      {[dict get {BCE @BCE@ CE @CE@} \\\n\t\t\t\t\t    [dict get $date era]]}]\n\t\t    }\n\t\t    C {\t\t\t# Locale-dependent era\n\t\t\tappend formatString %s\n\t\t\tappend substituents { [dict get $date localeEra]}\n\t\t    }\n\t\t    y {\t\t\t# Locale-dependent year of the era\n\t\t\tappend preFormatCode {\n\t\t\t    set y [dict get $date localeYear]\n\t\t\t    if { $y >= 0 && $y < 100 } {\n\t\t\t\tset Eyear [lindex $localeNumerals $y]\n\t\t\t    } else {\n\t\t\t\tset Eyear $y\n\t\t\t    }\n\t\t\t}\n\t\t\tappend formatString %s\n\t\t\tappend substituents { $Eyear}\n\t\t    }\n\t\t    default {\t\t# Unknown %E format group\n\t\t\tappend formatString %%E $char\n\t\t    }\n\t\t}\n\t    }\n\t    percentO {\t\t\t# Character following %O\n\t\tset state {}\n\t\tswitch -exact -- $char {\n\t\t    d - e {\t\t# Day of the month in alternative\n\t\t\t# numerals\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    { [lindex $localeNumerals \\\n\t\t\t\t   [dict get $date dayOfMonth]]}\n\t\t    }\n\t\t    H - k {\t\t# Hour of the day in alternative\n\t\t\t\t\t# numerals\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    { [lindex $localeNumerals \\\n\t\t\t\t   [expr { [dict get $date localSeconds]\n\t\t\t\t\t   / 3600\n\t\t\t\t\t   % 24 }]]}\n\t\t    }\n\t\t    I - l {\t\t# Hour (12-11) AM/PM in alternative\n\t\t\t\t\t# numerals\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    { [lindex $localeNumerals \\\n\t\t\t\t   [expr { ( ( ( [dict get $date localSeconds]\n\t\t\t\t\t\t % 86400 )\n\t\t\t\t\t       + 86400\n\t\t\t\t\t       - 3600 )\n\t\t\t\t\t     / 3600 )\n\t\t\t\t\t   % 12 + 1 }]]}\n\t\t    }\n\t\t    m {\t\t\t# Month number in alternative numerals\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    { [lindex $localeNumerals [dict get $date month]]}\n\t\t    }\n\t\t    M {\t\t\t# Minute of the hour in alternative\n\t\t\t\t\t# numerals\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    { [lindex $localeNumerals \\\n\t\t\t\t   [expr { [dict get $date localSeconds]\n\t\t\t\t\t   / 60\n\t\t\t\t\t   % 60 }]]}\n\t\t    }\n\t\t    S {\t\t\t# Second of the minute in alternative\n\t\t\t\t\t# numerals\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    { [lindex $localeNumerals \\\n\t\t\t\t   [expr { [dict get $date localSeconds]\n\t\t\t\t\t   % 60 }]]}\n\t\t    }\n\t\t    u {\t\t\t# Day of the week (Monday=1,Sunday=7)\n\t\t\t\t\t# in alternative numerals\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    { [lindex $localeNumerals \\\n\t\t\t\t   [dict get $date dayOfWeek]]}\n\t\t\t}\n\t\t    w {\t\t\t# Day of the week (Sunday=0,Saturday=6)\n\t\t\t\t\t# in alternative numerals\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    { [lindex $localeNumerals \\\n\t\t\t\t   [expr { [dict get $date dayOfWeek] % 7 }]]}\n\t\t    }\n\t\t    y {\t\t\t# Year of the century in alternative\n\t\t\t\t\t# numerals\n\t\t\tappend formatString %s\n\t\t\tappend substituents \\\n\t\t\t    { [lindex $localeNumerals \\\n\t\t\t\t   [expr { [dict get $date year] % 100 }]]}\n\t\t    }\n\t\t    default {\t# Unknown format group\n\t\t\tappend formatString %%O $char\n\t\t    }\n\t\t}\n\t    }\n\t}\n    }\n\n    # Clean up any improperly terminated groups\n\n    switch -exact -- $state {\n\tpercent {\n\t    append formatString %%\n\t}\n\tpercentE {\n\t    append retval %%E\n\t}\n\tpercentO {\n\t    append retval %%O\n\t}\n    }\n\n    proc $procName {clockval timezone} \"\n        $preFormatCode\n        return \\[::format [list $formatString] $substituents\\]\n    \"\n\n    #    puts [list $procName [info args $procName] [info body $procName]]\n\n    return $procName\n}\n\n#----------------------------------------------------------------------\n#\n# clock scan --\n#\n#\tInputs a count of seconds since the Posix Epoch as a time of day.\n#\n# The 'clock format' command scans times of day on input.  Refer to the user\n# documentation to see what it does.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::scan { args } {\n\n    set format {}\n\n    # Check the count of args\n\n    if { [llength $args] < 1 || [llength $args] % 2 != 1 } {\n\tset cmdName \"clock scan\"\n\treturn -code error \\\n\t    -errorcode [list CLOCK wrongNumArgs] \\\n\t    \"wrong \\# args: should be\\\n             \\\"$cmdName string\\\n             ?-base seconds?\\\n             ?-format string? ?-gmt boolean?\\\n             ?-locale LOCALE? ?-timezone ZONE?\\\"\"\n    }\n\n    # Set defaults\n\n    set base [clock seconds]\n    set string [lindex $args 0]\n    set format {}\n    set gmt 0\n    set locale c\n    set timezone [GetSystemTimeZone]\n\n    # Pick up command line options.\n\n    foreach { flag value } [lreplace $args 0 0] {\n\tset saw($flag) {}\n\tswitch -exact -- $flag {\n\t    -b - -ba - -bas - -base {\n\t\tset base $value\n\t    }\n\t    -f - -fo - -for - -form - -forma - -format {\n\t\tset format $value\n\t    }\n\t    -g - -gm - -gmt {\n\t\tset gmt $value\n\t    }\n\t    -l - -lo - -loc - -loca - -local - -locale {\n\t\tset locale [string tolower $value]\n\t    }\n\t    -t - -ti - -tim - -time - -timez - -timezo - -timezon - -timezone {\n\t\tset timezone $value\n\t    }\n\t    default {\n\t\treturn -code error \\\n\t\t    -errorcode [list CLOCK badOption $flag] \\\n\t\t    \"bad option \\\"$flag\\\",\\\n                     must be -base, -format, -gmt, -locale or -timezone\"\n\t    }\n\t}\n    }\n\n    # Check options for validity\n\n    if { [info exists saw(-gmt)] && [info exists saw(-timezone)] } {\n\treturn -code error \\\n\t    -errorcode [list CLOCK gmtWithTimezone] \\\n\t    \"cannot use -gmt and -timezone in same call\"\n    }\n    if { [catch { expr { wide($base) } } result] } {\n\treturn -code error \"expected integer but got \\\"$base\\\"\"\n    }\n    if { ![string is boolean -strict $gmt] } {\n\treturn -code error \"expected boolean value but got \\\"$gmt\\\"\"\n    } elseif { $gmt } {\n\tset timezone :GMT\n    }\n\n    if { ![info exists saw(-format)] } {\n\t# Perhaps someday we'll localize the legacy code. Right now, it's not\n\t# localized.\n\tif { [info exists saw(-locale)] } {\n\t    return -code error \\\n\t\t-errorcode [list CLOCK flagWithLegacyFormat] \\\n\t\t\"legacy \\[clock scan\\] does not support -locale\"\n\n\t}\n\treturn [FreeScan $string $base $timezone $locale]\n    }\n\n    # Change locale if a fresh locale has been given on the command line.\n\n    EnterLocale $locale\n\n    try {\n\t# Map away the locale-dependent composite format groups\n\n\tset scanner [ParseClockScanFormat $format $locale]\n\treturn [$scanner $string $base $timezone]\n    } trap CLOCK {result opts} {\n\t# Conceal location of generation of expected errors\n\tdict unset opts -errorinfo\n\treturn -options $opts $result\n    }\n}\n\n#----------------------------------------------------------------------\n#\n# FreeScan --\n#\n#\tScans a time in free format\n#\n# Parameters:\n#\tstring - String containing the time to scan\n#\tbase - Base time, expressed in seconds from the Epoch\n#\ttimezone - Default time zone in which the time will be expressed\n#\tlocale - (Unused) Name of the locale where the time will be scanned.\n#\n# Results:\n#\tReturns the date and time extracted from the string in seconds from\n#\tthe epoch\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::FreeScan { string base timezone locale } {\n\n    variable TZData\n\n    # Get the data for time changes in the given zone\n\n    try {\n\tSetupTimeZone $timezone\n    } on error {retval opts} {\n\tdict unset opts -errorinfo\n\treturn -options $opts $retval\n    }\n\n    # Extract year, month and day from the base time for the parser to use as\n    # defaults\n\n    set date [GetDateFields $base $TZData($timezone) 2361222]\n    dict set date secondOfDay [expr {\n\t[dict get $date localSeconds] % 86400\n    }]\n\n    # Parse the date.  The parser will return a list comprising date, time,\n    # time zone, relative month/day/seconds, relative weekday, ordinal month.\n\n    try {\n\tset scanned [Oldscan $string \\\n\t\t     [dict get $date year] \\\n\t\t     [dict get $date month] \\\n\t\t     [dict get $date dayOfMonth]]\n\tlassign $scanned \\\n\t    parseDate parseTime parseZone parseRel \\\n\t    parseWeekday parseOrdinalMonth\n    } on error message {\n\treturn -code error \\\n\t    \"unable to convert date-time string \\\"$string\\\": $message\"\n    }\n\n    # If the caller supplied a date in the string, update the 'date' dict with\n    # the value. If the caller didn't specify a time with the date, default to\n    # midnight.\n\n    if { [llength $parseDate] > 0 } {\n\tlassign $parseDate y m d\n\tif { $y < 100 } {\n\t    if { $y >= 39 } {\n\t\tincr y 1900\n\t    } else {\n\t\tincr y 2000\n\t    }\n\t}\n\tdict set date era CE\n\tdict set date year $y\n\tdict set date month $m\n\tdict set date dayOfMonth $d\n\tif { $parseTime eq {} } {\n\t    set parseTime 0\n\t}\n    }\n\n    # If the caller supplied a time zone in the string, it comes back as a\n    # two-element list; the first element is the number of minutes east of\n    # Greenwich, and the second is a Daylight Saving Time indicator (1 == yes,\n    # 0 == no, -1 == unknown). We make it into a time zone indicator of\n    # +-hhmm.\n\n    if { [llength $parseZone] > 0 } {\n\tlassign $parseZone minEast dstFlag\n\tset timezone [FormatNumericTimeZone \\\n\t\t\t  [expr { 60 * $minEast + 3600 * $dstFlag }]]\n\tSetupTimeZone $timezone\n    }\n    dict set date tzName $timezone\n\n    # Assemble date, time, zone into seconds-from-epoch\n\n    set date [GetJulianDayFromEraYearMonthDay $date[set date {}] 2361222]\n    if { $parseTime ne {} } {\n\tdict set date secondOfDay $parseTime\n    } elseif { [llength $parseWeekday] != 0\n\t       || [llength $parseOrdinalMonth] != 0\n\t       || ( [llength $parseRel] != 0\n\t\t    && ( [lindex $parseRel 0] != 0\n\t\t\t || [lindex $parseRel 1] != 0 ) ) } {\n\tdict set date secondOfDay 0\n    }\n\n    dict set date localSeconds [expr {\n\t-210866803200\n\t+ ( 86400 * wide([dict get $date julianDay]) )\n\t+ [dict get $date secondOfDay]\n    }]\n    dict set date tzName $timezone\n    set date [ConvertLocalToUTC $date[set date {}] $TZData($timezone) 2361222]\n    set seconds [dict get $date seconds]\n\n    # Do relative times\n\n    if { [llength $parseRel] > 0 } {\n\tlassign $parseRel relMonth relDay relSecond\n\tset seconds [add $seconds \\\n\t\t\t $relMonth months $relDay days $relSecond seconds \\\n\t\t\t -timezone $timezone -locale $locale]\n    }\n\n    # Do relative weekday\n\n    if { [llength $parseWeekday] > 0 } {\n\tlassign $parseWeekday dayOrdinal dayOfWeek\n\tset date2 [GetDateFields $seconds $TZData($timezone) 2361222]\n\tdict set date2 era CE\n\tset jdwkday [WeekdayOnOrBefore $dayOfWeek [expr {\n\t    [dict get $date2 julianDay] + 6\n\t}]]\n\tincr jdwkday [expr { 7 * $dayOrdinal }]\n\tif { $dayOrdinal > 0 } {\n\t    incr jdwkday -7\n\t}\n\tdict set date2 secondOfDay \\\n\t    [expr { [dict get $date2 localSeconds] % 86400 }]\n\tdict set date2 julianDay $jdwkday\n\tdict set date2 localSeconds [expr {\n\t    -210866803200\n\t    + ( 86400 * wide([dict get $date2 julianDay]) )\n\t    + [dict get $date secondOfDay]\n\t}]\n\tdict set date2 tzName $timezone\n\tset date2 [ConvertLocalToUTC $date2[set date2 {}] $TZData($timezone) \\\n\t\t       2361222]\n\tset seconds [dict get $date2 seconds]\n\n    }\n\n    # Do relative month\n\n    if { [llength $parseOrdinalMonth] > 0 } {\n\tlassign $parseOrdinalMonth monthOrdinal monthNumber\n\tif { $monthOrdinal > 0 } {\n\t    set monthDiff [expr { $monthNumber - [dict get $date month] }]\n\t    if { $monthDiff <= 0 } {\n\t\tincr monthDiff 12\n\t    }\n\t    incr monthOrdinal -1\n\t} else {\n\t    set monthDiff [expr { [dict get $date month] - $monthNumber }]\n\t    if { $monthDiff >= 0 } {\n\t\tincr monthDiff -12\n\t    }\n\t    incr monthOrdinal\n\t}\n\tset seconds [add $seconds $monthOrdinal years $monthDiff months \\\n\t\t\t -timezone $timezone -locale $locale]\n    }\n\n    return $seconds\n}\n\n\n#----------------------------------------------------------------------\n#\n# ParseClockScanFormat --\n#\n#\tParses a format string given to [clock scan -format]\n#\n# Parameters:\n#\tformatString - The format being parsed\n#\tlocale - The current locale\n#\n# Results:\n#\tConstructs and returns a procedure that accepts the string being\n#\tscanned, the base time, and the time zone.  The procedure will either\n#\treturn the scanned time or else throw an error that should be rethrown\n#\tto the caller of [clock scan]\n#\n# Side effects:\n#\tThe given procedure is defined in the ::tcl::clock namespace.  Scan\n#\tprocedures are not deleted once installed.\n#\n# Why do we parse dates by defining a procedure to parse them?  The reason is\n# that by doing so, we have one convenient place to cache all the information:\n# the regular expressions that match the patterns (which will be compiled),\n# the code that assembles the date information, everything lands in one place.\n# In this way, when a given format is reused at run time, all the information\n# of how to apply it is available in a single place.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::ParseClockScanFormat {formatString locale} {\n    # Check whether the format has been parsed previously, and return the\n    # existing recognizer if it has.\n\n    set procName scanproc'$formatString'$locale\n    set procName [namespace current]::[string map {: {\\:} \\\\ {\\\\}} $procName]\n    if { [namespace which $procName] != {} } {\n\treturn $procName\n    }\n\n    variable DateParseActions\n    variable TimeParseActions\n\n    # Localize the %x, %X, etc. groups\n\n    set formatString [LocalizeFormat $locale $formatString]\n\n    # Condense whitespace\n\n    regsub -all {[[:space:]]+} $formatString { } formatString\n\n    # Walk through the groups of the format string.  In this loop, we\n    # accumulate:\n    #\t- a regular expression that matches the string,\n    #   - the count of capturing brackets in the regexp\n    #   - a set of code that post-processes the fields captured by the regexp,\n    #   - a dictionary whose keys are the names of fields that are present\n    #     in the format string.\n\n    set re {^[[:space:]]*}\n    set captureCount 0\n    set postcode {}\n    set fieldSet [dict create]\n    set fieldCount 0\n    set postSep {}\n    set state {}\n\n    foreach c [split $formatString {}] {\n\tswitch -exact -- $state {\n\t    {} {\n\t\tif { $c eq \"%\" } {\n\t\t    set state %\n\t\t} elseif { $c eq \" \" } {\n\t\t    append re {[[:space:]]+}\n\t\t} else {\n\t\t    if { ! [string is alnum $c] } {\n\t\t\tappend re \"\\\\\"\n\t\t    }\n\t\t    append re $c\n\t\t}\n\t    }\n\t    % {\n\t\tset state {}\n\t\tswitch -exact -- $c {\n\t\t    % {\n\t\t\tappend re %\n\t\t    }\n\t\t    { } {\n\t\t\tappend re \"\\[\\[:space:\\]\\]*\"\n\t\t    }\n\t\t    a - A { \t\t# Day of week, in words\n\t\t\tset l {}\n\t\t\tforeach \\\n\t\t\t    i {7 1 2 3 4 5 6} \\\n\t\t\t    abr [mc DAYS_OF_WEEK_ABBREV] \\\n\t\t\t    full [mc DAYS_OF_WEEK_FULL] {\n\t\t\t\tdict set l [string tolower $abr] $i\n\t\t\t\tdict set l [string tolower $full] $i\n\t\t\t\tincr i\n\t\t\t    }\n\t\t\tlassign [UniquePrefixRegexp $l] regex lookup\n\t\t\tappend re ( $regex )\n\t\t\tdict set fieldSet dayOfWeek [incr fieldCount]\n\t\t\tappend postcode \"dict set date dayOfWeek \\[\" \\\n\t\t\t    \"dict get \" [list $lookup] \" \" \\\n\t\t\t    \\[ {string tolower $field} [incr captureCount] \\] \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    b - B - h {\t\t# Name of month\n\t\t\tset i 0\n\t\t\tset l {}\n\t\t\tforeach \\\n\t\t\t    abr [mc MONTHS_ABBREV] \\\n\t\t\t    full [mc MONTHS_FULL] {\n\t\t\t\tincr i\n\t\t\t\tdict set l [string tolower $abr] $i\n\t\t\t\tdict set l [string tolower $full] $i\n\t\t\t    }\n\t\t\tlassign [UniquePrefixRegexp $l] regex lookup\n\t\t\tappend re ( $regex )\n\t\t\tdict set fieldSet month [incr fieldCount]\n\t\t\tappend postcode \"dict set date month \\[\" \\\n\t\t\t    \"dict get \" [list $lookup] \\\n\t\t\t    \" \" \\[ {string tolower $field} \\\n\t\t\t    [incr captureCount] \\] \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    C {\t\t\t# Gregorian century\n\t\t\tappend re \\\\s*(\\\\d\\\\d?)\n\t\t\tdict set fieldSet century [incr fieldCount]\n\t\t\tappend postcode \"dict set date century \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    d - e {\t\t# Day of month\n\t\t\tappend re \\\\s*(\\\\d\\\\d?)\n\t\t\tdict set fieldSet dayOfMonth [incr fieldCount]\n\t\t\tappend postcode \"dict set date dayOfMonth \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    E {\t\t\t# Prefix for locale-specific codes\n\t\t\tset state %E\n\t\t    }\n\t\t    g {\t\t\t# ISO8601 2-digit year\n\t\t\tappend re \\\\s*(\\\\d\\\\d)\n\t\t\tdict set fieldSet iso8601YearOfCentury \\\n\t\t\t    [incr fieldCount]\n\t\t\tappend postcode \\\n\t\t\t    \"dict set date iso8601YearOfCentury \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    G {\t\t\t# ISO8601 4-digit year\n\t\t\tappend re \\\\s*(\\\\d\\\\d)(\\\\d\\\\d)\n\t\t\tdict set fieldSet iso8601Century [incr fieldCount]\n\t\t\tdict set fieldSet iso8601YearOfCentury \\\n\t\t\t    [incr fieldCount]\n\t\t\tappend postcode \\\n\t\t\t    \"dict set date iso8601Century \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\" \\\n\t\t\t    \"dict set date iso8601YearOfCentury \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    H - k {\t\t# Hour of day\n\t\t\tappend re \\\\s*(\\\\d\\\\d?)\n\t\t\tdict set fieldSet hour [incr fieldCount]\n\t\t\tappend postcode \"dict set date hour \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    I - l {\t\t# Hour, AM/PM\n\t\t\tappend re \\\\s*(\\\\d\\\\d?)\n\t\t\tdict set fieldSet hourAMPM [incr fieldCount]\n\t\t\tappend postcode \"dict set date hourAMPM \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    j {\t\t\t# Day of year\n\t\t\tappend re \\\\s*(\\\\d\\\\d?\\\\d?)\n\t\t\tdict set fieldSet dayOfYear [incr fieldCount]\n\t\t\tappend postcode \"dict set date dayOfYear \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    J {\t\t\t# Julian Day Number\n\t\t\tappend re \\\\s*(\\\\d+)\n\t\t\tdict set fieldSet julianDay [incr fieldCount]\n\t\t\tappend postcode \"dict set date julianDay \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %ld\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    m - N {\t\t# Month number\n\t\t\tappend re \\\\s*(\\\\d\\\\d?)\n\t\t\tdict set fieldSet month [incr fieldCount]\n\t\t\tappend postcode \"dict set date month \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    M {\t\t\t# Minute\n\t\t\tappend re \\\\s*(\\\\d\\\\d?)\n\t\t\tdict set fieldSet minute [incr fieldCount]\n\t\t\tappend postcode \"dict set date minute \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    n {\t\t\t# Literal newline\n\t\t\tappend re \\\\n\n\t\t    }\n\t\t    O {\t\t\t# Prefix for locale numerics\n\t\t\tset state %O\n\t\t    }\n\t\t    p - P { \t\t# AM/PM indicator\n\t\t\tset l [list [string tolower [mc AM]] 0 \\\n\t\t\t\t   [string tolower [mc PM]] 1]\n\t\t\tlassign [UniquePrefixRegexp $l] regex lookup\n\t\t\tappend re ( $regex )\n\t\t\tdict set fieldSet amPmIndicator [incr fieldCount]\n\t\t\tappend postcode \"dict set date amPmIndicator \\[\" \\\n\t\t\t    \"dict get \" [list $lookup] \" \\[string tolower \" \\\n\t\t\t    \"\\$field\" \\\n\t\t\t    [incr captureCount] \\\n\t\t\t    \"\\]\\]\\n\"\n\t\t    }\n\t\t    Q {\t\t\t# Hi, Jeff!\n\t\t\tappend re {Stardate\\s+([-+]?\\d+)(\\d\\d\\d)[.](\\d)}\n\t\t\tincr captureCount\n\t\t\tdict set fieldSet seconds [incr fieldCount]\n\t\t\tappend postcode {dict set date seconds } \\[ \\\n\t\t\t    {ParseStarDate $field} [incr captureCount] \\\n\t\t\t    { $field} [incr captureCount] \\\n\t\t\t    { $field} [incr captureCount] \\\n\t\t\t    \\] \\n\n\t\t    }\n\t\t    s {\t\t\t# Seconds from Posix Epoch\n\t\t\t# This next case is insanely difficult, because it's\n\t\t\t# problematic to determine whether the field is\n\t\t\t# actually within the range of a wide integer.\n\t\t\tappend re {\\s*([-+]?\\d+)}\n\t\t\tdict set fieldSet seconds [incr fieldCount]\n\t\t\tappend postcode {dict set date seconds } \\[ \\\n\t\t\t    {ScanWide $field} [incr captureCount] \\] \\n\n\t\t    }\n\t\t    S {\t\t\t# Second\n\t\t\tappend re \\\\s*(\\\\d\\\\d?)\n\t\t\tdict set fieldSet second [incr fieldCount]\n\t\t\tappend postcode \"dict set date second \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    t {\t\t\t# Literal tab character\n\t\t\tappend re \\\\t\n\t\t    }\n\t\t    u - w {\t\t# Day number within week, 0 or 7 == Sun\n\t\t\t\t\t# 1=Mon, 6=Sat\n\t\t\tappend re \\\\s*(\\\\d)\n\t\t\tdict set fieldSet dayOfWeek [incr fieldCount]\n\t\t\tappend postcode {::scan $field} [incr captureCount] \\\n\t\t\t    { %d dow} \\n \\\n\t\t\t    {\n\t\t\t\tif { $dow == 0 } {\n\t\t\t\t    set dow 7\n\t\t\t\t} elseif { $dow > 7 } {\n\t\t\t\t    return -code error \\\n\t\t\t\t\t-errorcode [list CLOCK badDayOfWeek] \\\n\t\t\t\t\t\"day of week is greater than 7\"\n\t\t\t\t}\n\t\t\t\tdict set date dayOfWeek $dow\n\t\t\t    }\n\t\t    }\n\t\t    U {\t\t\t# Week of year. The first Sunday of\n\t\t\t\t\t# the year is the first day of week\n\t\t\t\t\t# 01. No scan rule uses this group.\n\t\t\tappend re \\\\s*\\\\d\\\\d?\n\t\t    }\n\t\t    V {\t\t\t# Week of ISO8601 year\n\n\t\t\tappend re \\\\s*(\\\\d\\\\d?)\n\t\t\tdict set fieldSet iso8601Week [incr fieldCount]\n\t\t\tappend postcode \"dict set date iso8601Week \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    W {\t\t\t# Week of the year (00-53). The first\n\t\t\t\t\t# Monday of the year is the first day\n\t\t\t\t\t# of week 01. No scan rule uses this\n\t\t\t\t\t# group.\n\t\t\tappend re \\\\s*\\\\d\\\\d?\n\t\t    }\n\t\t    y {\t\t\t# Two-digit Gregorian year\n\t\t\tappend re \\\\s*(\\\\d\\\\d?)\n\t\t\tdict set fieldSet yearOfCentury [incr fieldCount]\n\t\t\tappend postcode \"dict set date yearOfCentury \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    Y {\t\t\t# 4-digit Gregorian year\n\t\t\tappend re \\\\s*(\\\\d\\\\d)(\\\\d\\\\d)\n\t\t\tdict set fieldSet century [incr fieldCount]\n\t\t\tdict set fieldSet yearOfCentury [incr fieldCount]\n\t\t\tappend postcode \\\n\t\t\t    \"dict set date century \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\" \\\n\t\t\t    \"dict set date yearOfCentury \\[\" \\\n\t\t\t    \"::scan \\$field\" [incr captureCount] \" %d\" \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    z - Z {\t\t\t# Time zone name\n\t\t\tappend re {(?:([-+]\\d\\d(?::?\\d\\d(?::?\\d\\d)?)?)|([[:alnum:]]{1,4}))}\n\t\t\tdict set fieldSet tzName [incr fieldCount]\n\t\t\tappend postcode \\\n\t\t\t    {if } \\{ { $field} [incr captureCount] \\\n\t\t\t    { ne \"\" } \\} { } \\{ \\n \\\n\t\t\t    {dict set date tzName $field} \\\n\t\t\t    $captureCount \\n \\\n\t\t\t    \\} { else } \\{ \\n \\\n\t\t\t    {dict set date tzName } \\[ \\\n\t\t\t    {ConvertLegacyTimeZone $field} \\\n\t\t\t    [incr captureCount] \\] \\n \\\n\t\t\t    \\} \\n \\\n\t\t    }\n\t\t    % {\t\t\t# Literal percent character\n\t\t\tappend re %\n\t\t    }\n\t\t    default {\n\t\t\tappend re %\n\t\t\tif { ! [string is alnum $c] } {\n\t\t\t    append re \\\\\n\t\t\t    }\n\t\t\tappend re $c\n\t\t    }\n\t\t}\n\t    }\n\t    %E {\n\t\tswitch -exact -- $c {\n\t\t    C {\t\t\t# Locale-dependent era\n\t\t\tset d {}\n\t\t\tforeach triple [mc LOCALE_ERAS] {\n\t\t\t    lassign $triple t symbol year\n\t\t\t    dict set d [string tolower $symbol] $year\n\t\t\t}\n\t\t\tlassign [UniquePrefixRegexp $d] regex lookup\n\t\t\tappend re (?: $regex )\n\t\t    }\n\t\t    E {\n\t\t\tset l {}\n\t\t\tdict set l [string tolower [mc BCE]] BCE\n\t\t\tdict set l [string tolower [mc CE]] CE\n\t\t\tdict set l b.c.e. BCE\n\t\t\tdict set l c.e. CE\n\t\t\tdict set l b.c. BCE\n\t\t\tdict set l a.d. CE\n\t\t\tlassign [UniquePrefixRegexp $l] regex lookup\n\t\t\tappend re ( $regex )\n\t\t\tdict set fieldSet era [incr fieldCount]\n\t\t\tappend postcode \"dict set date era \\[\"\\\n\t\t\t    \"dict get \" [list $lookup] \\\n\t\t\t    { } \\[ {string tolower $field} \\\n\t\t\t    [incr captureCount] \\] \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    y {\t\t\t# Locale-dependent year of the era\n\t\t\tlassign [LocaleNumeralMatcher $locale] regex lookup\n\t\t\tappend re $regex\n\t\t\tincr captureCount\n\t\t    }\n\t\t    default {\n\t\t\tappend re %E\n\t\t\tif { ! [string is alnum $c] } {\n\t\t\t    append re \\\\\n\t\t\t    }\n\t\t\tappend re $c\n\t\t    }\n\t\t}\n\t\tset state {}\n\t    }\n\t    %O {\n\t\tswitch -exact -- $c {\n\t\t    d - e {\n\t\t\tlassign [LocaleNumeralMatcher $locale] regex lookup\n\t\t\tappend re $regex\n\t\t\tdict set fieldSet dayOfMonth [incr fieldCount]\n\t\t\tappend postcode \"dict set date dayOfMonth \\[\" \\\n\t\t\t    \"dict get \" [list $lookup] \" \\$field\" \\\n\t\t\t    [incr captureCount] \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    H - k {\n\t\t\tlassign [LocaleNumeralMatcher $locale] regex lookup\n\t\t\tappend re $regex\n\t\t\tdict set fieldSet hour [incr fieldCount]\n\t\t\tappend postcode \"dict set date hour \\[\" \\\n\t\t\t    \"dict get \" [list $lookup] \" \\$field\" \\\n\t\t\t    [incr captureCount] \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    I - l {\n\t\t\tlassign [LocaleNumeralMatcher $locale] regex lookup\n\t\t\tappend re $regex\n\t\t\tdict set fieldSet hourAMPM [incr fieldCount]\n\t\t\tappend postcode \"dict set date hourAMPM \\[\" \\\n\t\t\t    \"dict get \" [list $lookup] \" \\$field\" \\\n\t\t\t    [incr captureCount] \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    m {\n\t\t\tlassign [LocaleNumeralMatcher $locale] regex lookup\n\t\t\tappend re $regex\n\t\t\tdict set fieldSet month [incr fieldCount]\n\t\t\tappend postcode \"dict set date month \\[\" \\\n\t\t\t    \"dict get \" [list $lookup] \" \\$field\" \\\n\t\t\t    [incr captureCount] \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    M {\n\t\t\tlassign [LocaleNumeralMatcher $locale] regex lookup\n\t\t\tappend re $regex\n\t\t\tdict set fieldSet minute [incr fieldCount]\n\t\t\tappend postcode \"dict set date minute \\[\" \\\n\t\t\t    \"dict get \" [list $lookup] \" \\$field\" \\\n\t\t\t    [incr captureCount] \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    S {\n\t\t\tlassign [LocaleNumeralMatcher $locale] regex lookup\n\t\t\tappend re $regex\n\t\t\tdict set fieldSet second [incr fieldCount]\n\t\t\tappend postcode \"dict set date second \\[\" \\\n\t\t\t    \"dict get \" [list $lookup] \" \\$field\" \\\n\t\t\t    [incr captureCount] \\\n\t\t\t    \"\\]\\n\"\n\t\t    }\n\t\t    u - w {\n\t\t\tlassign [LocaleNumeralMatcher $locale] regex lookup\n\t\t\tappend re $regex\n\t\t\tdict set fieldSet dayOfWeek [incr fieldCount]\n\t\t\tappend postcode \"set dow \\[dict get \" [list $lookup] \\\n\t\t\t    { $field} [incr captureCount] \\] \\n \\\n\t\t\t    {\n\t\t\t\tif { $dow == 0 } {\n\t\t\t\t    set dow 7\n\t\t\t\t} elseif { $dow > 7 } {\n\t\t\t\t    return -code error \\\n\t\t\t\t\t-errorcode [list CLOCK badDayOfWeek] \\\n\t\t\t\t\t\"day of week is greater than 7\"\n\t\t\t\t}\n\t\t\t\tdict set date dayOfWeek $dow\n\t\t\t    }\n\t\t    }\n\t\t    y {\n\t\t\tlassign [LocaleNumeralMatcher $locale] regex lookup\n\t\t\tappend re $regex\n\t\t\tdict set fieldSet yearOfCentury [incr fieldCount]\n\t\t\tappend postcode {dict set date yearOfCentury } \\[ \\\n\t\t\t    {dict get } [list $lookup] { $field} \\\n\t\t\t    [incr captureCount] \\] \\n\n\t\t    }\n\t\t    default {\n\t\t\tappend re %O\n\t\t\tif { ! [string is alnum $c] } {\n\t\t\t    append re \\\\\n\t\t\t    }\n\t\t\tappend re $c\n\t\t    }\n\t\t}\n\t\tset state {}\n\t    }\n\t}\n    }\n\n    # Clean up any unfinished format groups\n\n    append re $state \\\\s*\\$\n\n    # Build the procedure\n\n    set procBody {}\n    append procBody \"variable ::tcl::clock::TZData\" \\n\n    append procBody \"if \\{ !\\[ regexp -nocase [list $re] \\$string ->\"\n    for { set i 1 } { $i <= $captureCount } { incr i } {\n\tappend procBody \" \" field $i\n    }\n    append procBody \"\\] \\} \\{\" \\n\n    append procBody {\n\treturn -code error -errorcode [list CLOCK badInputString] \\\n\t    {input string does not match supplied format}\n    }\n    append procBody \\}\\n\n    append procBody \"set date \\[dict create\\]\" \\n\n    append procBody {dict set date tzName $timeZone} \\n\n    append procBody $postcode\n    append procBody [list set changeover [mc GREGORIAN_CHANGE_DATE]] \\n\n\n    # Set up the time zone before doing anything with a default base date\n    # that might need a timezone to interpret it.\n\n    if { ![dict exists $fieldSet seconds]\n\t    && ![dict exists $fieldSet starDate] } {\n\tif { [dict exists $fieldSet tzName] } {\n\t    append procBody {\n\t\tset timeZone [dict get $date tzName]\n\t    }\n\t}\n\tappend procBody {\n\t    ::tcl::clock::SetupTimeZone $timeZone\n\t}\n    }\n\n    # Add code that gets Julian Day Number from the fields.\n\n    append procBody [MakeParseCodeFromFields $fieldSet $DateParseActions]\n\n    # Get time of day\n\n    append procBody [MakeParseCodeFromFields $fieldSet $TimeParseActions]\n\n    # Assemble seconds from the Julian day and second of the day.\n    # Convert to local time unless epoch seconds or stardate are\n    # being processed - they're always absolute\n\n    if { ![dict exists $fieldSet seconds]\n         && ![dict exists $fieldSet starDate] } {\n\tappend procBody {\n\t    if { [dict get $date julianDay] > 5373484 } {\n\t\treturn -code error -errorcode [list CLOCK dateTooLarge] \\\n\t\t    \"requested date too large to represent\"\n\t    }\n\t    dict set date localSeconds [expr {\n\t\t-210866803200\n\t\t+ ( 86400 * wide([dict get $date julianDay]) )\n\t\t+ [dict get $date secondOfDay]\n\t    }]\n\t}\n\n\t# Finally, convert the date to local time\n\n\tappend procBody {\n\t    set date [::tcl::clock::ConvertLocalToUTC $date[set date {}] \\\n\t\t\t  $TZData($timeZone) $changeover]\n\t}\n    }\n\n    # Return result\n\n    append procBody {return [dict get $date seconds]} \\n\n\n    proc $procName { string baseTime timeZone } $procBody\n\n    # puts [list proc $procName [list string baseTime timeZone] $procBody]\n\n    return $procName\n}\n\n#----------------------------------------------------------------------\n#\n# LocaleNumeralMatcher --\n#\n#\tComposes a regexp that captures the numerals in the given locale, and\n#\ta dictionary to map them to conventional numerals.\n#\n# Parameters:\n#\tlocale - Name of the current locale\n#\n# Results:\n#\tReturns a two-element list comprising the regexp and the dictionary.\n#\n# Side effects:\n#\tCaches the result.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::LocaleNumeralMatcher {l} {\n    variable LocaleNumeralCache\n\n    if { ![dict exists $LocaleNumeralCache $l] } {\n\tset d {}\n\tset i 0\n\tset sep \\(\n\tforeach n [mc LOCALE_NUMERALS] {\n\t    dict set d $n $i\n\t    regsub -all {[^[:alnum:]]} $n \\\\\\\\& subex\n\t    append re $sep $subex\n\t    set sep |\n\t    incr i\n\t}\n\tappend re \\)\n\tdict set LocaleNumeralCache $l [list $re $d]\n    }\n    return [dict get $LocaleNumeralCache $l]\n}\n\n\n\n#----------------------------------------------------------------------\n#\n# UniquePrefixRegexp --\n#\n#\tComposes a regexp that performs unique-prefix matching.  The RE\n#\tmatches one of a supplied set of strings, or any unique prefix\n#\tthereof.\n#\n# Parameters:\n#\tdata - List of alternating match-strings and values.\n#\t       Match-strings with distinct values are considered\n#\t       distinct.\n#\n# Results:\n#\tReturns a two-element list.  The first is a regexp that matches any\n#\tunique prefix of any of the strings.  The second is a dictionary whose\n#\tkeys are match values from the regexp and whose values are the\n#\tcorresponding values from 'data'.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::UniquePrefixRegexp { data } {\n    # The 'successors' dictionary will contain, for each string that is a\n    # prefix of any key, all characters that may follow that prefix.  The\n    # 'prefixMapping' dictionary will have keys that are prefixes of keys and\n    # values that correspond to the keys.\n\n    set prefixMapping [dict create]\n    set successors [dict create {} {}]\n\n    # Walk the key-value pairs\n\n    foreach { key value } $data {\n\t# Construct all prefixes of the key;\n\n\tset prefix {}\n\tforeach char [split $key {}] {\n\t    set oldPrefix $prefix\n\t    dict set successors $oldPrefix $char {}\n\t    append prefix $char\n\n\t    # Put the prefixes in the 'prefixMapping' and 'successors'\n\t    # dictionaries\n\n\t    dict lappend prefixMapping $prefix $value\n\t    if { ![dict exists $successors $prefix] } {\n\t\tdict set successors $prefix {}\n\t    }\n\t}\n    }\n\n    # Identify those prefixes that designate unique values, and those that are\n    # the full keys\n\n    set uniquePrefixMapping {}\n    dict for { key valueList } $prefixMapping {\n\tif { [llength $valueList] == 1 } {\n\t    dict set uniquePrefixMapping $key [lindex $valueList 0]\n\t}\n    }\n    foreach { key value } $data {\n\tdict set uniquePrefixMapping $key $value\n    }\n\n    # Construct the re.\n\n    return [list \\\n\t\t[MakeUniquePrefixRegexp $successors $uniquePrefixMapping {}] \\\n\t\t$uniquePrefixMapping]\n}\n\n#----------------------------------------------------------------------\n#\n# MakeUniquePrefixRegexp --\n#\n#\tService procedure for 'UniquePrefixRegexp' that constructs a regular\n#\texpresison that matches the unique prefixes.\n#\n# Parameters:\n#\tsuccessors - Dictionary whose keys are all prefixes\n#\t\t     of keys passed to 'UniquePrefixRegexp' and whose\n#\t\t     values are dictionaries whose keys are the characters\n#\t\t     that may follow those prefixes.\n#\tuniquePrefixMapping - Dictionary whose keys are the unique\n#\t\t\t      prefixes and whose values are not examined.\n#\tprefixString - Current prefix being processed.\n#\n# Results:\n#\tReturns a constructed regular expression that matches the set of\n#\tunique prefixes beginning with the 'prefixString'.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::MakeUniquePrefixRegexp { successors\n\t\t\t\t\t  uniquePrefixMapping\n\t\t\t\t\t  prefixString } {\n\n    # Get the characters that may follow the current prefix string\n\n    set schars [lsort -ascii [dict keys [dict get $successors $prefixString]]]\n    if { [llength $schars] == 0 } {\n\treturn {}\n    }\n\n    # If there is more than one successor character, or if the current prefix\n    # is a unique prefix, surround the generated re with non-capturing\n    # parentheses.\n\n    set re {}\n    if {\n\t[dict exists $uniquePrefixMapping $prefixString]\n\t|| [llength $schars] > 1\n    } then {\n\tappend re \"(?:\"\n    }\n\n    # Generate a regexp that matches the successors.\n\n    set sep \"\"\n    foreach { c } $schars {\n\tset nextPrefix $prefixString$c\n\tregsub -all {[^[:alnum:]]} $c \\\\\\\\& rechar\n\tappend re $sep $rechar \\\n\t    [MakeUniquePrefixRegexp \\\n\t\t $successors $uniquePrefixMapping $nextPrefix]\n\tset sep |\n    }\n\n    # If the current prefix is a unique prefix, make all following text\n    # optional. Otherwise, if there is more than one successor character,\n    # close the non-capturing parentheses.\n\n    if { [dict exists $uniquePrefixMapping $prefixString] } {\n\tappend re \")?\"\n    } elseif { [llength $schars] > 1 } {\n\tappend re \")\"\n    }\n\n    return $re\n}\n\n#----------------------------------------------------------------------\n#\n# MakeParseCodeFromFields --\n#\n#\tComposes Tcl code to extract the Julian Day Number from a dictionary\n#\tcontaining date fields.\n#\n# Parameters:\n#\tdateFields -- Dictionary whose keys are fields of the date,\n#\t              and whose values are the rightmost positions\n#\t\t      at which those fields appear.\n#\tparseActions -- List of triples: field set, priority, and\n#\t\t\tcode to emit.  Smaller priorities are better, and\n#\t\t\tthe list must be in ascending order by priority\n#\n# Results:\n#\tReturns a burst of code that extracts the day number from the given\n#\tdate.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::MakeParseCodeFromFields { dateFields parseActions } {\n\n    set currPrio 999\n    set currFieldPos [list]\n    set currCodeBurst {\n\terror \"in ::tcl::clock::MakeParseCodeFromFields: can't happen\"\n    }\n\n    foreach { fieldSet prio parseAction } $parseActions {\n\t# If we've found an answer that's better than any that follow, quit\n\t# now.\n\n\tif { $prio > $currPrio } {\n\t    break\n\t}\n\n\t# Accumulate the field positions that are used in the current field\n\t# grouping.\n\n\tset fieldPos [list]\n\tset ok true\n\tforeach field $fieldSet {\n\t    if { ! [dict exists $dateFields $field] } {\n\t\tset ok 0\n\t\tbreak\n\t    }\n\t    lappend fieldPos [dict get $dateFields $field]\n\t}\n\n\t# Quit if we don't have a complete set of fields\n\tif { !$ok } {\n\t    continue\n\t}\n\n\t# Determine whether the current answer is better than the last.\n\n\tset fPos [lsort -integer -decreasing $fieldPos]\n\n\tif { $prio ==  $currPrio } {\n\t    foreach currPos $currFieldPos newPos $fPos {\n\t\tif {\n\t\t    ![string is integer $newPos]\n\t\t    || ![string is integer $currPos]\n\t\t    || $newPos > $currPos\n\t\t} then {\n\t\t    break\n\t\t}\n\t\tif { $newPos < $currPos } {\n\t\t    set ok 0\n\t\t    break\n\t\t}\n\t    }\n\t}\n\tif { !$ok } {\n\t    continue\n\t}\n\n\t# Remember the best possibility for extracting date information\n\n\tset currPrio $prio\n\tset currFieldPos $fPos\n\tset currCodeBurst $parseAction\n    }\n\n    return $currCodeBurst\n}\n\n#----------------------------------------------------------------------\n#\n# EnterLocale --\n#\n#\tSwitch [mclocale] to a given locale if necessary\n#\n# Parameters:\n#\tlocale -- Desired locale\n#\n# Results:\n#\tReturns the locale that was previously current.\n#\n# Side effects:\n#\tDoes [mclocale].  If necessary, loades the designated locale's files.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::EnterLocale { locale } {\n    if { $locale eq {system} } {\n\tif { $::tcl_platform(platform) ne {windows} } {\n\t    # On a non-windows platform, the 'system' locale is the same as\n\t    # the 'current' locale\n\n\t    set locale current\n\t} else {\n\t    # On a windows platform, the 'system' locale is adapted from the\n\t    # 'current' locale by applying the date and time formats from the\n\t    # Control Panel.  First, load the 'current' locale if it's not yet\n\t    # loaded\n\n\t    mcpackagelocale set [mclocale]\n\n\t    # Make a new locale string for the system locale, and get the\n\t    # Control Panel information\n\n\t    set locale [mclocale]_windows\n\t    if { ! [mcpackagelocale present $locale] } {\n\t\tLoadWindowsDateTimeFormats $locale\n\t    }\n\t}\n    }\n    if { $locale eq {current}} {\n\tset locale [mclocale]\n    }\n    # Eventually load the locale\n    mcpackagelocale set $locale\n}\n\n#----------------------------------------------------------------------\n#\n# LoadWindowsDateTimeFormats --\n#\n#\tLoad the date/time formats from the Control Panel in Windows and\n#\tconvert them so that they're usable by Tcl.\n#\n# Parameters:\n#\tlocale - Name of the locale in whose message catalog\n#\t         the converted formats are to be stored.\n#\n# Results:\n#\tNone.\n#\n# Side effects:\n#\tUpdates the given message catalog with the locale strings.\n#\n# Presumes that on entry, [mclocale] is set to the current locale, so that\n# default strings can be obtained if the Registry query fails.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::LoadWindowsDateTimeFormats { locale } {\n    # Bail out if we can't find the Registry\n\n    variable NoRegistry\n    if { [info exists NoRegistry] } return\n\n    if { ![catch {\n\tregistry get \"HKEY_CURRENT_USER\\\\Control Panel\\\\International\" \\\n\t    sShortDate\n    } string] } {\n\tset quote {}\n\tset datefmt {}\n\tforeach { unquoted quoted } [split $string '] {\n\t    append datefmt $quote [string map {\n\t\tdddd %A\n\t\tddd  %a\n\t\tdd   %d\n\t\td    %e\n\t\tMMMM %B\n\t\tMMM  %b\n\t\tMM   %m\n\t\tM    %N\n\t\tyyyy %Y\n\t\tyy   %y\n                y    %y\n                gg   {}\n\t    } $unquoted]\n\t    if { $quoted eq {} } {\n\t\tset quote '\n\t    } else {\n\t\tset quote $quoted\n\t    }\n\t}\n\t::msgcat::mcset $locale DATE_FORMAT $datefmt\n    }\n\n    if { ![catch {\n\tregistry get \"HKEY_CURRENT_USER\\\\Control Panel\\\\International\" \\\n\t    sLongDate\n    } string] } {\n\tset quote {}\n\tset ldatefmt {}\n\tforeach { unquoted quoted } [split $string '] {\n\t    append ldatefmt $quote [string map {\n\t\tdddd %A\n\t\tddd  %a\n\t\tdd   %d\n\t\td    %e\n\t\tMMMM %B\n\t\tMMM  %b\n\t\tMM   %m\n\t\tM    %N\n\t\tyyyy %Y\n\t\tyy   %y\n                y    %y\n                gg   {}\n\t    } $unquoted]\n\t    if { $quoted eq {} } {\n\t\tset quote '\n\t    } else {\n\t\tset quote $quoted\n\t    }\n\t}\n\t::msgcat::mcset $locale LOCALE_DATE_FORMAT $ldatefmt\n    }\n\n    if { ![catch {\n\tregistry get \"HKEY_CURRENT_USER\\\\Control Panel\\\\International\" \\\n\t    sTimeFormat\n    } string] } {\n\tset quote {}\n\tset timefmt {}\n\tforeach { unquoted quoted } [split $string '] {\n\t    append timefmt $quote [string map {\n\t\tHH    %H\n\t\tH     %k\n\t\thh    %I\n\t\th     %l\n\t\tmm    %M\n\t\tm     %M\n\t\tss    %S\n\t\ts     %S\n\t\ttt    %p\n\t\tt     %p\n\t    } $unquoted]\n\t    if { $quoted eq {} } {\n\t\tset quote '\n\t    } else {\n\t\tset quote $quoted\n\t    }\n\t}\n\t::msgcat::mcset $locale TIME_FORMAT $timefmt\n    }\n\n    catch {\n\t::msgcat::mcset $locale DATE_TIME_FORMAT \"$datefmt $timefmt\"\n    }\n    catch {\n\t::msgcat::mcset $locale LOCALE_DATE_TIME_FORMAT \"$ldatefmt $timefmt\"\n    }\n\n    return\n\n}\n\n#----------------------------------------------------------------------\n#\n# LocalizeFormat --\n#\n#\tMap away locale-dependent format groups in a clock format.\n#\n# Parameters:\n#\tlocale -- Current [mclocale] locale, supplied to avoid\n#\t\t  an extra call\n#\tformat -- Format supplied to [clock scan] or [clock format]\n#\n# Results:\n#\tReturns the string with locale-dependent composite format groups\n#\tsubstituted out.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::LocalizeFormat { locale format } {\n\n    # message catalog key to cache this format\n    set key FORMAT_$format\n\n    if { [::msgcat::mcexists -exactlocale -exactnamespace $key] } {\n\treturn [mc $key]\n    }\n    # Handle locale-dependent format groups by mapping them out of the format\n    # string.  Note that the order of the [string map] operations is\n    # significant because later formats can refer to later ones; for example\n    # %c can refer to %X, which in turn can refer to %T.\n\n    set list {\n\t%% %%\n\t%D %m/%d/%Y\n\t%+ {%a %b %e %H:%M:%S %Z %Y}\n    }\n    lappend list %EY [string map $list [mc LOCALE_YEAR_FORMAT]]\n    lappend list %T  [string map $list [mc TIME_FORMAT_24_SECS]]\n    lappend list %R  [string map $list [mc TIME_FORMAT_24]]\n    lappend list %r  [string map $list [mc TIME_FORMAT_12]]\n    lappend list %X  [string map $list [mc TIME_FORMAT]]\n    lappend list %EX [string map $list [mc LOCALE_TIME_FORMAT]]\n    lappend list %x  [string map $list [mc DATE_FORMAT]]\n    lappend list %Ex [string map $list [mc LOCALE_DATE_FORMAT]]\n    lappend list %c  [string map $list [mc DATE_TIME_FORMAT]]\n    lappend list %Ec [string map $list [mc LOCALE_DATE_TIME_FORMAT]]\n    set format [string map $list $format]\n\n    ::msgcat::mcset $locale $key $format\n    return $format\n}\n\n#----------------------------------------------------------------------\n#\n# FormatNumericTimeZone --\n#\n#\tFormats a time zone as +hhmmss\n#\n# Parameters:\n#\tz - Time zone in seconds east of Greenwich\n#\n# Results:\n#\tReturns the time zone formatted in a numeric form\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::FormatNumericTimeZone { z } {\n    if { $z < 0 } {\n\tset z [expr { - $z }]\n\tset retval -\n    } else {\n\tset retval +\n    }\n    append retval [::format %02d [expr { $z / 3600 }]]\n    set z [expr { $z % 3600 }]\n    append retval [::format %02d [expr { $z / 60 }]]\n    set z [expr { $z % 60 }]\n    if { $z != 0 } {\n\tappend retval [::format %02d $z]\n    }\n    return $retval\n}\n\n#----------------------------------------------------------------------\n#\n# FormatStarDate --\n#\n#\tFormats a date as a StarDate.\n#\n# Parameters:\n#\tdate - Dictionary containing 'year', 'dayOfYear', and\n#\t       'localSeconds' fields.\n#\n# Results:\n#\tReturns the given date formatted as a StarDate.\n#\n# Side effects:\n#\tNone.\n#\n# Jeff Hobbs put this in to support an atrocious pun about Tcl being\n# \"Enterprise ready.\"  Now we're stuck with it.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::FormatStarDate { date } {\n    variable Roddenberry\n\n    # Get day of year, zero based\n\n    set doy [expr { [dict get $date dayOfYear] - 1 }]\n\n    # Determine whether the year is a leap year\n\n    set lp [IsGregorianLeapYear $date]\n\n    # Convert day of year to a fractional year\n\n    if { $lp } {\n\tset fractYear [expr { 1000 * $doy / 366 }]\n    } else {\n\tset fractYear [expr { 1000 * $doy / 365 }]\n    }\n\n    # Put together the StarDate\n\n    return [::format \"Stardate %02d%03d.%1d\" \\\n\t\t[expr { [dict get $date year] - $Roddenberry }] \\\n\t\t$fractYear \\\n\t\t[expr { [dict get $date localSeconds] % 86400\n\t\t\t/ ( 86400 / 10 ) }]]\n}\n\n#----------------------------------------------------------------------\n#\n# ParseStarDate --\n#\n#\tParses a StarDate\n#\n# Parameters:\n#\tyear - Year from the Roddenberry epoch\n#\tfractYear - Fraction of a year specifiying the day of year.\n#\tfractDay - Fraction of a day\n#\n# Results:\n#\tReturns a count of seconds from the Posix epoch.\n#\n# Side effects:\n#\tNone.\n#\n# Jeff Hobbs put this in to support an atrocious pun about Tcl being\n# \"Enterprise ready.\"  Now we're stuck with it.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::ParseStarDate { year fractYear fractDay } {\n    variable Roddenberry\n\n    # Build a tentative date from year and fraction.\n\n    set date [dict create \\\n\t\t  gregorian 1 \\\n\t\t  era CE \\\n\t\t  year [expr { $year + $Roddenberry }] \\\n\t\t  dayOfYear [expr { $fractYear * 365 / 1000 + 1 }]]\n    set date [GetJulianDayFromGregorianEraYearDay $date[set date {}]]\n\n    # Determine whether the given year is a leap year\n\n    set lp [IsGregorianLeapYear $date]\n\n    # Reconvert the fractional year according to whether the given year is a\n    # leap year\n\n    if { $lp } {\n\tdict set date dayOfYear \\\n\t    [expr { $fractYear * 366 / 1000 + 1 }]\n    } else {\n\tdict set date dayOfYear \\\n\t    [expr { $fractYear * 365 / 1000 + 1 }]\n    }\n    dict unset date julianDay\n    dict unset date gregorian\n    set date [GetJulianDayFromGregorianEraYearDay $date[set date {}]]\n\n    return [expr {\n\t86400 * [dict get $date julianDay]\n\t- 210866803200\n\t+ ( 86400 / 10 ) * $fractDay\n    }]\n}\n\n#----------------------------------------------------------------------\n#\n# ScanWide --\n#\n#\tScans a wide integer from an input\n#\n# Parameters:\n#\tstr - String containing a decimal wide integer\n#\n# Results:\n#\tReturns the string as a pure wide integer.  Throws an error if the\n#\tstring is misformatted or out of range.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::ScanWide { str } {\n    set count [::scan $str {%ld %c} result junk]\n    if { $count != 1 } {\n\treturn -code error -errorcode [list CLOCK notAnInteger $str] \\\n\t    \"\\\"$str\\\" is not an integer\"\n    }\n    if { [incr result 0] != $str } {\n\treturn -code error -errorcode [list CLOCK integervalueTooLarge] \\\n\t    \"integer value too large to represent\"\n    }\n    return $result\n}\n\n#----------------------------------------------------------------------\n#\n# InterpretTwoDigitYear --\n#\n#\tGiven a date that contains only the year of the century, determines\n#\tthe target value of a two-digit year.\n#\n# Parameters:\n#\tdate - Dictionary containing fields of the date.\n#\tbaseTime - Base time relative to which the date is expressed.\n#\ttwoDigitField - Name of the field that stores the two-digit year.\n#\t\t\tDefault is 'yearOfCentury'\n#\tfourDigitField - Name of the field that will receive the four-digit\n#\t                 year.  Default is 'year'\n#\n# Results:\n#\tReturns the dictionary augmented with the four-digit year, stored in\n#\tthe given key.\n#\n# Side effects:\n#\tNone.\n#\n# The current rule for interpreting a two-digit year is that the year shall be\n# between 1937 and 2037, thus staying within the range of a 32-bit signed\n# value for time.  This rule may change to a sliding window in future\n# versions, so the 'baseTime' parameter (which is currently ignored) is\n# provided in the procedure signature.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::InterpretTwoDigitYear { date baseTime\n\t\t\t\t\t   { twoDigitField yearOfCentury }\n\t\t\t\t\t   { fourDigitField year } } {\n    set yr [dict get $date $twoDigitField]\n    if { $yr <= 37 } {\n\tdict set date $fourDigitField [expr { $yr + 2000 }]\n    } else {\n\tdict set date $fourDigitField [expr { $yr + 1900 }]\n    }\n    return $date\n}\n\n#----------------------------------------------------------------------\n#\n# AssignBaseYear --\n#\n#\tPlaces the number of the current year into a dictionary.\n#\n# Parameters:\n#\tdate - Dictionary value to update\n#\tbaseTime - Base time from which to extract the year, expressed\n#\t\t   in seconds from the Posix epoch\n#\ttimezone - the time zone in which the date is being scanned\n#\tchangeover - the Julian Day on which the Gregorian calendar\n#\t\t     was adopted in the target locale.\n#\n# Results:\n#\tReturns the dictionary with the current year assigned.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::AssignBaseYear { date baseTime timezone changeover } {\n    variable TZData\n\n    # Find the Julian Day Number corresponding to the base time, and\n    # find the Gregorian year corresponding to that Julian Day.\n\n    set date2 [GetDateFields $baseTime $TZData($timezone) $changeover]\n\n    # Store the converted year\n\n    dict set date era [dict get $date2 era]\n    dict set date year [dict get $date2 year]\n\n    return $date\n}\n\n#----------------------------------------------------------------------\n#\n# AssignBaseIso8601Year --\n#\n#\tDetermines the base year in the ISO8601 fiscal calendar.\n#\n# Parameters:\n#\tdate - Dictionary containing the fields of the date that\n#\t       is to be augmented with the base year.\n#\tbaseTime - Base time expressed in seconds from the Posix epoch.\n#\ttimeZone - Target time zone\n#\tchangeover - Julian Day of adoption of the Gregorian calendar in\n#\t\t     the target locale.\n#\n# Results:\n#\tReturns the given date with \"iso8601Year\" set to the\n#\tbase year.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::AssignBaseIso8601Year {date baseTime timeZone changeover} {\n    variable TZData\n\n    # Find the Julian Day Number corresponding to the base time\n\n    set date2 [GetDateFields $baseTime $TZData($timeZone) $changeover]\n\n    # Calculate the ISO8601 date and transfer the year\n\n    dict set date era CE\n    dict set date iso8601Year [dict get $date2 iso8601Year]\n    return $date\n}\n\n#----------------------------------------------------------------------\n#\n# AssignBaseMonth --\n#\n#\tPlaces the number of the current year and month into a\n#\tdictionary.\n#\n# Parameters:\n#\tdate - Dictionary value to update\n#\tbaseTime - Time from which the year and month are to be\n#\t           obtained, expressed in seconds from the Posix epoch.\n#\ttimezone - Name of the desired time zone\n#\tchangeover - Julian Day on which the Gregorian calendar was adopted.\n#\n# Results:\n#\tReturns the dictionary with the base year and month assigned.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::AssignBaseMonth {date baseTime timezone changeover} {\n    variable TZData\n\n    # Find the year and month corresponding to the base time\n\n    set date2 [GetDateFields $baseTime $TZData($timezone) $changeover]\n    dict set date era [dict get $date2 era]\n    dict set date year [dict get $date2 year]\n    dict set date month [dict get $date2 month]\n    return $date\n}\n\n#----------------------------------------------------------------------\n#\n# AssignBaseWeek --\n#\n#\tDetermines the base year and week in the ISO8601 fiscal calendar.\n#\n# Parameters:\n#\tdate - Dictionary containing the fields of the date that\n#\t       is to be augmented with the base year and week.\n#\tbaseTime - Base time expressed in seconds from the Posix epoch.\n#\tchangeover - Julian Day on which the Gregorian calendar was adopted\n#\t\t     in the target locale.\n#\n# Results:\n#\tReturns the given date with \"iso8601Year\" set to the\n#\tbase year and \"iso8601Week\" to the week number.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::AssignBaseWeek {date baseTime timeZone changeover} {\n    variable TZData\n\n    # Find the Julian Day Number corresponding to the base time\n\n    set date2 [GetDateFields $baseTime $TZData($timeZone) $changeover]\n\n    # Calculate the ISO8601 date and transfer the year\n\n    dict set date era CE\n    dict set date iso8601Year [dict get $date2 iso8601Year]\n    dict set date iso8601Week [dict get $date2 iso8601Week]\n    return $date\n}\n\n#----------------------------------------------------------------------\n#\n# AssignBaseJulianDay --\n#\n#\tDetermines the base day for a time-of-day conversion.\n#\n# Parameters:\n#\tdate - Dictionary that is to get the base day\n#\tbaseTime - Base time expressed in seconds from the Posix epoch\n#\tchangeover - Julian day on which the Gregorian calendar was\n#\t\t     adpoted in the target locale.\n#\n# Results:\n#\tReturns the given dictionary augmented with a 'julianDay' field\n#\tthat contains the base day.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::AssignBaseJulianDay { date baseTime timeZone changeover } {\n    variable TZData\n\n    # Find the Julian Day Number corresponding to the base time\n\n    set date2 [GetDateFields $baseTime $TZData($timeZone) $changeover]\n    dict set date julianDay [dict get $date2 julianDay]\n\n    return $date\n}\n\n#----------------------------------------------------------------------\n#\n# InterpretHMSP --\n#\n#\tInterprets a time in the form \"hh:mm:ss am\".\n#\n# Parameters:\n#\tdate -- Dictionary containing \"hourAMPM\", \"minute\", \"second\"\n#\t        and \"amPmIndicator\" fields.\n#\n# Results:\n#\tReturns the number of seconds from local midnight.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::InterpretHMSP { date } {\n    set hr [dict get $date hourAMPM]\n    if { $hr == 12 } {\n\tset hr 0\n    }\n    if { [dict get $date amPmIndicator] } {\n\tincr hr 12\n    }\n    dict set date hour $hr\n    return [InterpretHMS $date[set date {}]]\n}\n\n#----------------------------------------------------------------------\n#\n# InterpretHMS --\n#\n#\tInterprets a 24-hour time \"hh:mm:ss\"\n#\n# Parameters:\n#\tdate -- Dictionary containing the \"hour\", \"minute\" and \"second\"\n#\t        fields.\n#\n# Results:\n#\tReturns the given dictionary augmented with a \"secondOfDay\"\n#\tfield containing the number of seconds from local midnight.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::InterpretHMS { date } {\n    return [expr {\n\t( [dict get $date hour] * 60\n\t  + [dict get $date minute] ) * 60\n\t+ [dict get $date second]\n    }]\n}\n\n#----------------------------------------------------------------------\n#\n# GetSystemTimeZone --\n#\n#\tDetermines the system time zone, which is the default for the\n#\t'clock' command if no other zone is supplied.\n#\n# Parameters:\n#\tNone.\n#\n# Results:\n#\tReturns the system time zone.\n#\n# Side effects:\n#\tStores the sustem time zone in the 'CachedSystemTimeZone'\n#\tvariable, since determining it may be an expensive process.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::GetSystemTimeZone {} {\n    variable CachedSystemTimeZone\n    variable TimeZoneBad\n\n    if {[set result [getenv TCL_TZ]] ne {}} {\n\tset timezone $result\n    } elseif {[set result [getenv TZ]] ne {}} {\n\tset timezone $result\n    } else {\n        # Cache the time zone only if it was detected by one of the\n        # expensive methods.\n        if { [info exists CachedSystemTimeZone] } {\n            set timezone $CachedSystemTimeZone\n        } elseif { $::tcl_platform(platform) eq {windows} } {\n            set timezone [GuessWindowsTimeZone]\n        } elseif { [file exists /etc/localtime]\n                   && ![catch {ReadZoneinfoFile \\\n                                   Tcl/Localtime /etc/localtime}] } {\n            set timezone :Tcl/Localtime\n        } else {\n            set timezone :localtime\n        }\n\tset CachedSystemTimeZone $timezone\n    }\n    if { ![dict exists $TimeZoneBad $timezone] } {\n\tdict set TimeZoneBad $timezone [catch {SetupTimeZone $timezone}]\n    }\n    if { [dict get $TimeZoneBad $timezone] } {\n\treturn :localtime\n    } else {\n\treturn $timezone\n    }\n}\n\n#----------------------------------------------------------------------\n#\n# ConvertLegacyTimeZone --\n#\n#\tGiven an alphanumeric time zone identifier and the system time zone,\n#\tconvert the alphanumeric identifier to an unambiguous time zone.\n#\n# Parameters:\n#\ttzname - Name of the time zone to convert\n#\n# Results:\n#\tReturns a time zone name corresponding to tzname, but in an\n#\tunambiguous form, generally +hhmm.\n#\n# This procedure is implemented primarily to allow the parsing of RFC822\n# date/time strings.  Processing a time zone name on input is not recommended\n# practice, because there is considerable room for ambiguity; for instance, is\n# BST Brazilian Standard Time, or British Summer Time?\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::ConvertLegacyTimeZone { tzname } {\n    variable LegacyTimeZone\n\n    set tzname [string tolower $tzname]\n    if { ![dict exists $LegacyTimeZone $tzname] } {\n\treturn -code error -errorcode [list CLOCK badTZName $tzname] \\\n\t    \"time zone \\\"$tzname\\\" not found\"\n    }\n    return [dict get $LegacyTimeZone $tzname]\n}\n\n#----------------------------------------------------------------------\n#\n# SetupTimeZone --\n#\n#\tGiven the name or specification of a time zone, sets up its in-memory\n#\tdata.\n#\n# Parameters:\n#\ttzname - Name of a time zone\n#\n# Results:\n#\tUnless the time zone is ':localtime', sets the TZData array to contain\n#\tthe lookup table for local<->UTC conversion.  Returns an error if the\n#\ttime zone cannot be parsed.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::SetupTimeZone { timezone } {\n    variable TZData\n\n    if {! [info exists TZData($timezone)] } {\n\tvariable MINWIDE\n\tif { $timezone eq {:localtime} } {\n\t    # Nothing to do, we'll convert using the localtime function\n\n\t} elseif {\n\t    [regexp {^([-+])(\\d\\d)(?::?(\\d\\d)(?::?(\\d\\d))?)?} $timezone \\\n\t\t    -> s hh mm ss]\n\t} then {\n\t    # Make a fixed offset\n\n\t    ::scan $hh %d hh\n\t    if { $mm eq {} } {\n\t\tset mm 0\n\t    } else {\n\t\t::scan $mm %d mm\n\t    }\n\t    if { $ss eq {} } {\n\t\tset ss 0\n\t    } else {\n\t\t::scan $ss %d ss\n\t    }\n\t    set offset [expr { ( $hh * 60 + $mm ) * 60 + $ss }]\n\t    if { $s eq {-} } {\n\t\tset offset [expr { - $offset }]\n\t    }\n\t    set TZData($timezone) [list [list $MINWIDE $offset -1 $timezone]]\n\n\t} elseif { [string index $timezone 0] eq {:} } {\n\t    # Convert using a time zone file\n\n\t    if {\n\t\t[catch {\n\t\t    LoadTimeZoneFile [string range $timezone 1 end]\n\t\t}] && [catch {\n\t\t    LoadZoneinfoFile [string range $timezone 1 end]\n\t\t}]\n\t    } then {\n\t\treturn -code error \\\n\t\t    -errorcode [list CLOCK badTimeZone $timezone] \\\n\t\t    \"time zone \\\"$timezone\\\" not found\"\n\t    }\n\t} elseif { ![catch {ParsePosixTimeZone $timezone} tzfields] } {\n\t    # This looks like a POSIX time zone - try to process it\n\n\t    if { [catch {ProcessPosixTimeZone $tzfields} data opts] } {\n\t\tif { [lindex [dict get $opts -errorcode] 0] eq {CLOCK} } {\n\t\t    dict unset opts -errorinfo\n\t\t}\n\t\treturn -options $opts $data\n\t    } else {\n\t\tset TZData($timezone) $data\n\t    }\n\n\t} else {\n\t    # We couldn't parse this as a POSIX time zone.  Try again with a\n\t    # time zone file - this time without a colon\n\n\t    if { [catch { LoadTimeZoneFile $timezone }]\n\t\t && [catch { LoadZoneinfoFile $timezone } - opts] } {\n\t\tdict unset opts -errorinfo\n\t\treturn -options $opts \"time zone $timezone not found\"\n\t    }\n\t    set TZData($timezone) $TZData(:$timezone)\n\t}\n    }\n\n    return\n}\n\n#----------------------------------------------------------------------\n#\n# GuessWindowsTimeZone --\n#\n#\tDetermines the system time zone on windows.\n#\n# Parameters:\n#\tNone.\n#\n# Results:\n#\tReturns a time zone specifier that corresponds to the system time zone\n#\tinformation found in the Registry.\n#\n# Bugs:\n#\tFixed dates for DST change are unimplemented at present, because no\n#\ttime zone information supplied with Windows actually uses them!\n#\n# On a Windows system where neither $env(TCL_TZ) nor $env(TZ) is specified,\n# GuessWindowsTimeZone looks in the Registry for the system time zone\n# information.  It then attempts to find an entry in WinZoneInfo for a time\n# zone that uses the same rules.  If it finds one, it returns it; otherwise,\n# it constructs a Posix-style time zone string and returns that.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::GuessWindowsTimeZone {} {\n    variable WinZoneInfo\n    variable NoRegistry\n    variable TimeZoneBad\n\n    if { [info exists NoRegistry] } {\n\treturn :localtime\n    }\n\n    # Dredge time zone information out of the registry\n\n    if { [catch {\n\tset rpath HKEY_LOCAL_MACHINE\\\\System\\\\CurrentControlSet\\\\Control\\\\TimeZoneInformation\n\tset data [list \\\n\t\t      [expr { -60\n\t\t\t      * [registry get $rpath Bias] }] \\\n\t\t      [expr { -60\n\t\t\t\t  * [registry get $rpath StandardBias] }] \\\n\t\t      [expr { -60 \\\n\t\t\t\t  * [registry get $rpath DaylightBias] }]]\n\tset stdtzi [registry get $rpath StandardStart]\n\tforeach ind {0 2 14 4 6 8 10 12} {\n\t    binary scan $stdtzi @${ind}s val\n\t    lappend data $val\n\t}\n\tset daytzi [registry get $rpath DaylightStart]\n\tforeach ind {0 2 14 4 6 8 10 12} {\n\t    binary scan $daytzi @${ind}s val\n\t    lappend data $val\n\t}\n    }] } {\n\t# Missing values in the Registry - bail out\n\n\treturn :localtime\n    }\n\n    # Make up a Posix time zone specifier if we can't find one.  Check here\n    # that the tzdata file exists, in case we're running in an environment\n    # (e.g. starpack) where tzdata is incomplete.  (Bug 1237907)\n\n    if { [dict exists $WinZoneInfo $data] } {\n\tset tzname [dict get $WinZoneInfo $data]\n\tif { ! [dict exists $TimeZoneBad $tzname] } {\n\t    dict set TimeZoneBad $tzname [catch {SetupTimeZone $tzname}]\n\t}\n    } else {\n\tset tzname {}\n    }\n    if { $tzname eq {} || [dict get $TimeZoneBad $tzname] } {\n\tlassign $data \\\n\t    bias stdBias dstBias \\\n\t    stdYear stdMonth stdDayOfWeek stdDayOfMonth \\\n\t    stdHour stdMinute stdSecond stdMillisec \\\n\t    dstYear dstMonth dstDayOfWeek dstDayOfMonth \\\n\t    dstHour dstMinute dstSecond dstMillisec\n\tset stdDelta [expr { $bias + $stdBias }]\n\tset dstDelta [expr { $bias + $dstBias }]\n\tif { $stdDelta <= 0 } {\n\t    set stdSignum +\n\t    set stdDelta [expr { - $stdDelta }]\n\t    set dispStdSignum -\n\t} else {\n\t    set stdSignum -\n\t    set dispStdSignum +\n\t}\n\tset hh [::format %02d [expr { $stdDelta / 3600 }]]\n\tset mm [::format %02d [expr { ($stdDelta / 60 ) % 60 }]]\n\tset ss [::format %02d [expr { $stdDelta % 60 }]]\n\tset tzname {}\n\tappend tzname < $dispStdSignum $hh $mm > $stdSignum $hh : $mm : $ss\n\tif { $stdMonth >= 0 } {\n\t    if { $dstDelta <= 0 } {\n\t\tset dstSignum +\n\t\tset dstDelta [expr { - $dstDelta }]\n\t\tset dispDstSignum -\n\t    } else {\n\t\tset dstSignum -\n\t\tset dispDstSignum +\n\t    }\n\t    set hh [::format %02d [expr { $dstDelta / 3600 }]]\n\t    set mm [::format %02d [expr { ($dstDelta / 60 ) % 60 }]]\n\t    set ss [::format %02d [expr { $dstDelta % 60 }]]\n\t    append tzname < $dispDstSignum $hh $mm > $dstSignum $hh : $mm : $ss\n\t    if { $dstYear == 0 } {\n\t\tappend tzname ,M $dstMonth . $dstDayOfMonth . $dstDayOfWeek\n\t    } else {\n\t\t# I have not been able to find any locale on which Windows\n\t\t# converts time zone on a fixed day of the year, hence don't\n\t\t# know how to interpret the fields.  If someone can inform me,\n\t\t# I'd be glad to code it up.  For right now, we bail out in\n\t\t# such a case.\n\t\treturn :localtime\n\t    }\n\t    append tzname / [::format %02d $dstHour] \\\n\t\t: [::format %02d $dstMinute] \\\n\t\t: [::format %02d $dstSecond]\n\t    if { $stdYear == 0 } {\n\t\tappend tzname ,M $stdMonth . $stdDayOfMonth . $stdDayOfWeek\n\t    } else {\n\t\t# I have not been able to find any locale on which Windows\n\t\t# converts time zone on a fixed day of the year, hence don't\n\t\t# know how to interpret the fields.  If someone can inform me,\n\t\t# I'd be glad to code it up.  For right now, we bail out in\n\t\t# such a case.\n\t\treturn :localtime\n\t    }\n\t    append tzname / [::format %02d $stdHour] \\\n\t\t: [::format %02d $stdMinute] \\\n\t\t: [::format %02d $stdSecond]\n\t}\n\tdict set WinZoneInfo $data $tzname\n    }\n\n    return [dict get $WinZoneInfo $data]\n}\n\n#----------------------------------------------------------------------\n#\n# LoadTimeZoneFile --\n#\n#\tLoad the data file that specifies the conversion between a\n#\tgiven time zone and Greenwich.\n#\n# Parameters:\n#\tfileName -- Name of the file to load\n#\n# Results:\n#\tNone.\n#\n# Side effects:\n#\tTZData(:fileName) contains the time zone data\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::LoadTimeZoneFile { fileName } {\n    variable DataDir\n    variable TZData\n\n    if { [info exists TZData($fileName)] } {\n\treturn\n    }\n\n    # Since an unsafe interp uses the [clock] command in the parent, this code\n    # is security sensitive.  Make sure that the path name cannot escape the\n    # given directory.\n\n    if { ![regexp {^[[.-.][:alpha:]_]+(?:/[[.-.][:alpha:]_]+)*$} $fileName] } {\n\treturn -code error \\\n\t    -errorcode [list CLOCK badTimeZone $:fileName] \\\n\t    \"time zone \\\":$fileName\\\" not valid\"\n    }\n    try {\n\tsource -encoding utf-8 [file join $DataDir $fileName]\n    } on error {} {\n\treturn -code error \\\n\t    -errorcode [list CLOCK badTimeZone :$fileName] \\\n\t    \"time zone \\\":$fileName\\\" not found\"\n    }\n    return\n}\n\n#----------------------------------------------------------------------\n#\n# LoadZoneinfoFile --\n#\n#\tLoads a binary time zone information file in Olson format.\n#\n# Parameters:\n#\tfileName - Relative path name of the file to load.\n#\n# Results:\n#\tReturns an empty result normally; returns an error if no Olson file\n#\twas found or the file was malformed in some way.\n#\n# Side effects:\n#\tTZData(:fileName) contains the time zone data\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::LoadZoneinfoFile { fileName } {\n    variable ZoneinfoPaths\n\n    # Since an unsafe interp uses the [clock] command in the parent, this code\n    # is security sensitive.  Make sure that the path name cannot escape the\n    # given directory.\n\n    if { ![regexp {^[[.-.][:alpha:]_]+(?:/[[.-.][:alpha:]_]+)*$} $fileName] } {\n\treturn -code error \\\n\t    -errorcode [list CLOCK badTimeZone $:fileName] \\\n\t    \"time zone \\\":$fileName\\\" not valid\"\n    }\n    foreach d $ZoneinfoPaths {\n\tset fname [file join $d $fileName]\n\tif { [file readable $fname] && [file isfile $fname] } {\n\t    break\n\t}\n\tunset fname\n    }\n    ReadZoneinfoFile $fileName $fname\n}\n\n#----------------------------------------------------------------------\n#\n# ReadZoneinfoFile --\n#\n#\tLoads a binary time zone information file in Olson format.\n#\n# Parameters:\n#\tfileName - Name of the time zone (relative path name of the\n#\t\t   file).\n#\tfname - Absolute path name of the file.\n#\n# Results:\n#\tReturns an empty result normally; returns an error if no Olson file\n#\twas found or the file was malformed in some way.\n#\n# Side effects:\n#\tTZData(:fileName) contains the time zone data\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::ReadZoneinfoFile {fileName fname} {\n    variable MINWIDE\n    variable TZData\n    if { ![file exists $fname] } {\n\treturn -code error \"$fileName not found\"\n    }\n\n    if { [file size $fname] > 262144 } {\n\treturn -code error \"$fileName too big\"\n    }\n\n    # Suck in all the data from the file\n\n    set f [open $fname r]\n    fconfigure $f -translation binary\n    set d [read $f]\n    close $f\n\n    # The file begins with a magic number, sixteen reserved bytes, and then\n    # six 4-byte integers giving counts of fileds in the file.\n\n    binary scan $d a4a1x15IIIIII \\\n\tmagic version nIsGMT nIsStd nLeap nTime nType nChar\n    set seek 44\n    set ilen 4\n    set iformat I\n    if { $magic != {TZif} } {\n\treturn -code error \"$fileName not a time zone information file\"\n    }\n    if { $nType > 255 } {\n\treturn -code error \"$fileName contains too many time types\"\n    }\n    # Accept only Posix-style zoneinfo.  Sorry, 'leaps' bigots.\n    if { $nLeap != 0 } {\n\treturn -code error \"$fileName contains leap seconds\"\n    }\n\n    # In a version 2 file, we use the second part of the file, which contains\n    # 64-bit transition times.\n\n    if {$version eq \"2\"} {\n\tset seek [expr {\n\t    44\n\t    + 5 * $nTime\n\t    + 6 * $nType\n\t    + 4 * $nLeap\n\t    + $nIsStd\n\t    + $nIsGMT\n\t    + $nChar\n\t}]\n\tbinary scan $d @${seek}a4a1x15IIIIII \\\n\t    magic version nIsGMT nIsStd nLeap nTime nType nChar\n\tif {$magic ne {TZif}} {\n\t    return -code error \"seek address $seek miscomputed, magic = $magic\"\n\t}\n\tset iformat W\n\tset ilen 8\n\tincr seek 44\n    }\n\n    # Next come ${nTime} transition times, followed by ${nTime} time type\n    # codes.  The type codes are unsigned 1-byte quantities.  We insert an\n    # arbitrary start time in front of the transitions.\n\n    binary scan $d @${seek}${iformat}${nTime}c${nTime} times tempCodes\n    incr seek [expr { ($ilen + 1) * $nTime }]\n    set times [linsert $times 0 $MINWIDE]\n    set codes {}\n    foreach c $tempCodes {\n\tlappend codes [expr { $c & 0xFF }]\n    }\n    set codes [linsert $codes 0 0]\n\n    # Next come ${nType} time type descriptions, each of which has an offset\n    # (seconds east of GMT), a DST indicator, and an index into the\n    # abbreviation text.\n\n    for { set i 0 } { $i < $nType } { incr i } {\n\tbinary scan $d @${seek}Icc gmtOff isDst abbrInd\n\tlappend types [list $gmtOff $isDst $abbrInd]\n\tincr seek 6\n    }\n\n    # Next come $nChar characters of time zone name abbreviations, which are\n    # null-terminated.\n    # We build them up into a dictionary indexed by character index, because\n    # that's what's in the indices above.\n\n    binary scan $d @${seek}a${nChar} abbrs\n    incr seek ${nChar}\n    set abbrList [split $abbrs \\0]\n    set i 0\n    set abbrevs {}\n    foreach a $abbrList {\n\tfor {set j 0} {$j <= [string length $a]} {incr j} {\n\t    dict set abbrevs $i [string range $a $j end]\n\t    incr i\n\t}\n    }\n\n    # Package up a list of tuples, each of which contains transition time,\n    # seconds east of Greenwich, DST flag and time zone abbreviation.\n\n    set r {}\n    set lastTime $MINWIDE\n    foreach t $times c $codes {\n\tif { $t < $lastTime } {\n\t    return -code error \"$fileName has times out of order\"\n\t}\n\tset lastTime $t\n\tlassign [lindex $types $c] gmtoff isDst abbrInd\n\tset abbrev [dict get $abbrevs $abbrInd]\n\tlappend r [list $t $gmtoff $isDst $abbrev]\n    }\n\n    # In a version 2 file, there is also a POSIX-style time zone description\n    # at the very end of the file.  To get to it, skip over nLeap leap second\n    # values (8 bytes each),\n    # nIsStd standard/DST indicators and nIsGMT UTC/local indicators.\n\n    if {$version eq {2}} {\n\tset seek [expr {$seek + 8 * $nLeap + $nIsStd + $nIsGMT + 1}]\n\tset last [string first \\n $d $seek]\n\tset posix [string range $d $seek [expr {$last-1}]]\n\tif {[llength $posix] > 0} {\n\t    set posixFields [ParsePosixTimeZone $posix]\n\t    foreach tuple [ProcessPosixTimeZone $posixFields] {\n\t\tlassign $tuple t gmtoff isDst abbrev\n\t\tif {$t > $lastTime} {\n\t\t    lappend r $tuple\n\t\t}\n\t    }\n\t}\n    }\n\n    set TZData(:$fileName) $r\n\n    return\n}\n\n#----------------------------------------------------------------------\n#\n# ParsePosixTimeZone --\n#\n#\tParses the TZ environment variable in Posix form\n#\n# Parameters:\n#\ttz\tTime zone specifier to be interpreted\n#\n# Results:\n#\tReturns a dictionary whose values contain the various pieces of the\n#\ttime zone specification.\n#\n# Side effects:\n#\tNone.\n#\n# Errors:\n#\tThrows an error if the syntax of the time zone is incorrect.\n#\n# The following keys are present in the dictionary:\n#\tstdName - Name of the time zone when Daylight Saving Time\n#\t\t  is not in effect.\n#\tstdSignum - Sign (+, -, or empty) of the offset from Greenwich\n#\t\t    to the given (non-DST) time zone.  + and the empty\n#\t\t    string denote zones west of Greenwich, - denotes east\n#\t\t    of Greenwich; this is contrary to the ISO convention\n#\t\t    but follows Posix.\n#\tstdHours - Hours part of the offset from Greenwich to the given\n#\t\t   (non-DST) time zone.\n#\tstdMinutes - Minutes part of the offset from Greenwich to the\n#\t\t     given (non-DST) time zone. Empty denotes zero.\n#\tstdSeconds - Seconds part of the offset from Greenwich to the\n#\t\t     given (non-DST) time zone. Empty denotes zero.\n#\tdstName - Name of the time zone when DST is in effect, or the\n#\t\t  empty string if the time zone does not observe Daylight\n#\t\t  Saving Time.\n#\tdstSignum, dstHours, dstMinutes, dstSeconds -\n#\t\tFields corresponding to stdSignum, stdHours, stdMinutes,\n#\t\tstdSeconds for the Daylight Saving Time version of the\n#\t\ttime zone.  If dstHours is empty, it is presumed to be 1.\n#\tstartDayOfYear - The ordinal number of the day of the year on which\n#\t\t\t Daylight Saving Time begins.  If this field is\n#\t\t\t empty, then DST begins on a given month-week-day,\n#\t\t\t as below.\n#\tstartJ - The letter J, or an empty string.  If a J is present in\n#\t\t this field, then startDayOfYear does not count February 29\n#\t\t even in leap years.\n#\tstartMonth - The number of the month in which Daylight Saving Time\n#\t\t     begins, supplied if startDayOfYear is empty.  If both\n#\t\t     startDayOfYear and startMonth are empty, then US rules\n#\t\t     are presumed.\n#\tstartWeekOfMonth - The number of the week in the month in which\n#\t\t\t   Daylight Saving Time begins, in the range 1-5.\n#\t\t\t   5 denotes the last week of the month even in a\n#\t\t\t   4-week month.\n#\tstartDayOfWeek - The number of the day of the week (Sunday=0,\n#\t\t\t Saturday=6) on which Daylight Saving Time begins.\n#\tstartHours - The hours part of the time of day at which Daylight\n#\t\t     Saving Time begins. An empty string is presumed to be 2.\n#\tstartMinutes - The minutes part of the time of day at which DST begins.\n#\t\t       An empty string is presumed zero.\n#\tstartSeconds - The seconds part of the time of day at which DST begins.\n#\t\t       An empty string is presumed zero.\n#\tendDayOfYear, endJ, endMonth, endWeekOfMonth, endDayOfWeek,\n#\tendHours, endMinutes, endSeconds -\n#\t\tSpecify the end of DST in the same way that the start* fields\n#\t\tspecify the beginning of DST.\n#\n# This procedure serves only to break the time specifier into fields.  No\n# attempt is made to canonicalize the fields or supply default values.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::ParsePosixTimeZone { tz } {\n    if {[regexp -expanded -nocase -- {\n\t^\n\t# 1 - Standard time zone name\n\t([[:alpha:]]+ | <[-+[:alnum:]]+>)\n\t# 2 - Standard time zone offset, signum\n\t([-+]?)\n\t# 3 - Standard time zone offset, hours\n\t([[:digit:]]{1,2})\n\t(?:\n\t    # 4 - Standard time zone offset, minutes\n\t    : ([[:digit:]]{1,2})\n\t    (?:\n\t        # 5 - Standard time zone offset, seconds\n\t\t: ([[:digit:]]{1,2} )\n\t    )?\n\t)?\n\t(?:\n\t    # 6 - DST time zone name\n\t    ([[:alpha:]]+ | <[-+[:alnum:]]+>)\n\t    (?:\n\t        (?:\n\t\t    # 7 - DST time zone offset, signum\n\t\t    ([-+]?)\n\t\t    # 8 - DST time zone offset, hours\n\t\t    ([[:digit:]]{1,2})\n\t\t    (?:\n\t\t\t# 9 - DST time zone offset, minutes\n\t\t\t: ([[:digit:]]{1,2})\n\t\t\t(?:\n\t\t            # 10 - DST time zone offset, seconds\n\t\t\t    : ([[:digit:]]{1,2})\n\t\t\t)?\n\t\t    )?\n\t\t)?\n\t        (?:\n\t\t    ,\n\t\t    (?:\n\t\t\t# 11 - Optional J in n and Jn form 12 - Day of year\n\t\t        ( J ? )\t( [[:digit:]]+ )\n                        | M\n\t\t\t# 13 - Month number 14 - Week of month 15 - Day of week\n\t\t\t( [[:digit:]] + )\n\t\t\t[.] ( [[:digit:]] + )\n\t\t\t[.] ( [[:digit:]] + )\n\t\t    )\n\t\t    (?:\n\t\t\t# 16 - Start time of DST - hours\n\t\t\t/ ( [[:digit:]]{1,2} )\n\t\t        (?:\n\t\t\t    # 17 - Start time of DST - minutes\n\t\t\t    : ( [[:digit:]]{1,2} )\n\t\t\t    (?:\n\t\t\t\t# 18 - Start time of DST - seconds\n\t\t\t\t: ( [[:digit:]]{1,2} )\n\t\t\t    )?\n\t\t\t)?\n\t\t    )?\n\t\t    ,\n\t\t    (?:\n\t\t\t# 19 - Optional J in n and Jn form 20 - Day of year\n\t\t        ( J ? )\t( [[:digit:]]+ )\n                        | M\n\t\t\t# 21 - Month number 22 - Week of month 23 - Day of week\n\t\t\t( [[:digit:]] + )\n\t\t\t[.] ( [[:digit:]] + )\n\t\t\t[.] ( [[:digit:]] + )\n\t\t    )\n\t\t    (?:\n\t\t\t# 24 - End time of DST - hours\n\t\t\t/ ( [[:digit:]]{1,2} )\n\t\t        (?:\n\t\t\t    # 25 - End time of DST - minutes\n\t\t\t    : ( [[:digit:]]{1,2} )\n\t\t\t    (?:\n\t\t\t\t# 26 - End time of DST - seconds\n\t\t\t\t: ( [[:digit:]]{1,2} )\n\t\t\t    )?\n\t\t\t)?\n\t\t    )?\n                )?\n\t    )?\n        )?\n\t$\n    } $tz -> x(stdName) x(stdSignum) x(stdHours) x(stdMinutes) x(stdSeconds) \\\n\t     x(dstName) x(dstSignum) x(dstHours) x(dstMinutes) x(dstSeconds) \\\n\t     x(startJ) x(startDayOfYear) \\\n\t     x(startMonth) x(startWeekOfMonth) x(startDayOfWeek) \\\n\t     x(startHours) x(startMinutes) x(startSeconds) \\\n\t     x(endJ) x(endDayOfYear) \\\n\t     x(endMonth) x(endWeekOfMonth) x(endDayOfWeek) \\\n\t     x(endHours) x(endMinutes) x(endSeconds)] } {\n\t# it's a good timezone\n\n\treturn [array get x]\n    }\n\n    return -code error\\\n\t-errorcode [list CLOCK badTimeZone $tz] \\\n\t\"unable to parse time zone specification \\\"$tz\\\"\"\n}\n\n#----------------------------------------------------------------------\n#\n# ProcessPosixTimeZone --\n#\n#\tHandle a Posix time zone after it's been broken out into fields.\n#\n# Parameters:\n#\tz - Dictionary returned from 'ParsePosixTimeZone'\n#\n# Results:\n#\tReturns time zone information for the 'TZData' array.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::ProcessPosixTimeZone { z } {\n    variable MINWIDE\n    variable TZData\n\n    # Determine the standard time zone name and seconds east of Greenwich\n\n    set stdName [dict get $z stdName]\n    if { [string index $stdName 0] eq {<} } {\n\tset stdName [string range $stdName 1 end-1]\n    }\n    if { [dict get $z stdSignum] eq {-} } {\n\tset stdSignum +1\n    } else {\n\tset stdSignum -1\n    }\n    set stdHours [lindex [::scan [dict get $z stdHours] %d] 0]\n    if { [dict get $z stdMinutes] ne {} } {\n\tset stdMinutes [lindex [::scan [dict get $z stdMinutes] %d] 0]\n    } else {\n\tset stdMinutes 0\n    }\n    if { [dict get $z stdSeconds] ne {} } {\n\tset stdSeconds [lindex [::scan [dict get $z stdSeconds] %d] 0]\n    } else {\n\tset stdSeconds 0\n    }\n    set stdOffset [expr {\n\t(($stdHours * 60 + $stdMinutes) * 60 + $stdSeconds) * $stdSignum\n    }]\n    set data [list [list $MINWIDE $stdOffset 0 $stdName]]\n\n    # If there's no daylight zone, we're done\n\n    set dstName [dict get $z dstName]\n    if { $dstName eq {} } {\n\treturn $data\n    }\n    if { [string index $dstName 0] eq {<} } {\n\tset dstName [string range $dstName 1 end-1]\n    }\n\n    # Determine the daylight name\n\n    if { [dict get $z dstSignum] eq {-} } {\n\tset dstSignum +1\n    } else {\n\tset dstSignum -1\n    }\n    if { [dict get $z dstHours] eq {} } {\n\tset dstOffset [expr { 3600 + $stdOffset }]\n    } else {\n\tset dstHours [lindex [::scan [dict get $z dstHours] %d] 0]\n\tif { [dict get $z dstMinutes] ne {} } {\n\t    set dstMinutes [lindex [::scan [dict get $z dstMinutes] %d] 0]\n\t} else {\n\t    set dstMinutes 0\n\t}\n\tif { [dict get $z dstSeconds] ne {} } {\n\t    set dstSeconds [lindex [::scan [dict get $z dstSeconds] %d] 0]\n\t} else {\n\t    set dstSeconds 0\n\t}\n\tset dstOffset [expr {\n\t    (($dstHours*60 + $dstMinutes) * 60 + $dstSeconds) * $dstSignum\n\t}]\n    }\n\n    # Fill in defaults for European or US DST rules\n    # US start time is the second Sunday in March\n    # EU start time is the last Sunday in March\n    # US end time is the first Sunday in November.\n    # EU end time is the last Sunday in October\n\n    if {\n\t[dict get $z startDayOfYear] eq {}\n\t&& [dict get $z startMonth] eq {}\n    } then {\n\tif {($stdSignum * $stdHours>=0) && ($stdSignum * $stdHours<=12)} {\n\t    # EU\n\t    dict set z startWeekOfMonth 5\n\t    if {$stdHours>2} {\n\t\tdict set z startHours 2\n\t    } else {\n\t\tdict set z startHours [expr {$stdHours+1}]\n\t    }\n\t} else {\n\t    # US\n\t    dict set z startWeekOfMonth 2\n\t    dict set z startHours 2\n\t}\n\tdict set z startMonth 3\n\tdict set z startDayOfWeek 0\n\tdict set z startMinutes 0\n\tdict set z startSeconds 0\n    }\n    if {\n\t[dict get $z endDayOfYear] eq {}\n\t&& [dict get $z endMonth] eq {}\n    } then {\n\tif {($stdSignum * $stdHours>=0) && ($stdSignum * $stdHours<=12)} {\n\t    # EU\n\t    dict set z endMonth 10\n\t    dict set z endWeekOfMonth 5\n\t    if {$stdHours>2} {\n\t\tdict set z endHours 3\n\t    } else {\n\t\tdict set z endHours [expr {$stdHours+2}]\n\t    }\n\t} else {\n\t    # US\n\t    dict set z endMonth 11\n\t    dict set z endWeekOfMonth 1\n\t    dict set z endHours 2\n\t}\n\tdict set z endDayOfWeek 0\n\tdict set z endMinutes 0\n\tdict set z endSeconds 0\n    }\n\n    # Put DST in effect in all years from 1916 to 2099.\n\n    for { set y 1916 } { $y < 2100 } { incr y } {\n\tset startTime [DeterminePosixDSTTime $z start $y]\n\tincr startTime [expr { - wide($stdOffset) }]\n\tset endTime [DeterminePosixDSTTime $z end $y]\n\tincr endTime [expr { - wide($dstOffset) }]\n\tif { $startTime < $endTime } {\n\t    lappend data \\\n\t\t[list $startTime $dstOffset 1 $dstName] \\\n\t\t[list $endTime $stdOffset 0 $stdName]\n\t} else {\n\t    lappend data \\\n\t\t[list $endTime $stdOffset 0 $stdName] \\\n\t\t[list $startTime $dstOffset 1 $dstName]\n\t}\n    }\n\n    return $data\n}\n\n#----------------------------------------------------------------------\n#\n# DeterminePosixDSTTime --\n#\n#\tDetermines the time that Daylight Saving Time starts or ends from a\n#\tPosix time zone specification.\n#\n# Parameters:\n#\tz - Time zone data returned from ParsePosixTimeZone.\n#\t    Missing fields are expected to be filled in with\n#\t    default values.\n#\tbound - The word 'start' or 'end'\n#\ty - The year for which the transition time is to be determined.\n#\n# Results:\n#\tReturns the transition time as a count of seconds from the epoch.  The\n#\ttime is relative to the wall clock, not UTC.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::DeterminePosixDSTTime { z bound y } {\n\n    variable FEB_28\n\n    # Determine the start or end day of DST\n\n    set date [dict create era CE year $y]\n    set doy [dict get $z ${bound}DayOfYear]\n    if { $doy ne {} } {\n\n\t# Time was specified as a day of the year\n\n\tif { [dict get $z ${bound}J] ne {}\n\t     && [IsGregorianLeapYear $y]\n\t     && ( $doy > $FEB_28 ) } {\n\t    incr doy\n\t}\n\tdict set date dayOfYear $doy\n\tset date [GetJulianDayFromEraYearDay $date[set date {}] 2361222]\n    } else {\n\t# Time was specified as a day of the week within a month\n\n\tdict set date month [dict get $z ${bound}Month]\n\tdict set date dayOfWeek [dict get $z ${bound}DayOfWeek]\n\tset dowim [dict get $z ${bound}WeekOfMonth]\n\tif { $dowim >= 5 } {\n\t    set dowim -1\n\t}\n\tdict set date dayOfWeekInMonth $dowim\n\tset date [GetJulianDayFromEraYearMonthWeekDay $date[set date {}] 2361222]\n\n    }\n\n    set jd [dict get $date julianDay]\n    set seconds [expr {\n\twide($jd) * wide(86400) - wide(210866803200)\n    }]\n\n    set h [dict get $z ${bound}Hours]\n    if { $h eq {} } {\n\tset h 2\n    } else {\n\tset h [lindex [::scan $h %d] 0]\n    }\n    set m [dict get $z ${bound}Minutes]\n    if { $m eq {} } {\n\tset m 0\n    } else {\n\tset m [lindex [::scan $m %d] 0]\n    }\n    set s [dict get $z ${bound}Seconds]\n    if { $s eq {} } {\n\tset s 0\n    } else {\n\tset s [lindex [::scan $s %d] 0]\n    }\n    set tod [expr { ( $h * 60 + $m ) * 60 + $s }]\n    return [expr { $seconds + $tod }]\n}\n\n#----------------------------------------------------------------------\n#\n# GetLocaleEra --\n#\n#\tGiven local time expressed in seconds from the Posix epoch,\n#\tdetermine localized era and year within the era.\n#\n# Parameters:\n#\tdate - Dictionary that must contain the keys, 'localSeconds',\n#\t       whose value is expressed as the appropriate local time;\n#\t       and 'year', whose value is the Gregorian year.\n#\tetable - Value of the LOCALE_ERAS key in the message catalogue\n#\t         for the target locale.\n#\n# Results:\n#\tReturns the dictionary, augmented with the keys, 'localeEra' and\n#\t'localeYear'.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::GetLocaleEra { date etable } {\n    set index [BSearch $etable [dict get $date localSeconds]]\n    if { $index < 0} {\n\tdict set date localeEra \\\n\t    [::format %02d [expr { [dict get $date year] / 100 }]]\n\tdict set date localeYear [expr {\n\t    [dict get $date year] % 100\n\t}]\n    } else {\n\tdict set date localeEra [lindex $etable $index 1]\n\tdict set date localeYear [expr {\n\t    [dict get $date year] - [lindex $etable $index 2]\n\t}]\n    }\n    return $date\n}\n\n#----------------------------------------------------------------------\n#\n# GetJulianDayFromEraYearDay --\n#\n#\tGiven a year, month and day on the Gregorian calendar, determines\n#\tthe Julian Day Number beginning at noon on that date.\n#\n# Parameters:\n#\tdate -- A dictionary in which the 'era', 'year', and\n#\t\t'dayOfYear' slots are populated. The calendar in use\n#\t\tis determined by the date itself relative to:\n#       changeover -- Julian day on which the Gregorian calendar was\n#\t\tadopted in the current locale.\n#\n# Results:\n#\tReturns the given dictionary augmented with a 'julianDay' key whose\n#\tvalue is the desired Julian Day Number, and a 'gregorian' key that\n#\tspecifies whether the calendar is Gregorian (1) or Julian (0).\n#\n# Side effects:\n#\tNone.\n#\n# Bugs:\n#\tThis code needs to be moved to the C layer.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::GetJulianDayFromEraYearDay {date changeover} {\n    # Get absolute year number from the civil year\n\n    switch -exact -- [dict get $date era] {\n\tBCE {\n\t    set year [expr { 1 - [dict get $date year] }]\n\t}\n\tCE {\n\t    set year [dict get $date year]\n\t}\n    }\n    set ym1 [expr { $year - 1 }]\n\n    # Try the Gregorian calendar first.\n\n    dict set date gregorian 1\n    set jd [expr {\n\t1721425\n\t+ [dict get $date dayOfYear]\n\t+ ( 365 * $ym1 )\n\t+ ( $ym1 / 4 )\n\t- ( $ym1 / 100 )\n\t+ ( $ym1 / 400 )\n    }]\n\n    # If the date is before the Gregorian change, use the Julian calendar.\n\n    if { $jd < $changeover } {\n\tdict set date gregorian 0\n\tset jd [expr {\n\t    1721423\n\t    + [dict get $date dayOfYear]\n\t    + ( 365 * $ym1 )\n\t    + ( $ym1 / 4 )\n\t}]\n    }\n\n    dict set date julianDay $jd\n    return $date\n}\n\n#----------------------------------------------------------------------\n#\n# GetJulianDayFromEraYearMonthWeekDay --\n#\n#\tDetermines the Julian Day number corresponding to the nth given\n#\tday-of-the-week in a given month.\n#\n# Parameters:\n#\tdate - Dictionary containing the keys, 'era', 'year', 'month'\n#\t       'weekOfMonth', 'dayOfWeek', and 'dayOfWeekInMonth'.\n#\tchangeover - Julian Day of adoption of the Gregorian calendar\n#\n# Results:\n#\tReturns the given dictionary, augmented with a 'julianDay' key.\n#\n# Side effects:\n#\tNone.\n#\n# Bugs:\n#\tThis code needs to be moved to the C layer.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::GetJulianDayFromEraYearMonthWeekDay {date changeover} {\n    # Come up with a reference day; either the zeroeth day of the given month\n    # (dayOfWeekInMonth >= 0) or the seventh day of the following month\n    # (dayOfWeekInMonth < 0)\n\n    set date2 $date\n    set week [dict get $date dayOfWeekInMonth]\n    if { $week >= 0 } {\n\tdict set date2 dayOfMonth 0\n    } else {\n\tdict incr date2 month\n\tdict set date2 dayOfMonth 7\n    }\n    set date2 [GetJulianDayFromEraYearMonthDay $date2[set date2 {}] \\\n\t\t   $changeover]\n    set wd0 [WeekdayOnOrBefore [dict get $date dayOfWeek] \\\n\t\t [dict get $date2 julianDay]]\n    dict set date julianDay [expr { $wd0 + 7 * $week }]\n    return $date\n}\n\n#----------------------------------------------------------------------\n#\n# IsGregorianLeapYear --\n#\n#\tDetermines whether a given date represents a leap year in the\n#\tGregorian calendar.\n#\n# Parameters:\n#\tdate -- The date to test.  The fields, 'era', 'year' and 'gregorian'\n#\t        must be set.\n#\n# Results:\n#\tReturns 1 if the year is a leap year, 0 otherwise.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::IsGregorianLeapYear { date } {\n    switch -exact -- [dict get $date era] {\n\tBCE {\n\t    set year [expr { 1 - [dict get $date year]}]\n\t}\n\tCE {\n\t    set year [dict get $date year]\n\t}\n    }\n    if { $year % 4 != 0 } {\n\treturn 0\n    } elseif { ![dict get $date gregorian] } {\n\treturn 1\n    } elseif { $year % 400 == 0 } {\n\treturn 1\n    } elseif { $year % 100 == 0 } {\n\treturn 0\n    } else {\n\treturn 1\n    }\n}\n\n#----------------------------------------------------------------------\n#\n# WeekdayOnOrBefore --\n#\n#\tDetermine the nearest day of week (given by the 'weekday' parameter,\n#\tSunday==0) on or before a given Julian Day.\n#\n# Parameters:\n#\tweekday -- Day of the week\n#\tj -- Julian Day number\n#\n# Results:\n#\tReturns the Julian Day Number of the desired date.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::WeekdayOnOrBefore { weekday j } {\n    set k [expr { ( $weekday + 6 )  % 7 }]\n    return [expr { $j - ( $j - $k ) % 7 }]\n}\n\n#----------------------------------------------------------------------\n#\n# BSearch --\n#\n#\tService procedure that does binary search in several places inside the\n#\t'clock' command.\n#\n# Parameters:\n#\tlist - List of lists, sorted in ascending order by the\n#\t       first elements\n#\tkey - Value to search for\n#\n# Results:\n#\tReturns the index of the greatest element in $list that is less than\n#\tor equal to $key.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::BSearch { list key } {\n    if {[llength $list] == 0} {\n\treturn -1\n    }\n    if { $key < [lindex $list 0 0] } {\n\treturn -1\n    }\n\n    set l 0\n    set u [expr { [llength $list] - 1 }]\n\n    while { $l < $u } {\n\t# At this point, we know that\n\t#   $k >= [lindex $list $l 0]\n\t#   Either $u == [llength $list] or else $k < [lindex $list $u+1 0]\n\t# We find the midpoint of the interval {l,u} rounded UP, compare\n\t# against it, and set l or u to maintain the invariant.  Note that the\n\t# interval shrinks at each step, guaranteeing convergence.\n\n\tset m [expr { ( $l + $u + 1 ) / 2 }]\n\tif { $key >= [lindex $list $m 0] } {\n\t    set l $m\n\t} else {\n\t    set u [expr { $m - 1 }]\n\t}\n    }\n\n    return $l\n}\n\n#----------------------------------------------------------------------\n#\n# clock add --\n#\n#\tAdds an offset to a given time.\n#\n# Syntax:\n#\tclock add clockval ?count unit?... ?-option value?\n#\n# Parameters:\n#\tclockval -- Starting time value\n#\tcount -- Amount of a unit of time to add\n#\tunit -- Unit of time to add, must be one of:\n#\t\t\tyears year months month weeks week\n#\t\t\tdays day hours hour minutes minute\n#\t\t\tseconds second\n#\n# Options:\n#\t-gmt BOOLEAN\n#\t\t(Deprecated) Flag synonymous with '-timezone :GMT'\n#\t-timezone ZONE\n#\t\tName of the time zone in which calculations are to be done.\n#\t-locale NAME\n#\t\tName of the locale in which calculations are to be done.\n#\t\tUsed to determine the Gregorian change date.\n#\n# Results:\n#\tReturns the given time adjusted by the given offset(s) in\n#\torder.\n#\n# Notes:\n#\tIt is possible that adding a number of months or years will adjust the\n#\tday of the month as well.  For instance, the time at one month after\n#\t31 January is either 28 or 29 February, because February has fewer\n#\tthan 31 days.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::add { clockval args } {\n    if { [llength $args] % 2 != 0 } {\n\tset cmdName \"clock add\"\n\treturn -code error \\\n\t    -errorcode [list CLOCK wrongNumArgs] \\\n\t    \"wrong \\# args: should be\\\n             \\\"$cmdName clockval ?number units?...\\\n             ?-gmt boolean? ?-locale LOCALE? ?-timezone ZONE?\\\"\"\n    }\n    if { [catch { expr {wide($clockval)} } result] } {\n\treturn -code error $result\n    }\n\n    set offsets {}\n    set gmt 0\n    set locale c\n    set timezone [GetSystemTimeZone]\n\n    foreach { a b } $args {\n\tif { [string is integer -strict $a] } {\n\t    lappend offsets $a $b\n\t} else {\n\t    switch -exact -- $a {\n\t\t-g - -gm - -gmt {\n\t\t    set gmt $b\n\t\t}\n\t\t-l - -lo - -loc - -loca - -local - -locale {\n\t\t    set locale [string tolower $b]\n\t\t}\n\t\t-t - -ti - -tim - -time - -timez - -timezo - -timezon -\n\t\t-timezone {\n\t\t    set timezone $b\n\t\t}\n\t\tdefault {\n\t\t    throw [list CLOCK badOption $a] \\\n\t\t\t\"bad option \\\"$a\\\",\\\n                         must be -gmt, -locale or -timezone\"\n\t\t}\n\t    }\n\t}\n    }\n\n    # Check options for validity\n\n    if { [info exists saw(-gmt)] && [info exists saw(-timezone)] } {\n\treturn -code error \\\n\t    -errorcode [list CLOCK gmtWithTimezone] \\\n\t    \"cannot use -gmt and -timezone in same call\"\n    }\n    if { [catch { expr { wide($clockval) } } result] } {\n\treturn -code error \"expected integer but got \\\"$clockval\\\"\"\n    }\n    if { ![string is boolean -strict $gmt] } {\n\treturn -code error \"expected boolean value but got \\\"$gmt\\\"\"\n    } elseif { $gmt } {\n\tset timezone :GMT\n    }\n\n    EnterLocale $locale\n\n    set changeover [mc GREGORIAN_CHANGE_DATE]\n\n    if {[catch {SetupTimeZone $timezone} retval opts]} {\n\tdict unset opts -errorinfo\n\treturn -options $opts $retval\n    }\n\n    try {\n\tforeach { quantity unit } $offsets {\n\t    switch -exact -- $unit {\n\t\tyears - year {\n\t\t    set clockval [AddMonths [expr { 12 * $quantity }] \\\n\t\t\t    $clockval $timezone $changeover]\n\t\t}\n\t\tmonths - month {\n\t\t    set clockval [AddMonths $quantity $clockval $timezone \\\n\t\t\t    $changeover]\n\t\t}\n\n\t\tweeks - week {\n\t\t    set clockval [AddDays [expr { 7 * $quantity }] \\\n\t\t\t    $clockval $timezone $changeover]\n\t\t}\n\t\tdays - day {\n\t\t    set clockval [AddDays $quantity $clockval $timezone \\\n\t\t\t    $changeover]\n\t\t}\n\n\t\thours - hour {\n\t\t    set clockval [expr { 3600 * $quantity + $clockval }]\n\t\t}\n\t\tminutes - minute {\n\t\t    set clockval [expr { 60 * $quantity + $clockval }]\n\t\t}\n\t\tseconds - second {\n\t\t    set clockval [expr { $quantity + $clockval }]\n\t\t}\n\n\t\tdefault {\n\t\t    throw [list CLOCK badUnit $unit] \\\n\t\t\t\"unknown unit \\\"$unit\\\", must be \\\n                        years, months, weeks, days, hours, minutes or seconds\"\n\t\t}\n\t    }\n\t}\n\treturn $clockval\n    } trap CLOCK {result opts} {\n\t# Conceal the innards of [clock] when it's an expected error\n\tdict unset opts -errorinfo\n\treturn -options $opts $result\n    }\n}\n\n#----------------------------------------------------------------------\n#\n# AddMonths --\n#\n#\tAdd a given number of months to a given clock value in a given\n#\ttime zone.\n#\n# Parameters:\n#\tmonths - Number of months to add (may be negative)\n#\tclockval - Seconds since the epoch before the operation\n#\ttimezone - Time zone in which the operation is to be performed\n#\n# Results:\n#\tReturns the new clock value as a number of seconds since\n#\tthe epoch.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::AddMonths { months clockval timezone changeover } {\n    variable DaysInRomanMonthInCommonYear\n    variable DaysInRomanMonthInLeapYear\n    variable TZData\n\n    # Convert the time to year, month, day, and fraction of day.\n\n    set date [GetDateFields $clockval $TZData($timezone) $changeover]\n    dict set date secondOfDay [expr {\n\t[dict get $date localSeconds] % 86400\n    }]\n    dict set date tzName $timezone\n\n    # Add the requisite number of months\n\n    set m [dict get $date month]\n    incr m $months\n    incr m -1\n    set delta [expr { $m / 12 }]\n    set mm [expr { $m % 12 }]\n    dict set date month [expr { $mm + 1 }]\n    dict incr date year $delta\n\n    # If the date doesn't exist in the current month, repair it\n\n    if { [IsGregorianLeapYear $date] } {\n\tset hath [lindex $DaysInRomanMonthInLeapYear $mm]\n    } else {\n\tset hath [lindex $DaysInRomanMonthInCommonYear $mm]\n    }\n    if { [dict get $date dayOfMonth] > $hath } {\n\tdict set date dayOfMonth $hath\n    }\n\n    # Reconvert to a number of seconds\n\n    set date [GetJulianDayFromEraYearMonthDay \\\n\t\t  $date[set date {}]\\\n\t\t  $changeover]\n    dict set date localSeconds [expr {\n\t-210866803200\n\t+ ( 86400 * wide([dict get $date julianDay]) )\n\t+ [dict get $date secondOfDay]\n    }]\n    set date [ConvertLocalToUTC $date[set date {}] $TZData($timezone) \\\n\t\t $changeover]\n\n    return [dict get $date seconds]\n\n}\n\n#----------------------------------------------------------------------\n#\n# AddDays --\n#\n#\tAdd a given number of days to a given clock value in a given time\n#\tzone.\n#\n# Parameters:\n#\tdays - Number of days to add (may be negative)\n#\tclockval - Seconds since the epoch before the operation\n#\ttimezone - Time zone in which the operation is to be performed\n#\tchangeover - Julian Day on which the Gregorian calendar was adopted\n#\t\t     in the target locale.\n#\n# Results:\n#\tReturns the new clock value as a number of seconds since the epoch.\n#\n# Side effects:\n#\tNone.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::AddDays { days clockval timezone changeover } {\n    variable TZData\n\n    # Convert the time to Julian Day\n\n    set date [GetDateFields $clockval $TZData($timezone) $changeover]\n    dict set date secondOfDay [expr {\n\t[dict get $date localSeconds] % 86400\n    }]\n    dict set date tzName $timezone\n\n    # Add the requisite number of days\n\n    dict incr date julianDay $days\n\n    # Reconvert to a number of seconds\n\n    dict set date localSeconds [expr {\n\t-210866803200\n\t+ ( 86400 * wide([dict get $date julianDay]) )\n\t+ [dict get $date secondOfDay]\n    }]\n    set date [ConvertLocalToUTC $date[set date {}] $TZData($timezone) \\\n\t\t  $changeover]\n\n    return [dict get $date seconds]\n\n}\n\n#----------------------------------------------------------------------\n#\n# ChangeCurrentLocale --\n#\n#        The global locale was changed within msgcat.\n#        Clears the buffered parse functions of the current locale.\n#\n# Parameters:\n#        loclist (ignored)\n#\n# Results:\n#        None.\n#\n# Side effects:\n#        Buffered parse functions are cleared.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::ChangeCurrentLocale {args} {\n    variable FormatProc\n    variable LocaleNumeralCache\n    variable CachedSystemTimeZone\n    variable TimeZoneBad\n\n    foreach p [info procs [namespace current]::scanproc'*'current] {\n        rename $p {}\n    }\n    foreach p [info procs [namespace current]::formatproc'*'current] {\n        rename $p {}\n    }\n\n    catch {array unset FormatProc *'current}\n    set LocaleNumeralCache {}\n}\n\n#----------------------------------------------------------------------\n#\n# ClearCaches --\n#\n#\tClears all caches to reclaim the memory used in [clock]\n#\n# Parameters:\n#\tNone.\n#\n# Results:\n#\tNone.\n#\n# Side effects:\n#\tCaches are cleared.\n#\n#----------------------------------------------------------------------\n\nproc ::tcl::clock::ClearCaches {} {\n    variable FormatProc\n    variable LocaleNumeralCache\n    variable CachedSystemTimeZone\n    variable TimeZoneBad\n\n    foreach p [info procs [namespace current]::scanproc'*] {\n\trename $p {}\n    }\n    foreach p [info procs [namespace current]::formatproc'*] {\n\trename $p {}\n    }\n\n    catch {unset FormatProc}\n    set LocaleNumeralCache {}\n    catch {unset CachedSystemTimeZone}\n    set TimeZoneBad {}\n    InitTZData\n}\n",
		"/dde/":                                    "",
		"/dde/pkgIndex.tcl":                        "if {[info sharedlibextension] != \".dll\"} return\nif {[package vsatisfies [package provide Tcl] 9.0-]} {\n    package ifneeded dde 1.4.4 \\\n\t    [list load [file join $dir tcl9dde14.dll] Dde]\n} elseif {![package vsatisfies [package provide Tcl] 8.7]\n\t&& [::tcl::pkgconfig get debug]} {\n    package ifneeded dde 1.4.4 \\\n\t    [list load [file join $dir tcldde14g.dll] Dde]\n} else {\n    package ifneeded dde 1.4.4 \\\n\t    [list load [file join $dir tcldde14.dll] Dde]\n}\n",
		"/encoding/":                               "",
		"/encoding/ascii.enc":                      "# Encoding file: ascii, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n",
		"/encoding/big5.enc":                       "# Encoding file: big5, multi-byte\nM\n003F 0 89\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n0080008100820083008400850086008700880089008A008B008C008D008E008F\n0090009100920093009400950096009700980099009A009B009C009D009E009F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n3000FF0C30013002FF0E2022FF1BFF1AFF1FFF01FE3020262025FE50FF64FE52\n00B7FE54FE55FE56FE57FF5C2013FE312014FE33FFFDFE34FE4FFF08FF09FE35\nFE36FF5BFF5DFE37FE3830143015FE39FE3A30103011FE3BFE3C300A300BFE3D\nFE3E30083009FE3FFE40300C300DFE41FE42300E300FFE43FE44FE59FE5A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000FE5BFE5CFE5DFE5E20182019201C201D301D301E20352032FF03FF06FF0A\n203B00A7300325CB25CF25B325B225CE2606260525C725C625A125A025BD25BC\n32A32105203EFFFDFF3FFFFDFE49FE4AFE4DFE4EFE4BFE4CFE5FFE60FE61FF0B\nFF0D00D700F700B1221AFF1CFF1EFF1D226622672260221E22522261FE62FE63\nFE64FE65FE66223C2229222A22A52220221F22BF33D233D1222B222E22352234\n26402642264126092191219321902192219621972199219822252223FFFD0000\nA2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFFFDFF0FFF3CFF0400A5301200A200A3FF05FF2021032109FE69FE6AFE6B33D5\n339C339D339E33CE33A1338E338F33C400B05159515B515E515D5161516355E7\n74E97CCE25812582258325842585258625872588258F258E258D258C258B258A\n2589253C2534252C2524251C2594250025022595250C251025142518256D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000256E2570256F2550255E256A256125E225E325E525E4257125722573FF10\nFF11FF12FF13FF14FF15FF16FF17FF18FF192160216121622163216421652166\n216721682169302130223023302430253026302730283029FFFD5344FFFDFF21\nFF22FF23FF24FF25FF26FF27FF28FF29FF2AFF2BFF2CFF2DFF2EFF2FFF30FF31\nFF32FF33FF34FF35FF36FF37FF38FF39FF3AFF41FF42FF43FF44FF45FF46FF47\nFF48FF49FF4AFF4BFF4CFF4DFF4EFF4FFF50FF51FF52FF53FF54FF55FF560000\nA3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFF57FF58FF59FF5A039103920393039403950396039703980399039A039B039C\n039D039E039F03A003A103A303A403A503A603A703A803A903B103B203B303B4\n03B503B603B703B803B903BA03BB03BC03BD03BE03BF03C003C103C303C403C5\n03C603C703C803C931053106310731083109310A310B310C310D310E310F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00003110311131123113311431153116311731183119311A311B311C311D311E\n311F312031213122312331243125312631273128312902D902C902CA02C702CB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4E004E594E014E034E434E5D4E864E8C4EBA513F5165516B51E052005201529B\n53155341535C53C84E094E0B4E084E0A4E2B4E3851E14E454E484E5F4E5E4E8E\n4EA15140520352FA534353C953E3571F58EB5915592759735B505B515B535BF8\n5C0F5C225C385C715DDD5DE55DF15DF25DF35DFE5E725EFE5F0B5F13624D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004E114E104E0D4E2D4E304E394E4B5C394E884E914E954E924E944EA24EC1\n4EC04EC34EC64EC74ECD4ECA4ECB4EC4514351415167516D516E516C519751F6\n52065207520852FB52FE52FF53165339534853475345535E538453CB53CA53CD\n58EC5929592B592A592D5B545C115C245C3A5C6F5DF45E7B5EFF5F145F155FC3\n62086236624B624E652F6587659765A465B965E566F0670867286B206B626B79\n6BCB6BD46BDB6C0F6C34706B722A7236723B72477259725B72AC738B4E190000\nA5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4E164E154E144E184E3B4E4D4E4F4E4E4EE54ED84ED44ED54ED64ED74EE34EE4\n4ED94EDE514551445189518A51AC51F951FA51F8520A52A0529F530553065317\n531D4EDF534A534953615360536F536E53BB53EF53E453F353EC53EE53E953E8\n53FC53F853F553EB53E653EA53F253F153F053E553ED53FB56DB56DA59160000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000592E5931597459765B555B835C3C5DE85DE75DE65E025E035E735E7C5F01\n5F185F175FC5620A625362546252625165A565E6672E672C672A672B672D6B63\n6BCD6C116C106C386C416C406C3E72AF7384738974DC74E67518751F75287529\n7530753175327533758B767D76AE76BF76EE77DB77E277F3793A79BE7A747ACB\n4E1E4E1F4E524E534E694E994EA44EA64EA54EFF4F094F194F0A4F154F0D4F10\n4F114F0F4EF24EF64EFB4EF04EF34EFD4F014F0B514951475146514851680000\nA6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5171518D51B0521752115212520E521652A3530853215320537053715409540F\n540C540A54105401540B54045411540D54085403540E5406541256E056DE56DD\n573357305728572D572C572F57295919591A59375938598459785983597D5979\n598259815B575B585B875B885B855B895BFA5C165C795DDE5E065E765E740000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005F0F5F1B5FD95FD6620E620C620D62106263625B6258653665E965E865EC\n65ED66F266F36709673D6734673167356B216B646B7B6C166C5D6C576C596C5F\n6C606C506C556C616C5B6C4D6C4E7070725F725D767E7AF97C737CF87F367F8A\n7FBD80018003800C80128033807F8089808B808C81E381EA81F381FC820C821B\n821F826E8272827E866B8840884C8863897F96214E324EA84F4D4F4F4F474F57\n4F5E4F344F5B4F554F304F504F514F3D4F3A4F384F434F544F3C4F464F630000\nA7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4F5C4F604F2F4F4E4F364F594F5D4F484F5A514C514B514D517551B651B75225\n52245229522A522852AB52A952AA52AC532353735375541D542D541E543E5426\n544E542754465443543354485442541B5429544A5439543B5438542E54355436\n5420543C54405431542B541F542C56EA56F056E456EB574A57515740574D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005747574E573E5750574F573B58EF593E599D599259A8599E59A359995996\n598D59A45993598A59A55B5D5B5C5B5A5B5B5B8C5B8B5B8F5C2C5C405C415C3F\n5C3E5C905C915C945C8C5DEB5E0C5E8F5E875E8A5EF75F045F1F5F645F625F77\n5F795FD85FCC5FD75FCD5FF15FEB5FF85FEA6212621162846297629662806276\n6289626D628A627C627E627962736292626F6298626E62956293629162866539\n653B653865F166F4675F674E674F67506751675C6756675E6749674667600000\nA8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n675367576B656BCF6C426C5E6C996C816C886C896C856C9B6C6A6C7A6C906C70\n6C8C6C686C966C926C7D6C836C726C7E6C746C866C766C8D6C946C986C827076\n707C707D707872627261726072C472C27396752C752B75377538768276EF77E3\n79C179C079BF7A767CFB7F5580968093809D8098809B809A80B2826F82920000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000828B828D898B89D28A008C378C468C558C9D8D648D708DB38EAB8ECA8F9B\n8FB08FC28FC68FC58FC45DE1909190A290AA90A690A3914991C691CC9632962E\n9631962A962C4E264E564E734E8B4E9B4E9E4EAB4EAC4F6F4F9D4F8D4F734F7F\n4F6C4F9B4F8B4F864F834F704F754F884F694F7B4F964F7E4F8F4F914F7A5154\n51525155516951775176517851BD51FD523B52385237523A5230522E52365241\n52BE52BB5352535453535351536653775378537953D653D453D7547354750000\nA9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5496547854955480547B5477548454925486547C549054715476548C549A5462\n5468548B547D548E56FA57835777576A5769576157665764577C591C59495947\n59485944595459BE59BB59D459B959AE59D159C659D059CD59CB59D359CA59AF\n59B359D259C55B5F5B645B635B975B9A5B985B9C5B995B9B5C1A5C485C450000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005C465CB75CA15CB85CA95CAB5CB15CB35E185E1A5E165E155E1B5E115E78\n5E9A5E975E9C5E955E965EF65F265F275F295F805F815F7F5F7C5FDD5FE05FFD\n5FF55FFF600F6014602F60356016602A6015602160276029602B601B62166215\n623F623E6240627F62C962CC62C462BF62C262B962D262DB62AB62D362D462CB\n62C862A862BD62BC62D062D962C762CD62B562DA62B162D862D662D762C662AC\n62CE653E65A765BC65FA66146613660C66066602660E6600660F6615660A0000\nAA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6607670D670B676D678B67956771679C677367776787679D6797676F6770677F\n6789677E67906775679A6793677C676A67726B236B666B676B7F6C136C1B6CE3\n6CE86CF36CB16CCC6CE56CB36CBD6CBE6CBC6CE26CAB6CD56CD36CB86CC46CB9\n6CC16CAE6CD76CC56CF16CBF6CBB6CE16CDB6CCA6CAC6CEF6CDC6CD66CE00000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007095708E7092708A7099722C722D723872487267726972C072CE72D972D7\n72D073A973A8739F73AB73A5753D759D7599759A768476C276F276F477E577FD\n793E7940794179C979C87A7A7A797AFA7CFE7F547F8C7F8B800580BA80A580A2\n80B180A180AB80A980B480AA80AF81E581FE820D82B3829D829982AD82BD829F\n82B982B182AC82A582AF82B882A382B082BE82B7864E8671521D88688ECB8FCE\n8FD48FD190B590B890B190B691C791D195779580961C9640963F963B96440000\nAB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n964296B996E89752975E4E9F4EAD4EAE4FE14FB54FAF4FBF4FE04FD14FCF4FDD\n4FC34FB64FD84FDF4FCA4FD74FAE4FD04FC44FC24FDA4FCE4FDE4FB751575192\n519151A0524E5243524A524D524C524B524752C752C952C352C1530D5357537B\n539A53DB54AC54C054A854CE54C954B854A654B354C754C254BD54AA54C10000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000054C454C854AF54AB54B154BB54A954A754BF56FF5782578B57A057A357A2\n57CE57AE579359555951594F594E595059DC59D859FF59E359E85A0359E559EA\n59DA59E65A0159FB5B695BA35BA65BA45BA25BA55C015C4E5C4F5C4D5C4B5CD9\n5CD25DF75E1D5E255E1F5E7D5EA05EA65EFA5F085F2D5F655F885F855F8A5F8B\n5F875F8C5F896012601D60206025600E6028604D60706068606260466043606C\n606B606A6064624162DC6316630962FC62ED630162EE62FD630762F162F70000\nAC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n62EF62EC62FE62F463116302653F654565AB65BD65E26625662D66206627662F\n661F66286631662466F767FF67D367F167D467D067EC67B667AF67F567E967EF\n67C467D167B467DA67E567B867CF67DE67F367B067D967E267DD67D26B6A6B83\n6B866BB56BD26BD76C1F6CC96D0B6D326D2A6D416D256D0C6D316D1E6D170000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006D3B6D3D6D3E6D366D1B6CF56D396D276D386D296D2E6D356D0E6D2B70AB\n70BA70B370AC70AF70AD70B870AE70A472307272726F727472E972E072E173B7\n73CA73BB73B273CD73C073B3751A752D754F754C754E754B75AB75A475A575A2\n75A3767876867687768876C876C676C376C5770176F976F87709770B76FE76FC\n770777DC78027814780C780D794679497948794779B979BA79D179D279CB7A7F\n7A817AFF7AFD7C7D7D027D057D007D097D077D047D067F387F8E7FBF80040000\nAD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8010800D8011803680D680E580DA80C380C480CC80E180DB80CE80DE80E480DD\n81F4822282E78303830582E382DB82E6830482E58302830982D282D782F18301\n82DC82D482D182DE82D382DF82EF830686508679867B867A884D886B898189D4\n8A088A028A038C9E8CA08D748D738DB48ECD8ECC8FF08FE68FE28FEA8FE50000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008FED8FEB8FE48FE890CA90CE90C190C3914B914A91CD95829650964B964C\n964D9762976997CB97ED97F3980198A898DB98DF999699994E584EB3500C500D\n50234FEF502650254FF8502950165006503C501F501A501250114FFA50005014\n50284FF15021500B501950184FF34FEE502D502A4FFE502B5009517C51A451A5\n51A251CD51CC51C651CB5256525C5254525B525D532A537F539F539D53DF54E8\n55105501553754FC54E554F2550654FA551454E954ED54E1550954EE54EA0000\nAE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n54E65527550754FD550F5703570457C257D457CB57C35809590F59575958595A\n5A115A185A1C5A1F5A1B5A1359EC5A205A235A295A255A0C5A095B6B5C585BB0\n5BB35BB65BB45BAE5BB55BB95BB85C045C515C555C505CED5CFD5CFB5CEA5CE8\n5CF05CF65D015CF45DEE5E2D5E2B5EAB5EAD5EA75F315F925F915F9060590000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006063606560506055606D6069606F6084609F609A608D6094608C60856096\n624762F3630862FF634E633E632F635563426346634F6349633A6350633D632A\n632B6328634D634C65486549659965C165C566426649664F66436652664C6645\n664166F867146715671768216838684868466853683968426854682968B36817\n684C6851683D67F468506840683C6843682A68456813681868416B8A6B896BB7\n6C236C276C286C266C246CF06D6A6D956D886D876D666D786D776D596D930000\nAF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6D6C6D896D6E6D5A6D746D696D8C6D8A6D796D856D656D9470CA70D870E470D9\n70C870CF7239727972FC72F972FD72F872F7738673ED740973EE73E073EA73DE\n7554755D755C755A755975BE75C575C775B275B375BD75BC75B975C275B8768B\n76B076CA76CD76CE7729771F7720772877E9783078277838781D783478370000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007825782D7820781F7832795579507960795F7956795E795D7957795A79E4\n79E379E779DF79E679E979D87A847A887AD97B067B117C897D217D177D0B7D0A\n7D207D227D147D107D157D1A7D1C7D0D7D197D1B7F3A7F5F7F947FC57FC18006\n8018801580198017803D803F80F1810280F0810580ED80F4810680F880F38108\n80FD810A80FC80EF81ED81EC82008210822A822B8228822C82BB832B83528354\n834A83388350834983358334834F833283398336831783408331832883430000\nB0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8654868A86AA869386A486A9868C86A3869C8870887788818882887D88798A18\n8A108A0E8A0C8A158A0A8A178A138A168A0F8A118C488C7A8C798CA18CA28D77\n8EAC8ED28ED48ECF8FB1900190068FF790008FFA8FF490038FFD90058FF89095\n90E190DD90E29152914D914C91D891DD91D791DC91D995839662966396610000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000965B965D96649658965E96BB98E299AC9AA89AD89B259B329B3C4E7E507A\n507D505C50475043504C505A504950655076504E5055507550745077504F500F\n506F506D515C519551F0526A526F52D252D952D852D55310530F5319533F5340\n533E53C366FC5546556A55665544555E55615543554A55315556554F5555552F\n55645538552E555C552C55635533554155575708570B570957DF5805580A5806\n57E057E457FA5802583557F757F9592059625A365A415A495A665A6A5A400000\nB1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5A3C5A625A5A5A465A4A5B705BC75BC55BC45BC25BBF5BC65C095C085C075C60\n5C5C5C5D5D075D065D0E5D1B5D165D225D115D295D145D195D245D275D175DE2\n5E385E365E335E375EB75EB85EB65EB55EBE5F355F375F575F6C5F695F6B5F97\n5F995F9E5F985FA15FA05F9C607F60A3608960A060A860CB60B460E660BD0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000060C560BB60B560DC60BC60D860D560C660DF60B860DA60C7621A621B6248\n63A063A76372639663A263A563776367639863AA637163A963896383639B636B\n63A863846388639963A163AC6392638F6380637B63696368637A655D65566551\n65596557555F654F655865556554659C659B65AC65CF65CB65CC65CE665D665A\n666466686666665E66F952D7671B688168AF68A2689368B5687F687668B168A7\n689768B0688368C468AD688668856894689D68A8689F68A168826B326BBA0000\nB2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6BEB6BEC6C2B6D8E6DBC6DF36DD96DB26DE16DCC6DE46DFB6DFA6E056DC76DCB\n6DAF6DD16DAE6DDE6DF96DB86DF76DF56DC56DD26E1A6DB56DDA6DEB6DD86DEA\n6DF16DEE6DE86DC66DC46DAA6DEC6DBF6DE670F97109710A70FD70EF723D727D\n7281731C731B73167313731973877405740A7403740673FE740D74E074F60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000074F7751C75227565756675627570758F75D475D575B575CA75CD768E76D4\n76D276DB7737773E773C77367738773A786B7843784E79657968796D79FB7A92\n7A957B207B287B1B7B2C7B267B197B1E7B2E7C927C977C957D467D437D717D2E\n7D397D3C7D407D307D337D447D2F7D427D327D317F3D7F9E7F9A7FCC7FCE7FD2\n801C804A8046812F81168123812B81298130812482028235823782368239838E\n839E8398837883A2839683BD83AB8392838A8393838983A08377837B837C0000\nB3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n838683A786555F6A86C786C086B686C486B586C686CB86B186AF86C98853889E\n888888AB88928896888D888B8993898F8A2A8A1D8A238A258A318A2D8A1F8A1B\n8A228C498C5A8CA98CAC8CAB8CA88CAA8CA78D678D668DBE8DBA8EDB8EDF9019\n900D901A90179023901F901D90109015901E9020900F90229016901B90140000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000090E890ED90FD915791CE91F591E691E391E791ED91E99589966A96759673\n96789670967496769677966C96C096EA96E97AE07ADF980298039B5A9CE59E75\n9E7F9EA59EBB50A2508D508550995091508050965098509A670051F152725274\n5275526952DE52DD52DB535A53A5557B558055A7557C558A559D55985582559C\n55AA55945587558B558355B355AE559F553E55B2559A55BB55AC55B1557E5589\n55AB5599570D582F582A58345824583058315821581D582058F958FA59600000\nB4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5A775A9A5A7F5A925A9B5AA75B735B715BD25BCC5BD35BD05C0A5C0B5C315D4C\n5D505D345D475DFD5E455E3D5E405E435E7E5ECA5EC15EC25EC45F3C5F6D5FA9\n5FAA5FA860D160E160B260B660E0611C612360FA611560F060FB60F4616860F1\n610E60F6610961006112621F624963A3638C63CF63C063E963C963C663CD0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000063D263E363D063E163D663ED63EE637663F463EA63DB645263DA63F9655E\n6566656265636591659065AF666E667066746676666F6691667A667E667766FE\n66FF671F671D68FA68D568E068D868D7690568DF68F568EE68E768F968D268F2\n68E368CB68CD690D6912690E68C968DA696E68FB6B3E6B3A6B3D6B986B966BBC\n6BEF6C2E6C2F6C2C6E2F6E386E546E216E326E676E4A6E206E256E236E1B6E5B\n6E586E246E566E6E6E2D6E266E6F6E346E4D6E3A6E2C6E436E1D6E3E6ECB0000\nB5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6E896E196E4E6E636E446E726E696E5F7119711A7126713071217136716E711C\n724C728472807336732573347329743A742A743374227425743574367434742F\n741B7426742875257526756B756A75E275DB75E375D975D875DE75E0767B767C\n7696769376B476DC774F77ED785D786C786F7A0D7A087A0B7A057A007A980000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007A977A967AE57AE37B497B567B467B507B527B547B4D7B4B7B4F7B517C9F\n7CA57D5E7D507D687D557D2B7D6E7D727D617D667D627D707D7355847FD47FD5\n800B8052808581558154814B8151814E81398146813E814C815381748212821C\n83E9840383F8840D83E083C5840B83C183EF83F183F48457840A83F0840C83CC\n83FD83F283CA8438840E840483DC840783D483DF865B86DF86D986ED86D486DB\n86E486D086DE885788C188C288B1898389968A3B8A608A558A5E8A3C8A410000\nB6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8A548A5B8A508A468A348A3A8A368A568C618C828CAF8CBC8CB38CBD8CC18CBB\n8CC08CB48CB78CB68CBF8CB88D8A8D858D818DCE8DDD8DCB8DDA8DD18DCC8DDB\n8DC68EFB8EF88EFC8F9C902E90359031903890329036910290F5910990FE9163\n916591CF9214921592239209921E920D9210920792119594958F958B95910000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000095939592958E968A968E968B967D96859686968D9672968496C196C596C4\n96C696C796EF96F297CC98059806980898E798EA98EF98E998F298ED99AE99AD\n9EC39ECD9ED14E8250AD50B550B250B350C550BE50AC50B750BB50AF50C7527F\n5277527D52DF52E652E452E252E3532F55DF55E855D355E655CE55DC55C755D1\n55E355E455EF55DA55E155C555C655E555C957125713585E585158585857585A\n5854586B584C586D584A58625852584B59675AC15AC95ACC5ABE5ABD5ABC0000\nB7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5AB35AC25AB25D695D6F5E4C5E795EC95EC85F125F595FAC5FAE611A610F6148\n611F60F3611B60F961016108614E614C6144614D613E61346127610D61066137\n622162226413643E641E642A642D643D642C640F641C6414640D643664166417\n6406656C659F65B06697668966876688669666846698668D67036994696D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000695A697769606954697569306982694A6968696B695E695369796986695D\n6963695B6B476B726BC06BBF6BD36BFD6EA26EAF6ED36EB66EC26E906E9D6EC7\n6EC56EA56E986EBC6EBA6EAB6ED16E966E9C6EC46ED46EAA6EA76EB4714E7159\n7169716471497167715C716C7166714C7165715E714671687156723A72527337\n7345733F733E746F745A7455745F745E7441743F7459745B745C757675787600\n75F0760175F275F175FA75FF75F475F376DE76DF775B776B7766775E77630000\nB8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7779776A776C775C77657768776277EE788E78B078977898788C7889787C7891\n7893787F797A797F7981842C79BD7A1C7A1A7A207A147A1F7A1E7A9F7AA07B77\n7BC07B607B6E7B677CB17CB37CB57D937D797D917D817D8F7D5B7F6E7F697F6A\n7F727FA97FA87FA480568058808680848171817081788165816E8173816B0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008179817A81668205824784828477843D843184758466846B8449846C845B\n843C8435846184638469846D8446865E865C865F86F9871387088707870086FE\n86FB870287038706870A885988DF88D488D988DC88D888DD88E188CA88D588D2\n899C89E38A6B8A728A738A668A698A708A878A7C8A638AA08A718A858A6D8A62\n8A6E8A6C8A798A7B8A3E8A688C628C8A8C898CCA8CC78CC88CC48CB28CC38CC2\n8CC58DE18DDF8DE88DEF8DF38DFA8DEA8DE48DE68EB28F038F098EFE8F0A0000\nB9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8F9F8FB2904B904A905390429054903C905590509047904F904E904D9051903E\n904191129117916C916A916991C9923792579238923D9240923E925B924B9264\n925192349249924D92459239923F925A959896989694969596CD96CB96C996CA\n96F796FB96F996F6975697749776981098119813980A9812980C98FC98F40000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000098FD98FE99B399B199B49AE19CE99E829F0E9F139F2050E750EE50E550D6\n50ED50DA50D550CF50D150F150CE50E9516251F352835282533153AD55FE5600\n561B561755FD561456065609560D560E55F75616561F5608561055F657185716\n5875587E58835893588A58795885587D58FD592559225924596A59695AE15AE6\n5AE95AD75AD65AD85AE35B755BDE5BE75BE15BE55BE65BE85BE25BE45BDF5C0D\n5C625D845D875E5B5E635E555E575E545ED35ED65F0A5F465F705FB961470000\nBA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n613F614B617761626163615F615A61586175622A64876458645464A46478645F\n647A645164676434646D647B657265A165D765D666A266A8669D699C69A86995\n69C169AE69D369CB699B69B769BB69AB69B469D069CD69AD69CC69A669C369A3\n6B496B4C6C336F336F146EFE6F136EF46F296F3E6F206F2C6F0F6F026F220000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006EFF6EEF6F066F316F386F326F236F156F2B6F2F6F886F2A6EEC6F016EF2\n6ECC6EF771947199717D718A71847192723E729272967344735074647463746A\n7470746D750475917627760D760B7609761376E176E37784777D777F776178C1\n789F78A778B378A978A3798E798F798D7A2E7A317AAA7AA97AED7AEF7BA17B95\n7B8B7B757B977B9D7B947B8F7BB87B877B847CB97CBD7CBE7DBB7DB07D9C7DBD\n7DBE7DA07DCA7DB47DB27DB17DBA7DA27DBF7DB57DB87DAD7DD27DC77DAC0000\nBB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7F707FE07FE17FDF805E805A808781508180818F8188818A817F818281E781FA\n82078214821E824B84C984BF84C684C48499849E84B2849C84CB84B884C084D3\n849084BC84D184CA873F871C873B872287258734871887558737872988F38902\n88F488F988F888FD88E8891A88EF8AA68A8C8A9E8AA38A8D8AA18A938AA40000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008AAA8AA58AA88A988A918A9A8AA78C6A8C8D8C8C8CD38CD18CD28D6B8D99\n8D958DFC8F148F128F158F138FA390609058905C90639059905E9062905D905B\n91199118911E917591789177917492789280928592989296927B9293929C92A8\n927C929195A195A895A995A395A595A49699969C969B96CC96D29700977C9785\n97F69817981898AF98B199039905990C990999C19AAF9AB09AE69B419B429CF4\n9CF69CF39EBC9F3B9F4A5104510050FB50F550F9510251085109510551DC0000\nBC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n528752885289528D528A52F053B2562E563B56395632563F563456295653564E\n565756745636562F56305880589F589E58B3589C58AE58A958A6596D5B095AFB\n5B0B5AF55B0C5B085BEE5BEC5BE95BEB5C645C655D9D5D945E625E5F5E615EE2\n5EDA5EDF5EDD5EE35EE05F485F715FB75FB561766167616E615D615561820000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000617C6170616B617E61A7619061AB618E61AC619A61A4619461AE622E6469\n646F6479649E64B26488649064B064A56493649564A9649264AE64AD64AB649A\n64AC649964A264B365756577657866AE66AB66B466B16A236A1F69E86A016A1E\n6A1969FD6A216A136A0A69F36A026A0569ED6A116B506B4E6BA46BC56BC66F3F\n6F7C6F846F516F666F546F866F6D6F5B6F786F6E6F8E6F7A6F706F646F976F58\n6ED56F6F6F606F5F719F71AC71B171A87256729B734E73577469748B74830000\nBD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n747E7480757F76207629761F7624762676217622769A76BA76E4778E7787778C\n7791778B78CB78C578BA78CA78BE78D578BC78D07A3F7A3C7A407A3D7A377A3B\n7AAF7AAE7BAD7BB17BC47BB47BC67BC77BC17BA07BCC7CCA7DE07DF47DEF7DFB\n7DD87DEC7DDD7DE87DE37DDA7DDE7DE97D9E7DD97DF27DF97F757F777FAF0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007FE98026819B819C819D81A0819A81988517853D851A84EE852C852D8513\n851185238521851484EC852584FF850687828774877687608766877887688759\n8757874C8753885B885D89108907891289138915890A8ABC8AD28AC78AC48A95\n8ACB8AF88AB28AC98AC28ABF8AB08AD68ACD8AB68AB98ADB8C4C8C4E8C6C8CE0\n8CDE8CE68CE48CEC8CED8CE28CE38CDC8CEA8CE18D6D8D9F8DA38E2B8E108E1D\n8E228E0F8E298E1F8E218E1E8EBA8F1D8F1B8F1F8F298F268F2A8F1C8F1E0000\nBE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8F259069906E9068906D90779130912D9127913191879189918B918392C592BB\n92B792EA92AC92E492C192B392BC92D292C792F092B295AD95B1970497069707\n97099760978D978B978F9821982B981C98B3990A99139912991899DD99D099DF\n99DB99D199D599D299D99AB79AEE9AEF9B279B459B449B779B6F9D069D090000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009D039EA99EBE9ECE58A89F5251125118511451105115518051AA51DD5291\n529352F35659566B5679566956645678566A566856655671566F566C56625676\n58C158BE58C758C5596E5B1D5B345B785BF05C0E5F4A61B2619161A9618A61CD\n61B661BE61CA61C8623064C564C164CB64BB64BC64DA64C464C764C264CD64BF\n64D264D464BE657466C666C966B966C466C766B86A3D6A386A3A6A596A6B6A58\n6A396A446A626A616A4B6A476A356A5F6A486B596B776C056FC26FB16FA10000\nBF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6FC36FA46FC16FA76FB36FC06FB96FB66FA66FA06FB471BE71C971D071D271C8\n71D571B971CE71D971DC71C371C47368749C74A37498749F749E74E2750C750D\n76347638763A76E776E577A0779E779F77A578E878DA78EC78E779A67A4D7A4E\n7A467A4C7A4B7ABA7BD97C117BC97BE47BDB7BE17BE97BE67CD57CD67E0A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007E117E087E1B7E237E1E7E1D7E097E107F797FB27FF07FF17FEE802881B3\n81A981A881FB820882588259854A855985488568856985438549856D856A855E\n8783879F879E87A2878D8861892A89328925892B892189AA89A68AE68AFA8AEB\n8AF18B008ADC8AE78AEE8AFE8B018B028AF78AED8AF38AF68AFC8C6B8C6D8C93\n8CF48E448E318E348E428E398E358F3B8F2F8F388F338FA88FA6907590749078\n9072907C907A913491929320933692F89333932F932292FC932B9304931A0000\nC0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9310932693219315932E931995BB96A796A896AA96D5970E97119716970D9713\n970F975B975C9766979898309838983B9837982D9839982499109928991E991B\n9921991A99ED99E299F19AB89ABC9AFB9AED9B289B919D159D239D269D289D12\n9D1B9ED89ED49F8D9F9C512A511F5121513252F5568E56805690568556870000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000568F58D558D358D158CE5B305B2A5B245B7A5C375C685DBC5DBA5DBD5DB8\n5E6B5F4C5FBD61C961C261C761E661CB6232623464CE64CA64D864E064F064E6\n64EC64F164E264ED6582658366D966D66A806A946A846AA26A9C6ADB6AA36A7E\n6A976A906AA06B5C6BAE6BDA6C086FD86FF16FDF6FE06FDB6FE46FEB6FEF6F80\n6FEC6FE16FE96FD56FEE6FF071E771DF71EE71E671E571ED71EC71F471E07235\n72467370737274A974B074A674A876467642764C76EA77B377AA77B077AC0000\nC1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n77A777AD77EF78F778FA78F478EF790179A779AA7A577ABF7C077C0D7BFE7BF7\n7C0C7BE07CE07CDC7CDE7CE27CDF7CD97CDD7E2E7E3E7E467E377E327E437E2B\n7E3D7E317E457E417E347E397E487E357E3F7E2F7F447FF37FFC807180728070\n806F807381C681C381BA81C281C081BF81BD81C981BE81E88209827185AA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008584857E859C8591859485AF859B858785A8858A866787C087D187B387D2\n87C687AB87BB87BA87C887CB893B893689448938893D89AC8B0E8B178B198B1B\n8B0A8B208B1D8B048B108C418C3F8C738CFA8CFD8CFC8CF88CFB8DA88E498E4B\n8E488E4A8F448F3E8F428F458F3F907F907D9084908190829080913991A3919E\n919C934D938293289375934A9365934B9318937E936C935B9370935A935495CA\n95CB95CC95C895C696B196B896D6971C971E97A097D3984698B699359A010000\nC2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n99FF9BAE9BAB9BAA9BAD9D3B9D3F9E8B9ECF9EDE9EDC9EDD9EDB9F3E9F4B53E2\n569556AE58D958D85B385F5D61E3623364F464F264FE650664FA64FB64F765B7\n66DC67266AB36AAC6AC36ABB6AB86AC26AAE6AAF6B5F6B786BAF7009700B6FFE\n70066FFA7011700F71FB71FC71FE71F87377737574A774BF7515765676580000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000765277BD77BF77BB77BC790E79AE7A617A627A607AC47AC57C2B7C277C2A\n7C1E7C237C217CE77E547E557E5E7E5A7E617E527E597F487FF97FFB80778076\n81CD81CF820A85CF85A985CD85D085C985B085BA85B985A687EF87EC87F287E0\n898689B289F48B288B398B2C8B2B8C508D058E598E638E668E648E5F8E558EC0\n8F498F4D90879083908891AB91AC91D09394938A939693A293B393AE93AC93B0\n9398939A939795D495D695D095D596E296DC96D996DB96DE972497A397A60000\nC3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n97AD97F9984D984F984C984E985398BA993E993F993D992E99A59A0E9AC19B03\n9B069B4F9B4E9B4D9BCA9BC99BFD9BC89BC09D519D5D9D609EE09F159F2C5133\n56A558DE58DF58E25BF59F905EEC61F261F761F661F56500650F66E066DD6AE5\n6ADD6ADA6AD3701B701F7028701A701D701570187206720D725872A273780000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000737A74BD74CA74E375877586765F766177C7791979B17A6B7A697C3E7C3F\n7C387C3D7C377C407E6B7E6D7E797E697E6A7F857E737FB67FB97FB881D885E9\n85DD85EA85D585E485E585F787FB8805880D87F987FE8960895F8956895E8B41\n8B5C8B588B498B5A8B4E8B4F8B468B598D088D0A8E7C8E728E878E768E6C8E7A\n8E748F548F4E8FAD908A908B91B191AE93E193D193DF93C393C893DC93DD93D6\n93E293CD93D893E493D793E895DC96B496E3972A9727976197DC97FB985E0000\nC4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9858985B98BC994599499A169A199B0D9BE89BE79BD69BDB9D899D619D729D6A\n9D6C9E929E979E939EB452F856A856B756B656B456BC58E45B405B435B7D5BF6\n5DC961F861FA65186514651966E667276AEC703E703070327210737B74CF7662\n76657926792A792C792B7AC77AF67C4C7C437C4D7CEF7CF08FAE7E7D7E7C0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007E827F4C800081DA826685FB85F9861185FA8606860B8607860A88148815\n896489BA89F88B708B6C8B668B6F8B5F8B6B8D0F8D0D8E898E818E858E8291B4\n91CB9418940393FD95E1973098C49952995199A89A2B9A309A379A359C139C0D\n9E799EB59EE89F2F9F5F9F639F615137513856C156C056C259145C6C5DCD61FC\n61FE651D651C659566E96AFB6B046AFA6BB2704C721B72A774D674D4766977D3\n7C507E8F7E8C7FBC8617862D861A882388228821881F896A896C89BD8B740000\nC5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8B778B7D8D138E8A8E8D8E8B8F5F8FAF91BA942E94339435943A94389432942B\n95E297389739973297FF9867986599579A459A439A409A3E9ACF9B549B519C2D\n9C259DAF9DB49DC29DB89E9D9EEF9F199F5C9F669F67513C513B56C856CA56C9\n5B7F5DD45DD25F4E61FF65246B0A6B6170517058738074E4758A766E766C0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000079B37C607C5F807E807D81DF8972896F89FC8B808D168D178E918E938F61\n9148944494519452973D973E97C397C1986B99559A559A4D9AD29B1A9C499C31\n9C3E9C3B9DD39DD79F349F6C9F6A9F9456CC5DD662006523652B652A66EC6B10\n74DA7ACA7C647C637C657E937E967E9481E28638863F88318B8A9090908F9463\n946094649768986F995C9A5A9A5B9A579AD39AD49AD19C549C579C569DE59E9F\n9EF456D158E9652C705E7671767277D77F507F888836883988628B938B920000\nC6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8B9682778D1B91C0946A97429748974497C698709A5F9B229B589C5F9DF99DFA\n9E7C9E7D9F079F779F725EF36B1670637C6C7C6E883B89C08EA191C194729470\n9871995E9AD69B239ECC706477DA8B9A947797C99A629A657E9C8B9C8EAA91C5\n947D947E947C9C779C789EF78C54947F9E1A72289A6A9B319E1B9E1E7C720000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000030FE309D309E3005304130423043304430453046304730483049304A304B\n304C304D304E304F3050305130523053305430553056305730583059305A305B\n305C305D305E305F3060306130623063306430653066306730683069306A306B\n306C306D306E306F3070307130723073307430753076307730783079307A307B\n307C307D307E307F3080308130823083308430853086308730883089308A308B\n308C308D308E308F309030913092309330A130A230A330A430A530A630A70000\nC7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n30A830A930AA30AB30AC30AD30AE30AF30B030B130B230B330B430B530B630B7\n30B830B930BA30BB30BC30BD30BE30BF30C030C130C230C330C430C530C630C7\n30C830C930CA30CB30CC30CD30CE30CF30D030D130D230D330D430D530D630D7\n30D830D930DA30DB30DC30DD30DE30DF30E030E130E230E330E430E530E60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000030E730E830E930EA30EB30EC30ED30EE30EF30F030F130F230F330F430F5\n30F60414041504010416041704180419041A041B041C04230424042504260427\n04280429042A042B042C042D042E042F04300431043204330434043504510436\n043704380439043A043B043C043D043E043F0440044104420443044404450446\n044704480449044A044B044C044D044E044F2460246124622463246424652466\n246724682469247424752476247724782479247A247B247C247D000000000000\nC9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4E424E5C51F5531A53824E074E0C4E474E8D56D7FA0C5C6E5F734E0F51874E0E\n4E2E4E934EC24EC94EC8519852FC536C53B957205903592C5C105DFF65E16BB3\n6BCC6C14723F4E314E3C4EE84EDC4EE94EE14EDD4EDA520C531C534C57225723\n5917592F5B815B845C125C3B5C745C735E045E805E825FC9620962506C150000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006C366C436C3F6C3B72AE72B0738A79B8808A961E4F0E4F184F2C4EF54F14\n4EF14F004EF74F084F1D4F024F054F224F134F044EF44F1251B1521352095210\n52A65322531F534D538A540756E156DF572E572A5734593C5980597C5985597B\n597E5977597F5B565C155C255C7C5C7A5C7B5C7E5DDF5E755E845F025F1A5F74\n5FD55FD45FCF625C625E626462616266626262596260625A626565EF65EE673E\n67396738673B673A673F673C67336C186C466C526C5C6C4F6C4A6C546C4B0000\nCA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6C4C7071725E72B472B5738E752A767F7A757F518278827C8280827D827F864D\n897E909990979098909B909496229624962096234F564F3B4F624F494F534F64\n4F3E4F674F524F5F4F414F584F2D4F334F3F4F61518F51B9521C521E522152AD\n52AE530953635372538E538F54305437542A545454455419541C542554180000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000543D544F544154285424544756EE56E756E557415745574C5749574B5752\n5906594059A6599859A05997598E59A25990598F59A759A15B8E5B925C285C2A\n5C8D5C8F5C885C8B5C895C925C8A5C865C935C955DE05E0A5E0E5E8B5E895E8C\n5E885E8D5F055F1D5F785F765FD25FD15FD05FED5FE85FEE5FF35FE15FE45FE3\n5FFA5FEF5FF75FFB60005FF4623A6283628C628E628F629462876271627B627A\n6270628162886277627D62726274653765F065F465F365F265F5674567470000\nCB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n67596755674C6748675D674D675A674B6BD06C196C1A6C786C676C6B6C846C8B\n6C8F6C716C6F6C696C9A6C6D6C876C956C9C6C666C736C656C7B6C8E7074707A\n726372BF72BD72C372C672C172BA72C573957397739373947392753A75397594\n75957681793D80348095809980908092809C8290828F8285828E829182930000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000828A828382848C788FC98FBF909F90A190A5909E90A790A096309628962F\n962D4E334F984F7C4F854F7D4F804F874F764F744F894F844F774F4C4F974F6A\n4F9A4F794F814F784F904F9C4F944F9E4F924F824F954F6B4F6E519E51BC51BE\n5235523252335246523152BC530A530B533C539253945487547F548154915482\n5488546B547A547E5465546C54745466548D546F546154605498546354675464\n56F756F9576F5772576D576B57715770577657805775577B5773577457620000\nCC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5768577D590C594559B559BA59CF59CE59B259CC59C159B659BC59C359D659B1\n59BD59C059C859B459C75B625B655B935B955C445C475CAE5CA45CA05CB55CAF\n5CA85CAC5C9F5CA35CAD5CA25CAA5CA75C9D5CA55CB65CB05CA65E175E145E19\n5F285F225F235F245F545F825F7E5F7D5FDE5FE5602D602660196032600B0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006034600A60176033601A601E602C6022600D6010602E60136011600C6009\n601C6214623D62AD62B462D162BE62AA62B662CA62AE62B362AF62BB62A962B0\n62B8653D65A865BB660965FC66046612660865FB6603660B660D660565FD6611\n661066F6670A6785676C678E67926776677B6798678667846774678D678C677A\n679F679167996783677D67816778677967946B256B806B7E6BDE6C1D6C936CEC\n6CEB6CEE6CD96CB66CD46CAD6CE76CB76CD06CC26CBA6CC36CC66CED6CF20000\nCD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6CD26CDD6CB46C8A6C9D6C806CDE6CC06D306CCD6CC76CB06CF96CCF6CE96CD1\n709470987085709370867084709170967082709A7083726A72D672CB72D872C9\n72DC72D272D472DA72CC72D173A473A173AD73A673A273A073AC739D74DD74E8\n753F7540753E758C759876AF76F376F176F076F577F877FC77F977FB77FA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000077F77942793F79C57A787A7B7AFB7C757CFD8035808F80AE80A380B880B5\n80AD822082A082C082AB829A8298829B82B582A782AE82BC829E82BA82B482A8\n82A182A982C282A482C382B682A28670866F866D866E8C568FD28FCB8FD38FCD\n8FD68FD58FD790B290B490AF90B390B09639963D963C963A96434FCD4FC54FD3\n4FB24FC94FCB4FC14FD44FDC4FD94FBB4FB34FDB4FC74FD64FBA4FC04FB94FEC\n5244524952C052C2533D537C539753965399539854BA54A154AD54A554CF0000\nCE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n54C3830D54B754AE54D654B654C554C654A0547054BC54A254BE547254DE54B0\n57B5579E579F57A4578C5797579D579B57945798578F579957A5579A579558F4\n590D595359E159DE59EE5A0059F159DD59FA59FD59FC59F659E459F259F759DB\n59E959F359F559E059FE59F459ED5BA85C4C5CD05CD85CCC5CD75CCB5CDB0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005CDE5CDA5CC95CC75CCA5CD65CD35CD45CCF5CC85CC65CCE5CDF5CF85DF9\n5E215E225E235E205E245EB05EA45EA25E9B5EA35EA55F075F2E5F565F866037\n603960546072605E6045605360476049605B604C60406042605F602460446058\n6066606E6242624362CF630D630B62F5630E630362EB62F9630F630C62F862F6\n63006313631462FA631562FB62F06541654365AA65BF6636662166326635661C\n662666226633662B663A661D66346639662E670F671067C167F267C867BA0000\nCF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n67DC67BB67F867D867C067B767C567EB67E467DF67B567CD67B367F767F667EE\n67E367C267B967CE67E767F067B267FC67C667ED67CC67AE67E667DB67FA67C9\n67CA67C367EA67CB6B286B826B846BB66BD66BD86BE06C206C216D286D346D2D\n6D1F6D3C6D3F6D126D0A6CDA6D336D046D196D3A6D1A6D116D006D1D6D420000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006D016D186D376D036D0F6D406D076D206D2C6D086D226D096D1070B7709F\n70BE70B170B070A170B470B570A972417249724A726C72707273726E72CA72E4\n72E872EB72DF72EA72E672E3738573CC73C273C873C573B973B673B573B473EB\n73BF73C773BE73C373C673B873CB74EC74EE752E7547754875A775AA767976C4\n7708770377047705770A76F776FB76FA77E777E878067811781278057810780F\n780E780978037813794A794C794B7945794479D579CD79CF79D679CE7A800000\nD0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7A7E7AD17B007B017C7A7C787C797C7F7C807C817D037D087D017F587F917F8D\n7FBE8007800E800F8014803780D880C780E080D180C880C280D080C580E380D9\n80DC80CA80D580C980CF80D780E680CD81FF8221829482D982FE82F9830782E8\n830082D5833A82EB82D682F482EC82E182F282F5830C82FB82F682F082EA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000082E482E082FA82F382ED86778674867C86738841884E8867886A886989D3\n8A048A078D728FE38FE18FEE8FE090F190BD90BF90D590C590BE90C790CB90C8\n91D491D39654964F96519653964A964E501E50055007501350225030501B4FF5\n4FF450335037502C4FF64FF75017501C502050275035502F5031500E515A5194\n519351CA51C451C551C851CE5261525A5252525E525F5255526252CD530E539E\n552654E25517551254E754F354E4551A54FF5504550854EB5511550554F10000\nD1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n550A54FB54F754F854E0550E5503550B5701570257CC583257D557D257BA57C6\n57BD57BC57B857B657BF57C757D057B957C1590E594A5A195A165A2D5A2E5A15\n5A0F5A175A0A5A1E5A335B6C5BA75BAD5BAC5C035C565C545CEC5CFF5CEE5CF1\n5CF75D005CF95E295E285EA85EAE5EAA5EAC5F335F305F67605D605A60670000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000604160A26088608060926081609D60836095609B60976087609C608E6219\n624662F263106356632C634463456336634363E46339634B634A633C63296341\n6334635863546359632D63476333635A63516338635763406348654A654665C6\n65C365C465C2664A665F6647665167126713681F681A684968326833683B684B\n684F68166831681C6835682B682D682F684E68446834681D6812681468266828\n682E684D683A682568206B2C6B2F6B2D6B316B346B6D80826B886BE66BE40000\nD2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6BE86BE36BE26BE76C256D7A6D636D646D766D0D6D616D926D586D626D6D6D6F\n6D916D8D6DEF6D7F6D866D5E6D676D606D976D706D7C6D5F6D826D986D2F6D68\n6D8B6D7E6D806D846D166D836D7B6D7D6D756D9070DC70D370D170DD70CB7F39\n70E270D770D270DE70E070D470CD70C570C670C770DA70CE70E1724272780000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000072777276730072FA72F472FE72F672F372FB730173D373D973E573D673BC\n73E773E373E973DC73D273DB73D473DD73DA73D773D873E874DE74DF74F474F5\n7521755B755F75B075C175BB75C475C075BF75B675BA768A76C9771D771B7710\n771377127723771177157719771A772277277823782C78227835782F7828782E\n782B782178297833782A78317954795B794F795C79537952795179EB79EC79E0\n79EE79ED79EA79DC79DE79DD7A867A897A857A8B7A8C7A8A7A877AD87B100000\nD3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7B047B137B057B0F7B087B0A7B0E7B097B127C847C917C8A7C8C7C887C8D7C85\n7D1E7D1D7D117D0E7D187D167D137D1F7D127D0F7D0C7F5C7F617F5E7F607F5D\n7F5B7F967F927FC37FC27FC08016803E803980FA80F280F980F5810180FB8100\n8201822F82258333832D83448319835183258356833F83418326831C83220000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008342834E831B832A8308833C834D8316832483208337832F832983478345\n834C8353831E832C834B832783488653865286A286A88696868D8691869E8687\n86978686868B869A868586A5869986A186A786958698868E869D869086948843\n8844886D88758876887288808871887F886F8883887E8874887C8A128C478C57\n8C7B8CA48CA38D768D788DB58DB78DB68ED18ED38FFE8FF590028FFF8FFB9004\n8FFC8FF690D690E090D990DA90E390DF90E590D890DB90D790DC90E491500000\nD4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n914E914F91D591E291DA965C965F96BC98E39ADF9B2F4E7F5070506A5061505E\n50605053504B505D50725048504D5041505B504A506250155045505F5069506B\n5063506450465040506E50735057505151D0526B526D526C526E52D652D3532D\n539C55755576553C554D55505534552A55515562553655355530555255450000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000550C55325565554E55395548552D553B5540554B570A570757FB581457E2\n57F657DC57F4580057ED57FD580857F8580B57F357CF580757EE57E357F257E5\n57EC57E1580E57FC581057E75801580C57F157E957F0580D5804595C5A605A58\n5A555A675A5E5A385A355A6D5A505A5F5A655A6C5A535A645A575A435A5D5A52\n5A445A5B5A485A8E5A3E5A4D5A395A4C5A705A695A475A515A565A425A5C5B72\n5B6E5BC15BC05C595D1E5D0B5D1D5D1A5D205D0C5D285D0D5D265D255D0F0000\nD5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5D305D125D235D1F5D2E5E3E5E345EB15EB45EB95EB25EB35F365F385F9B5F96\n5F9F608A6090608660BE60B060BA60D360D460CF60E460D960DD60C860B160DB\n60B760CA60BF60C360CD60C063326365638A6382637D63BD639E63AD639D6397\n63AB638E636F63876390636E63AF6375639C636D63AE637C63A4633B639F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006378638563816391638D6370655365CD66656661665B6659665C66626718\n687968876890689C686D686E68AE68AB6956686F68A368AC68A96875687468B2\n688F68776892687C686B687268AA68806871687E689B6896688B68A0688968A4\n6878687B6891688C688A687D6B366B336B376B386B916B8F6B8D6B8E6B8C6C2A\n6DC06DAB6DB46DB36E746DAC6DE96DE26DB76DF66DD46E006DC86DE06DDF6DD6\n6DBE6DE56DDC6DDD6DDB6DF46DCA6DBD6DED6DF06DBA6DD56DC26DCF6DC90000\nD6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6DD06DF26DD36DFD6DD76DCD6DE36DBB70FA710D70F7711770F4710C70F07104\n70F3711070FC70FF71067113710070F870F6710B7102710E727E727B727C727F\n731D7317730773117318730A730872FF730F731E738873F673F873F574047401\n73FD7407740073FA73FC73FF740C740B73F474087564756375CE75D275CF0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000075CB75CC75D175D0768F768976D37739772F772D7731773277347733773D\n7725773B7735784878527849784D784A784C782678457850796479677969796A\n7963796B796179BB79FA79F879F679F77A8F7A947A907B357B477B347B257B30\n7B227B247B337B187B2A7B1D7B317B2B7B2D7B2F7B327B387B1A7B237C947C98\n7C967CA37D357D3D7D387D367D3A7D457D2C7D297D417D477D3E7D3F7D4A7D3B\n7D287F637F957F9C7F9D7F9B7FCA7FCB7FCD7FD07FD17FC77FCF7FC9801F0000\nD7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n801E801B804780438048811881258119811B812D811F812C811E812181158127\n811D8122821182388233823A823482328274839083A383A8838D837A837383A4\n8374838F8381839583998375839483A9837D8383838C839D839B83AA838B837E\n83A583AF8388839783B0837F83A6838783AE8376839A8659865686BF86B70000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000086C286C186C586BA86B086C886B986B386B886CC86B486BB86BC86C386BD\n86BE88528889889588A888A288AA889A889188A1889F889888A78899889B8897\n88A488AC888C8893888E898289D689D989D58A308A278A2C8A1E8C398C3B8C5C\n8C5D8C7D8CA58D7D8D7B8D798DBC8DC28DB98DBF8DC18ED88EDE8EDD8EDC8ED7\n8EE08EE19024900B9011901C900C902190EF90EA90F090F490F290F390D490EB\n90EC90E991569158915A9153915591EC91F491F191F391F891E491F991EA0000\nD8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n91EB91F791E891EE957A95869588967C966D966B9671966F96BF976A980498E5\n9997509B50955094509E508B50A35083508C508E509D5068509C509250825087\n515F51D45312531153A453A7559155A855A555AD5577564555A255935588558F\n55B5558155A3559255A4557D558C55A6557F559555A1558E570C582958370000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005819581E58275823582857F558485825581C581B5833583F5836582E5839\n5838582D582C583B59615AAF5A945A9F5A7A5AA25A9E5A785AA65A7C5AA55AAC\n5A955AAE5A375A845A8A5A975A835A8B5AA95A7B5A7D5A8C5A9C5A8F5A935A9D\n5BEA5BCD5BCB5BD45BD15BCA5BCE5C0C5C305D375D435D6B5D415D4B5D3F5D35\n5D515D4E5D555D335D3A5D525D3D5D315D595D425D395D495D385D3C5D325D36\n5D405D455E445E415F585FA65FA55FAB60C960B960CC60E260CE60C461140000\nD9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n60F2610A6116610560F5611360F860FC60FE60C161036118611D611060FF6104\n610B624A639463B163B063CE63E563E863EF63C3649D63F363CA63E063F663D5\n63F263F5646163DF63BE63DD63DC63C463D863D363C263C763CC63CB63C863F0\n63D763D965326567656A6564655C65686565658C659D659E65AE65D065D20000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000667C666C667B668066716679666A66726701690C68D3690468DC692A68EC\n68EA68F1690F68D668F768EB68E468F66913691068F368E1690768CC69086970\n68B4691168EF68C6691468F868D068FD68FC68E8690B690A691768CE68C868DD\n68DE68E668F468D1690668D468E96915692568C76B396B3B6B3F6B3C6B946B97\n6B996B956BBD6BF06BF26BF36C306DFC6E466E476E1F6E496E886E3C6E3D6E45\n6E626E2B6E3F6E416E5D6E736E1C6E336E4B6E406E516E3B6E036E2E6E5E0000\nDA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6E686E5C6E616E316E286E606E716E6B6E396E226E306E536E656E276E786E64\n6E776E556E796E526E666E356E366E5A7120711E712F70FB712E713171237125\n71227132711F7128713A711B724B725A7288728972867285728B7312730B7330\n73227331733373277332732D732673237335730C742E742C7430742B74160000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000741A7421742D743174247423741D74297420743274FB752F756F756C75E7\n75DA75E175E675DD75DF75E475D77695769276DA774677477744774D7745774A\n774E774B774C77DE77EC786078647865785C786D7871786A786E787078697868\n785E786279747973797279707A027A0A7A037A0C7A047A997AE67AE47B4A7B3B\n7B447B487B4C7B4E7B407B587B457CA27C9E7CA87CA17D587D6F7D637D537D56\n7D677D6A7D4F7D6D7D5C7D6B7D527D547D697D517D5F7D4E7F3E7F3F7F650000\nDB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7F667FA27FA07FA17FD78051804F805080FE80D48143814A8152814F8147813D\n814D813A81E681EE81F781F881F98204823C823D823F8275833B83CF83F98423\n83C083E8841283E783E483FC83F6841083C683C883EB83E383BF840183DD83E5\n83D883FF83E183CB83CE83D683F583C98409840F83DE8411840683C283F30000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000083D583FA83C783D183EA841383C383EC83EE83C483FB83D783E2841B83DB\n83FE86D886E286E686D386E386DA86EA86DD86EB86DC86EC86E986D786E886D1\n88488856885588BA88D788B988B888C088BE88B688BC88B788BD88B2890188C9\n89958998899789DD89DA89DB8A4E8A4D8A398A598A408A578A588A448A458A52\n8A488A518A4A8A4C8A4F8C5F8C818C808CBA8CBE8CB08CB98CB58D848D808D89\n8DD88DD38DCD8DC78DD68DDC8DCF8DD58DD98DC88DD78DC58EEF8EF78EFA0000\nDC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8EF98EE68EEE8EE58EF58EE78EE88EF68EEB8EF18EEC8EF48EE9902D9034902F\n9106912C910490FF90FC910890F990FB9101910091079105910391619164915F\n916291609201920A92259203921A9226920F920C9200921291FF91FD92069204\n92279202921C92249219921792059216957B958D958C95909687967E96880000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000096899683968096C296C896C396F196F0976C9770976E980798A998EB9CE6\n9EF94E834E844EB650BD50BF50C650AE50C450CA50B450C850C250B050C150BA\n50B150CB50C950B650B851D7527A5278527B527C55C355DB55CC55D055CB55CA\n55DD55C055D455C455E955BF55D2558D55CF55D555E255D655C855F255CD55D9\n55C25714585358685864584F584D5849586F5855584E585D58595865585B583D\n5863587158FC5AC75AC45ACB5ABA5AB85AB15AB55AB05ABF5AC85ABB5AC60000\nDD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5AB75AC05ACA5AB45AB65ACD5AB95A905BD65BD85BD95C1F5C335D715D635D4A\n5D655D725D6C5D5E5D685D675D625DF05E4F5E4E5E4A5E4D5E4B5EC55ECC5EC6\n5ECB5EC75F405FAF5FAD60F76149614A612B614561366132612E6146612F614F\n612961406220916862236225622463C563F163EB641064126409642064240000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000064336443641F641564186439643764226423640C64266430642864416435\n642F640A641A644064256427640B63E7641B642E6421640E656F659265D36686\n668C66956690668B668A66996694667867206966695F6938694E69626971693F\n6945696A6939694269576959697A694869496935696C6933693D696568F06978\n693469696940696F69446976695869416974694C693B694B6937695C694F6951\n69326952692F697B693C6B466B456B436B426B486B416B9BFA0D6BFB6BFC0000\nDE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6BF96BF76BF86E9B6ED66EC86E8F6EC06E9F6E936E946EA06EB16EB96EC66ED2\n6EBD6EC16E9E6EC96EB76EB06ECD6EA66ECF6EB26EBE6EC36EDC6ED86E996E92\n6E8E6E8D6EA46EA16EBF6EB36ED06ECA6E976EAE6EA371477154715271637160\n7141715D716271727178716A7161714271587143714B7170715F715071530000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007144714D715A724F728D728C72917290728E733C7342733B733A7340734A\n73497444744A744B7452745174577440744F7450744E74427446744D745474E1\n74FF74FE74FD751D75797577698375EF760F760375F775FE75FC75F975F87610\n75FB75F675ED75F575FD769976B576DD7755775F776077527756775A77697767\n77547759776D77E07887789A7894788F788478957885788678A1788378797899\n78807896787B797C7982797D79797A117A187A197A127A177A157A227A130000\nDF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7A1B7A107AA37AA27A9E7AEB7B667B647B6D7B747B697B727B657B737B717B70\n7B617B787B767B637CB27CB47CAF7D887D867D807D8D7D7F7D857D7A7D8E7D7B\n7D837D7C7D8C7D947D847D7D7D927F6D7F6B7F677F687F6C7FA67FA57FA77FDB\n7FDC8021816481608177815C8169815B816281726721815E81768167816F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000081448161821D8249824482408242824584F1843F845684768479848F848D\n846584518440848684678430844D847D845A845984748473845D8507845E8437\n843A8434847A8443847884328445842983D9844B842F8442842D845F84708439\n844E844C8452846F84C5848E843B8447843684338468847E8444842B84608454\n846E8450870B870486F7870C86FA86D686F5874D86F8870E8709870186F6870D\n870588D688CB88CD88CE88DE88DB88DA88CC88D08985899B89DF89E589E40000\nE0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n89E189E089E289DC89E68A768A868A7F8A618A3F8A778A828A848A758A838A81\n8A748A7A8C3C8C4B8C4A8C658C648C668C868C848C858CCC8D688D698D918D8C\n8D8E8D8F8D8D8D938D948D908D928DF08DE08DEC8DF18DEE8DD08DE98DE38DE2\n8DE78DF28DEB8DF48F068EFF8F018F008F058F078F088F028F0B9052903F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000090449049903D9110910D910F911191169114910B910E916E916F92489252\n9230923A926692339265925E9283922E924A9246926D926C924F92609267926F\n92369261927092319254926392509272924E9253924C92569232959F959C959E\n959B969296939691969796CE96FA96FD96F896F59773977797789772980F980D\n980E98AC98F698F999AF99B299B099B59AAD9AAB9B5B9CEA9CED9CE79E809EFD\n50E650D450D750E850F350DB50EA50DD50E450D350EC50F050EF50E350E00000\nE1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n51D85280528152E952EB533053AC56275615560C561255FC560F561C56015613\n560255FA561D560455FF55F95889587C5890589858865881587F5874588B587A\n58875891588E587658825888587B5894588F58FE596B5ADC5AEE5AE55AD55AEA\n5ADA5AED5AEB5AF35AE25AE05ADB5AEC5ADE5ADD5AD95AE85ADF5B775BE00000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005BE35C635D825D805D7D5D865D7A5D815D775D8A5D895D885D7E5D7C5D8D\n5D795D7F5E585E595E535ED85ED15ED75ECE5EDC5ED55ED95ED25ED45F445F43\n5F6F5FB6612C61286141615E61716173615261536172616C618061746154617A\n615B6165613B616A6161615662296227622B642B644D645B645D647464766472\n6473647D6475646664A6644E6482645E645C644B645364606450647F643F646C\n646B645964656477657365A066A166A0669F67056704672269B169B669C90000\nE2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n69A069CE699669B069AC69BC69916999698E69A7698D69A969BE69AF69BF69C4\n69BD69A469D469B969CA699A69CF69B3699369AA69A1699E69D96997699069C2\n69B569A569C66B4A6B4D6B4B6B9E6B9F6BA06BC36BC46BFE6ECE6EF56EF16F03\n6F256EF86F376EFB6F2E6F096F4E6F196F1A6F276F186F3B6F126EED6F0A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006F366F736EF96EEE6F2D6F406F306F3C6F356EEB6F076F0E6F436F056EFD\n6EF66F396F1C6EFC6F3A6F1F6F0D6F1E6F086F21718771907189718071857182\n718F717B718671817197724472537297729572937343734D7351734C74627473\n7471747574727467746E750075027503757D759076167608760C76157611760A\n761476B87781777C77857782776E7780776F777E778378B278AA78B478AD78A8\n787E78AB789E78A578A078AC78A278A47998798A798B79967995799479930000\nE3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n79977988799279907A2B7A4A7A307A2F7A287A267AA87AAB7AAC7AEE7B887B9C\n7B8A7B917B907B967B8D7B8C7B9B7B8E7B857B9852847B997BA47B827CBB7CBF\n7CBC7CBA7DA77DB77DC27DA37DAA7DC17DC07DC57D9D7DCE7DC47DC67DCB7DCC\n7DAF7DB97D967DBC7D9F7DA67DAE7DA97DA17DC97F737FE27FE37FE57FDE0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008024805D805C8189818681838187818D818C818B8215849784A484A1849F\n84BA84CE84C284AC84AE84AB84B984B484C184CD84AA849A84B184D0849D84A7\n84BB84A2849484C784CC849B84A984AF84A884D6849884B684CF84A084D784D4\n84D284DB84B084918661873387238728876B8740872E871E87218719871B8743\n872C8741873E874687208732872A872D873C8712873A87318735874287268727\n87388724871A8730871188F788E788F188F288FA88FE88EE88FC88F688FB0000\nE4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n88F088EC88EB899D89A1899F899E89E989EB89E88AAB8A998A8B8A928A8F8A96\n8C3D8C688C698CD58CCF8CD78D968E098E028DFF8E0D8DFD8E0A8E038E078E06\n8E058DFE8E008E048F108F118F0E8F0D9123911C91209122911F911D911A9124\n9121911B917A91729179917392A592A49276929B927A92A0929492AA928D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000092A6929A92AB92799297927F92A392EE928E9282929592A2927D928892A1\n928A9286928C929992A7927E928792A9929D928B922D969E96A196FF9758977D\n977A977E978397809782977B97849781977F97CE97CD981698AD98AE99029900\n9907999D999C99C399B999BB99BA99C299BD99C79AB19AE39AE79B3E9B3F9B60\n9B619B5F9CF19CF29CF59EA750FF5103513050F85106510750F650FE510B510C\n50FD510A528B528C52F152EF56485642564C56355641564A5649564656580000\nE5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n565A56405633563D562C563E5638562A563A571A58AB589D58B158A058A358AF\n58AC58A558A158FF5AFF5AF45AFD5AF75AF65B035AF85B025AF95B015B075B05\n5B0F5C675D995D975D9F5D925DA25D935D955DA05D9C5DA15D9A5D9E5E695E5D\n5E605E5C7DF35EDB5EDE5EE15F495FB2618B6183617961B161B061A261890000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000619B619361AF61AD619F619261AA61A1618D616661B3622D646E64706496\n64A064856497649C648F648B648A648C64A3649F646864B164986576657A6579\n657B65B265B366B566B066A966B266B766AA66AF6A006A066A1769E569F86A15\n69F169E46A2069FF69EC69E26A1B6A1D69FE6A2769F269EE6A1469F769E76A40\n6A0869E669FB6A0D69FC69EB6A096A046A186A256A0F69F66A266A0769F46A16\n6B516BA56BA36BA26BA66C016C006BFF6C026F416F266F7E6F876FC66F920000\nE6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6F8D6F896F8C6F626F4F6F856F5A6F966F766F6C6F826F556F726F526F506F57\n6F946F936F5D6F006F616F6B6F7D6F676F906F536F8B6F696F7F6F956F636F77\n6F6A6F7B71B271AF719B71B071A0719A71A971B5719D71A5719E71A471A171AA\n719C71A771B37298729A73587352735E735F7360735D735B7361735A73590000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000736274877489748A74867481747D74857488747C747975087507757E7625\n761E7619761D761C7623761A7628761B769C769D769E769B778D778F77897788\n78CD78BB78CF78CC78D178CE78D478C878C378C478C9799A79A179A0799C79A2\n799B6B767A397AB27AB47AB37BB77BCB7BBE7BAC7BCE7BAF7BB97BCA7BB57CC5\n7CC87CCC7CCB7DF77DDB7DEA7DE77DD77DE17E037DFA7DE67DF67DF17DF07DEE\n7DDF7F767FAC7FB07FAD7FED7FEB7FEA7FEC7FE67FE88064806781A3819F0000\nE7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n819E819581A2819981978216824F825382528250824E82518524853B850F8500\n8529850E8509850D851F850A8527851C84FB852B84FA8508850C84F4852A84F2\n851584F784EB84F384FC851284EA84E9851684FE8528851D852E850284FD851E\n84F68531852684E784E884F084EF84F9851885208530850B8519852F86620000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000875687638764877787E1877387588754875B87528761875A8751875E876D\n876A8750874E875F875D876F876C877A876E875C8765874F877B877587628767\n8769885A8905890C8914890B891789188919890689168911890E890989A289A4\n89A389ED89F089EC8ACF8AC68AB88AD38AD18AD48AD58ABB8AD78ABE8AC08AC5\n8AD88AC38ABA8ABD8AD98C3E8C4D8C8F8CE58CDF8CD98CE88CDA8CDD8CE78DA0\n8D9C8DA18D9B8E208E238E258E248E2E8E158E1B8E168E118E198E268E270000\nE8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8E148E128E188E138E1C8E178E1A8F2C8F248F188F1A8F208F238F168F179073\n9070906F9067906B912F912B9129912A91329126912E91859186918A91819182\n9184918092D092C392C492C092D992B692CF92F192DF92D892E992D792DD92CC\n92EF92C292E892CA92C892CE92E692CD92D592C992E092DE92E792D192D30000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000092B592E192C692B4957C95AC95AB95AE95B096A496A296D3970597089702\n975A978A978E978897D097CF981E981D9826982998289820981B982798B29908\n98FA9911991499169917991599DC99CD99CF99D399D499CE99C999D699D899CB\n99D799CC9AB39AEC9AEB9AF39AF29AF19B469B439B679B749B719B669B769B75\n9B709B689B649B6C9CFC9CFA9CFD9CFF9CF79D079D009CF99CFB9D089D059D04\n9E839ED39F0F9F10511C51135117511A511151DE533453E156705660566E0000\nE9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n567356665663566D5672565E5677571C571B58C858BD58C958BF58BA58C258BC\n58C65B175B195B1B5B215B145B135B105B165B285B1A5B205B1E5BEF5DAC5DB1\n5DA95DA75DB55DB05DAE5DAA5DA85DB25DAD5DAF5DB45E675E685E665E6F5EE9\n5EE75EE65EE85EE55F4B5FBC619D61A8619661C561B461C661C161CC61BA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000061BF61B8618C64D764D664D064CF64C964BD648964C364DB64F364D96533\n657F657C65A266C866BE66C066CA66CB66CF66BD66BB66BA66CC67236A346A66\n6A496A676A326A686A3E6A5D6A6D6A766A5B6A516A286A5A6A3B6A3F6A416A6A\n6A646A506A4F6A546A6F6A696A606A3C6A5E6A566A556A4D6A4E6A466B556B54\n6B566BA76BAA6BAB6BC86BC76C046C036C066FAD6FCB6FA36FC76FBC6FCE6FC8\n6F5E6FC46FBD6F9E6FCA6FA870046FA56FAE6FBA6FAC6FAA6FCF6FBF6FB80000\nEA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6FA26FC96FAB6FCD6FAF6FB26FB071C571C271BF71B871D671C071C171CB71D4\n71CA71C771CF71BD71D871BC71C671DA71DB729D729E736973667367736C7365\n736B736A747F749A74A074947492749574A1750B7580762F762D7631763D7633\n763C76357632763076BB76E6779A779D77A1779C779B77A277A3779577990000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000779778DD78E978E578EA78DE78E378DB78E178E278ED78DF78E079A47A44\n7A487A477AB67AB87AB57AB17AB77BDE7BE37BE77BDD7BD57BE57BDA7BE87BF9\n7BD47BEA7BE27BDC7BEB7BD87BDF7CD27CD47CD77CD07CD17E127E217E177E0C\n7E1F7E207E137E0E7E1C7E157E1A7E227E0B7E0F7E167E0D7E147E257E247F43\n7F7B7F7C7F7A7FB17FEF802A8029806C81B181A681AE81B981B581AB81B081AC\n81B481B281B781A781F282558256825785568545856B854D8553856185580000\nEB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n854085468564854185628544855185478563853E855B8571854E856E85758555\n85678560858C8566855D85548565856C866386658664879B878F879787938792\n87888781879687988779878787A3878587908791879D87848794879C879A8789\n891E89268930892D892E89278931892289298923892F892C891F89F18AE00000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008AE28AF28AF48AF58ADD8B148AE48ADF8AF08AC88ADE8AE18AE88AFF8AEF\n8AFB8C918C928C908CF58CEE8CF18CF08CF38D6C8D6E8DA58DA78E338E3E8E38\n8E408E458E368E3C8E3D8E418E308E3F8EBD8F368F2E8F358F328F398F378F34\n90769079907B908690FA913391359136919391909191918D918F9327931E9308\n931F9306930F937A9338933C931B9323931293019346932D930E930D92CB931D\n92FA9325931392F992F793349302932492FF932993399335932A9314930C0000\nEC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n930B92FE9309930092FB931695BC95CD95BE95B995BA95B695BF95B595BD96A9\n96D4970B9712971097999797979497F097F89835982F98329924991F99279929\n999E99EE99EC99E599E499F099E399EA99E999E79AB99ABF9AB49ABB9AF69AFA\n9AF99AF79B339B809B859B879B7C9B7E9B7B9B829B939B929B909B7A9B950000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009B7D9B889D259D179D209D1E9D149D299D1D9D189D229D109D199D1F9E88\n9E869E879EAE9EAD9ED59ED69EFA9F129F3D51265125512251245120512952F4\n5693568C568D568656845683567E5682567F568158D658D458CF58D25B2D5B25\n5B325B235B2C5B275B265B2F5B2E5B7B5BF15BF25DB75E6C5E6A5FBE5FBB61C3\n61B561BC61E761E061E561E461E861DE64EF64E964E364EB64E464E865816580\n65B665DA66D26A8D6A966A816AA56A896A9F6A9B6AA16A9E6A876A936A8E0000\nED\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6A956A836AA86AA46A916A7F6AA66A9A6A856A8C6A926B5B6BAD6C096FCC6FA9\n6FF46FD46FE36FDC6FED6FE76FE66FDE6FF26FDD6FE26FE871E171F171E871F2\n71E471F071E27373736E736F749774B274AB749074AA74AD74B174A574AF7510\n75117512750F7584764376487649764776A476E977B577AB77B277B777B60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000077B477B177A877F078F378FD790278FB78FC78F2790578F978FE790479AB\n79A87A5C7A5B7A567A587A547A5A7ABE7AC07AC17C057C0F7BF27C007BFF7BFB\n7C0E7BF47C0B7BF37C027C097C037C017BF87BFD7C067BF07BF17C107C0A7CE8\n7E2D7E3C7E427E3398487E387E2A7E497E407E477E297E4C7E307E3B7E367E44\n7E3A7F457F7F7F7E7F7D7FF47FF2802C81BB81C481CC81CA81C581C781BC81E9\n825B825A825C85838580858F85A7859585A0858B85A3857B85A4859A859E0000\nEE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8577857C858985A1857A85788557858E85968586858D8599859D858185A28582\n858885858579857685988590859F866887BE87AA87AD87C587B087AC87B987B5\n87BC87AE87C987C387C287CC87B787AF87C487CA87B487B687BF87B887BD87DE\n87B289358933893C893E894189528937894289AD89AF89AE89F289F38B1E0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008B188B168B118B058B0B8B228B0F8B128B158B078B0D8B088B068B1C8B13\n8B1A8C4F8C708C728C718C6F8C958C948CF98D6F8E4E8E4D8E538E508E4C8E47\n8F438F409085907E9138919A91A2919B9199919F91A1919D91A093A1938393AF\n936493569347937C9358935C93769349935093519360936D938F934C936A9379\n935793559352934F93719377937B9361935E936393679380934E935995C795C0\n95C995C395C595B796AE96B096AC9720971F9718971D9719979A97A1979C0000\nEF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n979E979D97D597D497F198419844984A9849984598439925992B992C992A9933\n9932992F992D99319930999899A399A19A0299FA99F499F799F999F899F699FB\n99FD99FE99FC9A039ABE9AFE9AFD9B019AFC9B489B9A9BA89B9E9B9B9BA69BA1\n9BA59BA49B869BA29BA09BAF9D339D419D679D369D2E9D2F9D319D389D300000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009D459D429D439D3E9D379D409D3D7FF59D2D9E8A9E899E8D9EB09EC89EDA\n9EFB9EFF9F249F239F229F549FA05131512D512E5698569C5697569A569D5699\n59705B3C5C695C6A5DC05E6D5E6E61D861DF61ED61EE61F161EA61F061EB61D6\n61E964FF650464FD64F86501650364FC659465DB66DA66DB66D86AC56AB96ABD\n6AE16AC66ABA6AB66AB76AC76AB46AAD6B5E6BC96C0B7007700C700D70017005\n7014700E6FFF70006FFB70266FFC6FF7700A720171FF71F9720371FD73760000\nF0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n74B874C074B574C174BE74B674BB74C275147513765C76647659765076537657\n765A76A676BD76EC77C277BA78FF790C79137914790979107912791179AD79AC\n7A5F7C1C7C297C197C207C1F7C2D7C1D7C267C287C227C257C307E5C7E507E56\n7E637E587E627E5F7E517E607E577E537FB57FB37FF77FF8807581D181D20000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000081D0825F825E85B485C685C085C385C285B385B585BD85C785C485BF85CB\n85CE85C885C585B185B685D2862485B885B785BE866987E787E687E287DB87EB\n87EA87E587DF87F387E487D487DC87D387ED87D887E387A487D787D9880187F4\n87E887DD8953894B894F894C89468950895189498B2A8B278B238B338B308B35\n8B478B2F8B3C8B3E8B318B258B378B268B368B2E8B248B3B8B3D8B3A8C428C75\n8C998C988C978CFE8D048D028D008E5C8E628E608E578E568E5E8E658E670000\nF1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8E5B8E5A8E618E5D8E698E548F468F478F488F4B9128913A913B913E91A891A5\n91A791AF91AA93B5938C939293B7939B939D938993A7938E93AA939E93A69395\n93889399939F938D93B1939193B293A493A893B493A393A595D295D395D196B3\n96D796DA5DC296DF96D896DD97239722972597AC97AE97A897AB97A497AA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000097A297A597D797D997D697D897FA98509851985298B89941993C993A9A0F\n9A0B9A099A0D9A049A119A0A9A059A079A069AC09ADC9B089B049B059B299B35\n9B4A9B4C9B4B9BC79BC69BC39BBF9BC19BB59BB89BD39BB69BC49BB99BBD9D5C\n9D539D4F9D4A9D5B9D4B9D599D569D4C9D579D529D549D5F9D589D5A9E8E9E8C\n9EDF9F019F009F169F259F2B9F2A9F299F289F4C9F5551345135529652F753B4\n56AB56AD56A656A756AA56AC58DA58DD58DB59125B3D5B3E5B3F5DC35E700000\nF2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5FBF61FB65076510650D6509650C650E658465DE65DD66DE6AE76AE06ACC6AD1\n6AD96ACB6ADF6ADC6AD06AEB6ACF6ACD6ADE6B606BB06C0C7019702770207016\n702B702170227023702970177024701C702A720C720A72077202720572A572A6\n72A472A372A174CB74C574B774C37516766077C977CA77C477F1791D791B0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007921791C7917791E79B07A677A687C337C3C7C397C2C7C3B7CEC7CEA7E76\n7E757E787E707E777E6F7E7A7E727E747E687F4B7F4A7F837F867FB77FFD7FFE\n807881D781D582648261826385EB85F185ED85D985E185E885DA85D785EC85F2\n85F885D885DF85E385DC85D185F085E685EF85DE85E2880087FA880387F687F7\n8809880C880B880687FC880887FF880A88028962895A895B89578961895C8958\n895D8959898889B789B689F68B508B488B4A8B408B538B568B548B4B8B550000\nF3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8B518B428B528B578C438C778C768C9A8D068D078D098DAC8DAA8DAD8DAB8E6D\n8E788E738E6A8E6F8E7B8EC28F528F518F4F8F508F538FB49140913F91B091AD\n93DE93C793CF93C293DA93D093F993EC93CC93D993A993E693CA93D493EE93E3\n93D593C493CE93C093D293E7957D95DA95DB96E19729972B972C972897260000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000097B397B797B697DD97DE97DF985C9859985D985798BF98BD98BB98BE9948\n9947994399A699A79A1A9A159A259A1D9A249A1B9A229A209A279A239A1E9A1C\n9A149AC29B0B9B0A9B0E9B0C9B379BEA9BEB9BE09BDE9BE49BE69BE29BF09BD4\n9BD79BEC9BDC9BD99BE59BD59BE19BDA9D779D819D8A9D849D889D719D809D78\n9D869D8B9D8C9D7D9D6B9D749D759D709D699D859D739D7B9D829D6F9D799D7F\n9D879D689E949E919EC09EFC9F2D9F409F419F4D9F569F579F58533756B20000\nF4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n56B556B358E35B455DC65DC75EEE5EEF5FC05FC161F9651765166515651365DF\n66E866E366E46AF36AF06AEA6AE86AF96AF16AEE6AEF703C7035702F70377034\n703170427038703F703A70397040703B703370417213721472A8737D737C74BA\n76AB76AA76BE76ED77CC77CE77CF77CD77F27925792379277928792479290000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000079B27A6E7A6C7A6D7AF77C497C487C4A7C477C457CEE7E7B7E7E7E817E80\n7FBA7FFF807981DB81D9820B82688269862285FF860185FE861B860085F68604\n86098605860C85FD8819881088118817881388168963896689B989F78B608B6A\n8B5D8B688B638B658B678B6D8DAE8E868E888E848F598F568F578F558F588F5A\n908D9143914191B791B591B291B3940B941393FB9420940F941493FE94159410\n94289419940D93F5940093F79407940E9416941293FA940993F8940A93FF0000\nF5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n93FC940C93F69411940695DE95E095DF972E972F97B997BB97FD97FE98609862\n9863985F98C198C29950994E9959994C994B99539A329A349A319A2C9A2A9A36\n9A299A2E9A389A2D9AC79ACA9AC69B109B129B119C0B9C089BF79C059C129BF8\n9C409C079C0E9C069C179C149C099D9F9D999DA49D9D9D929D989D909D9B0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009DA09D949D9C9DAA9D979DA19D9A9DA29DA89D9E9DA39DBF9DA99D969DA6\n9DA79E999E9B9E9A9EE59EE49EE79EE69F309F2E9F5B9F609F5E9F5D9F599F91\n513A51395298529756C356BD56BE5B485B475DCB5DCF5EF161FD651B6B026AFC\n6B036AF86B0070437044704A7048704970457046721D721A7219737E7517766A\n77D0792D7931792F7C547C537CF27E8A7E877E887E8B7E867E8D7F4D7FBB8030\n81DD8618862A8626861F8623861C86198627862E862186208629861E86250000\nF6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8829881D881B88208824881C882B884A896D8969896E896B89FA8B798B788B45\n8B7A8B7B8D108D148DAF8E8E8E8C8F5E8F5B8F5D91469144914591B9943F943B\n94369429943D943C94309439942A9437942C9440943195E595E495E39735973A\n97BF97E1986498C998C698C0995899569A399A3D9A469A449A429A419A3A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009A3F9ACD9B159B179B189B169B3A9B529C2B9C1D9C1C9C2C9C239C289C29\n9C249C219DB79DB69DBC9DC19DC79DCA9DCF9DBE9DC59DC39DBB9DB59DCE9DB9\n9DBA9DAC9DC89DB19DAD9DCC9DB39DCD9DB29E7A9E9C9EEB9EEE9EED9F1B9F18\n9F1A9F319F4E9F659F649F924EB956C656C556CB59715B4B5B4C5DD55DD15EF2\n65216520652665226B0B6B086B096C0D7055705670577052721E721F72A9737F\n74D874D574D974D7766D76AD793579B47A707A717C577C5C7C597C5B7C5A0000\nF7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7CF47CF17E917F4F7F8781DE826B863486358633862C86328636882C88288826\n882A8825897189BF89BE89FB8B7E8B848B828B868B858B7F8D158E958E948E9A\n8E928E908E968E978F608F629147944C9450944A944B944F9447944594489449\n9446973F97E3986A986998CB9954995B9A4E9A539A549A4C9A4F9A489A4A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009A499A529A509AD09B199B2B9B3B9B569B559C469C489C3F9C449C399C33\n9C419C3C9C379C349C329C3D9C369DDB9DD29DDE9DDA9DCB9DD09DDC9DD19DDF\n9DE99DD99DD89DD69DF59DD59DDD9EB69EF09F359F339F329F429F6B9F959FA2\n513D529958E858E759725B4D5DD8882F5F4F62016203620465296525659666EB\n6B116B126B0F6BCA705B705A7222738273817383767077D47C677C667E95826C\n863A86408639863C8631863B863E88308832882E883389768974897389FE0000\nF8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8B8C8B8E8B8B8B888C458D198E988F648F6391BC94629455945D9457945E97C4\n97C598009A569A599B1E9B1F9B209C529C589C509C4A9C4D9C4B9C559C599C4C\n9C4E9DFB9DF79DEF9DE39DEB9DF89DE49DF69DE19DEE9DE69DF29DF09DE29DEC\n9DF49DF39DE89DED9EC29ED09EF29EF39F069F1C9F389F379F369F439F4F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009F719F709F6E9F6F56D356CD5B4E5C6D652D66ED66EE6B13705F7061705D\n7060722374DB74E577D5793879B779B67C6A7E977F89826D8643883888378835\n884B8B948B958E9E8E9F8EA08E9D91BE91BD91C2946B9468946996E597469743\n974797C797E59A5E9AD59B599C639C679C669C629C5E9C609E029DFE9E079E03\n9E069E059E009E019E099DFF9DFD9E049EA09F1E9F469F749F759F7656D4652E\n65B86B186B196B176B1A7062722672AA77D877D979397C697C6B7CF67E9A0000\nF9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7E987E9B7E9981E081E18646864786488979897A897C897B89FF8B988B998EA5\n8EA48EA3946E946D946F9471947397499872995F9C689C6E9C6D9E0B9E0D9E10\n9E0F9E129E119EA19EF59F099F479F789F7B9F7A9F79571E70667C6F883C8DB2\n8EA691C394749478947694759A609C749C739C719C759E149E139EF69F0A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009FA4706870657CF7866A883E883D883F8B9E8C9C8EA98EC9974B98739874\n98CC996199AB9A649A669A679B249E159E179F4862076B1E7227864C8EA89482\n948094819A699A689B2E9E197229864B8B9F94839C799EB776759A6B9C7A9E1D\n7069706A9EA49F7E9F499F980000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n",
		"/encoding/cns11643.enc":                   "# Encoding file: cns11643, double-byte\nD\n2134 0 93\n21\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004E284E364E3F4E854E054E04518251965338536953B64E2A4E874E4951E2\n4E464E8F4EBC4EBE516651E35204529C53B95902590A5B805DDB5E7A5E7F5EF4\n5F505F515F61961D4E3C4E634E624EA351854EC54ECF4ECE4ECC518451865722\n572351E45205529E529D52FD5300533A5C735346535D538653B7620953CC6C15\n53CE57216C3F5E005F0C623762386534653565E04F0E738D4E974EE04F144EF1\n4EE74EF74EE64F1D4F024F054F2256D8518B518C519951E55213520B52A60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n22\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000053225304530353075407531E535F536D538953BA53D0598053F653F753F9\n597E53F4597F5B565724590459185932593059345DDF59755E845B825BF95C14\n5FD55FD45FCF625C625E626462615E815E835F0D5F52625A5FCA5FC7623965EE\n624F65E7672F6B7A6C39673F673C6C376C446C45738C75927676909390926C4B\n6C4C4E214E204E224E684E894E984EF94EEF7F5182784EF84F064F034EFC4EEE\n4F1690994F284F1C4F074F1A4EFA4F17514A962351724F3B51B451B351B20000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n23\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004F6451E84F675214520F5215521852A84F33534B534F518F5350521C538B\n522153BE52AE53D2541653FF538E540054305405541354155445541956E35735\n57365731573258EE59054E545447593656E756E55741597A574C5986574B5752\n5B865F535C1859985C3D5C78598E59A25990598F5C8059A15E085B925C285C2A\n5C8D5EF55F0E5C8B5C895C925FD35FDA5C935FDB5DE0620F625D625F62676257\n9F505E8D65EB65EA5F7867375FD2673267366B226BCE5FEE6C586C516C770000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n24\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006C3C5FFA6C5A5FF76C53706F7072706E6283628C707372B172B26287738F\n627B627A6270793C6288808D808E6272827B65F08D718FB99096909A67454E24\n4E7167554E9C4F454F4A4F394F37674B4F324F426C1A4F444F4B6C6B4F404F35\n4F3151516C6F5150514E6C6D6C87519D6C9C51B551B851EC522352275226521F\n522B522052B452B372C65325533B537473957397739373947392544D75397594\n543A7681793D5444544C5423541A5432544B5421828F54345449545054220000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n25\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000543F5451545A542F8FC956E956F256F356EF56ED56EC56E6574896285744\n573F573C575357564F85575F5743575857574F744F894F8457464F4C573D4F6A\n57425754575558F158F258F0590B9EA656F1593D4F955994598C519E599C51BE\n5235599F5233599B52315989599A530B658853925B8D54875BFE5BFF5BFD5C2B\n54885C845C8E5C9C5465546C5C855DF55E09546F54615E0B54985E925E905F03\n56F75F1E5F6357725FE75FFE5FE65FDC5FCE57805FFC5FDF5FEC5FF657620000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n26\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005FF25FF05FF95945621359BA59CF623B623C628259C159B659BC6278628B\n59B1629E62A5629B629C6299628D6285629D62755C445C475CAE65F65CA05CB5\n5CAF66F5675B5C9F675467525CA267586744674A67615CB66C7F6C916C9E5E14\n6C6E6C7C6C9F6C755F246C566CA26C795F7D6CA15FE56CAA6CA0601970797077\n707E600A7075707B7264601E72BB72BC72C772B972BE72B66011600C7398601C\n6214623D62AD7593768062BE768376C076C162AE62B377F477F562A97ACC0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n27\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007ACD7CFA809F80918097809466048286828C65FB8295660B866C66058FB5\n8FBE8FC766F68FC190A990A4678E6792677690A896279626962B963396349629\n4E3D679F4E9D4F934F8A677D67814F6D4F8E4FA04FA24FA14F9F4FA36C1D4F72\n6CEC4F8C51566CD96CB651906CAD6CE76CB751ED51FE522F6CC3523C52345239\n52B952B552BF53556C9D5376537A53936D3053C153C253D554856CCF545F5493\n548954799EFE548F5469546D70915494546A548A708356FD56FB56F872D80000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n28\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000056FC56F6576557815763576772D1576E5778577F73A673A258F3594B594C\n74DD74E8753F59AD753E59C4759859C259B076F176F076F577F859BF77F959C9\n59B859AC7942793F79C559B759D77AFB5B607CFD5B965B9E5B945B9F5B9D80B5\n5C005C1982A082C05C495C4A82985CBB5CC182A782AE82BC5CB95C9E5CB45CBA\n5DF65E135E125E7782C35E9882A25E995E9D5EF8866E5EF98FD25F065F218FCD\n5F255F558FD790B290B45F845F8360306007963D6036963A96434FCD5FE90000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n29\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000603D60084FC94FCB62BA62B24FDC62B762E462A74FDB4FC74FD662D562E1\n62DD62A662C162C562C062DF62E062DE53976589539965A665BA54A165FF54A5\n66176618660165FE54AE670C54B6676B67966782678A54BC67A354BE67A2678F\n54B067F967806B266B276B686B69579D6B816BB46BD1578F57996C1C579A5795\n58F4590D59536C976C6C6CDF5A006CEA59DD6CE46CD86CB26CCE6CC859F2708B\n70887090708F59F570877089708D70815BA8708C5CD05CD872405CD75CCB0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n2A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007265726672685CC95CC772CD72D372DB5CD472CF73A773A3739E5CDF73AF\n5DF95E2173AA739C5E2075427544753B75415E9B759B759E5F0779C479C379C6\n6037603979C7607279CA604560537ACF7C767C747CFF7CFC6042605F7F5980A8\n6058606680B0624280B362CF80A480B680A780AC630380A65367820E82C4833E\n829C63006313631462FA631582AA62F082C9654365AA82A682B2662166326635\n8FCC8FD98FCA8FD88FCF90B7661D90AD90B99637670F9641963E96B697510000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n2B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000097634E574E794EB24EB04EAF4EB14FD24FD567E44FBE4FB84FB04FB14FC8\n67F667EE4FC64FCC4FE54FE34FB4516A67B2519F67C651C167CC51C251C35245\n524867C967CA524F67EA67CB52C552CA52C453275358537D6BE053DD53DC53DA\n53D954B96D1F54D054B454CA6D0A54A354DA54A46D1954B2549E549F54B56D1D\n6D4254CD6D1854CC6D03570057AC5791578E578D579257A1579057A657A8709F\n579C579657A770A170B470B570A958F572495909590872705952726E72CA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n2C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000059DF72E859EB59EF59F059D55A0D5A0459F95A0259F859E259D959E75B6A\n73B473EB5BAB73C75C1B5C2F73C6663C73CB74EC74EE5CD15CDC5CE65CE15CCD\n76795CE25CDD5CE55DFB5DFA5E1E76F75EA176FA77E75EFC5EFB5F2F78127805\n5F66780F780E7809605C7813604E6051794B794560236031607C605279D66060\n604A60617AD162187B017C7A7C787C797C7F7C807C81631F631762EA63216304\n63057FBE6531654465408014654265BE80C76629661B80C86623662C661A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n2D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006630663B661E6637663880C9670E80D780E667E867D6822167C767BC6852\n67BF67D567FE836367FB833A67B168016805680067D782F26B2A6B6B82FB82F6\n82F082EA6BE182E082FA6D236CFF6D146D056D136D066D21884E6D156CAF6CF4\n6D026D458A076D268FE36D448FEE6D2470A590BD70A390D570A270BB70A070AA\n90C891D470A870B670B270A79653964A70B9722E5005723C5013726D5030501B\n72E772ED503372EC72E572E24FF773C473BD73CF73C973C173D0503173CE0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n2E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000074ED74EB519374EF754975507546754A5261754D75A6525E525F525575A8\n52CD530E76C776FF54E276FD77E6780A54F37804780B78075504781578085511\n79D379D479D079D77A7C54F854E07A7D7A837A8257017AD47AD57AD37AD07AD2\n7AFE7AFC7C777C7C7C7B57B657BF57C757D057B957C1590E594A7F8F80D35A2D\n80CB80D25A0F810980E280DF80C65B6C822482F782D882DD5C565C5482F882FC\n5CEE5CF182E95D0082EE5E2982D0830E82E2830B82FD517986765F6786780000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n2F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000605A60678675867D6088884288666081898C8A0560958A0660978C9F609C\n8FF18FE78FE98FEF90C290BC632C90C690C06336634390CD90C9634B90C4633C\n958163419CEC50324FF9501D4FFF50044FF05003635150024FFC4FF250245008\n5036502E65C35010503850394FFD50564FFB51A351A651A1681A684951C751C9\n5260526452595265526752575263682B5253682F52CF684452CE52D052D152CC\n68266828682E550D54F46825551354EF54F554F9550255006B6D808255180000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n30\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000054F054F66BE86BE355196BE7570557C96D6357B757CD6D0D6D616D9257BE\n57BB6D6D57DB57C857C457C557D157CA57C06D676D605A215A2A6D7C5A1D6D82\n5A0B6D2F6D686D8B6D7E5A226D846D165A246D7B5A145A316D905A2F5A1A5A12\n70DD70CB5A2670E270D75BBC5BBB5BB75C055C065C525C5370C770DA5CFA5CEB\n72425CF35CF55CE95CEF72FA5E2A5E305E2E5E2C5E2F5EAF5EA973D95EFD5F32\n5F8E5F935F8F604F609973D2607E73D46074604B6073607573E874DE60560000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n31\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000060A9608B60A6755B609360AE609E60A7624575C075BF632E75BA63526330\n635B771B6319631B77126331635D6337633563537722635C633F654B78227835\n658B7828659A66506646664E6640782A664B6648795B66606644664D79526837\n682479EC79E0681B683679EA682C681968566847683E681E7A8B681568226827\n685968586855683068236B2E6B2B6B306B6C7B096B8B7C846BE96BEA6BE56D6B\n7C8D7C856D736D577D117D0E6D5D6D566D8F6D5B6D1C6D9A6D9B6D997F610000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n32\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006D816D717F5D7F5B6D726D5C6D9670C470DB70CC70D070E370DF80F270D6\n70EE70D580FB81008201822F727A833372F573028319835173E273EC73D573F9\n73DF73E683228342834E831B73E473E174F3834D831683248320755675557558\n7557755E75C38353831E75B4834B75B18348865376CB76CC772A86967716770F\n869E8687773F772B770E772486857721771877DD86A7869578247836869D7958\n79598843796279DA79D9887679E179E579E879DB886F79E279F08874887C0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n33\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008A128C477ADA7ADD8CA47ADB7ADC8D788DB57B0D7B0B7B147C8E7C868FF5\n7C877C837C8B90048FFC8FF690D67D2490D990DA90E37D257F627F937F997F97\n90DC90E47FC47FC6800A91D591E28040803C803B80F680FF80EE810481038107\n506A506180F750605053822D505D82278229831F8357505B504A506250158321\n505F506983188358506450465040506E50738684869F869B868986A68692868F\n86A0884F8878887A886E887B88848873555055348A0D8A0B8A19553655350000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n34\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000553055525545550C8FF990099008553990DE9151553B554091DB91DF91DE\n91D691E095859660965957F4965657ED57FD96BD57F8580B5042505958075044\n50665052505450715050507B507C505857E758015079506C507851A851D151CF\n5268527652D45A5553A053C45A385558554C55685A5F55495A6C5A53555D5529\n5A43555455535A44555A5A48553A553F552B57EA5A4C57EF5A695A4757DD57FE\n5A4257DE57E65B6E57E857FF580358F768A6591F5D1A595B595D595E5D0D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n35\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005D265A2B5D0F5A3B5D125D235A615A3A5A6E5A4B5A6B5EB45EB95A455A4E\n5A685A3D5A715A3F5A6F5A7560905A735A2C5A595A545A4F5A6360CF60E45BC8\n60DD5BC360B15C5B5C6160CA5D215D0A5D0960C05D2C5D08638A63825D2A5D15\n639E5D105D1363975D2F5D18636F5DE35E395E355E3A5E32639C636D63AE637C\n5EBB5EBA5F345F39638563816391638D6098655360D066656661665B60D760AA\n666260A160A4688760EE689C60E7686E68AE60DE6956686F637E638B68A90000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n36\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000687563796386639368776373636A686B636C68AA637F687163B263BA6896\n688B6366637468A4655A687B654E654D658D658E65AD6B3365C765CA6B9165C9\n6B8D65E366576C2A66636667671A671967166DAC6DE9689E68B6689868736E00\n689A688E68B768DB68A5686C68C168846DDB6DF46895687A68996DF068B868B9\n68706DCF6B356DD06B906BBB6BED6DD76DCD6DE36DC16DC36DCE70F771176DAD\n6E0470F06DB970F36DE770FC6E086E0671136E0A6DB070F66DF86E0C710E0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n37\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006DB1727B6E026E076E096E016E176DFF6E12730A730871037107710170F5\n70F1710870F2710F740170FE7407740073FA731A7310730E740273F374087564\n73FB75CE75D275CF751B752375617568768F756775D37739772F769077317732\n76D576D776D67730773B7726784877407849771E784A784C782678477850784B\n7851784F78427846796B796E796C79F279F879F179F579F379F97A907B357B3B\n7A9A7A937A917AE17B247B337B217B1C7B167B177B367B1F7B2F7C937C990000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n38\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007C9A7C9C7C947D497C967D347D377D3D7D2D7D367D4C7D457D2C7D487D41\n7D477F3B7D3F7D4A7D3B7D288008801A7F9C801D7F9B8049804580447C9B7FD1\n7FC7812A812E801F801E81318047811A8134811781258119811B831D83718384\n8380837283A18127837983918211839F83AD823A8234832382748385839C83B7\n8658865A8373865786B2838F86AE8395839983758845889C889488A3888F88A5\n88A988A6888A88A0889089928991899483B08A268A328A2883AE83768A1C0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n39\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000086568A2B8A2086C28A2986C586BA86B08A218C3A86B38C5B8C588C7C86BB\n8CA68CAE8CAD8D6588528D7E88958D7C8D7F8D7A8DBD889188A18DC08DBB8EAD\n8EAF8ED6889788A488AC888C88938ED9898289D69012900E90258A27901390EE\n8C3990AB90F78C5D9159915491F291F091E591F68DC28DB995878DC1965A8EDE\n8EDD966E8ED78EE08EE19679900B98E198E6900C9EC49ED24E8090F04E81508F\n50975088508990EC90E950815160915A91535E4251D391F491F151D251D60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n3A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000527391F9527091EB91F791E853A853A653C5559755DE966D966B559655B4\n96BF55859804559B55A0509B555950945586508B50A355AF557A508E509D5068\n559E509255A9570F570E581A5312581F53A4583C5818583E582655AD583A5645\n5822559358FB5963596455815AA85AA35A825A885AA15A855A9855955A99558E\n5A895A815A965A80581E58275A91582857F5584858255ACF581B5833583F5836\n582E58395A875AA0582C5A7959615A865AAB5AAA5AA45A8D5A7E5A785BD50000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n3B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005A7C5AA55AAC5C1E5C5F5C5E5D445D3E5A975D485D1C5AA95D5B5D4D5A8C\n5A9C5D575A935D535D4F5BCD5D3B5D465BD15BCA5E465E475C305E485EC05EBD\n5EBF5D4B5F115D355F3E5F3B5D555F3A5D3A5D525D3D5FA75D5960EA5D396107\n6122610C5D325D3660B360D660D25E4160E360E560E95FAB60C9611160FD60E2\n60CE611E61206121621E611663E263DE63E660F860FC60FE60C163F8611863FE\n63C163BF63F763D1655F6560656163B063CE65D163E863EF667D666B667F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n3C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000063CA63E066736681666D6669646163DF671E68ED63DC63C463D863D36903\n63C768FE68E5691E690263D763D9690968CA690065646901691868E268CF659D\n692E68C568FF65D2691C68C3667B6B6F66716B6E666A6BBE67016BF46C2D6904\n6DB66E756E1E68EA6E18690F6E4868F76E4F68E46E426E6A6E706DFE68E16907\n6E6D69086E7B6E7E6E5968EF6E5769146E806E5068FD6E296E766E2A6E4C712A\n68CE7135712C7137711D68F468D1713868D47134712B7133712771246B3B0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n3D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000712D7232728372827287730673247338732A732C732B6DFC732F73287417\n6E496E88741974386E45741F7414743C73F7741C74157418743974F975246E51\n6E3B6E03756E756D7571758E6E6175E56E286E606E716E6B769476B36E3076D9\n6E657748774977436E776E55774277DF6E66786378766E5A785F786679667971\n712E713179767984797579FF7A0771287A0E7A09724B725A7288728972867285\n7AE77AE27B55733073227B437B577B6C7B427B5373267B417335730C7CA70000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n3E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007CA07CA67CA47D74741A7D59742D7D607D577D6C7D7E7D6474207D5A7D5D\n752F756F756C7D767D4D7D7575E67FD37FD675E475D78060804E8145813B7747\n814881428149814081148141774C81EF81F68203786483ED785C83DA841883D2\n8408787084007868785E786284178346841483D38405841F8402841683CD83E6\n7AE6865D86D586E17B447B487B4C7B4E86EE884788467CA27C9E88BB7CA188BF\n88B47D6388B57D56899A8A437D4F7D6D8A5A7D6B7D527D548A358A388A420000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n3F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008A498A5D8A4B8A3D7F667FA27FA07FA18C608C5E8C7F8C7E8C8380D48CB1\n8D878152814F8D888D83814D813A8D868D8B8D828DCA8DD28204823C8DD48DC9\n8EB0833B83CF83F98EF28EE48EF38EEA83E78EFD83FC8F9D902B902A83C89028\n9029902C840183DD903A90309037903B83CB910A83D683F583C991FE922083DE\n920B84069218922283D5921B920883D1920E9213839A83C3959583EE83C483FB\n968C967B967F968183FE968286E286E686D386E386DA96EE96ED86EB96EC0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n40\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000975F976F86D7976D86D188488856885588BA88D798F088B888C088BE9AA9\n88BC88B79AE04EB7890188C950CC50BC899750AA50B989DB50AB50C350CD517E\n527E52798A588A4452E152E052E7538053AB53AA53A953E055EA8C8055D78CBE\n8CB055C157158D84586C8D89585C58505861586A5869585658605866585F5923\n596659688EEF8EF75ACE8EF95AC55AC38EE58EF55AD08EE88EF68EEB8EF18EEC\n8EF45B745B765BDC5BD75BDA5BDB91045C205D6D5D6690F95D645D6E91000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n41\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005D605F425F5A5F6E9164915F6130613A612A614361196131921A613D920F\n920C92006408643264389206643192276419921C6411921992176429641D957B\n958D958C643C96876446644796899683643A640796C8656B96F16570656D9770\n65E4669398A998EB9CE69EF9668F4E844EB6669250BF668E50AE694650CA50B4\n50C850C250B050C150BA693150CB50C9693E50B8697C694352786973527C6955\n55DB55CC6985694D69506947696769366964696155BF697D6B446B406B710000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n42\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006B736B9C55C855F255CD6BC155C26BFA6C316C325864584F6EB86EA8586F\n6E916EBB585D6E9A5865585B6EA9586358716EB56E6C6EE85ACB6EDD6EDA6EE6\n6EAC5AB05ABF5AC86ED96EE36EE96EDB5ACA716F5AB65ACD71485A90714A716B\n5BD9714F715771745D635D4A5D6571457151716D5D6872517250724E5E4F7341\n5E4A732E73465EC574275EC674487453743D5FAF745D74566149741E74477443\n74587449612E744C7445743E61297501751E91686223757A75EE760276970000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n43\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007698641064126409775D77647753775878827890788A6439787A787D6423\n788B787864306428788D788878927881797E798364256427640B7980641B642E\n64217A0F656F65927A1D66867AA17AA466907AE97AEA66997B627B6B67207B5E\n695F7B79694E69627B6F7B686945696A7CAE6942695769597CB069487D906935\n7D8A69337D8B7D997D9569787D877D787D977D897D986976695869417FA3694C\n693B694B7FDD8057694F8163816A816C692F697B693C815D81756B43815F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n44\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006B48817D816D6BFB6BFC8241844F84846E9B847F6EC88448842A847B8472\n8464842E845C84536EC6844184C86EC184628480843E848384716EA6844A8455\n84586EC36EDC6ED886FC86FD87156E8D871686FF6EBF6EB36ED0885888CF88E0\n6EA371477154715289E78A6A8A80715D8A6F8A6571788A788A7D8A8871587143\n8A648A7E715F8A678C638C88714D8CCD724F8CC9728C8DED7290728E733C7342\n733B733A73408EB1734974448F048F9E8FA090439046904890459040904C0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n45\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000074427446910C9113911574FF916B9167925D9255923569839259922F923C\n928F925C926A9262925F926B926E923B92449241959A7699959976DD7755775F\n968F77529696775A7769776796F496FC776D9755788797797894788F788497EE\n97F57886980B788398F37899788098F798FF98F5798298EC98F17A117A18999A\n7A129AE29B3D9B5D9CE87A1B9CEB9CEF9CEE9E819F1450D050D950DC50D87B69\n50E150EB7B737B7150F450E250DE7B767B637CB251F47CAF7D887D8652ED0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n46\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000052EA7D7F53327D7A53AE53B07D8355FB5603560B7D8456077D9255F87F6B\n5628561E7F6C5618561156515605571758928164588C817758785884587358AD\n58975895587758725896588D59108161596C82495AE782405AE4824584F15AEF\n5626847684795AF05D7B84655D83844084865D8B5D8C844D5D785E5284598474\n5ED05ECF85075FB35FB4843A8434847A617B8478616F6181613C614261386133\n844261606169617D6186622C62288452644C84C56457647C8447843664550000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n47\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000064626471646A6456643B6481846E644F647E646486F7870C86FA86D686F5\n657186F8870E66A5669A669C870D66A688D666A4698F69C569C8699269B288CC\n88D0898569E369C069D669D1699F69A269D289DC89E68A7669E169D5699D8A3F\n8A7769988A846B746BA18A816EF06EF38C3C8C4B6F1B6F0C6F1D6F346F286F17\n8C856F446F426F046F116EFA6F4A7191718E8D93718B718D717F718C717E717C\n71838DEE71888DE98DE372948DE773557353734F7354746C7465746674610000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n48\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000746B746874768F0B7460903F74747506760E91107607910F911176B99114\n76B776E2916E7774777777767775923A777877719265777A715B777B78A678AE\n78B8926C924F926078B178AF923679897987923192547A2992507A2A924E7A2D\n7A2C92567A32959F7AEC7AF07B817B9E7B8396917B9296CE7BA37B9F7B9396F5\n7B867CB87CB79772980F980D980E98AC7DC87DB699AF7DD199B07DA87DAB9AAB\n7DB37DCD9CED7DCF7DA49EFD50E67F417F6F7F7150F350DB50EA50DD50E40000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n49\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000050D38023805B50EF8061805F818152805281818482135330824A824C5615\n560C561284BD8495561C849284C35602849684A584B584B384A384E484D884D5\n589884B784AD84DA84938736587A58875891873D872B87478739587B8745871D\n58FE88FF88EA5AEE88F55AD5890088ED890388E95AF35AE289EA5ADB8A9B8A8E\n8AA25AD98A9C8A948A908AA98AAC5C638A9F5D805D7D8A9D5D7A8C675D775D8A\n8CD08CD68CD48D988D9A8D975D7F5E585E598E0B8E088E018EB48EB35EDC0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008FA18FA25ED2905A5F449061905F5FB6612C9125917B9176917C61739289\n92F692B192AD929292819284617A92AE9290929E616A6161615695A295A7622B\n642B644D645B645D96A0969D969F96D0647D96D1646664A6975964829764645C\n644B64539819645098149815981A646B645964656477990665A098F89901669F\n99BE99BC99B799B699C069C999B869CE699669B099C469BC99BF69999ADA9AE4\n9AE99AE89AEA9AE569BF9B2669BD69A49B4069B969CA699A69CF69B369930000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000069AA9EBD699E69D969976990510E69B550F769C650FC510D510151DA51D9\n51DB5286528E52EE533353B16EF15647562D56546F37564B5652563156445656\n5650562B6F18564D5637564F58A258B76F7358B26EEE58AA58B558B06F3C58B4\n58A458A76F0E59265AFE6EFD5B046F395AFC6EFC5B065B0A5AFA5B0D5B005B0E\n7187719071895D9171855D8F5D905D985DA45D9B5DA35D965DE45E5A72957293\n5E5E734D5FB86157615C61A661956188747261A3618F75006164750361590000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006178761661856187619E7611760A6198619C7781777C622F6480649B648E\n648D649464C678B264A8648378AD64B9648664B464AF649178A064AA64A164A7\n66B666B3798B66BC66AC799466AD6A0E79886A1C6A1A7A2B7A4A6A0B7A2F69EF\n6A0C69F06A227AAC69D87B886A1269FA7B916A2A7B966A107B8C7B9B6A2969F9\n69EA6A2C6A247BA469E96B526B4F6B537CBA7DA76F106F656F757DAA7DC17DC0\n7DC56FD07DCE6F5C6F3D6F717DCC6F916F0B6F796F816F8F7DA66F596F740000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007DA171AE7F7371A371AD7FE57FDE71AB71A671A2818952F2725772557299\n734B747A8215849784A4748C748484BA84CE74827493747B84AB750984B484C1\n84CD84AA849A84B1778A849D779084BB78C678D378C078D278C778C284AF799F\n799D799E84B67A4184A07A387A3A7A4284DB84B07A3E7AB07BAE7BB38728876B\n7BBF872E871E7BCD87197BB28743872C8741873E8746872087327CC47CCD7CC2\n7CC67CC37CC97CC787427DF887277DED7DE2871A873087117DDC7E027E010000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000088F27DD688FE7DE47DFE88F67E007DFC7DFD88EB7DF57DFF899F7DEB7DE5\n7F787FAE7FE78A998065806A80668068806B819481A18192819681938D968E09\n85018DFF84F88DFD84F58E0385048E068E058DFE8E00851B85038533853484ED\n9123911C853591228505911D911A91249121877D917A91729179877192A5885C\n88E6890F891B92A089A989A589EE8AB1929A8ACC8ACE92978AB792A38AB58AE9\n8AB492958AB38AC18AAF8ACA8AD09286928C92998C8E927E92878CE98CDB0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000928B8CEB8DA496A18DA28D9D977D977A977E97838E2A8E28977B97848EB8\n8EB68EB98EB78F228F2B8F278F198FA499078FB3999C9071906A99BB99BA9188\n918C92BF92B892BE92DC92E59B3F9B6092D492D69CF192DA92ED92F392DB5103\n92B992E292EB95AF50F695B295B3510C50FD510A96A396A552F152EF56485642\n970A563597879789978C97EF982A98225640981F563D9919563E99CA99DA563A\n571A58AB99DE99C899E058A39AB69AB558A59AF458FF9B6B9B699B729B630000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n50\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005AF69D0D5AF89D019D0C5B019CF85B055B0F9CFE9D029E845D9F9EAB9EAA\n511D51165DA0512B511E511B5290529453145E605E5C56675EDB567B5EE1565F\n5661618B6183617961B161B061A2618958C358CA58BB58C058C459015B1F5B18\n5B115B1561B35B125B1C64705B225B795DA664975DB35DAB5EEA648A5F5B64A3\n649F61B761CE61B961BD61CF61C06199619765B361BB61D061C4623166B764D3\n64C06A006A066A1769E564DC64D164C869E464D566C369EC69E266BF66C50000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n51\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000069FE66CD66C167066A1467246A636A426A5269E66A436A3369FC6A6C6A57\n6A046A4C6A6E6A0F69F66A266A0769F46A376B516A716A4A6A366BA66A536C00\n6A456A706F416F266A5C6B586B576F926F8D6F896F8C6F626F4F6FBB6F5A6F96\n6FBE6F6C6F826F556FB56FD36F9F6F576FB76FF571B76F0071BB6F6B71D16F67\n71BA6F5371B671CC6F7F6F9571D3749B6F6A6F7B749674A2749D750A750E719A\n7581762C76377636763B71A476A171AA719C779871B37796729A735873520000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n52\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000078D678EB736078DC735B79A579A998347A537A4574897A4F74867ABD7ABB\n7AF17488747C7BEC7BED7507757E7CD3761E7CE1761D7E197623761A76287E27\n7E26769D769E806E81AF778F778981AD78CD81AA821878CC78D178CE78D4856F\n854C78C48542799A855C8570855F79A2855A854B853F878A7AB4878B87A1878E\n7BBE7BAC8799885E885F892489A78AEA8AFD8AF98AE38AE57DDB7DEA8AEC7DD7\n7DE17E037DFA8CF27DF68CEF7DF08DA67DDF7F767FAC8E3B8E437FED8E320000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n53\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008F318F307FE68F2D8F3C8FA78FA5819F819E819591379195918E82169196\n82539345930A824E825192FD9317931C930793319332932C9330930393058527\n95C284FB95B884FA95C1850C84F4852A96AB96B784F784EB97159714851284EA\n970C971784FE9793851D97D2850284FD983698319833983C982E983A84F0983D\n84F998B5992299239920991C991D866299A0876399EF99E899EB877387588754\n99E199E68761875A9AF89AF5876D876A9B839B949B84875D9B8B9B8F877A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n54\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009B8C875C9B89874F9B8E8775876287679D249D0F89059D139D0A890B8917\n891889199D2A9D1A89119D279D169D2189A49E859EAC9EC69EC59ED79F538AB8\n5128512751DF8AD5533553B38ABE568A567D56898AC358CD58D08AD95B2B5B33\n5B295B355B315B375C365DBE8CDD5DB98DA05DBB8DA161E261DB61DD61DC61DA\n8E2E61D98E1B8E1664DF8E198E2664E18E1464EE8E1865B566D466D58E1A66D0\n66D166CE66D78F208F236A7D6A8A90736AA7906F6A996A826A88912B91290000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n55\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006A8691326A986A9D918591866A8F91816AAA91846B5D92D06C0A92C46FD7\n6FD66FE592CF92F192DF6FD96FDA6FEA92DD6FF692EF92C271E392CA71E992CE\n71EB71EF71F371EA92E092DE92E792D192D3737192E174AE92C674B3957C74AC\n95AB95AE75837645764E764476A376A577A677A4978A77A977AF97D097CF981E\n78F078F878F198287A49981B982798B27AC27AF27AF37BFA99167BF67BFC7C18\n7C087C1299D399D47CDB7CDA99D699D899CB7E2C7E4D9AB39AEC7F467FF60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n56\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000802B807481B881C89B679B749B71859285939B75857F85AB85979B6C9CFC\n85AC9CFD9CFF9CF787CE9D0087CD9CFB9D0887C187B187C79ED389409F10893F\n893951178943511151DE533489AB56708B1F8B098B0C566656638C4056728C96\n56778CF68CF758C88E468E4F58BF58BA58C28F3D8F4193669378935D93699374\n937D936E93729373936293489353935F93685DB1937F936B5DB595C45DAE96AF\n96AD96B25DAD5DAF971A971B5E685E665E6F5EE9979B979F5EE85EE55F4B0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n57\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005FBC5FBB619D61A86196984061B4984761C198B761BA61BF61B8618C64D7\n99A264D064CF9A0099F3648964C399F564F364D99ABD9B009B0265A29B349B49\n9B9F66CA9BA39BCD9B999B9D66BA66CC9D396A349D446A496A679D356A686A3E\n9EAF6A6D512F6A5B6A519F8E6A5A569F569B569E5696569456A06A4F5B3B6A6F\n6A695B3A5DC15F4D5F5D61F36A4D6A4E6A466B5564F664E564EA64E765056BC8\n64F96C046C036C066AAB6AED6AB26AB06AB56ABE6AC16AC86FC46AC06ABC0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n58\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006AB16AC46ABF6FA56FAE700870036FFD7010700270136FA271FA720074B9\n74BC6FB2765B7651764F76EB77B871D677B977C177C077BE790B71C77907790A\n790871BC790D7906791579AF729E736973667AF5736C73657C2E736A7C1B749A\n7C1A7C24749274957CE67CE37580762F7E5D7E4F7E667E5B7F477FB476327630\n76BB7FFA802E779D77A181CE779B77A282197795779985CC85B278E985BB85C1\n78DE78E378DB87E987EE87F087D6880E87DA8948894A894E894D89B189B00000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n59\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000089B37AB78B388B327BE78B2D7BD58B347BDA8B298C747BD47BEA8D037BDC\n7BEB8DA98E587CD27CD48EBF8EC18F4A8FAC7E219089913D913C91A993A07E0E\n93907E159393938B93AD93BB93B87E0D7E14939C95D895D77F7B7F7C7F7A975D\n97A997DA8029806C81B181A6985481B99855984B81B0983F98B981B281B781A7\n81F29938993699408556993B993999A4855385619A089A0C85469A1085419B07\n85449BD285479BC29BBB9BCC9BCB854E856E9D4D9D639D4E85609D509D550000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000855D9D5E85659E909EB29EB186649ECA9F029F279F26879356AF58E058DC\n87965B39877987875B7C5BF3879087915C6B5DC4650B6508650A8789891E65DC\n8930892D66E166DF6ACE6AD46AE36AD76AE2892C891F89F18AE06AD86AD56AD2\n8AF58ADD701E702C70256FF37204720872158AE874C474C974C774C876A977C6\n77C57918791A79208CF37A667A647A6A8DA78E338E3E8E388E408E457C357C34\n8E3D8E417E6C8E3F7E6E7E718F2E81D481D6821A82628265827685DB85D60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000908685E79133913585F4919387FD87D58807918F880F87F89308931F8987\n930F89B589F5933C8B3F8B438B4C93018D0B8E6B8E688E708E758E7792FA8EC3\n92F993E993EA93CB93C593C6932993ED93D3932A93E5930C930B93DB93EB93E0\n93C1931695BC95DD95BE95B995BA95B695BF95B595BD96A996D497B297B497B1\n97B597F2979497F097F89856982F98329924994499279A269A1F9A189A219A17\n99E49B0999E399EA9BC59BDF9AB99BE39AB49BE99BEE9AFA9AF99D669D7A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009B809D6E9D919D839D769D7E9D6D9B939E959EE39B7A9B959F039F049D25\n9F179D2051369D1453369D1D5B429D229D105B445B465B7E5DCA5DC85DCC5EF0\n9ED5658566E566E79F3D512651256AF451246AE9512952F45693568C568D703D\n56847036567E7216567F7212720F72177211720B5B2D5B2574CD74D074CC74CE\n74D15B2F75895B7B7A6F7C4B7C445E6C5E6A5FBE61C361B57E7F8B7161E0802F\n807A807B807C64EF64E964E385FC861086026581658085EE860366D2860D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000086138608860F881888126A9B6AA18967896589BB8B698B626A838B6E6AA4\n8B616A7F8B648B4D8C516A8C6A928E838EC66C09941F6FA99404941794089405\n6FED93F3941E9402941A941B9427941C71E196B571E871F2973371F097349731\n97B897BA749797FC74AB749098C374AD994D74A59A2F7510751175129AC97584\n9AC89AC49B2A9B389B5076E99C0A9BFB9C049BFC9BFE77B477B177A89C029BF6\n9C1B9BF99C159C109BFF9C009C0C78F978FE9D959DA579A87A5C7A5B7A560000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009E989EC17A5A9F5A516456BB7C0558E65B495BF77BFF7BFB5DD07BF45FC2\n7BF365117C096AFF6AFE6AFD7BFD6B017BF07BF1704B704D704774D376687667\n7E33984877D179307932792E7E479F9D7AC97AC87E3B7C567C517E3A7F457F7F\n7E857E897E8E7E84802C826A862B862F862881C586168615861D881A825A825C\n858389BC8B758B7C85958D118D128F5C91BB85A493F4859E8577942D858985A1\n96E497379736976797BE97BD97E29868986698C898CA98C798DC8585994F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000099A99A3C85909A3B9ACE87BE9B149B5387C59C2E87AC9C1F87B587BC87AE\n87C99DB09DBD87CC87B79DAE9DC49E7B87B487B69E9E87B89F0587DE9F699FA1\n56C7571D5B4A5DD389525F72620289AD62356527651E651F8B1E8B186B076B06\n8B058B0B7054721C72207AF88B077C5D7C588B067E927F4E8B1A8C4F8C708827\n8C718B818B838C948C448D6F8E4E8E4D8E539442944D9454944E8F409443907E\n9138973C974097C09199919F91A1919D995A9A5193839ADD936493569C380000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n60\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000937C9C459C3A93769C359350935193609EF1938F9F93529A937993578641\n5DD7934F65289377937B936170537059936772219359766F793779B57C627C5E\n7CF596AE96B0863D9720882D89898B8D8B878B908D1A8E99979E979D97D5945F\n97F1984194569461945B945A945C9465992B9741992A9933986E986C986D9931\n99AA9A5C9A589ADE9A029C4F9C5199F79C5399F899F699FB9DFC9F3999FC513E\n9ABE56D29AFD5B4F6B149B487A727A739B9E9B9B9BA68B919BA59BA491BF0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n61\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009BA2946C9BAF9D3396E697459D3697C897E4995D9D389B219D459B2C9B57\n9D3E9D379C5D9C619C659E089E8A9E899E8D9EB09EC89F459EFB9EFF620566EF\n6B1B6B1D722572247C6D512E8642864956978978898A8B9759708C9B8D1C5C6A\n8EA25E6D5E6E61D861DF61ED61EE61F161EA9C6C61EB9C6F61E99E0E65049F08\n9F1D9FA3650364FC5F606B1C66DA66DB66D87CF36AB98B9B8EA791C46ABA947A\n6AB76AC79A619A639AD79C766C0B9FA5700C7067700172AB864A897D8B9D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n62\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008C538F65947B6FFC98CD98DD72019B309E16720371FD737674B874C096E7\n9E189EA274B69F7C74C27E9E9484765C9E1C76597C7197CA7657765A76A69EA3\n76EC9C7B9F97790C7913975079097910791257275C1379AC7A5F7C1C7C297C19\n7C205FC87C2D7C1D7C267C287C2267657C307E5C52BD7E565B667E5865F96788\n6CE66CCB7E574FBD5F8D7FB36018604880756B2970A681D07706825E85B485C6\n5A105CFC5CFE85B385B585BD85C785C485BF70C985CE85C885C585B185B60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n63\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000085D28624957985B796BA866987E787E687E287DB87EB87EA7B29812887F3\n8A2E87D487DC87D39AD987D8582B584587D963FA87F487E887DD6E86894B894F\n894C89468950586789495BDD656E8B238B338B308C878B4750D250DF8B3E8B31\n8B258B3769BA8B366B9D8B2480598B3D8B3A8C428C758C998C988C978CFE8D04\n8D028D008E5C6F8A8E608E577BC37BC28E658E678E5B8E5A90F68E5D98238E54\n8F468F478F488F4B71CD7499913B913E91A891A591A7984291AA93B5938C0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n64\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000093927F84939B939D938993A7938E8D0E939E9861939593888B73939F9C27\n938D945877D69B2D93A493A893B493A395D295D395D196B396D796DA5DC296DF\n96D896DD97239722972597AC97AE97A84F664F684FE7503F97A550A6510F523E\n53245365539B517F54CB55735571556B55F456225620569256BA569156B05759\n578A580F581258135847589B5900594D5AD15AD35B675C575C775CD55D755D8E\n5DA55DB65DBF5E655ECD5EED5F945F9A5FBA6125615062A36360636463B60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n65\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000640364B6651A7A255C2166E2670267A467AC68106806685E685A692C6929\n6A2D6A776A7A6ACA6AE66AF56B0D6B0E6BDC6BDD6BF66C1E6C636DA56E0F6E8A\n6E846E8B6E7C6F4C6F486F496F9D6F996FF8702E702D705C79CC70BF70EA70E5\n71117112713F7139713B713D71777175717671717196719371B471DD71DE720E\n591172187347734873EF7412743B74A4748D74B47673767776BC7819781B783D\n78537854785878B778D878EE7922794D7986799979A379BC7AA77B377B590000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n66\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007BD07C2F7C327C427C4E7C687CA97CED7DD07E077DD37E647F40791E8041\n806380BB6711672582488310836283128421841E84E284DE84E1857385D485F5\n863786458672874A87A987A587F5883488508887895489848B038C528CD88D0C\n8D188DB08EBC8ED58FAA909C85E8915C922B9221927392F492F5933F93429386\n93BE93BC93BD93F193F293EF94229423942494679466959795CE95E7973B974D\n98E499429B1D9B9889629D4964495E715E8561D3990E8002781E898889B70000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n67\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005528557255BA55F055EE56B856B956C4805392B08B558B518B428B528B57\n8C438C778C768C9A8D068D078D098DAC8DAA8DAD8DAB8E6D8E788E738E6A8E6F\n8E7B8EC28F528F518F4F8F508F538FB49140913F91B091AD93DE93C793CF93C2\n93DA93D093F993EC93CC93D993A993E693CA93D493EE93E393D593C493CE93C0\n93D293A593E7957D95DA95DB96E19729972B972C9728972697B397B797B697DD\n97DE97DF985C9859985D985798BF98BD98BB98BE99489947994399A699A70000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n68\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009A1A9A159A259A1D9A249A1B9A229A209A279A239A1E9A1C9A149AC29B0B\n9B0A9B0E9B0C9B379BEA9BEB9BE09BDE9BE49BE69BE29BF09BD49BD79BEC9BDC\n9BD99BE59BD59BE19BDA9D779D819D8A9D849D889D719D809D789D869D8B9D8C\n9D7D9D6B9D749D759D709D699D859D739D7B9D829D6F9D799D7F9D879D689E94\n9E919EC09EFC9F2D9F409F419F4D9F569F579F58533756B256B556B358E35B45\n5DC65DC75EEE5EEF5FC05FC161F9651765166515651365DF66E866E366E40000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n69\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006AF36AF06AEA6AE86AF96AF16AEE6AEF703C7035702F7037703470317042\n7038703F703A7039702A7040703B703370417213721472A8737D737C74BA76AB\n76AA76BE76ED77CC77CE77CF77CD77F279257923792779287924792979B27A6E\n7A6C7A6D7AF77C497C487C4A7C477C457CEE7E7B7E7E7E817E807FBA7FFF8079\n81DB81D982688269862285FF860185FE861B860085F6860486098605860C85FD\n8819881088118817881388168963896689B989F78B608B6A8B5D8B688B630000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008B658B678B6D8DAE8E868E888E848F598F568F578F558F588F5A908D9143\n914191B791B591B291B3940B941393FB9420940F941493FE9415941094289419\n940D93F5940093F79407940E9416941293FA940993F8943C940A93FF93FC940C\n93F69411940695DE95E095DF972E972F97B997BB97FD97FE986098629863985F\n98C198C29950994E9959994C994B99539A329A349A319A2C9A2A9A369A299A2E\n9A389A2D9AC79ACA9AC69B109B129B119C0B9C089BF79C059C129BF89C400000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009C079C0E9C069C179C149C099D9F9D999DA49D9D9D929D989D909D9B9DA0\n9D949D9C9DAA9D979DA19D9A9DA29DA89D9E9DA39DBF9DA99D969DA69DA79E99\n9E9B9E9A9EE59EE49EE79EE69F309F2E9F5B9F609F5E9F5D9F599F91513A5139\n5298529756C356BD56BE5B485B475DCB5DCF5EF161FD651B6B026AFC6B036AF8\n6B0070437044704A7048704970457046721D721A7219737E7517766A77D0792D\n7931792F7C547C537CF27E8A7E877E887E8B7E867E8D7F4D7FBB803081DD0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008618862A8626861F8623861C86198627862E862186208629861E86258829\n881D881B88208824881C882B884A896D8969896E896B89FA8B798B788B458B7A\n8B7B8D108D148DAF8E8E8E8C8F5E8F5B8F5D91469144914591B9943F943B9436\n9429943D94309439942A9437942C9440943195E595E495E39735973A97BF97E1\n986498C998C698C0995899569A399A3D9A469A449A429A419A3A9A3F9ACD9B15\n9B179B189B169B3A9B529C2B9C1D9C1C9C2C9C239C289C299C249C219DB70000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009DB69DBC9DC19DC79DCA9DCF9DBE9DC59DC39DBB9DB59DCE9DB99DBA9DAC\n9DC89DB19DAD9DCC9DB39DCD9DB29E7A9E9C9EEB9EEE9EED9F1B9F189F1A9F31\n9F4E9F659F649F924EB956C656C556CB59715B4B5B4C5DD55DD15EF265216520\n652665226B0B6B086B096C0D7055705670577052721E721F72A9737F74D874D5\n74D974D7766D76AD793579B47A707A717C577C5C7C597C5B7C5A7CF47CF17E91\n7F4F7F8781DE826B863486358633862C86328636882C88288826882A88250000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000897189BF89BE89FB8B7E8B848B828B868B858B7F8D158E958E948E9A8E92\n8E908E968E978F608F629147944C9450944A944B944F94479445944894499446\n973F97E3986A986998CB9954995B9A4E9A539A549A4C9A4F9A489A4A9A499A52\n9A509AD09B199B2B9B3B9B569B559C469C489C3F9C449C399C339C419C3C9C37\n9C349C329C3D9C369DDB9DD29DDE9DDA9DCB9DD09DDC9DD19DDF9DE99DD99DD8\n9DD69DF59DD59DDD9EB69EF09F359F339F329F429F6B9F959FA2513D52990000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000058E858E759725B4D5DD8882F5F4F62016203620465296525659666EB6B11\n6B126B0F6BCA705B705A7222738273817383767077D47C677C667E95826C863A\n86408639863C8631863B863E88308832882E883389768974897389FE8B8C8B8E\n8B8B8B888C458D198E988F648F6391BC94629455945D9457945E97C497C59800\n9A569A599B1E9B1F9B209C529C589C509C4A9C4D9C4B9C559C599C4C9C4E9DFB\n9DF79DEF9DE39DEB9DF89DE49DF69DE19DEE9DE69DF29DF09DE29DEC9DF40000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n70\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009DF39DE89DED9EC29ED09EF29EF39F069F1C9F389F379F369F439F4F9F71\n9F709F6E9F6F56D356CD5B4E5C6D652D66ED66EE6B13705F7061705D70607223\n74DB74E577D5793879B779B67C6A7E977F89826D8643883888378835884B8B94\n8B958E9E8E9F8EA08E9D91BE91BD91C2946B9468946996E597469743974797C7\n97E59A5E9AD59B599C639C679C669C629C5E9C609E029DFE9E079E039E069E05\n9E009E019E099DFF9DFD9E049EA09F1E9F469F749F759F7656D4652E65B80000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n71\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006B186B196B176B1A7062722672AA77D877D979397C697C6B7CF67E9A7E98\n7E9B7E9981E081E18646864786488979897A897C897B89FF8B988B998EA58EA4\n8EA3946E946D946F9471947397499872995F9C689C6E9C6D9E0B9E0D9E109E0F\n9E129E119EA19EF59F099F479F789F7B9F7A9F79571E70667C6F883C8DB28EA6\n91C394749478947694759A609B2E9C749C739C719C759E149E139EF69F0A9FA4\n706870657CF7866A883E883D883F8B9E8C9C8EA98EC9974B9873987498CC0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n72\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000996199AB9A649A669A679B249E159E179F4862076B1E7227864C8EA89482\n948094819A699A689E19864B8B9F94839C799EB776759A6B9C7A9E1D7069706A\n72299EA49F7E9F499F988AF68AFC8C6B8C6D8C938CF48E448E318E348E428E39\n8E358F3B8F2F8F388F338FA88FA69075907490789072907C907A913491929320\n933692F89333932F932292FC932B9304931A9310932693219315932E931995BB\n96A796A896AA96D5970E97119716970D9713970F975B975C9766979898300000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n73\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009838983B9837982D9839982499109928991E991B9921991A99ED99E299F1\n9AB89ABC9AFB9AED9B289B919D159D239D269D289D129D1B9ED89ED49F8D9F9C\n512A511F5121513252F5568E5680569056855687568F58D558D358D158CE5B30\n5B2A5B245B7A5C375C685DBC5DBA5DBD5DB85E6B5F4C5FBD61C961C261C761E6\n61CB6232623464CE64CA64D864E064F064E664EC64F164E264ED6582658366D9\n66D66A806A946A846AA26A9C6ADB6AA36A7E6A976A906AA06B5C6BAE6BDA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n74\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006C086FD86FF16FDF6FE06FDB6FE46FEB6FEF6F806FEC6FE16FE96FD56FEE\n6FF071E771DF71EE71E671E571ED71EC71F471E0723572467370737274A974B0\n74A674A876467642764C76EA77B377AA77B077AC77A777AD77EF78F778FA78F4\n78EF790179A779AA7A577ABF7C077C0D7BFE7BF77C0C7BE07CE07CDC7CDE7CE2\n7CDF7CD97CDD7E2E7E3E7E467E377E327E437E2B7E3D7E317E457E417E347E39\n7E487E357E3F7E2F7F447FF37FFC807180728070806F807381C681C381BA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n75\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000081C281C081BF81BD81C981BE81E88209827185AA8584857E859C85918594\n85AF859B858785A8858A85A6866787C087D187B387D287C687AB87BB87BA87C8\n87CB893B893689448938893D89AC8B0E8B178B198B1B8B0A8B208B1D8B048B10\n8C418C3F8C738CFA8CFD8CFC8CF88CFB8DA88E498E4B8E488E4A8F448F3E8F42\n8F458F3F907F907D9084908190829080913991A3919E919C934D938293289375\n934A9365934B9318937E936C935B9370935A935495CA95CB95CC95C895C60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n76\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000096B196B896D6971C971E97A097D3984698B699359A0199FF9BAE9BAB9BAA\n9BAD9D3B9D3F9E8B9ECF9EDE9EDC9EDD9EDB9F3E9F4B53E2569556AE58D958D8\n5B385F5E61E3623364F464F264FE650664FA64FB64F765B766DC67266AB36AAC\n6AC36ABB6AB86AC26AAE6AAF6B5F6B786BAF7009700B6FFE70066FFA7011700F\n71FB71FC71FE71F87377737574A774BF751576567658765277BD77BF77BB77BC\n790E79AE7A617A627A607AC47AC57C2B7C277C2A7C1E7C237C217CE77E540000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n77\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007E557E5E7E5A7E617E527E597F487FF97FFB8077807681CD81CF820A85CF\n85A985CD85D085C985B085BA85B987EF87EC87F287E0898689B289F48B288B39\n8B2C8B2B8C508D058E598E638E668E648E5F8E558EC08F498F4D908790839088\n91AB91AC91D09394938A939693A293B393AE93AC93B09398939A939795D495D6\n95D095D596E296DC96D996DB96DE972497A397A697AD97F9984D984F984C984E\n985398BA993E993F993D992E99A59A0E9AC19B039B069B4F9B4E9B4D9BCA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n78\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009BC99BFD9BC89BC09D519D5D9D609EE09F159F2C513356A556A858DE58DF\n58E25BF59F905EEC61F261F761F661F56500650F66E066DD6AE56ADD6ADA6AD3\n701B701F7028701A701D701570187206720D725872A27378737A74BD74CA74E3\n75877586765F766177C7791979B17A6B7A697C3E7C3F7C387C3D7C377C407E6B\n7E6D7E797E697E6A7E737F857FB67FB97FB881D885E985DD85EA85D585E485E5\n85F787FB8805880D87F987FE8960895F8956895E8B418B5C8B588B498B5A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n79\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008B4E8B4F8B468B598D088D0A8E7C8E728E878E768E6C8E7A8E748F548F4E\n8FAD908A908B91B191AE93E193D193DF93C393C893DC93DD93D693E293CD93D8\n93E493D793E895DC96B496E3972A9727976197DC97FB985E9858985B98BC9945\n99499A169A199B0D9BE89BE79BD69BDB9D899D619D729D6A9D6C9E929E979E93\n9EB452F856B756B656B456BC58E45B405B435B7D5BF65DC961F861FA65186514\n651966E667276AEC703E703070327210737B74CF766276657926792A792C0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000792B7AC77AF67C4C7C437C4D7CEF7CF08FAE7E7D7E7C7E827F4C800081DA\n826685FB85F9861185FA8606860B8607860A88148815896489BA89F88B708B6C\n8B668B6F8B5F8B6B8D0F8D0D8E898E818E858E8291B491CB9418940393FD95E1\n973098C49952995199A89A2B9A309A379A359C139C0D9E799EB59EE89F2F9F5F\n9F639F615137513856C156C056C259145C6C5DCD61FC61FE651D651C659566E9\n6AFB6B046AFA6BB2704C721B72A774D674D4766977D37C507E8F7E8C7FBC0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008617862D861A882388228821881F896A896C89BD8B748B778B7D8D138E8A\n8E8D8E8B8F5F8FAF91BA942E94339435943A94389432942B95E2973897399732\n97FF9867986599579A459A439A409A3E9ACF9B549B519C2D9C259DAF9DB49DC2\n9DB89E9D9EEF9F199F5C9F669F67513C513B56C856CA56C95B7F5DD45DD25F4E\n61FF65246B0A6B6170517058738074E4758A766E766C79B37C607C5F807E807D\n81DF8972896F89FC8B808D168D178E918E938F619148944494519452973D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000973E97C397C1986B99559A559A4D9AD29B1A9C499C319C3E9C3B9DD39DD7\n9F349F6C9F6A9F9456CC5DD662006523652B652A66EC6B1074DA7ACA7C647C63\n7C657E937E967E9481E28638863F88318B8A9090908F9463946094649768986F\n995C9A5A9A5B9A579AD39AD49AD19C549C579C569DE59E9F9EF456D158E9652C\n705E7671767277D77F507F888836883988628B938B928B9682778D1B91C0946A\n97429748974497C698709A5F9B229B589C5F9DF99DFA9E7C9E7D9F079F770000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009F725EF36B1670637C6C7C6E883B89C08EA191C1947294709871995E9AD6\n9B239ECC706477DA8B9A947797C99A629A657E9C8B9C8EAA91C5947D947E947C\n9C779C789EF78C54947F9E1A72289A6A9B319E1B9E1E7C720000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n",
		"/encoding/cp1250.enc":                     "# Encoding file: cp1250, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n20AC0081201A0083201E2026202020210088203001602039015A0164017D0179\n009020182019201C201D202220132014009821220161203A015B0165017E017A\n00A002C702D8014100A4010400A600A700A800A9015E00AB00AC00AD00AE017B\n00B000B102DB014200B400B500B600B700B80105015F00BB013D02DD013E017C\n015400C100C2010200C40139010600C7010C00C9011800CB011A00CD00CE010E\n01100143014700D300D4015000D600D70158016E00DA017000DC00DD016200DF\n015500E100E2010300E4013A010700E7010D00E9011900EB011B00ED00EE010F\n01110144014800F300F4015100F600F70159016F00FA017100FC00FD016302D9\n",
		"/encoding/cp1251.enc":                     "# Encoding file: cp1251, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n04020403201A0453201E20262020202120AC203004092039040A040C040B040F\n045220182019201C201D202220132014009821220459203A045A045C045B045F\n00A0040E045E040800A4049000A600A7040100A9040400AB00AC00AD00AE0407\n00B000B104060456049100B500B600B704512116045400BB0458040504550457\n0410041104120413041404150416041704180419041A041B041C041D041E041F\n0420042104220423042404250426042704280429042A042B042C042D042E042F\n0430043104320433043404350436043704380439043A043B043C043D043E043F\n0440044104420443044404450446044704480449044A044B044C044D044E044F\n",
		"/encoding/cp1252.enc":                     "# Encoding file: cp1252, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n20AC0081201A0192201E20262020202102C62030016020390152008D017D008F\n009020182019201C201D20222013201402DC21220161203A0153009D017E0178\n00A000A100A200A300A400A500A600A700A800A900AA00AB00AC00AD00AE00AF\n00B000B100B200B300B400B500B600B700B800B900BA00BB00BC00BD00BE00BF\n00C000C100C200C300C400C500C600C700C800C900CA00CB00CC00CD00CE00CF\n00D000D100D200D300D400D500D600D700D800D900DA00DB00DC00DD00DE00DF\n00E000E100E200E300E400E500E600E700E800E900EA00EB00EC00ED00EE00EF\n00F000F100F200F300F400F500F600F700F800F900FA00FB00FC00FD00FE00FF\n",
		"/encoding/cp1253.enc":                     "# Encoding file: cp1253, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n20AC0081201A0192201E20262020202100882030008A2039008C008D008E008F\n009020182019201C201D20222013201400982122009A203A009C009D009E009F\n00A00385038600A300A400A500A600A700A800A9000000AB00AC00AD00AE2015\n00B000B100B200B3038400B500B600B703880389038A00BB038C00BD038E038F\n0390039103920393039403950396039703980399039A039B039C039D039E039F\n03A003A1000003A303A403A503A603A703A803A903AA03AB03AC03AD03AE03AF\n03B003B103B203B303B403B503B603B703B803B903BA03BB03BC03BD03BE03BF\n03C003C103C203C303C403C503C603C703C803C903CA03CB03CC03CD03CE0000\n",
		"/encoding/cp1254.enc":                     "# Encoding file: cp1254, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n20AC0081201A0192201E20262020202102C62030016020390152008D008E008F\n009020182019201C201D20222013201402DC21220161203A0153009D009E0178\n00A000A100A200A300A400A500A600A700A800A900AA00AB00AC00AD00AE00AF\n00B000B100B200B300B400B500B600B700B800B900BA00BB00BC00BD00BE00BF\n00C000C100C200C300C400C500C600C700C800C900CA00CB00CC00CD00CE00CF\n011E00D100D200D300D400D500D600D700D800D900DA00DB00DC0130015E00DF\n00E000E100E200E300E400E500E600E700E800E900EA00EB00EC00ED00EE00EF\n011F00F100F200F300F400F500F600F700F800F900FA00FB00FC0131015F00FF\n",
		"/encoding/cp1255.enc":                     "# Encoding file: cp1255, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n20AC0081201A0192201E20262020202102C62030008A2039008C008D008E008F\n009020182019201C201D20222013201402DC2122009A203A009C009D009E009F\n00A000A100A200A320AA00A500A600A700A800A900D700AB00AC00AD00AE00AF\n00B000B100B200B300B400B500B600B700B800B900F700BB00BC00BD00BE00BF\n05B005B105B205B305B405B505B605B705B805B9000005BB05BC05BD05BE05BF\n05C005C105C205C305F005F105F205F305F40000000000000000000000000000\n05D005D105D205D305D405D505D605D705D805D905DA05DB05DC05DD05DE05DF\n05E005E105E205E305E405E505E605E705E805E905EA00000000200E200F0000\n",
		"/encoding/cp1256.enc":                     "# Encoding file: cp1256, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n20AC067E201A0192201E20262020202102C62030067920390152068606980688\n06AF20182019201C201D20222013201406A921220691203A0153200C200D06BA\n00A0060C00A200A300A400A500A600A700A800A906BE00AB00AC00AD00AE00AF\n00B000B100B200B300B400B500B600B700B800B9061B00BB00BC00BD00BE061F\n06C1062106220623062406250626062706280629062A062B062C062D062E062F\n063006310632063306340635063600D7063706380639063A0640064106420643\n00E0064400E2064506460647064800E700E800E900EA00EB0649064A00EE00EF\n064B064C064D064E00F4064F065000F7065100F9065200FB00FC200E200F06D2\n",
		"/encoding/cp1257.enc":                     "# Encoding file: cp1257, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n20AC0081201A0083201E20262020202100882030008A2039008C00A802C700B8\n009020182019201C201D20222013201400982122009A203A009C00AF02DB009F\n00A0000000A200A300A4000000A600A700D800A9015600AB00AC00AD00AE00C6\n00B000B100B200B300B400B500B600B700F800B9015700BB00BC00BD00BE00E6\n0104012E0100010600C400C501180112010C00C90179011601220136012A013B\n01600143014500D3014C00D500D600D701720141015A016A00DC017B017D00DF\n0105012F0101010700E400E501190113010D00E9017A011701230137012B013C\n01610144014600F3014D00F500F600F701730142015B016B00FC017C017E02D9\n",
		"/encoding/cp1258.enc":                     "# Encoding file: cp1258, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n20AC0081201A0192201E20262020202102C62030008A20390152008D008E008F\n009020182019201C201D20222013201402DC2122009A203A0153009D009E0178\n00A000A100A200A300A400A500A600A700A800A900AA00AB00AC00AD00AE00AF\n00B000B100B200B300B400B500B600B700B800B900BA00BB00BC00BD00BE00BF\n00C000C100C2010200C400C500C600C700C800C900CA00CB030000CD00CE00CF\n011000D1030900D300D401A000D600D700D800D900DA00DB00DC01AF030300DF\n00E000E100E2010300E400E500E600E700E800E900EA00EB030100ED00EE00EF\n011100F1032300F300F401A100F600F700F800F900FA00FB00FC01B020AB00FF\n",
		"/encoding/cp437.enc":                      "# Encoding file: cp437, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n00C700FC00E900E200E400E000E500E700EA00EB00E800EF00EE00EC00C400C5\n00C900E600C600F400F600F200FB00F900FF00D600DC00A200A300A520A70192\n00E100ED00F300FA00F100D100AA00BA00BF231000AC00BD00BC00A100AB00BB\n259125922593250225242561256225562555256325512557255D255C255B2510\n25142534252C251C2500253C255E255F255A25542569256625602550256C2567\n2568256425652559255825522553256B256A2518250C25882584258C25902580\n03B100DF039303C003A303C300B503C403A6039803A903B4221E03C603B52229\n226100B1226522642320232100F7224800B0221900B7221A207F00B225A000A0\n",
		"/encoding/cp737.enc":                      "# Encoding file: cp737, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n039103920393039403950396039703980399039A039B039C039D039E039F03A0\n03A103A303A403A503A603A703A803A903B103B203B303B403B503B603B703B8\n03B903BA03BB03BC03BD03BE03BF03C003C103C303C203C403C503C603C703C8\n259125922593250225242561256225562555256325512557255D255C255B2510\n25142534252C251C2500253C255E255F255A25542569256625602550256C2567\n2568256425652559255825522553256B256A2518250C25882584258C25902580\n03C903AC03AD03AE03CA03AF03CC03CD03CB03CE038603880389038A038C038E\n038F00B12265226403AA03AB00F7224800B0221900B7221A207F00B225A000A0\n",
		"/encoding/cp775.enc":                      "# Encoding file: cp775, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n010600FC00E9010100E4012300E501070142011301560157012B017900C400C5\n00C900E600C6014D00F6012200A2015A015B00D600DC00F800A300D800D700A4\n0100012A00F3017B017C017A201D00A600A900AE00AC00BD00BC014100AB00BB\n259125922593250225240104010C01180116256325512557255D012E01602510\n25142534252C251C2500253C0172016A255A25542569256625602550256C017D\n0105010D01190117012F01610173016B017E2518250C25882584258C25902580\n00D300DF014C014300F500D500B5014401360137013B013C0146011201452019\n00AD00B1201C00BE00B600A700F7201E00B0221900B700B900B300B225A000A0\n",
		"/encoding/cp850.enc":                      "# Encoding file: cp850, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n00C700FC00E900E200E400E000E500E700EA00EB00E800EF00EE00EC00C400C5\n00C900E600C600F400F600F200FB00F900FF00D600DC00F800A300D800D70192\n00E100ED00F300FA00F100D100AA00BA00BF00AE00AC00BD00BC00A100AB00BB\n2591259225932502252400C100C200C000A9256325512557255D00A200A52510\n25142534252C251C2500253C00E300C3255A25542569256625602550256C00A4\n00F000D000CA00CB00C8013100CD00CE00CF2518250C2588258400A600CC2580\n00D300DF00D400D200F500D500B500FE00DE00DA00DB00D900FD00DD00AF00B4\n00AD00B1201700BE00B600A700F700B800B000A800B700B900B300B225A000A0\n",
		"/encoding/cp852.enc":                      "# Encoding file: cp852, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n00C700FC00E900E200E4016F010700E7014200EB0150015100EE017900C40106\n00C90139013A00F400F6013D013E015A015B00D600DC01640165014100D7010D\n00E100ED00F300FA01040105017D017E0118011900AC017A010C015F00AB00BB\n2591259225932502252400C100C2011A015E256325512557255D017B017C2510\n25142534252C251C2500253C01020103255A25542569256625602550256C00A4\n01110110010E00CB010F014700CD00CE011B2518250C258825840162016E2580\n00D300DF00D401430144014801600161015400DA0155017000FD00DD016300B4\n00AD02DD02DB02C702D800A700F700B800B000A802D901710158015925A000A0\n",
		"/encoding/cp855.enc":                      "# Encoding file: cp855, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n0452040204530403045104010454040404550405045604060457040704580408\n04590409045A040A045B040B045C040C045E040E045F040F044E042E044A042A\n0430041004310411044604260434041404350415044404240433041300AB00BB\n259125922593250225240445042504380418256325512557255D043904192510\n25142534252C251C2500253C043A041A255A25542569256625602550256C00A4\n043B041B043C041C043D041D043E041E043F2518250C25882584041F044F2580\n042F044004200441042104420422044304230436041604320412044C042C2116\n00AD044B042B0437041704480428044D042D044904290447042700A725A000A0\n",
		"/encoding/cp857.enc":                      "# Encoding file: cp857, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n00C700FC00E900E200E400E000E500E700EA00EB00E800EF00EE013100C400C5\n00C900E600C600F400F600F200FB00F9013000D600DC00F800A300D8015E015F\n00E100ED00F300FA00F100D1011E011F00BF00AE00AC00BD00BC00A100AB00BB\n2591259225932502252400C100C200C000A9256325512557255D00A200A52510\n25142534252C251C2500253C00E300C3255A25542569256625602550256C00A4\n00BA00AA00CA00CB00C8000000CD00CE00CF2518250C2588258400A600CC2580\n00D300DF00D400D200F500D500B5000000D700DA00DB00D900EC00FF00AF00B4\n00AD00B1000000BE00B600A700F700B800B000A800B700B900B300B225A000A0\n",
		"/encoding/cp860.enc":                      "# Encoding file: cp860, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n00C700FC00E900E200E300E000C100E700EA00CA00E800CD00D400EC00C300C2\n00C900C000C800F400F500F200DA00F900CC00D500DC00A200A300D920A700D3\n00E100ED00F300FA00F100D100AA00BA00BF00D200AC00BD00BC00A100AB00BB\n259125922593250225242561256225562555256325512557255D255C255B2510\n25142534252C251C2500253C255E255F255A25542569256625602550256C2567\n2568256425652559255825522553256B256A2518250C25882584258C25902580\n03B100DF039303C003A303C300B503C403A6039803A903B4221E03C603B52229\n226100B1226522642320232100F7224800B0221900B7221A207F00B225A000A0\n",
		"/encoding/cp861.enc":                      "# Encoding file: cp861, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n00C700FC00E900E200E400E000E500E700EA00EB00E800D000F000DE00C400C5\n00C900E600C600F400F600FE00FB00DD00FD00D600DC00F800A300D820A70192\n00E100ED00F300FA00C100CD00D300DA00BF231000AC00BD00BC00A100AB00BB\n259125922593250225242561256225562555256325512557255D255C255B2510\n25142534252C251C2500253C255E255F255A25542569256625602550256C2567\n2568256425652559255825522553256B256A2518250C25882584258C25902580\n03B100DF039303C003A303C300B503C403A6039803A903B4221E03C603B52229\n226100B1226522642320232100F7224800B0221900B7221A207F00B225A000A0\n",
		"/encoding/cp862.enc":                      "# Encoding file: cp862, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n05D005D105D205D305D405D505D605D705D805D905DA05DB05DC05DD05DE05DF\n05E005E105E205E305E405E505E605E705E805E905EA00A200A300A520A70192\n00E100ED00F300FA00F100D100AA00BA00BF231000AC00BD00BC00A100AB00BB\n259125922593250225242561256225562555256325512557255D255C255B2510\n25142534252C251C2500253C255E255F255A25542569256625602550256C2567\n2568256425652559255825522553256B256A2518250C25882584258C25902580\n03B100DF039303C003A303C300B503C403A6039803A903B4221E03C603B52229\n226100B1226522642320232100F7224800B0221900B7221A207F00B225A000A0\n",
		"/encoding/cp863.enc":                      "# Encoding file: cp863, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n00C700FC00E900E200C200E000B600E700EA00EB00E800EF00EE201700C000A7\n00C900C800CA00F400CB00CF00FB00F900A400D400DC00A200A300D900DB0192\n00A600B400F300FA00A800B800B300AF00CE231000AC00BD00BC00BE00AB00BB\n259125922593250225242561256225562555256325512557255D255C255B2510\n25142534252C251C2500253C255E255F255A25542569256625602550256C2567\n2568256425652559255825522553256B256A2518250C25882584258C25902580\n03B100DF039303C003A303C300B503C403A6039803A903B4221E03C603B52229\n226100B1226522642320232100F7224800B0221900B7221A207F00B225A000A0\n",
		"/encoding/cp864.enc":                      "# Encoding file: cp864, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n00200021002200230024066A0026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n00B000B72219221A259225002502253C2524252C251C25342510250C25142518\n03B2221E03C600B100BD00BC224800AB00BBFEF7FEF8009B009CFEFBFEFC009F\n00A000ADFE8200A300A4FE8400000000FE8EFE8FFE95FE99060CFE9DFEA1FEA5\n0660066106620663066406650666066706680669FED1061BFEB1FEB5FEB9061F\n00A2FE80FE81FE83FE85FECAFE8BFE8DFE91FE93FE97FE9BFE9FFEA3FEA7FEA9\nFEABFEADFEAFFEB3FEB7FEBBFEBFFEC1FEC5FECBFECF00A600AC00F700D7FEC9\n0640FED3FED7FEDBFEDFFEE3FEE7FEEBFEEDFEEFFEF3FEBDFECCFECEFECDFEE1\nFE7D0651FEE5FEE9FEECFEF0FEF2FED0FED5FEF5FEF6FEDDFED9FEF125A00000\n",
		"/encoding/cp865.enc":                      "# Encoding file: cp865, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n00C700FC00E900E200E400E000E500E700EA00EB00E800EF00EE00EC00C400C5\n00C900E600C600F400F600F200FB00F900FF00D600DC00F800A300D820A70192\n00E100ED00F300FA00F100D100AA00BA00BF231000AC00BD00BC00A100AB00A4\n259125922593250225242561256225562555256325512557255D255C255B2510\n25142534252C251C2500253C255E255F255A25542569256625602550256C2567\n2568256425652559255825522553256B256A2518250C25882584258C25902580\n03B100DF039303C003A303C300B503C403A6039803A903B4221E03C603B52229\n226100B1226522642320232100F7224800B0221900B7221A207F00B225A000A0\n",
		"/encoding/cp866.enc":                      "# Encoding file: cp866, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n0410041104120413041404150416041704180419041A041B041C041D041E041F\n0420042104220423042404250426042704280429042A042B042C042D042E042F\n0430043104320433043404350436043704380439043A043B043C043D043E043F\n259125922593250225242561256225562555256325512557255D255C255B2510\n25142534252C251C2500253C255E255F255A25542569256625602550256C2567\n2568256425652559255825522553256B256A2518250C25882584258C25902580\n0440044104420443044404450446044704480449044A044B044C044D044E044F\n040104510404045404070457040E045E00B0221900B7221A211600A425A000A0\n",
		"/encoding/cp869.enc":                      "# Encoding file: cp869, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n0080008100820083008400850386008700B700AC00A620182019038820150389\n038A03AA038C00930094038E03AB00A9038F00B200B303AC00A303AD03AE03AF\n03CA039003CC03CD039103920393039403950396039700BD0398039900AB00BB\n25912592259325022524039A039B039C039D256325512557255D039E039F2510\n25142534252C251C2500253C03A003A1255A25542569256625602550256C03A3\n03A403A503A603A703A803A903B103B203B32518250C2588258403B403B52580\n03B603B703B803B903BA03BB03BC03BD03BE03BF03C003C103C303C203C40384\n00AD00B103C503C603C700A703C8038500B000A803C903CB03B003CE25A000A0\n",
		"/encoding/cp874.enc":                      "# Encoding file: cp874, single-byte\nS\n003F 0 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n20AC008100820083008420260086008700880089008A008B008C008D008E008F\n009020182019201C201D20222013201400980099009A009B009C009D009E009F\n00A00E010E020E030E040E050E060E070E080E090E0A0E0B0E0C0E0D0E0E0E0F\n0E100E110E120E130E140E150E160E170E180E190E1A0E1B0E1C0E1D0E1E0E1F\n0E200E210E220E230E240E250E260E270E280E290E2A0E2B0E2C0E2D0E2E0E2F\n0E300E310E320E330E340E350E360E370E380E390E3A00000000000000000E3F\n0E400E410E420E430E440E450E460E470E480E490E4A0E4B0E4C0E4D0E4E0E4F\n0E500E510E520E530E540E550E560E570E580E590E5A0E5B0000000000000000\n",
		"/encoding/cp932.enc":                      "# Encoding file: cp932, multi-byte\nM\n003F 0 46\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n0080000000000000000000850086000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000FF61FF62FF63FF64FF65FF66FF67FF68FF69FF6AFF6BFF6CFF6DFF6EFF6F\nFF70FF71FF72FF73FF74FF75FF76FF77FF78FF79FF7AFF7BFF7CFF7DFF7EFF7F\nFF80FF81FF82FF83FF84FF85FF86FF87FF88FF89FF8AFF8BFF8CFF8DFF8EFF8F\nFF90FF91FF92FF93FF94FF95FF96FF97FF98FF99FF9AFF9BFF9CFF9DFF9EFF9F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n81\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n300030013002FF0CFF0E30FBFF1AFF1BFF1FFF01309B309C00B4FF4000A8FF3E\nFFE3FF3F30FD30FE309D309E30034EDD30053006300730FC20152010FF0FFF3C\nFF5E2225FF5C2026202520182019201C201DFF08FF0930143015FF3BFF3DFF5B\nFF5D30083009300A300B300C300D300E300F30103011FF0BFF0D00B100D70000\n00F7FF1D2260FF1CFF1E22662267221E22342642264000B0203220332103FFE5\nFF04FFE0FFE1FF05FF03FF06FF0AFF2000A72606260525CB25CF25CE25C725C6\n25A125A025B325B225BD25BC203B301221922190219121933013000000000000\n000000000000000000000000000000002208220B2286228722822283222A2229\n0000000000000000000000000000000022272228FFE221D221D4220022030000\n0000000000000000000000000000000000000000222022A52312220222072261\n2252226A226B221A223D221D2235222B222C0000000000000000000000000000\n212B2030266F266D266A2020202100B6000000000000000025EF000000000000\n82\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000000000000000000000000000000000000000000000000000000000000FF10\nFF11FF12FF13FF14FF15FF16FF17FF18FF190000000000000000000000000000\nFF21FF22FF23FF24FF25FF26FF27FF28FF29FF2AFF2BFF2CFF2DFF2EFF2FFF30\nFF31FF32FF33FF34FF35FF36FF37FF38FF39FF3A000000000000000000000000\n0000FF41FF42FF43FF44FF45FF46FF47FF48FF49FF4AFF4BFF4CFF4DFF4EFF4F\nFF50FF51FF52FF53FF54FF55FF56FF57FF58FF59FF5A00000000000000003041\n30423043304430453046304730483049304A304B304C304D304E304F30503051\n30523053305430553056305730583059305A305B305C305D305E305F30603061\n30623063306430653066306730683069306A306B306C306D306E306F30703071\n30723073307430753076307730783079307A307B307C307D307E307F30803081\n30823083308430853086308730883089308A308B308C308D308E308F30903091\n3092309300000000000000000000000000000000000000000000000000000000\n83\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n30A130A230A330A430A530A630A730A830A930AA30AB30AC30AD30AE30AF30B0\n30B130B230B330B430B530B630B730B830B930BA30BB30BC30BD30BE30BF30C0\n30C130C230C330C430C530C630C730C830C930CA30CB30CC30CD30CE30CF30D0\n30D130D230D330D430D530D630D730D830D930DA30DB30DC30DD30DE30DF0000\n30E030E130E230E330E430E530E630E730E830E930EA30EB30EC30ED30EE30EF\n30F030F130F230F330F430F530F6000000000000000000000000000000000391\n03920393039403950396039703980399039A039B039C039D039E039F03A003A1\n03A303A403A503A603A703A803A90000000000000000000000000000000003B1\n03B203B303B403B503B603B703B803B903BA03BB03BC03BD03BE03BF03C003C1\n03C303C403C503C603C703C803C9000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n84\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n04100411041204130414041504010416041704180419041A041B041C041D041E\n041F0420042104220423042404250426042704280429042A042B042C042D042E\n042F000000000000000000000000000000000000000000000000000000000000\n04300431043204330434043504510436043704380439043A043B043C043D0000\n043E043F0440044104420443044404450446044704480449044A044B044C044D\n044E044F00000000000000000000000000000000000000000000000000002500\n2502250C251025182514251C252C25242534253C25012503250F2513251B2517\n25232533252B253B254B2520252F25282537253F251D25302525253825420000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n87\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n2460246124622463246424652466246724682469246A246B246C246D246E246F\n2470247124722473216021612162216321642165216621672168216900003349\n33143322334D331833273303333633513357330D33263323332B334A333B339C\n339D339E338E338F33C433A100000000000000000000000000000000337B0000\n301D301F211633CD212132A432A532A632A732A8323132323239337E337D337C\n22522261222B222E2211221A22A52220221F22BF22352229222A000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n88\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000004E9C\n55165A03963F54C0611B632859F690228475831C7A5060AA63E16E2565ED8466\n82A69BF56893572765A162715B9B59D0867B98F47D627DBE9B8E62167C9F88B7\n5B895EB563096697684895C7978D674F4EE54F0A4F4D4F9D504956F2593759D4\n5A015C0960DF610F61706613690570BA754F757079FB7DAD7DEF80C3840E8863\n8B029055907A533B4E954EA557DF80B290C178EF4E0058F16EA290387A328328\n828B9C2F5141537054BD54E156E059FB5F1598F26DEB80E4852D000000000000\n89\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9662967096A097FB540B53F35B8770CF7FBD8FC296E8536F9D5C7ABA4E117893\n81FC6E26561855046B1D851A9C3B59E553A96D6674DC958F56424E91904B96F2\n834F990C53E155B65B305F71662066F368046C386CF36D29745B76C87A4E9834\n82F1885B8A6092ED6DB275AB76CA99C560A68B018D8A95B2698E53AD51860000\n5712583059445BB45EF6602863A963F46CBF6F14708E7114715971D5733F7E01\n827682D185979060925B9D1B586965BC6C5A752551F9592E59655F805FDC62BC\n65FA6A2A6B276BB4738B7FC189569D2C9D0E9EC45CA16C96837B51045C4B61B6\n81C6687672614E594FFA537860696E297A4F97F34E0B53164EEE4F554F3D4FA1\n4F7352A053EF5609590F5AC15BB65BE179D16687679C67B66B4C6CB3706B73C2\n798D79BE7A3C7B8782B182DB8304837783EF83D387668AB256298CA88FE6904E\n971E868A4FC45CE862117259753B81E582BD86FE8CC096C5991399D54ECB4F1A\n89E356DE584A58CA5EFB5FEB602A6094606261D0621262D06539000000000000\n8A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9B41666668B06D777070754C76867D7582A587F9958B968E8C9D51F152BE5916\n54B35BB35D16616869826DAF788D84CB88578A7293A79AB86D6C99A886D957A3\n67FF86CE920E5283568754045ED362E164B9683C68386BBB737278BA7A6B899A\n89D28D6B8F0390ED95A3969497695B665CB3697D984D984E639B7B206A2B0000\n6A7F68B69C0D6F5F5272559D607062EC6D3B6E076ED1845B89108F444E149C39\n53F6691B6A3A9784682A515C7AC384B291DC938C565B9D286822830584317CA5\n520882C574E64E7E4F8351A05BD2520A52D852E75DFB559A582A59E65B8C5B98\n5BDB5E725E7960A3611F616361BE63DB656267D1685368FA6B3E6B536C576F22\n6F976F4574B0751876E3770B7AFF7BA17C217DE97F367FF0809D8266839E89B3\n8ACC8CAB908494519593959195A2966597D3992882184E38542B5CB85DCC73A9\n764C773C5CA97FEB8D0B96C19811985498584F014F0E5371559C566857FA5947\n5B095BC45C905E0C5E7E5FCC63EE673A65D765E2671F68CB68C4000000000000\n8B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6A5F5E306BC56C176C7D757F79485B637A007D005FBD898F8A188CB48D778ECC\n8F1D98E29A0E9B3C4E80507D510059935B9C622F628064EC6B3A72A075917947\n7FA987FB8ABC8B7063AC83CA97A05409540355AB68546A588A70782767759ECD\n53745BA2811A865090064E184E454EC74F1153CA54385BAE5F13602565510000\n673D6C426C726CE3707874037A767AAE7B087D1A7CFE7D6665E7725B53BB5C45\n5DE862D262E063196E20865A8A318DDD92F86F0179A69B5A4EA84EAB4EAC4F9B\n4FA050D151477AF6517151F653545321537F53EB55AC58835CE15F375F4A602F\n6050606D631F65596A4B6CC172C272ED77EF80F881058208854E90F793E197FF\n99579A5A4EF051DD5C2D6681696D5C4066F26975738968507C8150C552E45747\n5DFE932665A46B236B3D7434798179BD7B4B7DCA82B983CC887F895F8B398FD1\n91D1541F92804E5D503653E5533A72D7739677E982E68EAF99C699C899D25177\n611A865E55B07A7A50765BD3904796854E326ADB91E75C515C48000000000000\n8C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n63987A9F6C9397748F617AAA718A96887C8268177E706851936C52F2541B85AB\n8A137FA48ECD90E15366888879414FC250BE521151445553572D73EA578B5951\n5F625F8460756176616761A963B2643A656C666F68426E1375667A3D7CFB7D4C\n7D997E4B7F6B830E834A86CD8A088A638B668EFD981A9D8F82B88FCE9BE80000\n5287621F64836FC09699684150916B206C7A6F547A747D5088408A2367084EF6\n503950265065517C5238526355A7570F58055ACC5EFA61B261F862F36372691C\n6A29727D72AC732E7814786F7D79770C80A9898B8B198CE28ED290639375967A\n98559A139E785143539F53B35E7B5F266E1B6E90738473FE7D4382378A008AFA\n96504E4E500B53E4547C56FA59D15B645DF15EAB5F276238654567AF6E5672D0\n7CCA88B480A180E183F0864E8A878DE8923796C798679F134E944E924F0D5348\n5449543E5A2F5F8C5FA1609F68A76A8E745A78818A9E8AA48B7791904E5E9BC9\n4EA44F7C4FAF501950165149516C529F52B952FE539A53E35411000000000000\n8D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n540E5589575157A2597D5B545B5D5B8F5DE55DE75DF75E785E835E9A5EB75F18\n6052614C629762D863A7653B6602664366F4676D6821689769CB6C5F6D2A6D69\n6E2F6E9D75327687786C7A3F7CE07D057D187D5E7DB18015800380AF80B18154\n818F822A8352884C88618B1B8CA28CFC90CA91759271783F92FC95A4964D0000\n980599999AD89D3B525B52AB53F7540858D562F76FE08C6A8F5F9EB9514B523B\n544A56FD7A4091779D609ED273446F09817075115FFD60DA9AA872DB8FBC6B64\n98034ECA56F0576458BE5A5A606861C7660F6606683968B16DF775D57D3A826E\n9B424E9B4F5053C955065D6F5DE65DEE67FB6C99747378028A50939688DF5750\n5EA7632B50B550AC518D670054C9585E59BB5BB05F69624D63A1683D6B736E08\n707D91C7728078157826796D658E7D3083DC88C18F09969B5264572867507F6A\n8CA151B45742962A583A698A80B454B25D0E57FC78959DFA4F5C524A548B643E\n6628671467F57A847B567D22932F685C9BAD7B395319518A5237000000000000\n8E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5BDF62F664AE64E6672D6BBA85A996D176909BD6634C93069BAB76BF66524E09\n509853C25C7160E864926563685F71E673CA75237B977E8286958B838CDB9178\n991065AC66AB6B8B4ED54ED44F3A4F7F523A53F853F255E356DB58EB59CB59C9\n59FF5B505C4D5E025E2B5FD7601D6307652F5B5C65AF65BD65E8679D6B620000\n6B7B6C0F7345794979C17CF87D197D2B80A2810281F389968A5E8A698A668A8C\n8AEE8CC78CDC96CC98FC6B6F4E8B4F3C4F8D51505B575BFA6148630166426B21\n6ECB6CBB723E74BD75D478C1793A800C803381EA84948F9E6C509E7F5F0F8B58\n9D2B7AFA8EF85B8D96EB4E0353F157F759315AC95BA460896E7F6F0675BE8CEA\n5B9F85007BE0507267F4829D5C61854A7E1E820E51995C0463688D66659C716E\n793E7D1780058B1D8ECA906E86C790AA501F52FA5C3A6753707C7235914C91C8\n932B82E55BC25F3160F94E3B53D65B88624B67316B8A72E973E07A2E816B8DA3\n91529996511253D7546A5BFF63886A397DAC970056DA53CE5468000000000000\n8F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5B975C315DDE4FEE610162FE6D3279C079CB7D427E4D7FD281ED821F84908846\n89728B908E748F2F9031914B916C96C6919C4EC04F4F514553415F93620E67D4\n6C416E0B73637E2691CD928353D459195BBF6DD1795D7E2E7C9B587E719F51FA\n88538FF04FCA5CFB662577AC7AE3821C99FF51C65FAA65EC696F6B896DF30000\n6E966F6476FE7D145DE190759187980651E6521D6240669166D96E1A5EB67DD2\n7F7266F885AF85F78AF852A953D959735E8F5F90605592E4966450B7511F52DD\n5320534753EC54E8554655315617596859BE5A3C5BB55C065C0F5C115C1A5E84\n5E8A5EE05F70627F628462DB638C63776607660C662D6676677E68A26A1F6A35\n6CBC6D886E096E58713C7126716775C77701785D7901796579F07AE07B117CA7\n7D39809683D6848B8549885D88F38A1F8A3C8A548A738C618CDE91A49266937E\n9418969C97984E0A4E084E1E4E575197527057CE583458CC5B225E3860C564FE\n676167566D4472B675737A6384B88B7291B89320563157F498FE000000000000\n90\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n62ED690D6B9671ED7E548077827289E698DF87558FB15C3B4F384FE14FB55507\n5A205BDD5BE95FC3614E632F65B0664B68EE699B6D786DF1753375B9771F795E\n79E67D3381E382AF85AA89AA8A3A8EAB8F9B903291DD97074EBA4EC152035875\n58EC5C0B751A5C3D814E8A0A8FC59663976D7B258ACF9808916256F353A80000\n9017543957825E2563A86C34708A77617C8B7FE088709042915493109318968F\n745E9AC45D075D69657067A28DA896DB636E6749691983C5981796C088FE6F84\n647A5BF84E16702C755D662F51C4523652E259D35F8160276210653F6574661F\n667468F268166B636E057272751F76DB7CBE805658F088FD897F8AA08A938ACB\n901D91929752975965897A0E810696BB5E2D60DC621A65A56614679077F37A4D\n7C4D7E3E810A8CAC8D648DE18E5F78A9520762D963A5644262988A2D7A837BC0\n8AAC96EA7D76820C87494ED95148534353605BA35C025C165DDD6226624764B0\n681368346CC96D456D1767D36F5C714E717D65CB7A7F7BAD7DDA000000000000\n91\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7E4A7FA8817A821B823985A68A6E8CCE8DF59078907792AD929195839BAE524D\n55846F387136516879857E5581B37CCE564C58515CA863AA66FE66FD695A72D9\n758F758E790E795679DF7C977D207D4486078A34963B90619F2050E7527553CC\n53E2500955AA58EE594F723D5B8B5C64531D60E360F3635C6383633F63BB0000\n64CD65E966F95DE369CD69FD6F1571E54E8975E976F87A937CDF7DCF7D9C8061\n83498358846C84BC85FB88C58D709001906D9397971C9A1250CF5897618E81D3\n85358D0890204FC3507452475373606F6349675F6E2C8DB3901F4FD75C5E8CCA\n65CF7D9A53528896517663C35B585B6B5C0A640D6751905C4ED6591A592A6C70\n8A51553E581559A560F0625367C182356955964099C49A284F5358065BFE8010\n5CB15E2F5F856020614B623466FF6CF06EDE80CE817F82D4888B8CB89000902E\n968A9EDB9BDB4EE353F059277B2C918D984C9DF96EDD7027535355445B856258\n629E62D36CA26FEF74228A1794386FC18AFE833851E786F853EA000000000000\n92\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n53E94F4690548FB0596A81315DFD7AEA8FBF68DA8C3772F89C486A3D8AB04E39\n53585606576662C563A265E66B4E6DE16E5B70AD77ED7AEF7BAA7DBB803D80C6\n86CB8A95935B56E358C75F3E65AD66966A806BB575378AC7502477E557305F1B\n6065667A6C6075F47A1A7F6E81F48718904599B37BC9755C7AF97B5184C40000\n901079E97A9283365AE177404E2D4EF25B995FE062BD663C67F16CE8866B8877\n8A3B914E92F399D06A177026732A82E784578CAF4E01514651CB558B5BF55E16\n5E335E815F145F355F6B5FB461F2631166A2671D6F6E7252753A773A80748139\n817887768ABF8ADC8D858DF3929A957798029CE552C5635776F467156C8873CD\n8CC393AE96736D25589C690E69CC8FFD939A75DB901A585A680263B469FB4F43\n6F2C67D88FBB85267DB49354693F6F70576A58F75B2C7D2C722A540A91E39DB4\n4EAD4F4E505C507552438C9E544858245B9A5E1D5E955EAD5EF75F1F608C62B5\n633A63D068AF6C407887798E7A0B7DE082478A028AE68E449013000000000000\n93\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n90B8912D91D89F0E6CE5645864E265756EF476847B1B906993D16EBA54F25FB9\n64A48F4D8FED92445178586B59295C555E976DFB7E8F751C8CBC8EE2985B70B9\n4F1D6BBF6FB1753096FB514E54105835585759AC5C605F926597675C6E21767B\n83DF8CED901490FD934D7825783A52AA5EA6571F597460125012515A51AC0000\n51CD520055105854585859575B955CF65D8B60BC6295642D6771684368BC68DF\n76D76DD86E6F6D9B706F71C85F5375D879777B497B547B527CD67D7152308463\n856985E48A0E8B048C468E0F9003900F94199676982D9A3095D850CD52D5540C\n58025C0E61A7649E6D1E77B37AE580F48404905392855CE09D07533F5F975FB3\n6D9C7279776379BF7BE46BD272EC8AAD68036A6151F87A8169345C4A9CF682EB\n5BC59149701E56785C6F60C765666C8C8C5A90419813545166C7920D594890A3\n51854E4D51EA85998B0E7058637A934B696299B47E047577535769608EDF96E3\n6C5D4E8C5C3C5F108FE953028CD1808986795EFF65E54E735165000000000000\n94\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n59825C3F97EE4EFB598A5FCD8A8D6FE179B079625BE78471732B71B15E745FF5\n637B649A71C37C984E435EFC4E4B57DC56A260A96FC37D0D80FD813381BF8FB2\n899786A45DF4628A64AD898767776CE26D3E743678345A467F7582AD99AC4FF3\n5EC362DD63926557676F76C3724C80CC80BA8F29914D500D57F95A9268850000\n6973716472FD8CB758F28CE0966A9019877F79E477E784294F2F5265535A62CD\n67CF6CCA767D7B947C95823685848FEB66DD6F2072067E1B83AB99C19EA651FD\n7BB178727BB880877B486AE85E61808C75517560516B92626E8C767A91979AEA\n4F107F70629C7B4F95A59CE9567A585986E496BC4F345224534A53CD53DB5E06\n642C6591677F6C3E6C4E724872AF73ED75547E41822C85E98CA97BC491C67169\n981298EF633D6669756A76E478D0854386EE532A5351542659835E875F7C60B2\n6249627962AB65906BD46CCC75B276AE789179D87DCB7F7780A588AB8AB98CBB\n907F975E98DB6A0B7C3850995C3E5FAE67876BD8743577097F8E000000000000\n95\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9F3B67CA7A175339758B9AED5F66819D83F180985F3C5FC575627B46903C6867\n59EB5A9B7D10767E8B2C4FF55F6A6A196C376F0274E2796888688A558C795EDF\n63CF75C579D282D7932892F2849C86ED9C2D54C15F6C658C6D5C70158CA78CD3\n983B654F74F64E0D4ED857E0592B5A665BCC51A85E035E9C6016627665770000\n65A7666E6D6E72367B268150819A82998B5C8CA08CE68D74961C96444FAE64AB\n6B66821E8461856A90E85C01695398A8847A85574F0F526F5FA95E45670D798F\n8179890789866DF55F1762556CB84ECF72699B925206543B567458B361A4626E\n711A596E7C897CDE7D1B96F06587805E4E194F75517558405E635E735F0A67C4\n4E26853D9589965B7C73980150FB58C1765678A7522577A585117B86504F5909\n72477BC77DE88FBA8FD4904D4FBF52C95A295F0197AD4FDD821792EA57036355\n6B69752B88DC8F147A4252DF58936155620A66AE6BCD7C3F83E950234FF85305\n5446583159495B9D5CF05CEF5D295E9662B16367653E65B9670B000000000000\n96\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6CD56CE170F978327E2B80DE82B3840C84EC870289128A2A8C4A90A692D298FD\n9CF39D6C4E4F4EA1508D5256574A59A85E3D5FD85FD9623F66B4671B67D068D2\n51927D2180AA81A88B008C8C8CBF927E96325420982C531750D5535C58A864B2\n6734726777667A4691E652C36CA16B8658005E4C5954672C7FFB51E176C60000\n646978E89B549EBB57CB59B96627679A6BCE54E969D95E55819C67959BAA67FE\n9C52685D4EA64FE353C862B9672B6CAB8FC44FAD7E6D9EBF4E0761626E806F2B\n85135473672A9B455DF37B955CAC5BC6871C6E4A84D17A14810859997C8D6C11\n772052D959227121725F77DB97279D61690B5A7F5A1851A5540D547D660E76DF\n8FF792989CF459EA725D6EC5514D68C97DBF7DEC97629EBA64786A2183025984\n5B5F6BDB731B76F27DB280178499513267289ED976EE676252FF99055C24623B\n7C7E8CB0554F60B67D0B958053014E5F51B6591C723A803691CE5F2577E25384\n5F797D0485AC8A338E8D975667F385AE9453610961086CB97652000000000000\n97\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8AED8F38552F4F51512A52C753CB5BA55E7D60A0618263D6670967DA6E676D8C\n733673377531795088D58A98904A909190F596C4878D59154E884F594E0E8A89\n8F3F981050AD5E7C59965BB95EB863DA63FA64C166DC694A69D86D0B6EB67194\n75287AAF7F8A8000844984C989818B218E0A9065967D990A617E62916B320000\n6C836D747FCC7FFC6DC07F8587BA88F8676583B1983C96F76D1B7D61843D916A\n4E7153755D506B046FEB85CD862D89A75229540F5C65674E68A87406748375E2\n88CF88E191CC96E296785F8B73877ACB844E63A0756552896D416E9C74097559\n786B7C9296867ADC9F8D4FB6616E65C5865C4E864EAE50DA4E2151CC5BEE6599\n68816DBC731F764277AD7A1C7CE7826F8AD2907C91CF96759818529B7DD1502B\n539867976DCB71D0743381E88F2A96A39C579E9F746058416D997D2F985E4EE4\n4F364F8B51B752B15DBA601C73B2793C82D3923496B796F6970A9E979F6266A6\n6B74521752A370C888C25EC9604B61906F2371497C3E7DF4806F000000000000\n98\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n84EE9023932C54429B6F6AD370898CC28DEF973252B45A415ECA5F046717697C\n69946D6A6F0F726272FC7BED8001807E874B90CE516D9E937984808B93328AD6\n502D548C8A716B6A8CC4810760D167A09DF24E994E989C108A6B85C185686900\n6E7E789781550000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000005F0C\n4E104E154E2A4E314E364E3C4E3F4E424E564E584E824E858C6B4E8A82125F0D\n4E8E4E9E4E9F4EA04EA24EB04EB34EB64ECE4ECD4EC44EC64EC24ED74EDE4EED\n4EDF4EF74F094F5A4F304F5B4F5D4F574F474F764F884F8F4F984F7B4F694F70\n4F914F6F4F864F9651184FD44FDF4FCE4FD84FDB4FD14FDA4FD04FE44FE5501A\n50285014502A502550054F1C4FF650215029502C4FFE4FEF5011500650435047\n6703505550505048505A5056506C50785080509A508550B450B2000000000000\n99\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n50C950CA50B350C250D650DE50E550ED50E350EE50F950F55109510151025116\n51155114511A5121513A5137513C513B513F51405152514C515451627AF85169\n516A516E5180518256D8518C5189518F519151935195519651A451A651A251A9\n51AA51AB51B351B151B251B051B551BD51C551C951DB51E0865551E951ED0000\n51F051F551FE5204520B5214520E5227522A522E52335239524F5244524B524C\n525E5254526A527452695273527F527D528D529452925271528852918FA88FA7\n52AC52AD52BC52B552C152CD52D752DE52E352E698ED52E052F352F552F852F9\n530653087538530D5310530F5315531A5323532F533153335338534053465345\n4E175349534D51D6535E5369536E5918537B53775382539653A053A653A553AE\n53B053B653C37C1296D953DF66FC71EE53EE53E853ED53FA5401543D5440542C\n542D543C542E54365429541D544E548F5475548E545F5471547754705492547B\n5480547654845490548654C754A254B854A554AC54C454C854A8000000000000\n9A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n54AB54C254A454BE54BC54D854E554E6550F551454FD54EE54ED54FA54E25539\n55405563554C552E555C55455556555755385533555D5599558054AF558A559F\n557B557E5598559E55AE557C558355A9558755A855DA55C555DF55C455DC55E4\n55D4561455F7561655FE55FD561B55F9564E565071DF56345636563256380000\n566B5664562F566C566A56865680568A56A05694568F56A556AE56B656B456C2\n56BC56C156C356C056C856CE56D156D356D756EE56F9570056FF570457095708\n570B570D57135718571655C7571C572657375738574E573B5740574F576957C0\n57885761577F5789579357A057B357A457AA57B057C357C657D457D257D3580A\n57D657E3580B5819581D587258215862584B58706BC05852583D5879588558B9\n589F58AB58BA58DE58BB58B858AE58C558D358D158D758D958D858E558DC58E4\n58DF58EF58FA58F958FB58FC58FD5902590A5910591B68A65925592C592D5932\n5938593E7AD259555950594E595A5958596259605967596C5969000000000000\n9B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n59785981599D4F5E4FAB59A359B259C659E859DC598D59D959DA5A255A1F5A11\n5A1C5A095A1A5A405A6C5A495A355A365A625A6A5A9A5ABC5ABE5ACB5AC25ABD\n5AE35AD75AE65AE95AD65AFA5AFB5B0C5B0B5B165B325AD05B2A5B365B3E5B43\n5B455B405B515B555B5A5B5B5B655B695B705B735B755B7865885B7A5B800000\n5B835BA65BB85BC35BC75BC95BD45BD05BE45BE65BE25BDE5BE55BEB5BF05BF6\n5BF35C055C075C085C0D5C135C205C225C285C385C395C415C465C4E5C535C50\n5C4F5B715C6C5C6E4E625C765C795C8C5C915C94599B5CAB5CBB5CB65CBC5CB7\n5CC55CBE5CC75CD95CE95CFD5CFA5CED5D8C5CEA5D0B5D155D175D5C5D1F5D1B\n5D115D145D225D1A5D195D185D4C5D525D4E5D4B5D6C5D735D765D875D845D82\n5DA25D9D5DAC5DAE5DBD5D905DB75DBC5DC95DCD5DD35DD25DD65DDB5DEB5DF2\n5DF55E0B5E1A5E195E115E1B5E365E375E445E435E405E4E5E575E545E5F5E62\n5E645E475E755E765E7A9EBC5E7F5EA05EC15EC25EC85ED05ECF000000000000\n9C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5ED65EE35EDD5EDA5EDB5EE25EE15EE85EE95EEC5EF15EF35EF05EF45EF85EFE\n5F035F095F5D5F5C5F0B5F115F165F295F2D5F385F415F485F4C5F4E5F2F5F51\n5F565F575F595F615F6D5F735F775F835F825F7F5F8A5F885F915F875F9E5F99\n5F985FA05FA85FAD5FBC5FD65FFB5FE45FF85FF15FDD60B35FFF602160600000\n601960106029600E6031601B6015602B6026600F603A605A6041606A6077605F\n604A6046604D6063604360646042606C606B60596081608D60E76083609A6084\n609B60966097609260A7608B60E160B860E060D360B45FF060BD60C660B560D8\n614D6115610660F660F7610060F460FA6103612160FB60F1610D610E6147613E\n61286127614A613F613C612C6134613D614261446173617761586159615A616B\n6174616F61656171615F615D6153617561996196618761AC6194619A618A6191\n61AB61AE61CC61CA61C961F761C861C361C661BA61CB7F7961CD61E661E361F6\n61FA61F461FF61FD61FC61FE620062086209620D620C6214621B000000000000\n9D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n621E6221622A622E6230623262336241624E625E6263625B62606268627C6282\n6289627E62926293629662D46283629462D762D162BB62CF62FF62C664D462C8\n62DC62CC62CA62C262C7629B62C9630C62EE62F163276302630862EF62F56350\n633E634D641C634F6396638E638063AB637663A3638F6389639F63B5636B0000\n636963BE63E963C063C663E363C963D263F663C4641664346406641364266436\n651D64176428640F6467646F6476644E652A6495649364A564A9648864BC64DA\n64D264C564C764BB64D864C264F164E7820964E064E162AC64E364EF652C64F6\n64F464F264FA650064FD6518651C650565246523652B65346535653765366538\n754B654865566555654D6558655E655D65726578658265838B8A659B659F65AB\n65B765C365C665C165C465CC65D265DB65D965E065E165F16772660A660365FB\n6773663566366634661C664F664466496641665E665D666466676668665F6662\n667066836688668E668966846698669D66C166B966C966BE66BC000000000000\n9E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n66C466B866D666DA66E0663F66E666E966F066F566F7670F6716671E67266727\n9738672E673F67366741673867376746675E67606759676367646789677067A9\n677C676A678C678B67A667A1678567B767EF67B467EC67B367E967B867E467DE\n67DD67E267EE67B967CE67C667E76A9C681E684668296840684D6832684E0000\n68B3682B685968636877687F689F688F68AD6894689D689B68836AAE68B96874\n68B568A068BA690F688D687E690168CA690868D86922692668E1690C68CD68D4\n68E768D569366912690468D768E3692568F968E068EF6928692A691A69236921\n68C669796977695C6978696B6954697E696E69396974693D695969306961695E\n695D6981696A69B269AE69D069BF69C169D369BE69CE5BE869CA69DD69BB69C3\n69A76A2E699169A0699C699569B469DE69E86A026A1B69FF6B0A69F969F269E7\n6A0569B16A1E69ED6A1469EB6A0A6A126AC16A236A136A446A0C6A726A366A78\n6A476A626A596A666A486A386A226A906A8D6AA06A846AA26AA3000000000000\n9F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6A9786176ABB6AC36AC26AB86AB36AAC6ADE6AD16ADF6AAA6ADA6AEA6AFB6B05\n86166AFA6B126B169B316B1F6B386B3776DC6B3998EE6B476B436B496B506B59\n6B546B5B6B5F6B616B786B796B7F6B806B846B836B8D6B986B956B9E6BA46BAA\n6BAB6BAF6BB26BB16BB36BB76BBC6BC66BCB6BD36BDF6BEC6BEB6BF36BEF0000\n9EBE6C086C136C146C1B6C246C236C5E6C556C626C6A6C826C8D6C9A6C816C9B\n6C7E6C686C736C926C906CC46CF16CD36CBD6CD76CC56CDD6CAE6CB16CBE6CBA\n6CDB6CEF6CD96CEA6D1F884D6D366D2B6D3D6D386D196D356D336D126D0C6D63\n6D936D646D5A6D796D596D8E6D956FE46D856DF96E156E0A6DB56DC76DE66DB8\n6DC66DEC6DDE6DCC6DE86DD26DC56DFA6DD96DE46DD56DEA6DEE6E2D6E6E6E2E\n6E196E726E5F6E3E6E236E6B6E2B6E766E4D6E1F6E436E3A6E4E6E246EFF6E1D\n6E386E826EAA6E986EC96EB76ED36EBD6EAF6EC46EB26ED46ED56E8F6EA56EC2\n6E9F6F416F11704C6EEC6EF86EFE6F3F6EF26F316EEF6F326ECC000000000000\nE0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6F3E6F136EF76F866F7A6F786F816F806F6F6F5B6FF36F6D6F826F7C6F586F8E\n6F916FC26F666FB36FA36FA16FA46FB96FC66FAA6FDF6FD56FEC6FD46FD86FF1\n6FEE6FDB7009700B6FFA70117001700F6FFE701B701A6F74701D7018701F7030\n703E7032705170637099709270AF70F170AC70B870B370AE70DF70CB70DD0000\n70D9710970FD711C711971657155718871667162714C7156716C718F71FB7184\n719571A871AC71D771B971BE71D271C971D471CE71E071EC71E771F571FC71F9\n71FF720D7210721B7228722D722C72307232723B723C723F72407246724B7258\n7274727E7282728172877292729672A272A772B972B272C372C672C472CE72D2\n72E272E072E172F972F7500F7317730A731C7316731D7334732F73297325733E\n734E734F9ED87357736A7368737073787375737B737A73C873B373CE73BB73C0\n73E573EE73DE74A27405746F742573F87432743A7455743F745F74597441745C\n746974707463746A7476747E748B749E74A774CA74CF74D473F1000000000000\nE1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n74E074E374E774E974EE74F274F074F174F874F7750475037505750C750E750D\n75157513751E7526752C753C7544754D754A7549755B7546755A756975647567\n756B756D75787576758675877574758A758975827594759A759D75A575A375C2\n75B375C375B575BD75B875BC75B175CD75CA75D275D975E375DE75FE75FF0000\n75FC760175F075FA75F275F3760B760D7609761F762776207621762276247634\n7630763B764776487646765C76587661766276687669766A7667766C76707672\n76767678767C768076837688768B768E769676937699769A76B076B476B876B9\n76BA76C276CD76D676D276DE76E176E576E776EA862F76FB7708770777047729\n7724771E77257726771B773777387747775A7768776B775B7765777F777E7779\n778E778B779177A0779E77B077B677B977BF77BC77BD77BB77C777CD77D777DA\n77DC77E377EE77FC780C781279267820792A7845788E78747886787C789A788C\n78A378B578AA78AF78D178C678CB78D478BE78BC78C578CA78EC000000000000\nE2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n78E778DA78FD78F47907791279117919792C792B794079607957795F795A7955\n7953797A797F798A799D79A79F4B79AA79AE79B379B979BA79C979D579E779EC\n79E179E37A087A0D7A187A197A207A1F79807A317A3B7A3E7A377A437A577A49\n7A617A627A699F9D7A707A797A7D7A887A977A957A987A967AA97AC87AB00000\n7AB67AC57AC47ABF90837AC77ACA7ACD7ACF7AD57AD37AD97ADA7ADD7AE17AE2\n7AE67AED7AF07B027B0F7B0A7B067B337B187B197B1E7B357B287B367B507B7A\n7B047B4D7B0B7B4C7B457B757B657B747B677B707B717B6C7B6E7B9D7B987B9F\n7B8D7B9C7B9A7B8B7B927B8F7B5D7B997BCB7BC17BCC7BCF7BB47BC67BDD7BE9\n7C117C147BE67BE57C607C007C077C137BF37BF77C177C0D7BF67C237C277C2A\n7C1F7C377C2B7C3D7C4C7C437C547C4F7C407C507C587C5F7C647C567C657C6C\n7C757C837C907CA47CAD7CA27CAB7CA17CA87CB37CB27CB17CAE7CB97CBD7CC0\n7CC57CC27CD87CD27CDC7CE29B3B7CEF7CF27CF47CF67CFA7D06000000000000\nE3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7D027D1C7D157D0A7D457D4B7D2E7D327D3F7D357D467D737D567D4E7D727D68\n7D6E7D4F7D637D937D897D5B7D8F7D7D7D9B7DBA7DAE7DA37DB57DC77DBD7DAB\n7E3D7DA27DAF7DDC7DB87D9F7DB07DD87DDD7DE47DDE7DFB7DF27DE17E057E0A\n7E237E217E127E317E1F7E097E0B7E227E467E667E3B7E357E397E437E370000\n7E327E3A7E677E5D7E567E5E7E597E5A7E797E6A7E697E7C7E7B7E837DD57E7D\n8FAE7E7F7E887E897E8C7E927E907E937E947E967E8E7E9B7E9C7F387F3A7F45\n7F4C7F4D7F4E7F507F517F557F547F587F5F7F607F687F697F677F787F827F86\n7F837F887F877F8C7F947F9E7F9D7F9A7FA37FAF7FB27FB97FAE7FB67FB88B71\n7FC57FC67FCA7FD57FD47FE17FE67FE97FF37FF998DC80068004800B80128018\n8019801C80218028803F803B804A804680528058805A805F8062806880738072\n807080768079807D807F808480868085809B8093809A80AD519080AC80DB80E5\n80D980DD80C480DA80D6810980EF80F1811B81298123812F814B000000000000\nE4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n968B8146813E8153815180FC8171816E81658166817481838188818A81808182\n81A0819581A481A3815F819381A981B081B581BE81B881BD81C081C281BA81C9\n81CD81D181D981D881C881DA81DF81E081E781FA81FB81FE8201820282058207\n820A820D821082168229822B82388233824082598258825D825A825F82640000\n82628268826A826B822E827182778278827E828D829282AB829F82BB82AC82E1\n82E382DF82D282F482F382FA8393830382FB82F982DE830682DC830982D98335\n83348316833283318340833983508345832F832B831783188385839A83AA839F\n83A283968323838E8387838A837C83B58373837583A0838983A883F4841383EB\n83CE83FD840383D8840B83C183F7840783E083F2840D8422842083BD84388506\n83FB846D842A843C855A84848477846B84AD846E848284698446842C846F8479\n843584CA846284B984BF849F84D984CD84BB84DA84D084C184C684D684A18521\n84FF84F485178518852C851F8515851484FC8540856385588548000000000000\nE5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n85418602854B8555858085A485888591858A85A8856D8594859B85EA8587859C\n8577857E859085C985BA85CF85B985D085D585DD85E585DC85F9860A8613860B\n85FE85FA86068622861A8630863F864D4E558654865F86678671869386A386A9\n86AA868B868C86B686AF86C486C686B086C9882386AB86D486DE86E986EC0000\n86DF86DB86EF8712870687088700870386FB87118709870D86F9870A8734873F\n8737873B87258729871A8760875F8778874C874E877487578768876E87598753\n8763876A880587A2879F878287AF87CB87BD87C087D096D687AB87C487B387C7\n87C687BB87EF87F287E0880F880D87FE87F687F7880E87D28811881688158822\n88218831883688398827883B8844884288528859885E8862886B8881887E889E\n8875887D88B5887288828897889288AE889988A2888D88A488B088BF88B188C3\n88C488D488D888D988DD88F9890288FC88F488E888F28904890C890A89138943\n891E8925892A892B89418944893B89368938894C891D8960895E000000000000\nE6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n89668964896D896A896F89748977897E89838988898A8993899889A189A989A6\n89AC89AF89B289BA89BD89BF89C089DA89DC89DD89E789F489F88A038A168A10\n8A0C8A1B8A1D8A258A368A418A5B8A528A468A488A7C8A6D8A6C8A628A858A82\n8A848AA88AA18A918AA58AA68A9A8AA38AC48ACD8AC28ADA8AEB8AF38AE70000\n8AE48AF18B148AE08AE28AF78ADE8ADB8B0C8B078B1A8AE18B168B108B178B20\n8B3397AB8B268B2B8B3E8B288B418B4C8B4F8B4E8B498B568B5B8B5A8B6B8B5F\n8B6C8B6F8B748B7D8B808B8C8B8E8B928B938B968B998B9A8C3A8C418C3F8C48\n8C4C8C4E8C508C558C628C6C8C788C7A8C828C898C858C8A8C8D8C8E8C948C7C\n8C98621D8CAD8CAA8CBD8CB28CB38CAE8CB68CC88CC18CE48CE38CDA8CFD8CFA\n8CFB8D048D058D0A8D078D0F8D0D8D109F4E8D138CCD8D148D168D678D6D8D71\n8D738D818D998DC28DBE8DBA8DCF8DDA8DD68DCC8DDB8DCB8DEA8DEB8DDF8DE3\n8DFC8E088E098DFF8E1D8E1E8E108E1F8E428E358E308E348E4A000000000000\nE7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8E478E498E4C8E508E488E598E648E608E2A8E638E558E768E728E7C8E818E87\n8E858E848E8B8E8A8E938E918E948E998EAA8EA18EAC8EB08EC68EB18EBE8EC5\n8EC88ECB8EDB8EE38EFC8EFB8EEB8EFE8F0A8F058F158F128F198F138F1C8F1F\n8F1B8F0C8F268F338F3B8F398F458F428F3E8F4C8F498F468F4E8F578F5C0000\n8F628F638F648F9C8F9F8FA38FAD8FAF8FB78FDA8FE58FE28FEA8FEF90878FF4\n90058FF98FFA901190159021900D901E9016900B90279036903590398FF8904F\n905090519052900E9049903E90569058905E9068906F907696A890729082907D\n90819080908A9089908F90A890AF90B190B590E290E4624890DB910291129119\n91329130914A9156915891639165916991739172918B9189918291A291AB91AF\n91AA91B591B491BA91C091C191C991CB91D091D691DF91E191DB91FC91F591F6\n921E91FF9214922C92159211925E925792459249926492489295923F924B9250\n929C92969293929B925A92CF92B992B792E9930F92FA9344932E000000000000\nE8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n93199322931A9323933A9335933B935C9360937C936E935693B093AC93AD9394\n93B993D693D793E893E593D893C393DD93D093C893E4941A9414941394039407\n94109436942B94359421943A944194529444945B94609462945E946A92299470\n94759477947D945A947C947E9481947F95829587958A95949596959895990000\n95A095A895A795AD95BC95BB95B995BE95CA6FF695C395CD95CC95D595D495D6\n95DC95E195E595E296219628962E962F9642964C964F964B9677965C965E965D\n965F96669672966C968D96989695969796AA96A796B196B296B096B496B696B8\n96B996CE96CB96C996CD894D96DC970D96D596F99704970697089713970E9711\n970F971697199724972A97309739973D973E97449746974897429749975C9760\n97649766976852D2976B977197799785977C9781977A9786978B978F9790979C\n97A897A697A397B397B497C397C697C897CB97DC97ED9F4F97F27ADF97F697F5\n980F980C9838982498219837983D9846984F984B986B986F9870000000000000\nE9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n98719874987398AA98AF98B198B698C498C398C698E998EB9903990999129914\n99189921991D991E99249920992C992E993D993E9942994999459950994B9951\n9952994C99559997999899A599AD99AE99BC99DF99DB99DD99D899D199ED99EE\n99F199F299FB99F89A019A0F9A0599E29A199A2B9A379A459A429A409A430000\n9A3E9A559A4D9A5B9A579A5F9A629A659A649A699A6B9A6A9AAD9AB09ABC9AC0\n9ACF9AD19AD39AD49ADE9ADF9AE29AE39AE69AEF9AEB9AEE9AF49AF19AF79AFB\n9B069B189B1A9B1F9B229B239B259B279B289B299B2A9B2E9B2F9B329B449B43\n9B4F9B4D9B4E9B519B589B749B939B839B919B969B979B9F9BA09BA89BB49BC0\n9BCA9BB99BC69BCF9BD19BD29BE39BE29BE49BD49BE19C3A9BF29BF19BF09C15\n9C149C099C139C0C9C069C089C129C0A9C049C2E9C1B9C259C249C219C309C47\n9C329C469C3E9C5A9C609C679C769C789CE79CEC9CF09D099D089CEB9D039D06\n9D2A9D269DAF9D239D1F9D449D159D129D419D3F9D3E9D469D48000000000000\nEA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9D5D9D5E9D649D519D509D599D729D899D879DAB9D6F9D7A9D9A9DA49DA99DB2\n9DC49DC19DBB9DB89DBA9DC69DCF9DC29DD99DD39DF89DE69DED9DEF9DFD9E1A\n9E1B9E1E9E759E799E7D9E819E889E8B9E8C9E929E959E919E9D9EA59EA99EB8\n9EAA9EAD97619ECC9ECE9ECF9ED09ED49EDC9EDE9EDD9EE09EE59EE89EEF0000\n9EF49EF69EF79EF99EFB9EFC9EFD9F079F0876B79F159F219F2C9F3E9F4A9F52\n9F549F639F5F9F609F619F669F679F6C9F6A9F779F729F769F959F9C9FA0582F\n69C79059746451DC719900000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nED\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7E8A891C9348928884DC4FC970BB663168C892F966FB5F454E284EE14EFC4F00\n4F034F394F564F924F8A4F9A4F944FCD504050224FFF501E5046507050425094\n50F450D8514A5164519D51BE51EC5215529C52A652C052DB5300530753245372\n539353B253DDFA0E549C548A54A954FF55865759576557AC57C857C7FA0F0000\nFA10589E58B2590B5953595B595D596359A459BA5B565BC0752F5BD85BEC5C1E\n5CA65CBA5CF55D275D53FA115D425D6D5DB85DB95DD05F215F345F675FB75FDE\n605D6085608A60DE60D5612060F26111613761306198621362A663F56460649D\n64CE654E66006615663B6609662E661E6624666566576659FA126673669966A0\n66B266BF66FA670EF929676667BB685267C06801684468CFFA136968FA146998\n69E26A306A6B6A466A736A7E6AE26AE46BD66C3F6C5C6C866C6F6CDA6D046D87\n6D6F6D966DAC6DCF6DF86DF26DFC6E396E5C6E276E3C6EBF6F886FB56FF57005\n70077028708570AB710F7104715C71467147FA1571C171FE72B1000000000000\nEE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n72BE7324FA16737773BD73C973D673E373D2740773F57426742A7429742E7462\n7489749F7501756F7682769C769E769B76A6FA17774652AF7821784E7864787A\n7930FA18FA19FA1A7994FA1B799B7AD17AE7FA1C7AEB7B9EFA1D7D487D5C7DB7\n7DA07DD67E527F477FA1FA1E83018362837F83C783F6844884B4855385590000\n856BFA1F85B0FA20FA21880788F58A128A378A798AA78ABE8ADFFA228AF68B53\n8B7F8CF08CF48D128D76FA238ECFFA24FA25906790DEFA269115912791DA91D7\n91DE91ED91EE91E491E592069210920A923A9240923C924E9259925192399267\n92A79277927892E792D792D992D0FA2792D592E092D39325932192FBFA28931E\n92FF931D93029370935793A493C693DE93F89431944594489592F9DCFA29969D\n96AF9733973B9743974D974F9751975598579865FA2AFA2B9927FA2C999E9A4E\n9AD99ADC9B759B729B8F9BB19BBB9C009D709D6BFA2D9E199ED1000000002170\n217121722173217421752176217721782179FFE2FFE4FF07FF02000000000000\nFA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n2170217121722173217421752176217721782179216021612162216321642165\n2166216721682169FFE2FFE4FF07FF0232312116212122357E8A891C93489288\n84DC4FC970BB663168C892F966FB5F454E284EE14EFC4F004F034F394F564F92\n4F8A4F9A4F944FCD504050224FFF501E504650705042509450F450D8514A0000\n5164519D51BE51EC5215529C52A652C052DB5300530753245372539353B253DD\nFA0E549C548A54A954FF55865759576557AC57C857C7FA0FFA10589E58B2590B\n5953595B595D596359A459BA5B565BC0752F5BD85BEC5C1E5CA65CBA5CF55D27\n5D53FA115D425D6D5DB85DB95DD05F215F345F675FB75FDE605D6085608A60DE\n60D5612060F26111613761306198621362A663F56460649D64CE654E66006615\n663B6609662E661E6624666566576659FA126673669966A066B266BF66FA670E\nF929676667BB685267C06801684468CFFA136968FA14699869E26A306A6B6A46\n6A736A7E6AE26AE46BD66C3F6C5C6C866C6F6CDA6D046D876D6F000000000000\nFB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6D966DAC6DCF6DF86DF26DFC6E396E5C6E276E3C6EBF6F886FB56FF570057007\n7028708570AB710F7104715C71467147FA1571C171FE72B172BE7324FA167377\n73BD73C973D673E373D2740773F57426742A7429742E74627489749F7501756F\n7682769C769E769B76A6FA17774652AF7821784E7864787A7930FA18FA190000\nFA1A7994FA1B799B7AD17AE7FA1C7AEB7B9EFA1D7D487D5C7DB77DA07DD67E52\n7F477FA1FA1E83018362837F83C783F6844884B485538559856BFA1F85B0FA20\nFA21880788F58A128A378A798AA78ABE8ADFFA228AF68B538B7F8CF08CF48D12\n8D76FA238ECFFA24FA25906790DEFA269115912791DA91D791DE91ED91EE91E4\n91E592069210920A923A9240923C924E925992519239926792A79277927892E7\n92D792D992D0FA2792D592E092D39325932192FBFA28931E92FF931D93029370\n935793A493C693DE93F89431944594489592F9DCFA29969D96AF9733973B9743\n974D974F9751975598579865FA2AFA2B9927FA2C999E9A4E9AD9000000000000\nFC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9ADC9B759B729B8F9BB19BBB9C009D709D6BFA2D9E199ED10000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nR\n8160 301C FF5E\n8161 2016 2225\n817C 2212 FF0D\n8191 00A2 FFE0\n8192 00A3 FFE1\n81CA 00AC FFE2\n81BE 222a\n81BF 2229\n81DA 2220\n81DB 22a5\n81DF 2261\n81E0 2252\n81E3 221a\n81E6 2235\n81E7 222b\n",
		"/encoding/cp936.enc":                      "# Encoding file: cp936, multi-byte\nM\n003F 0 127\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n20AC000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n81\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4E024E044E054E064E0F4E124E174E1F4E204E214E234E264E294E2E4E2F4E31\n4E334E354E374E3C4E404E414E424E444E464E4A4E514E554E574E5A4E5B4E62\n4E634E644E654E674E684E6A4E6B4E6C4E6D4E6E4E6F4E724E744E754E764E77\n4E784E794E7A4E7B4E7C4E7D4E7F4E804E814E824E834E844E854E874E8A0000\n4E904E964E974E994E9C4E9D4E9E4EA34EAA4EAF4EB04EB14EB44EB64EB74EB8\n4EB94EBC4EBD4EBE4EC84ECC4ECF4ED04ED24EDA4EDB4EDC4EE04EE24EE64EE7\n4EE94EED4EEE4EEF4EF14EF44EF84EF94EFA4EFC4EFE4F004F024F034F044F05\n4F064F074F084F0B4F0C4F124F134F144F154F164F1C4F1D4F214F234F284F29\n4F2C4F2D4F2E4F314F334F354F374F394F3B4F3E4F3F4F404F414F424F444F45\n4F474F484F494F4A4F4B4F4C4F524F544F564F614F624F664F684F6A4F6B4F6D\n4F6E4F714F724F754F774F784F794F7A4F7D4F804F814F824F854F864F874F8A\n4F8C4F8E4F904F924F934F954F964F984F994F9A4F9C4F9E4F9F4FA14FA20000\n82\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4FA44FAB4FAD4FB04FB14FB24FB34FB44FB64FB74FB84FB94FBA4FBB4FBC4FBD\n4FBE4FC04FC14FC24FC64FC74FC84FC94FCB4FCC4FCD4FD24FD34FD44FD54FD6\n4FD94FDB4FE04FE24FE44FE54FE74FEB4FEC4FF04FF24FF44FF54FF64FF74FF9\n4FFB4FFC4FFD4FFF5000500150025003500450055006500750085009500A0000\n500B500E501050115013501550165017501B501D501E50205022502350245027\n502B502F5030503150325033503450355036503750385039503B503D503F5040\n504150425044504550465049504A504B504D5050505150525053505450565057\n50585059505B505D505E505F506050615062506350645066506750685069506A\n506B506D506E506F50705071507250735074507550785079507A507C507D5081\n508250835084508650875089508A508B508C508E508F50905091509250935094\n50955096509750985099509A509B509C509D509E509F50A050A150A250A450A6\n50AA50AB50AD50AE50AF50B050B150B350B450B550B650B750B850B950BC0000\n83\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n50BD50BE50BF50C050C150C250C350C450C550C650C750C850C950CA50CB50CC\n50CD50CE50D050D150D250D350D450D550D750D850D950DB50DC50DD50DE50DF\n50E050E150E250E350E450E550E850E950EA50EB50EF50F050F150F250F450F6\n50F750F850F950FA50FC50FD50FE50FF51005101510251035104510551080000\n5109510A510C510D510E510F511051115113511451155116511751185119511A\n511B511C511D511E511F512051225123512451255126512751285129512A512B\n512C512D512E512F5130513151325133513451355136513751385139513A513B\n513C513D513E51425147514A514C514E514F515051525153515751585159515B\n515D515E515F5160516151635164516651675169516A516F5172517A517E517F\n5183518451865187518A518B518E518F51905191519351945198519A519D519E\n519F51A151A351A651A751A851A951AA51AD51AE51B451B851B951BA51BE51BF\n51C151C251C351C551C851CA51CD51CE51D051D251D351D451D551D651D70000\n84\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n51D851D951DA51DC51DE51DF51E251E351E551E651E751E851E951EA51EC51EE\n51F151F251F451F751FE520452055209520B520C520F5210521352145215521C\n521E521F522152225223522552265227522A522C522F5231523252345235523C\n523E524452455246524752485249524B524E524F525252535255525752580000\n5259525A525B525D525F526052625263526452665268526B526C526D526E5270\n52715273527452755276527752785279527A527B527C527E5280528352845285\n528652875289528A528B528C528D528E528F5291529252945295529652975298\n5299529A529C52A452A552A652A752AE52AF52B052B452B552B652B752B852B9\n52BA52BB52BC52BD52C052C152C252C452C552C652C852CA52CC52CD52CE52CF\n52D152D352D452D552D752D952DA52DB52DC52DD52DE52E052E152E252E352E5\n52E652E752E852E952EA52EB52EC52ED52EE52EF52F152F252F352F452F552F6\n52F752F852FB52FC52FD530153025303530453075309530A530B530C530E0000\n85\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n53115312531353145318531B531C531E531F532253245325532753285329532B\n532C532D532F533053315332533353345335533653375338533C533D53405342\n53445346534B534C534D5350535453585359535B535D53655368536A536C536D\n537253765379537B537C537D537E53805381538353875388538A538E538F0000\n53905391539253935394539653975399539B539C539E53A053A153A453A753AA\n53AB53AC53AD53AF53B053B153B253B353B453B553B753B853B953BA53BC53BD\n53BE53C053C353C453C553C653C753CE53CF53D053D253D353D553DA53DC53DD\n53DE53E153E253E753F453FA53FE53FF5400540254055407540B541454185419\n541A541C542254245425542A5430543354365437543A543D543F544154425444\n544554475449544C544D544E544F5451545A545D545E545F5460546154635465\n54675469546A546B546C546D546E546F547054745479547A547E547F54815483\n5485548754885489548A548D5491549354975498549C549E549F54A054A10000\n86\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n54A254A554AE54B054B254B554B654B754B954BA54BC54BE54C354C554CA54CB\n54D654D854DB54E054E154E254E354E454EB54EC54EF54F054F154F454F554F6\n54F754F854F954FB54FE550055025503550455055508550A550B550C550D550E\n5512551355155516551755185519551A551C551D551E551F5521552555260000\n55285529552B552D553255345535553655385539553A553B553D554055425545\n55475548554B554C554D554E554F5551555255535554555755585559555A555B\n555D555E555F55605562556355685569556B556F557055715572557355745579\n557A557D557F55855586558C558D558E559055925593559555965597559A559B\n559E55A055A155A255A355A455A555A655A855A955AA55AB55AC55AD55AE55AF\n55B055B255B455B655B855BA55BC55BF55C055C155C255C355C655C755C855CA\n55CB55CE55CF55D055D555D755D855D955DA55DB55DE55E055E255E755E955ED\n55EE55F055F155F455F655F855F955FA55FB55FC55FF56025603560456050000\n87\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n56065607560A560B560D561056115612561356145615561656175619561A561C\n561D5620562156225625562656285629562A562B562E562F5630563356355637\n5638563A563C563D563E5640564156425643564456455646564756485649564A\n564B564F565056515652565356555656565A565B565D565E565F566056610000\n5663566556665667566D566E566F56705672567356745675567756785679567A\n567D567E567F56805681568256835684568756885689568A568B568C568D5690\n56915692569456955696569756985699569A569B569C569D569E569F56A056A1\n56A256A456A556A656A756A856A956AA56AB56AC56AD56AE56B056B156B256B3\n56B456B556B656B856B956BA56BB56BD56BE56BF56C056C156C256C356C456C5\n56C656C756C856C956CB56CC56CD56CE56CF56D056D156D256D356D556D656D8\n56D956DC56E356E556E656E756E856E956EA56EC56EE56EF56F256F356F656F7\n56F856FB56FC57005701570257055707570B570C570D570E570F571057110000\n88\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n57125713571457155716571757185719571A571B571D571E5720572157225724\n572557265727572B5731573257345735573657375738573C573D573F57415743\n57445745574657485749574B5752575357545755575657585759576257635765\n5767576C576E5770577157725774577557785779577A577D577E577F57800000\n5781578757885789578A578D578E578F57905791579457955796579757985799\n579A579C579D579E579F57A557A857AA57AC57AF57B057B157B357B557B657B7\n57B957BA57BB57BC57BD57BE57BF57C057C157C457C557C657C757C857C957CA\n57CC57CD57D057D157D357D657D757DB57DC57DE57E157E257E357E557E657E7\n57E857E957EA57EB57EC57EE57F057F157F257F357F557F657F757FB57FC57FE\n57FF580158035804580558085809580A580C580E580F58105812581358145816\n58175818581A581B581C581D581F5822582358255826582758285829582B582C\n582D582E582F58315832583358345836583758385839583A583B583C583D0000\n89\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n583E583F584058415842584358455846584758485849584A584B584E584F5850\n585258535855585658575859585A585B585C585D585F58605861586258635864\n5866586758685869586A586D586E586F58705871587258735874587558765877\n58785879587A587B587C587D587F58825884588658875888588A588B588C0000\n588D588E588F5890589158945895589658975898589B589C589D58A058A158A2\n58A358A458A558A658A758AA58AB58AC58AD58AE58AF58B058B158B258B358B4\n58B558B658B758B858B958BA58BB58BD58BE58BF58C058C258C358C458C658C7\n58C858C958CA58CB58CC58CD58CE58CF58D058D258D358D458D658D758D858D9\n58DA58DB58DC58DD58DE58DF58E058E158E258E358E558E658E758E858E958EA\n58ED58EF58F158F258F458F558F758F858FA58FB58FC58FD58FE58FF59005901\n59035905590659085909590A590B590C590E591059115912591359175918591B\n591D591E592059215922592359265928592C59305932593359355936593B0000\n8A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n593D593E593F5940594359455946594A594C594D5950595259535959595B595C\n595D595E595F5961596359645966596759685969596A596B596C596D596E596F\n59705971597259755977597A597B597C597E597F598059855989598B598C598E\n598F59905991599459955998599A599B599C599D599F59A059A159A259A60000\n59A759AC59AD59B059B159B359B459B559B659B759B859BA59BC59BD59BF59C0\n59C159C259C359C459C559C759C859C959CC59CD59CE59CF59D559D659D959DB\n59DE59DF59E059E159E259E459E659E759E959EA59EB59ED59EE59EF59F059F1\n59F259F359F459F559F659F759F859FA59FC59FD59FE5A005A025A0A5A0B5A0D\n5A0E5A0F5A105A125A145A155A165A175A195A1A5A1B5A1D5A1E5A215A225A24\n5A265A275A285A2A5A2B5A2C5A2D5A2E5A2F5A305A335A355A375A385A395A3A\n5A3B5A3D5A3E5A3F5A415A425A435A445A455A475A485A4B5A4C5A4D5A4E5A4F\n5A505A515A525A535A545A565A575A585A595A5B5A5C5A5D5A5E5A5F5A600000\n8B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5A615A635A645A655A665A685A695A6B5A6C5A6D5A6E5A6F5A705A715A725A73\n5A785A795A7B5A7C5A7D5A7E5A805A815A825A835A845A855A865A875A885A89\n5A8A5A8B5A8C5A8D5A8E5A8F5A905A915A935A945A955A965A975A985A995A9C\n5A9D5A9E5A9F5AA05AA15AA25AA35AA45AA55AA65AA75AA85AA95AAB5AAC0000\n5AAD5AAE5AAF5AB05AB15AB45AB65AB75AB95ABA5ABB5ABC5ABD5ABF5AC05AC3\n5AC45AC55AC65AC75AC85ACA5ACB5ACD5ACE5ACF5AD05AD15AD35AD55AD75AD9\n5ADA5ADB5ADD5ADE5ADF5AE25AE45AE55AE75AE85AEA5AEC5AED5AEE5AEF5AF0\n5AF25AF35AF45AF55AF65AF75AF85AF95AFA5AFB5AFC5AFD5AFE5AFF5B005B01\n5B025B035B045B055B065B075B085B0A5B0B5B0C5B0D5B0E5B0F5B105B115B12\n5B135B145B155B185B195B1A5B1B5B1C5B1D5B1E5B1F5B205B215B225B235B24\n5B255B265B275B285B295B2A5B2B5B2C5B2D5B2E5B2F5B305B315B335B355B36\n5B385B395B3A5B3B5B3C5B3D5B3E5B3F5B415B425B435B445B455B465B470000\n8C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5B485B495B4A5B4B5B4C5B4D5B4E5B4F5B525B565B5E5B605B615B675B685B6B\n5B6D5B6E5B6F5B725B745B765B775B785B795B7B5B7C5B7E5B7F5B825B865B8A\n5B8D5B8E5B905B915B925B945B965B9F5BA75BA85BA95BAC5BAD5BAE5BAF5BB1\n5BB25BB75BBA5BBB5BBC5BC05BC15BC35BC85BC95BCA5BCB5BCD5BCE5BCF0000\n5BD15BD45BD55BD65BD75BD85BD95BDA5BDB5BDC5BE05BE25BE35BE65BE75BE9\n5BEA5BEB5BEC5BED5BEF5BF15BF25BF35BF45BF55BF65BF75BFD5BFE5C005C02\n5C035C055C075C085C0B5C0C5C0D5C0E5C105C125C135C175C195C1B5C1E5C1F\n5C205C215C235C265C285C295C2A5C2B5C2D5C2E5C2F5C305C325C335C355C36\n5C375C435C445C465C475C4C5C4D5C525C535C545C565C575C585C5A5C5B5C5C\n5C5D5C5F5C625C645C675C685C695C6A5C6B5C6C5C6D5C705C725C735C745C75\n5C765C775C785C7B5C7C5C7D5C7E5C805C835C845C855C865C875C895C8A5C8B\n5C8E5C8F5C925C935C955C9D5C9E5C9F5CA05CA15CA45CA55CA65CA75CA80000\n8D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5CAA5CAE5CAF5CB05CB25CB45CB65CB95CBA5CBB5CBC5CBE5CC05CC25CC35CC5\n5CC65CC75CC85CC95CCA5CCC5CCD5CCE5CCF5CD05CD15CD35CD45CD55CD65CD7\n5CD85CDA5CDB5CDC5CDD5CDE5CDF5CE05CE25CE35CE75CE95CEB5CEC5CEE5CEF\n5CF15CF25CF35CF45CF55CF65CF75CF85CF95CFA5CFC5CFD5CFE5CFF5D000000\n5D015D045D055D085D095D0A5D0B5D0C5D0D5D0F5D105D115D125D135D155D17\n5D185D195D1A5D1C5D1D5D1F5D205D215D225D235D255D285D2A5D2B5D2C5D2F\n5D305D315D325D335D355D365D375D385D395D3A5D3B5D3C5D3F5D405D415D42\n5D435D445D455D465D485D495D4D5D4E5D4F5D505D515D525D535D545D555D56\n5D575D595D5A5D5C5D5E5D5F5D605D615D625D635D645D655D665D675D685D6A\n5D6D5D6E5D705D715D725D735D755D765D775D785D795D7A5D7B5D7C5D7D5D7E\n5D7F5D805D815D835D845D855D865D875D885D895D8A5D8B5D8C5D8D5D8E5D8F\n5D905D915D925D935D945D955D965D975D985D9A5D9B5D9C5D9E5D9F5DA00000\n8E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5DA15DA25DA35DA45DA55DA65DA75DA85DA95DAA5DAB5DAC5DAD5DAE5DAF5DB0\n5DB15DB25DB35DB45DB55DB65DB85DB95DBA5DBB5DBC5DBD5DBE5DBF5DC05DC1\n5DC25DC35DC45DC65DC75DC85DC95DCA5DCB5DCC5DCE5DCF5DD05DD15DD25DD3\n5DD45DD55DD65DD75DD85DD95DDA5DDC5DDF5DE05DE35DE45DEA5DEC5DED0000\n5DF05DF55DF65DF85DF95DFA5DFB5DFC5DFF5E005E045E075E095E0A5E0B5E0D\n5E0E5E125E135E175E1E5E1F5E205E215E225E235E245E255E285E295E2A5E2B\n5E2C5E2F5E305E325E335E345E355E365E395E3A5E3E5E3F5E405E415E435E46\n5E475E485E495E4A5E4B5E4D5E4E5E4F5E505E515E525E535E565E575E585E59\n5E5A5E5C5E5D5E5F5E605E635E645E655E665E675E685E695E6A5E6B5E6C5E6D\n5E6E5E6F5E705E715E755E775E795E7E5E815E825E835E855E885E895E8C5E8D\n5E8E5E925E985E9B5E9D5EA15EA25EA35EA45EA85EA95EAA5EAB5EAC5EAE5EAF\n5EB05EB15EB25EB45EBA5EBB5EBC5EBD5EBF5EC05EC15EC25EC35EC45EC50000\n8F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5EC65EC75EC85ECB5ECC5ECD5ECE5ECF5ED05ED45ED55ED75ED85ED95EDA5EDC\n5EDD5EDE5EDF5EE05EE15EE25EE35EE45EE55EE65EE75EE95EEB5EEC5EED5EEE\n5EEF5EF05EF15EF25EF35EF55EF85EF95EFB5EFC5EFD5F055F065F075F095F0C\n5F0D5F0E5F105F125F145F165F195F1A5F1C5F1D5F1E5F215F225F235F240000\n5F285F2B5F2C5F2E5F305F325F335F345F355F365F375F385F3B5F3D5F3E5F3F\n5F415F425F435F445F455F465F475F485F495F4A5F4B5F4C5F4D5F4E5F4F5F51\n5F545F595F5A5F5B5F5C5F5E5F5F5F605F635F655F675F685F6B5F6E5F6F5F72\n5F745F755F765F785F7A5F7D5F7E5F7F5F835F865F8D5F8E5F8F5F915F935F94\n5F965F9A5F9B5F9D5F9E5F9F5FA05FA25FA35FA45FA55FA65FA75FA95FAB5FAC\n5FAF5FB05FB15FB25FB35FB45FB65FB85FB95FBA5FBB5FBE5FBF5FC05FC15FC2\n5FC75FC85FCA5FCB5FCE5FD35FD45FD55FDA5FDB5FDC5FDE5FDF5FE25FE35FE5\n5FE65FE85FE95FEC5FEF5FF05FF25FF35FF45FF65FF75FF95FFA5FFC60070000\n90\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n60086009600B600C60106011601360176018601A601E601F602260236024602C\n602D602E603060316032603360346036603760386039603A603D603E60406044\n60456046604760486049604A604C604E604F605160536054605660576058605B\n605C605E605F6060606160656066606E60716072607460756077607E60800000\n608160826085608660876088608A608B608E608F609060916093609560976098\n6099609C609E60A160A260A460A560A760A960AA60AE60B060B360B560B660B7\n60B960BA60BD60BE60BF60C060C160C260C360C460C760C860C960CC60CD60CE\n60CF60D060D260D360D460D660D760D960DB60DE60E160E260E360E460E560EA\n60F160F260F560F760F860FB60FC60FD60FE60FF61026103610461056107610A\n610B610C611061116112611361146116611761186119611B611C611D611E6121\n6122612561286129612A612C612D612E612F6130613161326133613461356136\n613761386139613A613B613C613D613E61406141614261436144614561460000\n91\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n61476149614B614D614F61506152615361546156615761586159615A615B615C\n615E615F6160616161636164616561666169616A616B616C616D616E616F6171\n617261736174617661786179617A617B617C617D617E617F6180618161826183\n618461856186618761886189618A618C618D618F619061916192619361950000\n6196619761986199619A619B619C619E619F61A061A161A261A361A461A561A6\n61AA61AB61AD61AE61AF61B061B161B261B361B461B561B661B861B961BA61BB\n61BC61BD61BF61C061C161C361C461C561C661C761C961CC61CD61CE61CF61D0\n61D361D561D661D761D861D961DA61DB61DC61DD61DE61DF61E061E161E261E3\n61E461E561E761E861E961EA61EB61EC61ED61EE61EF61F061F161F261F361F4\n61F661F761F861F961FA61FB61FC61FD61FE6200620162026203620462056207\n6209621362146219621C621D621E622062236226622762286229622B622D622F\n6230623162326235623662386239623A623B623C6242624462456246624A0000\n92\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n624F62506255625662576259625A625C625D625E625F62606261626262646265\n6268627162726274627562776278627A627B627D628162826283628562866287\n6288628B628C628D628E628F629062946299629C629D629E62A362A662A762A9\n62AA62AD62AE62AF62B062B262B362B462B662B762B862BA62BE62C062C10000\n62C362CB62CF62D162D562DD62DE62E062E162E462EA62EB62F062F262F562F8\n62F962FA62FB63006303630463056306630A630B630C630D630F631063126313\n63146315631763186319631C632663276329632C632D632E6330633163336334\n6335633663376338633B633C633E633F63406341634463476348634A63516352\n635363546356635763586359635A635B635C635D63606364636563666368636A\n636B636C636F6370637263736374637563786379637C637D637E637F63816383\n638463856386638B638D639163936394639563976399639A639B639C639D639E\n639F63A163A463A663AB63AF63B163B263B563B663B963BB63BD63BF63C00000\n93\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n63C163C263C363C563C763C863CA63CB63CC63D163D363D463D563D763D863D9\n63DA63DB63DC63DD63DF63E263E463E563E663E763E863EB63EC63EE63EF63F0\n63F163F363F563F763F963FA63FB63FC63FE640364046406640764086409640A\n640D640E6411641264156416641764186419641A641D641F6422642364240000\n6425642764286429642B642E642F643064316432643364356436643764386439\n643B643C643E6440644264436449644B644C644D644E644F6450645164536455\n645664576459645A645B645C645D645F64606461646264636464646564666468\n646A646B646C646E646F64706471647264736474647564766477647B647C647D\n647E647F648064816483648664886489648A648B648C648D648E648F64906493\n649464976498649A649B649C649D649F64A064A164A264A364A564A664A764A8\n64AA64AB64AF64B164B264B364B464B664B964BB64BD64BE64BF64C164C364C4\n64C664C764C864C964CA64CB64CC64CF64D164D364D464D564D664D964DA0000\n94\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n64DB64DC64DD64DF64E064E164E364E564E764E864E964EA64EB64EC64ED64EE\n64EF64F064F164F264F364F464F564F664F764F864F964FA64FB64FC64FD64FE\n64FF65016502650365046505650665076508650A650B650C650D650E650F6510\n6511651365146515651665176519651A651B651C651D651E651F652065210000\n6522652365246526652765286529652A652C652D65306531653265336537653A\n653C653D6540654165426543654465466547654A654B654D654E655065526553\n655465576558655A655C655F6560656165646565656765686569656A656D656E\n656F657165736575657665786579657A657B657C657D657E657F658065816582\n658365846585658665886589658A658D658E658F65926594659565966598659A\n659D659E65A065A265A365A665A865AA65AC65AE65B165B265B365B465B565B6\n65B765B865BA65BB65BE65BF65C065C265C765C865C965CA65CD65D065D165D3\n65D465D565D865D965DA65DB65DC65DD65DE65DF65E165E365E465EA65EB0000\n95\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n65F265F365F465F565F865F965FB65FC65FD65FE65FF66016604660566076608\n6609660B660D661066116612661666176618661A661B661C661E662166226623\n662466266629662A662B662C662E663066326633663766386639663A663B663D\n663F66406642664466456646664766486649664A664D664E6650665166580000\n6659665B665C665D665E666066626663666566676669666A666B666C666D6671\n66726673667566786679667B667C667D667F6680668166836685668666886689\n668A668B668D668E668F6690669266936694669566986699669A669B669C669E\n669F66A066A166A266A366A466A566A666A966AA66AB66AC66AD66AF66B066B1\n66B266B366B566B666B766B866BA66BB66BC66BD66BF66C066C166C266C366C4\n66C566C666C766C866C966CA66CB66CC66CD66CE66CF66D066D166D266D366D4\n66D566D666D766D866DA66DE66DF66E066E166E266E366E466E566E766E866EA\n66EB66EC66ED66EE66EF66F166F566F666F866FA66FB66FD6701670267030000\n96\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6704670567066707670C670E670F671167126713671667186719671A671C671E\n67206721672267236724672567276729672E6730673267336736673767386739\n673B673C673E673F6741674467456747674A674B674D67526754675567576758\n6759675A675B675D67626763676467666767676B676C676E6771677467760000\n67786779677A677B677D678067826783678567866788678A678C678D678E678F\n679167926793679467966799679B679F67A067A167A467A667A967AC67AE67B1\n67B267B467B967BA67BB67BC67BD67BE67BF67C067C267C567C667C767C867C9\n67CA67CB67CC67CD67CE67D567D667D767DB67DF67E167E367E467E667E767E8\n67EA67EB67ED67EE67F267F567F667F767F867F967FA67FB67FC67FE68016802\n680368046806680D681068126814681568186819681A681B681C681E681F6820\n6822682368246825682668276828682B682C682D682E682F6830683168346835\n6836683A683B683F6847684B684D684F68526856685768586859685A685B0000\n97\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n685C685D685E685F686A686C686D686E686F6870687168726873687568786879\n687A687B687C687D687E687F688068826884688768886889688A688B688C688D\n688E68906891689268946895689668986899689A689B689C689D689E689F68A0\n68A168A368A468A568A968AA68AB68AC68AE68B168B268B468B668B768B80000\n68B968BA68BB68BC68BD68BE68BF68C168C368C468C568C668C768C868CA68CC\n68CE68CF68D068D168D368D468D668D768D968DB68DC68DD68DE68DF68E168E2\n68E468E568E668E768E868E968EA68EB68EC68ED68EF68F268F368F468F668F7\n68F868FB68FD68FE68FF69006902690369046906690769086909690A690C690F\n69116913691469156916691769186919691A691B691C691D691E692169226923\n69256926692769286929692A692B692C692E692F693169326933693569366937\n6938693A693B693C693E694069416943694469456946694769486949694A694B\n694C694D694E694F69506951695269536955695669586959695B695C695F0000\n98\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6961696269646965696769686969696A696C696D696F69706972697369746975\n6976697A697B697D697E697F698169836985698A698B698C698E698F69906991\n69926993699669976999699A699D699E699F69A069A169A269A369A469A569A6\n69A969AA69AC69AE69AF69B069B269B369B569B669B869B969BA69BC69BD0000\n69BE69BF69C069C269C369C469C569C669C769C869C969CB69CD69CF69D169D2\n69D369D569D669D769D869D969DA69DC69DD69DE69E169E269E369E469E569E6\n69E769E869E969EA69EB69EC69EE69EF69F069F169F369F469F569F669F769F8\n69F969FA69FB69FC69FE6A006A016A026A036A046A056A066A076A086A096A0B\n6A0C6A0D6A0E6A0F6A106A116A126A136A146A156A166A196A1A6A1B6A1C6A1D\n6A1E6A206A226A236A246A256A266A276A296A2B6A2C6A2D6A2E6A306A326A33\n6A346A366A376A386A396A3A6A3B6A3C6A3F6A406A416A426A436A456A466A48\n6A496A4A6A4B6A4C6A4D6A4E6A4F6A516A526A536A546A556A566A576A5A0000\n99\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6A5C6A5D6A5E6A5F6A606A626A636A646A666A676A686A696A6A6A6B6A6C6A6D\n6A6E6A6F6A706A726A736A746A756A766A776A786A7A6A7B6A7D6A7E6A7F6A81\n6A826A836A856A866A876A886A896A8A6A8B6A8C6A8D6A8F6A926A936A946A95\n6A966A986A996A9A6A9B6A9C6A9D6A9E6A9F6AA16AA26AA36AA46AA56AA60000\n6AA76AA86AAA6AAD6AAE6AAF6AB06AB16AB26AB36AB46AB56AB66AB76AB86AB9\n6ABA6ABB6ABC6ABD6ABE6ABF6AC06AC16AC26AC36AC46AC56AC66AC76AC86AC9\n6ACA6ACB6ACC6ACD6ACE6ACF6AD06AD16AD26AD36AD46AD56AD66AD76AD86AD9\n6ADA6ADB6ADC6ADD6ADE6ADF6AE06AE16AE26AE36AE46AE56AE66AE76AE86AE9\n6AEA6AEB6AEC6AED6AEE6AEF6AF06AF16AF26AF36AF46AF56AF66AF76AF86AF9\n6AFA6AFB6AFC6AFD6AFE6AFF6B006B016B026B036B046B056B066B076B086B09\n6B0A6B0B6B0C6B0D6B0E6B0F6B106B116B126B136B146B156B166B176B186B19\n6B1A6B1B6B1C6B1D6B1E6B1F6B256B266B286B296B2A6B2B6B2C6B2D6B2E0000\n9A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6B2F6B306B316B336B346B356B366B386B3B6B3C6B3D6B3F6B406B416B426B44\n6B456B486B4A6B4B6B4D6B4E6B4F6B506B516B526B536B546B556B566B576B58\n6B5A6B5B6B5C6B5D6B5E6B5F6B606B616B686B696B6B6B6C6B6D6B6E6B6F6B70\n6B716B726B736B746B756B766B776B786B7A6B7D6B7E6B7F6B806B856B880000\n6B8C6B8E6B8F6B906B916B946B956B976B986B996B9C6B9D6B9E6B9F6BA06BA2\n6BA36BA46BA56BA66BA76BA86BA96BAB6BAC6BAD6BAE6BAF6BB06BB16BB26BB6\n6BB86BB96BBA6BBB6BBC6BBD6BBE6BC06BC36BC46BC66BC76BC86BC96BCA6BCC\n6BCE6BD06BD16BD86BDA6BDC6BDD6BDE6BDF6BE06BE26BE36BE46BE56BE66BE7\n6BE86BE96BEC6BED6BEE6BF06BF16BF26BF46BF66BF76BF86BFA6BFB6BFC6BFE\n6BFF6C006C016C026C036C046C086C096C0A6C0B6C0C6C0E6C126C176C1C6C1D\n6C1E6C206C236C256C2B6C2C6C2D6C316C336C366C376C396C3A6C3B6C3C6C3E\n6C3F6C436C446C456C486C4B6C4C6C4D6C4E6C4F6C516C526C536C566C580000\n9B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6C596C5A6C626C636C656C666C676C6B6C6C6C6D6C6E6C6F6C716C736C756C77\n6C786C7A6C7B6C7C6C7F6C806C846C876C8A6C8B6C8D6C8E6C916C926C956C96\n6C976C986C9A6C9C6C9D6C9E6CA06CA26CA86CAC6CAF6CB06CB46CB56CB66CB7\n6CBA6CC06CC16CC26CC36CC66CC76CC86CCB6CCD6CCE6CCF6CD16CD26CD80000\n6CD96CDA6CDC6CDD6CDF6CE46CE66CE76CE96CEC6CED6CF26CF46CF96CFF6D00\n6D026D036D056D066D086D096D0A6D0D6D0F6D106D116D136D146D156D166D18\n6D1C6D1D6D1F6D206D216D226D236D246D266D286D296D2C6D2D6D2F6D306D34\n6D366D376D386D3A6D3F6D406D426D446D496D4C6D506D556D566D576D586D5B\n6D5D6D5F6D616D626D646D656D676D686D6B6D6C6D6D6D706D716D726D736D75\n6D766D796D7A6D7B6D7D6D7E6D7F6D806D816D836D846D866D876D8A6D8B6D8D\n6D8F6D906D926D966D976D986D996D9A6D9C6DA26DA56DAC6DAD6DB06DB16DB3\n6DB46DB66DB76DB96DBA6DBB6DBC6DBD6DBE6DC16DC26DC36DC86DC96DCA0000\n9C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6DCD6DCE6DCF6DD06DD26DD36DD46DD56DD76DDA6DDB6DDC6DDF6DE26DE36DE5\n6DE76DE86DE96DEA6DED6DEF6DF06DF26DF46DF56DF66DF86DFA6DFD6DFE6DFF\n6E006E016E026E036E046E066E076E086E096E0B6E0F6E126E136E156E186E19\n6E1B6E1C6E1E6E1F6E226E266E276E286E2A6E2C6E2E6E306E316E336E350000\n6E366E376E396E3B6E3C6E3D6E3E6E3F6E406E416E426E456E466E476E486E49\n6E4A6E4B6E4C6E4F6E506E516E526E556E576E596E5A6E5C6E5D6E5E6E606E61\n6E626E636E646E656E666E676E686E696E6A6E6C6E6D6E6F6E706E716E726E73\n6E746E756E766E776E786E796E7A6E7B6E7C6E7D6E806E816E826E846E876E88\n6E8A6E8B6E8C6E8D6E8E6E916E926E936E946E956E966E976E996E9A6E9B6E9D\n6E9E6EA06EA16EA36EA46EA66EA86EA96EAB6EAC6EAD6EAE6EB06EB36EB56EB8\n6EB96EBC6EBE6EBF6EC06EC36EC46EC56EC66EC86EC96ECA6ECC6ECD6ECE6ED0\n6ED26ED66ED86ED96EDB6EDC6EDD6EE36EE76EEA6EEB6EEC6EED6EEE6EEF0000\n9D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6EF06EF16EF26EF36EF56EF66EF76EF86EFA6EFB6EFC6EFD6EFE6EFF6F006F01\n6F036F046F056F076F086F0A6F0B6F0C6F0D6F0E6F106F116F126F166F176F18\n6F196F1A6F1B6F1C6F1D6F1E6F1F6F216F226F236F256F266F276F286F2C6F2E\n6F306F326F346F356F376F386F396F3A6F3B6F3C6F3D6F3F6F406F416F420000\n6F436F446F456F486F496F4A6F4C6F4E6F4F6F506F516F526F536F546F556F56\n6F576F596F5A6F5B6F5D6F5F6F606F616F636F646F656F676F686F696F6A6F6B\n6F6C6F6F6F706F716F736F756F766F776F796F7B6F7D6F7E6F7F6F806F816F82\n6F836F856F866F876F8A6F8B6F8F6F906F916F926F936F946F956F966F976F98\n6F996F9A6F9B6F9D6F9E6F9F6FA06FA26FA36FA46FA56FA66FA86FA96FAA6FAB\n6FAC6FAD6FAE6FAF6FB06FB16FB26FB46FB56FB76FB86FBA6FBB6FBC6FBD6FBE\n6FBF6FC16FC36FC46FC56FC66FC76FC86FCA6FCB6FCC6FCD6FCE6FCF6FD06FD3\n6FD46FD56FD66FD76FD86FD96FDA6FDB6FDC6FDD6FDF6FE26FE36FE46FE50000\n9E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6FE66FE76FE86FE96FEA6FEB6FEC6FED6FF06FF16FF26FF36FF46FF56FF66FF7\n6FF86FF96FFA6FFB6FFC6FFD6FFE6FFF70007001700270037004700570067007\n70087009700A700B700C700D700E700F70107012701370147015701670177018\n7019701C701D701E701F702070217022702470257026702770287029702A0000\n702B702C702D702E702F70307031703270337034703670377038703A703B703C\n703D703E703F7040704170427043704470457046704770487049704A704B704D\n704E7050705170527053705470557056705770587059705A705B705C705D705F\n7060706170627063706470657066706770687069706A706E7071707270737074\n70777079707A707B707D7081708270837084708670877088708B708C708D708F\n70907091709370977098709A709B709E709F70A070A170A270A370A470A570A6\n70A770A870A970AA70B070B270B470B570B670BA70BE70BF70C470C570C670C7\n70C970CB70CC70CD70CE70CF70D070D170D270D370D470D570D670D770DA0000\n9F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n70DC70DD70DE70E070E170E270E370E570EA70EE70F070F170F270F370F470F5\n70F670F870FA70FB70FC70FE70FF710071017102710371047105710671077108\n710B710C710D710E710F7111711271147117711B711C711D711E711F71207121\n7122712371247125712771287129712A712B712C712D712E7132713371340000\n7135713771387139713A713B713C713D713E713F714071417142714371447146\n714771487149714B714D714F7150715171527153715471557156715771587159\n715A715B715D715F716071617162716371657169716A716B716C716D716F7170\n717171747175717671777179717B717C717E717F718071817182718371857186\n718771887189718B718C718D718E7190719171927193719571967197719A719B\n719C719D719E71A171A271A371A471A571A671A771A971AA71AB71AD71AE71AF\n71B071B171B271B471B671B771B871BA71BB71BC71BD71BE71BF71C071C171C2\n71C471C571C671C771C871C971CA71CB71CC71CD71CF71D071D171D271D30000\nA0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n71D671D771D871D971DA71DB71DC71DD71DE71DF71E171E271E371E471E671E8\n71E971EA71EB71EC71ED71EF71F071F171F271F371F471F571F671F771F871FA\n71FB71FC71FD71FE71FF720072017202720372047205720772087209720A720B\n720C720D720E720F7210721172127213721472157216721772187219721A0000\n721B721C721E721F722072217222722372247225722672277229722B722D722E\n722F723272337234723A723C723E72407241724272437244724572467249724A\n724B724E724F7250725172537254725572577258725A725C725E726072637264\n72657268726A726B726C726D7270727172737274727672777278727B727C727D\n7282728372857286728772887289728C728E7290729172937294729572967297\n72987299729A729B729C729D729E72A072A172A272A372A472A572A672A772A8\n72A972AA72AB72AE72B172B272B372B572BA72BB72BC72BD72BE72BF72C072C5\n72C672C772C972CA72CB72CC72CF72D172D372D472D572D672D872DA72DB0000\nA1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000030003001300200B702C902C700A8300330052014FF5E2016202620182019\n201C201D3014301530083009300A300B300C300D300E300F3016301730103011\n00B100D700F72236222722282211220F222A222922082237221A22A522252220\n23122299222B222E2261224C2248223D221D2260226E226F22642265221E2235\n22342642264000B0203220332103FF0400A4FFE0FFE1203000A7211626062605\n25CB25CF25CE25C725C625A125A025B325B2203B219221902191219330130000\nA2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000217021712172217321742175217621772178217900000000000000000000\n000024882489248A248B248C248D248E248F2490249124922493249424952496\n249724982499249A249B247424752476247724782479247A247B247C247D247E\n247F248024812482248324842485248624872460246124622463246424652466\n2467246824690000000032203221322232233224322532263227322832290000\n00002160216121622163216421652166216721682169216A216B000000000000\nA3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000FF01FF02FF03FFE5FF05FF06FF07FF08FF09FF0AFF0BFF0CFF0DFF0EFF0F\nFF10FF11FF12FF13FF14FF15FF16FF17FF18FF19FF1AFF1BFF1CFF1DFF1EFF1F\nFF20FF21FF22FF23FF24FF25FF26FF27FF28FF29FF2AFF2BFF2CFF2DFF2EFF2F\nFF30FF31FF32FF33FF34FF35FF36FF37FF38FF39FF3AFF3BFF3CFF3DFF3EFF3F\nFF40FF41FF42FF43FF44FF45FF46FF47FF48FF49FF4AFF4BFF4CFF4DFF4EFF4F\nFF50FF51FF52FF53FF54FF55FF56FF57FF58FF59FF5AFF5BFF5CFF5DFFE30000\nA4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000304130423043304430453046304730483049304A304B304C304D304E304F\n3050305130523053305430553056305730583059305A305B305C305D305E305F\n3060306130623063306430653066306730683069306A306B306C306D306E306F\n3070307130723073307430753076307730783079307A307B307C307D307E307F\n3080308130823083308430853086308730883089308A308B308C308D308E308F\n3090309130923093000000000000000000000000000000000000000000000000\nA5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000030A130A230A330A430A530A630A730A830A930AA30AB30AC30AD30AE30AF\n30B030B130B230B330B430B530B630B730B830B930BA30BB30BC30BD30BE30BF\n30C030C130C230C330C430C530C630C730C830C930CA30CB30CC30CD30CE30CF\n30D030D130D230D330D430D530D630D730D830D930DA30DB30DC30DD30DE30DF\n30E030E130E230E330E430E530E630E730E830E930EA30EB30EC30ED30EE30EF\n30F030F130F230F330F430F530F6000000000000000000000000000000000000\nA6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000039103920393039403950396039703980399039A039B039C039D039E039F\n03A003A103A303A403A503A603A703A803A90000000000000000000000000000\n000003B103B203B303B403B503B603B703B803B903BA03BB03BC03BD03BE03BF\n03C003C103C303C403C503C603C703C803C90000000000000000000000000000\nFE35FE36FE39FE3AFE3FFE40FE3DFE3EFE41FE42FE43FE4400000000FE3BFE3C\nFE37FE38FE310000FE33FE340000000000000000000000000000000000000000\nA7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000004100411041204130414041504010416041704180419041A041B041C041D\n041E041F0420042104220423042404250426042704280429042A042B042C042D\n042E042F00000000000000000000000000000000000000000000000000000000\n000004300431043204330434043504510436043704380439043A043B043C043D\n043E043F0440044104420443044404450446044704480449044A044B044C044D\n044E044F00000000000000000000000000000000000000000000000000000000\nA8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n02CA02CB02D920132015202520352105210921962197219821992215221F2223\n22522266226722BF2550255125522553255425552556255725582559255A255B\n255C255D255E255F2560256125622563256425652566256725682569256A256B\n256C256D256E256F257025712572257325812582258325842585258625870000\n25882589258A258B258C258D258E258F25932594259525BC25BD25E225E325E4\n25E5260922953012301D301E0000000000000000000000000000000000000000\n0000010100E101CE00E0011300E9011B00E8012B00ED01D000EC014D00F301D2\n00F2016B00FA01D400F901D601D801DA01DC00FC00EA02510000014401480000\n0261000000000000000031053106310731083109310A310B310C310D310E310F\n3110311131123113311431153116311731183119311A311B311C311D311E311F\n3120312131223123312431253126312731283129000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n30213022302330243025302630273028302932A3338E338F339C339D339E33A1\n33C433CE33D133D233D5FE30FFE2FFE400002121323100002010000000000000\n30FC309B309C30FD30FE3006309D309EFE49FE4AFE4BFE4CFE4DFE4EFE4FFE50\nFE51FE52FE54FE55FE56FE57FE59FE5AFE5BFE5CFE5DFE5EFE5FFE60FE610000\nFE62FE63FE64FE65FE66FE68FE69FE6AFE6B0000000000000000000000000000\n0000000000000000000000003007000000000000000000000000000000000000\n00000000000000002500250125022503250425052506250725082509250A250B\n250C250D250E250F2510251125122513251425152516251725182519251A251B\n251C251D251E251F2520252125222523252425252526252725282529252A252B\n252C252D252E252F2530253125322533253425352536253725382539253A253B\n253C253D253E253F2540254125422543254425452546254725482549254A254B\n0000000000000000000000000000000000000000000000000000000000000000\nAA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n72DC72DD72DF72E272E372E472E572E672E772EA72EB72F572F672F972FD72FE\n72FF73007302730473057306730773087309730B730C730D730F731073117312\n731473187319731A731F732073237324732673277328732D732F733073327333\n73357336733A733B733C733D7340734173427343734473457346734773480000\n7349734A734B734C734E734F7351735373547355735673587359735A735B735C\n735D735E735F736173627363736473657366736773687369736A736B736E7370\n7371000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nAB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n73727373737473757376737773787379737A737B737C737D737F738073817382\n7383738573867388738A738C738D738F73907392739373947395739773987399\n739A739C739D739E73A073A173A373A473A573A673A773A873AA73AC73AD73B1\n73B473B573B673B873B973BC73BD73BE73BF73C173C373C473C573C673C70000\n73CB73CC73CE73D273D373D473D573D673D773D873DA73DB73DC73DD73DF73E1\n73E273E373E473E673E873EA73EB73EC73EE73EF73F073F173F373F473F573F6\n73F7000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nAC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n73F873F973FA73FB73FC73FD73FE73FF740074017402740474077408740B740C\n740D740E741174127413741474157416741774187419741C741D741E741F7420\n74217423742474277429742B742D742F74317432743774387439743A743B743D\n743E743F744074427443744474457446744774487449744A744B744C744D0000\n744E744F7450745174527453745474567458745D746074617462746374647465\n7466746774687469746A746B746C746E746F7471747274737474747574787479\n747A000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nAD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n747B747C747D747F748274847485748674887489748A748C748D748F74917492\n7493749474957496749774987499749A749B749D749F74A074A174A274A374A4\n74A574A674AA74AB74AC74AD74AE74AF74B074B174B274B374B474B574B674B7\n74B874B974BB74BC74BD74BE74BF74C074C174C274C374C474C574C674C70000\n74C874C974CA74CB74CC74CD74CE74CF74D074D174D374D474D574D674D774D8\n74D974DA74DB74DD74DF74E174E574E774E874E974EA74EB74EC74ED74F074F1\n74F2000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nAE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n74F374F574F874F974FA74FB74FC74FD74FE7500750175027503750575067507\n75087509750A750B750C750E751075127514751575167517751B751D751E7520\n752175227523752475267527752A752E753475367539753C753D753F75417542\n75437544754675477549754A754D755075517552755375557556755775580000\n755D755E755F75607561756275637564756775687569756B756C756D756E756F\n757075717573757575767577757A757B757C757D757E75807581758275847585\n7587000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nAF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n75887589758A758C758D758E7590759375957598759B759C759E75A275A675A7\n75A875A975AA75AD75B675B775BA75BB75BF75C075C175C675CB75CC75CE75CF\n75D075D175D375D775D975DA75DC75DD75DF75E075E175E575E975EC75ED75EE\n75EF75F275F375F575F675F775F875FA75FB75FD75FE76027604760676070000\n76087609760B760D760E760F76117612761376147616761A761C761D761E7621\n762376277628762C762E762F76317632763676377639763A763B763D76417642\n7644000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nB0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n76457646764776487649764A764B764E764F7650765176527653765576577658\n7659765A765B765D765F766076617662766476657666766776687669766A766C\n766D766E767076717672767376747675767676777679767A767C767F76807681\n768376857689768A768C768D768F769076927694769576977698769A769B0000\n769C769D769E769F76A076A176A276A376A576A676A776A876A976AA76AB76AC\n76AD76AF76B076B376B576B676B776B876B976BA76BB76BC76BD76BE76C076C1\n76C3554A963F57C3632854CE550954C07691764C853C77EE827E788D72319698\n978D6C285B894FFA630966975CB880FA684880AE660276CE51F9655671AC7FF1\n888450B2596561CA6FB382AD634C625253ED54277B06516B75A45DF462D48DCB\n9776628A8019575D97387F627238767D67CF767E64464F708D2562DC7A176591\n73ED642C6273822C9881677F7248626E62CC4F3474E3534A529E7ECA90A65E2E\n6886699C81807ED168D278C5868C9551508D8C2482DE80DE5305891252650000\nB1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n76C476C776C976CB76CC76D376D576D976DA76DC76DD76DE76E076E176E276E3\n76E476E676E776E876E976EA76EB76EC76ED76F076F376F576F676F776FA76FB\n76FD76FF77007702770377057706770A770C770E770F77107711771277137714\n7715771677177718771B771C771D771E77217723772477257727772A772B0000\n772C772E773077317732773377347739773B773D773E773F7742774477457746\n77487749774A774B774C774D774E774F77527753775477557756775777587759\n775C858496F94FDD582199715B9D62B162A566B48C799C8D7206676F789160B2\n535153178F8880CC8D1D94A1500D72C8590760EB711988AB595482EF672C7B28\n5D297EF7752D6CF58E668FF8903C9F3B6BD491197B145F7C78A784D6853D6BD5\n6BD96BD65E015E8775F995ED655D5F0A5FC58F9F58C181C2907F965B97AD8FB9\n7F168D2C62414FBF53D8535E8FA88FA98FAB904D68075F6A819888689CD6618B\n522B762A5F6C658C6FD26EE85BBE6448517551B067C44E1979C9997C70B30000\nB2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n775D775E775F7760776477677769776A776D776E776F77707771777277737774\n7775777677777778777A777B777C7781778277837786778777887789778A778B\n778F77907793779477957796779777987799779A779B779C779D779E77A177A3\n77A477A677A877AB77AD77AE77AF77B177B277B477B677B777B877B977BA0000\n77BC77BE77C077C177C277C377C477C577C677C777C877C977CA77CB77CC77CE\n77CF77D077D177D277D377D477D577D677D877D977DA77DD77DE77DF77E077E1\n77E475C55E7673BB83E064AD62E894B56CE2535A52C3640F94C27B944F2F5E1B\n82368116818A6E246CCA9A736355535C54FA886557E04E0D5E036B657C3F90E8\n601664E6731C88C16750624D8D22776C8E2991C75F6983DC8521991053C28695\n6B8B60ED60E8707F82CD82314ED36CA785CF64CD7CD969FD66F9834953957B56\n4FA7518C6D4B5C428E6D63D253C9832C833667E578B4643D5BDF5C945DEE8BE7\n62C667F48C7A640063BA8749998B8C177F2094F24EA7961098A4660C73160000\nB3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n77E677E877EA77EF77F077F177F277F477F577F777F977FA77FB77FC78037804\n7805780678077808780A780B780E780F7810781378157819781B781E78207821\n782278247828782A782B782E782F78317832783378357836783D783F78417842\n78437844784678487849784A784B784D784F78517853785478587859785A0000\n785B785C785E785F7860786178627863786478657866786778687869786F7870\n78717872787378747875787678787879787A787B787D787E787F788078817882\n7883573A5C1D5E38957F507F80A05382655E7545553150218D856284949E671D\n56326F6E5DE2543570928F66626F64A463A35F7B6F8890F481E38FB05C186668\n5FF16C8996488D81886C649179F057CE6A59621054484E587A0B60E96F848BDA\n627F901E9A8B79E4540375F4630153196C608FDF5F1B9A70803B9F7F4F885C3A\n8D647FC565A570BD514551B2866B5D075BA062BD916C75748E0C7A2061017B79\n4EC77EF877854E1181ED521D51FA6A7153A88E87950496CF6EC19664695A0000\nB4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7884788578867888788A788B788F789078927894789578967899789D789E78A0\n78A278A478A678A878A978AA78AB78AC78AD78AE78AF78B578B678B778B878BA\n78BB78BC78BD78BF78C078C278C378C478C678C778C878CC78CD78CE78CF78D1\n78D278D378D678D778D878DA78DB78DC78DD78DE78DF78E078E178E278E30000\n78E478E578E678E778E978EA78EB78ED78EE78EF78F078F178F378F578F678F8\n78F978FB78FC78FD78FE78FF79007902790379047906790779087909790A790B\n790C784050A877D7641089E6590463E35DDD7A7F693D4F20823955984E3275AE\n7A975E625E8A95EF521B5439708A6376952457826625693F918755076DF37EAF\n882262337EF075B5832878C196CC8F9E614874F78BCD6B64523A8D506B21806A\n847156F153064ECE4E1B51D17C97918B7C074FC38E7F7BE17A9C64675D1450AC\n810676017CB96DEC7FE067515B585BF878CB64AE641363AA632B9519642D8FBE\n7B5476296253592754466B7950A362345E266B864EE38D37888B5F85902E0000\nB5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n790D790E790F791079117912791479157916791779187919791A791B791C791D\n791F792079217922792379257926792779287929792A792B792C792D792E792F\n793079317932793379357936793779387939793D793F79427943794479457947\n794A794B794C794D794E794F7950795179527954795579587959796179630000\n796479667969796A796B796C796E79707971797279737974797579767979797B\n797C797D797E797F798279837986798779887989798B798C798D798E79907991\n79926020803D62C54E39535590F863B880C665E66C2E4F4660EE6DE18BDE5F39\n86CB5F536321515A83616863520063638E4850125C9B79775BFC52307A3B60BC\n905376D75FB75F9776848E6C706F767B7B4977AA51F3909358244F4E6EF48FEA\n654C7B1B72C46DA47FDF5AE162B55E95573084827B2C5E1D5F1F90127F1498A0\n63826EC7789870B95178975B57AB75354F4375385E9760E659606DC06BBF7889\n53FC96D551CB52016389540A94938C038DCC7239789F87768FED8C0D53E00000\nB6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7993799479957996799779987999799B799C799D799E799F79A079A179A279A3\n79A479A579A679A879A979AA79AB79AC79AD79AE79AF79B079B179B279B479B5\n79B679B779B879BC79BF79C279C479C579C779C879CA79CC79CE79CF79D079D3\n79D479D679D779D979DA79DB79DC79DD79DE79E079E179E279E579E879EA0000\n79EC79EE79F179F279F379F479F579F679F779F979FA79FC79FE79FF7A017A04\n7A057A077A087A097A0A7A0C7A0F7A107A117A127A137A157A167A187A197A1B\n7A1C4E0176EF53EE948998769F0E952D5B9A8BA24E224E1C51AC846361C252A8\n680B4F97606B51BB6D1E515C6296659796618C46901775D890FD77636BD2728A\n72EC8BFB583577798D4C675C9540809A5EA66E2159927AEF77ED953B6BB565AD\n7F0E58065151961F5BF958A954288E726566987F56E4949D76FE9041638754C6\n591A593A579B8EB267358DFA8235524160F0581586FE5CE89E454FC4989D8BB9\n5A2560765384627C904F9102997F6069800C513F80335C1499756D314E8C0000\nB7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7A1D7A1F7A217A227A247A257A267A277A287A297A2A7A2B7A2C7A2D7A2E7A2F\n7A307A317A327A347A357A367A387A3A7A3E7A407A417A427A437A447A457A47\n7A487A497A4A7A4B7A4C7A4D7A4E7A4F7A507A527A537A547A557A567A587A59\n7A5A7A5B7A5C7A5D7A5E7A5F7A607A617A627A637A647A657A667A677A680000\n7A697A6A7A6B7A6C7A6D7A6E7A6F7A717A727A737A757A7B7A7C7A7D7A7E7A82\n7A857A877A897A8A7A8B7A8C7A8E7A8F7A907A937A947A997A9A7A9B7A9E7AA1\n7AA28D3053D17F5A7B4F4F104E4F96006CD573D085E95E06756A7FFB6A0A77FE\n94927E4151E170E653CD8FD483038D2972AF996D6CDB574A82B365B980AA623F\n963259A84EFF8BBF7EBA653E83F2975E556198DE80A5532A8BFD542080BA5E9F\n6CB88D3982AC915A54296C1B52067EB7575F711A6C7E7C89594B4EFD5FFF6124\n7CAA4E305C0167AB87025CF0950B98CE75AF70FD902251AF7F1D8BBD594951E4\n4F5B5426592B657780A45B75627662C28F905E456C1F7B264F0F4FD8670D0000\nB8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7AA37AA47AA77AA97AAA7AAB7AAE7AAF7AB07AB17AB27AB47AB57AB67AB77AB8\n7AB97ABA7ABB7ABC7ABD7ABE7AC07AC17AC27AC37AC47AC57AC67AC77AC87AC9\n7ACA7ACC7ACD7ACE7ACF7AD07AD17AD27AD37AD47AD57AD77AD87ADA7ADB7ADC\n7ADD7AE17AE27AE47AE77AE87AE97AEA7AEB7AEC7AEE7AF07AF17AF27AF30000\n7AF47AF57AF67AF77AF87AFB7AFC7AFE7B007B017B027B057B077B097B0C7B0D\n7B0E7B107B127B137B167B177B187B1A7B1C7B1D7B1F7B217B227B237B277B29\n7B2D6D6E6DAA798F88B15F17752B629A8F854FEF91DC65A7812F81515E9C8150\n8D74526F89868D4B590D50854ED8961C723681798D1F5BCC8BA3964459877F1A\n54905676560E8BE565396982949976D66E895E727518674667D17AFF809D8D76\n611F79C665628D635188521A94A27F38809B7EB25C976E2F67607BD9768B9AD8\n818F7F947CD5641E95507A3F544A54E56B4C640162089E3D80F3759952729769\n845B683C86E49601969494EC4E2A54047ED968398DDF801566F45E9A7FB90000\nB9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7B2F7B307B327B347B357B367B377B397B3B7B3D7B3F7B407B417B427B437B44\n7B467B487B4A7B4D7B4E7B537B557B577B597B5C7B5E7B5F7B617B637B647B65\n7B667B677B687B697B6A7B6B7B6C7B6D7B6F7B707B737B747B767B787B7A7B7C\n7B7D7B7F7B817B827B837B847B867B877B887B897B8A7B8B7B8C7B8E7B8F0000\n7B917B927B937B967B987B997B9A7B9B7B9E7B9F7BA07BA37BA47BA57BAE7BAF\n7BB07BB27BB37BB57BB67BB77BB97BBA7BBB7BBC7BBD7BBE7BBF7BC07BC27BC3\n7BC457C2803F68975DE5653B529F606D9F9A4F9B8EAC516C5BAB5F135DE96C5E\n62F18D21517194A952FE6C9F82DF72D757A267848D2D591F8F9C83C754957B8D\n4F306CBD5B6459D19F1353E486CA9AA88C3780A16545987E56FA96C7522E74DC\n52505BE1630289024E5662D0602A68FA51735B9851A089C27BA199867F5060EF\n704C8D2F51495E7F901B747089C4572D78455F529F9F95FA8F689B3C8BE17678\n684267DC8DEA8D35523D8F8A6EDA68CD950590ED56FD679C88F98FC754C80000\nBA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7BC57BC87BC97BCA7BCB7BCD7BCE7BCF7BD07BD27BD47BD57BD67BD77BD87BDB\n7BDC7BDE7BDF7BE07BE27BE37BE47BE77BE87BE97BEB7BEC7BED7BEF7BF07BF2\n7BF37BF47BF57BF67BF87BF97BFA7BFB7BFD7BFF7C007C017C027C037C047C05\n7C067C087C097C0A7C0D7C0E7C107C117C127C137C147C157C177C187C190000\n7C1A7C1B7C1C7C1D7C1E7C207C217C227C237C247C257C287C297C2B7C2C7C2D\n7C2E7C2F7C307C317C327C337C347C357C367C377C397C3A7C3B7C3C7C3D7C3E\n7C429AB85B696D776C264EA55BB39A87916361A890AF97E9542B6DB55BD251FD\n558A7F557FF064BC634D65F161BE608D710A6C576C49592F676D822A58D5568E\n8C6A6BEB90DD597D801753F76D695475559D837783CF683879BE548C4F555408\n76D28C8996026CB36DB88D6B89109E648D3A563F9ED175D55F8872E0606854FC\n4EA86A2A886160528F7054C470D886799E3F6D2A5B8F5F187EA255894FAF7334\n543C539A5019540E547C4E4E5FFD745A58F6846B80E1877472D07CCA6E560000\nBB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7C437C447C457C467C477C487C497C4A7C4B7C4C7C4E7C4F7C507C517C527C53\n7C547C557C567C577C587C597C5A7C5B7C5C7C5D7C5E7C5F7C607C617C627C63\n7C647C657C667C677C687C697C6A7C6B7C6C7C6D7C6E7C6F7C707C717C727C75\n7C767C777C787C797C7A7C7E7C7F7C807C817C827C837C847C857C867C870000\n7C887C8A7C8B7C8C7C8D7C8E7C8F7C907C937C947C967C997C9A7C9B7CA07CA1\n7CA37CA67CA77CA87CA97CAB7CAC7CAD7CAF7CB07CB47CB57CB67CB77CB87CBA\n7CBB5F27864E552C62A44E926CAA623782B154D7534E733E6ED1753B52125316\n8BDD69D05F8A60006DEE574F6B2273AF68538FD87F13636260A3552475EA8C62\n71156DA35BA65E7B8352614C9EC478FA87577C27768751F060F6714C66435E4C\n604D8C0E707063258F895FBD606286D456DE6BC160946167534960E066668D3F\n79FD4F1A70E96C478BB38BF27ED88364660F5A5A9B426D516DF78C416D3B4F19\n706B83B7621660D1970D8D27797851FB573E57FA673A75787A3D79EF7B950000\nBC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7CBF7CC07CC27CC37CC47CC67CC97CCB7CCE7CCF7CD07CD17CD27CD37CD47CD8\n7CDA7CDB7CDD7CDE7CE17CE27CE37CE47CE57CE67CE77CE97CEA7CEB7CEC7CED\n7CEE7CF07CF17CF27CF37CF47CF57CF67CF77CF97CFA7CFC7CFD7CFE7CFF7D00\n7D017D027D037D047D057D067D077D087D097D0B7D0C7D0D7D0E7D0F7D100000\n7D117D127D137D147D157D167D177D187D197D1A7D1B7D1C7D1D7D1E7D1F7D21\n7D237D247D257D267D287D297D2A7D2C7D2D7D2E7D307D317D327D337D347D35\n7D36808C99658FF96FC08BA59E2159EC7EE97F095409678168D88F917C4D96C6\n53CA602575BE6C7253735AC97EA7632451E0810A5DF184DF628051805B634F0E\n796D524260B86D4E5BC45BC28BA18BB065E25FCC964559937EE77EAA560967B7\n59394F735BB652A0835A988A8D3E753294BE50477A3C4EF767B69A7E5AC16B7C\n76D1575A5C167B3A95F4714E517C80A9827059787F04832768C067EC78B17877\n62E363617B804FED526A51CF835069DB92748DF58D3189C1952E7BAD4EF60000\nBD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7D377D387D397D3A7D3B7D3C7D3D7D3E7D3F7D407D417D427D437D447D457D46\n7D477D487D497D4A7D4B7D4C7D4D7D4E7D4F7D507D517D527D537D547D557D56\n7D577D587D597D5A7D5B7D5C7D5D7D5E7D5F7D607D617D627D637D647D657D66\n7D677D687D697D6A7D6B7D6C7D6D7D6F7D707D717D727D737D747D757D760000\n7D787D797D7A7D7B7D7C7D7D7D7E7D7F7D807D817D827D837D847D857D867D87\n7D887D897D8A7D8B7D8C7D8D7D8E7D8F7D907D917D927D937D947D957D967D97\n7D98506582305251996F6E106E856DA75EFA50F559DC5C066D466C5F7586848B\n686859568BB253209171964D854969127901712680F64EA490CA6D479A845A07\n56BC640594F077EB4FA5811A72E189D2997A7F347EDE527F655991758F7F8F83\n53EB7A9663ED63A5768679F888579636622A52AB8282685467706377776B7AED\n6D017ED389E359D0621285C982A5754C501F4ECB75A58BEB5C4A5DFE7B4B65A4\n91D14ECA6D25895F7D2795264EC58C288FDB9773664B79818FD170EC6D780000\nBE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7D997D9A7D9B7D9C7D9D7D9E7D9F7DA07DA17DA27DA37DA47DA57DA77DA87DA9\n7DAA7DAB7DAC7DAD7DAF7DB07DB17DB27DB37DB47DB57DB67DB77DB87DB97DBA\n7DBB7DBC7DBD7DBE7DBF7DC07DC17DC27DC37DC47DC57DC67DC77DC87DC97DCA\n7DCB7DCC7DCD7DCE7DCF7DD07DD17DD27DD37DD47DD57DD67DD77DD87DD90000\n7DDA7DDB7DDC7DDD7DDE7DDF7DE07DE17DE27DE37DE47DE57DE67DE77DE87DE9\n7DEA7DEB7DEC7DED7DEE7DEF7DF07DF17DF27DF37DF47DF57DF67DF77DF87DF9\n7DFA5C3D52B283465162830E775B66769CB84EAC60CA7CBE7CB37ECF4E958B66\n666F988897595883656C955C5F8475C997567ADF7ADE51C070AF7A9863EA7A76\n7EA0739697ED4E4570784E5D915253A9655165E781FC8205548E5C31759A97A0\n62D872D975BD5C459A7983CA5C40548077E94E3E6CAE805A62D2636E5DE85177\n8DDD8E1E952F4FF153E560E770AC526763509E435A1F5026773753777EE26485\n652B628963985014723589C951B38BC07EDD574783CC94A7519B541B5CFB0000\nBF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7DFB7DFC7DFD7DFE7DFF7E007E017E027E037E047E057E067E077E087E097E0A\n7E0B7E0C7E0D7E0E7E0F7E107E117E127E137E147E157E167E177E187E197E1A\n7E1B7E1C7E1D7E1E7E1F7E207E217E227E237E247E257E267E277E287E297E2A\n7E2B7E2C7E2D7E2E7E2F7E307E317E327E337E347E357E367E377E387E390000\n7E3A7E3C7E3D7E3E7E3F7E407E427E437E447E457E467E487E497E4A7E4B7E4C\n7E4D7E4E7E4F7E507E517E527E537E547E557E567E577E587E597E5A7E5B7E5C\n7E5D4FCA7AE36D5A90E19A8F55805496536154AF5F0063E9697751EF6168520A\n582A52D8574E780D770B5EB761777CE0625B62974EA27095800362F770E49760\n577782DB67EF68F578D5989779D158F354B353EF6E34514B523B5BA28BFE80AF\n554357A660735751542D7A7A60505B5463A762A053E362635BC767AF54ED7A9F\n82E691775E9388E4593857AE630E8DE880EF57577B774FA95FEB5BBD6B3E5321\n7B5072C2684677FF773665F751B54E8F76D45CBF7AA58475594E9B4150800000\nC0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7E5E7E5F7E607E617E627E637E647E657E667E677E687E697E6A7E6B7E6C7E6D\n7E6E7E6F7E707E717E727E737E747E757E767E777E787E797E7A7E7B7E7C7E7D\n7E7E7E7F7E807E817E837E847E857E867E877E887E897E8A7E8B7E8C7E8D7E8E\n7E8F7E907E917E927E937E947E957E967E977E987E997E9A7E9C7E9D7E9E0000\n7EAE7EB47EBB7EBC7ED67EE47EEC7EF97F0A7F107F1E7F377F397F3B7F3C7F3D\n7F3E7F3F7F407F417F437F467F477F487F497F4A7F4B7F4C7F4D7F4E7F4F7F52\n7F53998861276E8357646606634656F062EC62695ED39614578362C955878721\n814A8FA3556683B167658D5684DD5A6A680F62E67BEE961151706F9C8C3063FD\n89C861D27F0670C26EE57405699472FC5ECA90CE67176D6A635E52B372628001\n4F6C59E5916A70D96D9D52D24E5096F7956D857E78CA7D2F5121579264C2808B\n7C7B6CEA68F1695E51B7539868A872819ECE7BF172F879BB6F137406674E91CC\n9CA4793C83898354540F68174E3D538952B1783E5386522950884F8B4FD00000\nC1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7F567F597F5B7F5C7F5D7F5E7F607F637F647F657F667F677F6B7F6C7F6D7F6F\n7F707F737F757F767F777F787F7A7F7B7F7C7F7D7F7F7F807F827F837F847F85\n7F867F877F887F897F8B7F8D7F8F7F907F917F927F937F957F967F977F987F99\n7F9B7F9C7FA07FA27FA37FA57FA67FA87FA97FAA7FAB7FAC7FAD7FAE7FB10000\n7FB37FB47FB57FB67FB77FBA7FBB7FBE7FC07FC27FC37FC47FC67FC77FC87FC9\n7FCB7FCD7FCF7FD07FD17FD27FD37FD67FD77FD97FDA7FDB7FDC7FDD7FDE7FE2\n7FE375E27ACB7C926CA596B6529B748354E94FE9805483B28FDE95705EC9601C\n6D9F5E18655B813894FE604B70BC7EC37CAE51C968817CB1826F4E248F8691CF\n667E4EAE8C0564A9804A50DA759771CE5BE58FBD6F664E86648295635ED66599\n521788C270C852A3730E7433679778F797164E3490BB9CDE6DCB51DB8D41541D\n62CE73B283F196F69F8494C34F367F9A51CC707596755CAD988653E64EE46E9C\n740969B4786B998F7559521876246D4167F3516D9F99804B54997B3C7ABF0000\nC2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7FE47FE77FE87FEA7FEB7FEC7FED7FEF7FF27FF47FF57FF67FF77FF87FF97FFA\n7FFD7FFE7FFF8002800780088009800A800E800F80118013801A801B801D801E\n801F802180238024802B802C802D802E802F8030803280348039803A803C803E\n8040804180448045804780488049804E804F8050805180538055805680570000\n8059805B805C805D805E805F806080618062806380648065806680678068806B\n806C806D806E806F807080728073807480758076807780788079807A807B807C\n807D9686578462E29647697C5A0464027BD36F0F964B82A6536298855E907089\n63B35364864F9C819E93788C97328DEF8D429E7F6F5E79845F559646622E9A74\n541594DD4FA365C55C655C617F1586516C2F5F8B73876EE47EFF5CE6631B5B6A\n6EE653754E7163A0756562A18F6E4F264ED16CA67EB68BBA841D87BA7F57903B\n95237BA99AA188F8843D6D1B9A867EDC59889EBB739B780186829A6C9A82561B\n541757CB4E709EA653568FC881097792999286EE6EE1851366FC61626F2B0000\nC3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n807E8081808280858088808A808D808E808F8090809180928094809580978099\n809E80A380A680A780A880AC80B080B380B580B680B880B980BB80C580C780C8\n80C980CA80CB80CF80D080D180D280D380D480D580D880DF80E080E280E380E6\n80EE80F580F780F980FB80FE80FF8100810181038104810581078108810B0000\n810C811581178119811B811C811D811F81208121812281238124812581268127\n81288129812A812B812D812E813081338134813581378139813A813B813C813D\n813F8C298292832B76F26C135FD983BD732B8305951A6BDB77DB94C6536F8302\n51925E3D8C8C8D384E4873AB679A68859176970971646CA177095A9295416BCF\n7F8E66275BD059B95A9A95E895F74EEC840C84996AAC76DF9530731B68A65B5F\n772F919A97617CDC8FF78C1C5F257C7379D889C56CCC871C5BC65E4268C97720\n7EF55195514D52C95A297F05976282D763CF778485D079D26E3A5E9959998511\n706D6C1162BF76BF654F60AF95FD660E879F9E2394ED540D547D8C2C64780000\nC4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n81408141814281438144814581478149814D814E814F8152815681578158815B\n815C815D815E815F816181628163816481668168816A816B816C816F81728173\n81758176817781788181818381848185818681878189818B818C818D818E8190\n8192819381948195819681978199819A819E819F81A081A181A281A481A50000\n81A781A981AB81AC81AD81AE81AF81B081B181B281B481B581B681B781B881B9\n81BC81BD81BE81BF81C481C581C781C881C981CB81CD81CE81CF81D081D181D2\n81D3647986116A21819C78E864699B5462B9672B83AB58A89ED86CAB6F205BDE\n964C8C0B725F67D062C772614EA959C66BCD589366AE5E5552DF6155672876EE\n776672677A4662FF54EA545094A090A35A1C7EB36C164E435976801059485357\n753796BE56CA63208111607C95F96DD65462998151855AE980FD59AE9713502A\n6CE55C3C62DF4F60533F817B90066EBA852B62C85E7478BE64B5637B5FF55A18\n917F9E1F5C3F634F80425B7D556E954A954D6D8560A867E072DE51DD5B810000\nC5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n81D481D581D681D781D881D981DA81DB81DC81DD81DE81DF81E081E181E281E4\n81E581E681E881E981EB81EE81EF81F081F181F281F581F681F781F881F981FA\n81FD81FF8203820782088209820A820B820E820F821182138215821682178218\n8219821A821D822082248225822682278229822E8232823A823C823D823F0000\n8240824182428243824582468248824A824C824D824E82508251825282538254\n8255825682578259825B825C825D825E82608261826282638264826582668267\n826962E76CDE725B626D94AE7EBD81136D53519C5F04597452AA601259736696\n8650759F632A61E67CEF8BFA54E66B279E256BB485D5545550766CA4556A8DB4\n722C5E156015743662CD6392724C5F986E436D3E65006F5876D878D076FC7554\n522453DB4E535E9E65C1802A80D6629B5486522870AE888D8DD16CE1547880DA\n57F988F48D54966A914D4F696C9B55B776C6783062A870F96F8E5F6D84EC68DA\n787C7BF781A8670B9E4F636778B0576F78129739627962AB528874356BD70000\nC6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n826A826B826C826D82718275827682778278827B827C82808281828382858286\n82878289828C82908293829482958296829A829B829E82A082A282A382A782B2\n82B582B682BA82BB82BC82BF82C082C282C382C582C682C982D082D682D982DA\n82DD82E282E782E882E982EA82EC82ED82EE82F082F282F382F582F682F80000\n82FA82FC82FD82FE82FF8300830A830B830D831083128313831683188319831D\n831E831F83208321832283238324832583268329832A832E833083328337833B\n833D5564813E75B276AE533975DE50FB5C418B6C7BC7504F72479A9798D86F02\n74E27968648777A562FC98918D2B54C180584E52576A82F9840D5E7351ED74F6\n8BC45C4F57616CFC98875A4678349B448FEB7C955256625194FA4EC683868461\n83E984B257D467345703666E6D668C3166DD7011671F6B3A6816621A59BB4E03\n51C46F0667D26C8F517668CB59476B6775665D0E81109F5065D7794879419A91\n8D775C824E5E4F01542F5951780C56686C148FC45F036C7D6CE38BAB63900000\nC7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n833E833F83418342834483458348834A834B834C834D834E8353835583568357\n83588359835D836283708371837283738374837583768379837A837E837F8380\n838183828383838483878388838A838B838C838D838F83908391839483958396\n83978399839A839D839F83A183A283A383A483A583A683A783AC83AD83AE0000\n83AF83B583BB83BE83BF83C283C383C483C683C883C983CB83CD83CE83D083D1\n83D283D383D583D783D983DA83DB83DE83E283E383E483E683E783E883EB83EC\n83ED60706D3D72756266948E94C553438FC17B7E4EDF8C264E7E9ED494B194B3\n524D6F5C90636D458C3458115D4C6B206B4967AA545B81547F8C589985375F3A\n62A26A47953965726084686577A74E544FA85DE7979864AC7FD85CED4FCF7A8D\n520783044E14602F7A8394A64FB54EB279E6743452E482B964D279BD5BDD6C81\n97528F7B6C22503E537F6E0564CE66746C3060C598778BF75E86743C7A7779CB\n4E1890B174036C4256DA914B6CC58D8B533A86C666F28EAF5C489A716E200000\nC8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n83EE83EF83F383F483F583F683F783FA83FB83FC83FE83FF8400840284058407\n84088409840A84108412841384148415841684178419841A841B841E841F8420\n8421842284238429842A842B842C842D842E842F843084328433843484358436\n84378439843A843B843E843F8440844184428443844484458447844884490000\n844A844B844C844D844E844F8450845284538454845584568458845D845E845F\n8460846284648465846684678468846A846E846F84708472847484778479847B\n847C53D65A369F8B8DA353BB570898A76743919B6CC9516875CA62F372AC5238\n529D7F3A7094763853749E4A69B7786E96C088D97FA4713671C3518967D374E4\n58E4651856B78BA9997662707ED560F970ED58EC4EC14EBA5FCD97E74EFB8BA4\n5203598A7EAB62544ECD65E5620E833884C98363878D71946EB65BB97ED25197\n63C967D480898339881551125B7A59828FB14E736C5D516589258F6F962E854A\n745E951095F06DA682E55F3164926D128428816E9CC3585E8D5B4E0953C10000\nC9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n847D847E847F848084818483848484858486848A848D848F8490849184928493\n8494849584968498849A849B849D849E849F84A084A284A384A484A584A684A7\n84A884A984AA84AB84AC84AD84AE84B084B184B384B584B684B784BB84BC84BE\n84C084C284C384C584C684C784C884CB84CC84CE84CF84D284D484D584D70000\n84D884D984DA84DB84DC84DE84E184E284E484E784E884E984EA84EB84ED84EE\n84EF84F184F284F384F484F584F684F784F884F984FA84FB84FD84FE85008501\n85024F1E6563685155D34E2764149A9A626B5AC2745F82726DA968EE50E7838E\n7802674052396C997EB150BB5565715E7B5B665273CA82EB67495C715220717D\n886B95EA965564C58D6181B355846C5562477F2E58924F2455468D4F664C4E0A\n5C1A88F368A2634E7A0D70E7828D52FA97F65C1154E890B57ECD59628D4A86C7\n820C820D8D6664445C0461516D89793E8BBE78377533547B4F388EAB6DF15A20\n7EC5795E6C885BA15A76751A80BE614E6E1758F0751F7525727253477EF30000\nCA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8503850485058506850785088509850A850B850D850E850F8510851285148515\n851685188519851B851C851D851E852085228523852485258526852785288529\n852A852D852E852F8530853185328533853485358536853E853F854085418542\n8544854585468547854B854C854D854E854F8550855185528553855485550000\n85578558855A855B855C855D855F85608561856285638565856685678569856A\n856B856C856D856E856F8570857185738575857685778578857C857D857F8580\n8581770176DB526980DC57235E08593172EE65BD6E7F8BD75C388671534177F3\n62FE65F64EC098DF86805B9E8BC653F277E24F7F5C4E9A7659CB5F0F793A58EB\n4E1667FF4E8B62ED8A93901D52BF662F55DC566C90024ED54F8D91CA99706C0F\n5E0260435BA489C68BD56536624B99965B885BFF6388552E53D77626517D852C\n67A268B36B8A62928F9353D482126DD1758F4E668D4E5B70719F85AF669166D9\n7F7287009ECD9F205C5E672F8FF06811675F620D7AD658855EB665706F310000\nCB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n85828583858685888589858A858B858C858D858E859085918592859385948595\n8596859785988599859A859D859E859F85A085A185A285A385A585A685A785A9\n85AB85AC85AD85B185B285B385B485B585B685B885BA85BB85BC85BD85BE85BF\n85C085C285C385C485C585C685C785C885CA85CB85CC85CD85CE85D185D20000\n85D485D685D785D885D985DA85DB85DD85DE85DF85E085E185E285E385E585E6\n85E785E885EA85EB85EC85ED85EE85EF85F085F185F285F385F485F585F685F7\n85F860555237800D6454887075295E05681362F4971C53CC723D8C016C347761\n7A0E542E77AC987A821C8BF47855671470C165AF64955636601D79C153F84E1D\n6B7B80865BFA55E356DB4F3A4F3C99725DF3677E80386002988290015B8B8BBC\n8BF5641C825864DE55FD82CF91654FD77D20901F7C9F50F358516EAF5BBF8BC9\n80839178849C7B97867D968B968F7EE59AD3788E5C817A57904296A7795F5B59\n635F7B0B84D168AD55067F2974107D2295016240584C4ED65B83597958540000\nCC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n85F985FA85FC85FD85FE860086018602860386048606860786088609860A860B\n860C860D860E860F86108612861386148615861786188619861A861B861C861D\n861E861F86208621862286238624862586268628862A862B862C862D862E862F\n863086318632863386348635863686378639863A863B863D863E863F86400000\n864186428643864486458646864786488649864A864B864C8652865386558656\n865786588659865B865C865D865F866086618663866486658666866786688669\n866A736D631E8E4B8E0F80CE82D462AC53F06CF0915E592A60016C70574D644A\n8D2A762B6EE9575B6A8075F06F6D8C2D8C0857666BEF889278B363A253F970AD\n6C645858642A580268E0819B55107CD650188EBA6DCC8D9F70EB638F6D9B6ED4\n7EE68404684390036DD896768BA85957727985E4817E75BC8A8A68AF52548E22\n951163D098988E44557C4F5366FF568F60D56D9552435C4959296DFB586B7530\n751C606C82148146631167618FE2773A8DF38D3494C15E165385542C70C30000\nCD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n866D866F86708672867386748675867686778678868386848685868686878688\n8689868E868F86908691869286948696869786988699869A869B869E869F86A0\n86A186A286A586A686AB86AD86AE86B286B386B786B886B986BB86BC86BD86BE\n86BF86C186C286C386C586C886CC86CD86D286D386D586D686D786DA86DC0000\n86DD86E086E186E286E386E586E686E786E886EA86EB86EC86EF86F586F686F7\n86FA86FB86FC86FD86FF8701870487058706870B870C870E870F871087118714\n87166C405EF7505C4EAD5EAD633A8247901A6850916E77B3540C94DC5F647AE5\n687663457B527EDF75DB507762955934900F51F879C37A8156FE5F9290146D82\n5C60571F541051546E4D56E263A89893817F8715892A9000541E5C6F81C062D6\n625881319E3596409A6E9A7C692D59A562D3553E631654C786D96D3C5A0374E6\n889C6B6A59168C4C5F2F6E7E73A9987D4E3870F75B8C7897633D665A769660CB\n5B9B5A494E0781556C6A738B4EA167897F515F8065FA671B5FD859845A010000\nCE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8719871B871D871F87208724872687278728872A872B872C872D872F87308732\n87338735873687388739873A873C873D8740874187428743874487458746874A\n874B874D874F8750875187528754875587568758875A875B875C875D875E875F\n876187628766876787688769876A876B876C876D876F87718772877387750000\n877787788779877A877F878087818784878687878789878A878C878E878F8790\n8791879287948795879687988799879A879B879C879D879E87A087A187A287A3\n87A45DCD5FAE537197E68FDD684556F4552F60DF4E3A6F4D7EF482C7840E59D4\n4F1F4F2A5C3E7EAC672A851A5473754F80C355829B4F4F4D6E2D8C135C096170\n536B761F6E29868A658795FB7EB9543B7A337D0A95EE55E17FC174EE631D8717\n6DA17A9D621165A1536763E16C835DEB545C94A84E4C6C618BEC5C4B65E0829C\n68A7543E54346BCB6B664E9463425348821E4F0D4FAE575E620A96FE66647269\n52FF52A1609F8BEF661471996790897F785277FD6670563B54389521727A0000\nCF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n87A587A687A787A987AA87AE87B087B187B287B487B687B787B887B987BB87BC\n87BE87BF87C187C287C387C487C587C787C887C987CC87CD87CE87CF87D087D4\n87D587D687D787D887D987DA87DC87DD87DE87DF87E187E287E387E487E687E7\n87E887E987EB87EC87ED87EF87F087F187F287F387F487F587F687F787F80000\n87FA87FB87FC87FD87FF880088018802880488058806880788088809880B880C\n880D880E880F8810881188128814881788188819881A881C881D881E881F8820\n88237A00606F5E0C6089819D591560DC718470EF6EAA6C5072806A8488AD5E2D\n4E605AB3559C94E36D177CFB9699620F7EC6778E867E5323971E8F9666875CE1\n4FA072ED4E0B53A6590F54136380952851484ED99C9C7EA454B88D2488548237\n95F26D8E5F265ACC663E966973B0732E53BF817A99857FA15BAA967796507EBF\n76F853A2957699997BB189446E584E617FD479658BE660F354CD4EAB98795DF7\n6A6150CF54118C618427785D9704524A54EE56A395006D885BB56DC666530000\nD0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n882488258826882788288829882A882B882C882D882E882F8830883188338834\n8835883688378838883A883B883D883E883F8841884288438846884788488849\n884A884B884E884F8850885188528853885588568858885A885B885C885D885E\n885F886088668867886A886D886F8871887388748875887688788879887A0000\n887B887C88808883888688878889888A888C888E888F88908891889388948895\n889788988899889A889B889D889E889F88A088A188A388A588A688A788A888A9\n88AA5C0F5B5D6821809655787B11654869544E9B6B47874E978B534F631F643A\n90AA659C80C18C10519968B0537887F961C86CC46CFB8C225C5185AA82AF950C\n6B238F9B65B05FFB5FC34FE18845661F8165732960FA51745211578B5F6290A2\n884C91925E78674F602759D3514451F680F853086C7996C4718A4F114FEE7F9E\n673D55C5950879C088967EE3589F620C9700865A5618987B5F908BB884C49157\n53D965ED5E8F755C60647D6E5A7F7EEA7EED8F6955A75BA360AC65CB73840000\nD1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n88AC88AE88AF88B088B288B388B488B588B688B888B988BA88BB88BD88BE88BF\n88C088C388C488C788C888CA88CB88CC88CD88CF88D088D188D388D688D788DA\n88DB88DC88DD88DE88E088E188E688E788E988EA88EB88EC88ED88EE88EF88F2\n88F588F688F788FA88FB88FD88FF890089018903890489058906890789080000\n8909890B890C890D890E890F891189148915891689178918891C891D891E891F\n89208922892389248926892789288929892C892D892E892F8931893289338935\n89379009766377297EDA9774859B5B667A7496EA884052CB718F5FAA65EC8BE2\n5BFB9A6F5DE16B896C5B8BAD8BAF900A8FC5538B62BC9E269E2D54404E2B82BD\n7259869C5D1688596DAF96C554D14E9A8BB6710954BD960970DF6DF976D04E25\n781487125CA95EF68A00989C960E708E6CBF594463A9773C884D6F1482735830\n71D5538C781A96C155015F6671305BB48C1A9A8C6B83592E9E2F79E76768626C\n4F6F75A17F8A6D0B96336C274EF075D2517B68376F3E90808170599674760000\nD2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n89388939893A893B893C893D893E893F89408942894389458946894789488949\n894A894B894C894D894E894F8950895189528953895489558956895789588959\n895A895B895C895D896089618962896389648965896789688969896A896B896C\n896D896E896F8970897189728973897489758976897789788979897A897C0000\n897D897E8980898289848985898789888989898A898B898C898D898E898F8990\n899189928993899489958996899789988999899A899B899C899D899E899F89A0\n89A164475C2790657A918C2359DA54AC8200836F898180006930564E80367237\n91CE51B64E5F987563964E1A53F666F3814B591C6DB24E0058F9533B63D694F1\n4F9D4F0A886398905937905779FB4EEA80F075916C825B9C59E85F5D69058681\n501A5DF24E5977E34EE5827A6291661390915C794EBF5F7981C69038808475AB\n4EA688D4610F6BC55FC64E4976CA6EA28BE38BAE8C0A8BD15F027FFC7FCC7ECE\n8335836B56E06BB797F3963459FB541F94F66DEB5BC5996E5C395F1596900000\nD3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n89A289A389A489A589A689A789A889A989AA89AB89AC89AD89AE89AF89B089B1\n89B289B389B489B589B689B789B889B989BA89BB89BC89BD89BE89BF89C089C3\n89CD89D389D489D589D789D889D989DB89DD89DF89E089E189E289E489E789E8\n89E989EA89EC89ED89EE89F089F189F289F489F589F689F789F889F989FA0000\n89FB89FC89FD89FE89FF8A018A028A038A048A058A068A088A098A0A8A0B8A0C\n8A0D8A0E8A0F8A108A118A128A138A148A158A168A178A188A198A1A8A1B8A1C\n8A1D537082F16A315A749E705E947F2883B984248425836787478FCE8D6276C8\n5F719896786C662054DF62E54F6381C375C85EB896CD8E0A86F9548F6CF36D8C\n6C38607F52C775285E7D4F1860A05FE75C24753190AE94C072B96CB96E389149\n670953CB53F34F5191C98BF153C85E7C8FC26DE44E8E76C26986865E611A8206\n4F594FDE903E9C7C61096E1D6E1496854E885A3196E84E0E5C7F79B95B878BED\n7FBD738957DF828B90C15401904755BB5CEA5FA161086B3272F180B28A890000\nD4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8A1E8A1F8A208A218A228A238A248A258A268A278A288A298A2A8A2B8A2C8A2D\n8A2E8A2F8A308A318A328A338A348A358A368A378A388A398A3A8A3B8A3C8A3D\n8A3F8A408A418A428A438A448A458A468A478A498A4A8A4B8A4C8A4D8A4E8A4F\n8A508A518A528A538A548A558A568A578A588A598A5A8A5B8A5C8A5D8A5E0000\n8A5F8A608A618A628A638A648A658A668A678A688A698A6A8A6B8A6C8A6D8A6E\n8A6F8A708A718A728A738A748A758A768A778A788A7A8A7B8A7C8A7D8A7E8A7F\n8A806D745BD388D598848C6B9A6D9E336E0A51A4514357A38881539F63F48F95\n56ED54585706733F6E907F188FDC82D1613F6028966266F07EA68D8A8DC394A5\n5CB37CA4670860A6960580184E9190E75300966851418FD08574915D665597F5\n5B55531D78386742683D54C9707E5BB08F7D518D572854B1651266828D5E8D43\n810F846C906D7CDF51FF85FB67A365E96FA186A48E81566A90207682707671E5\n8D2362E952196CFD8D3C600E589E618E66FE8D60624E55B36E23672D8F670000\nD5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8A818A828A838A848A858A868A878A888A8B8A8C8A8D8A8E8A8F8A908A918A92\n8A948A958A968A978A988A998A9A8A9B8A9C8A9D8A9E8A9F8AA08AA18AA28AA3\n8AA48AA58AA68AA78AA88AA98AAA8AAB8AAC8AAD8AAE8AAF8AB08AB18AB28AB3\n8AB48AB58AB68AB78AB88AB98ABA8ABB8ABC8ABD8ABE8ABF8AC08AC18AC20000\n8AC38AC48AC58AC68AC78AC88AC98ACA8ACB8ACC8ACD8ACE8ACF8AD08AD18AD2\n8AD38AD48AD58AD68AD78AD88AD98ADA8ADB8ADC8ADD8ADE8ADF8AE08AE18AE2\n8AE394E195F87728680569A8548B4E4D70B88BC86458658B5B857A84503A5BE8\n77BB6BE18A797C986CBE76CF65A98F975D2D5C5586386808536062187AD96E5B\n7EFD6A1F7AE05F706F335F20638C6DA867564E085E108D264ED780C07634969C\n62DB662D627E6CBC8D7571677F695146808753EC906E629854F286F08F998005\n951785178FD96D5973CD659F771F7504782781FB8D1E94884FA6679575B98BCA\n9707632F9547963584B8632377415F8172F04E896014657462EF6B63653F0000\nD6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8AE48AE58AE68AE78AE88AE98AEA8AEB8AEC8AED8AEE8AEF8AF08AF18AF28AF3\n8AF48AF58AF68AF78AF88AF98AFA8AFB8AFC8AFD8AFE8AFF8B008B018B028B03\n8B048B058B068B088B098B0A8B0B8B0C8B0D8B0E8B0F8B108B118B128B138B14\n8B158B168B178B188B198B1A8B1B8B1C8B1D8B1E8B1F8B208B218B228B230000\n8B248B258B278B288B298B2A8B2B8B2C8B2D8B2E8B2F8B308B318B328B338B34\n8B358B368B378B388B398B3A8B3B8B3C8B3D8B3E8B3F8B408B418B428B438B44\n8B455E2775C790D18BC1829D679D652F5431871877E580A281026C414E4B7EC7\n804C76F4690D6B966267503C4F84574063076B628DBE53EA65E87EB85FD7631A\n63B781F381F47F6E5E1C5CD95236667A79E97A1A8D28709975D46EDE6CBB7A92\n4E2D76C55FE0949F88777EC879CD80BF91CD4EF24F17821F54685DDE6D328BCC\n7CA58F7480985E1A549276B15B99663C9AA473E0682A86DB6731732A8BF88BDB\n90107AF970DB716E62C477A956314E3B845767F152A986C08D2E94F87B510000\nD7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8B468B478B488B498B4A8B4B8B4C8B4D8B4E8B4F8B508B518B528B538B548B55\n8B568B578B588B598B5A8B5B8B5C8B5D8B5E8B5F8B608B618B628B638B648B65\n8B678B688B698B6A8B6B8B6D8B6E8B6F8B708B718B728B738B748B758B768B77\n8B788B798B7A8B7B8B7C8B7D8B7E8B7F8B808B818B828B838B848B858B860000\n8B878B888B898B8A8B8B8B8C8B8D8B8E8B8F8B908B918B928B938B948B958B96\n8B978B988B998B9A8B9B8B9C8B9D8B9E8B9F8BAC8BB18BBB8BC78BD08BEA8C09\n8C1E4F4F6CE8795D9A7B6293722A62FD4E1378168F6C64B08D5A7BC668695E84\n88C55986649E58EE72B6690E95258FFD8D5857607F008C0651C6634962D95353\n684C74228301914C55447740707C6D4A517954A88D4459FF6ECB6DC45B5C7D2B\n4ED47C7D6ED35B5081EA6E0D5B579B0368D58E2A5B977EFC603B7EB590B98D70\n594F63CD79DF8DB3535265CF79568BC5963B7EC494BB7E825634918967007F6A\n5C0A907566285DE64F5067DE505A4F5C57505EA7000000000000000000000000\nD8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8C388C398C3A8C3B8C3C8C3D8C3E8C3F8C408C428C438C448C458C488C4A8C4B\n8C4D8C4E8C4F8C508C518C528C538C548C568C578C588C598C5B8C5C8C5D8C5E\n8C5F8C608C638C648C658C668C678C688C698C6C8C6D8C6E8C6F8C708C718C72\n8C748C758C768C778C7B8C7C8C7D8C7E8C7F8C808C818C838C848C868C870000\n8C888C8B8C8D8C8E8C8F8C908C918C928C938C958C968C978C998C9A8C9B8C9C\n8C9D8C9E8C9F8CA08CA18CA28CA38CA48CA58CA68CA78CA88CA98CAA8CAB8CAC\n8CAD4E8D4E0C51404E105EFF53454E154E984E1E9B325B6C56694E2879BA4E3F\n53154E47592D723B536E6C1056DF80E499976BD3777E9F174E364E9F9F104E5C\n4E694E9382885B5B556C560F4EC4538D539D53A353A553AE97658D5D531A53F5\n5326532E533E8D5C5366536352025208520E522D5233523F5240524C525E5261\n525C84AF527D528252815290529351827F544EBB4EC34EC94EC24EE84EE14EEB\n4EDE4F1B4EF34F224F644EF54F254F274F094F2B4F5E4F6765384F5A4F5D0000\nD9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8CAE8CAF8CB08CB18CB28CB38CB48CB58CB68CB78CB88CB98CBA8CBB8CBC8CBD\n8CBE8CBF8CC08CC18CC28CC38CC48CC58CC68CC78CC88CC98CCA8CCB8CCC8CCD\n8CCE8CCF8CD08CD18CD28CD38CD48CD58CD68CD78CD88CD98CDA8CDB8CDC8CDD\n8CDE8CDF8CE08CE18CE28CE38CE48CE58CE68CE78CE88CE98CEA8CEB8CEC0000\n8CED8CEE8CEF8CF08CF18CF28CF38CF48CF58CF68CF78CF88CF98CFA8CFB8CFC\n8CFD8CFE8CFF8D008D018D028D038D048D058D068D078D088D098D0A8D0B8D0C\n8D0D4F5F4F574F324F3D4F764F744F914F894F834F8F4F7E4F7B4FAA4F7C4FAC\n4F944FE64FE84FEA4FC54FDA4FE34FDC4FD14FDF4FF85029504C4FF3502C500F\n502E502D4FFE501C500C50255028507E504350555048504E506C507B50A550A7\n50A950BA50D6510650ED50EC50E650EE5107510B4EDD6C3D4F584F654FCE9FA0\n6C467C74516E5DFD9EC999985181591452F9530D8A07531051EB591951554EA0\n51564EB3886E88A44EB5811488D279805B3488037FB851AB51B151BD51BC0000\nDA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8D0E8D0F8D108D118D128D138D148D158D168D178D188D198D1A8D1B8D1C8D20\n8D518D528D578D5F8D658D688D698D6A8D6C8D6E8D6F8D718D728D788D798D7A\n8D7B8D7C8D7D8D7E8D7F8D808D828D838D868D878D888D898D8C8D8D8D8E8D8F\n8D908D928D938D958D968D978D988D998D9A8D9B8D9C8D9D8D9E8DA08DA10000\n8DA28DA48DA58DA68DA78DA88DA98DAA8DAB8DAC8DAD8DAE8DAF8DB08DB28DB6\n8DB78DB98DBB8DBD8DC08DC18DC28DC58DC78DC88DC98DCA8DCD8DD08DD28DD3\n8DD451C7519651A251A58BA08BA68BA78BAA8BB48BB58BB78BC28BC38BCB8BCF\n8BCE8BD28BD38BD48BD68BD88BD98BDC8BDF8BE08BE48BE88BE98BEE8BF08BF3\n8BF68BF98BFC8BFF8C008C028C048C078C0C8C0F8C118C128C148C158C168C19\n8C1B8C188C1D8C1F8C208C218C258C278C2A8C2B8C2E8C2F8C328C338C358C36\n5369537A961D962296219631962A963D963C964296499654965F9667966C9672\n96749688968D969796B09097909B909D909990AC90A190B490B390B690BA0000\nDB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8DD58DD88DD98DDC8DE08DE18DE28DE58DE68DE78DE98DED8DEE8DF08DF18DF2\n8DF48DF68DFC8DFE8DFF8E008E018E028E038E048E068E078E088E0B8E0D8E0E\n8E108E118E128E138E158E168E178E188E198E1A8E1B8E1C8E208E218E248E25\n8E268E278E288E2B8E2D8E308E328E338E348E368E378E388E3B8E3C8E3E0000\n8E3F8E438E458E468E4C8E4D8E4E8E4F8E508E538E548E558E568E578E588E5A\n8E5B8E5C8E5D8E5E8E5F8E608E618E628E638E648E658E678E688E6A8E6B8E6E\n8E7190B890B090CF90C590BE90D090C490C790D390E690E290DC90D790DB90EB\n90EF90FE91049122911E91239131912F913991439146520D594252A252AC52AD\n52BE54FF52D052D652F053DF71EE77CD5EF451F551FC9B2F53B65F01755A5DEF\n574C57A957A1587E58BC58C558D15729572C572A57335739572E572F575C573B\n574257695785576B5786577C577B5768576D5776577357AD57A4578C57B257CF\n57A757B4579357A057D557D857DA57D957D257B857F457EF57F857E457DD0000\nDC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8E738E758E778E788E798E7A8E7B8E7D8E7E8E808E828E838E848E868E888E89\n8E8A8E8B8E8C8E8D8E8E8E918E928E938E958E968E978E988E998E9A8E9B8E9D\n8E9F8EA08EA18EA28EA38EA48EA58EA68EA78EA88EA98EAA8EAD8EAE8EB08EB1\n8EB38EB48EB58EB68EB78EB88EB98EBB8EBC8EBD8EBE8EBF8EC08EC18EC20000\n8EC38EC48EC58EC68EC78EC88EC98ECA8ECB8ECC8ECD8ECF8ED08ED18ED28ED3\n8ED48ED58ED68ED78ED88ED98EDA8EDB8EDC8EDD8EDE8EDF8EE08EE18EE28EE3\n8EE4580B580D57FD57ED5800581E5819584458205865586C58815889589A5880\n99A89F1961FF8279827D827F828F828A82A88284828E82918297829982AB82B8\n82BE82B082C882CA82E3829882B782AE82CB82CC82C182A982B482A182AA829F\n82C482CE82A482E1830982F782E4830F830782DC82F482D282D8830C82FB82D3\n8311831A83068314831582E082D5831C8351835B835C83088392833C83348331\n839B835E832F834F83478343835F834083178360832D833A8333836683650000\nDD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8EE58EE68EE78EE88EE98EEA8EEB8EEC8EED8EEE8EEF8EF08EF18EF28EF38EF4\n8EF58EF68EF78EF88EF98EFA8EFB8EFC8EFD8EFE8EFF8F008F018F028F038F04\n8F058F068F078F088F098F0A8F0B8F0C8F0D8F0E8F0F8F108F118F128F138F14\n8F158F168F178F188F198F1A8F1B8F1C8F1D8F1E8F1F8F208F218F228F230000\n8F248F258F268F278F288F298F2A8F2B8F2C8F2D8F2E8F2F8F308F318F328F33\n8F348F358F368F378F388F398F3A8F3B8F3C8F3D8F3E8F3F8F408F418F428F43\n8F448368831B8369836C836A836D836E83B0837883B383B483A083AA8393839C\n8385837C83B683A9837D83B8837B8398839E83A883BA83BC83C1840183E583D8\n58078418840B83DD83FD83D6841C84388411840683D483DF840F840383F883F9\n83EA83C583C0842683F083E1845C8451845A8459847384878488847A84898478\n843C844684698476848C848E8431846D84C184CD84D084E684BD84D384CA84BF\n84BA84E084A184B984B4849784E584E3850C750D853884F08539851F853A0000\nDE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8F458F468F478F488F498F4A8F4B8F4C8F4D8F4E8F4F8F508F518F528F538F54\n8F558F568F578F588F598F5A8F5B8F5C8F5D8F5E8F5F8F608F618F628F638F64\n8F658F6A8F808F8C8F928F9D8FA08FA18FA28FA48FA58FA68FA78FAA8FAC8FAD\n8FAE8FAF8FB28FB38FB48FB58FB78FB88FBA8FBB8FBC8FBF8FC08FC38FC60000\n8FC98FCA8FCB8FCC8FCD8FCF8FD28FD68FD78FDA8FE08FE18FE38FE78FEC8FEF\n8FF18FF28FF48FF58FF68FFA8FFB8FFC8FFE8FFF90079008900C900E90139015\n90188556853B84FF84FC8559854885688564855E857A77A285438572857B85A4\n85A88587858F857985AE859C858585B985B785B085D385C185DC85FF86278605\n86298616863C5EFE5F08593C594180375955595A5958530F5C225C255C2C5C34\n624C626A629F62BB62CA62DA62D762EE632262F66339634B634363AD63F66371\n637A638E63B4636D63AC638A636963AE63BC63F263F863E063FF63C463DE63CE\n645263C663BE64456441640B641B6420640C64266421645E6484646D64960000\nDF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9019901C902390249025902790289029902A902B902C90309031903290339034\n90379039903A903D903F904090439045904690489049904A904B904C904E9054\n905590569059905A905C905D905E905F906090619064906690679069906A906B\n906C906F90709071907290739076907790789079907A907B907C907E90810000\n90849085908690879089908A908C908D908E908F90909092909490969098909A\n909C909E909F90A090A490A590A790A890A990AB90AD90B290B790BC90BD90BF\n90C0647A64B764B8649964BA64C064D064D764E464E265096525652E5F0B5FD2\n75195F11535F53F153FD53E953E853FB541254165406544B5452545354545456\n54435421545754595423543254825494547754715464549A549B548454765466\n549D54D054AD54C254B454D254A754A654D354D4547254A354D554BB54BF54CC\n54D954DA54DC54A954AA54A454DD54CF54DE551B54E7552054FD551454F35522\n5523550F55115527552A5567558F55B55549556D55415555553F5550553C0000\nE0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n90C290C390C690C890C990CB90CC90CD90D290D490D590D690D890D990DA90DE\n90DF90E090E390E490E590E990EA90EC90EE90F090F190F290F390F590F690F7\n90F990FA90FB90FC90FF91009101910391059106910791089109910A910B910C\n910D910E910F911091119112911391149115911691179118911A911B911C0000\n911D911F91209121912491259126912791289129912A912B912C912D912E9130\n9132913391349135913691379138913A913B913C913D913E913F914091419142\n91445537555655755576557755335530555C558B55D2558355B155B955885581\n559F557E55D65591557B55DF55BD55BE5594559955EA55F755C9561F55D155EB\n55EC55D455E655DD55C455EF55E555F255F355CC55CD55E855F555E48F94561E\n5608560C56015624562355FE56005627562D565856395657562C564D56625659\n565C564C5654568656645671566B567B567C5685569356AF56D456D756DD56E1\n56F556EB56F956FF5704570A5709571C5E0F5E195E145E115E315E3B5E3C0000\nE1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9145914791489151915391549155915691589159915B915C915F916091669167\n9168916B916D9173917A917B917C9180918191829183918491869188918A918E\n918F9193919491959196919791989199919C919D919E919F91A091A191A491A5\n91A691A791A891A991AB91AC91B091B191B291B391B691B791B891B991BB0000\n91BC91BD91BE91BF91C091C191C291C391C491C591C691C891CB91D091D291D3\n91D491D591D691D791D891D991DA91DB91DD91DE91DF91E091E191E291E391E4\n91E55E375E445E545E5B5E5E5E615C8C5C7A5C8D5C905C965C885C985C995C91\n5C9A5C9C5CB55CA25CBD5CAC5CAB5CB15CA35CC15CB75CC45CD25CE45CCB5CE5\n5D025D035D275D265D2E5D245D1E5D065D1B5D585D3E5D345D3D5D6C5D5B5D6F\n5D5D5D6B5D4B5D4A5D695D745D825D995D9D8C735DB75DC55F735F775F825F87\n5F895F8C5F955F995F9C5FA85FAD5FB55FBC88625F6172AD72B072B472B772B8\n72C372C172CE72CD72D272E872EF72E972F272F472F7730172F3730372FA0000\nE2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n91E691E791E891E991EA91EB91EC91ED91EE91EF91F091F191F291F391F491F5\n91F691F791F891F991FA91FB91FC91FD91FE91FF920092019202920392049205\n9206920792089209920A920B920C920D920E920F921092119212921392149215\n9216921792189219921A921B921C921D921E921F922092219222922392240000\n92259226922792289229922A922B922C922D922E922F92309231923292339234\n92359236923792389239923A923B923C923D923E923F92409241924292439244\n924572FB731773137321730A731E731D7315732273397325732C733873317350\n734D73577360736C736F737E821B592598E7592459029963996799689969996A\n996B996C99749977997D998099849987998A998D999099919993999499955E80\n5E915E8B5E965EA55EA05EB95EB55EBE5EB38D535ED25ED15EDB5EE85EEA81BA\n5FC45FC95FD65FCF60035FEE60045FE15FE45FFE600560065FEA5FED5FF86019\n60356026601B600F600D6029602B600A603F602160786079607B607A60420000\nE3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9246924792489249924A924B924C924D924E924F925092519252925392549255\n9256925792589259925A925B925C925D925E925F926092619262926392649265\n9266926792689269926A926B926C926D926E926F927092719272927392759276\n927792789279927A927B927C927D927E927F9280928192829283928492850000\n9286928792889289928A928B928C928D928F9290929192929293929492959296\n929792989299929A929B929C929D929E929F92A092A192A292A392A492A592A6\n92A7606A607D6096609A60AD609D60836092608C609B60EC60BB60B160DD60D8\n60C660DA60B4612061266115612360F46100610E612B614A617561AC619461A7\n61B761D461F55FDD96B395E995EB95F195F395F595F695FC95FE960396049606\n9608960A960B960C960D960F96129615961696179619961A4E2C723F62156C35\n6C546C5C6C4A6CA36C856C906C946C8C6C686C696C746C766C866CA96CD06CD4\n6CAD6CF76CF86CF16CD76CB26CE06CD66CFA6CEB6CEE6CB16CD36CEF6CFE0000\nE4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n92A892A992AA92AB92AC92AD92AF92B092B192B292B392B492B592B692B792B8\n92B992BA92BB92BC92BD92BE92BF92C092C192C292C392C492C592C692C792C9\n92CA92CB92CC92CD92CE92CF92D092D192D292D392D492D592D692D792D892D9\n92DA92DB92DC92DD92DE92DF92E092E192E292E392E492E592E692E792E80000\n92E992EA92EB92EC92ED92EE92EF92F092F192F292F392F492F592F692F792F8\n92F992FA92FB92FC92FD92FE92FF930093019302930393049305930693079308\n93096D396D276D0C6D436D486D076D046D196D0E6D2B6D4D6D2E6D356D1A6D4F\n6D526D546D336D916D6F6D9E6DA06D5E6D936D946D5C6D606D7C6D636E1A6DC7\n6DC56DDE6E0E6DBF6DE06E116DE66DDD6DD96E166DAB6E0C6DAE6E2B6E6E6E4E\n6E6B6EB26E5F6E866E536E546E326E256E446EDF6EB16E986EE06F2D6EE26EA5\n6EA76EBD6EBB6EB76ED76EB46ECF6E8F6EC26E9F6F626F466F476F246F156EF9\n6F2F6F366F4B6F746F2A6F096F296F896F8D6F8C6F786F726F7C6F7A6FD10000\nE5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n930A930B930C930D930E930F9310931193129313931493159316931793189319\n931A931B931C931D931E931F9320932193229323932493259326932793289329\n932A932B932C932D932E932F9330933193329333933493359336933793389339\n933A933B933C933D933F93409341934293439344934593469347934893490000\n934A934B934C934D934E934F9350935193529353935493559356935793589359\n935A935B935C935D935E935F9360936193629363936493659366936793689369\n936B6FC96FA76FB96FB66FC26FE16FEE6FDE6FE06FEF701A7023701B70397035\n704F705E5B805B845B955B935BA55BB8752F9A9E64345BE45BEE89305BF08E47\n8B078FB68FD38FD58FE58FEE8FE48FE98FE68FF38FE890059004900B90269011\n900D9016902190359036902D902F9044905190529050906890589062905B66B9\n9074907D908290889083908B5F505F575F565F585C3B54AB5C505C595B715C63\n5C667FBC5F2A5F295F2D82745F3C9B3B5C6E59815983598D59A959AA59A30000\nE6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n936C936D936E936F9370937193729373937493759376937793789379937A937B\n937C937D937E937F9380938193829383938493859386938793889389938A938B\n938C938D938E9390939193929393939493959396939793989399939A939B939C\n939D939E939F93A093A193A293A393A493A593A693A793A893A993AA93AB0000\n93AC93AD93AE93AF93B093B193B293B393B493B593B693B793B893B993BA93BB\n93BC93BD93BE93BF93C093C193C293C393C493C593C693C793C893C993CB93CC\n93CD599759CA59AB599E59A459D259B259AF59D759BE5A055A0659DD5A0859E3\n59D859F95A0C5A095A325A345A115A235A135A405A675A4A5A555A3C5A625A75\n80EC5AAA5A9B5A775A7A5ABE5AEB5AB25AD25AD45AB85AE05AE35AF15AD65AE6\n5AD85ADC5B095B175B165B325B375B405C155C1C5B5A5B655B735B515B535B62\n9A759A779A789A7A9A7F9A7D9A809A819A859A889A8A9A909A929A939A969A98\n9A9B9A9C9A9D9A9F9AA09AA29AA39AA59AA77E9F7EA17EA37EA57EA87EA90000\nE7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n93CE93CF93D093D193D293D393D493D593D793D893D993DA93DB93DC93DD93DE\n93DF93E093E193E293E393E493E593E693E793E893E993EA93EB93EC93ED93EE\n93EF93F093F193F293F393F493F593F693F793F893F993FA93FB93FC93FD93FE\n93FF9400940194029403940494059406940794089409940A940B940C940D0000\n940E940F9410941194129413941494159416941794189419941A941B941C941D\n941E941F9420942194229423942494259426942794289429942A942B942C942D\n942E7EAD7EB07EBE7EC07EC17EC27EC97ECB7ECC7ED07ED47ED77EDB7EE07EE1\n7EE87EEB7EEE7EEF7EF17EF27F0D7EF67EFA7EFB7EFE7F017F027F037F077F08\n7F0B7F0C7F0F7F117F127F177F197F1C7F1B7F1F7F217F227F237F247F257F26\n7F277F2A7F2B7F2C7F2D7F2F7F307F317F327F337F355E7A757F5DDB753E9095\n738E739173AE73A2739F73CF73C273D173B773B373C073C973C873E573D9987C\n740A73E973E773DE73BA73F2740F742A745B7426742574287430742E742C0000\nE8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n942F9430943194329433943494359436943794389439943A943B943C943D943F\n9440944194429443944494459446944794489449944A944B944C944D944E944F\n9450945194529453945494559456945794589459945A945B945C945D945E945F\n9460946194629463946494659466946794689469946A946C946D946E946F0000\n9470947194729473947494759476947794789479947A947B947C947D947E947F\n9480948194829483948494919496949894C794CF94D394D494DA94E694FB951C\n9520741B741A7441745C7457745574597477746D747E749C748E748074817487\n748B749E74A874A9749074A774D274BA97EA97EB97EC674C6753675E67486769\n67A56787676A6773679867A7677567A8679E67AD678B6777677C67F0680967D8\n680A67E967B0680C67D967B567DA67B367DD680067C367B867E2680E67C167FD\n6832683368606861684E6862684468646883681D68556866684168676840683E\n684A6849682968B5688F687468776893686B68C2696E68FC691F692068F90000\nE9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n95279533953D95439548954B9555955A9560956E95749575957795789579957A\n957B957C957D957E9580958195829583958495859586958795889589958A958B\n958C958D958E958F9590959195929593959495959596959795989599959A959B\n959C959D959E959F95A095A195A295A395A495A595A695A795A895A995AA0000\n95AB95AC95AD95AE95AF95B095B195B295B395B495B595B695B795B895B995BA\n95BB95BC95BD95BE95BF95C095C195C295C395C495C595C695C795C895C995CA\n95CB692468F0690B6901695768E369106971693969606942695D6984696B6980\n69986978693469CC6987698869CE6989696669636979699B69A769BB69AB69AD\n69D469B169C169CA69DF699569E0698D69FF6A2F69ED6A176A186A6569F26A44\n6A3E6AA06A506A5B6A356A8E6A796A3D6A286A586A7C6A916A906AA96A976AAB\n733773526B816B826B876B846B926B936B8D6B9A6B9B6BA16BAA8F6B8F6D8F71\n8F728F738F758F768F788F778F798F7A8F7C8F7E8F818F828F848F878F8B0000\nEA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n95CC95CD95CE95CF95D095D195D295D395D495D595D695D795D895D995DA95DB\n95DC95DD95DE95DF95E095E195E295E395E495E595E695E795EC95FF96079613\n9618961B961E96209623962496259626962796289629962B962C962D962F9630\n963796389639963A963E96419643964A964E964F965196529653965696570000\n96589659965A965C965D965E9660966396659666966B966D966E966F96709671\n967396789679967A967B967C967D967E967F9680968196829683968496879689\n968A8F8D8F8E8F8F8F988F9A8ECE620B6217621B621F6222622162256224622C\n81E774EF74F474FF750F75117513653465EE65EF65F0660A6619677266036615\n6600708566F7661D66346631663666358006665F66546641664F665666616657\n66776684668C66A7669D66BE66DB66DC66E666E98D328D338D368D3B8D3D8D40\n8D458D468D488D498D478D4D8D558D5989C789CA89CB89CC89CE89CF89D089D1\n726E729F725D7266726F727E727F7284728B728D728F72926308633263B00000\nEB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n968C968E96919692969396959696969A969B969D969E969F96A096A196A296A3\n96A496A596A696A896A996AA96AB96AC96AD96AE96AF96B196B296B496B596B7\n96B896BA96BB96BF96C296C396C896CA96CB96D096D196D396D496D696D796D8\n96D996DA96DB96DC96DD96DE96DF96E196E296E396E496E596E696E796EB0000\n96EC96ED96EE96F096F196F296F496F596F896FA96FB96FC96FD96FF97029703\n9705970A970B970C97109711971297149715971797189719971A971B971D971F\n9720643F64D880046BEA6BF36BFD6BF56BF96C056C076C066C0D6C156C186C19\n6C1A6C216C296C246C2A6C3265356555656B724D72527256723086625216809F\n809C809380BC670A80BD80B180AB80AD80B480B780E780E880E980EA80DB80C2\n80C480D980CD80D7671080DD80EB80F180F480ED810D810E80F280FC67158112\n8C5A8136811E812C811881328148814C815381748159815A817181608169817C\n817D816D8167584D5AB58188818281916ED581A381AA81CC672681CA81BB0000\nEC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n972197229723972497259726972797289729972B972C972E972F973197339734\n973597369737973A973B973C973D973F97409741974297439744974597469747\n97489749974A974B974C974D974E974F975097519754975597579758975A975C\n975D975F97639764976697679768976A976B976C976D976E976F977097710000\n97729775977797789779977A977B977D977E977F978097819782978397849786\n978797889789978A978C978E978F979097939795979697979799979A979B979C\n979D81C181A66B246B376B396B436B466B5998D198D298D398D598D998DA6BB3\n5F406BC289F365909F51659365BC65C665C465C365CC65CE65D265D67080709C\n7096709D70BB70C070B770AB70B170E870CA711071137116712F71317173715C\n716871457172714A7178717A719871B371B571A871A071E071D471E771F9721D\n7228706C7118716671B9623E623D624362486249793B794079467949795B795C\n7953795A796279577960796F7967797A7985798A799A79A779B35FD15FD00000\nED\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n979E979F97A197A297A497A597A697A797A897A997AA97AC97AE97B097B197B3\n97B597B697B797B897B997BA97BB97BC97BD97BE97BF97C097C197C297C397C4\n97C597C697C797C897C997CA97CB97CC97CD97CE97CF97D097D197D297D397D4\n97D597D697D797D897D997DA97DB97DC97DD97DE97DF97E097E197E297E30000\n97E497E597E897EE97EF97F097F197F297F497F797F897F997FA97FB97FC97FD\n97FE97FF9800980198029803980498059806980798089809980A980B980C980D\n980E603C605D605A606760416059606360AB6106610D615D61A9619D61CB61D1\n62068080807F6C936CF66DFC77F677F87800780978177818781165AB782D781C\n781D7839783A783B781F783C7825782C78237829784E786D7856785778267850\n7847784C786A789B7893789A7887789C78A178A378B278B978A578D478D978C9\n78EC78F2790578F479137924791E79349F9B9EF99EFB9EFC76F17704770D76F9\n77077708771A77227719772D7726773577387750775177477743775A77680000\nEE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n980F9810981198129813981498159816981798189819981A981B981C981D981E\n981F9820982198229823982498259826982798289829982A982B982C982D982E\n982F9830983198329833983498359836983798389839983A983B983C983D983E\n983F9840984198429843984498459846984798489849984A984B984C984D0000\n984E984F9850985198529853985498559856985798589859985A985B985C985D\n985E985F9860986198629863986498659866986798689869986A986B986C986D\n986E77627765777F778D777D7780778C7791779F77A077B077B577BD753A7540\n754E754B7548755B7572757975837F587F617F5F8A487F687F747F717F797F81\n7F7E76CD76E58832948594869487948B948A948C948D948F9490949494979495\n949A949B949C94A394A494AB94AA94AD94AC94AF94B094B294B494B694B794B8\n94B994BA94BC94BD94BF94C494C894C994CA94CB94CC94CD94CE94D094D194D2\n94D594D694D794D994D894DB94DE94DF94E094E294E494E594E794E894EA0000\nEF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n986F98709871987298739874988B988E98929895989998A398A898A998AA98AB\n98AC98AD98AE98AF98B098B198B298B398B498B598B698B798B898B998BA98BB\n98BC98BD98BE98BF98C098C198C298C398C498C598C698C798C898C998CA98CB\n98CC98CD98CF98D098D498D698D798DB98DC98DD98E098E198E298E398E40000\n98E598E698E998EA98EB98EC98ED98EE98EF98F098F198F298F398F498F598F6\n98F798F898F998FA98FB98FC98FD98FE98FF9900990199029903990499059906\n990794E994EB94EE94EF94F394F494F594F794F994FC94FD94FF950395029506\n95079509950A950D950E950F951295139514951595169518951B951D951E951F\n9522952A952B9529952C953195329534953695379538953C953E953F95429535\n9544954595469549954C954E954F9552955395549556955795589559955B955E\n955F955D95619562956495659566956795689569956A956B956C956F95719572\n9573953A77E777EC96C979D579ED79E379EB7A065D477A037A027A1E7A140000\nF0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n99089909990A990B990C990E990F991199129913991499159916991799189919\n991A991B991C991D991E991F9920992199229923992499259926992799289929\n992A992B992C992D992F9930993199329933993499359936993799389939993A\n993B993C993D993E993F99409941994299439944994599469947994899490000\n994A994B994C994D994E994F99509951995299539956995799589959995A995B\n995C995D995E995F99609961996299649966997399789979997B997E99829983\n99897A397A377A519ECF99A57A707688768E7693769976A474DE74E0752C9E20\n9E229E289E299E2A9E2B9E2C9E329E319E369E389E379E399E3A9E3E9E419E42\n9E449E469E479E489E499E4B9E4C9E4E9E519E559E579E5A9E5B9E5C9E5E9E63\n9E669E679E689E699E6A9E6B9E6C9E719E6D9E7375927594759675A0759D75AC\n75A375B375B475B875C475B175B075C375C275D675CD75E375E875E675E475EB\n75E7760375F175FC75FF761076007605760C7617760A76257618761576190000\nF1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n998C998E999A999B999C999D999E999F99A099A199A299A399A499A699A799A9\n99AA99AB99AC99AD99AE99AF99B099B199B299B399B499B599B699B799B899B9\n99BA99BB99BC99BD99BE99BF99C099C199C299C399C499C599C699C799C899C9\n99CA99CB99CC99CD99CE99CF99D099D199D299D399D499D599D699D799D80000\n99D999DA99DB99DC99DD99DE99DF99E099E199E299E399E499E599E699E799E8\n99E999EA99EB99EC99ED99EE99EF99F099F199F299F399F499F599F699F799F8\n99F9761B763C762276207640762D7630763F76357643763E7633764D765E7654\n765C7656766B766F7FCA7AE67A787A797A807A867A887A957AA67AA07AAC7AA8\n7AAD7AB3886488698872887D887F888288A288C688B788BC88C988E288CE88E3\n88E588F1891A88FC88E888FE88F0892189198913891B890A8934892B89368941\n8966897B758B80E576B276B477DC801280148016801C80208022802580268027\n802980288031800B803580438046804D80528069807189839878988098830000\nF2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n99FA99FB99FC99FD99FE99FF9A009A019A029A039A049A059A069A079A089A09\n9A0A9A0B9A0C9A0D9A0E9A0F9A109A119A129A139A149A159A169A179A189A19\n9A1A9A1B9A1C9A1D9A1E9A1F9A209A219A229A239A249A259A269A279A289A29\n9A2A9A2B9A2C9A2D9A2E9A2F9A309A319A329A339A349A359A369A379A380000\n9A399A3A9A3B9A3C9A3D9A3E9A3F9A409A419A429A439A449A459A469A479A48\n9A499A4A9A4B9A4C9A4D9A4E9A4F9A509A519A529A539A549A559A569A579A58\n9A599889988C988D988F9894989A989B989E989F98A198A298A598A6864D8654\n866C866E867F867A867C867B86A8868D868B86AC869D86A786A386AA869386A9\n86B686C486B586CE86B086BA86B186AF86C986CF86B486E986F186F286ED86F3\n86D0871386DE86F486DF86D886D18703870786F88708870A870D87098723873B\n871E8725872E871A873E87488734873187298737873F87828722877D877E877B\n87608770874C876E878B87538763877C876487598765879387AF87A887D20000\nF3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9A5A9A5B9A5C9A5D9A5E9A5F9A609A619A629A639A649A659A669A679A689A69\n9A6A9A6B9A729A839A899A8D9A8E9A949A959A999AA69AA99AAA9AAB9AAC9AAD\n9AAE9AAF9AB29AB39AB49AB59AB99ABB9ABD9ABE9ABF9AC39AC49AC69AC79AC8\n9AC99ACA9ACD9ACE9ACF9AD09AD29AD49AD59AD69AD79AD99ADA9ADB9ADC0000\n9ADD9ADE9AE09AE29AE39AE49AE59AE79AE89AE99AEA9AEC9AEE9AF09AF19AF2\n9AF39AF49AF59AF69AF79AF89AFA9AFC9AFD9AFE9AFF9B009B019B029B049B05\n9B0687C68788878587AD8797878387AB87E587AC87B587B387CB87D387BD87D1\n87C087CA87DB87EA87E087EE8816881387FE880A881B88218839883C7F367F42\n7F447F4582107AFA7AFD7B087B037B047B157B0A7B2B7B0F7B477B387B2A7B19\n7B2E7B317B207B257B247B337B3E7B1E7B587B5A7B457B757B4C7B5D7B607B6E\n7B7B7B627B727B717B907BA67BA77BB87BAC7B9D7BA87B857BAA7B9C7BA27BAB\n7BB47BD17BC17BCC7BDD7BDA7BE57BE67BEA7C0C7BFE7BFC7C0F7C167C0B0000\nF4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9B079B099B0A9B0B9B0C9B0D9B0E9B109B119B129B149B159B169B179B189B19\n9B1A9B1B9B1C9B1D9B1E9B209B219B229B249B259B269B279B289B299B2A9B2B\n9B2C9B2D9B2E9B309B319B339B349B359B369B379B389B399B3A9B3D9B3E9B3F\n9B409B469B4A9B4B9B4C9B4E9B509B529B539B559B569B579B589B599B5A0000\n9B5B9B5C9B5D9B5E9B5F9B609B619B629B639B649B659B669B679B689B699B6A\n9B6B9B6C9B6D9B6E9B6F9B709B719B729B739B749B759B769B779B789B799B7A\n9B7B7C1F7C2A7C267C387C417C4081FE82018202820481EC8844822182228223\n822D822F8228822B8238823B82338234823E82448249824B824F825A825F8268\n887E8885888888D888DF895E7F9D7F9F7FA77FAF7FB07FB27C7C65497C917C9D\n7C9C7C9E7CA27CB27CBC7CBD7CC17CC77CCC7CCD7CC87CC57CD77CE8826E66A8\n7FBF7FCE7FD57FE57FE17FE67FE97FEE7FF37CF87D777DA67DAE7E477E9B9EB8\n9EB48D738D848D948D918DB18D678D6D8C478C49914A9150914E914F91640000\nF5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9B7C9B7D9B7E9B7F9B809B819B829B839B849B859B869B879B889B899B8A9B8B\n9B8C9B8D9B8E9B8F9B909B919B929B939B949B959B969B979B989B999B9A9B9B\n9B9C9B9D9B9E9B9F9BA09BA19BA29BA39BA49BA59BA69BA79BA89BA99BAA9BAB\n9BAC9BAD9BAE9BAF9BB09BB19BB29BB39BB49BB59BB69BB79BB89BB99BBA0000\n9BBB9BBC9BBD9BBE9BBF9BC09BC19BC29BC39BC49BC59BC69BC79BC89BC99BCA\n9BCB9BCC9BCD9BCE9BCF9BD09BD19BD29BD39BD49BD59BD69BD79BD89BD99BDA\n9BDB9162916191709169916F917D917E917291749179918C91859190918D9191\n91A291A391AA91AD91AE91AF91B591B491BA8C559E7E8DB88DEB8E058E598E69\n8DB58DBF8DBC8DBA8DC48DD68DD78DDA8DDE8DCE8DCF8DDB8DC68DEC8DF78DF8\n8DE38DF98DFB8DE48E098DFD8E148E1D8E1F8E2C8E2E8E238E2F8E3A8E408E39\n8E358E3D8E318E498E418E428E518E528E4A8E708E768E7C8E6F8E748E858E8F\n8E948E908E9C8E9E8C788C828C8A8C858C988C94659B89D689DE89DA89DC0000\nF6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9BDC9BDD9BDE9BDF9BE09BE19BE29BE39BE49BE59BE69BE79BE89BE99BEA9BEB\n9BEC9BED9BEE9BEF9BF09BF19BF29BF39BF49BF59BF69BF79BF89BF99BFA9BFB\n9BFC9BFD9BFE9BFF9C009C019C029C039C049C059C069C079C089C099C0A9C0B\n9C0C9C0D9C0E9C0F9C109C119C129C139C149C159C169C179C189C199C1A0000\n9C1B9C1C9C1D9C1E9C1F9C209C219C229C239C249C259C269C279C289C299C2A\n9C2B9C2C9C2D9C2E9C2F9C309C319C329C339C349C359C369C379C389C399C3A\n9C3B89E589EB89EF8A3E8B26975396E996F396EF970697019708970F970E972A\n972D9730973E9F809F839F859F869F879F889F899F8A9F8C9EFE9F0B9F0D96B9\n96BC96BD96CE96D277BF96E0928E92AE92C8933E936A93CA938F943E946B9C7F\n9C829C859C869C879C887A239C8B9C8E9C909C919C929C949C959C9A9C9B9C9E\n9C9F9CA09CA19CA29CA39CA59CA69CA79CA89CA99CAB9CAD9CAE9CB09CB19CB2\n9CB39CB49CB59CB69CB79CBA9CBB9CBC9CBD9CC49CC59CC69CC79CCA9CCB0000\nF7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9C3C9C3D9C3E9C3F9C409C419C429C439C449C459C469C479C489C499C4A9C4B\n9C4C9C4D9C4E9C4F9C509C519C529C539C549C559C569C579C589C599C5A9C5B\n9C5C9C5D9C5E9C5F9C609C619C629C639C649C659C669C679C689C699C6A9C6B\n9C6C9C6D9C6E9C6F9C709C719C729C739C749C759C769C779C789C799C7A0000\n9C7B9C7D9C7E9C809C839C849C899C8A9C8C9C8F9C939C969C979C989C999C9D\n9CAA9CAC9CAF9CB99CBE9CBF9CC09CC19CC29CC89CC99CD19CD29CDA9CDB9CE0\n9CE19CCC9CCD9CCE9CCF9CD09CD39CD49CD59CD79CD89CD99CDC9CDD9CDF9CE2\n977C978597919792979497AF97AB97A397B297B49AB19AB09AB79E589AB69ABA\n9ABC9AC19AC09AC59AC29ACB9ACC9AD19B459B439B479B499B489B4D9B5198E8\n990D992E995599549ADF9AE19AE69AEF9AEB9AFB9AED9AF99B089B0F9B139B1F\n9B239EBD9EBE7E3B9E829E879E889E8B9E9293D69E9D9E9F9EDB9EDC9EDD9EE0\n9EDF9EE29EE99EE79EE59EEA9EEF9F229F2C9F2F9F399F379F3D9F3E9F440000\nF8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9CE39CE49CE59CE69CE79CE89CE99CEA9CEB9CEC9CED9CEE9CEF9CF09CF19CF2\n9CF39CF49CF59CF69CF79CF89CF99CFA9CFB9CFC9CFD9CFE9CFF9D009D019D02\n9D039D049D059D069D079D089D099D0A9D0B9D0C9D0D9D0E9D0F9D109D119D12\n9D139D149D159D169D179D189D199D1A9D1B9D1C9D1D9D1E9D1F9D209D210000\n9D229D239D249D259D269D279D289D299D2A9D2B9D2C9D2D9D2E9D2F9D309D31\n9D329D339D349D359D369D379D389D399D3A9D3B9D3C9D3D9D3E9D3F9D409D41\n9D42000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nF9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9D439D449D459D469D479D489D499D4A9D4B9D4C9D4D9D4E9D4F9D509D519D52\n9D539D549D559D569D579D589D599D5A9D5B9D5C9D5D9D5E9D5F9D609D619D62\n9D639D649D659D669D679D689D699D6A9D6B9D6C9D6D9D6E9D6F9D709D719D72\n9D739D749D759D769D779D789D799D7A9D7B9D7C9D7D9D7E9D7F9D809D810000\n9D829D839D849D859D869D879D889D899D8A9D8B9D8C9D8D9D8E9D8F9D909D91\n9D929D939D949D959D969D979D989D999D9A9D9B9D9C9D9D9D9E9D9F9DA09DA1\n9DA2000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9DA39DA49DA59DA69DA79DA89DA99DAA9DAB9DAC9DAD9DAE9DAF9DB09DB19DB2\n9DB39DB49DB59DB69DB79DB89DB99DBA9DBB9DBC9DBD9DBE9DBF9DC09DC19DC2\n9DC39DC49DC59DC69DC79DC89DC99DCA9DCB9DCC9DCD9DCE9DCF9DD09DD19DD2\n9DD39DD49DD59DD69DD79DD89DD99DDA9DDB9DDC9DDD9DDE9DDF9DE09DE10000\n9DE29DE39DE49DE59DE69DE79DE89DE99DEA9DEB9DEC9DED9DEE9DEF9DF09DF1\n9DF29DF39DF49DF59DF69DF79DF89DF99DFA9DFB9DFC9DFD9DFE9DFF9E009E01\n9E02000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9E039E049E059E069E079E089E099E0A9E0B9E0C9E0D9E0E9E0F9E109E119E12\n9E139E149E159E169E179E189E199E1A9E1B9E1C9E1D9E1E9E249E279E2E9E30\n9E349E3B9E3C9E409E4D9E509E529E539E549E569E599E5D9E5F9E609E619E62\n9E659E6E9E6F9E729E749E759E769E779E789E799E7A9E7B9E7C9E7D9E800000\n9E819E839E849E859E869E899E8A9E8C9E8D9E8E9E8F9E909E919E949E959E96\n9E979E989E999E9A9E9B9E9C9E9E9EA09EA19EA29EA39EA49EA59EA79EA89EA9\n9EAA000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9EAB9EAC9EAD9EAE9EAF9EB09EB19EB29EB39EB59EB69EB79EB99EBA9EBC9EBF\n9EC09EC19EC29EC39EC59EC69EC79EC89ECA9ECB9ECC9ED09ED29ED39ED59ED6\n9ED79ED99EDA9EDE9EE19EE39EE49EE69EE89EEB9EEC9EED9EEE9EF09EF19EF2\n9EF39EF49EF59EF69EF79EF89EFA9EFD9EFF9F009F019F029F039F049F050000\n9F069F079F089F099F0A9F0C9F0F9F119F129F149F159F169F189F1A9F1B9F1C\n9F1D9F1E9F1F9F219F239F249F259F269F279F289F299F2A9F2B9F2D9F2E9F30\n9F31000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9F329F339F349F359F369F389F3A9F3C9F3F9F409F419F429F439F459F469F47\n9F489F499F4A9F4B9F4C9F4D9F4E9F4F9F529F539F549F559F569F579F589F59\n9F5A9F5B9F5C9F5D9F5E9F5F9F609F619F629F639F649F659F669F679F689F69\n9F6A9F6B9F6C9F6D9F6E9F6F9F709F719F729F739F749F759F769F779F780000\n9F799F7A9F7B9F7C9F7D9F7E9F819F829F8D9F8E9F8F9F909F919F929F939F94\n9F959F969F979F989F9C9F9D9F9E9FA19FA29FA39FA49FA5F92CF979F995F9E7\nF9F1000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFA0CFA0DFA0EFA0FFA11FA13FA14FA18FA1FFA20FA21FA23FA24FA27FA28FA29\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n",
		"/encoding/cp949.enc":                      "# Encoding file: cp949, multi-byte\nM\n003F 0 125\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n0080000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n81\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000AC02AC03AC05AC06AC0BAC0CAC0DAC0EAC0FAC18AC1EAC1FAC21AC22AC23\nAC25AC26AC27AC28AC29AC2AAC2BAC2EAC32AC33AC3400000000000000000000\n0000AC35AC36AC37AC3AAC3BAC3DAC3EAC3FAC41AC42AC43AC44AC45AC46AC47\nAC48AC49AC4AAC4CAC4EAC4FAC50AC51AC52AC53AC5500000000000000000000\n0000AC56AC57AC59AC5AAC5BAC5DAC5EAC5FAC60AC61AC62AC63AC64AC65AC66\nAC67AC68AC69AC6AAC6BAC6CAC6DAC6EAC6FAC72AC73AC75AC76AC79AC7BAC7C\nAC7DAC7EAC7FAC82AC87AC88AC8DAC8EAC8FAC91AC92AC93AC95AC96AC97AC98\nAC99AC9AAC9BAC9EACA2ACA3ACA4ACA5ACA6ACA7ACABACADACAEACB1ACB2ACB3\nACB4ACB5ACB6ACB7ACBAACBEACBFACC0ACC2ACC3ACC5ACC6ACC7ACC9ACCAACCB\nACCDACCEACCFACD0ACD1ACD2ACD3ACD4ACD6ACD8ACD9ACDAACDBACDCACDDACDE\nACDFACE2ACE3ACE5ACE6ACE9ACEBACEDACEEACF2ACF4ACF7ACF8ACF9ACFAACFB\nACFEACFFAD01AD02AD03AD05AD07AD08AD09AD0AAD0BAD0EAD10AD12AD130000\n82\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000AD14AD15AD16AD17AD19AD1AAD1BAD1DAD1EAD1FAD21AD22AD23AD24AD25\nAD26AD27AD28AD2AAD2BAD2EAD2FAD30AD31AD32AD3300000000000000000000\n0000AD36AD37AD39AD3AAD3BAD3DAD3EAD3FAD40AD41AD42AD43AD46AD48AD4A\nAD4BAD4CAD4DAD4EAD4FAD51AD52AD53AD55AD56AD5700000000000000000000\n0000AD59AD5AAD5BAD5CAD5DAD5EAD5FAD60AD62AD64AD65AD66AD67AD68AD69\nAD6AAD6BAD6EAD6FAD71AD72AD77AD78AD79AD7AAD7EAD80AD83AD84AD85AD86\nAD87AD8AAD8BAD8DAD8EAD8FAD91AD92AD93AD94AD95AD96AD97AD98AD99AD9A\nAD9BAD9EAD9FADA0ADA1ADA2ADA3ADA5ADA6ADA7ADA8ADA9ADAAADABADACADAD\nADAEADAFADB0ADB1ADB2ADB3ADB4ADB5ADB6ADB8ADB9ADBAADBBADBCADBDADBE\nADBFADC2ADC3ADC5ADC6ADC7ADC9ADCAADCBADCCADCDADCEADCFADD2ADD4ADD5\nADD6ADD7ADD8ADD9ADDAADDBADDDADDEADDFADE1ADE2ADE3ADE5ADE6ADE7ADE8\nADE9ADEAADEBADECADEDADEEADEFADF0ADF1ADF2ADF3ADF4ADF5ADF6ADF70000\n83\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000ADFAADFBADFDADFEAE02AE03AE04AE05AE06AE07AE0AAE0CAE0EAE0FAE10\nAE11AE12AE13AE15AE16AE17AE18AE19AE1AAE1BAE1C00000000000000000000\n0000AE1DAE1EAE1FAE20AE21AE22AE23AE24AE25AE26AE27AE28AE29AE2AAE2B\nAE2CAE2DAE2EAE2FAE32AE33AE35AE36AE39AE3BAE3C00000000000000000000\n0000AE3DAE3EAE3FAE42AE44AE47AE48AE49AE4BAE4FAE51AE52AE53AE55AE57\nAE58AE59AE5AAE5BAE5EAE62AE63AE64AE66AE67AE6AAE6BAE6DAE6EAE6FAE71\nAE72AE73AE74AE75AE76AE77AE7AAE7EAE7FAE80AE81AE82AE83AE86AE87AE88\nAE89AE8AAE8BAE8DAE8EAE8FAE90AE91AE92AE93AE94AE95AE96AE97AE98AE99\nAE9AAE9BAE9CAE9DAE9EAE9FAEA0AEA1AEA2AEA3AEA4AEA5AEA6AEA7AEA8AEA9\nAEAAAEABAEACAEADAEAEAEAFAEB0AEB1AEB2AEB3AEB4AEB5AEB6AEB7AEB8AEB9\nAEBAAEBBAEBFAEC1AEC2AEC3AEC5AEC6AEC7AEC8AEC9AECAAECBAECEAED2AED3\nAED4AED5AED6AED7AEDAAEDBAEDDAEDEAEDFAEE0AEE1AEE2AEE3AEE4AEE50000\n84\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000AEE6AEE7AEE9AEEAAEECAEEEAEEFAEF0AEF1AEF2AEF3AEF5AEF6AEF7AEF9\nAEFAAEFBAEFDAEFEAEFFAF00AF01AF02AF03AF04AF0500000000000000000000\n0000AF06AF09AF0AAF0BAF0CAF0EAF0FAF11AF12AF13AF14AF15AF16AF17AF18\nAF19AF1AAF1BAF1CAF1DAF1EAF1FAF20AF21AF22AF2300000000000000000000\n0000AF24AF25AF26AF27AF28AF29AF2AAF2BAF2EAF2FAF31AF33AF35AF36AF37\nAF38AF39AF3AAF3BAF3EAF40AF44AF45AF46AF47AF4AAF4BAF4CAF4DAF4EAF4F\nAF51AF52AF53AF54AF55AF56AF57AF58AF59AF5AAF5BAF5EAF5FAF60AF61AF62\nAF63AF66AF67AF68AF69AF6AAF6BAF6CAF6DAF6EAF6FAF70AF71AF72AF73AF74\nAF75AF76AF77AF78AF7AAF7BAF7CAF7DAF7EAF7FAF81AF82AF83AF85AF86AF87\nAF89AF8AAF8BAF8CAF8DAF8EAF8FAF92AF93AF94AF96AF97AF98AF99AF9AAF9B\nAF9DAF9EAF9FAFA0AFA1AFA2AFA3AFA4AFA5AFA6AFA7AFA8AFA9AFAAAFABAFAC\nAFADAFAEAFAFAFB0AFB1AFB2AFB3AFB4AFB5AFB6AFB7AFBAAFBBAFBDAFBE0000\n85\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000AFBFAFC1AFC2AFC3AFC4AFC5AFC6AFCAAFCCAFCFAFD0AFD1AFD2AFD3AFD5\nAFD6AFD7AFD8AFD9AFDAAFDBAFDDAFDEAFDFAFE0AFE100000000000000000000\n0000AFE2AFE3AFE4AFE5AFE6AFE7AFEAAFEBAFECAFEDAFEEAFEFAFF2AFF3AFF5\nAFF6AFF7AFF9AFFAAFFBAFFCAFFDAFFEAFFFB002B00300000000000000000000\n0000B005B006B007B008B009B00AB00BB00DB00EB00FB011B012B013B015B016\nB017B018B019B01AB01BB01EB01FB020B021B022B023B024B025B026B027B029\nB02AB02BB02CB02DB02EB02FB030B031B032B033B034B035B036B037B038B039\nB03AB03BB03CB03DB03EB03FB040B041B042B043B046B047B049B04BB04DB04F\nB050B051B052B056B058B05AB05BB05CB05EB05FB060B061B062B063B064B065\nB066B067B068B069B06AB06BB06CB06DB06EB06FB070B071B072B073B074B075\nB076B077B078B079B07AB07BB07EB07FB081B082B083B085B086B087B088B089\nB08AB08BB08EB090B092B093B094B095B096B097B09BB09DB09EB0A3B0A40000\n86\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B0A5B0A6B0A7B0AAB0B0B0B2B0B6B0B7B0B9B0BAB0BBB0BDB0BEB0BFB0C0\nB0C1B0C2B0C3B0C6B0CAB0CBB0CCB0CDB0CEB0CFB0D200000000000000000000\n0000B0D3B0D5B0D6B0D7B0D9B0DAB0DBB0DCB0DDB0DEB0DFB0E1B0E2B0E3B0E4\nB0E6B0E7B0E8B0E9B0EAB0EBB0ECB0EDB0EEB0EFB0F000000000000000000000\n0000B0F1B0F2B0F3B0F4B0F5B0F6B0F7B0F8B0F9B0FAB0FBB0FCB0FDB0FEB0FF\nB100B101B102B103B104B105B106B107B10AB10DB10EB10FB111B114B115B116\nB117B11AB11EB11FB120B121B122B126B127B129B12AB12BB12DB12EB12FB130\nB131B132B133B136B13AB13BB13CB13DB13EB13FB142B143B145B146B147B149\nB14AB14BB14CB14DB14EB14FB152B153B156B157B159B15AB15BB15DB15EB15F\nB161B162B163B164B165B166B167B168B169B16AB16BB16CB16DB16EB16FB170\nB171B172B173B174B175B176B177B17AB17BB17DB17EB17FB181B183B184B185\nB186B187B18AB18CB18EB18FB190B191B195B196B197B199B19AB19BB19D0000\n87\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B19EB19FB1A0B1A1B1A2B1A3B1A4B1A5B1A6B1A7B1A9B1AAB1ABB1ACB1AD\nB1AEB1AFB1B0B1B1B1B2B1B3B1B4B1B5B1B6B1B7B1B800000000000000000000\n0000B1B9B1BAB1BBB1BCB1BDB1BEB1BFB1C0B1C1B1C2B1C3B1C4B1C5B1C6B1C7\nB1C8B1C9B1CAB1CBB1CDB1CEB1CFB1D1B1D2B1D3B1D500000000000000000000\n0000B1D6B1D7B1D8B1D9B1DAB1DBB1DEB1E0B1E1B1E2B1E3B1E4B1E5B1E6B1E7\nB1EAB1EBB1EDB1EEB1EFB1F1B1F2B1F3B1F4B1F5B1F6B1F7B1F8B1FAB1FCB1FE\nB1FFB200B201B202B203B206B207B209B20AB20DB20EB20FB210B211B212B213\nB216B218B21AB21BB21CB21DB21EB21FB221B222B223B224B225B226B227B228\nB229B22AB22BB22CB22DB22EB22FB230B231B232B233B235B236B237B238B239\nB23AB23BB23DB23EB23FB240B241B242B243B244B245B246B247B248B249B24A\nB24BB24CB24DB24EB24FB250B251B252B253B254B255B256B257B259B25AB25B\nB25DB25EB25FB261B262B263B264B265B266B267B26AB26BB26CB26DB26E0000\n88\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B26FB270B271B272B273B276B277B278B279B27AB27BB27DB27EB27FB280\nB281B282B283B286B287B288B28AB28BB28CB28DB28E00000000000000000000\n0000B28FB292B293B295B296B297B29BB29CB29DB29EB29FB2A2B2A4B2A7B2A8\nB2A9B2ABB2ADB2AEB2AFB2B1B2B2B2B3B2B5B2B6B2B700000000000000000000\n0000B2B8B2B9B2BAB2BBB2BCB2BDB2BEB2BFB2C0B2C1B2C2B2C3B2C4B2C5B2C6\nB2C7B2CAB2CBB2CDB2CEB2CFB2D1B2D3B2D4B2D5B2D6B2D7B2DAB2DCB2DEB2DF\nB2E0B2E1B2E3B2E7B2E9B2EAB2F0B2F1B2F2B2F6B2FCB2FDB2FEB302B303B305\nB306B307B309B30AB30BB30CB30DB30EB30FB312B316B317B318B319B31AB31B\nB31DB31EB31FB320B321B322B323B324B325B326B327B328B329B32AB32BB32C\nB32DB32EB32FB330B331B332B333B334B335B336B337B338B339B33AB33BB33C\nB33DB33EB33FB340B341B342B343B344B345B346B347B348B349B34AB34BB34C\nB34DB34EB34FB350B351B352B353B357B359B35AB35DB360B361B362B3630000\n89\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B366B368B36AB36CB36DB36FB372B373B375B376B377B379B37AB37BB37C\nB37DB37EB37FB382B386B387B388B389B38AB38BB38D00000000000000000000\n0000B38EB38FB391B392B393B395B396B397B398B399B39AB39BB39CB39DB39E\nB39FB3A2B3A3B3A4B3A5B3A6B3A7B3A9B3AAB3ABB3AD00000000000000000000\n0000B3AEB3AFB3B0B3B1B3B2B3B3B3B4B3B5B3B6B3B7B3B8B3B9B3BAB3BBB3BC\nB3BDB3BEB3BFB3C0B3C1B3C2B3C3B3C6B3C7B3C9B3CAB3CDB3CFB3D1B3D2B3D3\nB3D6B3D8B3DAB3DCB3DEB3DFB3E1B3E2B3E3B3E5B3E6B3E7B3E9B3EAB3EBB3EC\nB3EDB3EEB3EFB3F0B3F1B3F2B3F3B3F4B3F5B3F6B3F7B3F8B3F9B3FAB3FBB3FD\nB3FEB3FFB400B401B402B403B404B405B406B407B408B409B40AB40BB40CB40D\nB40EB40FB411B412B413B414B415B416B417B419B41AB41BB41DB41EB41FB421\nB422B423B424B425B426B427B42AB42CB42DB42EB42FB430B431B432B433B435\nB436B437B438B439B43AB43BB43CB43DB43EB43FB440B441B442B443B4440000\n8A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B445B446B447B448B449B44AB44BB44CB44DB44EB44FB452B453B455B456\nB457B459B45AB45BB45CB45DB45EB45FB462B464B46600000000000000000000\n0000B467B468B469B46AB46BB46DB46EB46FB470B471B472B473B474B475B476\nB477B478B479B47AB47BB47CB47DB47EB47FB481B48200000000000000000000\n0000B483B484B485B486B487B489B48AB48BB48CB48DB48EB48FB490B491B492\nB493B494B495B496B497B498B499B49AB49BB49CB49EB49FB4A0B4A1B4A2B4A3\nB4A5B4A6B4A7B4A9B4AAB4ABB4ADB4AEB4AFB4B0B4B1B4B2B4B3B4B4B4B6B4B8\nB4BAB4BBB4BCB4BDB4BEB4BFB4C1B4C2B4C3B4C5B4C6B4C7B4C9B4CAB4CBB4CC\nB4CDB4CEB4CFB4D1B4D2B4D3B4D4B4D6B4D7B4D8B4D9B4DAB4DBB4DEB4DFB4E1\nB4E2B4E5B4E7B4E8B4E9B4EAB4EBB4EEB4F0B4F2B4F3B4F4B4F5B4F6B4F7B4F9\nB4FAB4FBB4FCB4FDB4FEB4FFB500B501B502B503B504B505B506B507B508B509\nB50AB50BB50CB50DB50EB50FB510B511B512B513B516B517B519B51AB51D0000\n8B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B51EB51FB520B521B522B523B526B52BB52CB52DB52EB52FB532B533B535\nB536B537B539B53AB53BB53CB53DB53EB53FB542B54600000000000000000000\n0000B547B548B549B54AB54EB54FB551B552B553B555B556B557B558B559B55A\nB55BB55EB562B563B564B565B566B567B568B569B56A00000000000000000000\n0000B56BB56CB56DB56EB56FB570B571B572B573B574B575B576B577B578B579\nB57AB57BB57CB57DB57EB57FB580B581B582B583B584B585B586B587B588B589\nB58AB58BB58CB58DB58EB58FB590B591B592B593B594B595B596B597B598B599\nB59AB59BB59CB59DB59EB59FB5A2B5A3B5A5B5A6B5A7B5A9B5ACB5ADB5AEB5AF\nB5B2B5B6B5B7B5B8B5B9B5BAB5BEB5BFB5C1B5C2B5C3B5C5B5C6B5C7B5C8B5C9\nB5CAB5CBB5CEB5D2B5D3B5D4B5D5B5D6B5D7B5D9B5DAB5DBB5DCB5DDB5DEB5DF\nB5E0B5E1B5E2B5E3B5E4B5E5B5E6B5E7B5E8B5E9B5EAB5EBB5EDB5EEB5EFB5F0\nB5F1B5F2B5F3B5F4B5F5B5F6B5F7B5F8B5F9B5FAB5FBB5FCB5FDB5FEB5FF0000\n8C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B600B601B602B603B604B605B606B607B608B609B60AB60BB60CB60DB60E\nB60FB612B613B615B616B617B619B61AB61BB61CB61D00000000000000000000\n0000B61EB61FB620B621B622B623B624B626B627B628B629B62AB62BB62DB62E\nB62FB630B631B632B633B635B636B637B638B639B63A00000000000000000000\n0000B63BB63CB63DB63EB63FB640B641B642B643B644B645B646B647B649B64A\nB64BB64CB64DB64EB64FB650B651B652B653B654B655B656B657B658B659B65A\nB65BB65CB65DB65EB65FB660B661B662B663B665B666B667B669B66AB66BB66C\nB66DB66EB66FB670B671B672B673B674B675B676B677B678B679B67AB67BB67C\nB67DB67EB67FB680B681B682B683B684B685B686B687B688B689B68AB68BB68C\nB68DB68EB68FB690B691B692B693B694B695B696B697B698B699B69AB69BB69E\nB69FB6A1B6A2B6A3B6A5B6A6B6A7B6A8B6A9B6AAB6ADB6AEB6AFB6B0B6B2B6B3\nB6B4B6B5B6B6B6B7B6B8B6B9B6BAB6BBB6BCB6BDB6BEB6BFB6C0B6C1B6C20000\n8D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B6C3B6C4B6C5B6C6B6C7B6C8B6C9B6CAB6CBB6CCB6CDB6CEB6CFB6D0B6D1\nB6D2B6D3B6D5B6D6B6D7B6D8B6D9B6DAB6DBB6DCB6DD00000000000000000000\n0000B6DEB6DFB6E0B6E1B6E2B6E3B6E4B6E5B6E6B6E7B6E8B6E9B6EAB6EBB6EC\nB6EDB6EEB6EFB6F1B6F2B6F3B6F5B6F6B6F7B6F9B6FA00000000000000000000\n0000B6FBB6FCB6FDB6FEB6FFB702B703B704B706B707B708B709B70AB70BB70C\nB70DB70EB70FB710B711B712B713B714B715B716B717B718B719B71AB71BB71C\nB71DB71EB71FB720B721B722B723B724B725B726B727B72AB72BB72DB72EB731\nB732B733B734B735B736B737B73AB73CB73DB73EB73FB740B741B742B743B745\nB746B747B749B74AB74BB74DB74EB74FB750B751B752B753B756B757B758B759\nB75AB75BB75CB75DB75EB75FB761B762B763B765B766B767B769B76AB76BB76C\nB76DB76EB76FB772B774B776B777B778B779B77AB77BB77EB77FB781B782B783\nB785B786B787B788B789B78AB78BB78EB793B794B795B79AB79BB79DB79E0000\n8E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B79FB7A1B7A2B7A3B7A4B7A5B7A6B7A7B7AAB7AEB7AFB7B0B7B1B7B2B7B3\nB7B6B7B7B7B9B7BAB7BBB7BCB7BDB7BEB7BFB7C0B7C100000000000000000000\n0000B7C2B7C3B7C4B7C5B7C6B7C8B7CAB7CBB7CCB7CDB7CEB7CFB7D0B7D1B7D2\nB7D3B7D4B7D5B7D6B7D7B7D8B7D9B7DAB7DBB7DCB7DD00000000000000000000\n0000B7DEB7DFB7E0B7E1B7E2B7E3B7E4B7E5B7E6B7E7B7E8B7E9B7EAB7EBB7EE\nB7EFB7F1B7F2B7F3B7F5B7F6B7F7B7F8B7F9B7FAB7FBB7FEB802B803B804B805\nB806B80AB80BB80DB80EB80FB811B812B813B814B815B816B817B81AB81CB81E\nB81FB820B821B822B823B826B827B829B82AB82BB82DB82EB82FB830B831B832\nB833B836B83AB83BB83CB83DB83EB83FB841B842B843B845B846B847B848B849\nB84AB84BB84CB84DB84EB84FB850B852B854B855B856B857B858B859B85AB85B\nB85EB85FB861B862B863B865B866B867B868B869B86AB86BB86EB870B872B873\nB874B875B876B877B879B87AB87BB87DB87EB87FB880B881B882B883B8840000\n8F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B885B886B887B888B889B88AB88BB88CB88EB88FB890B891B892B893B894\nB895B896B897B898B899B89AB89BB89CB89DB89EB89F00000000000000000000\n0000B8A0B8A1B8A2B8A3B8A4B8A5B8A6B8A7B8A9B8AAB8ABB8ACB8ADB8AEB8AF\nB8B1B8B2B8B3B8B5B8B6B8B7B8B9B8BAB8BBB8BCB8BD00000000000000000000\n0000B8BEB8BFB8C2B8C4B8C6B8C7B8C8B8C9B8CAB8CBB8CDB8CEB8CFB8D1B8D2\nB8D3B8D5B8D6B8D7B8D8B8D9B8DAB8DBB8DCB8DEB8E0B8E2B8E3B8E4B8E5B8E6\nB8E7B8EAB8EBB8EDB8EEB8EFB8F1B8F2B8F3B8F4B8F5B8F6B8F7B8FAB8FCB8FE\nB8FFB900B901B902B903B905B906B907B908B909B90AB90BB90CB90DB90EB90F\nB910B911B912B913B914B915B916B917B919B91AB91BB91CB91DB91EB91FB921\nB922B923B924B925B926B927B928B929B92AB92BB92CB92DB92EB92FB930B931\nB932B933B934B935B936B937B938B939B93AB93BB93EB93FB941B942B943B945\nB946B947B948B949B94AB94BB94DB94EB950B952B953B954B955B956B9570000\n90\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B95AB95BB95DB95EB95FB961B962B963B964B965B966B967B96AB96CB96E\nB96FB970B971B972B973B976B977B979B97AB97BB97D00000000000000000000\n0000B97EB97FB980B981B982B983B986B988B98BB98CB98FB990B991B992B993\nB994B995B996B997B998B999B99AB99BB99CB99DB99E00000000000000000000\n0000B99FB9A0B9A1B9A2B9A3B9A4B9A5B9A6B9A7B9A8B9A9B9AAB9ABB9AEB9AF\nB9B1B9B2B9B3B9B5B9B6B9B7B9B8B9B9B9BAB9BBB9BEB9C0B9C2B9C3B9C4B9C5\nB9C6B9C7B9CAB9CBB9CDB9D3B9D4B9D5B9D6B9D7B9DAB9DCB9DFB9E0B9E2B9E6\nB9E7B9E9B9EAB9EBB9EDB9EEB9EFB9F0B9F1B9F2B9F3B9F6B9FBB9FCB9FDB9FE\nB9FFBA02BA03BA04BA05BA06BA07BA09BA0ABA0BBA0CBA0DBA0EBA0FBA10BA11\nBA12BA13BA14BA16BA17BA18BA19BA1ABA1BBA1CBA1DBA1EBA1FBA20BA21BA22\nBA23BA24BA25BA26BA27BA28BA29BA2ABA2BBA2CBA2DBA2EBA2FBA30BA31BA32\nBA33BA34BA35BA36BA37BA3ABA3BBA3DBA3EBA3FBA41BA43BA44BA45BA460000\n91\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000BA47BA4ABA4CBA4FBA50BA51BA52BA56BA57BA59BA5ABA5BBA5DBA5EBA5F\nBA60BA61BA62BA63BA66BA6ABA6BBA6CBA6DBA6EBA6F00000000000000000000\n0000BA72BA73BA75BA76BA77BA79BA7ABA7BBA7CBA7DBA7EBA7FBA80BA81BA82\nBA86BA88BA89BA8ABA8BBA8DBA8EBA8FBA90BA91BA9200000000000000000000\n0000BA93BA94BA95BA96BA97BA98BA99BA9ABA9BBA9CBA9DBA9EBA9FBAA0BAA1\nBAA2BAA3BAA4BAA5BAA6BAA7BAAABAADBAAEBAAFBAB1BAB3BAB4BAB5BAB6BAB7\nBABABABCBABEBABFBAC0BAC1BAC2BAC3BAC5BAC6BAC7BAC9BACABACBBACCBACD\nBACEBACFBAD0BAD1BAD2BAD3BAD4BAD5BAD6BAD7BADABADBBADCBADDBADEBADF\nBAE0BAE1BAE2BAE3BAE4BAE5BAE6BAE7BAE8BAE9BAEABAEBBAECBAEDBAEEBAEF\nBAF0BAF1BAF2BAF3BAF4BAF5BAF6BAF7BAF8BAF9BAFABAFBBAFDBAFEBAFFBB01\nBB02BB03BB05BB06BB07BB08BB09BB0ABB0BBB0CBB0EBB10BB12BB13BB14BB15\nBB16BB17BB19BB1ABB1BBB1DBB1EBB1FBB21BB22BB23BB24BB25BB26BB270000\n92\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000BB28BB2ABB2CBB2DBB2EBB2FBB30BB31BB32BB33BB37BB39BB3ABB3FBB40\nBB41BB42BB43BB46BB48BB4ABB4BBB4CBB4EBB51BB5200000000000000000000\n0000BB53BB55BB56BB57BB59BB5ABB5BBB5CBB5DBB5EBB5FBB60BB62BB64BB65\nBB66BB67BB68BB69BB6ABB6BBB6DBB6EBB6FBB70BB7100000000000000000000\n0000BB72BB73BB74BB75BB76BB77BB78BB79BB7ABB7BBB7CBB7DBB7EBB7FBB80\nBB81BB82BB83BB84BB85BB86BB87BB89BB8ABB8BBB8DBB8EBB8FBB91BB92BB93\nBB94BB95BB96BB97BB98BB99BB9ABB9BBB9CBB9DBB9EBB9FBBA0BBA1BBA2BBA3\nBBA5BBA6BBA7BBA9BBAABBABBBADBBAEBBAFBBB0BBB1BBB2BBB3BBB5BBB6BBB8\nBBB9BBBABBBBBBBCBBBDBBBEBBBFBBC1BBC2BBC3BBC5BBC6BBC7BBC9BBCABBCB\nBBCCBBCDBBCEBBCFBBD1BBD2BBD4BBD5BBD6BBD7BBD8BBD9BBDABBDBBBDCBBDD\nBBDEBBDFBBE0BBE1BBE2BBE3BBE4BBE5BBE6BBE7BBE8BBE9BBEABBEBBBECBBED\nBBEEBBEFBBF0BBF1BBF2BBF3BBF4BBF5BBF6BBF7BBFABBFBBBFDBBFEBC010000\n93\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000BC03BC04BC05BC06BC07BC0ABC0EBC10BC12BC13BC19BC1ABC20BC21BC22\nBC23BC26BC28BC2ABC2BBC2CBC2EBC2FBC32BC33BC3500000000000000000000\n0000BC36BC37BC39BC3ABC3BBC3CBC3DBC3EBC3FBC42BC46BC47BC48BC4ABC4B\nBC4EBC4FBC51BC52BC53BC54BC55BC56BC57BC58BC5900000000000000000000\n0000BC5ABC5BBC5CBC5EBC5FBC60BC61BC62BC63BC64BC65BC66BC67BC68BC69\nBC6ABC6BBC6CBC6DBC6EBC6FBC70BC71BC72BC73BC74BC75BC76BC77BC78BC79\nBC7ABC7BBC7CBC7DBC7EBC7FBC80BC81BC82BC83BC86BC87BC89BC8ABC8DBC8F\nBC90BC91BC92BC93BC96BC98BC9BBC9CBC9DBC9EBC9FBCA2BCA3BCA5BCA6BCA9\nBCAABCABBCACBCADBCAEBCAFBCB2BCB6BCB7BCB8BCB9BCBABCBBBCBEBCBFBCC1\nBCC2BCC3BCC5BCC6BCC7BCC8BCC9BCCABCCBBCCCBCCEBCD2BCD3BCD4BCD6BCD7\nBCD9BCDABCDBBCDDBCDEBCDFBCE0BCE1BCE2BCE3BCE4BCE5BCE6BCE7BCE8BCE9\nBCEABCEBBCECBCEDBCEEBCEFBCF0BCF1BCF2BCF3BCF7BCF9BCFABCFBBCFD0000\n94\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000BCFEBCFFBD00BD01BD02BD03BD06BD08BD0ABD0BBD0CBD0DBD0EBD0FBD11\nBD12BD13BD15BD16BD17BD18BD19BD1ABD1BBD1CBD1D00000000000000000000\n0000BD1EBD1FBD20BD21BD22BD23BD25BD26BD27BD28BD29BD2ABD2BBD2DBD2E\nBD2FBD30BD31BD32BD33BD34BD35BD36BD37BD38BD3900000000000000000000\n0000BD3ABD3BBD3CBD3DBD3EBD3FBD41BD42BD43BD44BD45BD46BD47BD4ABD4B\nBD4DBD4EBD4FBD51BD52BD53BD54BD55BD56BD57BD5ABD5BBD5CBD5DBD5EBD5F\nBD60BD61BD62BD63BD65BD66BD67BD69BD6ABD6BBD6CBD6DBD6EBD6FBD70BD71\nBD72BD73BD74BD75BD76BD77BD78BD79BD7ABD7BBD7CBD7DBD7EBD7FBD82BD83\nBD85BD86BD8BBD8CBD8DBD8EBD8FBD92BD94BD96BD97BD98BD9BBD9DBD9EBD9F\nBDA0BDA1BDA2BDA3BDA5BDA6BDA7BDA8BDA9BDAABDABBDACBDADBDAEBDAFBDB1\nBDB2BDB3BDB4BDB5BDB6BDB7BDB9BDBABDBBBDBCBDBDBDBEBDBFBDC0BDC1BDC2\nBDC3BDC4BDC5BDC6BDC7BDC8BDC9BDCABDCBBDCCBDCDBDCEBDCFBDD0BDD10000\n95\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000BDD2BDD3BDD6BDD7BDD9BDDABDDBBDDDBDDEBDDFBDE0BDE1BDE2BDE3BDE4\nBDE5BDE6BDE7BDE8BDEABDEBBDECBDEDBDEEBDEFBDF100000000000000000000\n0000BDF2BDF3BDF5BDF6BDF7BDF9BDFABDFBBDFCBDFDBDFEBDFFBE01BE02BE04\nBE06BE07BE08BE09BE0ABE0BBE0EBE0FBE11BE12BE1300000000000000000000\n0000BE15BE16BE17BE18BE19BE1ABE1BBE1EBE20BE21BE22BE23BE24BE25BE26\nBE27BE28BE29BE2ABE2BBE2CBE2DBE2EBE2FBE30BE31BE32BE33BE34BE35BE36\nBE37BE38BE39BE3ABE3BBE3CBE3DBE3EBE3FBE40BE41BE42BE43BE46BE47BE49\nBE4ABE4BBE4DBE4FBE50BE51BE52BE53BE56BE58BE5CBE5DBE5EBE5FBE62BE63\nBE65BE66BE67BE69BE6BBE6CBE6DBE6EBE6FBE72BE76BE77BE78BE79BE7ABE7E\nBE7FBE81BE82BE83BE85BE86BE87BE88BE89BE8ABE8BBE8EBE92BE93BE94BE95\nBE96BE97BE9ABE9BBE9CBE9DBE9EBE9FBEA0BEA1BEA2BEA3BEA4BEA5BEA6BEA7\nBEA9BEAABEABBEACBEADBEAEBEAFBEB0BEB1BEB2BEB3BEB4BEB5BEB6BEB70000\n96\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000BEB8BEB9BEBABEBBBEBCBEBDBEBEBEBFBEC0BEC1BEC2BEC3BEC4BEC5BEC6\nBEC7BEC8BEC9BECABECBBECCBECDBECEBECFBED2BED300000000000000000000\n0000BED5BED6BED9BEDABEDBBEDCBEDDBEDEBEDFBEE1BEE2BEE6BEE7BEE8BEE9\nBEEABEEBBEEDBEEEBEEFBEF0BEF1BEF2BEF3BEF4BEF500000000000000000000\n0000BEF6BEF7BEF8BEF9BEFABEFBBEFCBEFDBEFEBEFFBF00BF02BF03BF04BF05\nBF06BF07BF0ABF0BBF0CBF0DBF0EBF0FBF10BF11BF12BF13BF14BF15BF16BF17\nBF1ABF1EBF1FBF20BF21BF22BF23BF24BF25BF26BF27BF28BF29BF2ABF2BBF2C\nBF2DBF2EBF2FBF30BF31BF32BF33BF34BF35BF36BF37BF38BF39BF3ABF3BBF3C\nBF3DBF3EBF3FBF42BF43BF45BF46BF47BF49BF4ABF4BBF4CBF4DBF4EBF4FBF52\nBF53BF54BF56BF57BF58BF59BF5ABF5BBF5CBF5DBF5EBF5FBF60BF61BF62BF63\nBF64BF65BF66BF67BF68BF69BF6ABF6BBF6CBF6DBF6EBF6FBF70BF71BF72BF73\nBF74BF75BF76BF77BF78BF79BF7ABF7BBF7CBF7DBF7EBF7FBF80BF81BF820000\n97\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000BF83BF84BF85BF86BF87BF88BF89BF8ABF8BBF8CBF8DBF8EBF8FBF90BF91\nBF92BF93BF95BF96BF97BF98BF99BF9ABF9BBF9CBF9D00000000000000000000\n0000BF9EBF9FBFA0BFA1BFA2BFA3BFA4BFA5BFA6BFA7BFA8BFA9BFAABFABBFAC\nBFADBFAEBFAFBFB1BFB2BFB3BFB4BFB5BFB6BFB7BFB800000000000000000000\n0000BFB9BFBABFBBBFBCBFBDBFBEBFBFBFC0BFC1BFC2BFC3BFC4BFC6BFC7BFC8\nBFC9BFCABFCBBFCEBFCFBFD1BFD2BFD3BFD5BFD6BFD7BFD8BFD9BFDABFDBBFDD\nBFDEBFE0BFE2BFE3BFE4BFE5BFE6BFE7BFE8BFE9BFEABFEBBFECBFEDBFEEBFEF\nBFF0BFF1BFF2BFF3BFF4BFF5BFF6BFF7BFF8BFF9BFFABFFBBFFCBFFDBFFEBFFF\nC000C001C002C003C004C005C006C007C008C009C00AC00BC00CC00DC00EC00F\nC010C011C012C013C014C015C016C017C018C019C01AC01BC01CC01DC01EC01F\nC020C021C022C023C024C025C026C027C028C029C02AC02BC02CC02DC02EC02F\nC030C031C032C033C034C035C036C037C038C039C03AC03BC03DC03EC03F0000\n98\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C040C041C042C043C044C045C046C047C048C049C04AC04BC04CC04DC04E\nC04FC050C052C053C054C055C056C057C059C05AC05B00000000000000000000\n0000C05DC05EC05FC061C062C063C064C065C066C067C06AC06BC06CC06DC06E\nC06FC070C071C072C073C074C075C076C077C078C07900000000000000000000\n0000C07AC07BC07CC07DC07EC07FC080C081C082C083C084C085C086C087C088\nC089C08AC08BC08CC08DC08EC08FC092C093C095C096C097C099C09AC09BC09C\nC09DC09EC09FC0A2C0A4C0A6C0A7C0A8C0A9C0AAC0ABC0AEC0B1C0B2C0B7C0B8\nC0B9C0BAC0BBC0BEC0C2C0C3C0C4C0C6C0C7C0CAC0CBC0CDC0CEC0CFC0D1C0D2\nC0D3C0D4C0D5C0D6C0D7C0DAC0DEC0DFC0E0C0E1C0E2C0E3C0E6C0E7C0E9C0EA\nC0EBC0EDC0EEC0EFC0F0C0F1C0F2C0F3C0F6C0F8C0FAC0FBC0FCC0FDC0FEC0FF\nC101C102C103C105C106C107C109C10AC10BC10CC10DC10EC10FC111C112C113\nC114C116C117C118C119C11AC11BC121C122C125C128C129C12AC12BC12E0000\n99\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C132C133C134C135C137C13AC13BC13DC13EC13FC141C142C143C144C145\nC146C147C14AC14EC14FC150C151C152C153C156C15700000000000000000000\n0000C159C15AC15BC15DC15EC15FC160C161C162C163C166C16AC16BC16CC16D\nC16EC16FC171C172C173C175C176C177C179C17AC17B00000000000000000000\n0000C17CC17DC17EC17FC180C181C182C183C184C186C187C188C189C18AC18B\nC18FC191C192C193C195C197C198C199C19AC19BC19EC1A0C1A2C1A3C1A4C1A6\nC1A7C1AAC1ABC1ADC1AEC1AFC1B1C1B2C1B3C1B4C1B5C1B6C1B7C1B8C1B9C1BA\nC1BBC1BCC1BEC1BFC1C0C1C1C1C2C1C3C1C5C1C6C1C7C1C9C1CAC1CBC1CDC1CE\nC1CFC1D0C1D1C1D2C1D3C1D5C1D6C1D9C1DAC1DBC1DCC1DDC1DEC1DFC1E1C1E2\nC1E3C1E5C1E6C1E7C1E9C1EAC1EBC1ECC1EDC1EEC1EFC1F2C1F4C1F5C1F6C1F7\nC1F8C1F9C1FAC1FBC1FEC1FFC201C202C203C205C206C207C208C209C20AC20B\nC20EC210C212C213C214C215C216C217C21AC21BC21DC21EC221C222C2230000\n9A\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C224C225C226C227C22AC22CC22EC230C233C235C236C237C238C239C23A\nC23BC23CC23DC23EC23FC240C241C242C243C244C24500000000000000000000\n0000C246C247C249C24AC24BC24CC24DC24EC24FC252C253C255C256C257C259\nC25AC25BC25CC25DC25EC25FC261C262C263C264C26600000000000000000000\n0000C267C268C269C26AC26BC26EC26FC271C272C273C275C276C277C278C279\nC27AC27BC27EC280C282C283C284C285C286C287C28AC28BC28CC28DC28EC28F\nC291C292C293C294C295C296C297C299C29AC29CC29EC29FC2A0C2A1C2A2C2A3\nC2A6C2A7C2A9C2AAC2ABC2AEC2AFC2B0C2B1C2B2C2B3C2B6C2B8C2BAC2BBC2BC\nC2BDC2BEC2BFC2C0C2C1C2C2C2C3C2C4C2C5C2C6C2C7C2C8C2C9C2CAC2CBC2CC\nC2CDC2CEC2CFC2D0C2D1C2D2C2D3C2D4C2D5C2D6C2D7C2D8C2D9C2DAC2DBC2DE\nC2DFC2E1C2E2C2E5C2E6C2E7C2E8C2E9C2EAC2EEC2F0C2F2C2F3C2F4C2F5C2F7\nC2FAC2FDC2FEC2FFC301C302C303C304C305C306C307C30AC30BC30EC30F0000\n9B\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C310C311C312C316C317C319C31AC31BC31DC31EC31FC320C321C322C323\nC326C327C32AC32BC32CC32DC32EC32FC330C331C33200000000000000000000\n0000C333C334C335C336C337C338C339C33AC33BC33CC33DC33EC33FC340C341\nC342C343C344C346C347C348C349C34AC34BC34CC34D00000000000000000000\n0000C34EC34FC350C351C352C353C354C355C356C357C358C359C35AC35BC35C\nC35DC35EC35FC360C361C362C363C364C365C366C367C36AC36BC36DC36EC36F\nC371C373C374C375C376C377C37AC37BC37EC37FC380C381C382C383C385C386\nC387C389C38AC38BC38DC38EC38FC390C391C392C393C394C395C396C397C398\nC399C39AC39BC39CC39DC39EC39FC3A0C3A1C3A2C3A3C3A4C3A5C3A6C3A7C3A8\nC3A9C3AAC3ABC3ACC3ADC3AEC3AFC3B0C3B1C3B2C3B3C3B4C3B5C3B6C3B7C3B8\nC3B9C3BAC3BBC3BCC3BDC3BEC3BFC3C1C3C2C3C3C3C4C3C5C3C6C3C7C3C8C3C9\nC3CAC3CBC3CCC3CDC3CEC3CFC3D0C3D1C3D2C3D3C3D4C3D5C3D6C3D7C3DA0000\n9C\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C3DBC3DDC3DEC3E1C3E3C3E4C3E5C3E6C3E7C3EAC3EBC3ECC3EEC3EFC3F0\nC3F1C3F2C3F3C3F6C3F7C3F9C3FAC3FBC3FCC3FDC3FE00000000000000000000\n0000C3FFC400C401C402C403C404C405C406C407C409C40AC40BC40CC40DC40E\nC40FC411C412C413C414C415C416C417C418C419C41A00000000000000000000\n0000C41BC41CC41DC41EC41FC420C421C422C423C425C426C427C428C429C42A\nC42BC42DC42EC42FC431C432C433C435C436C437C438C439C43AC43BC43EC43F\nC440C441C442C443C444C445C446C447C449C44AC44BC44CC44DC44EC44FC450\nC451C452C453C454C455C456C457C458C459C45AC45BC45CC45DC45EC45FC460\nC461C462C463C466C467C469C46AC46BC46DC46EC46FC470C471C472C473C476\nC477C478C47AC47BC47CC47DC47EC47FC481C482C483C484C485C486C487C488\nC489C48AC48BC48CC48DC48EC48FC490C491C492C493C495C496C497C498C499\nC49AC49BC49DC49EC49FC4A0C4A1C4A2C4A3C4A4C4A5C4A6C4A7C4A8C4A90000\n9D\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C4AAC4ABC4ACC4ADC4AEC4AFC4B0C4B1C4B2C4B3C4B4C4B5C4B6C4B7C4B9\nC4BAC4BBC4BDC4BEC4BFC4C0C4C1C4C2C4C3C4C4C4C500000000000000000000\n0000C4C6C4C7C4C8C4C9C4CAC4CBC4CCC4CDC4CEC4CFC4D0C4D1C4D2C4D3C4D4\nC4D5C4D6C4D7C4D8C4D9C4DAC4DBC4DCC4DDC4DEC4DF00000000000000000000\n0000C4E0C4E1C4E2C4E3C4E4C4E5C4E6C4E7C4E8C4EAC4EBC4ECC4EDC4EEC4EF\nC4F2C4F3C4F5C4F6C4F7C4F9C4FBC4FCC4FDC4FEC502C503C504C505C506C507\nC508C509C50AC50BC50DC50EC50FC511C512C513C515C516C517C518C519C51A\nC51BC51DC51EC51FC520C521C522C523C524C525C526C527C52AC52BC52DC52E\nC52FC531C532C533C534C535C536C537C53AC53CC53EC53FC540C541C542C543\nC546C547C54BC54FC550C551C552C556C55AC55BC55CC55FC562C563C565C566\nC567C569C56AC56BC56CC56DC56EC56FC572C576C577C578C579C57AC57BC57E\nC57FC581C582C583C585C586C588C589C58AC58BC58EC590C592C593C5940000\n9E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C596C599C59AC59BC59DC59EC59FC5A1C5A2C5A3C5A4C5A5C5A6C5A7C5A8\nC5AAC5ABC5ACC5ADC5AEC5AFC5B0C5B1C5B2C5B3C5B600000000000000000000\n0000C5B7C5BAC5BFC5C0C5C1C5C2C5C3C5CBC5CDC5CFC5D2C5D3C5D5C5D6C5D7\nC5D9C5DAC5DBC5DCC5DDC5DEC5DFC5E2C5E4C5E6C5E700000000000000000000\n0000C5E8C5E9C5EAC5EBC5EFC5F1C5F2C5F3C5F5C5F8C5F9C5FAC5FBC602C603\nC604C609C60AC60BC60DC60EC60FC611C612C613C614C615C616C617C61AC61D\nC61EC61FC620C621C622C623C626C627C629C62AC62BC62FC631C632C636C638\nC63AC63CC63DC63EC63FC642C643C645C646C647C649C64AC64BC64CC64DC64E\nC64FC652C656C657C658C659C65AC65BC65EC65FC661C662C663C664C665C666\nC667C668C669C66AC66BC66DC66EC670C672C673C674C675C676C677C67AC67B\nC67DC67EC67FC681C682C683C684C685C686C687C68AC68CC68EC68FC690C691\nC692C693C696C697C699C69AC69BC69DC69EC69FC6A0C6A1C6A2C6A3C6A60000\n9F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C6A8C6AAC6ABC6ACC6ADC6AEC6AFC6B2C6B3C6B5C6B6C6B7C6BBC6BCC6BD\nC6BEC6BFC6C2C6C4C6C6C6C7C6C8C6C9C6CAC6CBC6CE00000000000000000000\n0000C6CFC6D1C6D2C6D3C6D5C6D6C6D7C6D8C6D9C6DAC6DBC6DEC6DFC6E2C6E3\nC6E4C6E5C6E6C6E7C6EAC6EBC6EDC6EEC6EFC6F1C6F200000000000000000000\n0000C6F3C6F4C6F5C6F6C6F7C6FAC6FBC6FCC6FEC6FFC700C701C702C703C706\nC707C709C70AC70BC70DC70EC70FC710C711C712C713C716C718C71AC71BC71C\nC71DC71EC71FC722C723C725C726C727C729C72AC72BC72CC72DC72EC72FC732\nC734C736C738C739C73AC73BC73EC73FC741C742C743C745C746C747C748C749\nC74BC74EC750C759C75AC75BC75DC75EC75FC761C762C763C764C765C766C767\nC769C76AC76CC76DC76EC76FC770C771C772C773C776C777C779C77AC77BC77F\nC780C781C782C786C78BC78CC78DC78FC792C793C795C799C79BC79CC79DC79E\nC79FC7A2C7A7C7A8C7A9C7AAC7ABC7AEC7AFC7B1C7B2C7B3C7B5C7B6C7B70000\nA0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C7B8C7B9C7BAC7BBC7BEC7C2C7C3C7C4C7C5C7C6C7C7C7CAC7CBC7CDC7CF\nC7D1C7D2C7D3C7D4C7D5C7D6C7D7C7D9C7DAC7DBC7DC00000000000000000000\n0000C7DEC7DFC7E0C7E1C7E2C7E3C7E5C7E6C7E7C7E9C7EAC7EBC7EDC7EEC7EF\nC7F0C7F1C7F2C7F3C7F4C7F5C7F6C7F7C7F8C7F9C7FA00000000000000000000\n0000C7FBC7FCC7FDC7FEC7FFC802C803C805C806C807C809C80BC80CC80DC80E\nC80FC812C814C817C818C819C81AC81BC81EC81FC821C822C823C825C826C827\nC828C829C82AC82BC82EC830C832C833C834C835C836C837C839C83AC83BC83D\nC83EC83FC841C842C843C844C845C846C847C84AC84BC84EC84FC850C851C852\nC853C855C856C857C858C859C85AC85BC85CC85DC85EC85FC860C861C862C863\nC864C865C866C867C868C869C86AC86BC86CC86DC86EC86FC872C873C875C876\nC877C879C87BC87CC87DC87EC87FC882C884C888C889C88AC88EC88FC890C891\nC892C893C895C896C897C898C899C89AC89BC89CC89EC8A0C8A2C8A3C8A40000\nA1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C8A5C8A6C8A7C8A9C8AAC8ABC8ACC8ADC8AEC8AFC8B0C8B1C8B2C8B3C8B4\nC8B5C8B6C8B7C8B8C8B9C8BAC8BBC8BEC8BFC8C0C8C100000000000000000000\n0000C8C2C8C3C8C5C8C6C8C7C8C9C8CAC8CBC8CDC8CEC8CFC8D0C8D1C8D2C8D3\nC8D6C8D8C8DAC8DBC8DCC8DDC8DEC8DFC8E2C8E3C8E500000000000000000000\n0000C8E6C8E7C8E8C8E9C8EAC8EBC8ECC8EDC8EEC8EFC8F0C8F1C8F2C8F3C8F4\nC8F6C8F7C8F8C8F9C8FAC8FBC8FEC8FFC901C902C903C907C908C909C90AC90B\nC90E30003001300200B72025202600A8300300AD20152225FF3C223C20182019\n201C201D3014301530083009300A300B300C300D300E300F3010301100B100D7\n00F7226022642265221E223400B0203220332103212BFFE0FFE1FFE526422640\n222022A52312220222072261225200A7203B2606260525CB25CF25CE25C725C6\n25A125A025B325B225BD25BC219221902191219321943013226A226B221A223D\n221D2235222B222C2208220B2286228722822283222A222922272228FFE20000\nA2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C910C912C913C914C915C916C917C919C91AC91BC91CC91DC91EC91FC920\nC921C922C923C924C925C926C927C928C929C92AC92B00000000000000000000\n0000C92DC92EC92FC930C931C932C933C935C936C937C938C939C93AC93BC93C\nC93DC93EC93FC940C941C942C943C944C945C946C94700000000000000000000\n0000C948C949C94AC94BC94CC94DC94EC94FC952C953C955C956C957C959C95A\nC95BC95CC95DC95EC95FC962C964C965C966C967C968C969C96AC96BC96DC96E\nC96F21D221D42200220300B4FF5E02C702D802DD02DA02D900B802DB00A100BF\n02D0222E2211220F00A42109203025C125C025B725B626642660266126652667\n2663229925C825A325D025D1259225A425A525A825A725A625A92668260F260E\n261C261E00B62020202121952197219921962198266D2669266A266C327F321C\n211633C7212233C233D8212120AC00AE00000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C971C972C973C975C976C977C978C979C97AC97BC97DC97EC97FC980C981\nC982C983C984C985C986C987C98AC98BC98DC98EC98F00000000000000000000\n0000C991C992C993C994C995C996C997C99AC99CC99EC99FC9A0C9A1C9A2C9A3\nC9A4C9A5C9A6C9A7C9A8C9A9C9AAC9ABC9ACC9ADC9AE00000000000000000000\n0000C9AFC9B0C9B1C9B2C9B3C9B4C9B5C9B6C9B7C9B8C9B9C9BAC9BBC9BCC9BD\nC9BEC9BFC9C2C9C3C9C5C9C6C9C9C9CBC9CCC9CDC9CEC9CFC9D2C9D4C9D7C9D8\nC9DBFF01FF02FF03FF04FF05FF06FF07FF08FF09FF0AFF0BFF0CFF0DFF0EFF0F\nFF10FF11FF12FF13FF14FF15FF16FF17FF18FF19FF1AFF1BFF1CFF1DFF1EFF1F\nFF20FF21FF22FF23FF24FF25FF26FF27FF28FF29FF2AFF2BFF2CFF2DFF2EFF2F\nFF30FF31FF32FF33FF34FF35FF36FF37FF38FF39FF3AFF3BFFE6FF3DFF3EFF3F\nFF40FF41FF42FF43FF44FF45FF46FF47FF48FF49FF4AFF4BFF4CFF4DFF4EFF4F\nFF50FF51FF52FF53FF54FF55FF56FF57FF58FF59FF5AFF5BFF5CFF5DFFE30000\nA4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C9DEC9DFC9E1C9E3C9E5C9E6C9E8C9E9C9EAC9EBC9EEC9F2C9F3C9F4C9F5\nC9F6C9F7C9FAC9FBC9FDC9FEC9FFCA01CA02CA03CA0400000000000000000000\n0000CA05CA06CA07CA0ACA0ECA0FCA10CA11CA12CA13CA15CA16CA17CA19CA1A\nCA1BCA1CCA1DCA1ECA1FCA20CA21CA22CA23CA24CA2500000000000000000000\n0000CA26CA27CA28CA2ACA2BCA2CCA2DCA2ECA2FCA30CA31CA32CA33CA34CA35\nCA36CA37CA38CA39CA3ACA3BCA3CCA3DCA3ECA3FCA40CA41CA42CA43CA44CA45\nCA46313131323133313431353136313731383139313A313B313C313D313E313F\n3140314131423143314431453146314731483149314A314B314C314D314E314F\n3150315131523153315431553156315731583159315A315B315C315D315E315F\n3160316131623163316431653166316731683169316A316B316C316D316E316F\n3170317131723173317431753176317731783179317A317B317C317D317E317F\n3180318131823183318431853186318731883189318A318B318C318D318E0000\nA5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CA47CA48CA49CA4ACA4BCA4ECA4FCA51CA52CA53CA55CA56CA57CA58CA59\nCA5ACA5BCA5ECA62CA63CA64CA65CA66CA67CA69CA6A00000000000000000000\n0000CA6BCA6CCA6DCA6ECA6FCA70CA71CA72CA73CA74CA75CA76CA77CA78CA79\nCA7ACA7BCA7CCA7ECA7FCA80CA81CA82CA83CA85CA8600000000000000000000\n0000CA87CA88CA89CA8ACA8BCA8CCA8DCA8ECA8FCA90CA91CA92CA93CA94CA95\nCA96CA97CA99CA9ACA9BCA9CCA9DCA9ECA9FCAA0CAA1CAA2CAA3CAA4CAA5CAA6\nCAA7217021712172217321742175217621772178217900000000000000000000\n2160216121622163216421652166216721682169000000000000000000000000\n0000039103920393039403950396039703980399039A039B039C039D039E039F\n03A003A103A303A403A503A603A703A803A90000000000000000000000000000\n000003B103B203B303B403B503B603B703B803B903BA03BB03BC03BD03BE03BF\n03C003C103C303C403C503C603C703C803C90000000000000000000000000000\nA6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CAA8CAA9CAAACAABCAACCAADCAAECAAFCAB0CAB1CAB2CAB3CAB4CAB5CAB6\nCAB7CAB8CAB9CABACABBCABECABFCAC1CAC2CAC3CAC500000000000000000000\n0000CAC6CAC7CAC8CAC9CACACACBCACECAD0CAD2CAD4CAD5CAD6CAD7CADACADB\nCADCCADDCADECADFCAE1CAE2CAE3CAE4CAE5CAE6CAE700000000000000000000\n0000CAE8CAE9CAEACAEBCAEDCAEECAEFCAF0CAF1CAF2CAF3CAF5CAF6CAF7CAF8\nCAF9CAFACAFBCAFCCAFDCAFECAFFCB00CB01CB02CB03CB04CB05CB06CB07CB09\nCB0A25002502250C251025182514251C252C25242534253C25012503250F2513\n251B251725232533252B253B254B2520252F25282537253F251D253025252538\n254225122511251A251925162515250E250D251E251F25212522252625272529\n252A252D252E25312532253525362539253A253D253E25402541254325442545\n2546254725482549254A00000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CB0BCB0CCB0DCB0ECB0FCB11CB12CB13CB15CB16CB17CB19CB1ACB1BCB1C\nCB1DCB1ECB1FCB22CB23CB24CB25CB26CB27CB28CB2900000000000000000000\n0000CB2ACB2BCB2CCB2DCB2ECB2FCB30CB31CB32CB33CB34CB35CB36CB37CB38\nCB39CB3ACB3BCB3CCB3DCB3ECB3FCB40CB42CB43CB4400000000000000000000\n0000CB45CB46CB47CB4ACB4BCB4DCB4ECB4FCB51CB52CB53CB54CB55CB56CB57\nCB5ACB5BCB5CCB5ECB5FCB60CB61CB62CB63CB65CB66CB67CB68CB69CB6ACB6B\nCB6C3395339633972113339833C433A333A433A533A63399339A339B339C339D\n339E339F33A033A133A233CA338D338E338F33CF3388338933C833A733A833B0\n33B133B233B333B433B533B633B733B833B93380338133823383338433BA33BB\n33BC33BD33BE33BF33903391339233933394212633C033C1338A338B338C33D6\n33C533AD33AE33AF33DB33A933AA33AB33AC33DD33D033D333C333C933DC33C6\n0000000000000000000000000000000000000000000000000000000000000000\nA8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CB6DCB6ECB6FCB70CB71CB72CB73CB74CB75CB76CB77CB7ACB7BCB7CCB7D\nCB7ECB7FCB80CB81CB82CB83CB84CB85CB86CB87CB8800000000000000000000\n0000CB89CB8ACB8BCB8CCB8DCB8ECB8FCB90CB91CB92CB93CB94CB95CB96CB97\nCB98CB99CB9ACB9BCB9DCB9ECB9FCBA0CBA1CBA2CBA300000000000000000000\n0000CBA4CBA5CBA6CBA7CBA8CBA9CBAACBABCBACCBADCBAECBAFCBB0CBB1CBB2\nCBB3CBB4CBB5CBB6CBB7CBB9CBBACBBBCBBCCBBDCBBECBBFCBC0CBC1CBC2CBC3\nCBC400C600D000AA0126000001320000013F014100D8015200BA00DE0166014A\n00003260326132623263326432653266326732683269326A326B326C326D326E\n326F3270327132723273327432753276327732783279327A327B24D024D124D2\n24D324D424D524D624D724D824D924DA24DB24DC24DD24DE24DF24E024E124E2\n24E324E424E524E624E724E824E9246024612462246324642465246624672468\n2469246A246B246C246D246E00BD2153215400BC00BE215B215C215D215E0000\nA9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CBC5CBC6CBC7CBC8CBC9CBCACBCBCBCCCBCDCBCECBCFCBD0CBD1CBD2CBD3\nCBD5CBD6CBD7CBD8CBD9CBDACBDBCBDCCBDDCBDECBDF00000000000000000000\n0000CBE0CBE1CBE2CBE3CBE5CBE6CBE8CBEACBEBCBECCBEDCBEECBEFCBF0CBF1\nCBF2CBF3CBF4CBF5CBF6CBF7CBF8CBF9CBFACBFBCBFC00000000000000000000\n0000CBFDCBFECBFFCC00CC01CC02CC03CC04CC05CC06CC07CC08CC09CC0ACC0B\nCC0ECC0FCC11CC12CC13CC15CC16CC17CC18CC19CC1ACC1BCC1ECC1FCC20CC23\nCC2400E6011100F001270131013301380140014200F8015300DF00FE0167014B\n01493200320132023203320432053206320732083209320A320B320C320D320E\n320F3210321132123213321432153216321732183219321A321B249C249D249E\n249F24A024A124A224A324A424A524A624A724A824A924AA24AB24AC24AD24AE\n24AF24B024B124B224B324B424B5247424752476247724782479247A247B247C\n247D247E247F24802481248200B900B200B32074207F20812082208320840000\nAA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CC25CC26CC2ACC2BCC2DCC2FCC31CC32CC33CC34CC35CC36CC37CC3ACC3F\nCC40CC41CC42CC43CC46CC47CC49CC4ACC4BCC4DCC4E00000000000000000000\n0000CC4FCC50CC51CC52CC53CC56CC5ACC5BCC5CCC5DCC5ECC5FCC61CC62CC63\nCC65CC67CC69CC6ACC6BCC6CCC6DCC6ECC6FCC71CC7200000000000000000000\n0000CC73CC74CC76CC77CC78CC79CC7ACC7BCC7CCC7DCC7ECC7FCC80CC81CC82\nCC83CC84CC85CC86CC87CC88CC89CC8ACC8BCC8CCC8DCC8ECC8FCC90CC91CC92\nCC93304130423043304430453046304730483049304A304B304C304D304E304F\n3050305130523053305430553056305730583059305A305B305C305D305E305F\n3060306130623063306430653066306730683069306A306B306C306D306E306F\n3070307130723073307430753076307730783079307A307B307C307D307E307F\n3080308130823083308430853086308730883089308A308B308C308D308E308F\n3090309130923093000000000000000000000000000000000000000000000000\nAB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CC94CC95CC96CC97CC9ACC9BCC9DCC9ECC9FCCA1CCA2CCA3CCA4CCA5CCA6\nCCA7CCAACCAECCAFCCB0CCB1CCB2CCB3CCB6CCB7CCB900000000000000000000\n0000CCBACCBBCCBDCCBECCBFCCC0CCC1CCC2CCC3CCC6CCC8CCCACCCBCCCCCCCD\nCCCECCCFCCD1CCD2CCD3CCD5CCD6CCD7CCD8CCD9CCDA00000000000000000000\n0000CCDBCCDCCCDDCCDECCDFCCE0CCE1CCE2CCE3CCE5CCE6CCE7CCE8CCE9CCEA\nCCEBCCEDCCEECCEFCCF1CCF2CCF3CCF4CCF5CCF6CCF7CCF8CCF9CCFACCFBCCFC\nCCFD30A130A230A330A430A530A630A730A830A930AA30AB30AC30AD30AE30AF\n30B030B130B230B330B430B530B630B730B830B930BA30BB30BC30BD30BE30BF\n30C030C130C230C330C430C530C630C730C830C930CA30CB30CC30CD30CE30CF\n30D030D130D230D330D430D530D630D730D830D930DA30DB30DC30DD30DE30DF\n30E030E130E230E330E430E530E630E730E830E930EA30EB30EC30ED30EE30EF\n30F030F130F230F330F430F530F6000000000000000000000000000000000000\nAC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CCFECCFFCD00CD02CD03CD04CD05CD06CD07CD0ACD0BCD0DCD0ECD0FCD11\nCD12CD13CD14CD15CD16CD17CD1ACD1CCD1ECD1FCD2000000000000000000000\n0000CD21CD22CD23CD25CD26CD27CD29CD2ACD2BCD2DCD2ECD2FCD30CD31CD32\nCD33CD34CD35CD36CD37CD38CD3ACD3BCD3CCD3DCD3E00000000000000000000\n0000CD3FCD40CD41CD42CD43CD44CD45CD46CD47CD48CD49CD4ACD4BCD4CCD4D\nCD4ECD4FCD50CD51CD52CD53CD54CD55CD56CD57CD58CD59CD5ACD5BCD5DCD5E\nCD5F04100411041204130414041504010416041704180419041A041B041C041D\n041E041F0420042104220423042404250426042704280429042A042B042C042D\n042E042F00000000000000000000000000000000000000000000000000000000\n000004300431043204330434043504510436043704380439043A043B043C043D\n043E043F0440044104420443044404450446044704480449044A044B044C044D\n044E044F00000000000000000000000000000000000000000000000000000000\nAD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CD61CD62CD63CD65CD66CD67CD68CD69CD6ACD6BCD6ECD70CD72CD73CD74\nCD75CD76CD77CD79CD7ACD7BCD7CCD7DCD7ECD7FCD8000000000000000000000\n0000CD81CD82CD83CD84CD85CD86CD87CD89CD8ACD8BCD8CCD8DCD8ECD8FCD90\nCD91CD92CD93CD96CD97CD99CD9ACD9BCD9DCD9ECD9F00000000000000000000\n0000CDA0CDA1CDA2CDA3CDA6CDA8CDAACDABCDACCDADCDAECDAFCDB1CDB2CDB3\nCDB4CDB5CDB6CDB7CDB8CDB9CDBACDBBCDBCCDBDCDBECDBFCDC0CDC1CDC2CDC3\nCDC5000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nAE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CDC6CDC7CDC8CDC9CDCACDCBCDCDCDCECDCFCDD1CDD2CDD3CDD4CDD5CDD6\nCDD7CDD8CDD9CDDACDDBCDDCCDDDCDDECDDFCDE0CDE100000000000000000000\n0000CDE2CDE3CDE4CDE5CDE6CDE7CDE9CDEACDEBCDEDCDEECDEFCDF1CDF2CDF3\nCDF4CDF5CDF6CDF7CDFACDFCCDFECDFFCE00CE01CE0200000000000000000000\n0000CE03CE05CE06CE07CE09CE0ACE0BCE0DCE0ECE0FCE10CE11CE12CE13CE15\nCE16CE17CE18CE1ACE1BCE1CCE1DCE1ECE1FCE22CE23CE25CE26CE27CE29CE2A\nCE2B000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nAF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CE2CCE2DCE2ECE2FCE32CE34CE36CE37CE38CE39CE3ACE3BCE3CCE3DCE3E\nCE3FCE40CE41CE42CE43CE44CE45CE46CE47CE48CE4900000000000000000000\n0000CE4ACE4BCE4CCE4DCE4ECE4FCE50CE51CE52CE53CE54CE55CE56CE57CE5A\nCE5BCE5DCE5ECE62CE63CE64CE65CE66CE67CE6ACE6C00000000000000000000\n0000CE6ECE6FCE70CE71CE72CE73CE76CE77CE79CE7ACE7BCE7DCE7ECE7FCE80\nCE81CE82CE83CE86CE88CE8ACE8BCE8CCE8DCE8ECE8FCE92CE93CE95CE96CE97\nCE99000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nB0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CE9ACE9BCE9CCE9DCE9ECE9FCEA2CEA6CEA7CEA8CEA9CEAACEABCEAECEAF\nCEB0CEB1CEB2CEB3CEB4CEB5CEB6CEB7CEB8CEB9CEBA00000000000000000000\n0000CEBBCEBCCEBDCEBECEBFCEC0CEC2CEC3CEC4CEC5CEC6CEC7CEC8CEC9CECA\nCECBCECCCECDCECECECFCED0CED1CED2CED3CED4CED500000000000000000000\n0000CED6CED7CED8CED9CEDACEDBCEDCCEDDCEDECEDFCEE0CEE1CEE2CEE3CEE6\nCEE7CEE9CEEACEEDCEEECEEFCEF0CEF1CEF2CEF3CEF6CEFACEFBCEFCCEFDCEFE\nCEFFAC00AC01AC04AC07AC08AC09AC0AAC10AC11AC12AC13AC14AC15AC16AC17\nAC19AC1AAC1BAC1CAC1DAC20AC24AC2CAC2DAC2FAC30AC31AC38AC39AC3CAC40\nAC4BAC4DAC54AC58AC5CAC70AC71AC74AC77AC78AC7AAC80AC81AC83AC84AC85\nAC86AC89AC8AAC8BAC8CAC90AC94AC9CAC9DAC9FACA0ACA1ACA8ACA9ACAAACAC\nACAFACB0ACB8ACB9ACBBACBCACBDACC1ACC4ACC8ACCCACD5ACD7ACE0ACE1ACE4\nACE7ACE8ACEAACECACEFACF0ACF1ACF3ACF5ACF6ACFCACFDAD00AD04AD060000\nB1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CF02CF03CF05CF06CF07CF09CF0ACF0BCF0CCF0DCF0ECF0FCF12CF14CF16\nCF17CF18CF19CF1ACF1BCF1DCF1ECF1FCF21CF22CF2300000000000000000000\n0000CF25CF26CF27CF28CF29CF2ACF2BCF2ECF32CF33CF34CF35CF36CF37CF39\nCF3ACF3BCF3CCF3DCF3ECF3FCF40CF41CF42CF43CF4400000000000000000000\n0000CF45CF46CF47CF48CF49CF4ACF4BCF4CCF4DCF4ECF4FCF50CF51CF52CF53\nCF56CF57CF59CF5ACF5BCF5DCF5ECF5FCF60CF61CF62CF63CF66CF68CF6ACF6B\nCF6CAD0CAD0DAD0FAD11AD18AD1CAD20AD29AD2CAD2DAD34AD35AD38AD3CAD44\nAD45AD47AD49AD50AD54AD58AD61AD63AD6CAD6DAD70AD73AD74AD75AD76AD7B\nAD7CAD7DAD7FAD81AD82AD88AD89AD8CAD90AD9CAD9DADA4ADB7ADC0ADC1ADC4\nADC8ADD0ADD1ADD3ADDCADE0ADE4ADF8ADF9ADFCADFFAE00AE01AE08AE09AE0B\nAE0DAE14AE30AE31AE34AE37AE38AE3AAE40AE41AE43AE45AE46AE4AAE4CAE4D\nAE4EAE50AE54AE56AE5CAE5DAE5FAE60AE61AE65AE68AE69AE6CAE70AE780000\nB2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CF6DCF6ECF6FCF72CF73CF75CF76CF77CF79CF7ACF7BCF7CCF7DCF7ECF7F\nCF81CF82CF83CF84CF86CF87CF88CF89CF8ACF8BCF8D00000000000000000000\n0000CF8ECF8FCF90CF91CF92CF93CF94CF95CF96CF97CF98CF99CF9ACF9BCF9C\nCF9DCF9ECF9FCFA0CFA2CFA3CFA4CFA5CFA6CFA7CFA900000000000000000000\n0000CFAACFABCFACCFADCFAECFAFCFB1CFB2CFB3CFB4CFB5CFB6CFB7CFB8CFB9\nCFBACFBBCFBCCFBDCFBECFBFCFC0CFC1CFC2CFC3CFC5CFC6CFC7CFC8CFC9CFCA\nCFCBAE79AE7BAE7CAE7DAE84AE85AE8CAEBCAEBDAEBEAEC0AEC4AECCAECDAECF\nAED0AED1AED8AED9AEDCAEE8AEEBAEEDAEF4AEF8AEFCAF07AF08AF0DAF10AF2C\nAF2DAF30AF32AF34AF3CAF3DAF3FAF41AF42AF43AF48AF49AF50AF5CAF5DAF64\nAF65AF79AF80AF84AF88AF90AF91AF95AF9CAFB8AFB9AFBCAFC0AFC7AFC8AFC9\nAFCBAFCDAFCEAFD4AFDCAFE8AFE9AFF0AFF1AFF4AFF8B000B001B004B00CB010\nB014B01CB01DB028B044B045B048B04AB04CB04EB053B054B055B057B0590000\nB3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000CFCCCFCDCFCECFCFCFD0CFD1CFD2CFD3CFD4CFD5CFD6CFD7CFD8CFD9CFDA\nCFDBCFDCCFDDCFDECFDFCFE2CFE3CFE5CFE6CFE7CFE900000000000000000000\n0000CFEACFEBCFECCFEDCFEECFEFCFF2CFF4CFF6CFF7CFF8CFF9CFFACFFBCFFD\nCFFECFFFD001D002D003D005D006D007D008D009D00A00000000000000000000\n0000D00BD00CD00DD00ED00FD010D012D013D014D015D016D017D019D01AD01B\nD01CD01DD01ED01FD020D021D022D023D024D025D026D027D028D029D02AD02B\nD02CB05DB07CB07DB080B084B08CB08DB08FB091B098B099B09AB09CB09FB0A0\nB0A1B0A2B0A8B0A9B0ABB0ACB0ADB0AEB0AFB0B1B0B3B0B4B0B5B0B8B0BCB0C4\nB0C5B0C7B0C8B0C9B0D0B0D1B0D4B0D8B0E0B0E5B108B109B10BB10CB110B112\nB113B118B119B11BB11CB11DB123B124B125B128B12CB134B135B137B138B139\nB140B141B144B148B150B151B154B155B158B15CB160B178B179B17CB180B182\nB188B189B18BB18DB192B193B194B198B19CB1A8B1CCB1D0B1D4B1DCB1DD0000\nB4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D02ED02FD030D031D032D033D036D037D039D03AD03BD03DD03ED03FD040\nD041D042D043D046D048D04AD04BD04CD04DD04ED04F00000000000000000000\n0000D051D052D053D055D056D057D059D05AD05BD05CD05DD05ED05FD061D062\nD063D064D065D066D067D068D069D06AD06BD06ED06F00000000000000000000\n0000D071D072D073D075D076D077D078D079D07AD07BD07ED07FD080D082D083\nD084D085D086D087D088D089D08AD08BD08CD08DD08ED08FD090D091D092D093\nD094B1DFB1E8B1E9B1ECB1F0B1F9B1FBB1FDB204B205B208B20BB20CB214B215\nB217B219B220B234B23CB258B25CB260B268B269B274B275B27CB284B285B289\nB290B291B294B298B299B29AB2A0B2A1B2A3B2A5B2A6B2AAB2ACB2B0B2B4B2C8\nB2C9B2CCB2D0B2D2B2D8B2D9B2DBB2DDB2E2B2E4B2E5B2E6B2E8B2EBB2ECB2ED\nB2EEB2EFB2F3B2F4B2F5B2F7B2F8B2F9B2FAB2FBB2FFB300B301B304B308B310\nB311B313B314B315B31CB354B355B356B358B35BB35CB35EB35FB364B3650000\nB5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D095D096D097D098D099D09AD09BD09CD09DD09ED09FD0A0D0A1D0A2D0A3\nD0A6D0A7D0A9D0AAD0ABD0ADD0AED0AFD0B0D0B1D0B200000000000000000000\n0000D0B3D0B6D0B8D0BAD0BBD0BCD0BDD0BED0BFD0C2D0C3D0C5D0C6D0C7D0CA\nD0CBD0CCD0CDD0CED0CFD0D2D0D6D0D7D0D8D0D9D0DA00000000000000000000\n0000D0DBD0DED0DFD0E1D0E2D0E3D0E5D0E6D0E7D0E8D0E9D0EAD0EBD0EED0F2\nD0F3D0F4D0F5D0F6D0F7D0F9D0FAD0FBD0FCD0FDD0FED0FFD100D101D102D103\nD104B367B369B36BB36EB370B371B374B378B380B381B383B384B385B38CB390\nB394B3A0B3A1B3A8B3ACB3C4B3C5B3C8B3CBB3CCB3CEB3D0B3D4B3D5B3D7B3D9\nB3DBB3DDB3E0B3E4B3E8B3FCB410B418B41CB420B428B429B42BB434B450B451\nB454B458B460B461B463B465B46CB480B488B49DB4A4B4A8B4ACB4B5B4B7B4B9\nB4C0B4C4B4C8B4D0B4D5B4DCB4DDB4E0B4E3B4E4B4E6B4ECB4EDB4EFB4F1B4F8\nB514B515B518B51BB51CB524B525B527B528B529B52AB530B531B534B5380000\nB6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D105D106D107D108D109D10AD10BD10CD10ED10FD110D111D112D113D114\nD115D116D117D118D119D11AD11BD11CD11DD11ED11F00000000000000000000\n0000D120D121D122D123D124D125D126D127D128D129D12AD12BD12CD12DD12E\nD12FD132D133D135D136D137D139D13BD13CD13DD13E00000000000000000000\n0000D13FD142D146D147D148D149D14AD14BD14ED14FD151D152D153D155D156\nD157D158D159D15AD15BD15ED160D162D163D164D165D166D167D169D16AD16B\nD16DB540B541B543B544B545B54BB54CB54DB550B554B55CB55DB55FB560B561\nB5A0B5A1B5A4B5A8B5AAB5ABB5B0B5B1B5B3B5B4B5B5B5BBB5BCB5BDB5C0B5C4\nB5CCB5CDB5CFB5D0B5D1B5D8B5ECB610B611B614B618B625B62CB634B648B664\nB668B69CB69DB6A0B6A4B6ABB6ACB6B1B6D4B6F0B6F4B6F8B700B701B705B728\nB729B72CB72FB730B738B739B73BB744B748B74CB754B755B760B764B768B770\nB771B773B775B77CB77DB780B784B78CB78DB78FB790B791B792B796B7970000\nB7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D16ED16FD170D171D172D173D174D175D176D177D178D179D17AD17BD17D\nD17ED17FD180D181D182D183D185D186D187D189D18A00000000000000000000\n0000D18BD18CD18DD18ED18FD190D191D192D193D194D195D196D197D198D199\nD19AD19BD19CD19DD19ED19FD1A2D1A3D1A5D1A6D1A700000000000000000000\n0000D1A9D1AAD1ABD1ACD1ADD1AED1AFD1B2D1B4D1B6D1B7D1B8D1B9D1BBD1BD\nD1BED1BFD1C1D1C2D1C3D1C4D1C5D1C6D1C7D1C8D1C9D1CAD1CBD1CCD1CDD1CE\nD1CFB798B799B79CB7A0B7A8B7A9B7ABB7ACB7ADB7B4B7B5B7B8B7C7B7C9B7EC\nB7EDB7F0B7F4B7FCB7FDB7FFB800B801B807B808B809B80CB810B818B819B81B\nB81DB824B825B828B82CB834B835B837B838B839B840B844B851B853B85CB85D\nB860B864B86CB86DB86FB871B878B87CB88DB8A8B8B0B8B4B8B8B8C0B8C1B8C3\nB8C5B8CCB8D0B8D4B8DDB8DFB8E1B8E8B8E9B8ECB8F0B8F8B8F9B8FBB8FDB904\nB918B920B93CB93DB940B944B94CB94FB951B958B959B95CB960B968B9690000\nB8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D1D0D1D1D1D2D1D3D1D4D1D5D1D6D1D7D1D9D1DAD1DBD1DCD1DDD1DED1DF\nD1E0D1E1D1E2D1E3D1E4D1E5D1E6D1E7D1E8D1E9D1EA00000000000000000000\n0000D1EBD1ECD1EDD1EED1EFD1F0D1F1D1F2D1F3D1F5D1F6D1F7D1F9D1FAD1FB\nD1FCD1FDD1FED1FFD200D201D202D203D204D205D20600000000000000000000\n0000D208D20AD20BD20CD20DD20ED20FD211D212D213D214D215D216D217D218\nD219D21AD21BD21CD21DD21ED21FD220D221D222D223D224D225D226D227D228\nD229B96BB96DB974B975B978B97CB984B985B987B989B98AB98DB98EB9ACB9AD\nB9B0B9B4B9BCB9BDB9BFB9C1B9C8B9C9B9CCB9CEB9CFB9D0B9D1B9D2B9D8B9D9\nB9DBB9DDB9DEB9E1B9E3B9E4B9E5B9E8B9ECB9F4B9F5B9F7B9F8B9F9B9FABA00\nBA01BA08BA15BA38BA39BA3CBA40BA42BA48BA49BA4BBA4DBA4EBA53BA54BA55\nBA58BA5CBA64BA65BA67BA68BA69BA70BA71BA74BA78BA83BA84BA85BA87BA8C\nBAA8BAA9BAABBAACBAB0BAB2BAB8BAB9BABBBABDBAC4BAC8BAD8BAD9BAFC0000\nB9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D22AD22BD22ED22FD231D232D233D235D236D237D238D239D23AD23BD23E\nD240D242D243D244D245D246D247D249D24AD24BD24C00000000000000000000\n0000D24DD24ED24FD250D251D252D253D254D255D256D257D258D259D25AD25B\nD25DD25ED25FD260D261D262D263D265D266D267D26800000000000000000000\n0000D269D26AD26BD26CD26DD26ED26FD270D271D272D273D274D275D276D277\nD278D279D27AD27BD27CD27DD27ED27FD282D283D285D286D287D289D28AD28B\nD28CBB00BB04BB0DBB0FBB11BB18BB1CBB20BB29BB2BBB34BB35BB36BB38BB3B\nBB3CBB3DBB3EBB44BB45BB47BB49BB4DBB4FBB50BB54BB58BB61BB63BB6CBB88\nBB8CBB90BBA4BBA8BBACBBB4BBB7BBC0BBC4BBC8BBD0BBD3BBF8BBF9BBFCBBFF\nBC00BC02BC08BC09BC0BBC0CBC0DBC0FBC11BC14BC15BC16BC17BC18BC1BBC1C\nBC1DBC1EBC1FBC24BC25BC27BC29BC2DBC30BC31BC34BC38BC40BC41BC43BC44\nBC45BC49BC4CBC4DBC50BC5DBC84BC85BC88BC8BBC8CBC8EBC94BC95BC970000\nBA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D28DD28ED28FD292D293D294D296D297D298D299D29AD29BD29DD29ED29F\nD2A1D2A2D2A3D2A5D2A6D2A7D2A8D2A9D2AAD2ABD2AD00000000000000000000\n0000D2AED2AFD2B0D2B2D2B3D2B4D2B5D2B6D2B7D2BAD2BBD2BDD2BED2C1D2C3\nD2C4D2C5D2C6D2C7D2CAD2CCD2CDD2CED2CFD2D0D2D100000000000000000000\n0000D2D2D2D3D2D5D2D6D2D7D2D9D2DAD2DBD2DDD2DED2DFD2E0D2E1D2E2D2E3\nD2E6D2E7D2E8D2E9D2EAD2EBD2ECD2EDD2EED2EFD2F2D2F3D2F5D2F6D2F7D2F9\nD2FABC99BC9ABCA0BCA1BCA4BCA7BCA8BCB0BCB1BCB3BCB4BCB5BCBCBCBDBCC0\nBCC4BCCDBCCFBCD0BCD1BCD5BCD8BCDCBCF4BCF5BCF6BCF8BCFCBD04BD05BD07\nBD09BD10BD14BD24BD2CBD40BD48BD49BD4CBD50BD58BD59BD64BD68BD80BD81\nBD84BD87BD88BD89BD8ABD90BD91BD93BD95BD99BD9ABD9CBDA4BDB0BDB8BDD4\nBDD5BDD8BDDCBDE9BDF0BDF4BDF8BE00BE03BE05BE0CBE0DBE10BE14BE1CBE1D\nBE1FBE44BE45BE48BE4CBE4EBE54BE55BE57BE59BE5ABE5BBE60BE61BE640000\nBB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D2FBD2FCD2FDD2FED2FFD302D304D306D307D308D309D30AD30BD30FD311\nD312D313D315D317D318D319D31AD31BD31ED322D32300000000000000000000\n0000D324D326D327D32AD32BD32DD32ED32FD331D332D333D334D335D336D337\nD33AD33ED33FD340D341D342D343D346D347D348D34900000000000000000000\n0000D34AD34BD34CD34DD34ED34FD350D351D352D353D354D355D356D357D358\nD359D35AD35BD35CD35DD35ED35FD360D361D362D363D364D365D366D367D368\nD369BE68BE6ABE70BE71BE73BE74BE75BE7BBE7CBE7DBE80BE84BE8CBE8DBE8F\nBE90BE91BE98BE99BEA8BED0BED1BED4BED7BED8BEE0BEE3BEE4BEE5BEECBF01\nBF08BF09BF18BF19BF1BBF1CBF1DBF40BF41BF44BF48BF50BF51BF55BF94BFB0\nBFC5BFCCBFCDBFD0BFD4BFDCBFDFBFE1C03CC051C058C05CC060C068C069C090\nC091C094C098C0A0C0A1C0A3C0A5C0ACC0ADC0AFC0B0C0B3C0B4C0B5C0B6C0BC\nC0BDC0BFC0C0C0C1C0C5C0C8C0C9C0CCC0D0C0D8C0D9C0DBC0DCC0DDC0E40000\nBC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D36AD36BD36CD36DD36ED36FD370D371D372D373D374D375D376D377D378\nD379D37AD37BD37ED37FD381D382D383D385D386D38700000000000000000000\n0000D388D389D38AD38BD38ED392D393D394D395D396D397D39AD39BD39DD39E\nD39FD3A1D3A2D3A3D3A4D3A5D3A6D3A7D3AAD3ACD3AE00000000000000000000\n0000D3AFD3B0D3B1D3B2D3B3D3B5D3B6D3B7D3B9D3BAD3BBD3BDD3BED3BFD3C0\nD3C1D3C2D3C3D3C6D3C7D3CAD3CBD3CCD3CDD3CED3CFD3D1D3D2D3D3D3D4D3D5\nD3D6C0E5C0E8C0ECC0F4C0F5C0F7C0F9C100C104C108C110C115C11CC11DC11E\nC11FC120C123C124C126C127C12CC12DC12FC130C131C136C138C139C13CC140\nC148C149C14BC14CC14DC154C155C158C15CC164C165C167C168C169C170C174\nC178C185C18CC18DC18EC190C194C196C19CC19DC19FC1A1C1A5C1A8C1A9C1AC\nC1B0C1BDC1C4C1C8C1CCC1D4C1D7C1D8C1E0C1E4C1E8C1F0C1F1C1F3C1FCC1FD\nC200C204C20CC20DC20FC211C218C219C21CC21FC220C228C229C22BC22D0000\nBD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D3D7D3D9D3DAD3DBD3DCD3DDD3DED3DFD3E0D3E2D3E4D3E5D3E6D3E7D3E8\nD3E9D3EAD3EBD3EED3EFD3F1D3F2D3F3D3F5D3F6D3F700000000000000000000\n0000D3F8D3F9D3FAD3FBD3FED400D402D403D404D405D406D407D409D40AD40B\nD40CD40DD40ED40FD410D411D412D413D414D415D41600000000000000000000\n0000D417D418D419D41AD41BD41CD41ED41FD420D421D422D423D424D425D426\nD427D428D429D42AD42BD42CD42DD42ED42FD430D431D432D433D434D435D436\nD437C22FC231C232C234C248C250C251C254C258C260C265C26CC26DC270C274\nC27CC27DC27FC281C288C289C290C298C29BC29DC2A4C2A5C2A8C2ACC2ADC2B4\nC2B5C2B7C2B9C2DCC2DDC2E0C2E3C2E4C2EBC2ECC2EDC2EFC2F1C2F6C2F8C2F9\nC2FBC2FCC300C308C309C30CC30DC313C314C315C318C31CC324C325C328C329\nC345C368C369C36CC370C372C378C379C37CC37DC384C388C38CC3C0C3D8C3D9\nC3DCC3DFC3E0C3E2C3E8C3E9C3EDC3F4C3F5C3F8C408C410C424C42CC4300000\nBE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D438D439D43AD43BD43CD43DD43ED43FD441D442D443D445D446D447D448\nD449D44AD44BD44CD44DD44ED44FD450D451D452D45300000000000000000000\n0000D454D455D456D457D458D459D45AD45BD45DD45ED45FD461D462D463D465\nD466D467D468D469D46AD46BD46CD46ED470D471D47200000000000000000000\n0000D473D474D475D476D477D47AD47BD47DD47ED481D483D484D485D486D487\nD48AD48CD48ED48FD490D491D492D493D495D496D497D498D499D49AD49BD49C\nD49DC434C43CC43DC448C464C465C468C46CC474C475C479C480C494C49CC4B8\nC4BCC4E9C4F0C4F1C4F4C4F8C4FAC4FFC500C501C50CC510C514C51CC528C529\nC52CC530C538C539C53BC53DC544C545C548C549C54AC54CC54DC54EC553C554\nC555C557C558C559C55DC55EC560C561C564C568C570C571C573C574C575C57C\nC57DC580C584C587C58CC58DC58FC591C595C597C598C59CC5A0C5A9C5B4C5B5\nC5B8C5B9C5BBC5BCC5BDC5BEC5C4C5C5C5C6C5C7C5C8C5C9C5CAC5CCC5CE0000\nBF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D49ED49FD4A0D4A1D4A2D4A3D4A4D4A5D4A6D4A7D4A8D4AAD4ABD4ACD4AD\nD4AED4AFD4B0D4B1D4B2D4B3D4B4D4B5D4B6D4B7D4B800000000000000000000\n0000D4B9D4BAD4BBD4BCD4BDD4BED4BFD4C0D4C1D4C2D4C3D4C4D4C5D4C6D4C7\nD4C8D4C9D4CAD4CBD4CDD4CED4CFD4D1D4D2D4D3D4D500000000000000000000\n0000D4D6D4D7D4D8D4D9D4DAD4DBD4DDD4DED4E0D4E1D4E2D4E3D4E4D4E5D4E6\nD4E7D4E9D4EAD4EBD4EDD4EED4EFD4F1D4F2D4F3D4F4D4F5D4F6D4F7D4F9D4FA\nD4FCC5D0C5D1C5D4C5D8C5E0C5E1C5E3C5E5C5ECC5EDC5EEC5F0C5F4C5F6C5F7\nC5FCC5FDC5FEC5FFC600C601C605C606C607C608C60CC610C618C619C61BC61C\nC624C625C628C62CC62DC62EC630C633C634C635C637C639C63BC640C641C644\nC648C650C651C653C654C655C65CC65DC660C66CC66FC671C678C679C67CC680\nC688C689C68BC68DC694C695C698C69CC6A4C6A5C6A7C6A9C6B0C6B1C6B4C6B8\nC6B9C6BAC6C0C6C1C6C3C6C5C6CCC6CDC6D0C6D4C6DCC6DDC6E0C6E1C6E80000\nC0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D4FED4FFD500D501D502D503D505D506D507D509D50AD50BD50DD50ED50F\nD510D511D512D513D516D518D519D51AD51BD51CD51D00000000000000000000\n0000D51ED51FD520D521D522D523D524D525D526D527D528D529D52AD52BD52C\nD52DD52ED52FD530D531D532D533D534D535D536D53700000000000000000000\n0000D538D539D53AD53BD53ED53FD541D542D543D545D546D547D548D549D54A\nD54BD54ED550D552D553D554D555D556D557D55AD55BD55DD55ED55FD561D562\nD563C6E9C6ECC6F0C6F8C6F9C6FDC704C705C708C70CC714C715C717C719C720\nC721C724C728C730C731C733C735C737C73CC73DC740C744C74AC74CC74DC74F\nC751C752C753C754C755C756C757C758C75CC760C768C76BC774C775C778C77C\nC77DC77EC783C784C785C787C788C789C78AC78EC790C791C794C796C797C798\nC79AC7A0C7A1C7A3C7A4C7A5C7A6C7ACC7ADC7B0C7B4C7BCC7BDC7BFC7C0C7C1\nC7C8C7C9C7CCC7CEC7D0C7D8C7DDC7E4C7E8C7ECC800C801C804C808C80A0000\nC1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D564D566D567D56AD56CD56ED56FD570D571D572D573D576D577D579D57A\nD57BD57DD57ED57FD580D581D582D583D586D58AD58B00000000000000000000\n0000D58CD58DD58ED58FD591D592D593D594D595D596D597D598D599D59AD59B\nD59CD59DD59ED59FD5A0D5A1D5A2D5A3D5A4D5A6D5A700000000000000000000\n0000D5A8D5A9D5AAD5ABD5ACD5ADD5AED5AFD5B0D5B1D5B2D5B3D5B4D5B5D5B6\nD5B7D5B8D5B9D5BAD5BBD5BCD5BDD5BED5BFD5C0D5C1D5C2D5C3D5C4D5C5D5C6\nD5C7C810C811C813C815C816C81CC81DC820C824C82CC82DC82FC831C838C83C\nC840C848C849C84CC84DC854C870C871C874C878C87AC880C881C883C885C886\nC887C88BC88CC88DC894C89DC89FC8A1C8A8C8BCC8BDC8C4C8C8C8CCC8D4C8D5\nC8D7C8D9C8E0C8E1C8E4C8F5C8FCC8FDC900C904C905C906C90CC90DC90FC911\nC918C92CC934C950C951C954C958C960C961C963C96CC970C974C97CC988C989\nC98CC990C998C999C99BC99DC9C0C9C1C9C4C9C7C9C8C9CAC9D0C9D1C9D30000\nC2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D5CAD5CBD5CDD5CED5CFD5D1D5D3D5D4D5D5D5D6D5D7D5DAD5DCD5DED5DF\nD5E0D5E1D5E2D5E3D5E6D5E7D5E9D5EAD5EBD5EDD5EE00000000000000000000\n0000D5EFD5F0D5F1D5F2D5F3D5F6D5F8D5FAD5FBD5FCD5FDD5FED5FFD602D603\nD605D606D607D609D60AD60BD60CD60DD60ED60FD61200000000000000000000\n0000D616D617D618D619D61AD61BD61DD61ED61FD621D622D623D625D626D627\nD628D629D62AD62BD62CD62ED62FD630D631D632D633D634D635D636D637D63A\nD63BC9D5C9D6C9D9C9DAC9DCC9DDC9E0C9E2C9E4C9E7C9ECC9EDC9EFC9F0C9F1\nC9F8C9F9C9FCCA00CA08CA09CA0BCA0CCA0DCA14CA18CA29CA4CCA4DCA50CA54\nCA5CCA5DCA5FCA60CA61CA68CA7DCA84CA98CABCCABDCAC0CAC4CACCCACDCACF\nCAD1CAD3CAD8CAD9CAE0CAECCAF4CB08CB10CB14CB18CB20CB21CB41CB48CB49\nCB4CCB50CB58CB59CB5DCB64CB78CB79CB9CCBB8CBD4CBE4CBE7CBE9CC0CCC0D\nCC10CC14CC1CCC1DCC21CC22CC27CC28CC29CC2CCC2ECC30CC38CC39CC3B0000\nC3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D63DD63ED63FD641D642D643D644D646D647D64AD64CD64ED64FD650D652\nD653D656D657D659D65AD65BD65DD65ED65FD660D66100000000000000000000\n0000D662D663D664D665D666D668D66AD66BD66CD66DD66ED66FD672D673D675\nD676D677D678D679D67AD67BD67CD67DD67ED67FD68000000000000000000000\n0000D681D682D684D686D687D688D689D68AD68BD68ED68FD691D692D693D695\nD696D697D698D699D69AD69BD69CD69ED6A0D6A2D6A3D6A4D6A5D6A6D6A7D6A9\nD6AACC3CCC3DCC3ECC44CC45CC48CC4CCC54CC55CC57CC58CC59CC60CC64CC66\nCC68CC70CC75CC98CC99CC9CCCA0CCA8CCA9CCABCCACCCADCCB4CCB5CCB8CCBC\nCCC4CCC5CCC7CCC9CCD0CCD4CCE4CCECCCF0CD01CD08CD09CD0CCD10CD18CD19\nCD1BCD1DCD24CD28CD2CCD39CD5CCD60CD64CD6CCD6DCD6FCD71CD78CD88CD94\nCD95CD98CD9CCDA4CDA5CDA7CDA9CDB0CDC4CDCCCDD0CDE8CDECCDF0CDF8CDF9\nCDFBCDFDCE04CE08CE0CCE14CE19CE20CE21CE24CE28CE30CE31CE33CE350000\nC4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D6ABD6ADD6AED6AFD6B1D6B2D6B3D6B4D6B5D6B6D6B7D6B8D6BAD6BCD6BD\nD6BED6BFD6C0D6C1D6C2D6C3D6C6D6C7D6C9D6CAD6CB00000000000000000000\n0000D6CDD6CED6CFD6D0D6D2D6D3D6D5D6D6D6D8D6DAD6DBD6DCD6DDD6DED6DF\nD6E1D6E2D6E3D6E5D6E6D6E7D6E9D6EAD6EBD6ECD6ED00000000000000000000\n0000D6EED6EFD6F1D6F2D6F3D6F4D6F6D6F7D6F8D6F9D6FAD6FBD6FED6FFD701\nD702D703D705D706D707D708D709D70AD70BD70CD70DD70ED70FD710D712D713\nD714CE58CE59CE5CCE5FCE60CE61CE68CE69CE6BCE6DCE74CE75CE78CE7CCE84\nCE85CE87CE89CE90CE91CE94CE98CEA0CEA1CEA3CEA4CEA5CEACCEADCEC1CEE4\nCEE5CEE8CEEBCEECCEF4CEF5CEF7CEF8CEF9CF00CF01CF04CF08CF10CF11CF13\nCF15CF1CCF20CF24CF2CCF2DCF2FCF30CF31CF38CF54CF55CF58CF5CCF64CF65\nCF67CF69CF70CF71CF74CF78CF80CF85CF8CCFA1CFA8CFB0CFC4CFE0CFE1CFE4\nCFE8CFF0CFF1CFF3CFF5CFFCD000D004D011D018D02DD034D035D038D03C0000\nC5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D715D716D717D71AD71BD71DD71ED71FD721D722D723D724D725D726D727\nD72AD72CD72ED72FD730D731D732D733D736D737D73900000000000000000000\n0000D73AD73BD73DD73ED73FD740D741D742D743D745D746D748D74AD74BD74C\nD74DD74ED74FD752D753D755D75AD75BD75CD75DD75E00000000000000000000\n0000D75FD762D764D766D767D768D76AD76BD76DD76ED76FD771D772D773D775\nD776D777D778D779D77AD77BD77ED77FD780D782D783D784D785D786D787D78A\nD78BD044D045D047D049D050D054D058D060D06CD06DD070D074D07CD07DD081\nD0A4D0A5D0A8D0ACD0B4D0B5D0B7D0B9D0C0D0C1D0C4D0C8D0C9D0D0D0D1D0D3\nD0D4D0D5D0DCD0DDD0E0D0E4D0ECD0EDD0EFD0F0D0F1D0F8D10DD130D131D134\nD138D13AD140D141D143D144D145D14CD14DD150D154D15CD15DD15FD161D168\nD16CD17CD184D188D1A0D1A1D1A4D1A8D1B0D1B1D1B3D1B5D1BAD1BCD1C0D1D8\nD1F4D1F8D207D209D210D22CD22DD230D234D23CD23DD23FD241D248D25C0000\nC6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D78DD78ED78FD791D792D793D794D795D796D797D79AD79CD79ED79FD7A0\nD7A1D7A2D7A30000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D264D280D281D284D288D290D291D295D29CD2A0D2A4D2ACD2B1D2B8D2B9\nD2BCD2BFD2C0D2C2D2C8D2C9D2CBD2D4D2D8D2DCD2E4D2E5D2F0D2F1D2F4D2F8\nD300D301D303D305D30CD30DD30ED310D314D316D31CD31DD31FD320D321D325\nD328D329D32CD330D338D339D33BD33CD33DD344D345D37CD37DD380D384D38C\nD38DD38FD390D391D398D399D39CD3A0D3A8D3A9D3ABD3ADD3B4D3B8D3BCD3C4\nD3C5D3C8D3C9D3D0D3D8D3E1D3E3D3ECD3EDD3F0D3F4D3FCD3FDD3FFD4010000\nC7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D408D41DD440D444D45CD460D464D46DD46FD478D479D47CD47FD480D482\nD488D489D48BD48DD494D4A9D4CCD4D0D4D4D4DCD4DFD4E8D4ECD4F0D4F8D4FB\nD4FDD504D508D50CD514D515D517D53CD53DD540D544D54CD54DD54FD551D558\nD559D55CD560D565D568D569D56BD56DD574D575D578D57CD584D585D587D588\nD589D590D5A5D5C8D5C9D5CCD5D0D5D2D5D8D5D9D5DBD5DDD5E4D5E5D5E8D5EC\nD5F4D5F5D5F7D5F9D600D601D604D608D610D611D613D614D615D61CD6200000\nC8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000D624D62DD638D639D63CD640D645D648D649D64BD64DD651D654D655D658\nD65CD667D669D670D671D674D683D685D68CD68DD690D694D69DD69FD6A1D6A8\nD6ACD6B0D6B9D6BBD6C4D6C5D6C8D6CCD6D1D6D4D6D7D6D9D6E0D6E4D6E8D6F0\nD6F5D6FCD6FDD700D704D711D718D719D71CD720D728D729D72BD72DD734D735\nD738D73CD744D747D749D750D751D754D756D757D758D759D760D761D763D765\nD769D76CD770D774D77CD77DD781D788D789D78CD790D798D799D79BD79D0000\nCA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004F3D4F73504750F952A053EF547554E556095AC15BB6668767B667B767EF\n6B4C73C275C27A3C82DB8304885788888A368CC88DCF8EFB8FE699D5523B5374\n5404606A61646BBC73CF811A89BA89D295A34F83520A58BE597859E65E725E79\n61C763C0674667EC687F6F97764E770B78F57A087AFF7C21809D826E82718AEB\n95934E6B559D66F76E3478A37AED845B8910874E97A852D8574E582A5D4C611F\n61BE6221656267D16A446E1B751875B376E377B07D3A90AF945194529F950000\nCB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000053235CAC753280DB92409598525B580859DC5CA15D175EB75F3A5F4A6177\n6C5F757A75867CE07D737DB17F8C81548221859189418B1B92FC964D9C474ECB\n4EF7500B51F1584F6137613E6168653969EA6F1175A5768676D67B8782A584CB\nF90093A7958B55805BA25751F9017CB37FB991B5502853BB5C455DE862D2636E\n64DA64E76E2070AC795B8DDD8E1EF902907D924592F84E7E4EF650655DFE5EFA\n61066957817186548E4793759A2B4E5E5091677068405109528D52926AA20000\nCC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000077BC92109ED452AB602F8FF2504861A963ED64CA683C6A846FC0818889A1\n96945805727D72AC75047D797E6D80A9898B8B7490639D5162896C7A6F547D50\n7F3A8A23517C614A7B9D8B199257938C4EAC4FD3501E50BE510652C152CD537F\n577058835E9A5F91617661AC64CE656C666F66BB66F468976D87708570F1749F\n74A574CA75D9786C78EC7ADF7AF67D457D938015803F811B83968B668F159015\n93E1980398389A5A9BE84FC25553583A59515B635C4660B86212684268B00000\nCD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000068E86EAA754C767878CE7A3D7CFB7E6B7E7C8A088AA18C3F968E9DC453E4\n53E9544A547156FA59D15B645C3B5EAB62F765376545657266A067AF69C16CBD\n75FC7690777E7A3F7F94800380A1818F82E682FD83F085C1883188B48AA5F903\n8F9C932E96C798679AD89F1354ED659B66F2688F7A408C379D6056F057645D11\n660668B168CD6EFE7428889E9BE46C68F9049AA84F9B516C5171529F5B545DE5\n6050606D62F163A7653B73D97A7A86A38CA2978F4E325BE16208679C74DC0000\nCE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000079D183D38A878AB28DE8904E934B98465ED369E885FF90EDF90551A05B98\n5BEC616368FA6B3E704C742F74D87BA17F5083C589C08CAB95DC9928522E605D\n62EC90024F8A5149532158D95EE366E06D38709A72C273D67B5080F1945B5366\n639B7F6B4E565080584A58DE602A612762D069D09B415B8F7D1880B18F5F4EA4\n50D154AC55AC5B0C5DA05DE7652A654E68216A4B72E1768E77EF7D5E7FF981A0\n854E86DF8F038F4E90CA99039A559BAB4E184E454E5D4EC74FF1517752FE0000\nCF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000534053E353E5548E5614577557A25BC75D875ED061FC62D8655167B867E9\n69CB6B506BC66BEC6C426E9D707872D77396740377BF77E97A767D7F800981FC\n8205820A82DF88628B338CFC8EC0901190B1926492B699D29A459CE99DD79F9C\n570B5C4083CA97A097AB9EB4541B7A987FA488D98ECD90E158005C4863987A9F\n5BAE5F137A797AAE828E8EAC5026523852F85377570862F363726B0A6DC37737\n53A5735785688E7695D5673A6AC36F708A6D8ECC994BF90666776B788CB40000\nD0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009B3CF90753EB572D594E63C669FB73EA78457ABA7AC57CFE8475898F8D73\n903595A852FB574775477B6083CC921EF9086A58514B524B5287621F68D86975\n969950C552A452E461C365A4683969FF747E7B4B82B983EB89B28B398FD19949\nF9094ECA599764D266116A8E7434798179BD82A9887E887F895FF90A93264F0B\n53CA602562716C727D1A7D664E98516277DC80AF4F014F0E5176518055DC5668\n573B57FA57FC5914594759935BC45C905D0E5DF15E7E5FCC628065D765E30000\nD1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000671E671F675E68CB68C46A5F6B3A6C236C7D6C826DC773987426742A7482\n74A37578757F788178EF794179477948797A7B957D007DBA7F888006802D808C\n8A188B4F8C488D779321932498E299519A0E9A0F9A659E927DCA4F76540962EE\n685491D155AB513AF90BF90C5A1C61E6F90D62CF62FFF90EF90FF910F911F912\nF91390A3F914F915F916F917F9188AFEF919F91AF91BF91C6696F91D7156F91E\nF91F96E3F920634F637A5357F921678F69606E73F9227537F923F924F9250000\nD2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007D0DF926F927887256CA5A18F928F929F92AF92BF92C4E43F92D51675948\n67F08010F92E59735E74649A79CA5FF5606C62C8637B5BE75BD752AAF92F5974\n5F296012F930F931F9327459F933F934F935F936F937F93899D1F939F93AF93B\nF93CF93DF93EF93FF940F941F942F9436FC3F944F94581BF8FB260F1F946F947\n8166F948F9495C3FF94AF94BF94CF94DF94EF94FF950F9515AE98A25677B7D10\nF952F953F954F955F956F95780FDF958F9595C3C6CE5533F6EBA591A83360000\nD3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004E394EB64F4655AE571858C75F5665B765E66A806BB56E4D77ED7AEF7C1E\n7DDE86CB88929132935B64BB6FBE737A75B890545556574D61BA64D466C76DE1\n6E5B6F6D6FB975F0804381BD854189838AC78B5A931F6C9375537B548E0F905D\n5510580258585E626207649E68E075767CD687B39EE84EE35788576E59275C0D\n5CB15E365F85623464E173B381FA888B8CB8968A9EDB5B855FB760B350125200\n52305716583558575C0E5C605CF65D8B5EA65F9260BC63116389641768430000\nD4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000068F96AC26DD86E216ED46FE471FE76DC777979B17A3B840489A98CED8DF3\n8E4890039014905390FD934D967697DC6BD27006725872A27368776379BF7BE4\n7E9B8B8058A960C7656665FD66BE6C8C711E71C98C5A98134E6D7A814EDD51AC\n51CD52D5540C61A76771685068DF6D1E6F7C75BC77B37AE580F484639285515C\n6597675C679375D87AC78373F95A8C469017982D5C6F81C0829A9041906F920D\n5F975D9D6A5971C8767B7B4985E48B0491279A30558761F6F95B76697F850000\nD5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000863F87BA88F8908FF95C6D1B70D973DE7D61843DF95D916A99F1F95E4E82\n53756B046B12703E721B862D9E1E524C8FA35D5064E5652C6B166FEB7C437E9C\n85CD896489BD62C981D8881F5ECA67176D6A72FC7405746F878290DE4F865D0D\n5FA0840A51B763A075654EAE5006516951C968816A117CAE7CB17CE7826F8AD2\n8F1B91CF4FB6513752F554425EEC616E623E65C56ADA6FFE792A85DC882395AD\n9A629A6A9E979ECE529B66C66B77701D792B8F6297426190620065236F230000\nD6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000714974897DF4806F84EE8F269023934A51BD521752A36D0C70C888C25EC9\n65826BAE6FC27C3E73754EE44F3656F9F95F5CBA5DBA601C73B27B2D7F9A7FCE\n8046901E923496F6974898189F614F8B6FA779AE91B496B752DEF960648864C4\n6AD36F5E7018721076E780018606865C8DEF8F0597329B6F9DFA9E75788C797F\n7DA083C993049E7F9E938AD658DF5F046727702774CF7C60807E512170287262\n78CA8CC28CDA8CF496F74E8650DA5BEE5ED6659971CE764277AD804A84FC0000\nD7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000907C9B279F8D58D85A415C626A136DDA6F0F763B7D2F7E37851E893893E4\n964B528965D267F369B46D416E9C700F7409746075597624786B8B2C985E516D\n622E96784F96502B5D196DEA7DB88F2A5F8B61446817F961968652D2808B51DC\n51CC695E7A1C7DBE83F196754FDA52295398540F550E5C6560A7674E68A86D6C\n728172F874067483F96275E27C6C7F797FB8838988CF88E191CC91D096E29BC9\n541D6F7E71D0749885FA8EAA96A39C579E9F67976DCB743381E89716782C0000\nD8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007ACB7B207C926469746A75F278BC78E899AC9B549EBB5BDE5E556F20819C\n83AB90884E07534D5A295DD25F4E6162633D666966FC6EFF6F2B7063779E842C\n8513883B8F1399459C3B551C62B9672B6CAB8309896A977A4EA159845FD85FD9\n671B7DB27F548292832B83BD8F1E909957CB59B95A925BD06627679A68856BCF\n71647F758CB78CE390819B4581088C8A964C9A409EA55B5F6C13731B76F276DF\n840C51AA8993514D519552C968C96C94770477207DBF7DEC97629EB56EC50000\nD9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000851151A5540D547D660E669D69276E9F76BF7791831784C2879F91699298\n9CF488824FAE519252DF59C65E3D61556478647966AE67D06A216BCD6BDB725F\n72617441773877DB801782BC83058B008B288C8C67286C90726776EE77667A46\n9DA96B7F6C92592267268499536F589359995EDF63CF663467736E3A732B7AD7\n82D7932852D95DEB61AE61CB620A62C764AB65E069596B666BCB712173F7755D\n7E46821E8302856A8AA38CBF97279D6158A89ED85011520E543B554F65870000\nDA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006C767D0A7D0B805E868A958096EF52FF6C95726954735A9A5C3E5D4B5F4C\n5FAE672A68B669636E3C6E4477097C737F8E85878B0E8FF797619EF45CB760B6\n610D61AB654F65FB65FC6C116CEF739F73C97DE195945BC6871C8B10525D535A\n62CD640F64B267346A386CCA73C0749E7B947C957E1B818A823685848FEB96F9\n99C14F34534A53CD53DB62CC642C6500659169C36CEE6F5873ED7554762276E4\n76FC78D078FB792C7D46822C87E08FD4981298EF52C362D464A56E246F510000\nDB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000767C8DCB91B192629AEE9B435023508D574A59A85C285E475F77623F653E\n65B965C16609678B699C6EC278C57D2180AA8180822B82B384A1868C8A2A8B17\n90A696329F90500D4FF3F96357F95F9862DC6392676F6E43711976C380CC80DA\n88F488F589198CE08F29914D966A4F2F4F705E1B67CF6822767D767E9B445E61\n6A0A716971D4756AF9647E41854385E998DC4F107B4F7F7095A551E15E0668B5\n6C3E6C4E6CDB72AF7BC483036CD5743A50FB528858C164D86A9774A776560000\nDC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000078A7861795E29739F965535E5F018B8A8FA88FAF908A522577A59C499F08\n4E19500251755C5B5E77661E663A67C468C570B3750175C579C97ADD8F279920\n9A084FDD582158315BF6666E6B656D116E7A6F7D73E4752B83E988DC89138B5C\n8F144F0F50D55310535C5B935FA9670D798F8179832F8514890789868F398F3B\n99A59C12672C4E764FF859495C015CEF5CF0636768D270FD71A2742B7E2B84EC\n8702902292D29CF34E0D4ED84FEF50855256526F5426549057E0592B5A660000\nDD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005B5A5B755BCC5E9CF9666276657765A76D6E6EA572367B267C3F7F368150\n8151819A8240829983A98A038CA08CE68CFB8D748DBA90E891DC961C964499D9\n9CE7531752065429567458B35954596E5FFF61A4626E66106C7E711A76C67C89\n7CDE7D1B82AC8CC196F0F9674F5B5F175F7F62C25D29670B68DA787C7E439D6C\n4E1550995315532A535159835A625E8760B2618A624962796590678769A76BD4\n6BD66BD76BD86CB8F968743575FA7812789179D579D87C837DCB7FE180A50000\nDE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000813E81C283F2871A88E88AB98B6C8CBB9119975E98DB9F3B56AC5B2A5F6C\n658C6AB36BAF6D5C6FF17015725D73AD8CA78CD3983B61916C3780589A014E4D\n4E8B4E9B4ED54F3A4F3C4F7F4FDF50FF53F253F8550655E356DB58EB59625A11\n5BEB5BFA5C045DF35E2B5F99601D6368659C65AF67F667FB68AD6B7B6C996CD7\n6E23700973457802793E7940796079C17BE97D177D728086820D838E84D186C7\n88DF8A508A5E8B1D8CDC8D668FAD90AA98FC99DF9E9D524AF9696714F96A0000\nDF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005098522A5C7165636C5573CA7523759D7B97849C917897304E7764926BBA\n715E85A94E09F96B674968EE6E17829F8518886B63F76F81921298AF4E0A50B7\n50CF511F554655AA56175B405C195CE05E385E8A5EA05EC260F368516A616E58\n723D724072C076F879657BB17FD488F389F48A738C618CDE971C585E74BD8CFD\n55C7F96C7A617D2282727272751F7525F96D7B19588558FB5DBC5E8F5EB65F90\n60556292637F654D669166D966F8681668F27280745E7B6E7D6E7DD67F720000\nE0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000080E5821285AF897F8A93901D92E49ECD9F205915596D5E2D60DC66146673\n67906C506DC56F5F77F378A984C691CB932B4ED950CA514855845B0B5BA36247\n657E65CB6E32717D74017444748774BF766C79AA7DDA7E557FA8817A81B38239\n861A87EC8A758DE3907892919425994D9BAE53685C5169546CC46D296E2B820C\n859B893B8A2D8AAA96EA9F67526166B96BB27E9687FE8D0D9583965D651D6D89\n71EEF96E57CE59D35BAC602760FA6210661F665F732973F976DB77017B6C0000\nE1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008056807281658AA091924E1652E26B726D177A057B397D30F96F8CB053EC\n562F58515BB55C0F5C115DE2624063836414662D68B36CBC6D886EAF701F70A4\n71D27526758F758E76197B117BE07C2B7D207D39852C856D86078A34900D9061\n90B592B797F69A374FD75C6C675F6D917C9F7E8C8B168D16901F5B6B5DFD640D\n84C0905C98E173875B8B609A677E6DDE8A1F8AA69001980C5237F9707051788E\n9396887091D74FEE53D755FD56DA578258FD5AC25B885CAB5CC05E2561010000\nE2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000620D624B6388641C653665786A396B8A6C346D196F3171E772E973787407\n74B27626776179C07A577AEA7CB97D8F7DAC7E617F9E81298331849084DA85EA\n88968AB08B908F3890429083916C929692B9968B96A796A896D6970098089996\n9AD39B1A53D4587E59195B705BBF6DD16F5A719F742174B9808583FD5DE15F87\n5FAA604265EC6812696F6A536B896D356DF373E376FE77AC7B4D7D148123821C\n834084F485638A628AC49187931E980699B4620C88538FF092655D075D270000\nE3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005D69745F819D87686FD562FE7FD2893689724E1E4E5850E752DD5347627F\n66077E698805965E4F8D5319563659CB5AA45C385C4E5C4D5E025F11604365BD\n662F664267BE67F4731C77E2793A7FC5849484CD89968A668A698AE18C558C7A\n57F45BD45F0F606F62ED690D6B966E5C71847BD287558B588EFE98DF98FE4F38\n4F814FE1547B5A205BB8613C65B0666871FC7533795E7D33814E81E3839885AA\n85CE87038A0A8EAB8F9BF9718FC559315BA45BE660895BE95C0B5FC36C810000\nE4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000F9726DF1700B751A82AF8AF64EC05341F97396D96C0F4E9E4FC45152555E\n5A255CE86211725982BD83AA86FE88598A1D963F96C599139D099D5D580A5CB3\n5DBD5E4460E1611563E16A026E2591029354984E9C109F775B895CB86309664F\n6848773C96C1978D98549B9F65A18B018ECB95BC55355CA95DD65EB56697764C\n83F495C758D362BC72CE9D284EF0592E600F663B6B8379E79D26539354C057C3\n5D16611B66D66DAF788D827E969897445384627C63966DB27E0A814B984D0000\nE5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006AFB7F4C9DAF9E1A4E5F503B51B6591C60F963F66930723A8036F97491CE\n5F31F975F9767D0482E5846F84BB85E58E8DF9774F6FF978F97958E45B436059\n63DA6518656D6698F97A694A6A236D0B7001716C75D2760D79B37A70F97B7F8A\nF97C8944F97D8B9391C0967DF97E990A57045FA165BC6F01760079A68A9E99AD\n9B5A9F6C510461B662916A8D81C6504358305F6671098A008AFA5B7C86164FFA\n513C56B4594463A96DF95DAA696D51864E884F59F97FF980F9815982F9820000\nE6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000F9836B5F6C5DF98474B57916F9858207824583398F3F8F5DF9869918F987\nF988F9894EA6F98A57DF5F796613F98BF98C75AB7E798B6FF98D90069A5B56A5\n582759F85A1F5BB4F98E5EF6F98FF9906350633BF991693D6C876CBF6D8E6D93\n6DF56F14F99270DF71367159F99371C371D5F994784F786FF9957B757DE3F996\n7E2FF997884D8EDFF998F999F99A925BF99B9CF6F99CF99DF99E60856D85F99F\n71B1F9A0F9A195B153ADF9A2F9A3F9A467D3F9A5708E71307430827682D20000\nE7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000F9A695BB9AE59E7D66C4F9A771C18449F9A8F9A9584BF9AAF9AB5DB85F71\nF9AC6620668E697969AE6C386CF36E366F416FDA701B702F715071DF7370F9AD\n745BF9AE74D476C87A4E7E93F9AFF9B082F18A608FCEF9B19348F9B29719F9B3\nF9B44E42502AF9B5520853E166F36C6D6FCA730A777F7A6282AE85DD8602F9B6\n88D48A638B7D8C6BF9B792B3F9B8971398104E944F0D4FC950B25348543E5433\n55DA586258BA59675A1B5BE4609FF9B961CA655665FF666468A76C5A6FB30000\nE8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000070CF71AC73527B7D87088AA49C329F075C4B6C8373447389923A6EAB7465\n761F7A697E15860A514058C564C174EE751576707FC1909596CD99546E2674E6\n7AA97AAA81E586D987788A1B5A495B8C5B9B68A169006D6373A97413742C7897\n7DE97FEB81188155839E8C4C962E981166F05F8065FA67896C6A738B502D5A03\n6B6A77EE59165D6C5DCD7325754FF9BAF9BB50E551F9582F592D599659DA5BE5\nF9BCF9BD5DA262D76416649364FEF9BE66DCF9BF6A48F9C071FF7464F9C10000\nE9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007A887AAF7E477E5E80008170F9C287EF89818B209059F9C390809952617E\n6B326D747E1F89258FB14FD150AD519752C757C758895BB95EB8614269956D8C\n6E676EB6719474627528752C8073833884C98E0A939493DEF9C44E8E4F515076\n512A53C853CB53F35B875BD35C24611A618265F4725B7397744076C279507991\n79B97D067FBD828B85D5865E8FC2904790F591EA968596E896E952D65F6765ED\n6631682F715C7A3690C1980A4E91F9C56A526B9E6F907189801882B885530000\nEA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000904B969596F297FB851A9B314E90718A96C45143539F54E15713571257A3\n5A9B5AC45BC36028613F63F46C856D396E726E907230733F745782D188818F45\n9060F9C6966298589D1B67088D8A925E4F4D504950DE5371570D59D45A015C09\n617066906E2D7232744B7DEF80C3840E8466853F875F885B89188B02905597CB\n9B4F4E734F915112516AF9C7552F55A95B7A5BA55E7C5E7D5EBE60A060DF6108\n610963C465386709F9C867D467DAF9C9696169626CB96D27F9CA6E38F9CB0000\nEB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006FE173367337F9CC745C7531F9CD7652F9CEF9CF7DAD81FE843888D58A98\n8ADB8AED8E308E42904A903E907A914991C9936EF9D0F9D15809F9D26BD38089\n80B2F9D3F9D45141596B5C39F9D5F9D66F6473A780E48D07F9D79217958FF9D8\nF9D9F9DAF9DB807F620E701C7D68878DF9DC57A0606961476BB78ABE928096B1\n4E59541F6DEB852D967097F398EE63D66CE3909151DD61C981BA9DF94F9D501A\n51005B9C610F61FF64EC69056BC5759177E37FA98264858F87FB88638ABC0000\nEC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008B7091AB4E8C4EE54F0AF9DDF9DE593759E8F9DF5DF25F1B5F5B6021F9E0\nF9E1F9E2F9E3723E73E5F9E4757075CDF9E579FBF9E6800C8033808482E18351\nF9E7F9E88CBD8CB39087F9E9F9EA98F4990CF9EBF9EC703776CA7FCA7FCC7FFC\n8B1A4EBA4EC152035370F9ED54BD56E059FB5BC55F155FCD6E6EF9EEF9EF7D6A\n8335F9F086938A8DF9F1976D9777F9F2F9F34E004F5A4F7E58F965E56EA29038\n93B099B94EFB58EC598A59D96041F9F4F9F57A14F9F6834F8CC3516553440000\nED\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000F9F7F9F8F9F94ECD52695B5582BF4ED4523A54A859C959FF5B505B575B5C\n606361486ECB7099716E738674F775B578C17D2B800581EA8328851785C98AEE\n8CC796CC4F5C52FA56BC65AB6628707C70B872357DBD828D914C96C09D725B71\n68E76B986F7A76DE5C9166AB6F5B7BB47C2A883696DC4E084ED75320583458BB\n58EF596C5C075E335E845F35638C66B267566A1F6AA36B0C6F3F7246F9FA7350\n748B7AE07CA7817881DF81E7838A846C8523859485CF88DD8D1391AC95770000\nEE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000969C518D54C957285BB0624D6750683D68936E3D6ED3707D7E2188C18CA1\n8F099F4B9F4E722D7B8F8ACD931A4F474F4E5132548059D05E9562B56775696E\n6A176CAE6E1A72D9732A75BD7BB87D3582E783F9845785F78A5B8CAF8E879019\n90B896CE9F5F52E3540A5AE15BC2645865756EF472C4F9FB76847A4D7B1B7C4D\n7E3E7FDF837B8B2B8CCA8D648DE18E5F8FEA8FF9906993D14F434F7A50B35168\n5178524D526A5861587C59605C085C555EDB609B623068136BBF6C086FB10000\nEF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000714E742075307538755176727B4C7B8B7BAD7BC67E8F8A6E8F3E8F49923F\n92939322942B96FB985A986B991E5207622A62986D5976647ACA7BC07D765360\n5CBE5E976F3870B97C9897119B8E9EDE63A5647A87764E014E954EAD505C5075\n544859C35B9A5E405EAD5EF75F8160C5633A653F657465CC6676667867FE6968\n6A896B636C406DC06DE86E1F6E5E701E70A1738E73FD753A775B7887798E7A0B\n7A7D7CBE7D8E82478A028AEA8C9E912D914A91D8926692CC9320970697560000\nF0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000975C98029F0E52365291557C58245E1D5F1F608C63D068AF6FDF796D7B2C\n81CD85BA88FD8AF88E44918D9664969B973D984C9F4A4FCE514651CB52A95632\n5F145F6B63AA64CD65E9664166FA66F9671D689D68D769FD6F156F6E716771E5\n722A74AA773A7956795A79DF7A207A957C977CDF7D447E70808785FB86A48A54\n8ABF8D998E819020906D91E3963B96D59CE565CF7C078DB393C35B585C0A5352\n62D9731D50275B975F9E60B0616B68D56DD9742E7A2E7D427D9C7E31816B0000\nF1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008E2A8E35937E94184F5057505DE65EA7632B7F6A4E3B4F4F4F8F505A59DD\n80C4546A546855FE594F5B995DDE5EDA665D673167F1682A6CE86D326E4A6F8D\n70B773E075877C4C7D027D2C7DA2821F86DB8A3B8A858D708E8A8F339031914E\n9152944499D07AF97CA54FCA510151C657C85BEF5CFB66596A3D6D5A6E966FEC\n710C756F7AE388229021907596CB99FF83014E2D4EF2884691CD537D6ADB696B\n6C41847A589E618E66FE62EF70DD751175C77E5284B88B498D084E4B53EA0000\nF2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000054AB573057405FD763016307646F652F65E8667A679D67B36B626C606C9A\n6F2C77E57825794979577D1980A2810281F3829D82B787188A8CF9FC8D048DBE\n907276F47A197A377E548077550755D45875632F64226649664B686D699B6B84\n6D256EB173CD746874A1755B75B976E1771E778B79E67E097E1D81FB852F8897\n8A3A8CD18EEB8FB0903293AD9663967397074F8453F159EA5AC95E19684E74C6\n75BE79E97A9281A386ED8CEA8DCC8FED659F6715F9FD57F76F577DDD8F2F0000\nF3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000093F696C65FB561F26F844E144F98501F53C955DF5D6F5DEE6B216B6478CB\n7B9AF9FE8E498ECA906E6349643E77407A84932F947F9F6A64B06FAF71E674A8\n74DA7AC47C127E827CB27E988B9A8D0A947D9910994C52395BDF64E6672D7D2E\n50ED53C358796158615961FA65AC7AD98B928B9650095021527555315A3C5EE0\n5F706134655E660C663666A269CD6EC46F32731676217A938139825983D684BC\n50B557F05BC05BE85F6963A178267DB583DC852191C791F5518A67F57B560000\nF4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008CAC51C459BB60BD8655501CF9FF52545C3A617D621A62D364F265A56ECC\n7620810A8E60965F96BB4EDF5343559859295DDD64C56CC96DFA73947A7F821B\n85A68CE48E10907791E795E1962197C651F854F255865FB964A46F887DB48F1F\n8F4D943550C95C166CBE6DFB751B77BB7C3D7C648A798AC2581E59BE5E166377\n7252758A776B8ADC8CBC8F125EF366746DF8807D83C18ACB97519BD6FA005243\n66FF6D956EEF7DE08AE6902E905E9AD4521D527F54E86194628462DB68A20000\nF5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006912695A6A3570927126785D7901790E79D27A0D8096827882D583498549\n8C828D859162918B91AE4FC356D171ED77D7870089F85BF85FD6675190A853E2\n585A5BF560A4618164607E3D80708525928364AE50AC5D146700589C62BD63A8\n690E69786A1E6E6B76BA79CB82BB84298ACF8DA88FFD9112914B919C93109318\n939A96DB9A369C0D4E11755C795D7AFA7B517BC97E2E84C48E598E748EF89010\n6625693F744351FA672E9EDC51455FE06C9687F2885D887760B481B584030000\nF6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008D0553D6543956345A365C31708A7FE0805A810681ED8DA391899A5F9DF2\n50744EC453A060FB6E2C5C644F88502455E45CD95E5F606568946CBB6DC471BE\n75D475F476617A1A7A497DC77DFB7F6E81F486A98F1C96C999B39F52524752C5\n98ED89AA4E0367D26F064FB55BE267956C886D78741B782791DD937C87C479E4\n7A315FEB4ED654A4553E58AE59A560F0625362D6673669558235964099B199DD\n502C53535544577CFA016258FA0264E2666B67DD6FC16FEF742274388A170000\nF7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000094385451560657665F48619A6B4E705870AD7DBB8A95596A812B63A27708\n803D8CAA5854642D69BB5B955E116E6FFA038569514C53F0592A6020614B6B86\n6C706CF07B1E80CE82D48DC690B098B1FA0464C76FA464916504514E5410571F\n8A0E615F6876FA0575DB7B527D71901A580669CC817F892A9000983950785957\n59AC6295900F9B2A615D727995D657615A465DF4628A64AD64FA67776CE26D3E\n722C743678347F7782AD8DDB981752245742677F724874E38CA98FA692110000\nF8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000962A516B53ED634C4F695504609665576C9B6D7F724C72FD7A1789878C9D\n5F6D6F8E70F981A8610E4FBF504F624172477BC77DE87FE9904D97AD9A198CB6\n576A5E7367B0840D8A5554205B165E635EE25F0A658380BA853D9589965B4F48\n5305530D530F548654FA57035E036016629B62B16355FA066CE16D6675B17832\n80DE812F82DE846184B2888D8912900B92EA98FD9B915E4566B466DD70117206\nFA074FF5527D5F6A615367536A196F0274E2796888688C7998C798C49A430000\nF9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000054C17A1F69538AF78C4A98A899AE5F7C62AB75B276AE88AB907F96425339\n5F3C5FC56CCC73CC7562758B7B4682FE999D4E4F903C4E0B4F5553A6590F5EC8\n66306CB37455837787668CC09050971E9C1558D15B7886508B149DB45BD26068\n608D65F16C576F226FA3701A7F557FF095919592965097D352728F4451FD542B\n54B85563558A6ABB6DB57DD88266929C96779E79540854C876D286E495A495D4\n965C4EA24F0959EE5AE65DF760526297676D68416C866E2F7F38809B822A0000\nFA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000FA08FA0998054EA5505554B35793595A5B695BB361C869776D77702387F9\n89E38A728AE7908299ED9AB852BE683850165E78674F8347884C4EAB541156AE\n73E6911597FF9909995799995653589F865B8A3161B26AF6737B8ED26B4796AA\n9A57595572008D6B97694FD45CF45F2661F8665B6CEB70AB738473B973FE7729\n774D7D437D627E2382378852FA0A8CE29249986F5B517A74884098015ACC4FE0\n5354593E5CFD633E6D7972F98105810783A292CF98304EA851445211578B0000\nFB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005F626CC26ECE7005705070AF719273E97469834A87A28861900890A293A3\n99A8516E5F5760E0616766B385598E4A91AF978B4E4E4E92547C58D558FA597D\n5CB55F2762366248660A66676BEB6D696DCF6E566EF86F946FE06FE9705D72D0\n7425745A74E07693795C7CCA7E1E80E182A6846B84BF864E865F87748B778C6A\n93AC9800986560D1621691775A5A660F6DF76E3E743F9B425FFD60DA7B0F54C4\n5F186C5E6CD36D2A70D87D0586798A0C9D3B5316548C5B056A3A706B75750000\nFC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000798D79BE82B183EF8A718B418CA89774FA0B64F4652B78BA78BB7A6B4E38\n559A59505BA65E7B60A363DB6B61666568536E19716574B07D0890849A699C25\n6D3B6ED1733E8C4195CA51F05E4C5FA8604D60F66130614C6643664469A56CC1\n6E5F6EC96F62714C749C76877BC17C27835287579051968D9EC3532F56DE5EFB\n5F8A6062609461F7666667036A9C6DEE6FAE7070736A7E6A81BE833486D48AA8\n8CC4528373725B966A6B940454EE56865B5D6548658566C9689F6D8D6DC60000\nFD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000723B80B491759A4D4FAF5019539A540E543C558955C55E3F5F8C673D7166\n73DD900552DB52F3586458CE7104718F71FB85B08A13668885A855A76684714A\n8431534955996BC15F595FBD63EE668971478AF18F1D9EBE4F11643A70CB7566\n866760648B4E9DF8514751F653086D3680F89ED166156B23709875D554035C79\n7D078A166B206B3D6B46543860706D3D7FD5820850D651DE559C566B56CD59EC\n5B095E0C619961986231665E66E6719971B971BA72A779A77A007FB28A700000\n",
		"/encoding/cp950.enc":                      "# Encoding file: cp950, multi-byte\nM\n003F 0 88\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n0080008100820083008400850086008700880089008A008B008C008D008E008F\n0090009100920093009400950096009700980099009A009B009C009D009E009F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n3000FF0C30013002FF0E2027FF1BFF1AFF1FFF01FE3020262025FE50FE51FE52\n00B7FE54FE55FE56FE57FF5C2013FE312014FE332574FE34FE4FFF08FF09FE35\nFE36FF5BFF5DFE37FE3830143015FE39FE3A30103011FE3BFE3C300A300BFE3D\nFE3E30083009FE3FFE40300C300DFE41FE42300E300FFE43FE44FE59FE5A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000FE5BFE5CFE5DFE5E20182019201C201D301D301E20352032FF03FF06FF0A\n203B00A7300325CB25CF25B325B225CE2606260525C725C625A125A025BD25BC\n32A3210500AFFFE3FF3F02CDFE49FE4AFE4DFE4EFE4BFE4CFE5FFE60FE61FF0B\nFF0D00D700F700B1221AFF1CFF1EFF1D226622672260221E22522261FE62FE63\nFE64FE65FE66FF5E2229222A22A52220221F22BF33D233D1222B222E22352234\n26402642229522992191219321902192219621972199219822252223FF0F0000\nA2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFF3C2215FE68FF04FFE53012FFE0FFE1FF05FF2021032109FE69FE6AFE6B33D5\n339C339D339E33CE33A1338E338F33C400B05159515B515E515D5161516355E7\n74E97CCE25812582258325842585258625872588258F258E258D258C258B258A\n2589253C2534252C2524251C2594250025022595250C251025142518256D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000256E2570256F2550255E256A256125E225E325E525E4257125722573FF10\nFF11FF12FF13FF14FF15FF16FF17FF18FF192160216121622163216421652166\n216721682169302130223023302430253026302730283029534153445345FF21\nFF22FF23FF24FF25FF26FF27FF28FF29FF2AFF2BFF2CFF2DFF2EFF2FFF30FF31\nFF32FF33FF34FF35FF36FF37FF38FF39FF3AFF41FF42FF43FF44FF45FF46FF47\nFF48FF49FF4AFF4BFF4CFF4DFF4EFF4FFF50FF51FF52FF53FF54FF55FF560000\nA3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFF57FF58FF59FF5A039103920393039403950396039703980399039A039B039C\n039D039E039F03A003A103A303A403A503A603A703A803A903B103B203B303B4\n03B503B603B703B803B903BA03BB03BC03BD03BE03BF03C003C103C303C403C5\n03C603C703C803C931053106310731083109310A310B310C310D310E310F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00003110311131123113311431153116311731183119311A311B311C311D311E\n311F312031213122312331243125312631273128312902D902C902CA02C702CB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000020AC00000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4E004E594E014E034E434E5D4E864E8C4EBA513F5165516B51E052005201529B\n53155341535C53C84E094E0B4E084E0A4E2B4E3851E14E454E484E5F4E5E4E8E\n4EA15140520352FA534353C953E3571F58EB5915592759735B505B515B535BF8\n5C0F5C225C385C715DDD5DE55DF15DF25DF35DFE5E725EFE5F0B5F13624D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004E114E104E0D4E2D4E304E394E4B5C394E884E914E954E924E944EA24EC1\n4EC04EC34EC64EC74ECD4ECA4ECB4EC4514351415167516D516E516C519751F6\n52065207520852FB52FE52FF53165339534853475345535E538453CB53CA53CD\n58EC5929592B592A592D5B545C115C245C3A5C6F5DF45E7B5EFF5F145F155FC3\n62086236624B624E652F6587659765A465B965E566F0670867286B206B626B79\n6BCB6BD46BDB6C0F6C34706B722A7236723B72477259725B72AC738B4E190000\nA5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4E164E154E144E184E3B4E4D4E4F4E4E4EE54ED84ED44ED54ED64ED74EE34EE4\n4ED94EDE514551445189518A51AC51F951FA51F8520A52A0529F530553065317\n531D4EDF534A534953615360536F536E53BB53EF53E453F353EC53EE53E953E8\n53FC53F853F553EB53E653EA53F253F153F053E553ED53FB56DB56DA59160000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000592E5931597459765B555B835C3C5DE85DE75DE65E025E035E735E7C5F01\n5F185F175FC5620A625362546252625165A565E6672E672C672A672B672D6B63\n6BCD6C116C106C386C416C406C3E72AF7384738974DC74E67518751F75287529\n7530753175327533758B767D76AE76BF76EE77DB77E277F3793A79BE7A747ACB\n4E1E4E1F4E524E534E694E994EA44EA64EA54EFF4F094F194F0A4F154F0D4F10\n4F114F0F4EF24EF64EFB4EF04EF34EFD4F014F0B514951475146514851680000\nA6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5171518D51B0521752115212520E521652A3530853215320537053715409540F\n540C540A54105401540B54045411540D54085403540E5406541256E056DE56DD\n573357305728572D572C572F57295919591A59375938598459785983597D5979\n598259815B575B585B875B885B855B895BFA5C165C795DDE5E065E765E740000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005F0F5F1B5FD95FD6620E620C620D62106263625B6258653665E965E865EC\n65ED66F266F36709673D6734673167356B216B646B7B6C166C5D6C576C596C5F\n6C606C506C556C616C5B6C4D6C4E7070725F725D767E7AF97C737CF87F367F8A\n7FBD80018003800C80128033807F8089808B808C81E381EA81F381FC820C821B\n821F826E8272827E866B8840884C8863897F96214E324EA84F4D4F4F4F474F57\n4F5E4F344F5B4F554F304F504F514F3D4F3A4F384F434F544F3C4F464F630000\nA7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4F5C4F604F2F4F4E4F364F594F5D4F484F5A514C514B514D517551B651B75225\n52245229522A522852AB52A952AA52AC532353735375541D542D541E543E5426\n544E542754465443543354485442541B5429544A5439543B5438542E54355436\n5420543C54405431542B541F542C56EA56F056E456EB574A57515740574D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005747574E573E5750574F573B58EF593E599D599259A8599E59A359995996\n598D59A45993598A59A55B5D5B5C5B5A5B5B5B8C5B8B5B8F5C2C5C405C415C3F\n5C3E5C905C915C945C8C5DEB5E0C5E8F5E875E8A5EF75F045F1F5F645F625F77\n5F795FD85FCC5FD75FCD5FF15FEB5FF85FEA6212621162846297629662806276\n6289626D628A627C627E627962736292626F6298626E62956293629162866539\n653B653865F166F4675F674E674F67506751675C6756675E6749674667600000\nA8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n675367576B656BCF6C426C5E6C996C816C886C896C856C9B6C6A6C7A6C906C70\n6C8C6C686C966C926C7D6C836C726C7E6C746C866C766C8D6C946C986C827076\n707C707D707872627261726072C472C27396752C752B75377538768276EF77E3\n79C179C079BF7A767CFB7F5580968093809D8098809B809A80B2826F82920000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000828B828D898B89D28A008C378C468C558C9D8D648D708DB38EAB8ECA8F9B\n8FB08FC28FC68FC58FC45DE1909190A290AA90A690A3914991C691CC9632962E\n9631962A962C4E264E564E734E8B4E9B4E9E4EAB4EAC4F6F4F9D4F8D4F734F7F\n4F6C4F9B4F8B4F864F834F704F754F884F694F7B4F964F7E4F8F4F914F7A5154\n51525155516951775176517851BD51FD523B52385237523A5230522E52365241\n52BE52BB5352535453535351536653775378537953D653D453D7547354750000\nA9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5496547854955480547B5477548454925486547C549054715476548C549A5462\n5468548B547D548E56FA57835777576A5769576157665764577C591C59495947\n59485944595459BE59BB59D459B959AE59D159C659D059CD59CB59D359CA59AF\n59B359D259C55B5F5B645B635B975B9A5B985B9C5B995B9B5C1A5C485C450000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005C465CB75CA15CB85CA95CAB5CB15CB35E185E1A5E165E155E1B5E115E78\n5E9A5E975E9C5E955E965EF65F265F275F295F805F815F7F5F7C5FDD5FE05FFD\n5FF55FFF600F6014602F60356016602A6015602160276029602B601B62166215\n623F623E6240627F62C962CC62C462BF62C262B962D262DB62AB62D362D462CB\n62C862A862BD62BC62D062D962C762CD62B562DA62B162D862D662D762C662AC\n62CE653E65A765BC65FA66146613660C66066602660E6600660F6615660A0000\nAA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6607670D670B676D678B67956771679C677367776787679D6797676F6770677F\n6789677E67906775679A6793677C676A67726B236B666B676B7F6C136C1B6CE3\n6CE86CF36CB16CCC6CE56CB36CBD6CBE6CBC6CE26CAB6CD56CD36CB86CC46CB9\n6CC16CAE6CD76CC56CF16CBF6CBB6CE16CDB6CCA6CAC6CEF6CDC6CD66CE00000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007095708E7092708A7099722C722D723872487267726972C072CE72D972D7\n72D073A973A8739F73AB73A5753D759D7599759A768476C276F276F477E577FD\n793E7940794179C979C87A7A7A797AFA7CFE7F547F8C7F8B800580BA80A580A2\n80B180A180AB80A980B480AA80AF81E581FE820D82B3829D829982AD82BD829F\n82B982B182AC82A582AF82B882A382B082BE82B7864E8671521D88688ECB8FCE\n8FD48FD190B590B890B190B691C791D195779580961C9640963F963B96440000\nAB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n964296B996E89752975E4E9F4EAD4EAE4FE14FB54FAF4FBF4FE04FD14FCF4FDD\n4FC34FB64FD84FDF4FCA4FD74FAE4FD04FC44FC24FDA4FCE4FDE4FB751575192\n519151A0524E5243524A524D524C524B524752C752C952C352C1530D5357537B\n539A53DB54AC54C054A854CE54C954B854A654B354C754C254BD54AA54C10000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000054C454C854AF54AB54B154BB54A954A754BF56FF5782578B57A057A357A2\n57CE57AE579359555951594F594E595059DC59D859FF59E359E85A0359E559EA\n59DA59E65A0159FB5B695BA35BA65BA45BA25BA55C015C4E5C4F5C4D5C4B5CD9\n5CD25DF75E1D5E255E1F5E7D5EA05EA65EFA5F085F2D5F655F885F855F8A5F8B\n5F875F8C5F896012601D60206025600E6028604D60706068606260466043606C\n606B606A6064624162DC6316630962FC62ED630162EE62FD630762F162F70000\nAC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n62EF62EC62FE62F463116302653F654565AB65BD65E26625662D66206627662F\n661F66286631662466F767FF67D367F167D467D067EC67B667AF67F567E967EF\n67C467D167B467DA67E567B867CF67DE67F367B067D967E267DD67D26B6A6B83\n6B866BB56BD26BD76C1F6CC96D0B6D326D2A6D416D256D0C6D316D1E6D170000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006D3B6D3D6D3E6D366D1B6CF56D396D276D386D296D2E6D356D0E6D2B70AB\n70BA70B370AC70AF70AD70B870AE70A472307272726F727472E972E072E173B7\n73CA73BB73B273CD73C073B3751A752D754F754C754E754B75AB75A475A575A2\n75A3767876867687768876C876C676C376C5770176F976F87709770B76FE76FC\n770777DC78027814780C780D794679497948794779B979BA79D179D279CB7A7F\n7A817AFF7AFD7C7D7D027D057D007D097D077D047D067F387F8E7FBF80040000\nAD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8010800D8011803680D680E580DA80C380C480CC80E180DB80CE80DE80E480DD\n81F4822282E78303830582E382DB82E6830482E58302830982D282D782F18301\n82DC82D482D182DE82D382DF82EF830686508679867B867A884D886B898189D4\n8A088A028A038C9E8CA08D748D738DB48ECD8ECC8FF08FE68FE28FEA8FE50000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008FED8FEB8FE48FE890CA90CE90C190C3914B914A91CD95829650964B964C\n964D9762976997CB97ED97F3980198A898DB98DF999699994E584EB3500C500D\n50234FEF502650254FF8502950165006503C501F501A501250114FFA50005014\n50284FF15021500B501950184FF34FEE502D502A4FFE502B5009517C51A451A5\n51A251CD51CC51C651CB5256525C5254525B525D532A537F539F539D53DF54E8\n55105501553754FC54E554F2550654FA551454E954ED54E1550954EE54EA0000\nAE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n54E65527550754FD550F5703570457C257D457CB57C35809590F59575958595A\n5A115A185A1C5A1F5A1B5A1359EC5A205A235A295A255A0C5A095B6B5C585BB0\n5BB35BB65BB45BAE5BB55BB95BB85C045C515C555C505CED5CFD5CFB5CEA5CE8\n5CF05CF65D015CF45DEE5E2D5E2B5EAB5EAD5EA75F315F925F915F9060590000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006063606560506055606D6069606F6084609F609A608D6094608C60856096\n624762F3630862FF634E633E632F635563426346634F6349633A6350633D632A\n632B6328634D634C65486549659965C165C566426649664F66436652664C6645\n664166F867146715671768216838684868466853683968426854682968B36817\n684C6851683D67F468506840683C6843682A68456813681868416B8A6B896BB7\n6C236C276C286C266C246CF06D6A6D956D886D876D666D786D776D596D930000\nAF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6D6C6D896D6E6D5A6D746D696D8C6D8A6D796D856D656D9470CA70D870E470D9\n70C870CF7239727972FC72F972FD72F872F7738673ED740973EE73E073EA73DE\n7554755D755C755A755975BE75C575C775B275B375BD75BC75B975C275B8768B\n76B076CA76CD76CE7729771F7720772877E9783078277838781D783478370000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007825782D7820781F7832795579507960795F7956795E795D7957795A79E4\n79E379E779DF79E679E979D87A847A887AD97B067B117C897D217D177D0B7D0A\n7D207D227D147D107D157D1A7D1C7D0D7D197D1B7F3A7F5F7F947FC57FC18006\n8018801580198017803D803F80F1810280F0810580ED80F4810680F880F38108\n80FD810A80FC80EF81ED81EC82008210822A822B8228822C82BB832B83528354\n834A83388350834983358334834F833283398336831783408331832883430000\nB0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8654868A86AA869386A486A9868C86A3869C8870887788818882887D88798A18\n8A108A0E8A0C8A158A0A8A178A138A168A0F8A118C488C7A8C798CA18CA28D77\n8EAC8ED28ED48ECF8FB1900190068FF790008FFA8FF490038FFD90058FF89095\n90E190DD90E29152914D914C91D891DD91D791DC91D995839662966396610000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000965B965D96649658965E96BB98E299AC9AA89AD89B259B329B3C4E7E507A\n507D505C50475043504C505A504950655076504E5055507550745077504F500F\n506F506D515C519551F0526A526F52D252D952D852D55310530F5319533F5340\n533E53C366FC5546556A55665544555E55615543554A55315556554F5555552F\n55645538552E555C552C55635533554155575708570B570957DF5805580A5806\n57E057E457FA5802583557F757F9592059625A365A415A495A665A6A5A400000\nB1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5A3C5A625A5A5A465A4A5B705BC75BC55BC45BC25BBF5BC65C095C085C075C60\n5C5C5C5D5D075D065D0E5D1B5D165D225D115D295D145D195D245D275D175DE2\n5E385E365E335E375EB75EB85EB65EB55EBE5F355F375F575F6C5F695F6B5F97\n5F995F9E5F985FA15FA05F9C607F60A3608960A060A860CB60B460E660BD0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000060C560BB60B560DC60BC60D860D560C660DF60B860DA60C7621A621B6248\n63A063A76372639663A263A563776367639863AA637163A963896383639B636B\n63A863846388639963A163AC6392638F6380637B63696368637A655D65566551\n65596557555F654F655865556554659C659B65AC65CF65CB65CC65CE665D665A\n666466686666665E66F952D7671B688168AF68A2689368B5687F687668B168A7\n689768B0688368C468AD688668856894689D68A8689F68A168826B326BBA0000\nB2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6BEB6BEC6C2B6D8E6DBC6DF36DD96DB26DE16DCC6DE46DFB6DFA6E056DC76DCB\n6DAF6DD16DAE6DDE6DF96DB86DF76DF56DC56DD26E1A6DB56DDA6DEB6DD86DEA\n6DF16DEE6DE86DC66DC46DAA6DEC6DBF6DE670F97109710A70FD70EF723D727D\n7281731C731B73167313731973877405740A7403740673FE740D74E074F60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000074F7751C75227565756675627570758F75D475D575B575CA75CD768E76D4\n76D276DB7737773E773C77367738773A786B7843784E79657968796D79FB7A92\n7A957B207B287B1B7B2C7B267B197B1E7B2E7C927C977C957D467D437D717D2E\n7D397D3C7D407D307D337D447D2F7D427D327D317F3D7F9E7F9A7FCC7FCE7FD2\n801C804A8046812F81168123812B81298130812482028235823782368239838E\n839E8398837883A2839683BD83AB8392838A8393838983A08377837B837C0000\nB3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n838683A786555F6A86C786C086B686C486B586C686CB86B186AF86C98853889E\n888888AB88928896888D888B8993898F8A2A8A1D8A238A258A318A2D8A1F8A1B\n8A228C498C5A8CA98CAC8CAB8CA88CAA8CA78D678D668DBE8DBA8EDB8EDF9019\n900D901A90179023901F901D90109015901E9020900F90229016901B90140000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000090E890ED90FD915791CE91F591E691E391E791ED91E99589966A96759673\n96789670967496769677966C96C096EA96E97AE07ADF980298039B5A9CE59E75\n9E7F9EA59EBB50A2508D508550995091508050965098509A670051F152725274\n5275526952DE52DD52DB535A53A5557B558055A7557C558A559D55985582559C\n55AA55945587558B558355B355AE559F553E55B2559A55BB55AC55B1557E5589\n55AB5599570D582F582A58345824583058315821581D582058F958FA59600000\nB4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5A775A9A5A7F5A925A9B5AA75B735B715BD25BCC5BD35BD05C0A5C0B5C315D4C\n5D505D345D475DFD5E455E3D5E405E435E7E5ECA5EC15EC25EC45F3C5F6D5FA9\n5FAA5FA860D160E160B260B660E0611C612360FA611560F060FB60F4616860F1\n610E60F6610961006112621F624963A3638C63CF63C063E963C963C663CD0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000063D263E363D063E163D663ED63EE637663F463EA63DB645263DA63F9655E\n6566656265636591659065AF666E667066746676666F6691667A667E667766FE\n66FF671F671D68FA68D568E068D868D7690568DF68F568EE68E768F968D268F2\n68E368CB68CD690D6912690E68C968DA696E68FB6B3E6B3A6B3D6B986B966BBC\n6BEF6C2E6C2F6C2C6E2F6E386E546E216E326E676E4A6E206E256E236E1B6E5B\n6E586E246E566E6E6E2D6E266E6F6E346E4D6E3A6E2C6E436E1D6E3E6ECB0000\nB5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6E896E196E4E6E636E446E726E696E5F7119711A7126713071217136716E711C\n724C728472807336732573347329743A742A743374227425743574367434742F\n741B7426742875257526756B756A75E275DB75E375D975D875DE75E0767B767C\n7696769376B476DC774F77ED785D786C786F7A0D7A087A0B7A057A007A980000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007A977A967AE57AE37B497B567B467B507B527B547B4D7B4B7B4F7B517C9F\n7CA57D5E7D507D687D557D2B7D6E7D727D617D667D627D707D7355847FD47FD5\n800B8052808581558154814B8151814E81398146813E814C815381748212821C\n83E9840383F8840D83E083C5840B83C183EF83F183F48457840A83F0840C83CC\n83FD83F283CA8438840E840483DC840783D483DF865B86DF86D986ED86D486DB\n86E486D086DE885788C188C288B1898389968A3B8A608A558A5E8A3C8A410000\nB6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8A548A5B8A508A468A348A3A8A368A568C618C828CAF8CBC8CB38CBD8CC18CBB\n8CC08CB48CB78CB68CBF8CB88D8A8D858D818DCE8DDD8DCB8DDA8DD18DCC8DDB\n8DC68EFB8EF88EFC8F9C902E90359031903890329036910290F5910990FE9163\n916591CF9214921592239209921E920D9210920792119594958F958B95910000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000095939592958E968A968E968B967D96859686968D9672968496C196C596C4\n96C696C796EF96F297CC98059806980898E798EA98EF98E998F298ED99AE99AD\n9EC39ECD9ED14E8250AD50B550B250B350C550BE50AC50B750BB50AF50C7527F\n5277527D52DF52E652E452E252E3532F55DF55E855D355E655CE55DC55C755D1\n55E355E455EF55DA55E155C555C655E555C957125713585E585158585857585A\n5854586B584C586D584A58625852584B59675AC15AC95ACC5ABE5ABD5ABC0000\nB7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5AB35AC25AB25D695D6F5E4C5E795EC95EC85F125F595FAC5FAE611A610F6148\n611F60F3611B60F961016108614E614C6144614D613E61346127610D61066137\n622162226413643E641E642A642D643D642C640F641C6414640D643664166417\n6406656C659F65B06697668966876688669666846698668D67036994696D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000695A697769606954697569306982694A6968696B695E695369796986695D\n6963695B6B476B726BC06BBF6BD36BFD6EA26EAF6ED36EB66EC26E906E9D6EC7\n6EC56EA56E986EBC6EBA6EAB6ED16E966E9C6EC46ED46EAA6EA76EB4714E7159\n7169716471497167715C716C7166714C7165715E714671687156723A72527337\n7345733F733E746F745A7455745F745E7441743F7459745B745C757675787600\n75F0760175F275F175FA75FF75F475F376DE76DF775B776B7766775E77630000\nB8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7779776A776C775C77657768776277EE788E78B078977898788C7889787C7891\n7893787F797A797F7981842C79BD7A1C7A1A7A207A147A1F7A1E7A9F7AA07B77\n7BC07B607B6E7B677CB17CB37CB57D937D797D917D817D8F7D5B7F6E7F697F6A\n7F727FA97FA87FA480568058808680848171817081788165816E8173816B0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008179817A81668205824784828477843D843184758466846B8449846C845B\n843C8435846184638469846D8446865E865C865F86F9871387088707870086FE\n86FB870287038706870A885988DF88D488D988DC88D888DD88E188CA88D588D2\n899C89E38A6B8A728A738A668A698A708A878A7C8A638AA08A718A858A6D8A62\n8A6E8A6C8A798A7B8A3E8A688C628C8A8C898CCA8CC78CC88CC48CB28CC38CC2\n8CC58DE18DDF8DE88DEF8DF38DFA8DEA8DE48DE68EB28F038F098EFE8F0A0000\nB9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8F9F8FB2904B904A905390429054903C905590509047904F904E904D9051903E\n904191129117916C916A916991C9923792579238923D9240923E925B924B9264\n925192349249924D92459239923F925A959896989694969596CD96CB96C996CA\n96F796FB96F996F6975697749776981098119813980A9812980C98FC98F40000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000098FD98FE99B399B199B49AE19CE99E829F0E9F139F2050E750EE50E550D6\n50ED50DA50D550CF50D150F150CE50E9516251F352835282533153AD55FE5600\n561B561755FD561456065609560D560E55F75616561F5608561055F657185716\n5875587E58835893588A58795885587D58FD592559225924596A59695AE15AE6\n5AE95AD75AD65AD85AE35B755BDE5BE75BE15BE55BE65BE85BE25BE45BDF5C0D\n5C625D845D875E5B5E635E555E575E545ED35ED65F0A5F465F705FB961470000\nBA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n613F614B617761626163615F615A61586175622A64876458645464A46478645F\n647A645164676434646D647B657265A165D765D666A266A8669D699C69A86995\n69C169AE69D369CB699B69B769BB69AB69B469D069CD69AD69CC69A669C369A3\n6B496B4C6C336F336F146EFE6F136EF46F296F3E6F206F2C6F0F6F026F220000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006EFF6EEF6F066F316F386F326F236F156F2B6F2F6F886F2A6EEC6F016EF2\n6ECC6EF771947199717D718A71847192723E729272967344735074647463746A\n7470746D750475917627760D760B7609761376E176E37784777D777F776178C1\n789F78A778B378A978A3798E798F798D7A2E7A317AAA7AA97AED7AEF7BA17B95\n7B8B7B757B977B9D7B947B8F7BB87B877B847CB97CBD7CBE7DBB7DB07D9C7DBD\n7DBE7DA07DCA7DB47DB27DB17DBA7DA27DBF7DB57DB87DAD7DD27DC77DAC0000\nBB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7F707FE07FE17FDF805E805A808781508180818F8188818A817F818281E781FA\n82078214821E824B84C984BF84C684C48499849E84B2849C84CB84B884C084D3\n849084BC84D184CA873F871C873B872287258734871887558737872988F38902\n88F488F988F888FD88E8891A88EF8AA68A8C8A9E8AA38A8D8AA18A938AA40000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008AAA8AA58AA88A988A918A9A8AA78C6A8C8D8C8C8CD38CD18CD28D6B8D99\n8D958DFC8F148F128F158F138FA390609058905C90639059905E9062905D905B\n91199118911E917591789177917492789280928592989296927B9293929C92A8\n927C929195A195A895A995A395A595A49699969C969B96CC96D29700977C9785\n97F69817981898AF98B199039905990C990999C19AAF9AB09AE69B419B429CF4\n9CF69CF39EBC9F3B9F4A5104510050FB50F550F9510251085109510551DC0000\nBC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n528752885289528D528A52F053B2562E563B56395632563F563456295653564E\n565756745636562F56305880589F589E58B3589C58AE58A958A6596D5B095AFB\n5B0B5AF55B0C5B085BEE5BEC5BE95BEB5C645C655D9D5D945E625E5F5E615EE2\n5EDA5EDF5EDD5EE35EE05F485F715FB75FB561766167616E615D615561820000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000617C6170616B617E61A7619061AB618E61AC619A61A4619461AE622E6469\n646F6479649E64B26488649064B064A56493649564A9649264AE64AD64AB649A\n64AC649964A264B365756577657866AE66AB66B466B16A236A1F69E86A016A1E\n6A1969FD6A216A136A0A69F36A026A0569ED6A116B506B4E6BA46BC56BC66F3F\n6F7C6F846F516F666F546F866F6D6F5B6F786F6E6F8E6F7A6F706F646F976F58\n6ED56F6F6F606F5F719F71AC71B171A87256729B734E73577469748B74830000\nBD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n747E7480757F76207629761F7624762676217622769A76BA76E4778E7787778C\n7791778B78CB78C578BA78CA78BE78D578BC78D07A3F7A3C7A407A3D7A377A3B\n7AAF7AAE7BAD7BB17BC47BB47BC67BC77BC17BA07BCC7CCA7DE07DF47DEF7DFB\n7DD87DEC7DDD7DE87DE37DDA7DDE7DE97D9E7DD97DF27DF97F757F777FAF0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007FE98026819B819C819D81A0819A81988517853D851A84EE852C852D8513\n851185238521851484EC852584FF850687828774877687608766877887688759\n8757874C8753885B885D89108907891289138915890A8ABC8AD28AC78AC48A95\n8ACB8AF88AB28AC98AC28ABF8AB08AD68ACD8AB68AB98ADB8C4C8C4E8C6C8CE0\n8CDE8CE68CE48CEC8CED8CE28CE38CDC8CEA8CE18D6D8D9F8DA38E2B8E108E1D\n8E228E0F8E298E1F8E218E1E8EBA8F1D8F1B8F1F8F298F268F2A8F1C8F1E0000\nBE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8F259069906E9068906D90779130912D9127913191879189918B918392C592BB\n92B792EA92AC92E492C192B392BC92D292C792F092B295AD95B1970497069707\n97099760978D978B978F9821982B981C98B3990A99139912991899DD99D099DF\n99DB99D199D599D299D99AB79AEE9AEF9B279B459B449B779B6F9D069D090000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009D039EA99EBE9ECE58A89F5251125118511451105115518051AA51DD5291\n529352F35659566B5679566956645678566A566856655671566F566C56625676\n58C158BE58C758C5596E5B1D5B345B785BF05C0E5F4A61B2619161A9618A61CD\n61B661BE61CA61C8623064C564C164CB64BB64BC64DA64C464C764C264CD64BF\n64D264D464BE657466C666C966B966C466C766B86A3D6A386A3A6A596A6B6A58\n6A396A446A626A616A4B6A476A356A5F6A486B596B776C056FC26FB16FA10000\nBF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6FC36FA46FC16FA76FB36FC06FB96FB66FA66FA06FB471BE71C971D071D271C8\n71D571B971CE71D971DC71C371C47368749C74A37498749F749E74E2750C750D\n76347638763A76E776E577A0779E779F77A578E878DA78EC78E779A67A4D7A4E\n7A467A4C7A4B7ABA7BD97C117BC97BE47BDB7BE17BE97BE67CD57CD67E0A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007E117E087E1B7E237E1E7E1D7E097E107F797FB27FF07FF17FEE802881B3\n81A981A881FB820882588259854A855985488568856985438549856D856A855E\n8783879F879E87A2878D8861892A89328925892B892189AA89A68AE68AFA8AEB\n8AF18B008ADC8AE78AEE8AFE8B018B028AF78AED8AF38AF68AFC8C6B8C6D8C93\n8CF48E448E318E348E428E398E358F3B8F2F8F388F338FA88FA6907590749078\n9072907C907A913491929320933692F89333932F932292FC932B9304931A0000\nC0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9310932693219315932E931995BB96A796A896AA96D5970E97119716970D9713\n970F975B975C9766979898309838983B9837982D9839982499109928991E991B\n9921991A99ED99E299F19AB89ABC9AFB9AED9B289B919D159D239D269D289D12\n9D1B9ED89ED49F8D9F9C512A511F5121513252F5568E56805690568556870000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000568F58D558D358D158CE5B305B2A5B245B7A5C375C685DBC5DBA5DBD5DB8\n5E6B5F4C5FBD61C961C261C761E661CB6232623464CE64CA64D864E064F064E6\n64EC64F164E264ED6582658366D966D66A806A946A846AA26A9C6ADB6AA36A7E\n6A976A906AA06B5C6BAE6BDA6C086FD86FF16FDF6FE06FDB6FE46FEB6FEF6F80\n6FEC6FE16FE96FD56FEE6FF071E771DF71EE71E671E571ED71EC71F471E07235\n72467370737274A974B074A674A876467642764C76EA77B377AA77B077AC0000\nC1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n77A777AD77EF78F778FA78F478EF790179A779AA7A577ABF7C077C0D7BFE7BF7\n7C0C7BE07CE07CDC7CDE7CE27CDF7CD97CDD7E2E7E3E7E467E377E327E437E2B\n7E3D7E317E457E417E347E397E487E357E3F7E2F7F447FF37FFC807180728070\n806F807381C681C381BA81C281C081BF81BD81C981BE81E88209827185AA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008584857E859C8591859485AF859B858785A8858A866787C087D187B387D2\n87C687AB87BB87BA87C887CB893B893689448938893D89AC8B0E8B178B198B1B\n8B0A8B208B1D8B048B108C418C3F8C738CFA8CFD8CFC8CF88CFB8DA88E498E4B\n8E488E4A8F448F3E8F428F458F3F907F907D9084908190829080913991A3919E\n919C934D938293289375934A9365934B9318937E936C935B9370935A935495CA\n95CB95CC95C895C696B196B896D6971C971E97A097D3984698B699359A010000\nC2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n99FF9BAE9BAB9BAA9BAD9D3B9D3F9E8B9ECF9EDE9EDC9EDD9EDB9F3E9F4B53E2\n569556AE58D958D85B385F5D61E3623364F464F264FE650664FA64FB64F765B7\n66DC67266AB36AAC6AC36ABB6AB86AC26AAE6AAF6B5F6B786BAF7009700B6FFE\n70066FFA7011700F71FB71FC71FE71F87377737574A774BF7515765676580000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000765277BD77BF77BB77BC790E79AE7A617A627A607AC47AC57C2B7C277C2A\n7C1E7C237C217CE77E547E557E5E7E5A7E617E527E597F487FF97FFB80778076\n81CD81CF820A85CF85A985CD85D085C985B085BA85B985A687EF87EC87F287E0\n898689B289F48B288B398B2C8B2B8C508D058E598E638E668E648E5F8E558EC0\n8F498F4D90879083908891AB91AC91D09394938A939693A293B393AE93AC93B0\n9398939A939795D495D695D095D596E296DC96D996DB96DE972497A397A60000\nC3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n97AD97F9984D984F984C984E985398BA993E993F993D992E99A59A0E9AC19B03\n9B069B4F9B4E9B4D9BCA9BC99BFD9BC89BC09D519D5D9D609EE09F159F2C5133\n56A558DE58DF58E25BF59F905EEC61F261F761F661F56500650F66E066DD6AE5\n6ADD6ADA6AD3701B701F7028701A701D701570187206720D725872A273780000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000737A74BD74CA74E375877586765F766177C7791979B17A6B7A697C3E7C3F\n7C387C3D7C377C407E6B7E6D7E797E697E6A7F857E737FB67FB97FB881D885E9\n85DD85EA85D585E485E585F787FB8805880D87F987FE8960895F8956895E8B41\n8B5C8B588B498B5A8B4E8B4F8B468B598D088D0A8E7C8E728E878E768E6C8E7A\n8E748F548F4E8FAD908A908B91B191AE93E193D193DF93C393C893DC93DD93D6\n93E293CD93D893E493D793E895DC96B496E3972A9727976197DC97FB985E0000\nC4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n9858985B98BC994599499A169A199B0D9BE89BE79BD69BDB9D899D619D729D6A\n9D6C9E929E979E939EB452F856A856B756B656B456BC58E45B405B435B7D5BF6\n5DC961F861FA65186514651966E667276AEC703E703070327210737B74CF7662\n76657926792A792C792B7AC77AF67C4C7C437C4D7CEF7CF08FAE7E7D7E7C0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007E827F4C800081DA826685FB85F9861185FA8606860B8607860A88148815\n896489BA89F88B708B6C8B668B6F8B5F8B6B8D0F8D0D8E898E818E858E8291B4\n91CB9418940393FD95E1973098C49952995199A89A2B9A309A379A359C139C0D\n9E799EB59EE89F2F9F5F9F639F615137513856C156C056C259145C6C5DCD61FC\n61FE651D651C659566E96AFB6B046AFA6BB2704C721B72A774D674D4766977D3\n7C507E8F7E8C7FBC8617862D861A882388228821881F896A896C89BD8B740000\nC5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8B778B7D8D138E8A8E8D8E8B8F5F8FAF91BA942E94339435943A94389432942B\n95E297389739973297FF9867986599579A459A439A409A3E9ACF9B549B519C2D\n9C259DAF9DB49DC29DB89E9D9EEF9F199F5C9F669F67513C513B56C856CA56C9\n5B7F5DD45DD25F4E61FF65246B0A6B6170517058738074E4758A766E766C0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000079B37C607C5F807E807D81DF8972896F89FC8B808D168D178E918E938F61\n9148944494519452973D973E97C397C1986B99559A559A4D9AD29B1A9C499C31\n9C3E9C3B9DD39DD79F349F6C9F6A9F9456CC5DD662006523652B652A66EC6B10\n74DA7ACA7C647C637C657E937E967E9481E28638863F88318B8A9090908F9463\n946094649768986F995C9A5A9A5B9A579AD39AD49AD19C549C579C569DE59E9F\n9EF456D158E9652C705E7671767277D77F507F888836883988628B938B920000\nC6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8B9682778D1B91C0946A97429748974497C698709A5F9B229B589C5F9DF99DFA\n9E7C9E7D9F079F779F725EF36B1670637C6C7C6E883B89C08EA191C194729470\n9871995E9AD69B239ECC706477DA8B9A947797C99A629A657E9C8B9C8EAA91C5\n947D947E947C9C779C789EF78C54947F9E1A72289A6A9B319E1B9E1E7C720000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nC9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n4E424E5C51F5531A53824E074E0C4E474E8D56D7FA0C5C6E5F734E0F51874E0E\n4E2E4E934EC24EC94EC8519852FC536C53B957205903592C5C105DFF65E16BB3\n6BCC6C14723F4E314E3C4EE84EDC4EE94EE14EDD4EDA520C531C534C57225723\n5917592F5B815B845C125C3B5C745C735E045E805E825FC9620962506C150000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006C366C436C3F6C3B72AE72B0738A79B8808A961E4F0E4F184F2C4EF54F14\n4EF14F004EF74F084F1D4F024F054F224F134F044EF44F1251B1521352095210\n52A65322531F534D538A540756E156DF572E572A5734593C5980597C5985597B\n597E5977597F5B565C155C255C7C5C7A5C7B5C7E5DDF5E755E845F025F1A5F74\n5FD55FD45FCF625C625E626462616266626262596260625A626565EF65EE673E\n67396738673B673A673F673C67336C186C466C526C5C6C4F6C4A6C546C4B0000\nCA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6C4C7071725E72B472B5738E752A767F7A757F518278827C8280827D827F864D\n897E909990979098909B909496229624962096234F564F3B4F624F494F534F64\n4F3E4F674F524F5F4F414F584F2D4F334F3F4F61518F51B9521C521E522152AD\n52AE530953635372538E538F54305437542A545454455419541C542554180000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000543D544F544154285424544756EE56E756E557415745574C5749574B5752\n5906594059A6599859A05997598E59A25990598F59A759A15B8E5B925C285C2A\n5C8D5C8F5C885C8B5C895C925C8A5C865C935C955DE05E0A5E0E5E8B5E895E8C\n5E885E8D5F055F1D5F785F765FD25FD15FD05FED5FE85FEE5FF35FE15FE45FE3\n5FFA5FEF5FF75FFB60005FF4623A6283628C628E628F629462876271627B627A\n6270628162886277627D62726274653765F065F465F365F265F5674567470000\nCB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n67596755674C6748675D674D675A674B6BD06C196C1A6C786C676C6B6C846C8B\n6C8F6C716C6F6C696C9A6C6D6C876C956C9C6C666C736C656C7B6C8E7074707A\n726372BF72BD72C372C672C172BA72C573957397739373947392753A75397594\n75957681793D80348095809980908092809C8290828F8285828E829182930000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000828A828382848C788FC98FBF909F90A190A5909E90A790A096309628962F\n962D4E334F984F7C4F854F7D4F804F874F764F744F894F844F774F4C4F974F6A\n4F9A4F794F814F784F904F9C4F944F9E4F924F824F954F6B4F6E519E51BC51BE\n5235523252335246523152BC530A530B533C539253945487547F548154915482\n5488546B547A547E5465546C54745466548D546F546154605498546354675464\n56F756F9576F5772576D576B57715770577657805775577B5773577457620000\nCC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5768577D590C594559B559BA59CF59CE59B259CC59C159B659BC59C359D659B1\n59BD59C059C859B459C75B625B655B935B955C445C475CAE5CA45CA05CB55CAF\n5CA85CAC5C9F5CA35CAD5CA25CAA5CA75C9D5CA55CB65CB05CA65E175E145E19\n5F285F225F235F245F545F825F7E5F7D5FDE5FE5602D602660196032600B0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006034600A60176033601A601E602C6022600D6010602E60136011600C6009\n601C6214623D62AD62B462D162BE62AA62B662CA62AE62B362AF62BB62A962B0\n62B8653D65A865BB660965FC66046612660865FB6603660B660D660565FD6611\n661066F6670A6785676C678E67926776677B6798678667846774678D678C677A\n679F679167996783677D67816778677967946B256B806B7E6BDE6C1D6C936CEC\n6CEB6CEE6CD96CB66CD46CAD6CE76CB76CD06CC26CBA6CC36CC66CED6CF20000\nCD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6CD26CDD6CB46C8A6C9D6C806CDE6CC06D306CCD6CC76CB06CF96CCF6CE96CD1\n709470987085709370867084709170967082709A7083726A72D672CB72D872C9\n72DC72D272D472DA72CC72D173A473A173AD73A673A273A073AC739D74DD74E8\n753F7540753E758C759876AF76F376F176F076F577F877FC77F977FB77FA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000077F77942793F79C57A787A7B7AFB7C757CFD8035808F80AE80A380B880B5\n80AD822082A082C082AB829A8298829B82B582A782AE82BC829E82BA82B482A8\n82A182A982C282A482C382B682A28670866F866D866E8C568FD28FCB8FD38FCD\n8FD68FD58FD790B290B490AF90B390B09639963D963C963A96434FCD4FC54FD3\n4FB24FC94FCB4FC14FD44FDC4FD94FBB4FB34FDB4FC74FD64FBA4FC04FB94FEC\n5244524952C052C2533D537C539753965399539854BA54A154AD54A554CF0000\nCE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n54C3830D54B754AE54D654B654C554C654A0547054BC54A254BE547254DE54B0\n57B5579E579F57A4578C5797579D579B57945798578F579957A5579A579558F4\n590D595359E159DE59EE5A0059F159DD59FA59FD59FC59F659E459F259F759DB\n59E959F359F559E059FE59F459ED5BA85C4C5CD05CD85CCC5CD75CCB5CDB0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005CDE5CDA5CC95CC75CCA5CD65CD35CD45CCF5CC85CC65CCE5CDF5CF85DF9\n5E215E225E235E205E245EB05EA45EA25E9B5EA35EA55F075F2E5F565F866037\n603960546072605E6045605360476049605B604C60406042605F602460446058\n6066606E6242624362CF630D630B62F5630E630362EB62F9630F630C62F862F6\n63006313631462FA631562FB62F06541654365AA65BF6636662166326635661C\n662666226633662B663A661D66346639662E670F671067C167F267C867BA0000\nCF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n67DC67BB67F867D867C067B767C567EB67E467DF67B567CD67B367F767F667EE\n67E367C267B967CE67E767F067B267FC67C667ED67CC67AE67E667DB67FA67C9\n67CA67C367EA67CB6B286B826B846BB66BD66BD86BE06C206C216D286D346D2D\n6D1F6D3C6D3F6D126D0A6CDA6D336D046D196D3A6D1A6D116D006D1D6D420000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006D016D186D376D036D0F6D406D076D206D2C6D086D226D096D1070B7709F\n70BE70B170B070A170B470B570A972417249724A726C72707273726E72CA72E4\n72E872EB72DF72EA72E672E3738573CC73C273C873C573B973B673B573B473EB\n73BF73C773BE73C373C673B873CB74EC74EE752E7547754875A775AA767976C4\n7708770377047705770A76F776FB76FA77E777E878067811781278057810780F\n780E780978037813794A794C794B7945794479D579CD79CF79D679CE7A800000\nD0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7A7E7AD17B007B017C7A7C787C797C7F7C807C817D037D087D017F587F917F8D\n7FBE8007800E800F8014803780D880C780E080D180C880C280D080C580E380D9\n80DC80CA80D580C980CF80D780E680CD81FF8221829482D982FE82F9830782E8\n830082D5833A82EB82D682F482EC82E182F282F5830C82FB82F682F082EA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000082E482E082FA82F382ED86778674867C86738841884E8867886A886989D3\n8A048A078D728FE38FE18FEE8FE090F190BD90BF90D590C590BE90C790CB90C8\n91D491D39654964F96519653964A964E501E50055007501350225030501B4FF5\n4FF450335037502C4FF64FF75017501C502050275035502F5031500E515A5194\n519351CA51C451C551C851CE5261525A5252525E525F5255526252CD530E539E\n552654E25517551254E754F354E4551A54FF5504550854EB5511550554F10000\nD1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n550A54FB54F754F854E0550E5503550B5701570257CC583257D557D257BA57C6\n57BD57BC57B857B657BF57C757D057B957C1590E594A5A195A165A2D5A2E5A15\n5A0F5A175A0A5A1E5A335B6C5BA75BAD5BAC5C035C565C545CEC5CFF5CEE5CF1\n5CF75D005CF95E295E285EA85EAE5EAA5EAC5F335F305F67605D605A60670000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000604160A26088608060926081609D60836095609B60976087609C608E6219\n624662F263106356632C634463456336634363E46339634B634A633C63296341\n6334635863546359632D63476333635A63516338635763406348654A654665C6\n65C365C465C2664A665F6647665167126713681F681A684968326833683B684B\n684F68166831681C6835682B682D682F684E68446834681D6812681468266828\n682E684D683A682568206B2C6B2F6B2D6B316B346B6D80826B886BE66BE40000\nD2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6BE86BE36BE26BE76C256D7A6D636D646D766D0D6D616D926D586D626D6D6D6F\n6D916D8D6DEF6D7F6D866D5E6D676D606D976D706D7C6D5F6D826D986D2F6D68\n6D8B6D7E6D806D846D166D836D7B6D7D6D756D9070DC70D370D170DD70CB7F39\n70E270D770D270DE70E070D470CD70C570C670C770DA70CE70E1724272780000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000072777276730072FA72F472FE72F672F372FB730173D373D973E573D673BC\n73E773E373E973DC73D273DB73D473DD73DA73D773D873E874DE74DF74F474F5\n7521755B755F75B075C175BB75C475C075BF75B675BA768A76C9771D771B7710\n771377127723771177157719771A772277277823782C78227835782F7828782E\n782B782178297833782A78317954795B794F795C79537952795179EB79EC79E0\n79EE79ED79EA79DC79DE79DD7A867A897A857A8B7A8C7A8A7A877AD87B100000\nD3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7B047B137B057B0F7B087B0A7B0E7B097B127C847C917C8A7C8C7C887C8D7C85\n7D1E7D1D7D117D0E7D187D167D137D1F7D127D0F7D0C7F5C7F617F5E7F607F5D\n7F5B7F967F927FC37FC27FC08016803E803980FA80F280F980F5810180FB8100\n8201822F82258333832D83448319835183258356833F83418326831C83220000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008342834E831B832A8308833C834D8316832483208337832F832983478345\n834C8353831E832C834B832783488653865286A286A88696868D8691869E8687\n86978686868B869A868586A5869986A186A786958698868E869D869086948843\n8844886D88758876887288808871887F886F8883887E8874887C8A128C478C57\n8C7B8CA48CA38D768D788DB58DB78DB68ED18ED38FFE8FF590028FFF8FFB9004\n8FFC8FF690D690E090D990DA90E390DF90E590D890DB90D790DC90E491500000\nD4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n914E914F91D591E291DA965C965F96BC98E39ADF9B2F4E7F5070506A5061505E\n50605053504B505D50725048504D5041505B504A506250155045505F5069506B\n5063506450465040506E50735057505151D0526B526D526C526E52D652D3532D\n539C55755576553C554D55505534552A55515562553655355530555255450000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000550C55325565554E55395548552D553B5540554B570A570757FB581457E2\n57F657DC57F4580057ED57FD580857F8580B57F357CF580757EE57E357F257E5\n57EC57E1580E57FC581057E75801580C57F157E957F0580D5804595C5A605A58\n5A555A675A5E5A385A355A6D5A505A5F5A655A6C5A535A645A575A435A5D5A52\n5A445A5B5A485A8E5A3E5A4D5A395A4C5A705A695A475A515A565A425A5C5B72\n5B6E5BC15BC05C595D1E5D0B5D1D5D1A5D205D0C5D285D0D5D265D255D0F0000\nD5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5D305D125D235D1F5D2E5E3E5E345EB15EB45EB95EB25EB35F365F385F9B5F96\n5F9F608A6090608660BE60B060BA60D360D460CF60E460D960DD60C860B160DB\n60B760CA60BF60C360CD60C063326365638A6382637D63BD639E63AD639D6397\n63AB638E636F63876390636E63AF6375639C636D63AE637C63A4633B639F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006378638563816391638D6370655365CD66656661665B6659665C66626718\n687968876890689C686D686E68AE68AB6956686F68A368AC68A96875687468B2\n688F68776892687C686B687268AA68806871687E689B6896688B68A0688968A4\n6878687B6891688C688A687D6B366B336B376B386B916B8F6B8D6B8E6B8C6C2A\n6DC06DAB6DB46DB36E746DAC6DE96DE26DB76DF66DD46E006DC86DE06DDF6DD6\n6DBE6DE56DDC6DDD6DDB6DF46DCA6DBD6DED6DF06DBA6DD56DC26DCF6DC90000\nD6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6DD06DF26DD36DFD6DD76DCD6DE36DBB70FA710D70F7711770F4710C70F07104\n70F3711070FC70FF71067113710070F870F6710B7102710E727E727B727C727F\n731D7317730773117318730A730872FF730F731E738873F673F873F574047401\n73FD7407740073FA73FC73FF740C740B73F474087564756375CE75D275CF0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000075CB75CC75D175D0768F768976D37739772F772D7731773277347733773D\n7725773B7735784878527849784D784A784C782678457850796479677969796A\n7963796B796179BB79FA79F879F679F77A8F7A947A907B357B477B347B257B30\n7B227B247B337B187B2A7B1D7B317B2B7B2D7B2F7B327B387B1A7B237C947C98\n7C967CA37D357D3D7D387D367D3A7D457D2C7D297D417D477D3E7D3F7D4A7D3B\n7D287F637F957F9C7F9D7F9B7FCA7FCB7FCD7FD07FD17FC77FCF7FC9801F0000\nD7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n801E801B804780438048811881258119811B812D811F812C811E812181158127\n811D8122821182388233823A823482328274839083A383A8838D837A837383A4\n8374838F8381839583998375839483A9837D8383838C839D839B83AA838B837E\n83A583AF8388839783B0837F83A6838783AE8376839A8659865686BF86B70000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000086C286C186C586BA86B086C886B986B386B886CC86B486BB86BC86C386BD\n86BE88528889889588A888A288AA889A889188A1889F889888A78899889B8897\n88A488AC888C8893888E898289D689D989D58A308A278A2C8A1E8C398C3B8C5C\n8C5D8C7D8CA58D7D8D7B8D798DBC8DC28DB98DBF8DC18ED88EDE8EDD8EDC8ED7\n8EE08EE19024900B9011901C900C902190EF90EA90F090F490F290F390D490EB\n90EC90E991569158915A9153915591EC91F491F191F391F891E491F991EA0000\nD8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n91EB91F791E891EE957A95869588967C966D966B9671966F96BF976A980498E5\n9997509B50955094509E508B50A35083508C508E509D5068509C509250825087\n515F51D45312531153A453A7559155A855A555AD5577564555A255935588558F\n55B5558155A3559255A4557D558C55A6557F559555A1558E570C582958370000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005819581E58275823582857F558485825581C581B5833583F5836582E5839\n5838582D582C583B59615AAF5A945A9F5A7A5AA25A9E5A785AA65A7C5AA55AAC\n5A955AAE5A375A845A8A5A975A835A8B5AA95A7B5A7D5A8C5A9C5A8F5A935A9D\n5BEA5BCD5BCB5BD45BD15BCA5BCE5C0C5C305D375D435D6B5D415D4B5D3F5D35\n5D515D4E5D555D335D3A5D525D3D5D315D595D425D395D495D385D3C5D325D36\n5D405D455E445E415F585FA65FA55FAB60C960B960CC60E260CE60C461140000\nD9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n60F2610A6116610560F5611360F860FC60FE60C161036118611D611060FF6104\n610B624A639463B163B063CE63E563E863EF63C3649D63F363CA63E063F663D5\n63F263F5646163DF63BE63DD63DC63C463D863D363C263C763CC63CB63C863F0\n63D763D965326567656A6564655C65686565658C659D659E65AE65D065D20000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000667C666C667B668066716679666A66726701690C68D3690468DC692A68EC\n68EA68F1690F68D668F768EB68E468F66913691068F368E1690768CC69086970\n68B4691168EF68C6691468F868D068FD68FC68E8690B690A691768CE68C868DD\n68DE68E668F468D1690668D468E96915692568C76B396B3B6B3F6B3C6B946B97\n6B996B956BBD6BF06BF26BF36C306DFC6E466E476E1F6E496E886E3C6E3D6E45\n6E626E2B6E3F6E416E5D6E736E1C6E336E4B6E406E516E3B6E036E2E6E5E0000\nDA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6E686E5C6E616E316E286E606E716E6B6E396E226E306E536E656E276E786E64\n6E776E556E796E526E666E356E366E5A7120711E712F70FB712E713171237125\n71227132711F7128713A711B724B725A7288728972867285728B7312730B7330\n73227331733373277332732D732673237335730C742E742C7430742B74160000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000741A7421742D743174247423741D74297420743274FB752F756F756C75E7\n75DA75E175E675DD75DF75E475D77695769276DA774677477744774D7745774A\n774E774B774C77DE77EC786078647865785C786D7871786A786E787078697868\n785E786279747973797279707A027A0A7A037A0C7A047A997AE67AE47B4A7B3B\n7B447B487B4C7B4E7B407B587B457CA27C9E7CA87CA17D587D6F7D637D537D56\n7D677D6A7D4F7D6D7D5C7D6B7D527D547D697D517D5F7D4E7F3E7F3F7F650000\nDB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7F667FA27FA07FA17FD78051804F805080FE80D48143814A8152814F8147813D\n814D813A81E681EE81F781F881F98204823C823D823F8275833B83CF83F98423\n83C083E8841283E783E483FC83F6841083C683C883EB83E383BF840183DD83E5\n83D883FF83E183CB83CE83D683F583C98409840F83DE8411840683C283F30000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000083D583FA83C783D183EA841383C383EC83EE83C483FB83D783E2841B83DB\n83FE86D886E286E686D386E386DA86EA86DD86EB86DC86EC86E986D786E886D1\n88488856885588BA88D788B988B888C088BE88B688BC88B788BD88B2890188C9\n89958998899789DD89DA89DB8A4E8A4D8A398A598A408A578A588A448A458A52\n8A488A518A4A8A4C8A4F8C5F8C818C808CBA8CBE8CB08CB98CB58D848D808D89\n8DD88DD38DCD8DC78DD68DDC8DCF8DD58DD98DC88DD78DC58EEF8EF78EFA0000\nDC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8EF98EE68EEE8EE58EF58EE78EE88EF68EEB8EF18EEC8EF48EE9902D9034902F\n9106912C910490FF90FC910890F990FB9101910091079105910391619164915F\n916291609201920A92259203921A9226920F920C9200921291FF91FD92069204\n92279202921C92249219921792059216957B958D958C95909687967E96880000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000096899683968096C296C896C396F196F0976C9770976E980798A998EB9CE6\n9EF94E834E844EB650BD50BF50C650AE50C450CA50B450C850C250B050C150BA\n50B150CB50C950B650B851D7527A5278527B527C55C355DB55CC55D055CB55CA\n55DD55C055D455C455E955BF55D2558D55CF55D555E255D655C855F255CD55D9\n55C25714585358685864584F584D5849586F5855584E585D58595865585B583D\n5863587158FC5AC75AC45ACB5ABA5AB85AB15AB55AB05ABF5AC85ABB5AC60000\nDD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5AB75AC05ACA5AB45AB65ACD5AB95A905BD65BD85BD95C1F5C335D715D635D4A\n5D655D725D6C5D5E5D685D675D625DF05E4F5E4E5E4A5E4D5E4B5EC55ECC5EC6\n5ECB5EC75F405FAF5FAD60F76149614A612B614561366132612E6146612F614F\n612961406220916862236225622463C563F163EB641064126409642064240000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000064336443641F641564186439643764226423640C64266430642864416435\n642F640A641A644064256427640B63E7641B642E6421640E656F659265D36686\n668C66956690668B668A66996694667867206966695F6938694E69626971693F\n6945696A6939694269576959697A694869496935696C6933693D696568F06978\n693469696940696F69446976695869416974694C693B694B6937695C694F6951\n69326952692F697B693C6B466B456B436B426B486B416B9BFA0D6BFB6BFC0000\nDE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6BF96BF76BF86E9B6ED66EC86E8F6EC06E9F6E936E946EA06EB16EB96EC66ED2\n6EBD6EC16E9E6EC96EB76EB06ECD6EA66ECF6EB26EBE6EC36EDC6ED86E996E92\n6E8E6E8D6EA46EA16EBF6EB36ED06ECA6E976EAE6EA371477154715271637160\n7141715D716271727178716A7161714271587143714B7170715F715071530000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007144714D715A724F728D728C72917290728E733C7342733B733A7340734A\n73497444744A744B7452745174577440744F7450744E74427446744D745474E1\n74FF74FE74FD751D75797577698375EF760F760375F775FE75FC75F975F87610\n75FB75F675ED75F575FD769976B576DD7755775F776077527756775A77697767\n77547759776D77E07887789A7894788F788478957885788678A1788378797899\n78807896787B797C7982797D79797A117A187A197A127A177A157A227A130000\nDF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7A1B7A107AA37AA27A9E7AEB7B667B647B6D7B747B697B727B657B737B717B70\n7B617B787B767B637CB27CB47CAF7D887D867D807D8D7D7F7D857D7A7D8E7D7B\n7D837D7C7D8C7D947D847D7D7D927F6D7F6B7F677F687F6C7FA67FA57FA77FDB\n7FDC8021816481608177815C8169815B816281726721815E81768167816F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000081448161821D8249824482408242824584F1843F845684768479848F848D\n846584518440848684678430844D847D845A845984748473845D8507845E8437\n843A8434847A8443847884328445842983D9844B842F8442842D845F84708439\n844E844C8452846F84C5848E843B8447843684338468847E8444842B84608454\n846E8450870B870486F7870C86FA86D686F5874D86F8870E8709870186F6870D\n870588D688CB88CD88CE88DE88DB88DA88CC88D08985899B89DF89E589E40000\nE0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n89E189E089E289DC89E68A768A868A7F8A618A3F8A778A828A848A758A838A81\n8A748A7A8C3C8C4B8C4A8C658C648C668C868C848C858CCC8D688D698D918D8C\n8D8E8D8F8D8D8D938D948D908D928DF08DE08DEC8DF18DEE8DD08DE98DE38DE2\n8DE78DF28DEB8DF48F068EFF8F018F008F058F078F088F028F0B9052903F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000090449049903D9110910D910F911191169114910B910E916E916F92489252\n9230923A926692339265925E9283922E924A9246926D926C924F92609267926F\n92369261927092319254926392509272924E9253924C92569232959F959C959E\n959B969296939691969796CE96FA96FD96F896F59773977797789772980F980D\n980E98AC98F698F999AF99B299B099B59AAD9AAB9B5B9CEA9CED9CE79E809EFD\n50E650D450D750E850F350DB50EA50DD50E450D350EC50F050EF50E350E00000\nE1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n51D85280528152E952EB533053AC56275615560C561255FC560F561C56015613\n560255FA561D560455FF55F95889587C5890589858865881587F5874588B587A\n58875891588E587658825888587B5894588F58FE596B5ADC5AEE5AE55AD55AEA\n5ADA5AED5AEB5AF35AE25AE05ADB5AEC5ADE5ADD5AD95AE85ADF5B775BE00000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005BE35C635D825D805D7D5D865D7A5D815D775D8A5D895D885D7E5D7C5D8D\n5D795D7F5E585E595E535ED85ED15ED75ECE5EDC5ED55ED95ED25ED45F445F43\n5F6F5FB6612C61286141615E61716173615261536172616C618061746154617A\n615B6165613B616A6161615662296227622B642B644D645B645D647464766472\n6473647D6475646664A6644E6482645E645C644B645364606450647F643F646C\n646B645964656477657365A066A166A0669F67056704672269B169B669C90000\nE2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n69A069CE699669B069AC69BC69916999698E69A7698D69A969BE69AF69BF69C4\n69BD69A469D469B969CA699A69CF69B3699369AA69A1699E69D96997699069C2\n69B569A569C66B4A6B4D6B4B6B9E6B9F6BA06BC36BC46BFE6ECE6EF56EF16F03\n6F256EF86F376EFB6F2E6F096F4E6F196F1A6F276F186F3B6F126EED6F0A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006F366F736EF96EEE6F2D6F406F306F3C6F356EEB6F076F0E6F436F056EFD\n6EF66F396F1C6EFC6F3A6F1F6F0D6F1E6F086F21718771907189718071857182\n718F717B718671817197724472537297729572937343734D7351734C74627473\n7471747574727467746E750075027503757D759076167608760C76157611760A\n761476B87781777C77857782776E7780776F777E778378B278AA78B478AD78A8\n787E78AB789E78A578A078AC78A278A47998798A798B79967995799479930000\nE3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n79977988799279907A2B7A4A7A307A2F7A287A267AA87AAB7AAC7AEE7B887B9C\n7B8A7B917B907B967B8D7B8C7B9B7B8E7B857B9852847B997BA47B827CBB7CBF\n7CBC7CBA7DA77DB77DC27DA37DAA7DC17DC07DC57D9D7DCE7DC47DC67DCB7DCC\n7DAF7DB97D967DBC7D9F7DA67DAE7DA97DA17DC97F737FE27FE37FE57FDE0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008024805D805C8189818681838187818D818C818B8215849784A484A1849F\n84BA84CE84C284AC84AE84AB84B984B484C184CD84AA849A84B184D0849D84A7\n84BB84A2849484C784CC849B84A984AF84A884D6849884B684CF84A084D784D4\n84D284DB84B084918661873387238728876B8740872E871E87218719871B8743\n872C8741873E874687208732872A872D873C8712873A87318735874287268727\n87388724871A8730871188F788E788F188F288FA88FE88EE88FC88F688FB0000\nE4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n88F088EC88EB899D89A1899F899E89E989EB89E88AAB8A998A8B8A928A8F8A96\n8C3D8C688C698CD58CCF8CD78D968E098E028DFF8E0D8DFD8E0A8E038E078E06\n8E058DFE8E008E048F108F118F0E8F0D9123911C91209122911F911D911A9124\n9121911B917A91729179917392A592A49276929B927A92A0929492AA928D0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000092A6929A92AB92799297927F92A392EE928E9282929592A2927D928892A1\n928A9286928C929992A7927E928792A9929D928B922D969E96A196FF9758977D\n977A977E978397809782977B97849781977F97CE97CD981698AD98AE99029900\n9907999D999C99C399B999BB99BA99C299BD99C79AB19AE39AE79B3E9B3F9B60\n9B619B5F9CF19CF29CF59EA750FF5103513050F85106510750F650FE510B510C\n50FD510A528B528C52F152EF56485642564C56355641564A5649564656580000\nE5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n565A56405633563D562C563E5638562A563A571A58AB589D58B158A058A358AF\n58AC58A558A158FF5AFF5AF45AFD5AF75AF65B035AF85B025AF95B015B075B05\n5B0F5C675D995D975D9F5D925DA25D935D955DA05D9C5DA15D9A5D9E5E695E5D\n5E605E5C7DF35EDB5EDE5EE15F495FB2618B6183617961B161B061A261890000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000619B619361AF61AD619F619261AA61A1618D616661B3622D646E64706496\n64A064856497649C648F648B648A648C64A3649F646864B164986576657A6579\n657B65B265B366B566B066A966B266B766AA66AF6A006A066A1769E569F86A15\n69F169E46A2069FF69EC69E26A1B6A1D69FE6A2769F269EE6A1469F769E76A40\n6A0869E669FB6A0D69FC69EB6A096A046A186A256A0F69F66A266A0769F46A16\n6B516BA56BA36BA26BA66C016C006BFF6C026F416F266F7E6F876FC66F920000\nE6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6F8D6F896F8C6F626F4F6F856F5A6F966F766F6C6F826F556F726F526F506F57\n6F946F936F5D6F006F616F6B6F7D6F676F906F536F8B6F696F7F6F956F636F77\n6F6A6F7B71B271AF719B71B071A0719A71A971B5719D71A5719E71A471A171AA\n719C71A771B37298729A73587352735E735F7360735D735B7361735A73590000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000736274877489748A74867481747D74857488747C747975087507757E7625\n761E7619761D761C7623761A7628761B769C769D769E769B778D778F77897788\n78CD78BB78CF78CC78D178CE78D478C878C378C478C9799A79A179A0799C79A2\n799B6B767A397AB27AB47AB37BB77BCB7BBE7BAC7BCE7BAF7BB97BCA7BB57CC5\n7CC87CCC7CCB7DF77DDB7DEA7DE77DD77DE17E037DFA7DE67DF67DF17DF07DEE\n7DDF7F767FAC7FB07FAD7FED7FEB7FEA7FEC7FE67FE88064806781A3819F0000\nE7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n819E819581A2819981978216824F825382528250824E82518524853B850F8500\n8529850E8509850D851F850A8527851C84FB852B84FA8508850C84F4852A84F2\n851584F784EB84F384FC851284EA84E9851684FE8528851D852E850284FD851E\n84F68531852684E784E884F084EF84F9851885208530850B8519852F86620000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000875687638764877787E1877387588754875B87528761875A8751875E876D\n876A8750874E875F875D876F876C877A876E875C8765874F877B877587628767\n8769885A8905890C8914890B891789188919890689168911890E890989A289A4\n89A389ED89F089EC8ACF8AC68AB88AD38AD18AD48AD58ABB8AD78ABE8AC08AC5\n8AD88AC38ABA8ABD8AD98C3E8C4D8C8F8CE58CDF8CD98CE88CDA8CDD8CE78DA0\n8D9C8DA18D9B8E208E238E258E248E2E8E158E1B8E168E118E198E268E270000\nE8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8E148E128E188E138E1C8E178E1A8F2C8F248F188F1A8F208F238F168F179073\n9070906F9067906B912F912B9129912A91329126912E91859186918A91819182\n9184918092D092C392C492C092D992B692CF92F192DF92D892E992D792DD92CC\n92EF92C292E892CA92C892CE92E692CD92D592C992E092DE92E792D192D30000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000092B592E192C692B4957C95AC95AB95AE95B096A496A296D3970597089702\n975A978A978E978897D097CF981E981D9826982998289820981B982798B29908\n98FA9911991499169917991599DC99CD99CF99D399D499CE99C999D699D899CB\n99D799CC9AB39AEC9AEB9AF39AF29AF19B469B439B679B749B719B669B769B75\n9B709B689B649B6C9CFC9CFA9CFD9CFF9CF79D079D009CF99CFB9D089D059D04\n9E839ED39F0F9F10511C51135117511A511151DE533453E156705660566E0000\nE9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n567356665663566D5672565E5677571C571B58C858BD58C958BF58BA58C258BC\n58C65B175B195B1B5B215B145B135B105B165B285B1A5B205B1E5BEF5DAC5DB1\n5DA95DA75DB55DB05DAE5DAA5DA85DB25DAD5DAF5DB45E675E685E665E6F5EE9\n5EE75EE65EE85EE55F4B5FBC619D61A8619661C561B461C661C161CC61BA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000061BF61B8618C64D764D664D064CF64C964BD648964C364DB64F364D96533\n657F657C65A266C866BE66C066CA66CB66CF66BD66BB66BA66CC67236A346A66\n6A496A676A326A686A3E6A5D6A6D6A766A5B6A516A286A5A6A3B6A3F6A416A6A\n6A646A506A4F6A546A6F6A696A606A3C6A5E6A566A556A4D6A4E6A466B556B54\n6B566BA76BAA6BAB6BC86BC76C046C036C066FAD6FCB6FA36FC76FBC6FCE6FC8\n6F5E6FC46FBD6F9E6FCA6FA870046FA56FAE6FBA6FAC6FAA6FCF6FBF6FB80000\nEA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6FA26FC96FAB6FCD6FAF6FB26FB071C571C271BF71B871D671C071C171CB71D4\n71CA71C771CF71BD71D871BC71C671DA71DB729D729E736973667367736C7365\n736B736A747F749A74A074947492749574A1750B7580762F762D7631763D7633\n763C76357632763076BB76E6779A779D77A1779C779B77A277A3779577990000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000779778DD78E978E578EA78DE78E378DB78E178E278ED78DF78E079A47A44\n7A487A477AB67AB87AB57AB17AB77BDE7BE37BE77BDD7BD57BE57BDA7BE87BF9\n7BD47BEA7BE27BDC7BEB7BD87BDF7CD27CD47CD77CD07CD17E127E217E177E0C\n7E1F7E207E137E0E7E1C7E157E1A7E227E0B7E0F7E167E0D7E147E257E247F43\n7F7B7F7C7F7A7FB17FEF802A8029806C81B181A681AE81B981B581AB81B081AC\n81B481B281B781A781F282558256825785568545856B854D8553856185580000\nEB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n854085468564854185628544855185478563853E855B8571854E856E85758555\n85678560858C8566855D85548565856C866386658664879B878F879787938792\n87888781879687988779878787A3878587908791879D87848794879C879A8789\n891E89268930892D892E89278931892289298923892F892C891F89F18AE00000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008AE28AF28AF48AF58ADD8B148AE48ADF8AF08AC88ADE8AE18AE88AFF8AEF\n8AFB8C918C928C908CF58CEE8CF18CF08CF38D6C8D6E8DA58DA78E338E3E8E38\n8E408E458E368E3C8E3D8E418E308E3F8EBD8F368F2E8F358F328F398F378F34\n90769079907B908690FA913391359136919391909191918D918F9327931E9308\n931F9306930F937A9338933C931B9323931293019346932D930E930D92CB931D\n92FA9325931392F992F793349302932492FF932993399335932A9314930C0000\nEC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n930B92FE9309930092FB931695BC95CD95BE95B995BA95B695BF95B595BD96A9\n96D4970B9712971097999797979497F097F89835982F98329924991F99279929\n999E99EE99EC99E599E499F099E399EA99E999E79AB99ABF9AB49ABB9AF69AFA\n9AF99AF79B339B809B859B879B7C9B7E9B7B9B829B939B929B909B7A9B950000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009B7D9B889D259D179D209D1E9D149D299D1D9D189D229D109D199D1F9E88\n9E869E879EAE9EAD9ED59ED69EFA9F129F3D51265125512251245120512952F4\n5693568C568D568656845683567E5682567F568158D658D458CF58D25B2D5B25\n5B325B235B2C5B275B265B2F5B2E5B7B5BF15BF25DB75E6C5E6A5FBE5FBB61C3\n61B561BC61E761E061E561E461E861DE64EF64E964E364EB64E464E865816580\n65B665DA66D26A8D6A966A816AA56A896A9F6A9B6AA16A9E6A876A936A8E0000\nED\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n6A956A836AA86AA46A916A7F6AA66A9A6A856A8C6A926B5B6BAD6C096FCC6FA9\n6FF46FD46FE36FDC6FED6FE76FE66FDE6FF26FDD6FE26FE871E171F171E871F2\n71E471F071E27373736E736F749774B274AB749074AA74AD74B174A574AF7510\n75117512750F7584764376487649764776A476E977B577AB77B277B777B60000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000077B477B177A877F078F378FD790278FB78FC78F2790578F978FE790479AB\n79A87A5C7A5B7A567A587A547A5A7ABE7AC07AC17C057C0F7BF27C007BFF7BFB\n7C0E7BF47C0B7BF37C027C097C037C017BF87BFD7C067BF07BF17C107C0A7CE8\n7E2D7E3C7E427E3398487E387E2A7E497E407E477E297E4C7E307E3B7E367E44\n7E3A7F457F7F7F7E7F7D7FF47FF2802C81BB81C481CC81CA81C581C781BC81E9\n825B825A825C85838580858F85A7859585A0858B85A3857B85A4859A859E0000\nEE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8577857C858985A1857A85788557858E85968586858D8599859D858185A28582\n858885858579857685988590859F866887BE87AA87AD87C587B087AC87B987B5\n87BC87AE87C987C387C287CC87B787AF87C487CA87B487B687BF87B887BD87DE\n87B289358933893C893E894189528937894289AD89AF89AE89F289F38B1E0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008B188B168B118B058B0B8B228B0F8B128B158B078B0D8B088B068B1C8B13\n8B1A8C4F8C708C728C718C6F8C958C948CF98D6F8E4E8E4D8E538E508E4C8E47\n8F438F409085907E9138919A91A2919B9199919F91A1919D91A093A1938393AF\n936493569347937C9358935C93769349935093519360936D938F934C936A9379\n935793559352934F93719377937B9361935E936393679380934E935995C795C0\n95C995C395C595B796AE96B096AC9720971F9718971D9719979A97A1979C0000\nEF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n979E979D97D597D497F198419844984A9849984598439925992B992C992A9933\n9932992F992D99319930999899A399A19A0299FA99F499F799F999F899F699FB\n99FD99FE99FC9A039ABE9AFE9AFD9B019AFC9B489B9A9BA89B9E9B9B9BA69BA1\n9BA59BA49B869BA29BA09BAF9D339D419D679D369D2E9D2F9D319D389D300000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009D459D429D439D3E9D379D409D3D7FF59D2D9E8A9E899E8D9EB09EC89EDA\n9EFB9EFF9F249F239F229F549FA05131512D512E5698569C5697569A569D5699\n59705B3C5C695C6A5DC05E6D5E6E61D861DF61ED61EE61F161EA61F061EB61D6\n61E964FF650464FD64F86501650364FC659465DB66DA66DB66D86AC56AB96ABD\n6AE16AC66ABA6AB66AB76AC76AB46AAD6B5E6BC96C0B7007700C700D70017005\n7014700E6FFF70006FFB70266FFC6FF7700A720171FF71F9720371FD73760000\nF0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n74B874C074B574C174BE74B674BB74C275147513765C76647659765076537657\n765A76A676BD76EC77C277BA78FF790C79137914790979107912791179AD79AC\n7A5F7C1C7C297C197C207C1F7C2D7C1D7C267C287C227C257C307E5C7E507E56\n7E637E587E627E5F7E517E607E577E537FB57FB37FF77FF8807581D181D20000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000081D0825F825E85B485C685C085C385C285B385B585BD85C785C485BF85CB\n85CE85C885C585B185B685D2862485B885B785BE866987E787E687E287DB87EB\n87EA87E587DF87F387E487D487DC87D387ED87D887E387A487D787D9880187F4\n87E887DD8953894B894F894C89468950895189498B2A8B278B238B338B308B35\n8B478B2F8B3C8B3E8B318B258B378B268B368B2E8B248B3B8B3D8B3A8C428C75\n8C998C988C978CFE8D048D028D008E5C8E628E608E578E568E5E8E658E670000\nF1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8E5B8E5A8E618E5D8E698E548F468F478F488F4B9128913A913B913E91A891A5\n91A791AF91AA93B5938C939293B7939B939D938993A7938E93AA939E93A69395\n93889399939F938D93B1939193B293A493A893B493A393A595D295D395D196B3\n96D796DA5DC296DF96D896DD97239722972597AC97AE97A897AB97A497AA0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000097A297A597D797D997D697D897FA98509851985298B89941993C993A9A0F\n9A0B9A099A0D9A049A119A0A9A059A079A069AC09ADC9B089B049B059B299B35\n9B4A9B4C9B4B9BC79BC69BC39BBF9BC19BB59BB89BD39BB69BC49BB99BBD9D5C\n9D539D4F9D4A9D5B9D4B9D599D569D4C9D579D529D549D5F9D589D5A9E8E9E8C\n9EDF9F019F009F169F259F2B9F2A9F299F289F4C9F5551345135529652F753B4\n56AB56AD56A656A756AA56AC58DA58DD58DB59125B3D5B3E5B3F5DC35E700000\nF2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n5FBF61FB65076510650D6509650C650E658465DE65DD66DE6AE76AE06ACC6AD1\n6AD96ACB6ADF6ADC6AD06AEB6ACF6ACD6ADE6B606BB06C0C7019702770207016\n702B702170227023702970177024701C702A720C720A72077202720572A572A6\n72A472A372A174CB74C574B774C37516766077C977CA77C477F1791D791B0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007921791C7917791E79B07A677A687C337C3C7C397C2C7C3B7CEC7CEA7E76\n7E757E787E707E777E6F7E7A7E727E747E687F4B7F4A7F837F867FB77FFD7FFE\n807881D781D582648261826385EB85F185ED85D985E185E885DA85D785EC85F2\n85F885D885DF85E385DC85D185F085E685EF85DE85E2880087FA880387F687F7\n8809880C880B880687FC880887FF880A88028962895A895B89578961895C8958\n895D8959898889B789B689F68B508B488B4A8B408B538B568B548B4B8B550000\nF3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8B518B428B528B578C438C778C768C9A8D068D078D098DAC8DAA8DAD8DAB8E6D\n8E788E738E6A8E6F8E7B8EC28F528F518F4F8F508F538FB49140913F91B091AD\n93DE93C793CF93C293DA93D093F993EC93CC93D993A993E693CA93D493EE93E3\n93D593C493CE93C093D293E7957D95DA95DB96E19729972B972C972897260000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000097B397B797B697DD97DE97DF985C9859985D985798BF98BD98BB98BE9948\n9947994399A699A79A1A9A159A259A1D9A249A1B9A229A209A279A239A1E9A1C\n9A149AC29B0B9B0A9B0E9B0C9B379BEA9BEB9BE09BDE9BE49BE69BE29BF09BD4\n9BD79BEC9BDC9BD99BE59BD59BE19BDA9D779D819D8A9D849D889D719D809D78\n9D869D8B9D8C9D7D9D6B9D749D759D709D699D859D739D7B9D829D6F9D799D7F\n9D879D689E949E919EC09EFC9F2D9F409F419F4D9F569F579F58533756B20000\nF4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n56B556B358E35B455DC65DC75EEE5EEF5FC05FC161F9651765166515651365DF\n66E866E366E46AF36AF06AEA6AE86AF96AF16AEE6AEF703C7035702F70377034\n703170427038703F703A70397040703B703370417213721472A8737D737C74BA\n76AB76AA76BE76ED77CC77CE77CF77CD77F27925792379277928792479290000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000079B27A6E7A6C7A6D7AF77C497C487C4A7C477C457CEE7E7B7E7E7E817E80\n7FBA7FFF807981DB81D9820B82688269862285FF860185FE861B860085F68604\n86098605860C85FD8819881088118817881388168963896689B989F78B608B6A\n8B5D8B688B638B658B678B6D8DAE8E868E888E848F598F568F578F558F588F5A\n908D9143914191B791B591B291B3940B941393FB9420940F941493FE94159410\n94289419940D93F5940093F79407940E9416941293FA940993F8940A93FF0000\nF5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n93FC940C93F69411940695DE95E095DF972E972F97B997BB97FD97FE98609862\n9863985F98C198C29950994E9959994C994B99539A329A349A319A2C9A2A9A36\n9A299A2E9A389A2D9AC79ACA9AC69B109B129B119C0B9C089BF79C059C129BF8\n9C409C079C0E9C069C179C149C099D9F9D999DA49D9D9D929D989D909D9B0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009DA09D949D9C9DAA9D979DA19D9A9DA29DA89D9E9DA39DBF9DA99D969DA6\n9DA79E999E9B9E9A9EE59EE49EE79EE69F309F2E9F5B9F609F5E9F5D9F599F91\n513A51395298529756C356BD56BE5B485B475DCB5DCF5EF161FD651B6B026AFC\n6B036AF86B0070437044704A7048704970457046721D721A7219737E7517766A\n77D0792D7931792F7C547C537CF27E8A7E877E887E8B7E867E8D7F4D7FBB8030\n81DD8618862A8626861F8623861C86198627862E862186208629861E86250000\nF6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8829881D881B88208824881C882B884A896D8969896E896B89FA8B798B788B45\n8B7A8B7B8D108D148DAF8E8E8E8C8F5E8F5B8F5D91469144914591B9943F943B\n94369429943D943C94309439942A9437942C9440943195E595E495E39735973A\n97BF97E1986498C998C698C0995899569A399A3D9A469A449A429A419A3A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009A3F9ACD9B159B179B189B169B3A9B529C2B9C1D9C1C9C2C9C239C289C29\n9C249C219DB79DB69DBC9DC19DC79DCA9DCF9DBE9DC59DC39DBB9DB59DCE9DB9\n9DBA9DAC9DC89DB19DAD9DCC9DB39DCD9DB29E7A9E9C9EEB9EEE9EED9F1B9F18\n9F1A9F319F4E9F659F649F924EB956C656C556CB59715B4B5B4C5DD55DD15EF2\n65216520652665226B0B6B086B096C0D7055705670577052721E721F72A9737F\n74D874D574D974D7766D76AD793579B47A707A717C577C5C7C597C5B7C5A0000\nF7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7CF47CF17E917F4F7F8781DE826B863486358633862C86328636882C88288826\n882A8825897189BF89BE89FB8B7E8B848B828B868B858B7F8D158E958E948E9A\n8E928E908E968E978F608F629147944C9450944A944B944F9447944594489449\n9446973F97E3986A986998CB9954995B9A4E9A539A549A4C9A4F9A489A4A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009A499A529A509AD09B199B2B9B3B9B569B559C469C489C3F9C449C399C33\n9C419C3C9C379C349C329C3D9C369DDB9DD29DDE9DDA9DCB9DD09DDC9DD19DDF\n9DE99DD99DD89DD69DF59DD59DDD9EB69EF09F359F339F329F429F6B9F959FA2\n513D529958E858E759725B4D5DD8882F5F4F62016203620465296525659666EB\n6B116B126B0F6BCA705B705A7222738273817383767077D47C677C667E95826C\n863A86408639863C8631863B863E88308832882E883389768974897389FE0000\nF8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8B8C8B8E8B8B8B888C458D198E988F648F6391BC94629455945D9457945E97C4\n97C598009A569A599B1E9B1F9B209C529C589C509C4A9C4D9C4B9C559C599C4C\n9C4E9DFB9DF79DEF9DE39DEB9DF89DE49DF69DE19DEE9DE69DF29DF09DE29DEC\n9DF49DF39DE89DED9EC29ED09EF29EF39F069F1C9F389F379F369F439F4F0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009F719F709F6E9F6F56D356CD5B4E5C6D652D66ED66EE6B13705F7061705D\n7060722374DB74E577D5793879B779B67C6A7E977F89826D8643883888378835\n884B8B948B958E9E8E9F8EA08E9D91BE91BD91C2946B9468946996E597469743\n974797C797E59A5E9AD59B599C639C679C669C629C5E9C609E029DFE9E079E03\n9E069E059E009E019E099DFF9DFD9E049EA09F1E9F469F749F759F7656D4652E\n65B86B186B196B176B1A7062722672AA77D877D979397C697C6B7CF67E9A0000\nF9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n7E987E9B7E9981E081E18646864786488979897A897C897B89FF8B988B998EA5\n8EA48EA3946E946D946F9471947397499872995F9C689C6E9C6D9E0B9E0D9E10\n9E0F9E129E119EA19EF59F099F479F789F7B9F7A9F79571E70667C6F883C8DB2\n8EA691C394749478947694759A609C749C739C719C759E149E139EF69F0A0000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009FA4706870657CF7866A883E883D883F8B9E8C9C8EA98EC9974B98739874\n98CC996199AB9A649A669A679B249E159E179F4862076B1E7227864C8EA89482\n948094819A699A689B2E9E197229864B8B9F94839C799EB776759A6B9C7A9E1D\n7069706A9EA49F7E9F499F98788192B988CF58BB60527CA75AFA255425662557\n2560256C2563255A2569255D255225642555255E256A256125582567255B2553\n25652556255F256B256225592568255C25512550256D256E2570256F25930000\n",
		"/encoding/dingbats.enc":                   "# Encoding file: dingbats, single-byte\nS\n003F 1 1\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n00202701270227032704260E2706270727082709261B261E270C270D270E270F\n2710271127122713271427152716271727182719271A271B271C271D271E271F\n2720272127222723272427252726272726052729272A272B272C272D272E272F\n2730273127322733273427352736273727382739273A273B273C273D273E273F\n2740274127422743274427452746274727482749274A274B25CF274D25A0274F\n27502751275225B225BC25C6275625D727582759275A275B275C275D275E007F\n0080008100820083008400850086008700880089008A008B008C008D008E008F\n0090009100920093009400950096009700980099009A009B009C009D009E009F\n0000276127622763276427652766276726632666266526602460246124622463\n2464246524662467246824692776277727782779277A277B277C277D277E277F\n2780278127822783278427852786278727882789278A278B278C278D278E278F\n2790279127922793279421922194219527982799279A279B279C279D279E279F\n27A027A127A227A327A427A527A627A727A827A927AA27AB27AC27AD27AE27AF\n000027B127B227B327B427B527B627B727B827B927BA27BB27BC27BD27BE0000\n",
		"/encoding/ebcdic.enc":                     "S\n006F 0 1\n00\n0000000100020003008500090086007F0087008D008E000B000C000D000E000F\n0010001100120013008F000A0008009700180019009C009D001C001D001E001F\n0080008100820083008400920017001B00880089008A008B008C000500060007\n0090009100160093009400950096000400980099009A009B00140015009E001A\n002000A000E200E400E000E100E300E500E700F10060002E003C0028002B007C\n002600E900EA00EB00E800ED00EE00EF00EC00DF00210024002A0029003B009F\n002D002F00C200C400C000C100C300C500C700D1005E002C0025005F003E003F\n00F800C900CA00CB00C800CD00CE00CF00CC00A8003A002300400027003D0022\n00D800610062006300640065006600670068006900AB00BB00F000FD00FE00B1\n00B0006A006B006C006D006E006F00700071007200AA00BA00E600B800C600A4\n00B500AF0073007400750076007700780079007A00A100BF00D000DD00DE00AE\n00A200A300A500B700A900A700B600BC00BD00BE00AC005B005C005D00B400D7\n00F900410042004300440045004600470048004900AD00F400F600F200F300F5\n00A6004A004B004C004D004E004F00500051005200B900FB00FC00DB00FA00FF\n00D900F70053005400550056005700580059005A00B200D400D600D200D300D5\n003000310032003300340035003600370038003900B3007B00DC007D00DA007E\n",
		"/encoding/euc-cn.enc":                     "# Encoding file: euc-cn, multi-byte\nM\n003F 0 82\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n0080008100820083008400850086008700880089008A008B008C008D008E008F\n0090009100920093009400950096009700980099009A009B009C009D009E009F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000030003001300230FB02C902C700A8300330052015FF5E2225202620182019\n201C201D3014301530083009300A300B300C300D300E300F3016301730103011\n00B100D700F72236222722282211220F222A222922082237221A22A522252220\n23122299222B222E2261224C2248223D221D2260226E226F22642265221E2235\n22342642264000B0203220332103FF0400A4FFE0FFE1203000A7211626062605\n25CB25CF25CE25C725C625A125A025B325B2203B219221902191219330130000\nA2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000024882489248A248B248C248D248E248F2490249124922493249424952496\n249724982499249A249B247424752476247724782479247A247B247C247D247E\n247F248024812482248324842485248624872460246124622463246424652466\n2467246824690000000032203221322232233224322532263227322832290000\n00002160216121622163216421652166216721682169216A216B000000000000\nA3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000FF01FF02FF03FFE5FF05FF06FF07FF08FF09FF0AFF0BFF0CFF0DFF0EFF0F\nFF10FF11FF12FF13FF14FF15FF16FF17FF18FF19FF1AFF1BFF1CFF1DFF1EFF1F\nFF20FF21FF22FF23FF24FF25FF26FF27FF28FF29FF2AFF2BFF2CFF2DFF2EFF2F\nFF30FF31FF32FF33FF34FF35FF36FF37FF38FF39FF3AFF3BFF3CFF3DFF3EFF3F\nFF40FF41FF42FF43FF44FF45FF46FF47FF48FF49FF4AFF4BFF4CFF4DFF4EFF4F\nFF50FF51FF52FF53FF54FF55FF56FF57FF58FF59FF5AFF5BFF5CFF5DFFE30000\nA4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000304130423043304430453046304730483049304A304B304C304D304E304F\n3050305130523053305430553056305730583059305A305B305C305D305E305F\n3060306130623063306430653066306730683069306A306B306C306D306E306F\n3070307130723073307430753076307730783079307A307B307C307D307E307F\n3080308130823083308430853086308730883089308A308B308C308D308E308F\n3090309130923093000000000000000000000000000000000000000000000000\nA5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000030A130A230A330A430A530A630A730A830A930AA30AB30AC30AD30AE30AF\n30B030B130B230B330B430B530B630B730B830B930BA30BB30BC30BD30BE30BF\n30C030C130C230C330C430C530C630C730C830C930CA30CB30CC30CD30CE30CF\n30D030D130D230D330D430D530D630D730D830D930DA30DB30DC30DD30DE30DF\n30E030E130E230E330E430E530E630E730E830E930EA30EB30EC30ED30EE30EF\n30F030F130F230F330F430F530F6000000000000000000000000000000000000\nA6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000039103920393039403950396039703980399039A039B039C039D039E039F\n03A003A103A303A403A503A603A703A803A90000000000000000000000000000\n000003B103B203B303B403B503B603B703B803B903BA03BB03BC03BD03BE03BF\n03C003C103C303C403C503C603C703C803C90000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000004100411041204130414041504010416041704180419041A041B041C041D\n041E041F0420042104220423042404250426042704280429042A042B042C042D\n042E042F00000000000000000000000000000000000000000000000000000000\n000004300431043204330434043504510436043704380439043A043B043C043D\n043E043F0440044104420443044404450446044704480449044A044B044C044D\n044E044F00000000000000000000000000000000000000000000000000000000\nA8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000010100E101CE00E0011300E9011B00E8012B00ED01D000EC014D00F301D2\n00F2016B00FA01D400F901D601D801DA01DC00FC00EA00000000000000000000\n0000000000000000000031053106310731083109310A310B310C310D310E310F\n3110311131123113311431153116311731183119311A311B311C311D311E311F\n3120312131223123312431253126312731283129000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00000000000000002500250125022503250425052506250725082509250A250B\n250C250D250E250F2510251125122513251425152516251725182519251A251B\n251C251D251E251F2520252125222523252425252526252725282529252A252B\n252C252D252E252F2530253125322533253425352536253725382539253A253B\n253C253D253E253F2540254125422543254425452546254725482549254A254B\n0000000000000000000000000000000000000000000000000000000000000000\nB0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000554A963F57C3632854CE550954C07691764C853C77EE827E788D72319698\n978D6C285B894FFA630966975CB880FA684880AE660276CE51F9655671AC7FF1\n888450B2596561CA6FB382AD634C625253ED54277B06516B75A45DF462D48DCB\n9776628A8019575D97387F627238767D67CF767E64464F708D2562DC7A176591\n73ED642C6273822C9881677F7248626E62CC4F3474E3534A529E7ECA90A65E2E\n6886699C81807ED168D278C5868C9551508D8C2482DE80DE5305891252650000\nB1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000858496F94FDD582199715B9D62B162A566B48C799C8D7206676F789160B2\n535153178F8880CC8D1D94A1500D72C8590760EB711988AB595482EF672C7B28\n5D297EF7752D6CF58E668FF8903C9F3B6BD491197B145F7C78A784D6853D6BD5\n6BD96BD65E015E8775F995ED655D5F0A5FC58F9F58C181C2907F965B97AD8FB9\n7F168D2C62414FBF53D8535E8FA88FA98FAB904D68075F6A819888689CD6618B\n522B762A5F6C658C6FD26EE85BBE6448517551B067C44E1979C9997C70B30000\nB2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000075C55E7673BB83E064AD62E894B56CE2535A52C3640F94C27B944F2F5E1B\n82368116818A6E246CCA9A736355535C54FA886557E04E0D5E036B657C3F90E8\n601664E6731C88C16750624D8D22776C8E2991C75F6983DC8521991053C28695\n6B8B60ED60E8707F82CD82314ED36CA785CF64CD7CD969FD66F9834953957B56\n4FA7518C6D4B5C428E6D63D253C9832C833667E578B4643D5BDF5C945DEE8BE7\n62C667F48C7A640063BA8749998B8C177F2094F24EA7961098A4660C73160000\nB3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000573A5C1D5E38957F507F80A05382655E7545553150218D856284949E671D\n56326F6E5DE2543570928F66626F64A463A35F7B6F8890F481E38FB05C186668\n5FF16C8996488D81886C649179F057CE6A59621054484E587A0B60E96F848BDA\n627F901E9A8B79E4540375F4630153196C608FDF5F1B9A70803B9F7F4F885C3A\n8D647FC565A570BD514551B2866B5D075BA062BD916C75748E0C7A2061017B79\n4EC77EF877854E1181ED521D51FA6A7153A88E87950496CF6EC19664695A0000\nB4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000784050A877D7641089E6590463E35DDD7A7F693D4F20823955984E3275AE\n7A975E625E8A95EF521B5439708A6376952457826625693F918755076DF37EAF\n882262337EF075B5832878C196CC8F9E614874F78BCD6B64523A8D506B21806A\n847156F153064ECE4E1B51D17C97918B7C074FC38E7F7BE17A9C64675D1450AC\n810676017CB96DEC7FE067515B585BF878CB64AE641363AA632B9519642D8FBE\n7B5476296253592754466B7950A362345E266B864EE38D37888B5F85902E0000\nB5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006020803D62C54E39535590F863B880C665E66C2E4F4660EE6DE18BDE5F39\n86CB5F536321515A83616863520063638E4850125C9B79775BFC52307A3B60BC\n905376D75FB75F9776848E6C706F767B7B4977AA51F3909358244F4E6EF48FEA\n654C7B1B72C46DA47FDF5AE162B55E95573084827B2C5E1D5F1F90127F1498A0\n63826EC7789870B95178975B57AB75354F4375385E9760E659606DC06BBF7889\n53FC96D551CB52016389540A94938C038DCC7239789F87768FED8C0D53E00000\nB6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004E0176EF53EE948998769F0E952D5B9A8BA24E224E1C51AC846361C252A8\n680B4F97606B51BB6D1E515C6296659796618C46901775D890FD77636BD2728A\n72EC8BFB583577798D4C675C9540809A5EA66E2159927AEF77ED953B6BB565AD\n7F0E58065151961F5BF958A954288E726566987F56E4949D76FE9041638754C6\n591A593A579B8EB267358DFA8235524160F0581586FE5CE89E454FC4989D8BB9\n5A2560765384627C904F9102997F6069800C513F80335C1499756D314E8C0000\nB7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008D3053D17F5A7B4F4F104E4F96006CD573D085E95E06756A7FFB6A0A77FE\n94927E4151E170E653CD8FD483038D2972AF996D6CDB574A82B365B980AA623F\n963259A84EFF8BBF7EBA653E83F2975E556198DE80A5532A8BFD542080BA5E9F\n6CB88D3982AC915A54296C1B52067EB7575F711A6C7E7C89594B4EFD5FFF6124\n7CAA4E305C0167AB87025CF0950B98CE75AF70FD902251AF7F1D8BBD594951E4\n4F5B5426592B657780A45B75627662C28F905E456C1F7B264F0F4FD8670D0000\nB8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006D6E6DAA798F88B15F17752B629A8F854FEF91DC65A7812F81515E9C8150\n8D74526F89868D4B590D50854ED8961C723681798D1F5BCC8BA3964459877F1A\n54905676560E8BE565396982949976D66E895E727518674667D17AFF809D8D76\n611F79C665628D635188521A94A27F38809B7EB25C976E2F67607BD9768B9AD8\n818F7F947CD5641E95507A3F544A54E56B4C640162089E3D80F3759952729769\n845B683C86E49601969494EC4E2A54047ED968398DDF801566F45E9A7FB90000\nB9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000057C2803F68975DE5653B529F606D9F9A4F9B8EAC516C5BAB5F135DE96C5E\n62F18D21517194A952FE6C9F82DF72D757A267848D2D591F8F9C83C754957B8D\n4F306CBD5B6459D19F1353E486CA9AA88C3780A16545987E56FA96C7522E74DC\n52505BE1630289024E5662D0602A68FA51735B9851A089C27BA199867F5060EF\n704C8D2F51495E7F901B747089C4572D78455F529F9F95FA8F689B3C8BE17678\n684267DC8DEA8D35523D8F8A6EDA68CD950590ED56FD679C88F98FC754C80000\nBA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009AB85B696D776C264EA55BB39A87916361A890AF97E9542B6DB55BD251FD\n558A7F557FF064BC634D65F161BE608D710A6C576C49592F676D822A58D5568E\n8C6A6BEB90DD597D801753F76D695475559D837783CF683879BE548C4F555408\n76D28C8996026CB36DB88D6B89109E648D3A563F9ED175D55F8872E0606854FC\n4EA86A2A886160528F7054C470D886799E3F6D2A5B8F5F187EA255894FAF7334\n543C539A5019540E547C4E4E5FFD745A58F6846B80E1877472D07CCA6E560000\nBB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005F27864E552C62A44E926CAA623782B154D7534E733E6ED1753B52125316\n8BDD69D05F8A60006DEE574F6B2273AF68538FD87F13636260A3552475EA8C62\n71156DA35BA65E7B8352614C9EC478FA87577C27768751F060F6714C66435E4C\n604D8C0E707063258F895FBD606286D456DE6BC160946167534960E066668D3F\n79FD4F1A70E96C478BB38BF27ED88364660F5A5A9B426D516DF78C416D3B4F19\n706B83B7621660D1970D8D27797851FB573E57FA673A75787A3D79EF7B950000\nBC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000808C99658FF96FC08BA59E2159EC7EE97F095409678168D88F917C4D96C6\n53CA602575BE6C7253735AC97EA7632451E0810A5DF184DF628051805B634F0E\n796D524260B86D4E5BC45BC28BA18BB065E25FCC964559937EE77EAA560967B7\n59394F735BB652A0835A988A8D3E753294BE50477A3C4EF767B69A7E5AC16B7C\n76D1575A5C167B3A95F4714E517C80A9827059787F04832768C067EC78B17877\n62E363617B804FED526A51CF835069DB92748DF58D3189C1952E7BAD4EF60000\nBD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000506582305251996F6E106E856DA75EFA50F559DC5C066D466C5F7586848B\n686859568BB253209171964D854969127901712680F64EA490CA6D479A845A07\n56BC640594F077EB4FA5811A72E189D2997A7F347EDE527F655991758F7F8F83\n53EB7A9663ED63A5768679F888579636622A52AB8282685467706377776B7AED\n6D017ED389E359D0621285C982A5754C501F4ECB75A58BEB5C4A5DFE7B4B65A4\n91D14ECA6D25895F7D2795264EC58C288FDB9773664B79818FD170EC6D780000\nBE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005C3D52B283465162830E775B66769CB84EAC60CA7CBE7CB37ECF4E958B66\n666F988897595883656C955C5F8475C997567ADF7ADE51C070AF7A9863EA7A76\n7EA0739697ED4E4570784E5D915253A9655165E781FC8205548E5C31759A97A0\n62D872D975BD5C459A7983CA5C40548077E94E3E6CAE805A62D2636E5DE85177\n8DDD8E1E952F4FF153E560E770AC526763509E435A1F5026773753777EE26485\n652B628963985014723589C951B38BC07EDD574783CC94A7519B541B5CFB0000\nBF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004FCA7AE36D5A90E19A8F55805496536154AF5F0063E9697751EF6168520A\n582A52D8574E780D770B5EB761777CE0625B62974EA27095800362F770E49760\n577782DB67EF68F578D5989779D158F354B353EF6E34514B523B5BA28BFE80AF\n554357A660735751542D7A7A60505B5463A762A053E362635BC767AF54ED7A9F\n82E691775E9388E4593857AE630E8DE880EF57577B774FA95FEB5BBD6B3E5321\n7B5072C2684677FF773665F751B54E8F76D45CBF7AA58475594E9B4150800000\nC0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000998861276E8357646606634656F062EC62695ED39614578362C955878721\n814A8FA3556683B167658D5684DD5A6A680F62E67BEE961151706F9C8C3063FD\n89C861D27F0670C26EE57405699472FC5ECA90CE67176D6A635E52B372628001\n4F6C59E5916A70D96D9D52D24E5096F7956D857E78CA7D2F5121579264C2808B\n7C7B6CEA68F1695E51B7539868A872819ECE7BF172F879BB6F137406674E91CC\n9CA4793C83898354540F68174E3D538952B1783E5386522950884F8B4FD00000\nC1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000075E27ACB7C926CA596B6529B748354E94FE9805483B28FDE95705EC9601C\n6D9F5E18655B813894FE604B70BC7EC37CAE51C968817CB1826F4E248F8691CF\n667E4EAE8C0564A9804A50DA759771CE5BE58FBD6F664E86648295635ED66599\n521788C270C852A3730E7433679778F797164E3490BB9CDE6DCB51DB8D41541D\n62CE73B283F196F69F8494C34F367F9A51CC707596755CAD988653E64EE46E9C\n740969B4786B998F7559521876246D4167F3516D9F99804B54997B3C7ABF0000\nC2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009686578462E29647697C5A0464027BD36F0F964B82A6536298855E907089\n63B35364864F9C819E93788C97328DEF8D429E7F6F5E79845F559646622E9A74\n541594DD4FA365C55C655C617F1586516C2F5F8B73876EE47EFF5CE6631B5B6A\n6EE653754E7163A0756562A18F6E4F264ED16CA67EB68BBA841D87BA7F57903B\n95237BA99AA188F8843D6D1B9A867EDC59889EBB739B780186829A6C9A82561B\n541757CB4E709EA653568FC881097792999286EE6EE1851366FC61626F2B0000\nC3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008C298292832B76F26C135FD983BD732B8305951A6BDB77DB94C6536F8302\n51925E3D8C8C8D384E4873AB679A68859176970971646CA177095A9295416BCF\n7F8E66275BD059B95A9A95E895F74EEC840C84996AAC76DF9530731B68A65B5F\n772F919A97617CDC8FF78C1C5F257C7379D889C56CCC871C5BC65E4268C97720\n7EF55195514D52C95A297F05976282D763CF778485D079D26E3A5E9959998511\n706D6C1162BF76BF654F60AF95FD660E879F9E2394ED540D547D8C2C64780000\nC4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000647986116A21819C78E864699B5462B9672B83AB58A89ED86CAB6F205BDE\n964C8C0B725F67D062C772614EA959C66BCD589366AE5E5552DF6155672876EE\n776672677A4662FF54EA545094A090A35A1C7EB36C164E435976801059485357\n753796BE56CA63208111607C95F96DD65462998151855AE980FD59AE9713502A\n6CE55C3C62DF4F60533F817B90066EBA852B62C85E7478BE64B5637B5FF55A18\n917F9E1F5C3F634F80425B7D556E954A954D6D8560A867E072DE51DD5B810000\nC5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000062E76CDE725B626D94AE7EBD81136D53519C5F04597452AA601259736696\n8650759F632A61E67CEF8BFA54E66B279E256BB485D5545550766CA4556A8DB4\n722C5E156015743662CD6392724C5F986E436D3E65006F5876D878D076FC7554\n522453DB4E535E9E65C1802A80D6629B5486522870AE888D8DD16CE1547880DA\n57F988F48D54966A914D4F696C9B55B776C6783062A870F96F8E5F6D84EC68DA\n787C7BF781A8670B9E4F636778B0576F78129739627962AB528874356BD70000\nC6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005564813E75B276AE533975DE50FB5C418B6C7BC7504F72479A9798D86F02\n74E27968648777A562FC98918D2B54C180584E52576A82F9840D5E7351ED74F6\n8BC45C4F57616CFC98875A4678349B448FEB7C955256625194FA4EC683868461\n83E984B257D467345703666E6D668C3166DD7011671F6B3A6816621A59BB4E03\n51C46F0667D26C8F517668CB59476B6775665D0E81109F5065D7794879419A91\n8D775C824E5E4F01542F5951780C56686C148FC45F036C7D6CE38BAB63900000\nC7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000060706D3D72756266948E94C553438FC17B7E4EDF8C264E7E9ED494B194B3\n524D6F5C90636D458C3458115D4C6B206B4967AA545B81547F8C589985375F3A\n62A26A47953965726084686577A74E544FA85DE7979864AC7FD85CED4FCF7A8D\n520783044E14602F7A8394A64FB54EB279E6743452E482B964D279BD5BDD6C81\n97528F7B6C22503E537F6E0564CE66746C3060C598778BF75E86743C7A7779CB\n4E1890B174036C4256DA914B6CC58D8B533A86C666F28EAF5C489A716E200000\nC8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000053D65A369F8B8DA353BB570898A76743919B6CC9516875CA62F372AC5238\n529D7F3A7094763853749E4A69B7786E96C088D97FA4713671C3518967D374E4\n58E4651856B78BA9997662707ED560F970ED58EC4EC14EBA5FCD97E74EFB8BA4\n5203598A7EAB62544ECD65E5620E833884C98363878D71946EB65BB97ED25197\n63C967D480898339881551125B7A59828FB14E736C5D516589258F6F962E854A\n745E951095F06DA682E55F3164926D128428816E9CC3585E8D5B4E0953C10000\nC9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004F1E6563685155D34E2764149A9A626B5AC2745F82726DA968EE50E7838E\n7802674052396C997EB150BB5565715E7B5B665273CA82EB67495C715220717D\n886B95EA965564C58D6181B355846C5562477F2E58924F2455468D4F664C4E0A\n5C1A88F368A2634E7A0D70E7828D52FA97F65C1154E890B57ECD59628D4A86C7\n820C820D8D6664445C0461516D89793E8BBE78377533547B4F388EAB6DF15A20\n7EC5795E6C885BA15A76751A80BE614E6E1758F0751F7525727253477EF30000\nCA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000770176DB526980DC57235E08593172EE65BD6E7F8BD75C388671534177F3\n62FE65F64EC098DF86805B9E8BC653F277E24F7F5C4E9A7659CB5F0F793A58EB\n4E1667FF4E8B62ED8A93901D52BF662F55DC566C90024ED54F8D91CA99706C0F\n5E0260435BA489C68BD56536624B99965B885BFF6388552E53D77626517D852C\n67A268B36B8A62928F9353D482126DD1758F4E668D4E5B70719F85AF669166D9\n7F7287009ECD9F205C5E672F8FF06811675F620D7AD658855EB665706F310000\nCB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000060555237800D6454887075295E05681362F4971C53CC723D8C016C347761\n7A0E542E77AC987A821C8BF47855671470C165AF64955636601D79C153F84E1D\n6B7B80865BFA55E356DB4F3A4F3C99725DF3677E80386002988290015B8B8BBC\n8BF5641C825864DE55FD82CF91654FD77D20901F7C9F50F358516EAF5BBF8BC9\n80839178849C7B97867D968B968F7EE59AD3788E5C817A57904296A7795F5B59\n635F7B0B84D168AD55067F2974107D2295016240584C4ED65B83597958540000\nCC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000736D631E8E4B8E0F80CE82D462AC53F06CF0915E592A60016C70574D644A\n8D2A762B6EE9575B6A8075F06F6D8C2D8C0857666BEF889278B363A253F970AD\n6C645858642A580268E0819B55107CD650188EBA6DCC8D9F70EB638F6D9B6ED4\n7EE68404684390036DD896768BA85957727985E4817E75BC8A8A68AF52548E22\n951163D098988E44557C4F5366FF568F60D56D9552435C4959296DFB586B7530\n751C606C82148146631167618FE2773A8DF38D3494C15E165385542C70C30000\nCD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006C405EF7505C4EAD5EAD633A8247901A6850916E77B3540C94DC5F647AE5\n687663457B527EDF75DB507762955934900F51F879C37A8156FE5F9290146D82\n5C60571F541051546E4D56E263A89893817F8715892A9000541E5C6F81C062D6\n625881319E3596409A6E9A7C692D59A562D3553E631654C786D96D3C5A0374E6\n889C6B6A59168C4C5F2F6E7E73A9987D4E3870F75B8C7897633D665A769660CB\n5B9B5A494E0781556C6A738B4EA167897F515F8065FA671B5FD859845A010000\nCE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005DCD5FAE537197E68FDD684556F4552F60DF4E3A6F4D7EF482C7840E59D4\n4F1F4F2A5C3E7EAC672A851A5473754F80C355829B4F4F4D6E2D8C135C096170\n536B761F6E29868A658795FB7EB9543B7A337D0A95EE55E17FC174EE631D8717\n6DA17A9D621165A1536763E16C835DEB545C94A84E4C6C618BEC5C4B65E0829C\n68A7543E54346BCB6B664E9463425348821E4F0D4FAE575E620A96FE66647269\n52FF52A1609F8BEF661471996790897F785277FD6670563B54389521727A0000\nCF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007A00606F5E0C6089819D591560DC718470EF6EAA6C5072806A8488AD5E2D\n4E605AB3559C94E36D177CFB9699620F7EC6778E867E5323971E8F9666875CE1\n4FA072ED4E0B53A6590F54136380952851484ED99C9C7EA454B88D2488548237\n95F26D8E5F265ACC663E966973B0732E53BF817A99857FA15BAA967796507EBF\n76F853A2957699997BB189446E584E617FD479658BE660F354CD4EAB98795DF7\n6A6150CF54118C618427785D9704524A54EE56A395006D885BB56DC666530000\nD0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005C0F5B5D6821809655787B11654869544E9B6B47874E978B534F631F643A\n90AA659C80C18C10519968B0537887F961C86CC46CFB8C225C5185AA82AF950C\n6B238F9B65B05FFB5FC34FE18845661F8165732960FA51745211578B5F6290A2\n884C91925E78674F602759D3514451F680F853086C7996C4718A4F114FEE7F9E\n673D55C5950879C088967EE3589F620C9700865A5618987B5F908BB884C49157\n53D965ED5E8F755C60647D6E5A7F7EEA7EED8F6955A75BA360AC65CB73840000\nD1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009009766377297EDA9774859B5B667A7496EA884052CB718F5FAA65EC8BE2\n5BFB9A6F5DE16B896C5B8BAD8BAF900A8FC5538B62BC9E269E2D54404E2B82BD\n7259869C5D1688596DAF96C554D14E9A8BB6710954BD960970DF6DF976D04E25\n781487125CA95EF68A00989C960E708E6CBF594463A9773C884D6F1482735830\n71D5538C781A96C155015F6671305BB48C1A9A8C6B83592E9E2F79E76768626C\n4F6F75A17F8A6D0B96336C274EF075D2517B68376F3E90808170599674760000\nD2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000064475C2790657A918C2359DA54AC8200836F898180006930564E80367237\n91CE51B64E5F987563964E1A53F666F3814B591C6DB24E0058F9533B63D694F1\n4F9D4F0A886398905937905779FB4EEA80F075916C825B9C59E85F5D69058681\n501A5DF24E5977E34EE5827A6291661390915C794EBF5F7981C69038808475AB\n4EA688D4610F6BC55FC64E4976CA6EA28BE38BAE8C0A8BD15F027FFC7FCC7ECE\n8335836B56E06BB797F3963459FB541F94F66DEB5BC5996E5C395F1596900000\nD3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000537082F16A315A749E705E947F2883B984248425836787478FCE8D6276C8\n5F719896786C662054DF62E54F6381C375C85EB896CD8E0A86F9548F6CF36D8C\n6C38607F52C775285E7D4F1860A05FE75C24753190AE94C072B96CB96E389149\n670953CB53F34F5191C98BF153C85E7C8FC26DE44E8E76C26986865E611A8206\n4F594FDE903E9C7C61096E1D6E1496854E885A3196E84E0E5C7F79B95B878BED\n7FBD738957DF828B90C15401904755BB5CEA5FA161086B3272F180B28A890000\nD4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006D745BD388D598848C6B9A6D9E336E0A51A4514357A38881539F63F48F95\n56ED54585706733F6E907F188FDC82D1613F6028966266F07EA68D8A8DC394A5\n5CB37CA4670860A6960580184E9190E75300966851418FD08574915D665597F5\n5B55531D78386742683D54C9707E5BB08F7D518D572854B1651266828D5E8D43\n810F846C906D7CDF51FF85FB67A365E96FA186A48E81566A90207682707671E5\n8D2362E952196CFD8D3C600E589E618E66FE8D60624E55B36E23672D8F670000\nD5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000094E195F87728680569A8548B4E4D70B88BC86458658B5B857A84503A5BE8\n77BB6BE18A797C986CBE76CF65A98F975D2D5C5586386808536062187AD96E5B\n7EFD6A1F7AE05F706F335F20638C6DA867564E085E108D264ED780C07634969C\n62DB662D627E6CBC8D7571677F695146808753EC906E629854F286F08F998005\n951785178FD96D5973CD659F771F7504782781FB8D1E94884FA6679575B98BCA\n9707632F9547963584B8632377415F8172F04E896014657462EF6B63653F0000\nD6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005E2775C790D18BC1829D679D652F5431871877E580A281026C414E4B7EC7\n804C76F4690D6B966267503C4F84574063076B628DBE53EA65E87EB85FD7631A\n63B781F381F47F6E5E1C5CD95236667A79E97A1A8D28709975D46EDE6CBB7A92\n4E2D76C55FE0949F88777EC879CD80BF91CD4EF24F17821F54685DDE6D328BCC\n7CA58F7480985E1A549276B15B99663C9AA473E0682A86DB6731732A8BF88BDB\n90107AF970DB716E62C477A956314E3B845767F152A986C08D2E94F87B510000\nD7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004F4F6CE8795D9A7B6293722A62FD4E1378168F6C64B08D5A7BC668695E84\n88C55986649E58EE72B6690E95258FFD8D5857607F008C0651C6634962D95353\n684C74228301914C55447740707C6D4A517954A88D4459FF6ECB6DC45B5C7D2B\n4ED47C7D6ED35B5081EA6E0D5B579B0368D58E2A5B977EFC603B7EB590B98D70\n594F63CD79DF8DB3535265CF79568BC5963B7EC494BB7E825634918967007F6A\n5C0A907566285DE64F5067DE505A4F5C57505EA7000000000000000000000000\nD8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004E8D4E0C51404E105EFF53454E154E984E1E9B325B6C56694E2879BA4E3F\n53154E47592D723B536E6C1056DF80E499976BD3777E9F174E364E9F9F104E5C\n4E694E9382885B5B556C560F4EC4538D539D53A353A553AE97658D5D531A53F5\n5326532E533E8D5C5366536352025208520E522D5233523F5240524C525E5261\n525C84AF527D528252815290529351827F544EBB4EC34EC94EC24EE84EE14EEB\n4EDE4F1B4EF34F224F644EF54F254F274F094F2B4F5E4F6765384F5A4F5D0000\nD9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004F5F4F574F324F3D4F764F744F914F894F834F8F4F7E4F7B4FAA4F7C4FAC\n4F944FE64FE84FEA4FC54FDA4FE34FDC4FD14FDF4FF85029504C4FF3502C500F\n502E502D4FFE501C500C50255028507E504350555048504E506C507B50A550A7\n50A950BA50D6510650ED50EC50E650EE5107510B4EDD6C3D4F584F654FCE9FA0\n6C467C74516E5DFD9EC999985181591452F9530D8A07531051EB591951554EA0\n51564EB3886E88A44EB5811488D279805B3488037FB851AB51B151BD51BC0000\nDA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000051C7519651A251A58BA08BA68BA78BAA8BB48BB58BB78BC28BC38BCB8BCF\n8BCE8BD28BD38BD48BD68BD88BD98BDC8BDF8BE08BE48BE88BE98BEE8BF08BF3\n8BF68BF98BFC8BFF8C008C028C048C078C0C8C0F8C118C128C148C158C168C19\n8C1B8C188C1D8C1F8C208C218C258C278C2A8C2B8C2E8C2F8C328C338C358C36\n5369537A961D962296219631962A963D963C964296499654965F9667966C9672\n96749688968D969796B09097909B909D909990AC90A190B490B390B690BA0000\nDB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000090B890B090CF90C590BE90D090C490C790D390E690E290DC90D790DB90EB\n90EF90FE91049122911E91239131912F913991439146520D594252A252AC52AD\n52BE54FF52D052D652F053DF71EE77CD5EF451F551FC9B2F53B65F01755A5DEF\n574C57A957A1587E58BC58C558D15729572C572A57335739572E572F575C573B\n574257695785576B5786577C577B5768576D5776577357AD57A4578C57B257CF\n57A757B4579357A057D557D857DA57D957D257B857F457EF57F857E457DD0000\nDC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000580B580D57FD57ED5800581E5819584458205865586C58815889589A5880\n99A89F1961FF8279827D827F828F828A82A88284828E82918297829982AB82B8\n82BE82B082C882CA82E3829882B782AE82CB82CC82C182A982B482A182AA829F\n82C482CE82A482E1830982F782E4830F830782DC82F482D282D8830C82FB82D3\n8311831A83068314831582E082D5831C8351835B835C83088392833C83348331\n839B835E832F834F83478343835F834083178360832D833A8333836683650000\nDD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008368831B8369836C836A836D836E83B0837883B383B483A083AA8393839C\n8385837C83B683A9837D83B8837B8398839E83A883BA83BC83C1840183E583D8\n58078418840B83DD83FD83D6841C84388411840683D483DF840F840383F883F9\n83EA83C583C0842683F083E1845C8451845A8459847384878488847A84898478\n843C844684698476848C848E8431846D84C184CD84D084E684BD84D384CA84BF\n84BA84E084A184B984B4849784E584E3850C750D853884F08539851F853A0000\nDE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008556853B84FF84FC8559854885688564855E857A77A285438572857B85A4\n85A88587858F857985AE859C858585B985B785B085D385C185DC85FF86278605\n86298616863C5EFE5F08593C594180375955595A5958530F5C225C255C2C5C34\n624C626A629F62BB62CA62DA62D762EE632262F66339634B634363AD63F66371\n637A638E63B4636D63AC638A636963AE63BC63F263F863E063FF63C463DE63CE\n645263C663BE64456441640B641B6420640C64266421645E6484646D64960000\nDF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000647A64B764B8649964BA64C064D064D764E464E265096525652E5F0B5FD2\n75195F11535F53F153FD53E953E853FB541254165406544B5452545354545456\n54435421545754595423543254825494547754715464549A549B548454765466\n549D54D054AD54C254B454D254A754A654D354D4547254A354D554BB54BF54CC\n54D954DA54DC54A954AA54A454DD54CF54DE551B54E7552054FD551454F35522\n5523550F55115527552A5567558F55B55549556D55415555553F5550553C0000\nE0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005537555655755576557755335530555C558B55D2558355B155B955885581\n559F557E55D65591557B55DF55BD55BE5594559955EA55F755C9561F55D155EB\n55EC55D455E655DD55C455EF55E555F255F355CC55CD55E855F555E48F94561E\n5608560C56015624562355FE56005627562D565856395657562C564D56625659\n565C564C5654568656645671566B567B567C5685569356AF56D456D756DD56E1\n56F556EB56F956FF5704570A5709571C5E0F5E195E145E115E315E3B5E3C0000\nE1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005E375E445E545E5B5E5E5E615C8C5C7A5C8D5C905C965C885C985C995C91\n5C9A5C9C5CB55CA25CBD5CAC5CAB5CB15CA35CC15CB75CC45CD25CE45CCB5CE5\n5D025D035D275D265D2E5D245D1E5D065D1B5D585D3E5D345D3D5D6C5D5B5D6F\n5D5D5D6B5D4B5D4A5D695D745D825D995D9D8C735DB75DC55F735F775F825F87\n5F895F8C5F955F995F9C5FA85FAD5FB55FBC88625F6172AD72B072B472B772B8\n72C372C172CE72CD72D272E872EF72E972F272F472F7730172F3730372FA0000\nE2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000072FB731773137321730A731E731D7315732273397325732C733873317350\n734D73577360736C736F737E821B592598E7592459029963996799689969996A\n996B996C99749977997D998099849987998A998D999099919993999499955E80\n5E915E8B5E965EA55EA05EB95EB55EBE5EB38D535ED25ED15EDB5EE85EEA81BA\n5FC45FC95FD65FCF60035FEE60045FE15FE45FFE600560065FEA5FED5FF86019\n60356026601B600F600D6029602B600A603F602160786079607B607A60420000\nE3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000606A607D6096609A60AD609D60836092608C609B60EC60BB60B160DD60D8\n60C660DA60B4612061266115612360F46100610E612B614A617561AC619461A7\n61B761D461F55FDD96B395E995EB95F195F395F595F695FC95FE960396049606\n9608960A960B960C960D960F96129615961696179619961A4E2C723F62156C35\n6C546C5C6C4A6CA36C856C906C946C8C6C686C696C746C766C866CA96CD06CD4\n6CAD6CF76CF86CF16CD76CB26CE06CD66CFA6CEB6CEE6CB16CD36CEF6CFE0000\nE4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006D396D276D0C6D436D486D076D046D196D0E6D2B6D4D6D2E6D356D1A6D4F\n6D526D546D336D916D6F6D9E6DA06D5E6D936D946D5C6D606D7C6D636E1A6DC7\n6DC56DDE6E0E6DBF6DE06E116DE66DDD6DD96E166DAB6E0C6DAE6E2B6E6E6E4E\n6E6B6EB26E5F6E866E536E546E326E256E446EDF6EB16E986EE06F2D6EE26EA5\n6EA76EBD6EBB6EB76ED76EB46ECF6E8F6EC26E9F6F626F466F476F246F156EF9\n6F2F6F366F4B6F746F2A6F096F296F896F8D6F8C6F786F726F7C6F7A6FD10000\nE5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006FC96FA76FB96FB66FC26FE16FEE6FDE6FE06FEF701A7023701B70397035\n704F705E5B805B845B955B935BA55BB8752F9A9E64345BE45BEE89305BF08E47\n8B078FB68FD38FD58FE58FEE8FE48FE98FE68FF38FE890059004900B90269011\n900D9016902190359036902D902F9044905190529050906890589062905B66B9\n9074907D908290889083908B5F505F575F565F585C3B54AB5C505C595B715C63\n5C667FBC5F2A5F295F2D82745F3C9B3B5C6E59815983598D59A959AA59A30000\nE6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000599759CA59AB599E59A459D259B259AF59D759BE5A055A0659DD5A0859E3\n59D859F95A0C5A095A325A345A115A235A135A405A675A4A5A555A3C5A625A75\n80EC5AAA5A9B5A775A7A5ABE5AEB5AB25AD25AD45AB85AE05AE35AF15AD65AE6\n5AD85ADC5B095B175B165B325B375B405C155C1C5B5A5B655B735B515B535B62\n9A759A779A789A7A9A7F9A7D9A809A819A859A889A8A9A909A929A939A969A98\n9A9B9A9C9A9D9A9F9AA09AA29AA39AA59AA77E9F7EA17EA37EA57EA87EA90000\nE7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007EAD7EB07EBE7EC07EC17EC27EC97ECB7ECC7ED07ED47ED77EDB7EE07EE1\n7EE87EEB7EEE7EEF7EF17EF27F0D7EF67EFA7EFB7EFE7F017F027F037F077F08\n7F0B7F0C7F0F7F117F127F177F197F1C7F1B7F1F7F217F227F237F247F257F26\n7F277F2A7F2B7F2C7F2D7F2F7F307F317F327F337F355E7A757F5DDB753E9095\n738E739173AE73A2739F73CF73C273D173B773B373C073C973C873E573D9987C\n740A73E973E773DE73BA73F2740F742A745B7426742574287430742E742C0000\nE8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000741B741A7441745C7457745574597477746D747E749C748E748074817487\n748B749E74A874A9749074A774D274BA97EA97EB97EC674C6753675E67486769\n67A56787676A6773679867A7677567A8679E67AD678B6777677C67F0680967D8\n680A67E967B0680C67D967B567DA67B367DD680067C367B867E2680E67C167FD\n6832683368606861684E6862684468646883681D68556866684168676840683E\n684A6849682968B5688F687468776893686B68C2696E68FC691F692068F90000\nE9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000692468F0690B6901695768E369106971693969606942695D6984696B6980\n69986978693469CC6987698869CE6989696669636979699B69A769BB69AB69AD\n69D469B169C169CA69DF699569E0698D69FF6A2F69ED6A176A186A6569F26A44\n6A3E6AA06A506A5B6A356A8E6A796A3D6A286A586A7C6A916A906AA96A976AAB\n733773526B816B826B876B846B926B936B8D6B9A6B9B6BA16BAA8F6B8F6D8F71\n8F728F738F758F768F788F778F798F7A8F7C8F7E8F818F828F848F878F8B0000\nEA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008F8D8F8E8F8F8F988F9A8ECE620B6217621B621F6222622162256224622C\n81E774EF74F474FF750F75117513653465EE65EF65F0660A6619677266036615\n6600708566F7661D66346631663666358006665F66546641664F665666616657\n66776684668C66A7669D66BE66DB66DC66E666E98D328D338D368D3B8D3D8D40\n8D458D468D488D498D478D4D8D558D5989C789CA89CB89CC89CE89CF89D089D1\n726E729F725D7266726F727E727F7284728B728D728F72926308633263B00000\nEB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000643F64D880046BEA6BF36BFD6BF56BF96C056C076C066C0D6C156C186C19\n6C1A6C216C296C246C2A6C3265356555656B724D72527256723086625216809F\n809C809380BC670A80BD80B180AB80AD80B480B780E780E880E980EA80DB80C2\n80C480D980CD80D7671080DD80EB80F180F480ED810D810E80F280FC67158112\n8C5A8136811E812C811881328148814C815381748159815A817181608169817C\n817D816D8167584D5AB58188818281916ED581A381AA81CC672681CA81BB0000\nEC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000081C181A66B246B376B396B436B466B5998D198D298D398D598D998DA6BB3\n5F406BC289F365909F51659365BC65C665C465C365CC65CE65D265D67080709C\n7096709D70BB70C070B770AB70B170E870CA711071137116712F71317173715C\n716871457172714A7178717A719871B371B571A871A071E071D471E771F9721D\n7228706C7118716671B9623E623D624362486249793B794079467949795B795C\n7953795A796279577960796F7967797A7985798A799A79A779B35FD15FD00000\nED\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000603C605D605A606760416059606360AB6106610D615D61A9619D61CB61D1\n62068080807F6C936CF66DFC77F677F87800780978177818781165AB782D781C\n781D7839783A783B781F783C7825782C78237829784E786D7856785778267850\n7847784C786A789B7893789A7887789C78A178A378B278B978A578D478D978C9\n78EC78F2790578F479137924791E79349F9B9EF99EFB9EFC76F17704770D76F9\n77077708771A77227719772D7726773577387750775177477743775A77680000\nEE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000077627765777F778D777D7780778C7791779F77A077B077B577BD753A7540\n754E754B7548755B7572757975837F587F617F5F8A487F687F747F717F797F81\n7F7E76CD76E58832948594869487948B948A948C948D948F9490949494979495\n949A949B949C94A394A494AB94AA94AD94AC94AF94B094B294B494B694B794B8\n94B994BA94BC94BD94BF94C494C894C994CA94CB94CC94CD94CE94D094D194D2\n94D594D694D794D994D894DB94DE94DF94E094E294E494E594E794E894EA0000\nEF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000094E994EB94EE94EF94F394F494F594F794F994FC94FD94FF950395029506\n95079509950A950D950E950F951295139514951595169518951B951D951E951F\n9522952A952B9529952C953195329534953695379538953C953E953F95429535\n9544954595469549954C954E954F9552955395549556955795589559955B955E\n955F955D95619562956495659566956795689569956A956B956C956F95719572\n9573953A77E777EC96C979D579ED79E379EB7A065D477A037A027A1E7A140000\nF0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007A397A377A519ECF99A57A707688768E7693769976A474DE74E0752C9E20\n9E229E289E299E2A9E2B9E2C9E329E319E369E389E379E399E3A9E3E9E419E42\n9E449E469E479E489E499E4B9E4C9E4E9E519E559E579E5A9E5B9E5C9E5E9E63\n9E669E679E689E699E6A9E6B9E6C9E719E6D9E7375927594759675A0759D75AC\n75A375B375B475B875C475B175B075C375C275D675CD75E375E875E675E475EB\n75E7760375F175FC75FF761076007605760C7617760A76257618761576190000\nF1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000761B763C762276207640762D7630763F76357643763E7633764D765E7654\n765C7656766B766F7FCA7AE67A787A797A807A867A887A957AA67AA07AAC7AA8\n7AAD7AB3886488698872887D887F888288A288C688B788BC88C988E288CE88E3\n88E588F1891A88FC88E888FE88F0892189198913891B890A8934892B89368941\n8966897B758B80E576B276B477DC801280148016801C80208022802580268027\n802980288031800B803580438046804D80528069807189839878988098830000\nF2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009889988C988D988F9894989A989B989E989F98A198A298A598A6864D8654\n866C866E867F867A867C867B86A8868D868B86AC869D86A786A386AA869386A9\n86B686C486B586CE86B086BA86B186AF86C986CF86B486E986F186F286ED86F3\n86D0871386DE86F486DF86D886D18703870786F88708870A870D87098723873B\n871E8725872E871A873E87488734873187298737873F87828722877D877E877B\n87608770874C876E878B87538763877C876487598765879387AF87A887D20000\nF3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000087C68788878587AD8797878387AB87E587AC87B587B387CB87D387BD87D1\n87C087CA87DB87EA87E087EE8816881387FE880A881B88218839883C7F367F42\n7F447F4582107AFA7AFD7B087B037B047B157B0A7B2B7B0F7B477B387B2A7B19\n7B2E7B317B207B257B247B337B3E7B1E7B587B5A7B457B757B4C7B5D7B607B6E\n7B7B7B627B727B717B907BA67BA77BB87BAC7B9D7BA87B857BAA7B9C7BA27BAB\n7BB47BD17BC17BCC7BDD7BDA7BE57BE67BEA7C0C7BFE7BFC7C0F7C167C0B0000\nF4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007C1F7C2A7C267C387C417C4081FE82018202820481EC8844822182228223\n822D822F8228822B8238823B82338234823E82448249824B824F825A825F8268\n887E8885888888D888DF895E7F9D7F9F7FA77FAF7FB07FB27C7C65497C917C9D\n7C9C7C9E7CA27CB27CBC7CBD7CC17CC77CCC7CCD7CC87CC57CD77CE8826E66A8\n7FBF7FCE7FD57FE57FE17FE67FE97FEE7FF37CF87D777DA67DAE7E477E9B9EB8\n9EB48D738D848D948D918DB18D678D6D8C478C49914A9150914E914F91640000\nF5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009162916191709169916F917D917E917291749179918C91859190918D9191\n91A291A391AA91AD91AE91AF91B591B491BA8C559E7E8DB88DEB8E058E598E69\n8DB58DBF8DBC8DBA8DC48DD68DD78DDA8DDE8DCE8DCF8DDB8DC68DEC8DF78DF8\n8DE38DF98DFB8DE48E098DFD8E148E1D8E1F8E2C8E2E8E238E2F8E3A8E408E39\n8E358E3D8E318E498E418E428E518E528E4A8E708E768E7C8E6F8E748E858E8F\n8E948E908E9C8E9E8C788C828C8A8C858C988C94659B89D689DE89DA89DC0000\nF6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000089E589EB89EF8A3E8B26975396E996F396EF970697019708970F970E972A\n972D9730973E9F809F839F859F869F879F889F899F8A9F8C9EFE9F0B9F0D96B9\n96BC96BD96CE96D277BF96E0928E92AE92C8933E936A93CA938F943E946B9C7F\n9C829C859C869C879C887A239C8B9C8E9C909C919C929C949C959C9A9C9B9C9E\n9C9F9CA09CA19CA29CA39CA59CA69CA79CA89CA99CAB9CAD9CAE9CB09CB19CB2\n9CB39CB49CB59CB69CB79CBA9CBB9CBC9CBD9CC49CC59CC69CC79CCA9CCB0000\nF7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009CCC9CCD9CCE9CCF9CD09CD39CD49CD59CD79CD89CD99CDC9CDD9CDF9CE2\n977C978597919792979497AF97AB97A397B297B49AB19AB09AB79E589AB69ABA\n9ABC9AC19AC09AC59AC29ACB9ACC9AD19B459B439B479B499B489B4D9B5198E8\n990D992E995599549ADF9AE19AE69AEF9AEB9AFB9AED9AF99B089B0F9B139B1F\n9B239EBD9EBE7E3B9E829E879E889E8B9E9293D69E9D9E9F9EDB9EDC9EDD9EE0\n9EDF9EE29EE99EE79EE59EEA9EEF9F229F2C9F2F9F399F379F3D9F3E9F440000\n",
		"/encoding/euc-jp.enc":                     "# Encoding file: euc-jp, multi-byte\nM\n003F 0 79\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n0080008100820083008400850086008700880089008A008B008C008D0000008F\n0090009100920093009400950096009700980099009A009B009C009D009E009F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n8E\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000FF61FF62FF63FF64FF65FF66FF67FF68FF69FF6AFF6BFF6CFF6DFF6EFF6F\nFF70FF71FF72FF73FF74FF75FF76FF77FF78FF79FF7AFF7BFF7CFF7DFF7EFF7F\nFF80FF81FF82FF83FF84FF85FF86FF87FF88FF89FF8AFF8BFF8CFF8DFF8EFF8F\nFF90FF91FF92FF93FF94FF95FF96FF97FF98FF99FF9AFF9BFF9CFF9DFF9EFF9F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000300030013002FF0CFF0E30FBFF1AFF1BFF1FFF01309B309C00B4FF4000A8\nFF3EFFE3FF3F30FD30FE309D309E30034EDD30053006300730FC20152010FF0F\nFF3C301C2016FF5C2026202520182019201C201DFF08FF0930143015FF3BFF3D\nFF5BFF5D30083009300A300B300C300D300E300F30103011FF0B221200B100D7\n00F7FF1D2260FF1CFF1E22662267221E22342642264000B0203220332103FFE5\nFF0400A200A3FF05FF03FF06FF0AFF2000A72606260525CB25CF25CE25C70000\nA2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000025C625A125A025B325B225BD25BC203B3012219221902191219330130000\n00000000000000000000000000000000000000002208220B2286228722822283\n222A2229000000000000000000000000000000002227222800AC21D221D42200\n220300000000000000000000000000000000000000000000222022A523122202\n220722612252226A226B221A223D221D2235222B222C00000000000000000000\n00000000212B2030266F266D266A2020202100B6000000000000000025EF0000\nA3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nFF10FF11FF12FF13FF14FF15FF16FF17FF18FF19000000000000000000000000\n0000FF21FF22FF23FF24FF25FF26FF27FF28FF29FF2AFF2BFF2CFF2DFF2EFF2F\nFF30FF31FF32FF33FF34FF35FF36FF37FF38FF39FF3A00000000000000000000\n0000FF41FF42FF43FF44FF45FF46FF47FF48FF49FF4AFF4BFF4CFF4DFF4EFF4F\nFF50FF51FF52FF53FF54FF55FF56FF57FF58FF59FF5A00000000000000000000\nA4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000304130423043304430453046304730483049304A304B304C304D304E304F\n3050305130523053305430553056305730583059305A305B305C305D305E305F\n3060306130623063306430653066306730683069306A306B306C306D306E306F\n3070307130723073307430753076307730783079307A307B307C307D307E307F\n3080308130823083308430853086308730883089308A308B308C308D308E308F\n3090309130923093000000000000000000000000000000000000000000000000\nA5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000030A130A230A330A430A530A630A730A830A930AA30AB30AC30AD30AE30AF\n30B030B130B230B330B430B530B630B730B830B930BA30BB30BC30BD30BE30BF\n30C030C130C230C330C430C530C630C730C830C930CA30CB30CC30CD30CE30CF\n30D030D130D230D330D430D530D630D730D830D930DA30DB30DC30DD30DE30DF\n30E030E130E230E330E430E530E630E730E830E930EA30EB30EC30ED30EE30EF\n30F030F130F230F330F430F530F6000000000000000000000000000000000000\nA6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000039103920393039403950396039703980399039A039B039C039D039E039F\n03A003A103A303A403A503A603A703A803A90000000000000000000000000000\n000003B103B203B303B403B503B603B703B803B903BA03BB03BC03BD03BE03BF\n03C003C103C303C403C503C603C703C803C90000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000004100411041204130414041504010416041704180419041A041B041C041D\n041E041F0420042104220423042404250426042704280429042A042B042C042D\n042E042F00000000000000000000000000000000000000000000000000000000\n000004300431043204330434043504510436043704380439043A043B043C043D\n043E043F0440044104420443044404450446044704480449044A044B044C044D\n044E044F00000000000000000000000000000000000000000000000000000000\nA8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000025002502250C251025182514251C252C25242534253C25012503250F2513\n251B251725232533252B253B254B2520252F25282537253F251D253025252538\n2542000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nB0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004E9C55165A03963F54C0611B632859F690228475831C7A5060AA63E16E25\n65ED846682A69BF56893572765A162715B9B59D0867B98F47D627DBE9B8E6216\n7C9F88B75B895EB563096697684895C7978D674F4EE54F0A4F4D4F9D504956F2\n593759D45A015C0960DF610F61706613690570BA754F757079FB7DAD7DEF80C3\n840E88638B029055907A533B4E954EA557DF80B290C178EF4E0058F16EA29038\n7A328328828B9C2F5141537054BD54E156E059FB5F1598F26DEB80E4852D0000\nB1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009662967096A097FB540B53F35B8770CF7FBD8FC296E8536F9D5C7ABA4E11\n789381FC6E26561855046B1D851A9C3B59E553A96D6674DC958F56424E91904B\n96F2834F990C53E155B65B305F71662066F368046C386CF36D29745B76C87A4E\n983482F1885B8A6092ED6DB275AB76CA99C560A68B018D8A95B2698E53AD5186\n5712583059445BB45EF6602863A963F46CBF6F14708E7114715971D5733F7E01\n827682D185979060925B9D1B586965BC6C5A752551F9592E59655F805FDC0000\nB2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000062BC65FA6A2A6B276BB4738B7FC189569D2C9D0E9EC45CA16C96837B5104\n5C4B61B681C6687672614E594FFA537860696E297A4F97F34E0B53164EEE4F55\n4F3D4FA14F7352A053EF5609590F5AC15BB65BE179D16687679C67B66B4C6CB3\n706B73C2798D79BE7A3C7B8782B182DB8304837783EF83D387668AB256298CA8\n8FE6904E971E868A4FC45CE862117259753B81E582BD86FE8CC096C5991399D5\n4ECB4F1A89E356DE584A58CA5EFB5FEB602A6094606261D0621262D065390000\nB3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009B41666668B06D777070754C76867D7582A587F9958B968E8C9D51F152BE\n591654B35BB35D16616869826DAF788D84CB88578A7293A79AB86D6C99A886D9\n57A367FF86CE920E5283568754045ED362E164B9683C68386BBB737278BA7A6B\n899A89D28D6B8F0390ED95A3969497695B665CB3697D984D984E639B7B206A2B\n6A7F68B69C0D6F5F5272559D607062EC6D3B6E076ED1845B89108F444E149C39\n53F6691B6A3A9784682A515C7AC384B291DC938C565B9D286822830584310000\nB4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007CA5520882C574E64E7E4F8351A05BD2520A52D852E75DFB559A582A59E6\n5B8C5B985BDB5E725E7960A3611F616361BE63DB656267D1685368FA6B3E6B53\n6C576F226F976F4574B0751876E3770B7AFF7BA17C217DE97F367FF0809D8266\n839E89B38ACC8CAB908494519593959195A2966597D3992882184E38542B5CB8\n5DCC73A9764C773C5CA97FEB8D0B96C19811985498584F014F0E5371559C5668\n57FA59475B095BC45C905E0C5E7E5FCC63EE673A65D765E2671F68CB68C40000\nB5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006A5F5E306BC56C176C7D757F79485B637A007D005FBD898F8A188CB48D77\n8ECC8F1D98E29A0E9B3C4E80507D510059935B9C622F628064EC6B3A72A07591\n79477FA987FB8ABC8B7063AC83CA97A05409540355AB68546A588A7078276775\n9ECD53745BA2811A865090064E184E454EC74F1153CA54385BAE5F1360256551\n673D6C426C726CE3707874037A767AAE7B087D1A7CFE7D6665E7725B53BB5C45\n5DE862D262E063196E20865A8A318DDD92F86F0179A69B5A4EA84EAB4EAC0000\nB6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00004F9B4FA050D151477AF6517151F653545321537F53EB55AC58835CE15F37\n5F4A602F6050606D631F65596A4B6CC172C272ED77EF80F881058208854E90F7\n93E197FF99579A5A4EF051DD5C2D6681696D5C4066F26975738968507C8150C5\n52E457475DFE932665A46B236B3D7434798179BD7B4B7DCA82B983CC887F895F\n8B398FD191D1541F92804E5D503653E5533A72D7739677E982E68EAF99C699C8\n99D25177611A865E55B07A7A50765BD3904796854E326ADB91E75C515C480000\nB7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000063987A9F6C9397748F617AAA718A96887C8268177E706851936C52F2541B\n85AB8A137FA48ECD90E15366888879414FC250BE521151445553572D73EA578B\n59515F625F8460756176616761A963B2643A656C666F68426E1375667A3D7CFB\n7D4C7D997E4B7F6B830E834A86CD8A088A638B668EFD981A9D8F82B88FCE9BE8\n5287621F64836FC09699684150916B206C7A6F547A747D5088408A2367084EF6\n503950265065517C5238526355A7570F58055ACC5EFA61B261F862F363720000\nB8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000691C6A29727D72AC732E7814786F7D79770C80A9898B8B198CE28ED29063\n9375967A98559A139E785143539F53B35E7B5F266E1B6E90738473FE7D438237\n8A008AFA96504E4E500B53E4547C56FA59D15B645DF15EAB5F276238654567AF\n6E5672D07CCA88B480A180E183F0864E8A878DE8923796C798679F134E944E92\n4F0D53485449543E5A2F5F8C5FA1609F68A76A8E745A78818A9E8AA48B779190\n4E5E9BC94EA44F7C4FAF501950165149516C529F52B952FE539A53E354110000\nB9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000540E5589575157A2597D5B545B5D5B8F5DE55DE75DF75E785E835E9A5EB7\n5F186052614C629762D863A7653B6602664366F4676D6821689769CB6C5F6D2A\n6D696E2F6E9D75327687786C7A3F7CE07D057D187D5E7DB18015800380AF80B1\n8154818F822A8352884C88618B1B8CA28CFC90CA91759271783F92FC95A4964D\n980599999AD89D3B525B52AB53F7540858D562F76FE08C6A8F5F9EB9514B523B\n544A56FD7A4091779D609ED273446F09817075115FFD60DA9AA872DB8FBC0000\nBA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006B6498034ECA56F0576458BE5A5A606861C7660F6606683968B16DF775D5\n7D3A826E9B424E9B4F5053C955065D6F5DE65DEE67FB6C99747378028A509396\n88DF57505EA7632B50B550AC518D670054C9585E59BB5BB05F69624D63A1683D\n6B736E08707D91C7728078157826796D658E7D3083DC88C18F09969B52645728\n67507F6A8CA151B45742962A583A698A80B454B25D0E57FC78959DFA4F5C524A\n548B643E6628671467F57A847B567D22932F685C9BAD7B395319518A52370000\nBB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005BDF62F664AE64E6672D6BBA85A996D176909BD6634C93069BAB76BF6652\n4E09509853C25C7160E864926563685F71E673CA75237B977E8286958B838CDB\n9178991065AC66AB6B8B4ED54ED44F3A4F7F523A53F853F255E356DB58EB59CB\n59C959FF5B505C4D5E025E2B5FD7601D6307652F5B5C65AF65BD65E8679D6B62\n6B7B6C0F7345794979C17CF87D197D2B80A2810281F389968A5E8A698A668A8C\n8AEE8CC78CDC96CC98FC6B6F4E8B4F3C4F8D51505B575BFA6148630166420000\nBC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006B216ECB6CBB723E74BD75D478C1793A800C803381EA84948F9E6C509E7F\n5F0F8B589D2B7AFA8EF85B8D96EB4E0353F157F759315AC95BA460896E7F6F06\n75BE8CEA5B9F85007BE0507267F4829D5C61854A7E1E820E51995C0463688D66\n659C716E793E7D1780058B1D8ECA906E86C790AA501F52FA5C3A6753707C7235\n914C91C8932B82E55BC25F3160F94E3B53D65B88624B67316B8A72E973E07A2E\n816B8DA391529996511253D7546A5BFF63886A397DAC970056DA53CE54680000\nBD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005B975C315DDE4FEE610162FE6D3279C079CB7D427E4D7FD281ED821F8490\n884689728B908E748F2F9031914B916C96C6919C4EC04F4F514553415F93620E\n67D46C416E0B73637E2691CD928353D459195BBF6DD1795D7E2E7C9B587E719F\n51FA88538FF04FCA5CFB662577AC7AE3821C99FF51C65FAA65EC696F6B896DF3\n6E966F6476FE7D145DE190759187980651E6521D6240669166D96E1A5EB67DD2\n7F7266F885AF85F78AF852A953D959735E8F5F90605592E4966450B7511F0000\nBE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000052DD5320534753EC54E8554655315617596859BE5A3C5BB55C065C0F5C11\n5C1A5E845E8A5EE05F70627F628462DB638C63776607660C662D6676677E68A2\n6A1F6A356CBC6D886E096E58713C7126716775C77701785D7901796579F07AE0\n7B117CA77D39809683D6848B8549885D88F38A1F8A3C8A548A738C618CDE91A4\n9266937E9418969C97984E0A4E084E1E4E575197527057CE583458CC5B225E38\n60C564FE676167566D4472B675737A6384B88B7291B89320563157F498FE0000\nBF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000062ED690D6B9671ED7E548077827289E698DF87558FB15C3B4F384FE14FB5\n55075A205BDD5BE95FC3614E632F65B0664B68EE699B6D786DF1753375B9771F\n795E79E67D3381E382AF85AA89AA8A3A8EAB8F9B903291DD97074EBA4EC15203\n587558EC5C0B751A5C3D814E8A0A8FC59663976D7B258ACF9808916256F353A8\n9017543957825E2563A86C34708A77617C8B7FE088709042915493109318968F\n745E9AC45D075D69657067A28DA896DB636E6749691983C5981796C088FE0000\nC0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006F84647A5BF84E16702C755D662F51C4523652E259D35F8160276210653F\n6574661F667468F268166B636E057272751F76DB7CBE805658F088FD897F8AA0\n8A938ACB901D91929752975965897A0E810696BB5E2D60DC621A65A566146790\n77F37A4D7C4D7E3E810A8CAC8D648DE18E5F78A9520762D963A5644262988A2D\n7A837BC08AAC96EA7D76820C87494ED95148534353605BA35C025C165DDD6226\n624764B0681368346CC96D456D1767D36F5C714E717D65CB7A7F7BAD7DDA0000\nC1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007E4A7FA8817A821B823985A68A6E8CCE8DF59078907792AD929195839BAE\n524D55846F387136516879857E5581B37CCE564C58515CA863AA66FE66FD695A\n72D9758F758E790E795679DF7C977D207D4486078A34963B90619F2050E75275\n53CC53E2500955AA58EE594F723D5B8B5C64531D60E360F3635C6383633F63BB\n64CD65E966F95DE369CD69FD6F1571E54E8975E976F87A937CDF7DCF7D9C8061\n83498358846C84BC85FB88C58D709001906D9397971C9A1250CF5897618E0000\nC2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000081D385358D0890204FC3507452475373606F6349675F6E2C8DB3901F4FD7\n5C5E8CCA65CF7D9A53528896517663C35B585B6B5C0A640D6751905C4ED6591A\n592A6C708A51553E581559A560F0625367C182356955964099C49A284F535806\n5BFE80105CB15E2F5F856020614B623466FF6CF06EDE80CE817F82D4888B8CB8\n9000902E968A9EDB9BDB4EE353F059277B2C918D984C9DF96EDD702753535544\n5B856258629E62D36CA26FEF74228A1794386FC18AFE833851E786F853EA0000\nC3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000053E94F4690548FB0596A81315DFD7AEA8FBF68DA8C3772F89C486A3D8AB0\n4E3953585606576662C563A265E66B4E6DE16E5B70AD77ED7AEF7BAA7DBB803D\n80C686CB8A95935B56E358C75F3E65AD66966A806BB575378AC7502477E55730\n5F1B6065667A6C6075F47A1A7F6E81F48718904599B37BC9755C7AF97B5184C4\n901079E97A9283365AE177404E2D4EF25B995FE062BD663C67F16CE8866B8877\n8A3B914E92F399D06A177026732A82E784578CAF4E01514651CB558B5BF50000\nC4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005E165E335E815F145F355F6B5FB461F2631166A2671D6F6E7252753A773A\n80748139817887768ABF8ADC8D858DF3929A957798029CE552C5635776F46715\n6C8873CD8CC393AE96736D25589C690E69CC8FFD939A75DB901A585A680263B4\n69FB4F436F2C67D88FBB85267DB49354693F6F70576A58F75B2C7D2C722A540A\n91E39DB44EAD4F4E505C507552438C9E544858245B9A5E1D5E955EAD5EF75F1F\n608C62B5633A63D068AF6C407887798E7A0B7DE082478A028AE68E4490130000\nC5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000090B8912D91D89F0E6CE5645864E265756EF476847B1B906993D16EBA54F2\n5FB964A48F4D8FED92445178586B59295C555E976DFB7E8F751C8CBC8EE2985B\n70B94F1D6BBF6FB1753096FB514E54105835585759AC5C605F926597675C6E21\n767B83DF8CED901490FD934D7825783A52AA5EA6571F597460125012515A51AC\n51CD520055105854585859575B955CF65D8B60BC6295642D6771684368BC68DF\n76D76DD86E6F6D9B706F71C85F5375D879777B497B547B527CD67D7152300000\nC6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008463856985E48A0E8B048C468E0F9003900F94199676982D9A3095D850CD\n52D5540C58025C0E61A7649E6D1E77B37AE580F48404905392855CE09D07533F\n5F975FB36D9C7279776379BF7BE46BD272EC8AAD68036A6151F87A8169345C4A\n9CF682EB5BC59149701E56785C6F60C765666C8C8C5A90419813545166C7920D\n594890A351854E4D51EA85998B0E7058637A934B696299B47E04757753576960\n8EDF96E36C5D4E8C5C3C5F108FE953028CD1808986795EFF65E54E7351650000\nC7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000059825C3F97EE4EFB598A5FCD8A8D6FE179B079625BE78471732B71B15E74\n5FF5637B649A71C37C984E435EFC4E4B57DC56A260A96FC37D0D80FD813381BF\n8FB2899786A45DF4628A64AD898767776CE26D3E743678345A467F7582AD99AC\n4FF35EC362DD63926557676F76C3724C80CC80BA8F29914D500D57F95A926885\n6973716472FD8CB758F28CE0966A9019877F79E477E784294F2F5265535A62CD\n67CF6CCA767D7B947C95823685848FEB66DD6F2072067E1B83AB99C19EA60000\nC8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000051FD7BB178727BB880877B486AE85E61808C75517560516B92626E8C767A\n91979AEA4F107F70629C7B4F95A59CE9567A585986E496BC4F345224534A53CD\n53DB5E06642C6591677F6C3E6C4E724872AF73ED75547E41822C85E98CA97BC4\n91C67169981298EF633D6669756A76E478D0854386EE532A5351542659835E87\n5F7C60B26249627962AB65906BD46CCC75B276AE789179D87DCB7F7780A588AB\n8AB98CBB907F975E98DB6A0B7C3850995C3E5FAE67876BD8743577097F8E0000\nC9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009F3B67CA7A175339758B9AED5F66819D83F180985F3C5FC575627B46903C\n686759EB5A9B7D10767E8B2C4FF55F6A6A196C376F0274E2796888688A558C79\n5EDF63CF75C579D282D7932892F2849C86ED9C2D54C15F6C658C6D5C70158CA7\n8CD3983B654F74F64E0D4ED857E0592B5A665BCC51A85E035E9C601662766577\n65A7666E6D6E72367B268150819A82998B5C8CA08CE68D74961C96444FAE64AB\n6B66821E8461856A90E85C01695398A8847A85574F0F526F5FA95E45670D0000\nCA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000798F8179890789866DF55F1762556CB84ECF72699B925206543B567458B3\n61A4626E711A596E7C897CDE7D1B96F06587805E4E194F75517558405E635E73\n5F0A67C44E26853D9589965B7C73980150FB58C1765678A7522577A585117B86\n504F590972477BC77DE88FBA8FD4904D4FBF52C95A295F0197AD4FDD821792EA\n570363556B69752B88DC8F147A4252DF58936155620A66AE6BCD7C3F83E95023\n4FF853055446583159495B9D5CF05CEF5D295E9662B16367653E65B9670B0000\nCB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006CD56CE170F978327E2B80DE82B3840C84EC870289128A2A8C4A90A692D2\n98FD9CF39D6C4E4F4EA1508D5256574A59A85E3D5FD85FD9623F66B4671B67D0\n68D251927D2180AA81A88B008C8C8CBF927E96325420982C531750D5535C58A8\n64B26734726777667A4691E652C36CA16B8658005E4C5954672C7FFB51E176C6\n646978E89B549EBB57CB59B96627679A6BCE54E969D95E55819C67959BAA67FE\n9C52685D4EA64FE353C862B9672B6CAB8FC44FAD7E6D9EBF4E0761626E800000\nCC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006F2B85135473672A9B455DF37B955CAC5BC6871C6E4A84D17A1481085999\n7C8D6C11772052D959227121725F77DB97279D61690B5A7F5A1851A5540D547D\n660E76DF8FF792989CF459EA725D6EC5514D68C97DBF7DEC97629EBA64786A21\n830259845B5F6BDB731B76F27DB280178499513267289ED976EE676252FF9905\n5C24623B7C7E8CB0554F60B67D0B958053014E5F51B6591C723A803691CE5F25\n77E253845F797D0485AC8A338E8D975667F385AE9453610961086CB976520000\nCD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008AED8F38552F4F51512A52C753CB5BA55E7D60A0618263D6670967DA6E67\n6D8C733673377531795088D58A98904A909190F596C4878D59154E884F594E0E\n8A898F3F981050AD5E7C59965BB95EB863DA63FA64C166DC694A69D86D0B6EB6\n719475287AAF7F8A8000844984C989818B218E0A9065967D990A617E62916B32\n6C836D747FCC7FFC6DC07F8587BA88F8676583B1983C96F76D1B7D61843D916A\n4E7153755D506B046FEB85CD862D89A75229540F5C65674E68A8740674830000\nCE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000075E288CF88E191CC96E296785F8B73877ACB844E63A0756552896D416E9C\n74097559786B7C9296867ADC9F8D4FB6616E65C5865C4E864EAE50DA4E2151CC\n5BEE659968816DBC731F764277AD7A1C7CE7826F8AD2907C91CF96759818529B\n7DD1502B539867976DCB71D0743381E88F2A96A39C579E9F746058416D997D2F\n985E4EE44F364F8B51B752B15DBA601C73B2793C82D3923496B796F6970A9E97\n9F6266A66B74521752A370C888C25EC9604B61906F2371497C3E7DF4806F0000\nCF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000084EE9023932C54429B6F6AD370898CC28DEF973252B45A415ECA5F046717\n697C69946D6A6F0F726272FC7BED8001807E874B90CE516D9E937984808B9332\n8AD6502D548C8A716B6A8CC4810760D167A09DF24E994E989C108A6B85C18568\n69006E7E78978155000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nD0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005F0C4E104E154E2A4E314E364E3C4E3F4E424E564E584E824E858C6B4E8A\n82125F0D4E8E4E9E4E9F4EA04EA24EB04EB34EB64ECE4ECD4EC44EC64EC24ED7\n4EDE4EED4EDF4EF74F094F5A4F304F5B4F5D4F574F474F764F884F8F4F984F7B\n4F694F704F914F6F4F864F9651184FD44FDF4FCE4FD84FDB4FD14FDA4FD04FE4\n4FE5501A50285014502A502550054F1C4FF650215029502C4FFE4FEF50115006\n504350476703505550505048505A5056506C50785080509A508550B450B20000\nD1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000050C950CA50B350C250D650DE50E550ED50E350EE50F950F5510951015102\n511651155114511A5121513A5137513C513B513F51405152514C515451627AF8\n5169516A516E5180518256D8518C5189518F519151935195519651A451A651A2\n51A951AA51AB51B351B151B251B051B551BD51C551C951DB51E0865551E951ED\n51F051F551FE5204520B5214520E5227522A522E52335239524F5244524B524C\n525E5254526A527452695273527F527D528D529452925271528852918FA80000\nD2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008FA752AC52AD52BC52B552C152CD52D752DE52E352E698ED52E052F352F5\n52F852F9530653087538530D5310530F5315531A5323532F5331533353385340\n534653454E175349534D51D6535E5369536E5918537B53775382539653A053A6\n53A553AE53B053B653C37C1296D953DF66FC71EE53EE53E853ED53FA5401543D\n5440542C542D543C542E54365429541D544E548F5475548E545F547154775470\n5492547B5480547654845490548654C754A254B854A554AC54C454C854A80000\nD3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000054AB54C254A454BE54BC54D854E554E6550F551454FD54EE54ED54FA54E2\n553955405563554C552E555C55455556555755385533555D5599558054AF558A\n559F557B557E5598559E55AE557C558355A9558755A855DA55C555DF55C455DC\n55E455D4561455F7561655FE55FD561B55F9564E565071DF5634563656325638\n566B5664562F566C566A56865680568A56A05694568F56A556AE56B656B456C2\n56BC56C156C356C056C856CE56D156D356D756EE56F9570056FF570457090000\nD4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005708570B570D57135718571655C7571C572657375738574E573B5740574F\n576957C057885761577F5789579357A057B357A457AA57B057C357C657D457D2\n57D3580A57D657E3580B5819581D587258215862584B58706BC05852583D5879\n588558B9589F58AB58BA58DE58BB58B858AE58C558D358D158D758D958D858E5\n58DC58E458DF58EF58FA58F958FB58FC58FD5902590A5910591B68A65925592C\n592D59325938593E7AD259555950594E595A5958596259605967596C59690000\nD5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000059785981599D4F5E4FAB59A359B259C659E859DC598D59D959DA5A255A1F\n5A115A1C5A095A1A5A405A6C5A495A355A365A625A6A5A9A5ABC5ABE5ACB5AC2\n5ABD5AE35AD75AE65AE95AD65AFA5AFB5B0C5B0B5B165B325AD05B2A5B365B3E\n5B435B455B405B515B555B5A5B5B5B655B695B705B735B755B7865885B7A5B80\n5B835BA65BB85BC35BC75BC95BD45BD05BE45BE65BE25BDE5BE55BEB5BF05BF6\n5BF35C055C075C085C0D5C135C205C225C285C385C395C415C465C4E5C530000\nD6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005C505C4F5B715C6C5C6E4E625C765C795C8C5C915C94599B5CAB5CBB5CB6\n5CBC5CB75CC55CBE5CC75CD95CE95CFD5CFA5CED5D8C5CEA5D0B5D155D175D5C\n5D1F5D1B5D115D145D225D1A5D195D185D4C5D525D4E5D4B5D6C5D735D765D87\n5D845D825DA25D9D5DAC5DAE5DBD5D905DB75DBC5DC95DCD5DD35DD25DD65DDB\n5DEB5DF25DF55E0B5E1A5E195E115E1B5E365E375E445E435E405E4E5E575E54\n5E5F5E625E645E475E755E765E7A9EBC5E7F5EA05EC15EC25EC85ED05ECF0000\nD7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00005ED65EE35EDD5EDA5EDB5EE25EE15EE85EE95EEC5EF15EF35EF05EF45EF8\n5EFE5F035F095F5D5F5C5F0B5F115F165F295F2D5F385F415F485F4C5F4E5F2F\n5F515F565F575F595F615F6D5F735F775F835F825F7F5F8A5F885F915F875F9E\n5F995F985FA05FA85FAD5FBC5FD65FFB5FE45FF85FF15FDD60B35FFF60216060\n601960106029600E6031601B6015602B6026600F603A605A6041606A6077605F\n604A6046604D6063604360646042606C606B60596081608D60E76083609A0000\nD8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006084609B60966097609260A7608B60E160B860E060D360B45FF060BD60C6\n60B560D8614D6115610660F660F7610060F460FA6103612160FB60F1610D610E\n6147613E61286127614A613F613C612C6134613D614261446173617761586159\n615A616B6174616F61656171615F615D6153617561996196618761AC6194619A\n618A619161AB61AE61CC61CA61C961F761C861C361C661BA61CB7F7961CD61E6\n61E361F661FA61F461FF61FD61FC61FE620062086209620D620C6214621B0000\nD9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000621E6221622A622E6230623262336241624E625E6263625B62606268627C\n62826289627E62926293629662D46283629462D762D162BB62CF62FF62C664D4\n62C862DC62CC62CA62C262C7629B62C9630C62EE62F163276302630862EF62F5\n6350633E634D641C634F6396638E638063AB637663A3638F6389639F63B5636B\n636963BE63E963C063C663E363C963D263F663C4641664346406641364266436\n651D64176428640F6467646F6476644E652A6495649364A564A9648864BC0000\nDA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000064DA64D264C564C764BB64D864C264F164E7820964E064E162AC64E364EF\n652C64F664F464F264FA650064FD6518651C650565246523652B653465356537\n65366538754B654865566555654D6558655E655D65726578658265838B8A659B\n659F65AB65B765C365C665C165C465CC65D265DB65D965E065E165F16772660A\n660365FB6773663566366634661C664F664466496641665E665D666466676668\n665F6662667066836688668E668966846698669D66C166B966C966BE66BC0000\nDB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000066C466B866D666DA66E0663F66E666E966F066F566F7670F6716671E6726\n67279738672E673F67366741673867376746675E676067596763676467896770\n67A9677C676A678C678B67A667A1678567B767EF67B467EC67B367E967B867E4\n67DE67DD67E267EE67B967CE67C667E76A9C681E684668296840684D6832684E\n68B3682B685968636877687F689F688F68AD6894689D689B68836AAE68B96874\n68B568A068BA690F688D687E690168CA690868D86922692668E1690C68CD0000\nDC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000068D468E768D569366912690468D768E3692568F968E068EF6928692A691A\n6923692168C669796977695C6978696B6954697E696E69396974693D69596930\n6961695E695D6981696A69B269AE69D069BF69C169D369BE69CE5BE869CA69DD\n69BB69C369A76A2E699169A0699C699569B469DE69E86A026A1B69FF6B0A69F9\n69F269E76A0569B16A1E69ED6A1469EB6A0A6A126AC16A236A136A446A0C6A72\n6A366A786A476A626A596A666A486A386A226A906A8D6AA06A846AA26AA30000\nDD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006A9786176ABB6AC36AC26AB86AB36AAC6ADE6AD16ADF6AAA6ADA6AEA6AFB\n6B0586166AFA6B126B169B316B1F6B386B3776DC6B3998EE6B476B436B496B50\n6B596B546B5B6B5F6B616B786B796B7F6B806B846B836B8D6B986B956B9E6BA4\n6BAA6BAB6BAF6BB26BB16BB36BB76BBC6BC66BCB6BD36BDF6BEC6BEB6BF36BEF\n9EBE6C086C136C146C1B6C246C236C5E6C556C626C6A6C826C8D6C9A6C816C9B\n6C7E6C686C736C926C906CC46CF16CD36CBD6CD76CC56CDD6CAE6CB16CBE0000\nDE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006CBA6CDB6CEF6CD96CEA6D1F884D6D366D2B6D3D6D386D196D356D336D12\n6D0C6D636D936D646D5A6D796D596D8E6D956FE46D856DF96E156E0A6DB56DC7\n6DE66DB86DC66DEC6DDE6DCC6DE86DD26DC56DFA6DD96DE46DD56DEA6DEE6E2D\n6E6E6E2E6E196E726E5F6E3E6E236E6B6E2B6E766E4D6E1F6E436E3A6E4E6E24\n6EFF6E1D6E386E826EAA6E986EC96EB76ED36EBD6EAF6EC46EB26ED46ED56E8F\n6EA56EC26E9F6F416F11704C6EEC6EF86EFE6F3F6EF26F316EEF6F326ECC0000\nDF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00006F3E6F136EF76F866F7A6F786F816F806F6F6F5B6FF36F6D6F826F7C6F58\n6F8E6F916FC26F666FB36FA36FA16FA46FB96FC66FAA6FDF6FD56FEC6FD46FD8\n6FF16FEE6FDB7009700B6FFA70117001700F6FFE701B701A6F74701D7018701F\n7030703E7032705170637099709270AF70F170AC70B870B370AE70DF70CB70DD\n70D9710970FD711C711971657155718871667162714C7156716C718F71FB7184\n719571A871AC71D771B971BE71D271C971D471CE71E071EC71E771F571FC0000\nE0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000071F971FF720D7210721B7228722D722C72307232723B723C723F72407246\n724B72587274727E7282728172877292729672A272A772B972B272C372C672C4\n72CE72D272E272E072E172F972F7500F7317730A731C7316731D7334732F7329\n7325733E734E734F9ED87357736A7368737073787375737B737A73C873B373CE\n73BB73C073E573EE73DE74A27405746F742573F87432743A7455743F745F7459\n7441745C746974707463746A7476747E748B749E74A774CA74CF74D473F10000\nE1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000074E074E374E774E974EE74F274F074F174F874F7750475037505750C750E\n750D75157513751E7526752C753C7544754D754A7549755B7546755A75697564\n7567756B756D75787576758675877574758A758975827594759A759D75A575A3\n75C275B375C375B575BD75B875BC75B175CD75CA75D275D975E375DE75FE75FF\n75FC760175F075FA75F275F3760B760D7609761F762776207621762276247634\n7630763B764776487646765C76587661766276687669766A7667766C76700000\nE2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000767276767678767C768076837688768B768E769676937699769A76B076B4\n76B876B976BA76C276CD76D676D276DE76E176E576E776EA862F76FB77087707\n770477297724771E77257726771B773777387747775A7768776B775B7765777F\n777E7779778E778B779177A0779E77B077B677B977BF77BC77BD77BB77C777CD\n77D777DA77DC77E377EE77FC780C781279267820792A7845788E78747886787C\n789A788C78A378B578AA78AF78D178C678CB78D478BE78BC78C578CA78EC0000\nE3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000078E778DA78FD78F47907791279117919792C792B794079607957795F795A\n79557953797A797F798A799D79A79F4B79AA79AE79B379B979BA79C979D579E7\n79EC79E179E37A087A0D7A187A197A207A1F79807A317A3B7A3E7A377A437A57\n7A497A617A627A699F9D7A707A797A7D7A887A977A957A987A967AA97AC87AB0\n7AB67AC57AC47ABF90837AC77ACA7ACD7ACF7AD57AD37AD97ADA7ADD7AE17AE2\n7AE67AED7AF07B027B0F7B0A7B067B337B187B197B1E7B357B287B367B500000\nE4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007B7A7B047B4D7B0B7B4C7B457B757B657B747B677B707B717B6C7B6E7B9D\n7B987B9F7B8D7B9C7B9A7B8B7B927B8F7B5D7B997BCB7BC17BCC7BCF7BB47BC6\n7BDD7BE97C117C147BE67BE57C607C007C077C137BF37BF77C177C0D7BF67C23\n7C277C2A7C1F7C377C2B7C3D7C4C7C437C547C4F7C407C507C587C5F7C647C56\n7C657C6C7C757C837C907CA47CAD7CA27CAB7CA17CA87CB37CB27CB17CAE7CB9\n7CBD7CC07CC57CC27CD87CD27CDC7CE29B3B7CEF7CF27CF47CF67CFA7D060000\nE5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007D027D1C7D157D0A7D457D4B7D2E7D327D3F7D357D467D737D567D4E7D72\n7D687D6E7D4F7D637D937D897D5B7D8F7D7D7D9B7DBA7DAE7DA37DB57DC77DBD\n7DAB7E3D7DA27DAF7DDC7DB87D9F7DB07DD87DDD7DE47DDE7DFB7DF27DE17E05\n7E0A7E237E217E127E317E1F7E097E0B7E227E467E667E3B7E357E397E437E37\n7E327E3A7E677E5D7E567E5E7E597E5A7E797E6A7E697E7C7E7B7E837DD57E7D\n8FAE7E7F7E887E897E8C7E927E907E937E947E967E8E7E9B7E9C7F387F3A0000\nE6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00007F457F4C7F4D7F4E7F507F517F557F547F587F5F7F607F687F697F677F78\n7F827F867F837F887F877F8C7F947F9E7F9D7F9A7FA37FAF7FB27FB97FAE7FB6\n7FB88B717FC57FC67FCA7FD57FD47FE17FE67FE97FF37FF998DC80068004800B\n801280188019801C80218028803F803B804A804680528058805A805F80628068\n80738072807080768079807D807F808480868085809B8093809A80AD519080AC\n80DB80E580D980DD80C480DA80D6810980EF80F1811B81298123812F814B0000\nE7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000968B8146813E8153815180FC8171816E81658166817481838188818A8180\n818281A0819581A481A3815F819381A981B081B581BE81B881BD81C081C281BA\n81C981CD81D181D981D881C881DA81DF81E081E781FA81FB81FE820182028205\n8207820A820D821082168229822B82388233824082598258825D825A825F8264\n82628268826A826B822E827182778278827E828D829282AB829F82BB82AC82E1\n82E382DF82D282F482F382FA8393830382FB82F982DE830682DC830982D90000\nE8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000833583348316833283318340833983508345832F832B831783188385839A\n83AA839F83A283968323838E8387838A837C83B58373837583A0838983A883F4\n841383EB83CE83FD840383D8840B83C183F7840783E083F2840D8422842083BD\n8438850683FB846D842A843C855A84848477846B84AD846E848284698446842C\n846F8479843584CA846284B984BF849F84D984CD84BB84DA84D084C184C684D6\n84A1852184FF84F485178518852C851F8515851484FC85408563855885480000\nE9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000085418602854B8555858085A485888591858A85A8856D8594859B85EA8587\n859C8577857E859085C985BA85CF85B985D085D585DD85E585DC85F9860A8613\n860B85FE85FA86068622861A8630863F864D4E558654865F86678671869386A3\n86A986AA868B868C86B686AF86C486C686B086C9882386AB86D486DE86E986EC\n86DF86DB86EF8712870687088700870386FB87118709870D86F9870A8734873F\n8737873B87258729871A8760875F8778874C874E877487578768876E87590000\nEA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000087538763876A880587A2879F878287AF87CB87BD87C087D096D687AB87C4\n87B387C787C687BB87EF87F287E0880F880D87FE87F687F7880E87D288118816\n8815882288218831883688398827883B8844884288528859885E8862886B8881\n887E889E8875887D88B5887288828897889288AE889988A2888D88A488B088BF\n88B188C388C488D488D888D988DD88F9890288FC88F488E888F28904890C890A\n89138943891E8925892A892B89418944893B89368938894C891D8960895E0000\nEB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000089668964896D896A896F89748977897E89838988898A8993899889A189A9\n89A689AC89AF89B289BA89BD89BF89C089DA89DC89DD89E789F489F88A038A16\n8A108A0C8A1B8A1D8A258A368A418A5B8A528A468A488A7C8A6D8A6C8A628A85\n8A828A848AA88AA18A918AA58AA68A9A8AA38AC48ACD8AC28ADA8AEB8AF38AE7\n8AE48AF18B148AE08AE28AF78ADE8ADB8B0C8B078B1A8AE18B168B108B178B20\n8B3397AB8B268B2B8B3E8B288B418B4C8B4F8B4E8B498B568B5B8B5A8B6B0000\nEC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008B5F8B6C8B6F8B748B7D8B808B8C8B8E8B928B938B968B998B9A8C3A8C41\n8C3F8C488C4C8C4E8C508C558C628C6C8C788C7A8C828C898C858C8A8C8D8C8E\n8C948C7C8C98621D8CAD8CAA8CBD8CB28CB38CAE8CB68CC88CC18CE48CE38CDA\n8CFD8CFA8CFB8D048D058D0A8D078D0F8D0D8D109F4E8D138CCD8D148D168D67\n8D6D8D718D738D818D998DC28DBE8DBA8DCF8DDA8DD68DCC8DDB8DCB8DEA8DEB\n8DDF8DE38DFC8E088E098DFF8E1D8E1E8E108E1F8E428E358E308E348E4A0000\nED\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00008E478E498E4C8E508E488E598E648E608E2A8E638E558E768E728E7C8E81\n8E878E858E848E8B8E8A8E938E918E948E998EAA8EA18EAC8EB08EC68EB18EBE\n8EC58EC88ECB8EDB8EE38EFC8EFB8EEB8EFE8F0A8F058F158F128F198F138F1C\n8F1F8F1B8F0C8F268F338F3B8F398F458F428F3E8F4C8F498F468F4E8F578F5C\n8F628F638F648F9C8F9F8FA38FAD8FAF8FB78FDA8FE58FE28FEA8FEF90878FF4\n90058FF98FFA901190159021900D901E9016900B90279036903590398FF80000\nEE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000904F905090519052900E9049903E90569058905E9068906F907696A89072\n9082907D90819080908A9089908F90A890AF90B190B590E290E4624890DB9102\n9112911991329130914A9156915891639165916991739172918B9189918291A2\n91AB91AF91AA91B591B491BA91C091C191C991CB91D091D691DF91E191DB91FC\n91F591F6921E91FF9214922C92159211925E925792459249926492489295923F\n924B9250929C92969293929B925A92CF92B992B792E9930F92FA9344932E0000\nEF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000093199322931A9323933A9335933B935C9360937C936E935693B093AC93AD\n939493B993D693D793E893E593D893C393DD93D093C893E4941A941494139403\n940794109436942B94359421943A944194529444945B94609462945E946A9229\n947094759477947D945A947C947E9481947F95829587958A9594959695989599\n95A095A895A795AD95BC95BB95B995BE95CA6FF695C395CD95CC95D595D495D6\n95DC95E195E595E296219628962E962F9642964C964F964B9677965C965E0000\nF0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000965D965F96669672966C968D96989695969796AA96A796B196B296B096B4\n96B696B896B996CE96CB96C996CD894D96DC970D96D596F99704970697089713\n970E9711970F971697199724972A97309739973D973E97449746974897429749\n975C976097649766976852D2976B977197799785977C9781977A9786978B978F\n9790979C97A897A697A397B397B497C397C697C897CB97DC97ED9F4F97F27ADF\n97F697F5980F980C9838982498219837983D9846984F984B986B986F98700000\nF1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000098719874987398AA98AF98B198B698C498C398C698E998EB990399099912\n991499189921991D991E99249920992C992E993D993E9942994999459950994B\n99519952994C99559997999899A599AD99AE99BC99DF99DB99DD99D899D199ED\n99EE99F199F299FB99F89A019A0F9A0599E29A199A2B9A379A459A429A409A43\n9A3E9A559A4D9A5B9A579A5F9A629A659A649A699A6B9A6A9AAD9AB09ABC9AC0\n9ACF9AD19AD39AD49ADE9ADF9AE29AE39AE69AEF9AEB9AEE9AF49AF19AF70000\nF2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009AFB9B069B189B1A9B1F9B229B239B259B279B289B299B2A9B2E9B2F9B32\n9B449B439B4F9B4D9B4E9B519B589B749B939B839B919B969B979B9F9BA09BA8\n9BB49BC09BCA9BB99BC69BCF9BD19BD29BE39BE29BE49BD49BE19C3A9BF29BF1\n9BF09C159C149C099C139C0C9C069C089C129C0A9C049C2E9C1B9C259C249C21\n9C309C479C329C469C3E9C5A9C609C679C769C789CE79CEC9CF09D099D089CEB\n9D039D069D2A9D269DAF9D239D1F9D449D159D129D419D3F9D3E9D469D480000\nF3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00009D5D9D5E9D649D519D509D599D729D899D879DAB9D6F9D7A9D9A9DA49DA9\n9DB29DC49DC19DBB9DB89DBA9DC69DCF9DC29DD99DD39DF89DE69DED9DEF9DFD\n9E1A9E1B9E1E9E759E799E7D9E819E889E8B9E8C9E929E959E919E9D9EA59EA9\n9EB89EAA9EAD97619ECC9ECE9ECF9ED09ED49EDC9EDE9EDD9EE09EE59EE89EEF\n9EF49EF69EF79EF99EFB9EFC9EFD9F079F0876B79F159F219F2C9F3E9F4A9F52\n9F549F639F5F9F609F619F669F679F6C9F6A9F779F729F769F959F9C9FA00000\nF4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000582F69C79059746451DC7199000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nR\nA1C1 301C FF5E\nA1C2 2016 2225\nA1DD 2212 FF0D\nA1F1 00A2 FFE0\nA1F2 00A3 FFE1\nA2CC 00AC FFE2\n",
		"/encoding/euc-kr.enc":                     "# Encoding file: euc-kr, multi-byte\nM\n003F 0 90\n00\n0000000100020003000400050006000700080009000A000B000C000D000E000F\n0010001100120013001400150016001700180019001A001B001C001D001E001F\n0020002100220023002400250026002700280029002A002B002C002D002E002F\n0030003100320033003400350036003700380039003A003B003C003D003E003F\n0040004100420043004400450046004700480049004A004B004C004D004E004F\n0050005100520053005400550056005700580059005A005B005C005D005E005F\n0060006100620063006400650066006700680069006A006B006C006D006E006F\n0070007100720073007400750076007700780079007A007B007C007D007E007F\n0080008100820083008400850086008700880089008A008B008C008D008E008F\n0090009100920093009400950096009700980099009A009B009C009D009E009F\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000030003001300200B72025202600A8300300AD20152225FF3C223C20182019\n201C201D3014301530083009300A300B300C300D300E300F3010301100B100D7\n00F7226022642265221E223400B0203220332103212BFFE0FFE1FFE526422640\n222022A52312220222072261225200A7203B2606260525CB25CF25CE25C725C6\n25A125A025B325B225BD25BC219221902191219321943013226A226B221A223D\n221D2235222B222C2208220B2286228722822283222A222922272228FFE20000\nA2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000021D221D42200220300B4FF5E02C702D802DD02DA02D900B802DB00A100BF\n02D0222E2211220F00A42109203025C125C025B725B626642660266126652667\n2663229925C825A325D025D1259225A425A525A825A725A625A92668260F260E\n261C261E00B62020202121952197219921962198266D2669266A266C327F321C\n211633C7212233C233D821210000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000FF01FF02FF03FF04FF05FF06FF07FF08FF09FF0AFF0BFF0CFF0DFF0EFF0F\nFF10FF11FF12FF13FF14FF15FF16FF17FF18FF19FF1AFF1BFF1CFF1DFF1EFF1F\nFF20FF21FF22FF23FF24FF25FF26FF27FF28FF29FF2AFF2BFF2CFF2DFF2EFF2F\nFF30FF31FF32FF33FF34FF35FF36FF37FF38FF39FF3AFF3BFFE6FF3DFF3EFF3F\nFF40FF41FF42FF43FF44FF45FF46FF47FF48FF49FF4AFF4BFF4CFF4DFF4EFF4F\nFF50FF51FF52FF53FF54FF55FF56FF57FF58FF59FF5AFF5BFF5CFF5DFFE30000\nA4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000313131323133313431353136313731383139313A313B313C313D313E313F\n3140314131423143314431453146314731483149314A314B314C314D314E314F\n3150315131523153315431553156315731583159315A315B315C315D315E315F\n3160316131623163316431653166316731683169316A316B316C316D316E316F\n3170317131723173317431753176317731783179317A317B317C317D317E317F\n3180318131823183318431853186318731883189318A318B318C318D318E0000\nA5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000217021712172217321742175217621772178217900000000000000000000\n2160216121622163216421652166216721682169000000000000000000000000\n0000039103920393039403950396039703980399039A039B039C039D039E039F\n03A003A103A303A403A503A603A703A803A90000000000000000000000000000\n000003B103B203B303B403B503B603B703B803B903BA03BB03BC03BD03BE03BF\n03C003C103C303C403C503C603C703C803C90000000000000000000000000000\nA6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000025002502250C251025182514251C252C25242534253C25012503250F2513\n251B251725232533252B253B254B2520252F25282537253F251D253025252538\n254225122511251A251925162515250E250D251E251F25212522252625272529\n252A252D252E25312532253525362539253A253D253E25402541254325442545\n2546254725482549254A00000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\nA7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n00003395339633972113339833C433A333A433A533A63399339A339B339C339D\n339E339F33A033A133A233CA338D338E338F33CF3388338933C833A733A833B0\n33B133B233B333B433B533B633B733B833B93380338133823383338433BA33BB\n33BC33BD33BE33BF33903391339233933394212633C033C1338A338B338C33D6\n33C533AD33AE33AF33DB33A933AA33AB33AC33DD33D033D333C333C933DC33C6\n0000000000000000000000000000000000000000000000000000000000000000\nA8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000000C600D000AA0126000001320000013F014100D8015200BA00DE0166014A\n00003260326132623263326432653266326732683269326A326B326C326D326E\n326F3270327132723273327432753276327732783279327A327B24D024D124D2\n24D324D424D524D624D724D824D924DA24DB24DC24DD24DE24DF24E024E124E2\n24E324E424E524E624E724E824E9246024612462246324642465246624672468\n2469246A246B246C246D246E00BD2153215400BC00BE215B215C215D215E0000\nA9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000000E6011100F001270131013301380140014200F8015300DF00FE0167014B\n01493200320132023203320432053206320732083209320A320B320C320D320E\n320F3210321132123213321432153216321732183219321A321B249C249D249E\n249F24A024A124A224A324A424A524A624A724A824A924AA24AB24AC24AD24AE\n24AF24B024B124B224B324B424B5247424752476247724782479247A247B247C\n247D247E247F24802481248200B900B200B32074207F20812082208320840000\nAA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000304130423043304430453046304730483049304A304B304C304D304E304F\n3050305130523053305430553056305730583059305A305B305C305D305E305F\n3060306130623063306430653066306730683069306A306B306C306D306E306F\n3070307130723073307430753076307730783079307A307B307C307D307E307F\n3080308130823083308430853086308730883089308A308B308C308D308E308F\n3090309130923093000000000000000000000000000000000000000000000000\nAB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000030A130A230A330A430A530A630A730A830A930AA30AB30AC30AD30AE30AF\n30B030B130B230B330B430B530B630B730B830B930BA30BB30BC30BD30BE30BF\n30C030C130C230C330C430C530C630C730C830C930CA30CB30CC30CD30CE30CF\n30D030D130D230D330D430D530D630D730D830D930DA30DB30DC30DD30DE30DF\n30E030E130E230E330E430E530E630E730E830E930EA30EB30EC30ED30EE30EF\n30F030F130F230F330F430F530F6000000000000000000000000000000000000\nAC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000004100411041204130414041504010416041704180419041A041B041C041D\n041E041F0420042104220423042404250426042704280429042A042B042C042D\n042E042F00000000000000000000000000000000000000000000000000000000\n000004300431043204330434043504510436043704380439043A043B043C043D\n043E043F0440044104420443044404450446044704480449044A044B044C044D\n044E044F00000000000000000000000000000000000000000000000000000000\nB0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000AC00AC01AC04AC07AC08AC09AC0AAC10AC11AC12AC13AC14AC15AC16AC17\nAC19AC1AAC1BAC1CAC1DAC20AC24AC2CAC2DAC2FAC30AC31AC38AC39AC3CAC40\nAC4BAC4DAC54AC58AC5CAC70AC71AC74AC77AC78AC7AAC80AC81AC83AC84AC85\nAC86AC89AC8AAC8BAC8CAC90AC94AC9CAC9DAC9FACA0ACA1ACA8ACA9ACAAACAC\nACAFACB0ACB8ACB9ACBBACBCACBDACC1ACC4ACC8ACCCACD5ACD7ACE0ACE1ACE4\nACE7ACE8ACEAACECACEFACF0ACF1ACF3ACF5ACF6ACFCACFDAD00AD04AD060000\nB1\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000AD0CAD0DAD0FAD11AD18AD1CAD20AD29AD2CAD2DAD34AD35AD38AD3CAD44\nAD45AD47AD49AD50AD54AD58AD61AD63AD6CAD6DAD70AD73AD74AD75AD76AD7B\nAD7CAD7DAD7FAD81AD82AD88AD89AD8CAD90AD9CAD9DADA4ADB7ADC0ADC1ADC4\nADC8ADD0ADD1ADD3ADDCADE0ADE4ADF8ADF9ADFCADFFAE00AE01AE08AE09AE0B\nAE0DAE14AE30AE31AE34AE37AE38AE3AAE40AE41AE43AE45AE46AE4AAE4CAE4D\nAE4EAE50AE54AE56AE5CAE5DAE5FAE60AE61AE65AE68AE69AE6CAE70AE780000\nB2\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000AE79AE7BAE7CAE7DAE84AE85AE8CAEBCAEBDAEBEAEC0AEC4AECCAECDAECF\nAED0AED1AED8AED9AEDCAEE8AEEBAEEDAEF4AEF8AEFCAF07AF08AF0DAF10AF2C\nAF2DAF30AF32AF34AF3CAF3DAF3FAF41AF42AF43AF48AF49AF50AF5CAF5DAF64\nAF65AF79AF80AF84AF88AF90AF91AF95AF9CAFB8AFB9AFBCAFC0AFC7AFC8AFC9\nAFCBAFCDAFCEAFD4AFDCAFE8AFE9AFF0AFF1AFF4AFF8B000B001B004B00CB010\nB014B01CB01DB028B044B045B048B04AB04CB04EB053B054B055B057B0590000\nB3\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B05DB07CB07DB080B084B08CB08DB08FB091B098B099B09AB09CB09FB0A0\nB0A1B0A2B0A8B0A9B0ABB0ACB0ADB0AEB0AFB0B1B0B3B0B4B0B5B0B8B0BCB0C4\nB0C5B0C7B0C8B0C9B0D0B0D1B0D4B0D8B0E0B0E5B108B109B10BB10CB110B112\nB113B118B119B11BB11CB11DB123B124B125B128B12CB134B135B137B138B139\nB140B141B144B148B150B151B154B155B158B15CB160B178B179B17CB180B182\nB188B189B18BB18DB192B193B194B198B19CB1A8B1CCB1D0B1D4B1DCB1DD0000\nB4\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B1DFB1E8B1E9B1ECB1F0B1F9B1FBB1FDB204B205B208B20BB20CB214B215\nB217B219B220B234B23CB258B25CB260B268B269B274B275B27CB284B285B289\nB290B291B294B298B299B29AB2A0B2A1B2A3B2A5B2A6B2AAB2ACB2B0B2B4B2C8\nB2C9B2CCB2D0B2D2B2D8B2D9B2DBB2DDB2E2B2E4B2E5B2E6B2E8B2EBB2ECB2ED\nB2EEB2EFB2F3B2F4B2F5B2F7B2F8B2F9B2FAB2FBB2FFB300B301B304B308B310\nB311B313B314B315B31CB354B355B356B358B35BB35CB35EB35FB364B3650000\nB5\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B367B369B36BB36EB370B371B374B378B380B381B383B384B385B38CB390\nB394B3A0B3A1B3A8B3ACB3C4B3C5B3C8B3CBB3CCB3CEB3D0B3D4B3D5B3D7B3D9\nB3DBB3DDB3E0B3E4B3E8B3FCB410B418B41CB420B428B429B42BB434B450B451\nB454B458B460B461B463B465B46CB480B488B49DB4A4B4A8B4ACB4B5B4B7B4B9\nB4C0B4C4B4C8B4D0B4D5B4DCB4DDB4E0B4E3B4E4B4E6B4ECB4EDB4EFB4F1B4F8\nB514B515B518B51BB51CB524B525B527B528B529B52AB530B531B534B5380000\nB6\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B540B541B543B544B545B54BB54CB54DB550B554B55CB55DB55FB560B561\nB5A0B5A1B5A4B5A8B5AAB5ABB5B0B5B1B5B3B5B4B5B5B5BBB5BCB5BDB5C0B5C4\nB5CCB5CDB5CFB5D0B5D1B5D8B5ECB610B611B614B618B625B62CB634B648B664\nB668B69CB69DB6A0B6A4B6ABB6ACB6B1B6D4B6F0B6F4B6F8B700B701B705B728\nB729B72CB72FB730B738B739B73BB744B748B74CB754B755B760B764B768B770\nB771B773B775B77CB77DB780B784B78CB78DB78FB790B791B792B796B7970000\nB7\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B798B799B79CB7A0B7A8B7A9B7ABB7ACB7ADB7B4B7B5B7B8B7C7B7C9B7EC\nB7EDB7F0B7F4B7FCB7FDB7FFB800B801B807B808B809B80CB810B818B819B81B\nB81DB824B825B828B82CB834B835B837B838B839B840B844B851B853B85CB85D\nB860B864B86CB86DB86FB871B878B87CB88DB8A8B8B0B8B4B8B8B8C0B8C1B8C3\nB8C5B8CCB8D0B8D4B8DDB8DFB8E1B8E8B8E9B8ECB8F0B8F8B8F9B8FBB8FDB904\nB918B920B93CB93DB940B944B94CB94FB951B958B959B95CB960B968B9690000\nB8\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000B96BB96DB974B975B978B97CB984B985B987B989B98AB98DB98EB9ACB9AD\nB9B0B9B4B9BCB9BDB9BFB9C1B9C8B9C9B9CCB9CEB9CFB9D0B9D1B9D2B9D8B9D9\nB9DBB9DDB9DEB9E1B9E3B9E4B9E5B9E8B9ECB9F4B9F5B9F7B9F8B9F9B9FABA00\nBA01BA08BA15BA38BA39BA3CBA40BA42BA48BA49BA4BBA4DBA4EBA53BA54BA55\nBA58BA5CBA64BA65BA67BA68BA69BA70BA71BA74BA78BA83BA84BA85BA87BA8C\nBAA8BAA9BAABBAACBAB0BAB2BAB8BAB9BABBBABDBAC4BAC8BAD8BAD9BAFC0000\nB9\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000BB00BB04BB0DBB0FBB11BB18BB1CBB20BB29BB2BBB34BB35BB36BB38BB3B\nBB3CBB3DBB3EBB44BB45BB47BB49BB4DBB4FBB50BB54BB58BB61BB63BB6CBB88\nBB8CBB90BBA4BBA8BBACBBB4BBB7BBC0BBC4BBC8BBD0BBD3BBF8BBF9BBFCBBFF\nBC00BC02BC08BC09BC0BBC0CBC0DBC0FBC11BC14BC15BC16BC17BC18BC1BBC1C\nBC1DBC1EBC1FBC24BC25BC27BC29BC2DBC30BC31BC34BC38BC40BC41BC43BC44\nBC45BC49BC4CBC4DBC50BC5DBC84BC85BC88BC8BBC8CBC8EBC94BC95BC970000\nBA\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000BC99BC9ABCA0BCA1BCA4BCA7BCA8BCB0BCB1BCB3BCB4BCB5BCBCBCBDBCC0\nBCC4BCCDBCCFBCD0BCD1BCD5BCD8BCDCBCF4BCF5BCF6BCF8BCFCBD04BD05BD07\nBD09BD10BD14BD24BD2CBD40BD48BD49BD4CBD50BD58BD59BD64BD68BD80BD81\nBD84BD87BD88BD89BD8ABD90BD91BD93BD95BD99BD9ABD9CBDA4BDB0BDB8BDD4\nBDD5BDD8BDDCBDE9BDF0BDF4BDF8BE00BE03BE05BE0CBE0DBE10BE14BE1CBE1D\nBE1FBE44BE45BE48BE4CBE4EBE54BE55BE57BE59BE5ABE5BBE60BE61BE640000\nBB\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000BE68BE6ABE70BE71BE73BE74BE75BE7BBE7CBE7DBE80BE84BE8CBE8DBE8F\nBE90BE91BE98BE99BEA8BED0BED1BED4BED7BED8BEE0BEE3BEE4BEE5BEECBF01\nBF08BF09BF18BF19BF1BBF1CBF1DBF40BF41BF44BF48BF50BF51BF55BF94BFB0\nBFC5BFCCBFCDBFD0BFD4BFDCBFDFBFE1C03CC051C058C05CC060C068C069C090\nC091C094C098C0A0C0A1C0A3C0A5C0ACC0ADC0AFC0B0C0B3C0B4C0B5C0B6C0BC\nC0BDC0BFC0C0C0C1C0C5C0C8C0C9C0CCC0D0C0D8C0D9C0DBC0DCC0DDC0E40000\nBC\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C0E5C0E8C0ECC0F4C0F5C0F7C0F9C100C104C108C110C115C11CC11DC11E\nC11FC120C123C124C126C127C12CC12DC12FC130C131C136C138C139C13CC140\nC148C149C14BC14CC14DC154C155C158C15CC164C165C167C168C169C170C174\nC178C185C18CC18DC18EC190C194C196C19CC19DC19FC1A1C1A5C1A8C1A9C1AC\nC1B0C1BDC1C4C1C8C1CCC1D4C1D7C1D8C1E0C1E4C1E8C1F0C1F1C1F3C1FCC1FD\nC200C204C20CC20DC20FC211C218C219C21CC21FC220C228C229C22BC22D0000\nBD\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C22FC231C232C234C248C250C251C254C258C260C265C26CC26DC270C274\nC27CC27DC27FC281C288C289C290C298C29BC29DC2A4C2A5C2A8C2ACC2ADC2B4\nC2B5C2B7C2B9C2DCC2DDC2E0C2E3C2E4C2EBC2ECC2EDC2EFC2F1C2F6C2F8C2F9\nC2FBC2FCC300C308C309C30CC30DC313C314C315C318C31CC324C325C328C329\nC345C368C369C36CC370C372C378C379C37CC37DC384C388C38CC3C0C3D8C3D9\nC3DCC3DFC3E0C3E2C3E8C3E9C3EDC3F4C3F5C3F8C408C410C424C42CC4300000\nBE\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C434C43CC43DC448C464C465C468C46CC474C475C479C480C494C49CC4B8\nC4BCC4E9C4F0C4F1C4F4C4F8C4FAC4FFC500C501C50CC510C514C51CC528C529\nC52CC530C538C539C53BC53DC544C545C548C549C54AC54CC54DC54EC553C554\nC555C557C558C559C55DC55EC560C561C564C568C570C571C573C574C575C57C\nC57DC580C584C587C58CC58DC58FC591C595C597C598C59CC5A0C5A9C5B4C5B5\nC5B8C5B9C5BBC5BCC5BDC5BEC5C4C5C5C5C6C5C7C5C8C5C9C5CAC5CCC5CE0000\nBF\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000C5D0C5D1C5D4C5D8C5E0C5E1C5E3C5E5C5ECC5EDC5EEC5F0C5F4C5F6C5F7\nC5FCC5FDC5FEC5FFC600C601C605C606C607C608C60CC610C618C619C61BC61C\nC624C625C628C62CC62DC62EC630C633C634C635C637C639C63BC640C641C644\nC648C650C651C653C654C655C65CC65DC660C66CC66FC671C678C679C67CC680\nC688C689C68BC68DC694C695C698C69CC6A4C6A5C6A7C6A9C6B0C6B1C6B4C6B8\nC6B9C6BAC6C0C6C1C6C3C6C5C6CCC6CDC6D0C6D4C6DCC6DDC6E0C6E1C6E80000\nC0\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n000000000000000000000000000000000000