// Copyright 2022 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.25.3
// source: relui.proto

package protos

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of artifact signing request.
type SignArtifactRequest_BuildType int32

const (
	SignArtifactRequest_BUILD_TYPE_UNSPECIFIED                      SignArtifactRequest_BuildType = 0
	SignArtifactRequest_BUILD_TYPE_MACOS                            SignArtifactRequest_BuildType = 1
	SignArtifactRequest_BUILD_TYPE_WINDOWS                          SignArtifactRequest_BuildType = 2
	SignArtifactRequest_BUILD_TYPE_GPG                              SignArtifactRequest_BuildType = 3
	SignArtifactRequest_BUILD_TYPE_MACOS_CONSTRUCT_INSTALLER_ONLY   SignArtifactRequest_BuildType = 4
	SignArtifactRequest_BUILD_TYPE_WINDOWS_CONSTRUCT_INSTALLER_ONLY SignArtifactRequest_BuildType = 5
	// Sign individual binary application artifacts.
	// The signing server expects zipped application bundles and signs the files in them.
	SignArtifactRequest_BUILD_TYPE_MACOS_BINARY   SignArtifactRequest_BuildType = 6
	SignArtifactRequest_BUILD_TYPE_WINDOWS_BINARY SignArtifactRequest_BuildType = 7
)

// Enum value maps for SignArtifactRequest_BuildType.
var (
	SignArtifactRequest_BuildType_name = map[int32]string{
		0: "BUILD_TYPE_UNSPECIFIED",
		1: "BUILD_TYPE_MACOS",
		2: "BUILD_TYPE_WINDOWS",
		3: "BUILD_TYPE_GPG",
		4: "BUILD_TYPE_MACOS_CONSTRUCT_INSTALLER_ONLY",
		5: "BUILD_TYPE_WINDOWS_CONSTRUCT_INSTALLER_ONLY",
		6: "BUILD_TYPE_MACOS_BINARY",
		7: "BUILD_TYPE_WINDOWS_BINARY",
	}
	SignArtifactRequest_BuildType_value = map[string]int32{
		"BUILD_TYPE_UNSPECIFIED":                      0,
		"BUILD_TYPE_MACOS":                            1,
		"BUILD_TYPE_WINDOWS":                          2,
		"BUILD_TYPE_GPG":                              3,
		"BUILD_TYPE_MACOS_CONSTRUCT_INSTALLER_ONLY":   4,
		"BUILD_TYPE_WINDOWS_CONSTRUCT_INSTALLER_ONLY": 5,
		"BUILD_TYPE_MACOS_BINARY":                     6,
		"BUILD_TYPE_WINDOWS_BINARY":                   7,
	}
)

func (x SignArtifactRequest_BuildType) Enum() *SignArtifactRequest_BuildType {
	p := new(SignArtifactRequest_BuildType)
	*p = x
	return p
}

func (x SignArtifactRequest_BuildType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SignArtifactRequest_BuildType) Descriptor() protoreflect.EnumDescriptor {
	return file_relui_proto_enumTypes[0].Descriptor()
}

func (SignArtifactRequest_BuildType) Type() protoreflect.EnumType {
	return &file_relui_proto_enumTypes[0]
}

func (x SignArtifactRequest_BuildType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SignArtifactRequest_BuildType.Descriptor instead.
func (SignArtifactRequest_BuildType) EnumDescriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{1, 0}
}

// Request an action from the signing client.
type SigningRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// unique identifier for the request. This would normally reside within
	// the metadata. This is primarily used to route requests between
	// caller/responder. The server and client must use the same id for each
	// corresponging request.
	MessageId string `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// Request type for the signing client.
	//
	// Types that are assignable to RequestOneof:
	//
	//	*SigningRequest_Sign
	//	*SigningRequest_Status
	//	*SigningRequest_Cancel
	RequestOneof isSigningRequest_RequestOneof `protobuf_oneof:"request_oneof"`
}

func (x *SigningRequest) Reset() {
	*x = SigningRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_relui_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SigningRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SigningRequest) ProtoMessage() {}

func (x *SigningRequest) ProtoReflect() protoreflect.Message {
	mi := &file_relui_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SigningRequest.ProtoReflect.Descriptor instead.
func (*SigningRequest) Descriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{0}
}

func (x *SigningRequest) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (m *SigningRequest) GetRequestOneof() isSigningRequest_RequestOneof {
	if m != nil {
		return m.RequestOneof
	}
	return nil
}

func (x *SigningRequest) GetSign() *SignArtifactRequest {
	if x, ok := x.GetRequestOneof().(*SigningRequest_Sign); ok {
		return x.Sign
	}
	return nil
}

func (x *SigningRequest) GetStatus() *SignArtifactStatusRequest {
	if x, ok := x.GetRequestOneof().(*SigningRequest_Status); ok {
		return x.Status
	}
	return nil
}

func (x *SigningRequest) GetCancel() *SignArtifactCancelRequest {
	if x, ok := x.GetRequestOneof().(*SigningRequest_Cancel); ok {
		return x.Cancel
	}
	return nil
}

type isSigningRequest_RequestOneof interface {
	isSigningRequest_RequestOneof()
}

type SigningRequest_Sign struct {
	Sign *SignArtifactRequest `protobuf:"bytes,2,opt,name=sign,proto3,oneof"`
}

type SigningRequest_Status struct {
	Status *SignArtifactStatusRequest `protobuf:"bytes,3,opt,name=status,proto3,oneof"`
}

type SigningRequest_Cancel struct {
	Cancel *SignArtifactCancelRequest `protobuf:"bytes,4,opt,name=cancel,proto3,oneof"`
}

func (*SigningRequest_Sign) isSigningRequest_RequestOneof() {}

func (*SigningRequest_Status) isSigningRequest_RequestOneof() {}

func (*SigningRequest_Cancel) isSigningRequest_RequestOneof() {}

// Request to sign a release artifact.
type SignArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BuildType SignArtifactRequest_BuildType `protobuf:"varint,1,opt,name=build_type,json=buildType,proto3,enum=protos.SignArtifactRequest_BuildType" json:"build_type,omitempty"`
	// The GCS URI for the artifact that should be signed.
	// This artifact must reside in the agreed upon private
	// GCS bucket.
	//
	// There must be at least one entry, and
	// each one points to an individual file.
	// For example, "gs://golang-release-staging/relui-scratch/<...>/go123.linux-amd64.tar.gz".
	GcsUri []string `protobuf:"bytes,2,rep,name=gcs_uri,json=gcsUri,proto3" json:"gcs_uri,omitempty"`
}

func (x *SignArtifactRequest) Reset() {
	*x = SignArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_relui_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignArtifactRequest) ProtoMessage() {}

func (x *SignArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_relui_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignArtifactRequest.ProtoReflect.Descriptor instead.
func (*SignArtifactRequest) Descriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{1}
}

func (x *SignArtifactRequest) GetBuildType() SignArtifactRequest_BuildType {
	if x != nil {
		return x.BuildType
	}
	return SignArtifactRequest_BUILD_TYPE_UNSPECIFIED
}

func (x *SignArtifactRequest) GetGcsUri() []string {
	if x != nil {
		return x.GcsUri
	}
	return nil
}

// Request for an update on an existing signing request.
type SignArtifactStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// unique identifier for the signing job.
	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
}

func (x *SignArtifactStatusRequest) Reset() {
	*x = SignArtifactStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_relui_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignArtifactStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignArtifactStatusRequest) ProtoMessage() {}

func (x *SignArtifactStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_relui_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignArtifactStatusRequest.ProtoReflect.Descriptor instead.
func (*SignArtifactStatusRequest) Descriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{2}
}

func (x *SignArtifactStatusRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

// Request to stop a previous signing request sooner if possible.
type SignArtifactCancelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// unique identifier for the signing job.
	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
}

func (x *SignArtifactCancelRequest) Reset() {
	*x = SignArtifactCancelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_relui_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignArtifactCancelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignArtifactCancelRequest) ProtoMessage() {}

func (x *SignArtifactCancelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_relui_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignArtifactCancelRequest.ProtoReflect.Descriptor instead.
func (*SignArtifactCancelRequest) Descriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{3}
}

func (x *SignArtifactCancelRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

// The status of the signing request.
type SigningStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// unique identifier for the request. This would normally reside within
	// the metadata. This is primarily used to route requests between
	// caller/responder. The server and client must use the same id for each
	// corresponging request.
	MessageId string `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// The status type of the signing request.
	//
	// Types that are assignable to StatusOneof:
	//
	//	*SigningStatus_NotFound
	//	*SigningStatus_Started
	//	*SigningStatus_Running
	//	*SigningStatus_Failed
	//	*SigningStatus_Completed
	StatusOneof isSigningStatus_StatusOneof `protobuf_oneof:"status_oneof"`
}

func (x *SigningStatus) Reset() {
	*x = SigningStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_relui_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SigningStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SigningStatus) ProtoMessage() {}

func (x *SigningStatus) ProtoReflect() protoreflect.Message {
	mi := &file_relui_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SigningStatus.ProtoReflect.Descriptor instead.
func (*SigningStatus) Descriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{4}
}

func (x *SigningStatus) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (m *SigningStatus) GetStatusOneof() isSigningStatus_StatusOneof {
	if m != nil {
		return m.StatusOneof
	}
	return nil
}

func (x *SigningStatus) GetNotFound() *StatusNotFound {
	if x, ok := x.GetStatusOneof().(*SigningStatus_NotFound); ok {
		return x.NotFound
	}
	return nil
}

func (x *SigningStatus) GetStarted() *StatusStarted {
	if x, ok := x.GetStatusOneof().(*SigningStatus_Started); ok {
		return x.Started
	}
	return nil
}

func (x *SigningStatus) GetRunning() *StatusRunning {
	if x, ok := x.GetStatusOneof().(*SigningStatus_Running); ok {
		return x.Running
	}
	return nil
}

func (x *SigningStatus) GetFailed() *StatusFailed {
	if x, ok := x.GetStatusOneof().(*SigningStatus_Failed); ok {
		return x.Failed
	}
	return nil
}

func (x *SigningStatus) GetCompleted() *StatusCompleted {
	if x, ok := x.GetStatusOneof().(*SigningStatus_Completed); ok {
		return x.Completed
	}
	return nil
}

type isSigningStatus_StatusOneof interface {
	isSigningStatus_StatusOneof()
}

type SigningStatus_NotFound struct {
	NotFound *StatusNotFound `protobuf:"bytes,3,opt,name=not_found,json=notFound,proto3,oneof"`
}

type SigningStatus_Started struct {
	Started *StatusStarted `protobuf:"bytes,4,opt,name=started,proto3,oneof"`
}

type SigningStatus_Running struct {
	Running *StatusRunning `protobuf:"bytes,5,opt,name=running,proto3,oneof"`
}

type SigningStatus_Failed struct {
	Failed *StatusFailed `protobuf:"bytes,6,opt,name=failed,proto3,oneof"`
}

type SigningStatus_Completed struct {
	Completed *StatusCompleted `protobuf:"bytes,7,opt,name=completed,proto3,oneof"`
}

func (*SigningStatus_NotFound) isSigningStatus_StatusOneof() {}

func (*SigningStatus_Started) isSigningStatus_StatusOneof() {}

func (*SigningStatus_Running) isSigningStatus_StatusOneof() {}

func (*SigningStatus_Failed) isSigningStatus_StatusOneof() {}

func (*SigningStatus_Completed) isSigningStatus_StatusOneof() {}

// The signing status for a signing request which does not exist.
type StatusNotFound struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StatusNotFound) Reset() {
	*x = StatusNotFound{}
	if protoimpl.UnsafeEnabled {
		mi := &file_relui_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusNotFound) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusNotFound) ProtoMessage() {}

func (x *StatusNotFound) ProtoReflect() protoreflect.Message {
	mi := &file_relui_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusNotFound.ProtoReflect.Descriptor instead.
func (*StatusNotFound) Descriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{5}
}

// The signing status for an in progress signing request.
type StatusStarted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// unique identifier for the signing job that started.
	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
}

func (x *StatusStarted) Reset() {
	*x = StatusStarted{}
	if protoimpl.UnsafeEnabled {
		mi := &file_relui_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusStarted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusStarted) ProtoMessage() {}

func (x *StatusStarted) ProtoReflect() protoreflect.Message {
	mi := &file_relui_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusStarted.ProtoReflect.Descriptor instead.
func (*StatusStarted) Descriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{6}
}

func (x *StatusStarted) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

type StatusRunning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details about the signing request status.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *StatusRunning) Reset() {
	*x = StatusRunning{}
	if protoimpl.UnsafeEnabled {
		mi := &file_relui_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusRunning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusRunning) ProtoMessage() {}

func (x *StatusRunning) ProtoReflect() protoreflect.Message {
	mi := &file_relui_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusRunning.ProtoReflect.Descriptor instead.
func (*StatusRunning) Descriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{7}
}

func (x *StatusRunning) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// The signing status for a failed signing request.
type StatusFailed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details about the signing request status.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *StatusFailed) Reset() {
	*x = StatusFailed{}
	if protoimpl.UnsafeEnabled {
		mi := &file_relui_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusFailed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusFailed) ProtoMessage() {}

func (x *StatusFailed) ProtoReflect() protoreflect.Message {
	mi := &file_relui_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusFailed.ProtoReflect.Descriptor instead.
func (*StatusFailed) Descriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{8}
}

func (x *StatusFailed) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// The signing status for a successfully completed signing request.
type StatusCompleted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GCS URIs of the signed artifact(s),
	// each one pointing to an individual file.
	// For example, "gs://golang-release-staging/relui-scratch/<...>/go123.linux-amd64.tar.gz".
	GcsUri []string `protobuf:"bytes,1,rep,name=gcs_uri,json=gcsUri,proto3" json:"gcs_uri,omitempty"`
}

func (x *StatusCompleted) Reset() {
	*x = StatusCompleted{}
	if protoimpl.UnsafeEnabled {
		mi := &file_relui_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusCompleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusCompleted) ProtoMessage() {}

func (x *StatusCompleted) ProtoReflect() protoreflect.Message {
	mi := &file_relui_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusCompleted.ProtoReflect.Descriptor instead.
func (*StatusCompleted) Descriptor() ([]byte, []int) {
	return file_relui_proto_rawDescGZIP(), []int{9}
}

func (x *StatusCompleted) GetGcsUri() []string {
	if x != nil {
		return x.GcsUri
	}
	return nil
}

var File_relui_proto protoreflect.FileDescriptor

var file_relui_proto_rawDesc = []byte{
	0x0a, 0x0b, 0x72, 0x65, 0x6c, 0x75, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0x22, 0xed, 0x01, 0x0a, 0x0e, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x04, 0x73, 0x69, 0x67, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x53,
	0x69, 0x67, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x04, 0x73, 0x69, 0x67, 0x6e, 0x12, 0x3b, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3b, 0x0a, 0x06, 0x63, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x06, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x42, 0x0f, 0x0a, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x22, 0xfc, 0x02, 0x0a, 0x13, 0x53, 0x69, 0x67, 0x6e, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a,
	0x0a, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x25, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x67, 0x63, 0x73, 0x55, 0x72, 0x69, 0x22, 0x85, 0x02, 0x0a,
	0x09, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x55,
	0x49, 0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x41, 0x43, 0x4f, 0x53, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12,
	0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f,
	0x57, 0x53, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x47, 0x50, 0x47, 0x10, 0x03, 0x12, 0x2d, 0x0a, 0x29, 0x42, 0x55, 0x49, 0x4c,
	0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x41, 0x43, 0x4f, 0x53, 0x5f, 0x43, 0x4f, 0x4e,
	0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x45, 0x52,
	0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x04, 0x12, 0x2f, 0x0a, 0x2b, 0x42, 0x55, 0x49, 0x4c, 0x44,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x53, 0x5f, 0x43, 0x4f,
	0x4e, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x45,
	0x52, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x05, 0x12, 0x1b, 0x0a, 0x17, 0x42, 0x55, 0x49, 0x4c,
	0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x41, 0x43, 0x4f, 0x53, 0x5f, 0x42, 0x49, 0x4e,
	0x41, 0x52, 0x59, 0x10, 0x06, 0x12, 0x1d, 0x0a, 0x19, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x53, 0x5f, 0x42, 0x49, 0x4e, 0x41,
	0x52, 0x59, 0x10, 0x07, 0x22, 0x32, 0x0a, 0x19, 0x53, 0x69, 0x67, 0x6e, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x22, 0x32, 0x0a, 0x19, 0x53, 0x69, 0x67, 0x6e,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x22, 0xc4, 0x02, 0x0a,
	0x0d, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1d,
	0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x35, 0x0a,
	0x09, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x08, 0x6e, 0x6f, 0x74, 0x46,
	0x6f, 0x75, 0x6e, 0x64, 0x12, 0x31, 0x0a, 0x07, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x07,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x12, 0x31, 0x0a, 0x07, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x48,
	0x00, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x2e, 0x0a, 0x06, 0x66, 0x61,
	0x69, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x48, 0x00, 0x52, 0x06, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6f, 0x6e,
	0x65, 0x6f, 0x66, 0x22, 0x10, 0x0a, 0x0e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4e, 0x6f, 0x74,
	0x46, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0x26, 0x0a, 0x0d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x22, 0x31, 0x0a,
	0x0d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x30, 0x0a, 0x0c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x2a, 0x0a, 0x0f, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x67, 0x63, 0x73, 0x55, 0x72, 0x69, 0x32, 0x5c,
	0x0a, 0x0e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x4a, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x15, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x16,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x42, 0x2a, 0x5a, 0x28,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x78, 0x2f, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x72, 0x65, 0x6c, 0x75,
	0x69, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_relui_proto_rawDescOnce sync.Once
	file_relui_proto_rawDescData = file_relui_proto_rawDesc
)

func file_relui_proto_rawDescGZIP() []byte {
	file_relui_proto_rawDescOnce.Do(func() {
		file_relui_proto_rawDescData = protoimpl.X.CompressGZIP(file_relui_proto_rawDescData)
	})
	return file_relui_proto_rawDescData
}

var file_relui_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_relui_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_relui_proto_goTypes = []interface{}{
	(SignArtifactRequest_BuildType)(0), // 0: protos.SignArtifactRequest.BuildType
	(*SigningRequest)(nil),             // 1: protos.SigningRequest
	(*SignArtifactRequest)(nil),        // 2: protos.SignArtifactRequest
	(*SignArtifactStatusRequest)(nil),  // 3: protos.SignArtifactStatusRequest
	(*SignArtifactCancelRequest)(nil),  // 4: protos.SignArtifactCancelRequest
	(*SigningStatus)(nil),              // 5: protos.SigningStatus
	(*StatusNotFound)(nil),             // 6: protos.StatusNotFound
	(*StatusStarted)(nil),              // 7: protos.StatusStarted
	(*StatusRunning)(nil),              // 8: protos.StatusRunning
	(*StatusFailed)(nil),               // 9: protos.StatusFailed
	(*StatusCompleted)(nil),            // 10: protos.StatusCompleted
}
var file_relui_proto_depIdxs = []int32{
	2,  // 0: protos.SigningRequest.sign:type_name -> protos.SignArtifactRequest
	3,  // 1: protos.SigningRequest.status:type_name -> protos.SignArtifactStatusRequest
	4,  // 2: protos.SigningRequest.cancel:type_name -> protos.SignArtifactCancelRequest
	0,  // 3: protos.SignArtifactRequest.build_type:type_name -> protos.SignArtifactRequest.BuildType
	6,  // 4: protos.SigningStatus.not_found:type_name -> protos.StatusNotFound
	7,  // 5: protos.SigningStatus.started:type_name -> protos.StatusStarted
	8,  // 6: protos.SigningStatus.running:type_name -> protos.StatusRunning
	9,  // 7: protos.SigningStatus.failed:type_name -> protos.StatusFailed
	10, // 8: protos.SigningStatus.completed:type_name -> protos.StatusCompleted
	5,  // 9: protos.ReleaseService.UpdateSigningStatus:input_type -> protos.SigningStatus
	1,  // 10: protos.ReleaseService.UpdateSigningStatus:output_type -> protos.SigningRequest
	10, // [10:11] is the sub-list for method output_type
	9,  // [9:10] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_relui_proto_init() }
func file_relui_proto_init() {
	if File_relui_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_relui_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SigningRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_relui_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_relui_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignArtifactStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_relui_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignArtifactCancelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_relui_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SigningStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_relui_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusNotFound); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_relui_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusStarted); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_relui_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusRunning); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_relui_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusFailed); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_relui_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusCompleted); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_relui_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*SigningRequest_Sign)(nil),
		(*SigningRequest_Status)(nil),
		(*SigningRequest_Cancel)(nil),
	}
	file_relui_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*SigningStatus_NotFound)(nil),
		(*SigningStatus_Started)(nil),
		(*SigningStatus_Running)(nil),
		(*SigningStatus_Failed)(nil),
		(*SigningStatus_Completed)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_relui_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_relui_proto_goTypes,
		DependencyIndexes: file_relui_proto_depIdxs,
		EnumInfos:         file_relui_proto_enumTypes,
		MessageInfos:      file_relui_proto_msgTypes,
	}.Build()
	File_relui_proto = out.File
	file_relui_proto_rawDesc = nil
	file_relui_proto_goTypes = nil
	file_relui_proto_depIdxs = nil
}
