// Copyright 2021 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v4.23.4
// source: gomote.proto

package protos

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CreateInstanceResponse_Status int32

const (
	CreateInstanceResponse_UNKNOWN  CreateInstanceResponse_Status = 0
	CreateInstanceResponse_WAITING  CreateInstanceResponse_Status = 1
	CreateInstanceResponse_COMPLETE CreateInstanceResponse_Status = 2
)

// Enum value maps for CreateInstanceResponse_Status.
var (
	CreateInstanceResponse_Status_name = map[int32]string{
		0: "UNKNOWN",
		1: "WAITING",
		2: "COMPLETE",
	}
	CreateInstanceResponse_Status_value = map[string]int32{
		"UNKNOWN":  0,
		"WAITING":  1,
		"COMPLETE": 2,
	}
)

func (x CreateInstanceResponse_Status) Enum() *CreateInstanceResponse_Status {
	p := new(CreateInstanceResponse_Status)
	*p = x
	return p
}

func (x CreateInstanceResponse_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CreateInstanceResponse_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_gomote_proto_enumTypes[0].Descriptor()
}

func (CreateInstanceResponse_Status) Type() protoreflect.EnumType {
	return &file_gomote_proto_enumTypes[0]
}

func (x CreateInstanceResponse_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CreateInstanceResponse_Status.Descriptor instead.
func (CreateInstanceResponse_Status) EnumDescriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{5, 0}
}

// AuthenticateRequest specifies the data needed for an authentication request.
type AuthenticateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AuthenticateRequest) Reset() {
	*x = AuthenticateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticateRequest) ProtoMessage() {}

func (x *AuthenticateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticateRequest.ProtoReflect.Descriptor instead.
func (*AuthenticateRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{0}
}

// AuthenticateResponse contains authenticated user data.
type AuthenticateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AuthenticateResponse) Reset() {
	*x = AuthenticateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticateResponse) ProtoMessage() {}

func (x *AuthenticateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticateResponse.ProtoReflect.Descriptor instead.
func (*AuthenticateResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{1}
}

// AddBootstrapRequest specifies the data needed for a request to add the bootstrap version of Go
// to the instance.
type AddBootstrapRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a gomote instance.
	GomoteId string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
}

func (x *AddBootstrapRequest) Reset() {
	*x = AddBootstrapRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddBootstrapRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddBootstrapRequest) ProtoMessage() {}

func (x *AddBootstrapRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddBootstrapRequest.ProtoReflect.Descriptor instead.
func (*AddBootstrapRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{2}
}

func (x *AddBootstrapRequest) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

// AddBootstrapResponse contains the information about the add bootstrap request.
type AddBootstrapResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL for the Go version added to the work directory.
	// If empty, the bootstrap version is undefined and has probably been included in
	// the instance image.
	BootstrapGoUrl string `protobuf:"bytes,1,opt,name=bootstrap_go_url,json=bootstrapGoUrl,proto3" json:"bootstrap_go_url,omitempty"`
}

func (x *AddBootstrapResponse) Reset() {
	*x = AddBootstrapResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddBootstrapResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddBootstrapResponse) ProtoMessage() {}

func (x *AddBootstrapResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddBootstrapResponse.ProtoReflect.Descriptor instead.
func (*AddBootstrapResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{3}
}

func (x *AddBootstrapResponse) GetBootstrapGoUrl() string {
	if x != nil {
		return x.BootstrapGoUrl
	}
	return ""
}

// CreateInstanceRequest specifies the data needed to create a gomote instance.
type CreateInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BuilderType      string   `protobuf:"bytes,1,opt,name=builder_type,json=builderType,proto3" json:"builder_type,omitempty"`
	ExperimentOption []string `protobuf:"bytes,2,rep,name=experiment_option,json=experimentOption,proto3" json:"experiment_option,omitempty"`
}

func (x *CreateInstanceRequest) Reset() {
	*x = CreateInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceRequest) ProtoMessage() {}

func (x *CreateInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceRequest.ProtoReflect.Descriptor instead.
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{4}
}

func (x *CreateInstanceRequest) GetBuilderType() string {
	if x != nil {
		return x.BuilderType
	}
	return ""
}

func (x *CreateInstanceRequest) GetExperimentOption() []string {
	if x != nil {
		return x.ExperimentOption
	}
	return nil
}

// CreateInstanceResponse contains data about a created gomote instance.
type CreateInstanceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instance information for the requested instance.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The status for the requested create.
	Status CreateInstanceResponse_Status `protobuf:"varint,2,opt,name=status,proto3,enum=protos.CreateInstanceResponse_Status" json:"status,omitempty"`
	// Waiters ahead is the count of how many instances are being scheduled for
	// creation before the current instance creation request.
	WaitersAhead int64 `protobuf:"varint,3,opt,name=waiters_ahead,json=waitersAhead,proto3" json:"waiters_ahead,omitempty"`
}

func (x *CreateInstanceResponse) Reset() {
	*x = CreateInstanceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInstanceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceResponse) ProtoMessage() {}

func (x *CreateInstanceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceResponse.ProtoReflect.Descriptor instead.
func (*CreateInstanceResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{5}
}

func (x *CreateInstanceResponse) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *CreateInstanceResponse) GetStatus() CreateInstanceResponse_Status {
	if x != nil {
		return x.Status
	}
	return CreateInstanceResponse_UNKNOWN
}

func (x *CreateInstanceResponse) GetWaitersAhead() int64 {
	if x != nil {
		return x.WaitersAhead
	}
	return 0
}

// DestroyInstanceRequest specifies the data needed to destroy a gomote instance.
type DestroyInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a gomote instance.
	GomoteId string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
}

func (x *DestroyInstanceRequest) Reset() {
	*x = DestroyInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestroyInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestroyInstanceRequest) ProtoMessage() {}

func (x *DestroyInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestroyInstanceRequest.ProtoReflect.Descriptor instead.
func (*DestroyInstanceRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{6}
}

func (x *DestroyInstanceRequest) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

// DestroyInstanceResponse contains data about a destroyed gomote instance.
type DestroyInstanceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DestroyInstanceResponse) Reset() {
	*x = DestroyInstanceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestroyInstanceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestroyInstanceResponse) ProtoMessage() {}

func (x *DestroyInstanceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestroyInstanceResponse.ProtoReflect.Descriptor instead.
func (*DestroyInstanceResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{7}
}

// ExecuteCommandRequest specifies the data needed to execute a command on a gomote instance.
type ExecuteCommandRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a gomote instance.
	GomoteId string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
	// The command to be executed on the buildlet.
	Command string `protobuf:"bytes,2,opt,name=command,proto3" json:"command,omitempty"`
	// Controls whether the command is run outside of the buildlet's environment.
	SystemLevel bool `protobuf:"varint,3,opt,name=system_level,json=systemLevel,proto3" json:"system_level,omitempty"`
	// Debug will instruct the buildlet to include extra debugging information in the output.
	Debug bool `protobuf:"varint,4,opt,name=debug,proto3" json:"debug,omitempty"`
	// These are additional environmental variables to include in the buildlet's process's
	// environment.
	AppendEnvironment []string `protobuf:"bytes,5,rep,name=append_environment,json=appendEnvironment,proto3" json:"append_environment,omitempty"`
	// Path specifies the PATH variable of the executed procesess's environment.
	// A non-nil entry will clear the existing PATH value.
	// The string "$PATH" expands to any existing PATH element(s).
	// The substring "$WORKDIR" expands to buildlet's temp workdir.
	Path []string `protobuf:"bytes,6,rep,name=path,proto3" json:"path,omitempty"`
	// The directory from which to execute the command.
	// If not specified, it defaults to the directory of the command or the
	// work directory if system level is set.
	Directory string `protobuf:"bytes,7,opt,name=directory,proto3" json:"directory,omitempty"`
	// The arguments to pass to the command.
	Args []string `protobuf:"bytes,8,rep,name=args,proto3" json:"args,omitempty"`
	// Optional alternate builder to act like. It must be a compatible builder.
	ImitateHostType string `protobuf:"bytes,9,opt,name=imitate_host_type,json=imitateHostType,proto3" json:"imitate_host_type,omitempty"`
}

func (x *ExecuteCommandRequest) Reset() {
	*x = ExecuteCommandRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteCommandRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteCommandRequest) ProtoMessage() {}

func (x *ExecuteCommandRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteCommandRequest.ProtoReflect.Descriptor instead.
func (*ExecuteCommandRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{8}
}

func (x *ExecuteCommandRequest) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

func (x *ExecuteCommandRequest) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *ExecuteCommandRequest) GetSystemLevel() bool {
	if x != nil {
		return x.SystemLevel
	}
	return false
}

func (x *ExecuteCommandRequest) GetDebug() bool {
	if x != nil {
		return x.Debug
	}
	return false
}

func (x *ExecuteCommandRequest) GetAppendEnvironment() []string {
	if x != nil {
		return x.AppendEnvironment
	}
	return nil
}

func (x *ExecuteCommandRequest) GetPath() []string {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *ExecuteCommandRequest) GetDirectory() string {
	if x != nil {
		return x.Directory
	}
	return ""
}

func (x *ExecuteCommandRequest) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ExecuteCommandRequest) GetImitateHostType() string {
	if x != nil {
		return x.ImitateHostType
	}
	return ""
}

// ExecuteCommandResponse contains data about the executed command.
type ExecuteCommandResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output from the executed command.
	Output []byte `protobuf:"bytes,1,opt,name=output,proto3" json:"output,omitempty"`
}

func (x *ExecuteCommandResponse) Reset() {
	*x = ExecuteCommandResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteCommandResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteCommandResponse) ProtoMessage() {}

func (x *ExecuteCommandResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteCommandResponse.ProtoReflect.Descriptor instead.
func (*ExecuteCommandResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{9}
}

func (x *ExecuteCommandResponse) GetOutput() []byte {
	if x != nil {
		return x.Output
	}
	return nil
}

// Instance contains descriptive information about a gomote instance.
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a gomote instance.
	GomoteId string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
	// Builder type for the gomote instance.
	BuilderType string `protobuf:"bytes,2,opt,name=builder_type,json=builderType,proto3" json:"builder_type,omitempty"`
	// Host type for the gomote instance.
	HostType string `protobuf:"bytes,3,opt,name=host_type,json=hostType,proto3" json:"host_type,omitempty"`
	// The timestamp for when the builder instance will expire. It is
	// represented in Unix epoch time format.
	Expires int64 `protobuf:"varint,4,opt,name=expires,proto3" json:"expires,omitempty"`
	// The working directory of the instance.
	WorkingDir string `protobuf:"bytes,5,opt,name=working_dir,json=workingDir,proto3" json:"working_dir,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{10}
}

func (x *Instance) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

func (x *Instance) GetBuilderType() string {
	if x != nil {
		return x.BuilderType
	}
	return ""
}

func (x *Instance) GetHostType() string {
	if x != nil {
		return x.HostType
	}
	return ""
}

func (x *Instance) GetExpires() int64 {
	if x != nil {
		return x.Expires
	}
	return 0
}

func (x *Instance) GetWorkingDir() string {
	if x != nil {
		return x.WorkingDir
	}
	return ""
}

// InstanceAliveRequest specifies the data needed to check the liveness of a gomote instance.
type InstanceAliveRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a gomote instance.
	GomoteId string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
}

func (x *InstanceAliveRequest) Reset() {
	*x = InstanceAliveRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceAliveRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceAliveRequest) ProtoMessage() {}

func (x *InstanceAliveRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceAliveRequest.ProtoReflect.Descriptor instead.
func (*InstanceAliveRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{11}
}

func (x *InstanceAliveRequest) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

// InstanceAliveResponse contains instance liveness state.
type InstanceAliveResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InstanceAliveResponse) Reset() {
	*x = InstanceAliveResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceAliveResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceAliveResponse) ProtoMessage() {}

func (x *InstanceAliveResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceAliveResponse.ProtoReflect.Descriptor instead.
func (*InstanceAliveResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{12}
}

// ListDirectoryRequest specifies the data needed to list contents of a directory from a gomote instance.
type ListDirectoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a gomote instance.
	GomoteId string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
	// The directory to list the contents of. The directory dir itself is not included.
	Directory string `protobuf:"bytes,2,opt,name=directory,proto3" json:"directory,omitempty"`
	// Controls whether the directory is listed recursively.
	Recursive bool `protobuf:"varint,3,opt,name=recursive,proto3" json:"recursive,omitempty"`
	// The directories to skip, relative to the main directory.
	// Each item should contain only forward slashes and not start or end in slashes.
	SkipFiles []string `protobuf:"bytes,4,rep,name=skip_files,json=skipFiles,proto3" json:"skip_files,omitempty"`
	// Controls whether the SHA-1 of regular files are returned.
	Digest bool `protobuf:"varint,5,opt,name=digest,proto3" json:"digest,omitempty"`
}

func (x *ListDirectoryRequest) Reset() {
	*x = ListDirectoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDirectoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDirectoryRequest) ProtoMessage() {}

func (x *ListDirectoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDirectoryRequest.ProtoReflect.Descriptor instead.
func (*ListDirectoryRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{13}
}

func (x *ListDirectoryRequest) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

func (x *ListDirectoryRequest) GetDirectory() string {
	if x != nil {
		return x.Directory
	}
	return ""
}

func (x *ListDirectoryRequest) GetRecursive() bool {
	if x != nil {
		return x.Recursive
	}
	return false
}

func (x *ListDirectoryRequest) GetSkipFiles() []string {
	if x != nil {
		return x.SkipFiles
	}
	return nil
}

func (x *ListDirectoryRequest) GetDigest() bool {
	if x != nil {
		return x.Digest
	}
	return false
}

// ListDirectoryResponse contains the directory listing of a gomote instance.
type ListDirectoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The directory entries.
	Entries []string `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *ListDirectoryResponse) Reset() {
	*x = ListDirectoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDirectoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDirectoryResponse) ProtoMessage() {}

func (x *ListDirectoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDirectoryResponse.ProtoReflect.Descriptor instead.
func (*ListDirectoryResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{14}
}

func (x *ListDirectoryResponse) GetEntries() []string {
	if x != nil {
		return x.Entries
	}
	return nil
}

// ListInstancesRequest specifies the data needed to list the live gomote instances owned by the caller.
type ListInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ListInstancesRequest) Reset() {
	*x = ListInstancesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesRequest) ProtoMessage() {}

func (x *ListInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesRequest.ProtoReflect.Descriptor instead.
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{15}
}

// ListInstancesResponse contains the list of live gomote instances owned by the caller.
type ListInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *ListInstancesResponse) Reset() {
	*x = ListInstancesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesResponse) ProtoMessage() {}

func (x *ListInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesResponse.ProtoReflect.Descriptor instead.
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{16}
}

func (x *ListInstancesResponse) GetInstances() []*Instance {
	if x != nil {
		return x.Instances
	}
	return nil
}

// ListSwarmingBuildersRequest specifies the data needed to list all swarming builders.
type ListSwarmingBuildersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ListSwarmingBuildersRequest) Reset() {
	*x = ListSwarmingBuildersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSwarmingBuildersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSwarmingBuildersRequest) ProtoMessage() {}

func (x *ListSwarmingBuildersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSwarmingBuildersRequest.ProtoReflect.Descriptor instead.
func (*ListSwarmingBuildersRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{17}
}

// ListSwarmingBuildersResponse contains a list of swarming builders.
type ListSwarmingBuildersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Builders []string `protobuf:"bytes,1,rep,name=builders,proto3" json:"builders,omitempty"`
}

func (x *ListSwarmingBuildersResponse) Reset() {
	*x = ListSwarmingBuildersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSwarmingBuildersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSwarmingBuildersResponse) ProtoMessage() {}

func (x *ListSwarmingBuildersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSwarmingBuildersResponse.ProtoReflect.Descriptor instead.
func (*ListSwarmingBuildersResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{18}
}

func (x *ListSwarmingBuildersResponse) GetBuilders() []string {
	if x != nil {
		return x.Builders
	}
	return nil
}

// ReadTGZToURLRequest specifies the data needed to retrieve a tar and zipped directory from a gomote instance.
type ReadTGZToURLRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a gomote instance.
	GomoteId string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
	// The relative directory from the gomote's work directory to tar up.
	Directory string `protobuf:"bytes,2,opt,name=directory,proto3" json:"directory,omitempty"`
}

func (x *ReadTGZToURLRequest) Reset() {
	*x = ReadTGZToURLRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTGZToURLRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTGZToURLRequest) ProtoMessage() {}

func (x *ReadTGZToURLRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTGZToURLRequest.ProtoReflect.Descriptor instead.
func (*ReadTGZToURLRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{19}
}

func (x *ReadTGZToURLRequest) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

func (x *ReadTGZToURLRequest) GetDirectory() string {
	if x != nil {
		return x.Directory
	}
	return ""
}

// ReadTGZToURLResponse contains a URL where the tar and zipped directory from a gomote instance can be downloaded from.
type ReadTGZToURLResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL to retrieve the tarball from.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *ReadTGZToURLResponse) Reset() {
	*x = ReadTGZToURLResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTGZToURLResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTGZToURLResponse) ProtoMessage() {}

func (x *ReadTGZToURLResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTGZToURLResponse.ProtoReflect.Descriptor instead.
func (*ReadTGZToURLResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{20}
}

func (x *ReadTGZToURLResponse) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// RemoveFilesRequest specifies the data needed to remove files or directories from a gomote instance.
type RemoveFilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a gomote instance.
	GomoteId string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
	// The list of paths for files or directories to remove from the file system.
	// When everything should be deleted, "." should be used.
	// The paths are relative to the work directory.
	Paths []string `protobuf:"bytes,2,rep,name=paths,proto3" json:"paths,omitempty"`
}

func (x *RemoveFilesRequest) Reset() {
	*x = RemoveFilesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveFilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveFilesRequest) ProtoMessage() {}

func (x *RemoveFilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveFilesRequest.ProtoReflect.Descriptor instead.
func (*RemoveFilesRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{21}
}

func (x *RemoveFilesRequest) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

func (x *RemoveFilesRequest) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

// RemoveFilesResponse contains the results from removing files or directories from a gomote instance.
type RemoveFilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveFilesResponse) Reset() {
	*x = RemoveFilesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveFilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveFilesResponse) ProtoMessage() {}

func (x *RemoveFilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveFilesResponse.ProtoReflect.Descriptor instead.
func (*RemoveFilesResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{22}
}

// SignSSHKeyRequest specifies the data needed to sign a public SSH key which attaches a certificate to the key.
type SignSSHKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a gomote instance.
	GomoteId string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
	// A user provided public SSH key which the user intends to initiate an SSH session with.
	PublicSshKey []byte `protobuf:"bytes,2,opt,name=public_ssh_key,json=publicSshKey,proto3" json:"public_ssh_key,omitempty"`
}

func (x *SignSSHKeyRequest) Reset() {
	*x = SignSSHKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignSSHKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignSSHKeyRequest) ProtoMessage() {}

func (x *SignSSHKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignSSHKeyRequest.ProtoReflect.Descriptor instead.
func (*SignSSHKeyRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{23}
}

func (x *SignSSHKeyRequest) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

func (x *SignSSHKeyRequest) GetPublicSshKey() []byte {
	if x != nil {
		return x.PublicSshKey
	}
	return nil
}

// SignSSHKeyResponse contains the results from a request to sign a public SSH key.
type SignSSHKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A signed SSH key can be used in conjunction with the associated private key to initiate an SSH session to a gomote instance.
	// The certificate attached to the key will contain principles which restrict the instance that can be logged into.
	SignedPublicSshKey []byte `protobuf:"bytes,1,opt,name=signed_public_ssh_key,json=signedPublicSshKey,proto3" json:"signed_public_ssh_key,omitempty"`
}

func (x *SignSSHKeyResponse) Reset() {
	*x = SignSSHKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignSSHKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignSSHKeyResponse) ProtoMessage() {}

func (x *SignSSHKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignSSHKeyResponse.ProtoReflect.Descriptor instead.
func (*SignSSHKeyResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{24}
}

func (x *SignSSHKeyResponse) GetSignedPublicSshKey() []byte {
	if x != nil {
		return x.SignedPublicSshKey
	}
	return nil
}

// UploadFileRequest specifies the data needed to create a request to upload an object to GCS.
type UploadFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UploadFileRequest) Reset() {
	*x = UploadFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadFileRequest) ProtoMessage() {}

func (x *UploadFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadFileRequest.ProtoReflect.Descriptor instead.
func (*UploadFileRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{25}
}

// UploadFileResponse contains the results from a request to upload an object to GCS.
type UploadFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL to post file to.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Form fields used when http posting files to GCS.
	Fields map[string]string `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Name used to reference the object.
	ObjectName string `protobuf:"bytes,3,opt,name=object_name,json=objectName,proto3" json:"object_name,omitempty"`
}

func (x *UploadFileResponse) Reset() {
	*x = UploadFileResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadFileResponse) ProtoMessage() {}

func (x *UploadFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadFileResponse.ProtoReflect.Descriptor instead.
func (*UploadFileResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{26}
}

func (x *UploadFileResponse) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *UploadFileResponse) GetFields() map[string]string {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *UploadFileResponse) GetObjectName() string {
	if x != nil {
		return x.ObjectName
	}
	return ""
}

// WriteFileFromURLRequest specifies the data needed to request that a gomote download the contents of a URL and place
// the contents in a file.
type WriteFileFromURLRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a gomote instance.
	GomoteId string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
	// URL to post get file from.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// The filename as it should appear at the destination.
	Filename string `protobuf:"bytes,3,opt,name=filename,proto3" json:"filename,omitempty"`
	// The file mode.
	Mode uint32 `protobuf:"fixed32,4,opt,name=mode,proto3" json:"mode,omitempty"`
}

func (x *WriteFileFromURLRequest) Reset() {
	*x = WriteFileFromURLRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteFileFromURLRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteFileFromURLRequest) ProtoMessage() {}

func (x *WriteFileFromURLRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteFileFromURLRequest.ProtoReflect.Descriptor instead.
func (*WriteFileFromURLRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{27}
}

func (x *WriteFileFromURLRequest) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

func (x *WriteFileFromURLRequest) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *WriteFileFromURLRequest) GetFilename() string {
	if x != nil {
		return x.Filename
	}
	return ""
}

func (x *WriteFileFromURLRequest) GetMode() uint32 {
	if x != nil {
		return x.Mode
	}
	return 0
}

// WriteFileFromURLResponse contains the results from requesting that a file be downloaded onto a gomote instance.
type WriteFileFromURLResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WriteFileFromURLResponse) Reset() {
	*x = WriteFileFromURLResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteFileFromURLResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteFileFromURLResponse) ProtoMessage() {}

func (x *WriteFileFromURLResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteFileFromURLResponse.ProtoReflect.Descriptor instead.
func (*WriteFileFromURLResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{28}
}

// WriteTGZFromURLRequest specifies the data needed to retrieve a file and expand it onto the file system of a gomote instance.
// It instructs the buildlet to download the tar.gz file from the url and write it to a directory, a relative directory from the workdir.
// If the directory is empty, they're placed at the root of the buildlet's work directory.
// The directory is created if necessary.
// The url must be of a tar.gz file.
type WriteTGZFromURLRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GomoteId  string `protobuf:"bytes,1,opt,name=gomote_id,json=gomoteId,proto3" json:"gomote_id,omitempty"`
	Url       string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	Directory string `protobuf:"bytes,3,opt,name=directory,proto3" json:"directory,omitempty"`
}

func (x *WriteTGZFromURLRequest) Reset() {
	*x = WriteTGZFromURLRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteTGZFromURLRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteTGZFromURLRequest) ProtoMessage() {}

func (x *WriteTGZFromURLRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteTGZFromURLRequest.ProtoReflect.Descriptor instead.
func (*WriteTGZFromURLRequest) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{29}
}

func (x *WriteTGZFromURLRequest) GetGomoteId() string {
	if x != nil {
		return x.GomoteId
	}
	return ""
}

func (x *WriteTGZFromURLRequest) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *WriteTGZFromURLRequest) GetDirectory() string {
	if x != nil {
		return x.Directory
	}
	return ""
}

// WriteTGZFromURLResponse contains the results from retrieving a file and expanding it onto the file system of a gomote instance.
type WriteTGZFromURLResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WriteTGZFromURLResponse) Reset() {
	*x = WriteTGZFromURLResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gomote_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteTGZFromURLResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteTGZFromURLResponse) ProtoMessage() {}

func (x *WriteTGZFromURLResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gomote_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteTGZFromURLResponse.ProtoReflect.Descriptor instead.
func (*WriteTGZFromURLResponse) Descriptor() ([]byte, []int) {
	return file_gomote_proto_rawDescGZIP(), []int{30}
}

var File_gomote_proto protoreflect.FileDescriptor

var file_gomote_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x22, 0x15, 0x0a, 0x13, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x16, 0x0a,
	0x14, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0x0a, 0x13, 0x41, 0x64, 0x64, 0x42, 0x6f, 0x6f, 0x74,
	0x73, 0x74, 0x72, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x22, 0x40, 0x0a, 0x14, 0x41, 0x64, 0x64,
	0x42, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x28, 0x0a, 0x10, 0x62, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x5f, 0x67,
	0x6f, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x62, 0x6f, 0x6f,
	0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x47, 0x6f, 0x55, 0x72, 0x6c, 0x22, 0x67, 0x0a, 0x15, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x10, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdc, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x2c, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x3d, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d,
	0x77, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x61, 0x68, 0x65, 0x61, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0c, 0x77, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73, 0x41, 0x68, 0x65, 0x61,
	0x64, 0x22, 0x30, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x49, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54,
	0x45, 0x10, 0x02, 0x22, 0x35, 0x0a, 0x16, 0x44, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x22, 0x19, 0x0a, 0x17, 0x44, 0x65,
	0x73, 0x74, 0x72, 0x6f, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa8, 0x02, 0x0a, 0x15, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x64, 0x65, 0x62,
	0x75, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x64, 0x65, 0x62, 0x75, 0x67, 0x12,
	0x2d, 0x0a, 0x12, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x64, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04,
	0x61, 0x72, 0x67, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x69, 0x6d, 0x69, 0x74, 0x61, 0x74, 0x65, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x69, 0x6d, 0x69, 0x74, 0x61, 0x74, 0x65, 0x48, 0x6f, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x22, 0x30, 0x0a, 0x16, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x22, 0xa2, 0x01, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x77, 0x6f, 0x72,
	0x6b, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x72, 0x22, 0x33, 0x0a, 0x14, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x41, 0x6c, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x22, 0x17, 0x0a, 0x15,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x69, 0x76, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x63,
	0x75, 0x72, 0x73, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x72, 0x65,
	0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6b, 0x69, 0x70, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73, 0x6b, 0x69,
	0x70, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x22, 0x31,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x22, 0x16, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x47, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2e, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x22, 0x1d, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x77, 0x61, 0x72, 0x6d, 0x69,
	0x6e, 0x67, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0x3a, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x77, 0x61, 0x72, 0x6d, 0x69, 0x6e,
	0x67, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x08, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x22, 0x50, 0x0a,
	0x13, 0x52, 0x65, 0x61, 0x64, 0x54, 0x47, 0x5a, 0x54, 0x6f, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49,
	0x64, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x22,
	0x28, 0x0a, 0x14, 0x52, 0x65, 0x61, 0x64, 0x54, 0x47, 0x5a, 0x54, 0x6f, 0x55, 0x52, 0x4c, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x22, 0x47, 0x0a, 0x12, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05,
	0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x70, 0x61, 0x74,
	0x68, 0x73, 0x22, 0x15, 0x0a, 0x13, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0x0a, 0x11, 0x53, 0x69, 0x67,
	0x6e, 0x53, 0x53, 0x48, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x73, 0x73, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x53, 0x73, 0x68, 0x4b, 0x65,
	0x79, 0x22, 0x47, 0x0a, 0x12, 0x53, 0x69, 0x67, 0x6e, 0x53, 0x53, 0x48, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x15, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x73, 0x73, 0x68, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x12, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x53, 0x73, 0x68, 0x4b, 0x65, 0x79, 0x22, 0x13, 0x0a, 0x11, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22,
	0xc2, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x3e, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x78, 0x0a, 0x17, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x46, 0x72, 0x6f, 0x6d, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x1a,
	0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x07, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x1a,
	0x0a, 0x18, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x55,
	0x52, 0x4c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x65, 0x0a, 0x16, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x54, 0x47, 0x5a, 0x46, 0x72, 0x6f, 0x6d, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x49,
	0x64, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x22, 0x19, 0x0a, 0x17, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x47, 0x5a, 0x46, 0x72, 0x6f,
	0x6d, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xd2, 0x09, 0x0a,
	0x0d, 0x47, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x4b,
	0x0a, 0x0c, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x1b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4b, 0x0a, 0x0c, 0x41,
	0x64, 0x64, 0x42, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x12, 0x1b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x42, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x41, 0x64, 0x64, 0x42, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x53, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1d, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x54, 0x0a,
	0x0f, 0x44, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x1e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x72, 0x6f,
	0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x72, 0x6f,
	0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x53, 0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x4e, 0x0a, 0x0d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x69, 0x76, 0x65, 0x12, 0x1c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x69, 0x76, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x69, 0x76, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4e, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4e, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x1c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x63, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x77, 0x61, 0x72, 0x6d, 0x69, 0x6e, 0x67, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x12, 0x23, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x77,
	0x61, 0x72, 0x6d, 0x69, 0x6e, 0x67, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x77, 0x61, 0x72, 0x6d, 0x69, 0x6e, 0x67, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4b, 0x0a,
	0x0c, 0x52, 0x65, 0x61, 0x64, 0x54, 0x47, 0x5a, 0x54, 0x6f, 0x55, 0x52, 0x4c, 0x12, 0x1b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x54, 0x47, 0x5a, 0x54, 0x6f,
	0x55, 0x52, 0x4c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x54, 0x47, 0x5a, 0x54, 0x6f, 0x55, 0x52, 0x4c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x48, 0x0a, 0x0b, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x45, 0x0a, 0x0a, 0x53, 0x69, 0x67, 0x6e, 0x53, 0x53, 0x48, 0x4b,
	0x65, 0x79, 0x12, 0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x53, 0x69, 0x67, 0x6e,
	0x53, 0x53, 0x48, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x53, 0x53, 0x48, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x45, 0x0a, 0x0a, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x57, 0x0a, 0x10, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x46,
	0x72, 0x6f, 0x6d, 0x55, 0x52, 0x4c, 0x12, 0x1f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x55, 0x52, 0x4c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x55, 0x52,
	0x4c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x54, 0x0a, 0x0f, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x54, 0x47, 0x5a, 0x46, 0x72, 0x6f, 0x6d, 0x55, 0x52, 0x4c, 0x12, 0x1e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x47, 0x5a,
	0x46, 0x72, 0x6f, 0x6d, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x47, 0x5a,
	0x46, 0x72, 0x6f, 0x6d, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x42, 0x2b, 0x5a, 0x29, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x78, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2f, 0x67, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_gomote_proto_rawDescOnce sync.Once
	file_gomote_proto_rawDescData = file_gomote_proto_rawDesc
)

func file_gomote_proto_rawDescGZIP() []byte {
	file_gomote_proto_rawDescOnce.Do(func() {
		file_gomote_proto_rawDescData = protoimpl.X.CompressGZIP(file_gomote_proto_rawDescData)
	})
	return file_gomote_proto_rawDescData
}

var file_gomote_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_gomote_proto_msgTypes = make([]protoimpl.MessageInfo, 32)
var file_gomote_proto_goTypes = []interface{}{
	(CreateInstanceResponse_Status)(0),   // 0: protos.CreateInstanceResponse.Status
	(*AuthenticateRequest)(nil),          // 1: protos.AuthenticateRequest
	(*AuthenticateResponse)(nil),         // 2: protos.AuthenticateResponse
	(*AddBootstrapRequest)(nil),          // 3: protos.AddBootstrapRequest
	(*AddBootstrapResponse)(nil),         // 4: protos.AddBootstrapResponse
	(*CreateInstanceRequest)(nil),        // 5: protos.CreateInstanceRequest
	(*CreateInstanceResponse)(nil),       // 6: protos.CreateInstanceResponse
	(*DestroyInstanceRequest)(nil),       // 7: protos.DestroyInstanceRequest
	(*DestroyInstanceResponse)(nil),      // 8: protos.DestroyInstanceResponse
	(*ExecuteCommandRequest)(nil),        // 9: protos.ExecuteCommandRequest
	(*ExecuteCommandResponse)(nil),       // 10: protos.ExecuteCommandResponse
	(*Instance)(nil),                     // 11: protos.Instance
	(*InstanceAliveRequest)(nil),         // 12: protos.InstanceAliveRequest
	(*InstanceAliveResponse)(nil),        // 13: protos.InstanceAliveResponse
	(*ListDirectoryRequest)(nil),         // 14: protos.ListDirectoryRequest
	(*ListDirectoryResponse)(nil),        // 15: protos.ListDirectoryResponse
	(*ListInstancesRequest)(nil),         // 16: protos.ListInstancesRequest
	(*ListInstancesResponse)(nil),        // 17: protos.ListInstancesResponse
	(*ListSwarmingBuildersRequest)(nil),  // 18: protos.ListSwarmingBuildersRequest
	(*ListSwarmingBuildersResponse)(nil), // 19: protos.ListSwarmingBuildersResponse
	(*ReadTGZToURLRequest)(nil),          // 20: protos.ReadTGZToURLRequest
	(*ReadTGZToURLResponse)(nil),         // 21: protos.ReadTGZToURLResponse
	(*RemoveFilesRequest)(nil),           // 22: protos.RemoveFilesRequest
	(*RemoveFilesResponse)(nil),          // 23: protos.RemoveFilesResponse
	(*SignSSHKeyRequest)(nil),            // 24: protos.SignSSHKeyRequest
	(*SignSSHKeyResponse)(nil),           // 25: protos.SignSSHKeyResponse
	(*UploadFileRequest)(nil),            // 26: protos.UploadFileRequest
	(*UploadFileResponse)(nil),           // 27: protos.UploadFileResponse
	(*WriteFileFromURLRequest)(nil),      // 28: protos.WriteFileFromURLRequest
	(*WriteFileFromURLResponse)(nil),     // 29: protos.WriteFileFromURLResponse
	(*WriteTGZFromURLRequest)(nil),       // 30: protos.WriteTGZFromURLRequest
	(*WriteTGZFromURLResponse)(nil),      // 31: protos.WriteTGZFromURLResponse
	nil,                                  // 32: protos.UploadFileResponse.FieldsEntry
}
var file_gomote_proto_depIdxs = []int32{
	11, // 0: protos.CreateInstanceResponse.instance:type_name -> protos.Instance
	0,  // 1: protos.CreateInstanceResponse.status:type_name -> protos.CreateInstanceResponse.Status
	11, // 2: protos.ListInstancesResponse.instances:type_name -> protos.Instance
	32, // 3: protos.UploadFileResponse.fields:type_name -> protos.UploadFileResponse.FieldsEntry
	1,  // 4: protos.GomoteService.Authenticate:input_type -> protos.AuthenticateRequest
	3,  // 5: protos.GomoteService.AddBootstrap:input_type -> protos.AddBootstrapRequest
	5,  // 6: protos.GomoteService.CreateInstance:input_type -> protos.CreateInstanceRequest
	7,  // 7: protos.GomoteService.DestroyInstance:input_type -> protos.DestroyInstanceRequest
	9,  // 8: protos.GomoteService.ExecuteCommand:input_type -> protos.ExecuteCommandRequest
	12, // 9: protos.GomoteService.InstanceAlive:input_type -> protos.InstanceAliveRequest
	14, // 10: protos.GomoteService.ListDirectory:input_type -> protos.ListDirectoryRequest
	16, // 11: protos.GomoteService.ListInstances:input_type -> protos.ListInstancesRequest
	18, // 12: protos.GomoteService.ListSwarmingBuilders:input_type -> protos.ListSwarmingBuildersRequest
	20, // 13: protos.GomoteService.ReadTGZToURL:input_type -> protos.ReadTGZToURLRequest
	22, // 14: protos.GomoteService.RemoveFiles:input_type -> protos.RemoveFilesRequest
	24, // 15: protos.GomoteService.SignSSHKey:input_type -> protos.SignSSHKeyRequest
	26, // 16: protos.GomoteService.UploadFile:input_type -> protos.UploadFileRequest
	28, // 17: protos.GomoteService.WriteFileFromURL:input_type -> protos.WriteFileFromURLRequest
	30, // 18: protos.GomoteService.WriteTGZFromURL:input_type -> protos.WriteTGZFromURLRequest
	2,  // 19: protos.GomoteService.Authenticate:output_type -> protos.AuthenticateResponse
	4,  // 20: protos.GomoteService.AddBootstrap:output_type -> protos.AddBootstrapResponse
	6,  // 21: protos.GomoteService.CreateInstance:output_type -> protos.CreateInstanceResponse
	8,  // 22: protos.GomoteService.DestroyInstance:output_type -> protos.DestroyInstanceResponse
	10, // 23: protos.GomoteService.ExecuteCommand:output_type -> protos.ExecuteCommandResponse
	13, // 24: protos.GomoteService.InstanceAlive:output_type -> protos.InstanceAliveResponse
	15, // 25: protos.GomoteService.ListDirectory:output_type -> protos.ListDirectoryResponse
	17, // 26: protos.GomoteService.ListInstances:output_type -> protos.ListInstancesResponse
	19, // 27: protos.GomoteService.ListSwarmingBuilders:output_type -> protos.ListSwarmingBuildersResponse
	21, // 28: protos.GomoteService.ReadTGZToURL:output_type -> protos.ReadTGZToURLResponse
	23, // 29: protos.GomoteService.RemoveFiles:output_type -> protos.RemoveFilesResponse
	25, // 30: protos.GomoteService.SignSSHKey:output_type -> protos.SignSSHKeyResponse
	27, // 31: protos.GomoteService.UploadFile:output_type -> protos.UploadFileResponse
	29, // 32: protos.GomoteService.WriteFileFromURL:output_type -> protos.WriteFileFromURLResponse
	31, // 33: protos.GomoteService.WriteTGZFromURL:output_type -> protos.WriteTGZFromURLResponse
	19, // [19:34] is the sub-list for method output_type
	4,  // [4:19] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_gomote_proto_init() }
func file_gomote_proto_init() {
	if File_gomote_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_gomote_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthenticateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthenticateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddBootstrapRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddBootstrapResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateInstanceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestroyInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestroyInstanceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteCommandRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteCommandResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceAliveRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceAliveResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDirectoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDirectoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListInstancesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListInstancesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSwarmingBuildersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSwarmingBuildersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTGZToURLRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTGZToURLResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveFilesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveFilesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignSSHKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignSSHKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadFileResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteFileFromURLRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteFileFromURLResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteTGZFromURLRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gomote_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteTGZFromURLResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_gomote_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   32,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_gomote_proto_goTypes,
		DependencyIndexes: file_gomote_proto_depIdxs,
		EnumInfos:         file_gomote_proto_enumTypes,
		MessageInfos:      file_gomote_proto_msgTypes,
	}.Build()
	File_gomote_proto = out.File
	file_gomote_proto_rawDesc = nil
	file_gomote_proto_goTypes = nil
	file_gomote_proto_depIdxs = nil
}
