/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.params;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.transforms.TransformParam;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InclusiveNamespaces
extends ElementProxy
implements TransformParam {
    public static final String _TAG_EC_INCLUSIVENAMESPACES = "InclusiveNamespaces";
    public static final String _ATT_EC_PREFIXLIST = "PrefixList";
    public static final String ExclusiveCanonicalizationNamespace = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public InclusiveNamespaces(Document document, String string) {
        this(document, InclusiveNamespaces.prefixStr2Set(string));
    }

    public InclusiveNamespaces(Document document, Set<String> set) {
        super(document);
        TreeSet<String> treeSet = null;
        treeSet = set instanceof SortedSet ? (TreeSet<String>)set : new TreeSet<String>(set);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : treeSet) {
            if ("xmlns".equals(string)) {
                stringBuilder.append("#default ");
                continue;
            }
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        this.setLocalAttribute(_ATT_EC_PREFIXLIST, stringBuilder.toString().trim());
    }

    public InclusiveNamespaces(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public String getInclusiveNamespaces() {
        return this.getLocalAttribute(_ATT_EC_PREFIXLIST);
    }

    public static SortedSet<String> prefixStr2Set(String string) {
        String[] stringArray;
        TreeSet<String> treeSet = new TreeSet<String>();
        if (string == null || string.length() == 0) {
            return treeSet;
        }
        for (String string2 : stringArray = string.split("\\s")) {
            if (string2.equals("#default")) {
                treeSet.add("xmlns");
                continue;
            }
            treeSet.add(string2);
        }
        return treeSet;
    }

    @Override
    public String getBaseNamespace() {
        return ExclusiveCanonicalizationNamespace;
    }

    @Override
    public String getBaseLocalName() {
        return _TAG_EC_INCLUSIVENAMESPACES;
    }
}

