package bytematcher

import (
	"bytes"
	"testing"

	//"github.com/richardlehane/siegfried/internal/bytematcher/frames"
	"github.com/richardlehane/siegfried/internal/bytematcher/frames/tests"
	"github.com/richardlehane/siegfried/internal/siegreader"

	//"github.com/richardlehane/siegfried/pkg/config"
	"github.com/richardlehane/siegfried/pkg/core"
)

func setup() (chan<- strike, <-chan core.Result) {
	m, _, _ := Add(nil, SignatureSet(tests.TestSignatures), nil)
	bm := m.(*Matcher)
	bufs := siegreader.New()
	buf, _ := bufs.Get(bytes.NewBuffer(TestSample1))
	buf.SizeNow()
	res := make(chan core.Result)
	str, _ := bm.scorer(buf, bm.priorities.WaitSet(), make(chan struct{}), res)
	return str, res
}

func TestScorer(t *testing.T) {
	scorer, res := setup()
	scorer <- strike{0, 0, 0, 4, false, false}
	scorer <- strike{1, 0, 17, 9, true, false}
	scorer <- strike{1, 1, 30, 5, true, false}
	if r := <-res; r.Index() != 0 {
		t.Errorf("expecting result %d, got %d", 0, r.Index())
	}
}

// 2 Jan 17 BenchmarkScorer   	   20000	    111048 ns/op
func BenchmarkScorer(bench *testing.B) {
	for i := 0; i < bench.N; i++ {
		bench.StopTimer()
		scorer, res := setup()
		bench.StartTimer()
		scorer <- strike{0, 0, 0, 4, false, false}
		scorer <- strike{1, 0, 17, 9, true, false}
		scorer <- strike{1, 1, 30, 5, true, false}
		<-res
	}
}

// tests an out of memory issue caused by fmt/134 - github #94
// temp fixed by change in sig processing
/*
func TestIssue94(t *testing.T) {
	config.SetDistance(64000)
	config.SetRange(64000)
	sheetPDF := []byte("\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x00\x00\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05\xFF\xFB\x10\xC0\x01\x03\x01\x01\x05\x05\x0B\x00\x08\x09\x03\x09\x0A\x09\x04\x01\x02\x03\x0B\x00\x09\x09\x07\x05\x05\x04\x0A\x06\x08\x04\x08\x08\x08\x0B\x06\x01\x01\x02\x01\x00\x02\x09\x04\x02\x09\x09\x03\x07\x05\x04\x0A\x02\x08\x07\x06\x00\x08\x06\x0A\x05")
	m, _, _ := Add(nil, SignatureSet([]frames.Signature{tests.TestFmts[13405]}), nil)
	bm := m.(*Matcher)
	bufs := siegreader.New()
	buf, _ := bufs.Get(bytes.NewBuffer(sheetPDF))
	buf.SizeNow()
	res := make(chan core.Result)
	incoming := bm.scorer(buf, bm.priorities.WaitSet(), make(chan struct{}), res)
	incoming <- strike{0, 0, 0, 2, false, false}
	if r := <-res; r.Index() != 0 {
		t.Errorf("expecing result %d, got %d", 0, r.Index())
	}
}
*/
