SYD-X(1)

# NAME

syd-x - Check executability of the given files

# SYNOPSIS

*syd-x* _[-hcv]_ _[files...]_

# DESCRIPTION

*syd-x* checks executability of the given files. The check uses the
_execveat_(2) system call with the flag "AT_EXECVE_CHECK" on Linux>=6.14
and falls back to the _faccessat_(2) system call with the flag "X_OK" on
older Linux.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-c*
:< Exit with success if the "AT_EXECVE_CHECK" flag is supported.
|[ *-v*
:< Print file check status information on standard error.

# EXIT STATUS

*syd-x* exits with 0 on success or with the errno number on failure.

The utility _syd-err_(1) may be used to convert the error number into a
human readable string.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _syd-err_(1)

- *syd* homepage: https://sydbox.exherbo.org/
- Executability check: https://docs.kernel.org/next/userspace-api/check_exec.html

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
