#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
---
module: wireless_profiles
short_description: Resource module for Wireless Profiles
description:
  - Manage operations create, update and delete of the
    resource Wireless Profiles.
  - This API allows the user to create a Wireless Network
    Profile.
  - This API allows the user to delete Wireless Network
    Profile by ID. - > This API allows the user to update
    a Wireless Network Profile by ID. Note that, when
    performing a PUT operation on a wireless network
    profile, it is essential to provide a complete payload.
    This is because the wireless network profile is
    tightly integrated with other network design entities.
    Consequently, all fields must be included—not just
    the fields to be updated. Any missing fields will
    be set to their default or null values. To ensure
    all fields are accurately populated, consider using
    the GET operation to retrieve the current resource
    data before proceeding with the PUT operation.
version_added: '6.15.0'
extends_documentation_fragment:
  - cisco.dnac.module
author: Rafael Campos (@racampos)
options:
  additionalInterfaces:
    description: These additional interfaces will be
      configured on the device as independent interfaces
      in addition to the interfaces mapped to SSIDs.
      Max Limit 4094.
    elements: str
    type: list
  apZones:
    description: Wireless Profiles's apZones.
    elements: dict
    suboptions:
      apZoneName:
        description: AP Zone Name.
        type: str
      rfProfileName:
        description: RF Profile Name.
        type: str
      ssids:
        description: Ssids part of apZone.
        elements: str
        type: list
    type: list
  featureTemplates:
    description: Wireless Profiles's featureTemplates.
    elements: dict
    suboptions:
      id:
        description: Feature Template UUID.
        type: str
      ssids:
        description: List of SSIDs.
        elements: str
        type: list
    type: list
  id:
    description: Id path parameter. Wireless Profile
      Id.
    type: str
  ssidDetails:
    description: Wireless Profiles's ssidDetails.
    elements: dict
    suboptions:
      anchorGroupName:
        description: Anchor Group Name.
        type: str
      dot11beProfileId:
        description: 802.11be Profile Id. Applicable
          to IOS controllers with version 17.15 and
          higher. 802.11be Profiles if passed, should
          be same across all SSIDs in network profile
          being configured.
        type: str
      enableFabric:
        description: True if fabric is enabled, else
          False. Flex and fabric cannot be enabled simultaneously
          and a profile can only contain either flex
          SSIDs or fabric SSIDs and not both at the
          same time.
        type: bool
      flexConnect:
        description: Wireless Profiles's flexConnect.
        suboptions:
          enableFlexConnect:
            description: True if flex connect is enabled,
              else False. Flex and fabric cannot be
              enabled simultaneously and a profile can
              only contain either flex SSIDs or fabric
              SSIDs and not both at the same time.
            type: bool
          localToVlan:
            description: Local to VLAN ID.
            type: int
        type: dict
      interfaceName:
        description: Interface Name.
        type: str
      policyProfileName:
        description: Policy Profile Name. If 'policyProfileName'
          is not provided, the value of 'wlanProfileName'
          will be assigned to it. If 'profileName' is
          also not provided, an autogenerated name will
          be used. Autogenerated name is generated by
          appending 'ssidName' field's value with '_profile'
          (Example If 'ssidName' = 'ExampleSsid', then
          autogenerated name will be 'ExampleSsid_profile').
        type: str
      ssidName:
        description: SSID Name.
        type: str
      vlanGroupName:
        description: VLAN Group Name.
        type: str
      wlanProfileName:
        description: WLAN Profile Name, if not passed
          autogenerated profile name will be assigned.
        type: str
    type: list
  wirelessProfileName:
    description: Wireless Network Profile Name.
    type: str
requirements:
  - dnacentersdk >= 2.4.9
  - python >= 3.5
seealso:
  - name: Cisco DNA Center documentation for Wireless
      CreateWirelessProfileConnectivity
    description: Complete reference of the CreateWirelessProfileConnectivity
      API.
    link: https://developer.cisco.com/docs/dna-center/#!create-wireless-profile-connectivity
  - name: Cisco DNA Center documentation for Wireless
      DeleteWirelessProfileConnectivity
    description: Complete reference of the DeleteWirelessProfileConnectivity
      API.
    link: https://developer.cisco.com/docs/dna-center/#!delete-wireless-profile-connectivity
  - name: Cisco DNA Center documentation for Wireless
      UpdateWirelessProfileConnectivity
    description: Complete reference of the UpdateWirelessProfileConnectivity
      API.
    link: https://developer.cisco.com/docs/dna-center/#!update-wireless-profile-connectivity
notes:
  - SDK Method used are
    wireless.Wireless.create_wireless_profile_connectivity,
    wireless.Wireless.delete_wireless_profile_connectivity,
    wireless.Wireless.update_wireless_profile_connectivity,
  - Paths used are
    post /dna/intent/api/v1/wirelessProfiles,
    delete /dna/intent/api/v1/wirelessProfiles/{id},
    put /dna/intent/api/v1/wirelessProfiles/{id},
"""

EXAMPLES = r"""
---
- name: Create
  cisco.dnac.wireless_profiles:
    dnac_host: "{{dnac_host}}"
    dnac_username: "{{dnac_username}}"
    dnac_password: "{{dnac_password}}"
    dnac_verify: "{{dnac_verify}}"
    dnac_port: "{{dnac_port}}"
    dnac_version: "{{dnac_version}}"
    dnac_debug: "{{dnac_debug}}"
    state: present
    additionalInterfaces:
      - string
    apZones:
      - apZoneName: string
        rfProfileName: string
        ssids:
          - string
    featureTemplates:
      - id: string
        ssids:
          - string
    ssidDetails:
      - anchorGroupName: string
        dot11beProfileId: string
        enableFabric: true
        flexConnect:
          enableFlexConnect: true
          localToVlan: 0
        interfaceName: string
        policyProfileName: string
        ssidName: string
        vlanGroupName: string
        wlanProfileName: string
    wirelessProfileName: string
- name: Update by id
  cisco.dnac.wireless_profiles:
    dnac_host: "{{dnac_host}}"
    dnac_username: "{{dnac_username}}"
    dnac_password: "{{dnac_password}}"
    dnac_verify: "{{dnac_verify}}"
    dnac_port: "{{dnac_port}}"
    dnac_version: "{{dnac_version}}"
    dnac_debug: "{{dnac_debug}}"
    state: present
    additionalInterfaces:
      - string
    apZones:
      - apZoneName: string
        rfProfileName: string
        ssids:
          - string
    featureTemplates:
      - id: string
        ssids:
          - string
    id: string
    ssidDetails:
      - anchorGroupName: string
        dot11beProfileId: string
        enableFabric: true
        flexConnect:
          enableFlexConnect: true
          localToVlan: 0
        interfaceName: string
        policyProfileName: string
        ssidName: string
        vlanGroupName: string
        wlanProfileName: string
    wirelessProfileName: string
- name: Delete by id
  cisco.dnac.wireless_profiles:
    dnac_host: "{{dnac_host}}"
    dnac_username: "{{dnac_username}}"
    dnac_password: "{{dnac_password}}"
    dnac_verify: "{{dnac_verify}}"
    dnac_port: "{{dnac_port}}"
    dnac_version: "{{dnac_version}}"
    dnac_debug: "{{dnac_debug}}"
    state: absent
    id: string
"""
RETURN = r"""
dnac_response:
  description: A dictionary or list with the response returned by the Cisco DNAC Python SDK
  returned: always
  type: dict
  sample: >
    {
      "response": {
        "taskId": "string",
        "url": "string"
      },
      "version": "string"
    }
"""
