/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.configuration;

import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.tinylog.Level;
import org.tinylog.provider.InternalLogger;

final class InitialContextWrapper {
    private InitialContextWrapper() {
    }

    static String resolve(String name) {
        try {
            Object value = InitialContext.doLookup(name);
            return value == null ? null : value.toString();
        }
        catch (NameNotFoundException ex) {
            return null;
        }
        catch (NamingException ex) {
            InternalLogger.log(Level.ERROR, ex, "Failed to look up \"" + name + "\"");
            return null;
        }
    }
}

