/*
 * Decompiled with CFR 0.152.
 */
package net.harawata.appdirs.impl;

import net.harawata.appdirs.AppDirs;
import net.harawata.appdirs.impl.WindowsFolderResolver;

public class WindowsAppDirs
extends AppDirs {
    private WindowsFolderResolver folderResolver;

    public WindowsAppDirs(WindowsFolderResolver folderResolver) {
        this.folderResolver = folderResolver;
    }

    @Override
    public String getUserDataDir(String appName, String appVersion, String appAuthor, boolean roaming) {
        String dir = roaming ? this.getAppData() : this.getLocalAppData();
        return this.buildPath(dir, appAuthor, appName, appVersion);
    }

    @Override
    public String getUserConfigDir(String appName, String appVersion, String appAuthor, boolean roaming) {
        return this.getUserDataDir(appName, appVersion, appAuthor, roaming);
    }

    @Override
    public String getUserCacheDir(String appName, String appVersion, String appAuthor) {
        return this.buildPath(this.getLocalAppData(), appAuthor, appName, "\\Cache", appVersion);
    }

    @Override
    public String getSiteDataDir(String appName, String appVersion, String appAuthor, boolean multiPath) {
        return this.buildPath(this.getCommonAppData(), appAuthor, appName, appVersion);
    }

    @Override
    public String getSiteConfigDir(String appName, String appVersion, String appAuthor, boolean multiPath) {
        return this.getSiteDataDir(appName, appVersion, appAuthor, multiPath);
    }

    @Override
    public String getUserLogDir(String appName, String appVersion, String appAuthor) {
        return this.buildPath(this.getLocalAppData(), appAuthor, appName, "\\Logs", appVersion);
    }

    @Override
    public String getUserDownloadsDir(String appName, String appVersion, String appAuthor) {
        return this.buildPath(this.getDownloads(), appAuthor, appName, appVersion);
    }

    @Override
    public String getSharedDir(String appName, String appVersion, String appAuthor) {
        return this.buildPath(this.getCommonAppData(), appAuthor, appName, appVersion);
    }

    protected String getAppData() {
        return this.folderResolver.resolveFolder(FolderId.APPDATA);
    }

    protected String getLocalAppData() {
        return this.folderResolver.resolveFolder(FolderId.LOCAL_APPDATA);
    }

    protected String getCommonAppData() {
        return this.folderResolver.resolveFolder(FolderId.COMMON_APPDATA);
    }

    protected String getDownloads() {
        return this.folderResolver.resolveFolder(FolderId.DOWNLOADS);
    }

    public static enum FolderId {
        APPDATA,
        LOCAL_APPDATA,
        COMMON_APPDATA,
        DOWNLOADS;

    }
}

