/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.IndexRange;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Observable;
import org.reactfx.Subscription;
import org.reactfx.collection.ChangeListenerWrapper;
import org.reactfx.collection.ChangeObserverWrapper;
import org.reactfx.collection.DynamicallyMappedList;
import org.reactfx.collection.InvalidationListenerWrapper;
import org.reactfx.collection.ListChange;
import org.reactfx.collection.ListModification;
import org.reactfx.collection.ListModificationSequence;
import org.reactfx.collection.ListRangeReduction;
import org.reactfx.collection.ListReduction;
import org.reactfx.collection.MappedList;
import org.reactfx.collection.MemoizationList;
import org.reactfx.collection.MemoizationListImpl;
import org.reactfx.collection.ModificationObserverWrapper;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.collection.QuasiListModification;
import org.reactfx.collection.SuspendableList;
import org.reactfx.collection.SuspendableListWrapper;
import org.reactfx.collection.ValAsList;
import org.reactfx.util.AccumulatorSize;
import org.reactfx.util.Experimental;
import org.reactfx.value.Val;

public interface LiveList<E>
extends ObservableList<E>,
Observable<Observer<? super E, ?>> {
    default public void addQuasiChangeObserver(QuasiChangeObserver<? super E> observer) {
        this.addObserver(observer);
    }

    default public void removeQuasiChangeObserver(QuasiChangeObserver<? super E> observer) {
        this.removeObserver(observer);
    }

    default public void addQuasiModificationObserver(QuasiModificationObserver<? super E> observer) {
        this.addObserver(observer);
    }

    default public void removeQuasiModificationObserver(QuasiModificationObserver<? super E> observer) {
        this.removeObserver(observer);
    }

    default public void addChangeObserver(Consumer<? super ListChange<? extends E>> observer) {
        this.addQuasiChangeObserver(new ChangeObserverWrapper(this, observer));
    }

    default public void removeChangeObserver(Consumer<? super ListChange<? extends E>> observer) {
        this.removeQuasiChangeObserver(new ChangeObserverWrapper(this, observer));
    }

    default public void addModificationObserver(Consumer<? super ListModification<? extends E>> observer) {
        this.addQuasiModificationObserver(new ModificationObserverWrapper(this, observer));
    }

    default public void removeModificationObserver(Consumer<? super ListModification<? extends E>> observer) {
        this.removeQuasiModificationObserver(new ModificationObserverWrapper(this, observer));
    }

    default public Subscription observeQuasiChanges(QuasiChangeObserver<? super E> observer) {
        this.addQuasiChangeObserver(observer);
        return () -> this.removeQuasiChangeObserver(observer);
    }

    default public Subscription observeQuasiModifications(QuasiModificationObserver<? super E> observer) {
        this.addQuasiModificationObserver(observer);
        return () -> this.removeQuasiModificationObserver(observer);
    }

    default public Subscription observeChanges(Consumer<? super ListChange<? extends E>> observer) {
        this.addChangeObserver(observer);
        return () -> this.removeChangeObserver(observer);
    }

    default public Subscription observeModifications(Consumer<? super ListModification<? extends E>> observer) {
        this.addModificationObserver(observer);
        return () -> this.removeModificationObserver(observer);
    }

    default public void addListener(ListChangeListener<? super E> listener) {
        this.addQuasiChangeObserver(new ChangeListenerWrapper<E>(this, listener));
    }

    default public void removeListener(ListChangeListener<? super E> listener) {
        this.removeQuasiChangeObserver(new ChangeListenerWrapper<E>(this, listener));
    }

    default public void addListener(InvalidationListener listener) {
        this.addQuasiChangeObserver(new InvalidationListenerWrapper(this, listener));
    }

    default public void removeListener(InvalidationListener listener) {
        this.removeQuasiChangeObserver(new InvalidationListenerWrapper(this, listener));
    }

    default public Subscription pin() {
        return this.observeQuasiChanges(qc -> {});
    }

    default public Val<Integer> sizeProperty() {
        return LiveList.sizeOf(this);
    }

    default public <F> LiveList<F> map(Function<? super E, ? extends F> f) {
        return LiveList.map(this, f);
    }

    default public <F> LiveList<F> mapDynamic(ObservableValue<? extends Function<? super E, ? extends F>> f) {
        return LiveList.mapDynamic(this, f);
    }

    default public SuspendableList<E> suspendable() {
        return LiveList.suspendable(this);
    }

    default public MemoizationList<E> memoize() {
        return LiveList.memoize(this);
    }

    default public Val<E> reduce(BinaryOperator<E> reduction) {
        return LiveList.reduce(this, reduction);
    }

    @Experimental
    default public Val<E> reduceRange(ObservableValue<IndexRange> range, BinaryOperator<E> reduction) {
        return LiveList.reduceRange(this, range, reduction);
    }

    @Experimental
    default public <T> Val<T> collapse(Function<? super List<E>, ? extends T> f) {
        return LiveList.collapse(this, f);
    }

    @Experimental
    default public <T> Val<T> collapseDynamic(ObservableValue<? extends Function<? super List<E>, ? extends T>> f) {
        return LiveList.collapseDynamic(this, f);
    }

    default public EventStream<QuasiListChange<? extends E>> quasiChanges() {
        return new EventStreamBase<QuasiListChange<? extends E>>(){

            @Override
            protected Subscription observeInputs() {
                return LiveList.this.observeQuasiChanges(this::emit);
            }
        };
    }

    default public EventStream<ListChange<? extends E>> changes() {
        return this.quasiChanges().map((? super T qc) -> QuasiListChange.instantiate(qc, this));
    }

    default public EventStream<QuasiListModification<? extends E>> quasiModifications() {
        return new EventStreamBase<QuasiListModification<? extends E>>(){

            @Override
            protected Subscription observeInputs() {
                return LiveList.this.observeQuasiModifications(this::emit);
            }
        };
    }

    default public EventStream<ListModification<? extends E>> modifications() {
        return this.quasiModifications().map((? super T qm) -> QuasiListModification.instantiate(qm, this));
    }

    public static <E> Subscription observeQuasiChanges(ObservableList<? extends E> list, QuasiChangeObserver<? super E> observer) {
        if (list instanceof LiveList) {
            LiveList lst = (LiveList)list;
            return lst.observeQuasiChanges(observer);
        }
        ListChangeListener listener = ch -> {
            QuasiListChange change = QuasiListChange.from(ch);
            observer.onChange(change);
        };
        list.addListener(listener);
        return () -> list.removeListener(listener);
    }

    public static <E> Subscription observeChanges(ObservableList<E> list, Consumer<? super ListChange<? extends E>> observer) {
        return LiveList.observeQuasiChanges(list, qc -> observer.accept(QuasiListChange.instantiate(qc, list)));
    }

    public static <E> EventStream<QuasiListChange<? extends E>> quasiChangesOf(final ObservableList<E> list) {
        if (list instanceof LiveList) {
            LiveList lst = (LiveList)list;
            return lst.quasiChanges();
        }
        return new EventStreamBase<QuasiListChange<? extends E>>(){

            @Override
            protected Subscription observeInputs() {
                return LiveList.observeQuasiChanges(list, this::emit);
            }
        };
    }

    public static <E> EventStream<ListChange<? extends E>> changesOf(ObservableList<E> list) {
        return LiveList.quasiChangesOf(list).map((? super T qc) -> QuasiListChange.instantiate(qc, list));
    }

    public static Val<Integer> sizeOf(ObservableList<?> list) {
        return Val.create(() -> list.size(), new javafx.beans.Observable[]{list});
    }

    public static <E, F> LiveList<F> map(ObservableList<? extends E> list, Function<? super E, ? extends F> f) {
        return new MappedList<E, F>(list, f);
    }

    public static <E, F> LiveList<F> mapDynamic(ObservableList<? extends E> list, ObservableValue<? extends Function<? super E, ? extends F>> f) {
        return new DynamicallyMappedList(list, f);
    }

    public static <E> SuspendableList<E> suspendable(ObservableList<E> list) {
        if (list instanceof SuspendableList) {
            return (SuspendableList)list;
        }
        return new SuspendableListWrapper<E>(list);
    }

    public static <E> MemoizationList<E> memoize(ObservableList<E> list) {
        if (list instanceof MemoizationList) {
            return (MemoizationList)list;
        }
        return new MemoizationListImpl<E>(list);
    }

    public static <E> Val<E> reduce(ObservableList<E> list, BinaryOperator<E> reduction) {
        return new ListReduction<E>(list, reduction);
    }

    @Experimental
    public static <E> Val<E> reduceRange(ObservableList<E> list, ObservableValue<IndexRange> range, BinaryOperator<E> reduction) {
        return new ListRangeReduction<E>(list, range, reduction);
    }

    @Experimental
    public static <E, T> Val<T> collapse(ObservableList<? extends E> list, Function<? super List<E>, ? extends T> f) {
        return Val.create(() -> f.apply(Collections.unmodifiableList(list)), new javafx.beans.Observable[]{list});
    }

    @Experimental
    public static <E, T> Val<T> collapseDynamic(ObservableList<? extends E> list, ObservableValue<? extends Function<? super List<E>, ? extends T>> f) {
        return Val.create(() -> ((Function)f.getValue()).apply(Collections.unmodifiableList(list)), new javafx.beans.Observable[]{list, f});
    }

    public static <E> LiveList<E> wrapVal(ObservableValue<E> obs) {
        return new ValAsList<E>(obs);
    }

    @FunctionalInterface
    public static interface QuasiModificationObserver<E>
    extends Observer<E, QuasiListModification<? extends E>> {
        @Override
        default public AccumulatorSize sizeOf(ListModificationSequence<? extends E> mods) {
            return AccumulatorSize.fromInt(mods.getModificationCount());
        }

        @Override
        default public QuasiListModification<? extends E> headOf(ListModificationSequence<? extends E> mods) {
            return (QuasiListModification)mods.getModifications().get(0);
        }

        @Override
        default public <F extends E> ListModificationSequence<F> tailOf(ListModificationSequence<F> mods) {
            return mods.asListChangeAccumulator().drop(1);
        }
    }

    @FunctionalInterface
    public static interface QuasiChangeObserver<E>
    extends Observer<E, QuasiListChange<? extends E>> {
        @Override
        default public AccumulatorSize sizeOf(ListModificationSequence<? extends E> mods) {
            return AccumulatorSize.ONE;
        }

        @Override
        default public QuasiListChange<? extends E> headOf(ListModificationSequence<? extends E> mods) {
            return mods.asListChange();
        }

        @Override
        default public <F extends E> ListModificationSequence<F> tailOf(ListModificationSequence<F> mods) {
            throw new NoSuchElementException();
        }
    }

    public static interface Observer<E, O> {
        public AccumulatorSize sizeOf(ListModificationSequence<? extends E> var1);

        public O headOf(ListModificationSequence<? extends E> var1);

        public <F extends E> ListModificationSequence<F> tailOf(ListModificationSequence<F> var1);

        public void onChange(O var1);
    }
}

