/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.jlink.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import org.beryx.jlink.util.SourceCodeRunner;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class JavaVersion
implements GroovyObject {
    private static final Logger LOGGER;
    private static final String sourceCode = "\nimport java.lang.reflect.Method;\n\npublic class JavaVersion {\n    public static void main(String[] args) {\n        System.out.print(getVersion());\n    }\n\n    public static int getVersion() {\n        try {\n            Method mVersion = Runtime.class.getMethod(\"version\");\n            Object version = mVersion.invoke(null);\n            try {\n                Method mFeature = version.getClass().getMethod(\"feature\");\n                return (int)mFeature.invoke(version);\n            } catch (Exception e) {\n                Method mMajor = version.getClass().getMethod(\"major\");\n                return (int)mMajor.invoke(version);\n            }\n        } catch (Exception e) {\n            try {\n                String prop = System.getProperty(\"java.specification.version\");\n                int pos = prop.lastIndexOf('.');\n                return Integer.parseInt(prop.substring(pos + 1));\n            } catch (Exception e1) {\n                return 8;\n            }\n        }\n    }\n}\n";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public JavaVersion() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static int get(String javaHome) {
        SourceCodeRunner runner = new SourceCodeRunner(javaHome, "JavaVersion", sourceCode);
        String javaOutput = runner.getOutput(new String[0]);
        LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{javaHome, javaOutput}, new String[]{"javaVersion(", "): ", ""})));
        int n = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)javaOutput, Integer.TYPE));
        try {
            return n;
        }
        catch (Exception e) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{javaOutput}, new String[]{"Cannot parse java version: ", ""})));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JavaVersion.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        LOGGER = logger = Logging.getLogger(JavaVersion.class);
    }

    @Generated
    public static String getSourceCode() {
        return sourceCode;
    }
}

