/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.scene.control.ComboBoxBase;

public class CustomComboBox<T>
extends ComboBoxBase<T> {
    private static final ButtonDisplay DEFAULT_BUTTON_DISPLAY = ButtonDisplay.RIGHT;
    private static final PseudoClass PSEUDO_CLASS_LEFT = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass PSEUDO_CLASS_RIGHT = PseudoClass.getPseudoClass((String)"right");
    private static final PseudoClass PSEUDO_CLASS_BUTTON_ONLY = PseudoClass.getPseudoClass((String)"button-only");
    private static final PseudoClass PSEUDO_CLASS_FIELD_ONLY = PseudoClass.getPseudoClass((String)"field-only");
    private ObjectProperty<ButtonDisplay> buttonDisplay;

    public CustomComboBox() {
        this.pseudoClassStateChanged(PSEUDO_CLASS_RIGHT, true);
    }

    public final ObjectProperty<ButtonDisplay> buttonDisplayProperty() {
        if (this.buttonDisplay == null) {
            this.buttonDisplay = new StyleableObjectProperty<ButtonDisplay>(DEFAULT_BUTTON_DISPLAY){

                protected void invalidated() {
                    ButtonDisplay value = (ButtonDisplay)((Object)this.get());
                    CustomComboBox.this.pseudoClassStateChanged(PSEUDO_CLASS_LEFT, value == ButtonDisplay.LEFT);
                    CustomComboBox.this.pseudoClassStateChanged(PSEUDO_CLASS_RIGHT, value == ButtonDisplay.RIGHT);
                    CustomComboBox.this.pseudoClassStateChanged(PSEUDO_CLASS_BUTTON_ONLY, value == ButtonDisplay.BUTTON_ONLY);
                    CustomComboBox.this.pseudoClassStateChanged(PSEUDO_CLASS_FIELD_ONLY, value == ButtonDisplay.FIELD_ONLY);
                }

                public CssMetaData<CustomComboBox, ButtonDisplay> getCssMetaData() {
                    return StyleableProperties.BUTTON_DISPLAY;
                }

                public Object getBean() {
                    return CustomComboBox.this;
                }

                public String getName() {
                    return "buttonDisplay";
                }
            };
        }
        return this.buttonDisplay;
    }

    public final void setButtonDisplay(ButtonDisplay value) {
        this.buttonDisplayProperty().setValue((Object)value);
    }

    public final ButtonDisplay getButtonDisplay() {
        return this.buttonDisplay == null ? DEFAULT_BUTTON_DISPLAY : (ButtonDisplay)((Object)this.buttonDisplay.getValue());
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return CustomComboBox.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public static enum ButtonDisplay {
        LEFT,
        RIGHT,
        BUTTON_ONLY,
        FIELD_ONLY;

    }

    private static class StyleableProperties {
        private static final CssMetaData<CustomComboBox, ButtonDisplay> BUTTON_DISPLAY = new CssMetaData<CustomComboBox, ButtonDisplay>("-fx-button-display", (StyleConverter)new EnumConverter(ButtonDisplay.class), DEFAULT_BUTTON_DISPLAY){

            public boolean isSettable(CustomComboBox styleable) {
                return styleable.buttonDisplay == null || !styleable.buttonDisplay.isBound();
            }

            public StyleableProperty<ButtonDisplay> getStyleableProperty(CustomComboBox styleable) {
                return (StyleableProperty)styleable.buttonDisplayProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(ComboBoxBase.getClassCssMetaData());
            Collections.addAll(styleables, BUTTON_DISPLAY);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

