/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.YearMonthView;
import com.dlsc.gemsfx.YearView;
import com.dlsc.gemsfx.skins.CalendarViewSkin;
import com.dlsc.gemsfx.skins.DateCellSkin;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Pos;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.util.Callback;

public class CalendarView
extends Control {
    private static final YearDisplayMode DEFAULT_YEAR_DISPLAY_MODE = YearDisplayMode.TEXT_ONLY;
    private static final MonthDisplayMode DEFAULT_MONTH_DISPLAY_MODE = MonthDisplayMode.TEXT_ONLY;
    private YearMonthView yearMonthView;
    private YearView yearView;
    private final ObjectProperty<YearMonth> yearMonth = new SimpleObjectProperty((Object)this, "yearMonth", (Object)YearMonth.now());
    private final ObservableSet<DayOfWeek> weekendDays = FXCollections.observableSet((Object[])new DayOfWeek[0]);
    private final BooleanProperty showWeekNumbers = new SimpleBooleanProperty((Object)this, "showWeekNumbers");
    private final BooleanProperty markSelectedDaysOfPreviousOrNextMonth = new SimpleBooleanProperty((Object)this, "markSelectedDaysOfPreviousOrNextMonth", true);
    private final BooleanProperty showDaysOfPreviousOrNextMonth = new SimpleBooleanProperty((Object)this, "showDaysOfPreviousOrNextMonth", true);
    private final BooleanProperty showToday = new SimpleBooleanProperty((Object)this, "showToday", true);
    private final ObjectProperty<LocalDate> today = new SimpleObjectProperty((Object)this, "today", (Object)LocalDate.now());
    private final BooleanProperty disablePreviousMonthButton = new SimpleBooleanProperty((Object)this, "disablePreviousMonth");
    private final BooleanProperty disableNextMonthButton = new SimpleBooleanProperty((Object)this, "disablePreviousMonth");
    private final BooleanProperty disableNextYearButton = new SimpleBooleanProperty((Object)this, "disableNextYearButton");
    private final BooleanProperty disablePreviousYearButton = new SimpleBooleanProperty((Object)this, "disablePreviousYearButton");
    public final BooleanProperty disableMonthDropdownButton = new SimpleBooleanProperty((Object)this, "disableMonthDropdownButton", false);
    public final BooleanProperty disableYearDropdownButton = new SimpleBooleanProperty((Object)this, "disableYearDropdownButton", false);
    private final ObjectProperty<Callback<LocalDate, Boolean>> dateFilter = new SimpleObjectProperty((Object)this, "dateFilter");
    private final ObjectProperty<Callback<CalendarView, DateCell>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
    private final BooleanProperty monthSelectionViewEnabled = new SimpleBooleanProperty((Object)this, "monthSelectionViewEnabled", true);
    private final BooleanProperty yearSelectionViewEnabled = new SimpleBooleanProperty((Object)this, "yearSelectionViewEnabled", true);
    private final BooleanProperty showMonth = new SimpleBooleanProperty((Object)this, "showMonth", true);
    private final BooleanProperty showYear = new SimpleBooleanProperty((Object)this, "showYear", true);
    private final BooleanProperty showTodayButton = new SimpleBooleanProperty((Object)this, "showTodayButton");
    private final BooleanProperty showMonthArrows = new SimpleBooleanProperty((Object)this, "showMonthArrows", true);
    private final ObjectProperty<SelectionModel> selectionModel = new SimpleObjectProperty((Object)this, "selectionModel", (Object)new SelectionModel());
    private final DoubleProperty weekNumberColumnWidth = new SimpleDoubleProperty((Object)this, "weekNumberColumnWidth", 16.0);
    private final ObjectProperty<HeaderLayout> headerLayout = new SimpleObjectProperty((Object)this, "headerLayout", (Object)HeaderLayout.CENTER);
    private final StringProperty todayText = new SimpleStringProperty((Object)this, "todayText", "Today");
    private final ObjectProperty<LocalDate> earliestDate = new SimpleObjectProperty((Object)this, "earliestDay");
    private final ObjectProperty<LocalDate> latestDate = new SimpleObjectProperty((Object)this, "latestDate");
    private ObjectProperty<YearDisplayMode> yearDisplayMode;
    private ObjectProperty<MonthDisplayMode> monthDisplayMode;

    public CalendarView() {
        this.getStyleClass().add((Object)"calendar-view");
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, evt -> this.requestFocus());
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, evt -> this.requestFocus());
        this.setFocusTraversable(true);
        this.setCellFactory((Callback<CalendarView, DateCell>)((Callback)view -> new DateCell()));
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    protected Skin<?> createDefaultSkin() {
        return new CalendarViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(CalendarView.class.getResource("calendar-view.css")).toExternalForm();
    }

    public YearMonthView getYearMonthView() {
        if (this.yearMonthView == null) {
            this.yearMonthView = new YearMonthView();
        }
        return this.yearMonthView;
    }

    public YearView getYearView() {
        if (this.yearView == null) {
            this.yearView = new YearView();
        }
        return this.yearView;
    }

    public final ObjectProperty<YearMonth> yearMonthProperty() {
        return this.yearMonth;
    }

    public final YearMonth getYearMonth() {
        return (YearMonth)this.yearMonth.get();
    }

    public void setYearMonth(YearMonth yearMonth) {
        this.yearMonth.set((Object)yearMonth);
    }

    public ObservableSet<DayOfWeek> getWeekendDays() {
        return this.weekendDays;
    }

    public final BooleanProperty showWeekNumbersProperty() {
        return this.showWeekNumbers;
    }

    public final void setShowWeekNumbers(boolean show) {
        this.showWeekNumbersProperty().set(show);
    }

    public final boolean isShowWeekNumbers() {
        return this.showWeekNumbersProperty().get();
    }

    public final boolean isMarkSelectedDaysOfPreviousOrNextMonth() {
        return this.markSelectedDaysOfPreviousOrNextMonth.get();
    }

    public final BooleanProperty markSelectedDaysOfPreviousOrNextMonthProperty() {
        return this.markSelectedDaysOfPreviousOrNextMonth;
    }

    public final void setMarkSelectedDaysOfPreviousOrNextMonth(boolean markSelectedDaysOfPreviousOrNextMonth) {
        this.markSelectedDaysOfPreviousOrNextMonth.set(markSelectedDaysOfPreviousOrNextMonth);
    }

    public final boolean isShowDaysOfPreviousOrNextMonth() {
        return this.showDaysOfPreviousOrNextMonth.get();
    }

    public final BooleanProperty showDaysOfPreviousOrNextMonthProperty() {
        return this.showDaysOfPreviousOrNextMonth;
    }

    public final void setShowDaysOfPreviousOrNextMonth(boolean showDaysOfPreviousOrNextMonth) {
        this.showDaysOfPreviousOrNextMonth.set(showDaysOfPreviousOrNextMonth);
    }

    public final ObjectProperty<LocalDate> todayProperty() {
        return this.today;
    }

    public final void setToday(LocalDate date) {
        Objects.requireNonNull(date);
        this.todayProperty().set((Object)date);
    }

    public final LocalDate getToday() {
        return (LocalDate)this.todayProperty().get();
    }

    public final BooleanProperty showTodayProperty() {
        return this.showToday;
    }

    public final boolean isShowToday() {
        return this.showTodayProperty().get();
    }

    public final void setShowToday(boolean show) {
        this.showTodayProperty().set(show);
    }

    public final boolean isDisablePreviousMonthButton() {
        return this.disablePreviousMonthButton.get();
    }

    public final BooleanProperty disablePreviousMonthButtonProperty() {
        return this.disablePreviousMonthButton;
    }

    public final void setDisablePreviousMonthButton(boolean disablePreviousMonthButton) {
        this.disablePreviousMonthButton.set(disablePreviousMonthButton);
    }

    public final boolean isDisableNextMonthButton() {
        return this.disableNextMonthButton.get();
    }

    public final BooleanProperty disableNextMonthButtonProperty() {
        return this.disableNextMonthButton;
    }

    public final void setDisableNextMonthButton(boolean disableNextMonthButton) {
        this.disableNextMonthButton.set(disableNextMonthButton);
    }

    public final boolean isDisableNextYearButton() {
        return this.disableNextYearButton.get();
    }

    public final BooleanProperty disableNextYearButtonProperty() {
        return this.disableNextYearButton;
    }

    public final void setDisableNextYearButton(boolean disableNextYearButton) {
        this.disableNextYearButton.set(disableNextYearButton);
    }

    public final boolean isDisablePreviousYearButton() {
        return this.disablePreviousYearButton.get();
    }

    public final BooleanProperty disablePreviousYearButtonProperty() {
        return this.disablePreviousYearButton;
    }

    public final void setDisablePreviousYearButton(boolean disablePreviousYearButton) {
        this.disablePreviousYearButton.set(disablePreviousYearButton);
    }

    public final boolean isDisableMonthDropdownButton() {
        return this.disableMonthDropdownButton.get();
    }

    public final BooleanProperty disableMonthDropdownButtonProperty() {
        return this.disableMonthDropdownButton;
    }

    public final void setDisableMonthDropdownButton(boolean disableMonthDropdownButton) {
        this.disableMonthDropdownButton.set(disableMonthDropdownButton);
    }

    public final boolean isDisableYearDropdownButton() {
        return this.disableYearDropdownButton.get();
    }

    public final BooleanProperty disableYearDropdownButtonProperty() {
        return this.disableYearDropdownButton;
    }

    public final void setDisableYearDropdownButton(boolean disableYearDropdownButton) {
        this.disableYearDropdownButton.set(disableYearDropdownButton);
    }

    public final Callback<LocalDate, Boolean> getDateFilter() {
        return (Callback)this.dateFilter.get();
    }

    public final ObjectProperty<Callback<LocalDate, Boolean>> dateFilterProperty() {
        return this.dateFilter;
    }

    public final void setDateFilter(Callback<LocalDate, Boolean> dateFilter) {
        this.dateFilter.set(dateFilter);
    }

    public final ObjectProperty<Callback<CalendarView, DateCell>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final void setCellFactory(Callback<CalendarView, DateCell> factory) {
        Objects.requireNonNull(factory);
        this.cellFactoryProperty().set(factory);
    }

    public final Callback<CalendarView, DateCell> getCellFactory() {
        return (Callback)this.cellFactoryProperty().get();
    }

    public final boolean isMonthSelectionViewEnabled() {
        return this.monthSelectionViewEnabled.get();
    }

    public final BooleanProperty monthSelectionViewEnabledProperty() {
        return this.monthSelectionViewEnabled;
    }

    public final boolean isYearSelectionViewEnabled() {
        return this.yearSelectionViewEnabled.get();
    }

    public final BooleanProperty yearSelectionViewEnabledProperty() {
        return this.yearSelectionViewEnabled;
    }

    public final void setYearSelectionViewEnabled(boolean yearSelectionViewEnabled) {
        this.yearSelectionViewEnabled.set(yearSelectionViewEnabled);
    }

    public final void setMonthSelectionViewEnabled(boolean monthSelectionViewEnabled) {
        this.monthSelectionViewEnabled.set(monthSelectionViewEnabled);
    }

    public boolean isShowMonth() {
        return this.showMonth.get();
    }

    public BooleanProperty showMonthProperty() {
        return this.showMonth;
    }

    public void setShowMonth(boolean showMonth) {
        this.showMonth.set(showMonth);
    }

    public final boolean isShowYear() {
        return this.showYear.get();
    }

    public final BooleanProperty showYearProperty() {
        return this.showYear;
    }

    public final void setShowYear(boolean showYear) {
        this.showYear.set(showYear);
    }

    public final BooleanProperty showTodayButtonProperty() {
        return this.showTodayButton;
    }

    public final void setShowTodayButton(boolean show) {
        this.showTodayButtonProperty().set(show);
    }

    public final boolean isShowTodayButton() {
        return this.showTodayButtonProperty().get();
    }

    public final BooleanProperty showMonthArrowsProperty() {
        return this.showMonthArrows;
    }

    public final void setShowMonthArrows(boolean show) {
        this.showMonthArrowsProperty().set(show);
    }

    public final boolean isShowMonthArrows() {
        return this.showMonthArrowsProperty().get();
    }

    public final SelectionModel getSelectionModel() {
        return (SelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<SelectionModel> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setSelectionModel(SelectionModel selectionModel) {
        this.selectionModel.set((Object)selectionModel);
    }

    public final double getWeekNumberColumnWidth() {
        return this.weekNumberColumnWidth.get();
    }

    public final DoubleProperty weekNumberColumnWidthProperty() {
        return this.weekNumberColumnWidth;
    }

    public final void setWeekNumberColumnWidth(double weekNumberColumnWidth) {
        this.weekNumberColumnWidth.set(weekNumberColumnWidth);
    }

    public final HeaderLayout getHeaderLayout() {
        return (HeaderLayout)((Object)this.headerLayout.get());
    }

    public final ObjectProperty<HeaderLayout> headerLayoutProperty() {
        return this.headerLayout;
    }

    public final void setHeaderLayout(HeaderLayout headerLayout) {
        this.headerLayout.set((Object)headerLayout);
    }

    public final String getTodayText() {
        return (String)this.todayText.get();
    }

    public final StringProperty todayTextProperty() {
        return this.todayText;
    }

    public final void setTodayText(String todayText) {
        this.todayText.set((Object)todayText);
    }

    public final LocalDate getEarliestDate() {
        return (LocalDate)this.earliestDate.get();
    }

    public final ObjectProperty<LocalDate> earliestDateProperty() {
        return this.earliestDate;
    }

    public final void setEarliestDate(LocalDate earliestDate) {
        this.earliestDate.set((Object)earliestDate);
    }

    public final LocalDate getLatestDate() {
        return (LocalDate)this.latestDate.get();
    }

    public final ObjectProperty<LocalDate> latestDateProperty() {
        return this.latestDate;
    }

    public final void setLatestDate(LocalDate latestDate) {
        this.latestDate.set((Object)latestDate);
    }

    public final ObjectProperty<YearDisplayMode> yearDisplayModeProperty() {
        if (this.yearDisplayMode == null) {
            this.yearDisplayMode = new StyleableObjectProperty<YearDisplayMode>(DEFAULT_YEAR_DISPLAY_MODE){

                public Object getBean() {
                    return CalendarView.this;
                }

                public String getName() {
                    return "yearDisplayMode";
                }

                public CssMetaData<? extends Styleable, YearDisplayMode> getCssMetaData() {
                    return StyleableProperties.YEAR_DISPLAY_MODE;
                }
            };
        }
        return this.yearDisplayMode;
    }

    public final YearDisplayMode getYearDisplayMode() {
        return this.yearDisplayMode == null ? DEFAULT_YEAR_DISPLAY_MODE : (YearDisplayMode)((Object)this.yearDisplayMode.get());
    }

    public final void setYearDisplayMode(YearDisplayMode yearDisplayMode) {
        this.yearDisplayModeProperty().set((Object)yearDisplayMode);
    }

    public final ObjectProperty<MonthDisplayMode> monthDisplayModeProperty() {
        if (this.monthDisplayMode == null) {
            this.monthDisplayMode = new StyleableObjectProperty<MonthDisplayMode>(DEFAULT_MONTH_DISPLAY_MODE){

                public Object getBean() {
                    return CalendarView.this;
                }

                public String getName() {
                    return "monthDisplayMode";
                }

                public CssMetaData<? extends Styleable, MonthDisplayMode> getCssMetaData() {
                    return StyleableProperties.MONTH_DISPLAY_MODE;
                }
            };
        }
        return this.monthDisplayMode;
    }

    public final MonthDisplayMode getMonthDisplayMode() {
        return this.monthDisplayMode == null ? DEFAULT_MONTH_DISPLAY_MODE : (MonthDisplayMode)((Object)this.monthDisplayMode.get());
    }

    public final void setMonthDisplayMode(MonthDisplayMode monthDisplayMode) {
        this.monthDisplayModeProperty().set((Object)monthDisplayMode);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return CalendarView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public static class SelectionModel {
        private final ObjectProperty<SelectionMode> selectionMode = new SimpleObjectProperty((Object)this, "selectionMode", (Object)SelectionMode.SINGLE_DATE);
        private final ObjectProperty<LocalDate> selectedDate = new SimpleObjectProperty((Object)this, "selectedDate");
        private final ObjectProperty<LocalDate> selectedEndDate = new SimpleObjectProperty((Object)this, "endDate");
        private final ListProperty<LocalDate> selectedDates = new SimpleListProperty((Object)this, "selectedDates", FXCollections.observableArrayList());

        public SelectionModel() {
            this.selectionMode.addListener(it -> this.clearSelection());
        }

        public final void clearSelection() {
            this.setSelectedDate(null);
            this.setSelectedEndDate(null);
            this.getSelectedDates().clear();
        }

        public final SelectionMode getSelectionMode() {
            return (SelectionMode)((Object)this.selectionMode.get());
        }

        public final ObjectProperty<SelectionMode> selectionModeProperty() {
            return this.selectionMode;
        }

        public final void setSelectionMode(SelectionMode selectionMode) {
            this.selectionMode.set((Object)selectionMode);
        }

        public void clearAndSelect(LocalDate date) {
            this.clearSelection();
            this.select(date);
        }

        public void select(LocalDate date) {
            if (date == null) {
                return;
            }
            switch (this.getSelectionMode()) {
                case SINGLE_DATE: {
                    this.setSelectedDate(date);
                    break;
                }
                case MULTIPLE_DATES: {
                    this.getSelectedDates().add((Object)date);
                    break;
                }
                case DATE_RANGE: {
                    if (this.getSelectedDate() == null) {
                        this.setSelectedDate(date);
                        break;
                    }
                    this.setSelectedEndDate(date);
                }
            }
        }

        public void clearSelection(LocalDate date) {
            switch (this.getSelectionMode()) {
                case SINGLE_DATE: {
                    this.clearSelection();
                    break;
                }
                case MULTIPLE_DATES: {
                    this.getSelectedDates().remove((Object)date);
                    break;
                }
                case DATE_RANGE: {
                    if (Objects.equals(this.getSelectedDate(), date)) {
                        this.setSelectedDate(null);
                        break;
                    }
                    if (!Objects.equals(this.getSelectedEndDate(), date)) break;
                    this.setSelectedEndDate(null);
                }
            }
        }

        public boolean isSelected(LocalDate date) {
            if (date == null) {
                return false;
            }
            LocalDate selectedDate = this.getSelectedDate();
            switch (this.getSelectionMode()) {
                case SINGLE_DATE: {
                    return Objects.equals(selectedDate, date);
                }
                case MULTIPLE_DATES: {
                    return this.getSelectedDates().contains((Object)date);
                }
                case DATE_RANGE: {
                    LocalDate selectedEndDate = this.getSelectedEndDate();
                    if (selectedDate == null && selectedEndDate == null) {
                        return false;
                    }
                    if (selectedDate != null && Objects.equals(selectedDate, date)) {
                        return true;
                    }
                    if (selectedDate != null && selectedEndDate != null) {
                        return !date.isBefore(selectedDate) && !date.isAfter(selectedEndDate);
                    }
                    return false;
                }
            }
            return false;
        }

        public final LocalDate getSelectedDate() {
            return (LocalDate)this.selectedDate.get();
        }

        public final ObjectProperty<LocalDate> selectedDateProperty() {
            return this.selectedDate;
        }

        public final void setSelectedDate(LocalDate selectedDate) {
            this.selectedDate.set((Object)selectedDate);
        }

        public final LocalDate getSelectedEndDate() {
            return (LocalDate)this.selectedEndDate.get();
        }

        public final ObjectProperty<LocalDate> selectedEndDateProperty() {
            return this.selectedEndDate;
        }

        public final void setSelectedEndDate(LocalDate selectedEndDate) {
            this.selectedEndDate.set((Object)selectedEndDate);
        }

        public final ObservableList<LocalDate> getSelectedDates() {
            return (ObservableList)this.selectedDates.get();
        }

        public final ListProperty<LocalDate> selectedDatesProperty() {
            return this.selectedDates;
        }

        public final void setSelectedDates(ObservableList<LocalDate> selectedDates) {
            this.selectedDates.set(selectedDates);
        }

        public static enum SelectionMode {
            SINGLE_DATE,
            MULTIPLE_DATES,
            DATE_RANGE;

        }
    }

    public static enum HeaderLayout {
        CENTER,
        LEFT,
        RIGHT;

    }

    public static enum YearDisplayMode {
        TEXT_ONLY,
        TEXT_AND_SPINNER,
        TEXT_AND_DROPDOWN;

    }

    public static enum MonthDisplayMode {
        TEXT_ONLY,
        TEXT_AND_DROPDOWN;

    }

    private static class StyleableProperties {
        private static final CssMetaData<CalendarView, YearDisplayMode> YEAR_DISPLAY_MODE = new CssMetaData<CalendarView, YearDisplayMode>("-fx-year-display-mode", (StyleConverter)new EnumConverter(YearDisplayMode.class), DEFAULT_YEAR_DISPLAY_MODE){

            public boolean isSettable(CalendarView control) {
                return control.yearDisplayMode == null || !control.yearDisplayMode.isBound();
            }

            public StyleableProperty<YearDisplayMode> getStyleableProperty(CalendarView control) {
                return (StyleableProperty)control.yearDisplayModeProperty();
            }
        };
        private static final CssMetaData<CalendarView, MonthDisplayMode> MONTH_DISPLAY_MODE = new CssMetaData<CalendarView, MonthDisplayMode>("-fx-month-display-mode", (StyleConverter)new EnumConverter(MonthDisplayMode.class), DEFAULT_MONTH_DISPLAY_MODE){

            public boolean isSettable(CalendarView control) {
                return control.monthDisplayMode == null || !control.monthDisplayMode.isBound();
            }

            public StyleableProperty<MonthDisplayMode> getStyleableProperty(CalendarView control) {
                return (StyleableProperty)control.monthDisplayModeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, YEAR_DISPLAY_MODE, MONTH_DISPLAY_MODE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static class DateCell
    extends Cell<LocalDate> {
        public DateCell() {
            this.getStyleClass().add((Object)"date-cell");
            this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.setAlignment(Pos.CENTER);
        }

        protected Skin<?> createDefaultSkin() {
            return new DateCellSkin(this);
        }

        public final LocalDate getDate() {
            return (LocalDate)this.getItem();
        }

        public void updateItem(LocalDate date, boolean empty) {
            super.updateItem((Object)date, empty);
            if (date != null) {
                this.setText(Integer.toString(date.getDayOfMonth()));
            }
        }
    }
}

