/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.BeforeAfterViewSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class BeforeAfterView
extends Control {
    private static final Orientation DEFAULT_ORIENTATION = Orientation.HORIZONTAL;
    private static final PseudoClass PSEUDO_CLASS_HORIZONTAL = PseudoClass.getPseudoClass((String)"horizontal");
    private static final PseudoClass PSEUDO_CLASS_VERTICAL = PseudoClass.getPseudoClass((String)"vertical");
    private final DoubleProperty dividerPosition = new SimpleDoubleProperty((Object)this, "dividerPosition", 0.5);
    private final ObjectProperty<Node> before = new SimpleObjectProperty((Object)this, "before", (Object)new Label("Before"){
        {
            this.setPrefSize(600.0, 400.0);
            this.setStyle("-fx-background-color: red;");
        }
    });
    private final ObjectProperty<Node> after = new SimpleObjectProperty((Object)this, "after", (Object)new Label("After"){
        {
            this.setPrefSize(600.0, 400.0);
            this.setStyle("-fx-background-color: green;");
            this.setAlignment(Pos.CENTER_RIGHT);
        }
    });
    private ObjectProperty<Orientation> orientation;

    public BeforeAfterView() {
        this.getStyleClass().add((Object)"before-after-view");
        this.beforeProperty().addListener(it -> {
            Node node = this.getBefore();
            if (node != null) {
                node.setMouseTransparent(true);
            }
        });
        this.afterProperty().addListener(it -> {
            Node node = this.getAfter();
            if (node != null) {
                node.setMouseTransparent(true);
            }
        });
        this.setFocusTraversable(false);
        this.updatePseudoClass();
    }

    private void updatePseudoClass() {
        this.pseudoClassStateChanged(PSEUDO_CLASS_HORIZONTAL, this.getOrientation().equals((Object)Orientation.HORIZONTAL));
        this.pseudoClassStateChanged(PSEUDO_CLASS_VERTICAL, this.getOrientation().equals((Object)Orientation.VERTICAL));
    }

    public BeforeAfterView(Node beforeNode, Node afterNode) {
        this();
        this.setBefore(beforeNode);
        this.setAfter(afterNode);
    }

    public BeforeAfterView(Image beforeImage, Image afterImage) {
        this((Node)new ImageView(beforeImage), (Node)new ImageView(afterImage));
    }

    protected Skin<?> createDefaultSkin() {
        return new BeforeAfterViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(BeforeAfterView.class.getResource("before-after-view.css")).toExternalForm();
    }

    public final double getDividerPosition() {
        return this.dividerPosition.get();
    }

    public final DoubleProperty dividerPositionProperty() {
        return this.dividerPosition;
    }

    public final void setDividerPosition(double dividerPosition) {
        this.dividerPosition.set(dividerPosition);
    }

    public final Node getBefore() {
        return (Node)this.before.get();
    }

    public final ObjectProperty<Node> beforeProperty() {
        return this.before;
    }

    public final void setBefore(Node before) {
        this.before.set((Object)before);
    }

    public final Node getAfter() {
        return (Node)this.after.get();
    }

    public final ObjectProperty<Node> afterProperty() {
        return this.after;
    }

    public final void setAfter(Node after) {
        this.after.set((Object)after);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? DEFAULT_ORIENTATION : (Orientation)this.orientation.get();
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(DEFAULT_ORIENTATION){

                protected void invalidated() {
                    BeforeAfterView.this.updatePseudoClass();
                }

                public Object getBean() {
                    return BeforeAfterView.this;
                }

                public String getName() {
                    return "orientation";
                }

                public CssMetaData<? extends Styleable, Orientation> getCssMetaData() {
                    return StyleableProperties.ORIENTATION;
                }
            };
        }
        return this.orientation;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set((Object)orientation);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return BeforeAfterView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<BeforeAfterView, Orientation> ORIENTATION = new CssMetaData<BeforeAfterView, Orientation>("-fx-orientation", (StyleConverter)new EnumConverter(Orientation.class), DEFAULT_ORIENTATION){

            public boolean isSettable(BeforeAfterView view) {
                return view.orientation == null || !view.orientation.isBound();
            }

            public StyleableProperty<Orientation> getStyleableProperty(BeforeAfterView view) {
                return (StyleableProperty)view.orientationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<BeforeAfterView, Orientation>> styleables = new ArrayList<CssMetaData<BeforeAfterView, Orientation>>(Control.getClassCssMetaData());
            styleables.add(ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

