/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import net.sourceforge.jeuclid.layout.GraphicsObject;

public class TextObject
implements GraphicsObject {
    private final TextLayout layout;
    private final Color color;
    private final float xoffset;
    private final float yoffset;
    private final AffineTransform trans;

    public TextObject(TextLayout textLayout, float f, Color color) {
        assert (textLayout != null);
        this.layout = textLayout;
        this.color = color;
        this.xoffset = f;
        this.yoffset = 0.0f;
        this.trans = null;
    }

    public TextObject(TextLayout textLayout, float f, float f2, AffineTransform affineTransform, Color color) {
        assert (textLayout != null);
        this.layout = textLayout;
        this.color = color;
        this.xoffset = f;
        this.yoffset = f2;
        this.trans = affineTransform;
    }

    @Override
    public void paint(float f, float f2, Graphics2D graphics2D) {
        graphics2D.setColor(this.color);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(f + this.xoffset, f2 + this.yoffset);
        if (this.trans != null) {
            graphics2D.transform(this.trans);
        }
        this.layout.draw(graphics2D, 0.0f, 0.0f);
        graphics2D.setTransform(affineTransform);
    }
}

