/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.util.Arrays;

final class EmptyCollectionHelper {
    EmptyCollectionHelper() {
    }

    static int determineSignatureOffsetDict(byte[] _sigb, int _currentOffset) {
        return EmptyCollectionHelper.determineEndOfBracketStructure(_sigb, _currentOffset, '{', '}');
    }

    static int determineSignatureOffsetArray(byte[] _sigb, int _currentOffset) {
        String sigSubString = EmptyCollectionHelper.determineSubSignature(_sigb, _currentOffset);
        if (sigSubString.isEmpty()) {
            return _currentOffset;
        }
        ECollectionSubType newtype = EmptyCollectionHelper.determineCollectionSubType((char)_sigb[_currentOffset]);
        switch (newtype) {
            case ARRAY: {
                return EmptyCollectionHelper.determineSignatureOffsetArray(_sigb, _currentOffset + 1);
            }
            case DICT: {
                return EmptyCollectionHelper.determineSignatureOffsetDict(_sigb, _currentOffset);
            }
            case STRUCT: {
                return EmptyCollectionHelper.determineSignatureOffsetStruct(_sigb, _currentOffset);
            }
            case PRIMITIVE: {
                return _currentOffset;
            }
        }
        throw new IllegalStateException("Unable to parse signature for empty collection");
    }

    private static int determineSignatureOffsetStruct(byte[] _sigb, int _currentOffset) {
        return EmptyCollectionHelper.determineEndOfBracketStructure(_sigb, _currentOffset, '(', ')');
    }

    private static int determineEndOfBracketStructure(byte[] _sigb, int _currentOffset, char _openChar, char _closeChar) {
        String sigSubString = EmptyCollectionHelper.determineSubSignature(_sigb, _currentOffset);
        if (sigSubString.isEmpty()) {
            return _currentOffset;
        }
        int i = 0;
        int depth = 0;
        for (char chr : sigSubString.toCharArray()) {
            if (chr == _openChar) {
                ++depth;
            } else if (chr == _closeChar) {
                --depth;
            }
            if (depth == 0) {
                return _currentOffset + i;
            }
            ++i;
        }
        throw new IllegalStateException("Unable to parse signature for empty collection");
    }

    private static String determineSubSignature(byte[] _sigb, int _currentOffset) {
        byte[] restSigbytes = Arrays.copyOfRange(_sigb, _currentOffset, _sigb.length);
        return new String(restSigbytes);
    }

    private static ECollectionSubType determineCollectionSubType(char _sig) {
        switch (_sig) {
            case '(': {
                return ECollectionSubType.STRUCT;
            }
            case '{': {
                return ECollectionSubType.DICT;
            }
            case 'a': {
                return ECollectionSubType.ARRAY;
            }
        }
        return ECollectionSubType.PRIMITIVE;
    }

    static enum ECollectionSubType {
        STRUCT,
        DICT,
        ARRAY,
        PRIMITIVE;

    }
}

