/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.CellListManager;
import org.fxmisc.flowless.OrientationHelper;
import org.fxmisc.flowless.SizeTracker;
import org.reactfx.collection.MemoizationList;

final class CellPositioner<T, C extends Cell<T, ?>> {
    private final CellListManager<T, C> cellManager;
    private final OrientationHelper orientation;
    private final SizeTracker sizeTracker;

    public CellPositioner(CellListManager<T, C> cellManager, OrientationHelper orientation, SizeTracker sizeTracker) {
        this.cellManager = cellManager;
        this.orientation = orientation;
        this.sizeTracker = sizeTracker;
    }

    public void cropTo(int from, int to) {
        this.cellManager.cropTo(from, to);
    }

    public C getVisibleCell(int itemIndex) {
        C cell = this.cellManager.getPresentCell(itemIndex);
        if (cell.getNode().isVisible()) {
            return cell;
        }
        throw new NoSuchElementException("Cell " + itemIndex + " is not visible");
    }

    public Optional<C> getCellIfVisible(int itemIndex) {
        return this.cellManager.getCellIfPresent(itemIndex).filter(c -> c.getNode().isVisible());
    }

    public OptionalInt lastVisibleBefore(int position) {
        MemoizationList<C> cells = this.cellManager.getLazyCellList();
        int presentBefore = cells.getMemoizedCountBefore(position);
        for (int i = presentBefore - 1; i >= 0; --i) {
            Cell cell = (Cell)cells.memoizedItems().get(i);
            if (!cell.getNode().isVisible()) continue;
            return OptionalInt.of(cells.indexOfMemoizedItem(i));
        }
        return OptionalInt.empty();
    }

    public OptionalInt firstVisibleAfter(int position) {
        MemoizationList<C> cells = this.cellManager.getLazyCellList();
        int presentBefore = cells.getMemoizedCountBefore(position);
        int present = cells.getMemoizedCount();
        for (int i = presentBefore; i < present; ++i) {
            Cell cell = (Cell)cells.memoizedItems().get(i);
            if (!cell.getNode().isVisible()) continue;
            return OptionalInt.of(cells.indexOfMemoizedItem(i));
        }
        return OptionalInt.empty();
    }

    public OptionalInt getLastVisibleIndex() {
        return this.lastVisibleBefore(this.cellManager.getLazyCellList().size());
    }

    public OptionalInt getFirstVisibleIndex() {
        return this.firstVisibleAfter(0);
    }

    public double shortestDeltaToViewport(C cell) {
        return this.shortestDeltaToViewport(cell, 0.0, this.orientation.length((Cell<?, ?>)cell));
    }

    public double shortestDeltaToViewport(C cell, double fromY, double toY) {
        double cellMinY = this.orientation.minY((Cell<?, ?>)cell);
        double gapBefore = cellMinY + fromY;
        double gapAfter = this.sizeTracker.getViewportLength() - (cellMinY + toY);
        return gapBefore < 0.0 && gapAfter > 0.0 ? Math.min(-gapBefore, gapAfter) : (gapBefore > 0.0 && gapAfter < 0.0 ? Math.max(-gapBefore, gapAfter) : 0.0);
    }

    public void shiftCellBy(C cell, double delta) {
        double y = this.orientation.minY((Cell<?, ?>)cell) + delta;
        this.relocate(cell, 0.0, y);
    }

    public C placeStartAt(int itemIndex, double startOffStart) {
        C cell = this.getSizedCell(itemIndex);
        this.relocate(cell, 0.0, startOffStart);
        cell.getNode().setVisible(true);
        return cell;
    }

    public C placeEndFromStart(int itemIndex, double endOffStart) {
        C cell = this.getSizedCell(itemIndex);
        this.relocate(cell, 0.0, endOffStart - this.orientation.length((Cell<?, ?>)cell));
        cell.getNode().setVisible(true);
        return cell;
    }

    public C placeEndFromEnd(int itemIndex, double endOffEnd) {
        C cell = this.getSizedCell(itemIndex);
        double y = this.sizeTracker.getViewportLength() + endOffEnd - this.orientation.length((Cell<?, ?>)cell);
        this.relocate(cell, 0.0, y);
        cell.getNode().setVisible(true);
        return cell;
    }

    public C placeStartFromEnd(int itemIndex, double startOffEnd) {
        C cell = this.getSizedCell(itemIndex);
        double y = this.sizeTracker.getViewportLength() + startOffEnd;
        this.relocate(cell, 0.0, y);
        cell.getNode().setVisible(true);
        return cell;
    }

    C getSizedCell(int itemIndex) {
        C cell = this.cellManager.getCell(itemIndex);
        double breadth = this.sizeTracker.breadthFor(itemIndex);
        double length = this.sizeTracker.lengthFor(itemIndex);
        this.orientation.resize((Cell<?, ?>)cell, breadth, length);
        return cell;
    }

    private void relocate(C cell, double breadth0, double length0) {
        this.orientation.relocate((Cell<?, ?>)cell, breadth0, length0);
    }
}

